/*
 * Rufus: The Reliable USB Formatting Utility
 * GPT Partition Types
 * Copyright © 2020 Pete Batard <pete@akeo.ie>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <windows.h>
// MinGW won't properly embed the GUIDs unless the following is defined
#define INITGUID
#include <guiddef.h>

#pragma once

/*
 * From https://en.wikipedia.org/wiki/GUID_Partition_Table
 */
DEFINE_GUID(PARTITION_ANDROID_BOOT, 0x49A4D17F, 0x93A3, 0x45C1, 0xA0, 0xDE, 0xF5, 0x0B, 0x2E, 0xBE, 0x25, 0x99);
DEFINE_GUID(PARTITION_ANDROID_BOOTLOADER1, 0x2568845D, 0x2332, 0x4675, 0xBC, 0x39, 0x8F, 0xA5, 0xA4, 0x74, 0x8D, 0x15);
DEFINE_GUID(PARTITION_ANDROID_BOOTLOADER2, 0x114EAFFE, 0x1552, 0x4022, 0xB2, 0x6E, 0x9B, 0x05, 0x36, 0x04, 0xCF, 0x84);
DEFINE_GUID(PARTITION_ANDROID_CACHE, 0xA893EF21, 0xE428, 0x470A, 0x9E, 0x55, 0x06, 0x68, 0xFD, 0x91, 0xA2, 0xD9);
DEFINE_GUID(PARTITION_ANDROID_CONFIG, 0xBD59408B, 0x4514, 0x490D, 0xBF, 0x12, 0x98, 0x78, 0xD9, 0x63, 0xF3, 0x78);
DEFINE_GUID(PARTITION_ANDROID_DATA, 0xDC76DDA9, 0x5AC1, 0x491C, 0xAF, 0x42, 0xA8, 0x25, 0x91, 0x58, 0x0C, 0x0D);
DEFINE_GUID(PARTITION_ANDROID_EXT, 0x193D1EA4, 0xB3CA, 0x11E4, 0xB0, 0x75, 0x10, 0x60, 0x4B, 0x88, 0x9D, 0xCF);
DEFINE_GUID(PARTITION_ANDROID_FACTORY1, 0x8F68CC74, 0xC5E5, 0x48DA, 0xBE, 0x91, 0xA0, 0xC8, 0xC1, 0x5E, 0x9C, 0x80);
DEFINE_GUID(PARTITION_ANDROID_FACTORY2, 0x9FDAA6EF, 0x4B3F, 0x40D2, 0xBA, 0x8D, 0xBF, 0xF1, 0x6B, 0xFB, 0x88, 0x7B);
DEFINE_GUID(PARTITION_ANDROID_FASTBOOT, 0x767941D0, 0x2085, 0x11E3, 0xAD, 0x3B, 0x6C, 0xFD, 0xB9, 0x47, 0x11, 0xE9);
DEFINE_GUID(PARTITION_ANDROID_METADATA1, 0x20AC26BE, 0x20B7, 0x11E3, 0x84, 0xC5, 0x6C, 0xFD, 0xB9, 0x47, 0x11, 0xE9);
DEFINE_GUID(PARTITION_ANDROID_METADATA2, 0x19A710A2, 0xB3CA, 0x11E4, 0xB0, 0x26, 0x10, 0x60, 0x4B, 0x88, 0x9D, 0xCF);
DEFINE_GUID(PARTITION_ANDROID_MISC, 0xEF32A33B, 0xA409, 0x486C, 0x91, 0x41, 0x9F, 0xFB, 0x71, 0x1F, 0x62, 0x66);
DEFINE_GUID(PARTITION_ANDROID_OEM, 0xAC6D7924, 0xEB71, 0x4DF8, 0xB4, 0x8D, 0xE2, 0x67, 0xB2, 0x71, 0x48, 0xFF);
DEFINE_GUID(PARTITION_ANDROID_PERSISTENCE, 0xEBC597D0, 0x2053, 0x4B15, 0x8B, 0x64, 0xE0, 0xAA, 0xC7, 0x5F, 0x4D, 0xB1);
DEFINE_GUID(PARTITION_ANDROID_RECOVERY, 0x4177C722, 0x9E92, 0x4AAB, 0x86, 0x44, 0x43, 0x50, 0x2B, 0xFD, 0x55, 0x06);
DEFINE_GUID(PARTITION_ANDROID_SYSTEM, 0x38F428E6, 0xD326, 0x425D, 0x91, 0x40, 0x6E, 0x0E, 0xA1, 0x33, 0x64, 0x7C);
DEFINE_GUID(PARTITION_ANDROID_VENDOR, 0xC5A0AEEC, 0x13EA, 0x11E5, 0xA1, 0xB1, 0x00, 0x1E, 0x67, 0xCA, 0x0C, 0x3C);
DEFINE_GUID(PARTITION_APPLE_APFS, 0x7C3457EF, 0x0000, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_BOOT, 0x426F6F74, 0x0000, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_FILEVAULT, 0x53746F72, 0x6167, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_HFS, 0x48465300, 0x0000, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_LABEL, 0x4C616265, 0x6C00, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_OFFLINE_RAID, 0x52414944, 0x5F4F, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_RAID, 0x52414944, 0x0000, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_RAID_CACHE, 0xBBBA6DF5, 0xF46F, 0x4A89, 0x8F, 0x59, 0x87, 0x65, 0xB2, 0x72, 0x75, 0x03);
DEFINE_GUID(PARTITION_APPLE_RAID_SCRATCH, 0x2E313465, 0x19B9, 0x463F, 0x81, 0x26, 0x8A, 0x79, 0x93, 0x77, 0x38, 0x01);
DEFINE_GUID(PARTITION_APPLE_RAID_STATUS, 0xB6FA30DA, 0x92D2, 0x4A9A, 0x96, 0xF1, 0x87, 0x1E, 0xC6, 0x48, 0x62, 0x00);
DEFINE_GUID(PARTITION_APPLE_RAID_VOLUME, 0xFA709C7E, 0x65B1, 0x4593, 0xBF, 0xD5, 0xE7, 0x1D, 0x61, 0xDE, 0x9B, 0x02);
DEFINE_GUID(PARTITION_APPLE_RECOVERY, 0x5265636F, 0x7665, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
DEFINE_GUID(PARTITION_APPLE_UFS, 0x55465300, 0x0000, 0x11AA, 0xAA, 0x11, 0x00, 0x30, 0x65, 0x43, 0xEC, 0xAC);
// Stolen from Solaris below. Great job here, Apple! Then again, Oracle can and *should* go to hell, so who cares...
DEFINE_GUID(PARTITION_APPLE_ZFS, 0x6A898CC3, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_ATARI_DATA, 0x734E5AFE, 0xF61A, 0x11E6, 0xBC, 0x64, 0x92, 0x36, 0x1F, 0x00, 0x26, 0x71);
DEFINE_GUID(PARTITION_BEOS_BFS, 0x42465331, 0x3BA3, 0x10F1, 0x80, 0x2A, 0x48, 0x61, 0x69, 0x6B, 0x75, 0x21);
DEFINE_GUID(PARTITION_CHROMEOS_KERNEL, 0xFE3A2A5D, 0x4F32, 0x41A7, 0xB7, 0x25, 0xAC, 0xCC, 0x32, 0x85, 0xA3, 0x09);
DEFINE_GUID(PARTITION_CHROMEOS_RESERVED, 0x2E0A753D, 0x9E48, 0x43B0, 0x83, 0x37, 0xB1, 0x51, 0x92, 0xCB, 0x1B, 0x5E);
DEFINE_GUID(PARTITION_CHROMEOS_ROOT, 0x3CB8E202, 0x3B7E, 0x47DD, 0x8A, 0x3C, 0x7F, 0xF2, 0xA1, 0x3C, 0xFC, 0xEC);
DEFINE_GUID(PARTITION_COREOS_RAID, 0xBE9067B9, 0xEA49, 0x4F15, 0xB4, 0xF6, 0xF3, 0x6F, 0x8C, 0x9E, 0x18, 0x18);
DEFINE_GUID(PARTITION_COREOS_RESERVED, 0xC95DC21A, 0xDF0E, 0x4340, 0x8D, 0x7B, 0x26, 0xCB, 0xFA, 0x9A, 0x03, 0xE0);
DEFINE_GUID(PARTITION_COREOS_ROOT, 0x3884DD41, 0x8582, 0x4404, 0xB9, 0xA8, 0xE9, 0xB8, 0x4F, 0x2D, 0xF5, 0x0E);
DEFINE_GUID(PARTITION_COREOS_USR, 0x5DFBF5F4, 0x2848, 0x4BAC, 0xAA, 0x5E, 0x0D, 0x9A, 0x20, 0xB7, 0x45, 0xA6);
DEFINE_GUID(PARTITION_FREEBSD_BOOT, 0x83BD6B9D, 0x7F41, 0x11DC, 0xBE, 0x0B, 0x00, 0x15, 0x60, 0xB8, 0x4F, 0x0F);
DEFINE_GUID(PARTITION_FREEBSD_DATA, 0x516E7CB4, 0x6ECF, 0x11D6, 0x8F, 0xF8, 0x00, 0x02, 0x2D, 0x09, 0x71, 0x2B);
DEFINE_GUID(PARTITION_FREEBSD_LVM, 0x516E7CB8, 0x6ECF, 0x11D6, 0x8F, 0xF8, 0x00, 0x02, 0x2D, 0x09, 0x71, 0x2B);
DEFINE_GUID(PARTITION_FREEBSD_SWAP, 0x516E7CB5, 0x6ECF, 0x11D6, 0x8F, 0xF8, 0x00, 0x02, 0x2D, 0x09, 0x71, 0x2B);
DEFINE_GUID(PARTITION_FREEBSD_UFS, 0x516E7CB6, 0x6ECF, 0x11D6, 0x8F, 0xF8, 0x00, 0x02, 0x2D, 0x09, 0x71, 0x2B);
DEFINE_GUID(PARTITION_FREEBSD_ZFS, 0x516E7CBA, 0x6ECF, 0x11D6, 0x8F, 0xF8, 0x00, 0x02, 0x2D, 0x09, 0x71, 0x2B);
DEFINE_GUID(PARTITION_GENERIC_BIOS_BOOT, 0x21686148, 0x6449, 0x6E6F, 0x74, 0x4E, 0x65, 0x65, 0x64, 0x45, 0x46, 0x49);
DEFINE_GUID(PARTITION_GENERIC_XBOOTLDR, 0xBC13C2FF, 0x59E6, 0x4262, 0xA3, 0x52, 0xB2, 0x75, 0xFD, 0x6F, 0x71, 0x72);
DEFINE_GUID(PARTITION_GENERIC_ESP, 0xC12A7328, 0xF81F, 0x11D2, 0xBA, 0x4B, 0x00, 0xA0, 0xC9, 0x3E, 0xC9, 0x3B);
DEFINE_GUID(PARTITION_GENERIC_MBR, 0x024DEE41, 0x33E7, 0x11D3, 0x9D, 0x69, 0x00, 0x08, 0xC7, 0x81, 0xF3, 0x9F);
DEFINE_GUID(PARTITION_GENERIC_UNUSED, 0x00000000, 0x0000, 0x0000, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
DEFINE_GUID(PARTITION_HPUX_DATA, 0x75894C1E, 0x3AEB, 0x11D3, 0xB7, 0xC1, 0x7B, 0x03, 0xA0, 0x00, 0x00, 0x00);
DEFINE_GUID(PARTITION_HPUX_SERVICE, 0xE2A1E728, 0x32E3, 0x11D6, 0xA6, 0x82, 0x7B, 0x03, 0xA0, 0x00, 0x00, 0x00);
DEFINE_GUID(PARTITION_IBM_GPFS, 0x37AFFC90, 0xEF7D, 0x4E96, 0x91, 0xC3, 0x2D, 0x7A, 0xE0, 0x55, 0xB1, 0x74);
DEFINE_GUID(PARTITION_INTEL_IFF, 0xD3BFE2DE, 0x3DAF, 0x11DF, 0xBA, 0x40, 0xE3, 0xA5, 0x56, 0xD8, 0x95, 0x93);
DEFINE_GUID(PARTITION_LENOVO_BOOT, 0xBFBFAFE7, 0xA34F, 0x448A, 0x9A, 0x5B, 0x62, 0x13, 0xEB, 0x73, 0x6C, 0x22);
DEFINE_GUID(PARTITION_LINUX_BOOT, 0xBC13C2FF, 0x59E6, 0x4262, 0xA3, 0x52, 0xB2, 0x75, 0xFD, 0x6F, 0x71, 0x72);
DEFINE_GUID(PARTITION_LINUX_DATA, 0x0FC63DAF, 0x8483, 0x4772, 0x8E, 0x79, 0x3D, 0x69, 0xD8, 0x47, 0x7D, 0xE4);
DEFINE_GUID(PARTITION_LINUX_ENCRYPTED, 0x7FFEC5C9, 0x2D00, 0x49B7, 0x89, 0x41, 0x3E, 0xA1, 0x0A, 0x55, 0x86, 0xB7);
DEFINE_GUID(PARTITION_LINUX_HOME, 0x933AC7E1, 0x2EB4, 0x4F13, 0xB8, 0x44, 0x0E, 0x14, 0xE2, 0xAE, 0xF9, 0x15);
DEFINE_GUID(PARTITION_LINUX_LUKS, 0xCA7D7CCB, 0x63ED, 0x4C53, 0x86, 0x1C, 0x17, 0x42, 0x53, 0x60, 0x59, 0xCC);
DEFINE_GUID(PARTITION_LINUX_LVM, 0xE6D6D379, 0xF507, 0x44C2, 0xA2, 0x3C, 0x23, 0x8F, 0x2A, 0x3D, 0xF9, 0x28);
DEFINE_GUID(PARTITION_LINUX_RAID, 0xA19D880F, 0x05FC, 0x4D3B, 0xA0, 0x06, 0x74, 0x3F, 0x0F, 0x84, 0x91, 0x1E);
DEFINE_GUID(PARTITION_LINUX_RESERVED, 0x8DA63339, 0x0007, 0x60C0, 0xC4, 0x36, 0x08, 0x3A, 0xC8, 0x23, 0x09, 0x08);
DEFINE_GUID(PARTITION_LINUX_ROOT_ARM_32, 0x69DAD710, 0x2CE4, 0x4E3C, 0xB1, 0x6C, 0x21, 0xA1, 0xD4, 0x9A, 0xBE, 0xD3);
DEFINE_GUID(PARTITION_LINUX_ROOT_ARM_64, 0xB921B045, 0x1DF0, 0x41C3, 0xAF, 0x44, 0x4C, 0x6F, 0x28, 0x0D, 0x3F, 0xAE);
DEFINE_GUID(PARTITION_LINUX_ROOT_X86_32, 0x44479540, 0xF297, 0x41B2, 0x9A, 0xF7, 0xD1, 0x31, 0xD5, 0xF0, 0x45, 0x8A);
DEFINE_GUID(PARTITION_LINUX_ROOT_X86_64, 0x4F68BCE3, 0xE8CD, 0x4DB1, 0x96, 0xE7, 0xFB, 0xCA, 0xF9, 0x84, 0xB7, 0x09);
DEFINE_GUID(PARTITION_LINUX_SRV, 0x3B8F8425, 0x20E0, 0x4F3B, 0x90, 0x7F, 0x1A, 0x25, 0xA7, 0x6F, 0x98, 0xE8);
DEFINE_GUID(PARTITION_LINUX_SWAP, 0x0657FD6D, 0xA4AB, 0x43C4, 0x84, 0xE5, 0x09, 0x33, 0xC8, 0x4B, 0x4F, 0x4F);
DEFINE_GUID(PARTITION_MICROSOFT_DATA, 0xEBD0A0A2, 0xB9E5, 0x4433, 0x87, 0xC0, 0x68, 0xB6, 0xB7, 0x26, 0x99, 0xC7);
DEFINE_GUID(PARTITION_MICROSOFT_LDM_DATA, 0xAF9B60A0, 0x1431, 0x4F62, 0xBC, 0x68, 0x33, 0x11, 0x71, 0x4A, 0x69, 0xAD);
DEFINE_GUID(PARTITION_MICROSOFT_LDM_META, 0x5808C8AA, 0x7E8F, 0x42E0, 0x85, 0xD2, 0xE1, 0xE9, 0x04, 0x34, 0xCF, 0xB3);
DEFINE_GUID(PARTITION_MICROSOFT_RECOVERY, 0xDE94BBA4, 0x06D1, 0x4D40, 0xA1, 0x6A, 0xBF, 0xD5, 0x01, 0x79, 0xD6, 0xAC);
DEFINE_GUID(PARTITION_MICROSOFT_RESERVED, 0xE3C9E316, 0x0B5C, 0x4DB8, 0x81, 0x7D, 0xF9, 0x2D, 0xF0, 0x02, 0x15, 0xAE);
DEFINE_GUID(PARTITION_MICROSOFT_STORAGE_SPACES, 0xE75CAF8F, 0xF680, 0x4CEE, 0xAF, 0xA3, 0xB0, 0x01, 0xE5, 0x6E, 0xFC, 0x2D);
DEFINE_GUID(PARTITION_NETBSD_CONCAT, 0x2DB519C4, 0xB10F, 0x11DC, 0xB9, 0x9B, 0x00, 0x19, 0xD1, 0x87, 0x96, 0x48);
DEFINE_GUID(PARTITION_NETBSD_ENCRYPTED, 0x2DB519EC, 0xB10F, 0x11DC, 0xB9, 0x9B, 0x00, 0x19, 0xD1, 0x87, 0x96, 0x48);
DEFINE_GUID(PARTITION_NETBSD_FFS, 0x49F48D5A, 0xB10E, 0x11DC, 0xB9, 0x9B, 0x00, 0x19, 0xD1, 0x87, 0x96, 0x48);
DEFINE_GUID(PARTITION_NETBSD_LFS, 0x49F48D82, 0xB10E, 0x11DC, 0xB9, 0x9B, 0x00, 0x19, 0xD1, 0x87, 0x96, 0x48);
DEFINE_GUID(PARTITION_NETBSD_RAID, 0x49F48DAA, 0xB10E, 0x11DC, 0xB9, 0x9B, 0x00, 0x19, 0xD1, 0x87, 0x96, 0x48);
DEFINE_GUID(PARTITION_NETBSD_SWAP, 0x49F48D32, 0xB10E, 0x11DC, 0xB9, 0x9B, 0x00, 0x19, 0xD1, 0x87, 0x96, 0x48);
DEFINE_GUID(PARTITION_OPENBSD_DATA, 0x824CC7A0, 0x36A8, 0x11E3, 0x89, 0x0A, 0x95, 0x25, 0x19, 0xAD, 0x3F, 0x61);
DEFINE_GUID(PARTITION_PLAN9_DATA, 0xC91818F9, 0x8025, 0x47AF, 0x89, 0xD2, 0xF0, 0x30, 0xD7, 0x00, 0x0C, 0x2C);
DEFINE_GUID(PARTITION_PREP_BOOT, 0x9E1A2D38, 0xC612, 0x4316, 0xAA, 0x26, 0x8B, 0x49, 0x52, 0x1E, 0x5A, 0x8B);
DEFINE_GUID(PARTITION_QNX_DATA, 0xCEF5A9AD, 0x73BC, 0x4601, 0x89, 0xF3, 0xCD, 0xEE, 0xEE, 0xE3, 0x21, 0xA1);
DEFINE_GUID(PARTITION_SOLARIS_ALT, 0x6A9283A5, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_BACKUP, 0x6A8B642B, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_BOOT, 0x6A82CB45, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_HOME, 0x6A90BA39, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_RESERVED1, 0x6A945A3B, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_RESERVED2, 0x6A9630D1, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_RESERVED3, 0x6A980767, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_RESERVED4, 0x6A96237F, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_RESERVED5, 0x6A8D2AC7, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
// You sure you don't need a couple more reserved partition GUIDs here, Solaris?
DEFINE_GUID(PARTITION_SOLARIS_ROOT, 0x6A85CF4D, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_SWAP, 0x6A87C46F, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
//DEFINE_GUID(PARTITION_SOLARIS_USR, 0x6A898CC3, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SOLARIS_VAR, 0x6A8EF2E9, 0x1DD2, 0x11B2, 0x99, 0xA6, 0x08, 0x00, 0x20, 0x73, 0x66, 0x31);
DEFINE_GUID(PARTITION_SONY_BOOT, 0xF4019732, 0x066E, 0x4E12, 0x82, 0x73, 0x34, 0x6C, 0x56, 0x41, 0x49, 0x4F);
DEFINE_GUID(PARTITION_VERACRYPT_DATA, 0x8C8F8EFF, 0xAC95, 0x4770, 0x81, 0x4A, 0x21, 0x99, 0x4F, 0x2D, 0xBC, 0x8F);
DEFINE_GUID(PARTITION_VMWARE_COREDUMP, 0x9D275380, 0x40AD, 0x11DB, 0xBF, 0x97, 0x00, 0x0C, 0x29, 0x11, 0xD1, 0xB8);
DEFINE_GUID(PARTITION_VMWARE_RESERVED, 0x9198EFFC, 0x31C0, 0x11DB, 0x8F, 0x78, 0x00, 0x0C, 0x29, 0x11, 0xD1, 0xB8);
DEFINE_GUID(PARTITION_VMWARE_VMFS, 0xAA31E02A, 0x400F, 0x11DB, 0x95, 0x90, 0x00, 0x0C, 0x29, 0x11, 0xD1, 0xB8);

typedef struct {
    const GUID* guid;
    const char* name;
} gpt_type_t;

gpt_type_t gpt_type[] = {
    { &PARTITION_ANDROID_BOOT, "Android Boot Partition" },
    { &PARTITION_ANDROID_BOOTLOADER1, "Android Bootloader Partition" },
    { &PARTITION_ANDROID_BOOTLOADER2, "Android Bootloader Partition" },
    { &PARTITION_ANDROID_CACHE, "Android Cache Partition" },
    { &PARTITION_ANDROID_CONFIG, "Android Config Partition" },
    { &PARTITION_ANDROID_DATA, "Android Data Partition" },
    { &PARTITION_ANDROID_EXT, "Android Ext Partition" },
    { &PARTITION_ANDROID_FACTORY1, "Android Factory Partition" },
    { &PARTITION_ANDROID_FACTORY2, "Android Factory Partition" },
    { &PARTITION_ANDROID_FASTBOOT, "Android Fastboot Partition" },
    { &PARTITION_ANDROID_METADATA1, "Android Metadata Partition" },
    { &PARTITION_ANDROID_METADATA2, "Android Metadata Partition" },
    { &PARTITION_ANDROID_MISC, "Android Misc Partition" },
    { &PARTITION_ANDROID_OEM, "Android OEM Partition" },
    { &PARTITION_ANDROID_PERSISTENCE, "Android Persistent Partition" },
    { &PARTITION_ANDROID_RECOVERY, "Android Recovery Partition" },
    { &PARTITION_ANDROID_SYSTEM, "Android System Partition" },
    { &PARTITION_ANDROID_VENDOR, "Android Vendor Partition" },
    { &PARTITION_APPLE_APFS, "Apple APFS Partition" },
    { &PARTITION_APPLE_BOOT, "Apple Boot Partition" },
    { &PARTITION_APPLE_FILEVAULT, "Apple Filevault Partition" },
    { &PARTITION_APPLE_HFS, "Apple HFS+ Partition" },
    { &PARTITION_APPLE_LABEL, "Apple Label Partition" },
    { &PARTITION_APPLE_OFFLINE_RAID, "Apple RAID Partition (Offline)" },
    { &PARTITION_APPLE_RAID, "Apple RAID Partition" },
    { &PARTITION_APPLE_RAID_CACHE, "Apple RAID Cache Partition" },
    { &PARTITION_APPLE_RAID_SCRATCH, "Apple RAID Scratch Partition" },
    { &PARTITION_APPLE_RAID_STATUS, "Apple RAID Status Partition" },
    { &PARTITION_APPLE_RAID_VOLUME, "Apple RAID Volume Partition" },
    { &PARTITION_APPLE_RECOVERY, "Apple Recovery Partition" },
    { &PARTITION_APPLE_UFS, "Apple UFS Partition" },
    { &PARTITION_APPLE_ZFS, "Apple ZFS Partition" },
    { &PARTITION_ATARI_DATA, "Atari Data Partition" },
    { &PARTITION_BEOS_BFS, "BeOS BFS Partition" },
    { &PARTITION_CHROMEOS_KERNEL, "Chrome OS Kernel Partition" },
    { &PARTITION_CHROMEOS_RESERVED, "Chrome OS Reserved Partition" },
    { &PARTITION_CHROMEOS_ROOT, "Chrome OS Root Partition" },
    { &PARTITION_COREOS_RAID, "CoreOS Raid Partition" },
    { &PARTITION_COREOS_RESERVED, "CoreOS Reserved Partition" },
    { &PARTITION_COREOS_ROOT, "CoreOS Root Partition" },
    { &PARTITION_COREOS_USR, "CoreOS Usr Partition" },
    { &PARTITION_FREEBSD_BOOT, "FreeBSD Boot Partition" },
    { &PARTITION_FREEBSD_DATA, "FreeBSD Data Partition" },
    { &PARTITION_FREEBSD_LVM, "FreeBSD LVM Partition" },
    { &PARTITION_FREEBSD_SWAP, "FreeBSD Swap Partition" },
    { &PARTITION_FREEBSD_UFS, "FreeBSD UFS Partition" },
    { &PARTITION_FREEBSD_ZFS, "FreeBSD ZFS Partition" },
    { &PARTITION_GENERIC_BIOS_BOOT, "BIOS Boot Partition" },
    { &PARTITION_GENERIC_XBOOTLDR, "Extended Boot Loader Partition" },
    { &PARTITION_GENERIC_ESP, "EFI System Partition" },
    { &PARTITION_GENERIC_MBR, "MBR Partition" },
    { &PARTITION_GENERIC_UNUSED, "Unused Partition" },
    { &PARTITION_HPUX_DATA, "HP-UX Data Partition" },
    { &PARTITION_HPUX_SERVICE, "HP-UX Service Partition" },
    { &PARTITION_IBM_GPFS, "IBM GPFS Partition" },
    { &PARTITION_INTEL_IFF, "Intel Fast Flash Partition" },
    { &PARTITION_LENOVO_BOOT, "Lenovo Boot Partition" },
    { &PARTITION_LINUX_BOOT, "Linux Boot Partition" },
    { &PARTITION_LINUX_DATA, "Linux Data Partition" },
    { &PARTITION_LINUX_ENCRYPTED, "Linux Encrypted Partition" },
    { &PARTITION_LINUX_HOME, "Linux Home Partition" },
    { &PARTITION_LINUX_LUKS, "Linux LUKS Partition" },
    { &PARTITION_LINUX_LVM, "Linux LVM Partition" },
    { &PARTITION_LINUX_RAID, "Linux RAID Partition" },
    { &PARTITION_LINUX_RESERVED, "Linux Reserved Partition" },
    { &PARTITION_LINUX_ROOT_ARM_32, "Linux Boot Partition (ARM)" },
    { &PARTITION_LINUX_ROOT_ARM_64, "Linux Boot Partition (ARM64)" },
    { &PARTITION_LINUX_ROOT_X86_32, "Linux Boot Partition (x86-32)" },
    { &PARTITION_LINUX_ROOT_X86_64, "Linux Boot Partition (x86-64)" },
    { &PARTITION_LINUX_SRV, "Linux Srv Partition" },
    { &PARTITION_LINUX_SWAP, "Linux Swap Partition" },
    { &PARTITION_MICROSOFT_DATA, "Microsoft Basic Data Partition" },
    { &PARTITION_MICROSOFT_LDM_DATA, "Microsoft LDM Data Partition" },
    { &PARTITION_MICROSOFT_LDM_META, "Microsoft LDM Metadata Partition" },
    { &PARTITION_MICROSOFT_RECOVERY, "Microsoft Recovery Partition" },
    { &PARTITION_MICROSOFT_RESERVED, "Microsoft System Reserved Partition" },
    { &PARTITION_MICROSOFT_STORAGE_SPACES, "Microsoft Storage Spaces Partition" },
    { &PARTITION_NETBSD_CONCAT, "NetBSD Concatenated Partition" },
    { &PARTITION_NETBSD_ENCRYPTED, "NetBSD Encrypted Partition" },
    { &PARTITION_NETBSD_FFS, "NetBSD FFS Partition" },
    { &PARTITION_NETBSD_LFS, "NetBSD LFS Partition" },
    { &PARTITION_NETBSD_RAID, "NetBSD RAID Partition" },
    { &PARTITION_NETBSD_SWAP, "NetBSD Swap Partition" },
    { &PARTITION_OPENBSD_DATA, "OpenBSD Data Partition" },
    { &PARTITION_PLAN9_DATA, "Plan 9 Data Partition" },
    { &PARTITION_PREP_BOOT, "PReP Boot Partition" },
    { &PARTITION_QNX_DATA, "QNX Data Partition" },
    { &PARTITION_SOLARIS_ALT, "Solaris Alternate Sector Partition" },
    { &PARTITION_SOLARIS_BACKUP, "Solaris Backup Partition" },
    { &PARTITION_SOLARIS_BOOT, "Solaris Boot Partition" },
    { &PARTITION_SOLARIS_HOME, "Solaris Home Partition" },
    { &PARTITION_SOLARIS_RESERVED1, "Solaris Reserved Partition" },
    { &PARTITION_SOLARIS_RESERVED2, "Solaris Reserved Partition" },
    { &PARTITION_SOLARIS_RESERVED3, "Solaris Reserved Partition" },
    { &PARTITION_SOLARIS_RESERVED4, "Solaris Reserved Partition" },
    { &PARTITION_SOLARIS_RESERVED5, "Solaris Reserved Partition" },
    { &PARTITION_SOLARIS_ROOT, "Solaris Root Partition" },
    { &PARTITION_SOLARIS_SWAP, "Solaris Swap Partition" },
//    { &PARTITION_SOLARIS_USR, "Solaris Usr Partition" },
    { &PARTITION_SOLARIS_VAR, "Solaris Var Partition" },
    { &PARTITION_SONY_BOOT, "Sony Boot Partition" },
    { &PARTITION_VERACRYPT_DATA, "VeraCrypt Data Partition" },
    { &PARTITION_VMWARE_COREDUMP, "VMware Coredump Partition" },
    { &PARTITION_VMWARE_RESERVED, "VMware Reserved Partition" },
    { &PARTITION_VMWARE_VMFS, "VMware VMFS Partition" },
};
