# sage_setup: distribution = sagemath-flint
# distutils: libraries = flint
# distutils: depends = flint/ca_poly.h

################################################################################
# This file is auto-generated by the script
#   SAGE_ROOT/src/sage_setup/autogen/flint_autogen.py.
# From the commit 3e2c3a3e091106a25ca9c6fba28e02f2cbcd654a
# Do not modify by hand! Fix and rerun the script instead.
################################################################################

from libc.stdio cimport FILE
from sage.libs.gmp.types cimport *
from sage.libs.mpfr.types cimport *
from sage.libs.flint.types cimport *

cdef extern from "flint_wrap.h":
    void ca_poly_init(ca_poly_t poly, ca_ctx_t ctx) noexcept
    void ca_poly_clear(ca_poly_t poly, ca_ctx_t ctx) noexcept
    void ca_poly_fit_length(ca_poly_t poly, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_set_length(ca_poly_t poly, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_normalise(ca_poly_t poly, ca_ctx_t ctx) noexcept
    void ca_poly_zero(ca_poly_t poly, ca_ctx_t ctx) noexcept
    void ca_poly_one(ca_poly_t poly, ca_ctx_t ctx) noexcept
    void ca_poly_x(ca_poly_t poly, ca_ctx_t ctx) noexcept
    void ca_poly_set_ca(ca_poly_t poly, const ca_t c, ca_ctx_t ctx) noexcept
    void ca_poly_set_si(ca_poly_t poly, slong c, ca_ctx_t ctx) noexcept
    void ca_poly_set(ca_poly_t res, const ca_poly_t src, ca_ctx_t ctx) noexcept
    void ca_poly_set_fmpz_poly(ca_poly_t res, const fmpz_poly_t src, ca_ctx_t ctx) noexcept
    void ca_poly_set_fmpq_poly(ca_poly_t res, const fmpq_poly_t src, ca_ctx_t ctx) noexcept
    void ca_poly_set_coeff_ca(ca_poly_t poly, slong n, const ca_t x, ca_ctx_t ctx) noexcept
    void ca_poly_transfer(ca_poly_t res, ca_ctx_t res_ctx, const ca_poly_t src, ca_ctx_t src_ctx) noexcept
    void ca_poly_randtest(ca_poly_t poly, flint_rand_t state, slong len, slong depth, slong bits, ca_ctx_t ctx) noexcept
    void ca_poly_randtest_rational(ca_poly_t poly, flint_rand_t state, slong len, slong bits, ca_ctx_t ctx) noexcept
    void ca_poly_print(const ca_poly_t poly, ca_ctx_t ctx) noexcept
    void ca_poly_printn(const ca_poly_t poly, slong digits, ca_ctx_t ctx) noexcept
    bint ca_poly_is_proper(const ca_poly_t poly, ca_ctx_t ctx) noexcept
    int ca_poly_make_monic(ca_poly_t res, const ca_poly_t poly, ca_ctx_t ctx) noexcept
    void _ca_poly_reverse(ca_ptr res, ca_srcptr poly, slong len, slong n, ca_ctx_t ctx) noexcept
    void ca_poly_reverse(ca_poly_t res, const ca_poly_t poly, slong n, ca_ctx_t ctx) noexcept
    truth_t _ca_poly_check_equal(ca_srcptr poly1, slong len1, ca_srcptr poly2, slong len2, ca_ctx_t ctx) noexcept
    truth_t ca_poly_check_equal(const ca_poly_t poly1, const ca_poly_t poly2, ca_ctx_t ctx) noexcept
    truth_t ca_poly_check_is_zero(const ca_poly_t poly, ca_ctx_t ctx) noexcept
    truth_t ca_poly_check_is_one(const ca_poly_t poly, ca_ctx_t ctx) noexcept
    void _ca_poly_shift_left(ca_ptr res, ca_srcptr poly, slong len, slong n, ca_ctx_t ctx) noexcept
    void ca_poly_shift_left(ca_poly_t res, const ca_poly_t poly, slong n, ca_ctx_t ctx) noexcept
    void _ca_poly_shift_right(ca_ptr res, ca_srcptr poly, slong len, slong n, ca_ctx_t ctx) noexcept
    void ca_poly_shift_right(ca_poly_t res, const ca_poly_t poly, slong n, ca_ctx_t ctx) noexcept
    void ca_poly_neg(ca_poly_t res, const ca_poly_t src, ca_ctx_t ctx) noexcept
    void _ca_poly_add(ca_ptr res, ca_srcptr poly1, slong len1, ca_srcptr poly2, slong len2, ca_ctx_t ctx) noexcept
    void ca_poly_add(ca_poly_t res, const ca_poly_t poly1, const ca_poly_t poly2, ca_ctx_t ctx) noexcept
    void _ca_poly_sub(ca_ptr res, ca_srcptr poly1, slong len1, ca_srcptr poly2, slong len2, ca_ctx_t ctx) noexcept
    void ca_poly_sub(ca_poly_t res, const ca_poly_t poly1, const ca_poly_t poly2, ca_ctx_t ctx) noexcept
    void _ca_poly_mul(ca_ptr res, ca_srcptr poly1, slong len1, ca_srcptr poly2, slong len2, ca_ctx_t ctx) noexcept
    void ca_poly_mul(ca_poly_t res, const ca_poly_t poly1, const ca_poly_t poly2, ca_ctx_t ctx) noexcept
    void _ca_poly_mullow(ca_ptr C, ca_srcptr poly1, slong len1, ca_srcptr poly2, slong len2, slong n, ca_ctx_t ctx) noexcept
    void ca_poly_mullow(ca_poly_t res, const ca_poly_t poly1, const ca_poly_t poly2, slong n, ca_ctx_t ctx) noexcept
    void ca_poly_mul_ca(ca_poly_t res, const ca_poly_t poly, const ca_t c, ca_ctx_t ctx) noexcept
    void ca_poly_div_ca(ca_poly_t res, const ca_poly_t poly, const ca_t c, ca_ctx_t ctx) noexcept
    void _ca_poly_divrem_basecase(ca_ptr Q, ca_ptr R, ca_srcptr A, slong lenA, ca_srcptr B, slong lenB, const ca_t invB, ca_ctx_t ctx) noexcept
    int ca_poly_divrem_basecase(ca_poly_t Q, ca_poly_t R, const ca_poly_t A, const ca_poly_t B, ca_ctx_t ctx) noexcept
    void _ca_poly_divrem(ca_ptr Q, ca_ptr R, ca_srcptr A, slong lenA, ca_srcptr B, slong lenB, const ca_t invB, ca_ctx_t ctx) noexcept
    int ca_poly_divrem(ca_poly_t Q, ca_poly_t R, const ca_poly_t A, const ca_poly_t B, ca_ctx_t ctx) noexcept
    int ca_poly_div(ca_poly_t Q, const ca_poly_t A, const ca_poly_t B, ca_ctx_t ctx) noexcept
    int ca_poly_rem(ca_poly_t R, const ca_poly_t A, const ca_poly_t B, ca_ctx_t ctx) noexcept
    void _ca_poly_pow_ui_trunc(ca_ptr res, ca_srcptr f, slong flen, ulong exp, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_pow_ui_trunc(ca_poly_t res, const ca_poly_t poly, ulong exp, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_pow_ui(ca_ptr res, ca_srcptr f, slong flen, ulong exp, ca_ctx_t ctx) noexcept
    void ca_poly_pow_ui(ca_poly_t res, const ca_poly_t poly, ulong exp, ca_ctx_t ctx) noexcept
    void _ca_poly_evaluate_horner(ca_t res, ca_srcptr f, slong len, const ca_t x, ca_ctx_t ctx) noexcept
    void ca_poly_evaluate_horner(ca_t res, const ca_poly_t f, const ca_t a, ca_ctx_t ctx) noexcept
    void _ca_poly_evaluate(ca_t res, ca_srcptr f, slong len, const ca_t x, ca_ctx_t ctx) noexcept
    void ca_poly_evaluate(ca_t res, const ca_poly_t f, const ca_t a, ca_ctx_t ctx) noexcept
    void _ca_poly_compose(ca_ptr res, ca_srcptr poly1, slong len1, ca_srcptr poly2, slong len2, ca_ctx_t ctx) noexcept
    void ca_poly_compose(ca_poly_t res, const ca_poly_t poly1, const ca_poly_t poly2, ca_ctx_t ctx) noexcept
    void _ca_poly_derivative(ca_ptr res, ca_srcptr poly, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_derivative(ca_poly_t res, const ca_poly_t poly, ca_ctx_t ctx) noexcept
    void _ca_poly_integral(ca_ptr res, ca_srcptr poly, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_integral(ca_poly_t res, const ca_poly_t poly, ca_ctx_t ctx) noexcept
    void _ca_poly_inv_series(ca_ptr res, ca_srcptr f, slong flen, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_inv_series(ca_poly_t res, const ca_poly_t f, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_div_series(ca_ptr res, ca_srcptr f, slong flen, ca_srcptr g, slong glen, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_div_series(ca_poly_t res, const ca_poly_t f, const ca_poly_t g, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_exp_series(ca_ptr res, ca_srcptr f, slong flen, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_exp_series(ca_poly_t res, const ca_poly_t f, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_log_series(ca_ptr res, ca_srcptr f, slong flen, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_log_series(ca_poly_t res, const ca_poly_t f, slong len, ca_ctx_t ctx) noexcept
    slong _ca_poly_gcd_euclidean(ca_ptr res, ca_srcptr A, slong lenA, ca_srcptr B, slong lenB, ca_ctx_t ctx) noexcept
    int ca_poly_gcd_euclidean(ca_poly_t res, const ca_poly_t A, const ca_poly_t B, ca_ctx_t ctx) noexcept
    slong _ca_poly_gcd(ca_ptr res, ca_srcptr A, slong lenA, ca_srcptr B, slong lenB, ca_ctx_t ctx) noexcept
    int ca_poly_gcd(ca_poly_t res, const ca_poly_t A, const ca_poly_t g, ca_ctx_t ctx) noexcept
    int ca_poly_factor_squarefree(ca_t c, ca_poly_vec_t fac, ulong * exp, const ca_poly_t F, ca_ctx_t ctx) noexcept
    int ca_poly_squarefree_part(ca_poly_t res, const ca_poly_t poly, ca_ctx_t ctx) noexcept
    void _ca_poly_set_roots(ca_ptr poly, ca_srcptr roots, const ulong * exp, slong n, ca_ctx_t ctx) noexcept
    void ca_poly_set_roots(ca_poly_t poly, ca_vec_t roots, const ulong * exp, ca_ctx_t ctx) noexcept
    int _ca_poly_roots(ca_ptr roots, ca_srcptr poly, slong len, ca_ctx_t ctx) noexcept
    int ca_poly_roots(ca_vec_t roots, ulong * exp, const ca_poly_t poly, ca_ctx_t ctx) noexcept
    ca_poly_struct * _ca_poly_vec_init(slong len, ca_ctx_t ctx) noexcept
    void ca_poly_vec_init(ca_poly_vec_t res, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_vec_fit_length(ca_poly_vec_t vec, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_vec_set_length(ca_poly_vec_t vec, slong len, ca_ctx_t ctx) noexcept
    void _ca_poly_vec_clear(ca_poly_struct * vec, slong len, ca_ctx_t ctx) noexcept
    void ca_poly_vec_clear(ca_poly_vec_t vec, ca_ctx_t ctx) noexcept
    void ca_poly_vec_append(ca_poly_vec_t vec, const ca_poly_t poly, ca_ctx_t ctx) noexcept
