/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_ARM_REGISTER_H
#define LIEF_ASM_ARM_REGISTER_H
namespace LIEF {
namespace assembly {
namespace arm {
enum class REG;
const char* get_register_name(REG r);

enum class REG {
  NoRegister = 0,
  APSR = 1,
  APSR_NZCV = 2,
  CPSR = 3,
  FPCXTNS = 4,
  FPCXTS = 5,
  FPEXC = 6,
  FPINST = 7,
  FPSCR = 8,
  FPSCR_NZCV = 9,
  FPSCR_NZCVQC = 10,
  FPSID = 11,
  ITSTATE = 12,
  LR = 13,
  PC = 14,
  RA_AUTH_CODE = 15,
  SP = 16,
  SPSR = 17,
  VPR = 18,
  ZR = 19,
  D0 = 20,
  D1 = 21,
  D2 = 22,
  D3 = 23,
  D4 = 24,
  D5 = 25,
  D6 = 26,
  D7 = 27,
  D8 = 28,
  D9 = 29,
  D10 = 30,
  D11 = 31,
  D12 = 32,
  D13 = 33,
  D14 = 34,
  D15 = 35,
  D16 = 36,
  D17 = 37,
  D18 = 38,
  D19 = 39,
  D20 = 40,
  D21 = 41,
  D22 = 42,
  D23 = 43,
  D24 = 44,
  D25 = 45,
  D26 = 46,
  D27 = 47,
  D28 = 48,
  D29 = 49,
  D30 = 50,
  D31 = 51,
  FPINST2 = 52,
  MVFR0 = 53,
  MVFR1 = 54,
  MVFR2 = 55,
  P0 = 56,
  Q0 = 57,
  Q1 = 58,
  Q2 = 59,
  Q3 = 60,
  Q4 = 61,
  Q5 = 62,
  Q6 = 63,
  Q7 = 64,
  Q8 = 65,
  Q9 = 66,
  Q10 = 67,
  Q11 = 68,
  Q12 = 69,
  Q13 = 70,
  Q14 = 71,
  Q15 = 72,
  R0 = 73,
  R1 = 74,
  R2 = 75,
  R3 = 76,
  R4 = 77,
  R5 = 78,
  R6 = 79,
  R7 = 80,
  R8 = 81,
  R9 = 82,
  R10 = 83,
  R11 = 84,
  R12 = 85,
  S0 = 86,
  S1 = 87,
  S2 = 88,
  S3 = 89,
  S4 = 90,
  S5 = 91,
  S6 = 92,
  S7 = 93,
  S8 = 94,
  S9 = 95,
  S10 = 96,
  S11 = 97,
  S12 = 98,
  S13 = 99,
  S14 = 100,
  S15 = 101,
  S16 = 102,
  S17 = 103,
  S18 = 104,
  S19 = 105,
  S20 = 106,
  S21 = 107,
  S22 = 108,
  S23 = 109,
  S24 = 110,
  S25 = 111,
  S26 = 112,
  S27 = 113,
  S28 = 114,
  S29 = 115,
  S30 = 116,
  S31 = 117,
  D0_D2 = 118,
  D1_D3 = 119,
  D2_D4 = 120,
  D3_D5 = 121,
  D4_D6 = 122,
  D5_D7 = 123,
  D6_D8 = 124,
  D7_D9 = 125,
  D8_D10 = 126,
  D9_D11 = 127,
  D10_D12 = 128,
  D11_D13 = 129,
  D12_D14 = 130,
  D13_D15 = 131,
  D14_D16 = 132,
  D15_D17 = 133,
  D16_D18 = 134,
  D17_D19 = 135,
  D18_D20 = 136,
  D19_D21 = 137,
  D20_D22 = 138,
  D21_D23 = 139,
  D22_D24 = 140,
  D23_D25 = 141,
  D24_D26 = 142,
  D25_D27 = 143,
  D26_D28 = 144,
  D27_D29 = 145,
  D28_D30 = 146,
  D29_D31 = 147,
  Q0_Q1 = 148,
  Q1_Q2 = 149,
  Q2_Q3 = 150,
  Q3_Q4 = 151,
  Q4_Q5 = 152,
  Q5_Q6 = 153,
  Q6_Q7 = 154,
  Q7_Q8 = 155,
  Q8_Q9 = 156,
  Q9_Q10 = 157,
  Q10_Q11 = 158,
  Q11_Q12 = 159,
  Q12_Q13 = 160,
  Q13_Q14 = 161,
  Q14_Q15 = 162,
  Q0_Q1_Q2_Q3 = 163,
  Q1_Q2_Q3_Q4 = 164,
  Q2_Q3_Q4_Q5 = 165,
  Q3_Q4_Q5_Q6 = 166,
  Q4_Q5_Q6_Q7 = 167,
  Q5_Q6_Q7_Q8 = 168,
  Q6_Q7_Q8_Q9 = 169,
  Q7_Q8_Q9_Q10 = 170,
  Q8_Q9_Q10_Q11 = 171,
  Q9_Q10_Q11_Q12 = 172,
  Q10_Q11_Q12_Q13 = 173,
  Q11_Q12_Q13_Q14 = 174,
  Q12_Q13_Q14_Q15 = 175,
  R0_R1 = 176,
  R2_R3 = 177,
  R4_R5 = 178,
  R6_R7 = 179,
  R8_R9 = 180,
  R10_R11 = 181,
  R12_SP = 182,
  D0_D1_D2 = 183,
  D1_D2_D3 = 184,
  D2_D3_D4 = 185,
  D3_D4_D5 = 186,
  D4_D5_D6 = 187,
  D5_D6_D7 = 188,
  D6_D7_D8 = 189,
  D7_D8_D9 = 190,
  D8_D9_D10 = 191,
  D9_D10_D11 = 192,
  D10_D11_D12 = 193,
  D11_D12_D13 = 194,
  D12_D13_D14 = 195,
  D13_D14_D15 = 196,
  D14_D15_D16 = 197,
  D15_D16_D17 = 198,
  D16_D17_D18 = 199,
  D17_D18_D19 = 200,
  D18_D19_D20 = 201,
  D19_D20_D21 = 202,
  D20_D21_D22 = 203,
  D21_D22_D23 = 204,
  D22_D23_D24 = 205,
  D23_D24_D25 = 206,
  D24_D25_D26 = 207,
  D25_D26_D27 = 208,
  D26_D27_D28 = 209,
  D27_D28_D29 = 210,
  D28_D29_D30 = 211,
  D29_D30_D31 = 212,
  D0_D2_D4 = 213,
  D1_D3_D5 = 214,
  D2_D4_D6 = 215,
  D3_D5_D7 = 216,
  D4_D6_D8 = 217,
  D5_D7_D9 = 218,
  D6_D8_D10 = 219,
  D7_D9_D11 = 220,
  D8_D10_D12 = 221,
  D9_D11_D13 = 222,
  D10_D12_D14 = 223,
  D11_D13_D15 = 224,
  D12_D14_D16 = 225,
  D13_D15_D17 = 226,
  D14_D16_D18 = 227,
  D15_D17_D19 = 228,
  D16_D18_D20 = 229,
  D17_D19_D21 = 230,
  D18_D20_D22 = 231,
  D19_D21_D23 = 232,
  D20_D22_D24 = 233,
  D21_D23_D25 = 234,
  D22_D24_D26 = 235,
  D23_D25_D27 = 236,
  D24_D26_D28 = 237,
  D25_D27_D29 = 238,
  D26_D28_D30 = 239,
  D27_D29_D31 = 240,
  D0_D2_D4_D6 = 241,
  D1_D3_D5_D7 = 242,
  D2_D4_D6_D8 = 243,
  D3_D5_D7_D9 = 244,
  D4_D6_D8_D10 = 245,
  D5_D7_D9_D11 = 246,
  D6_D8_D10_D12 = 247,
  D7_D9_D11_D13 = 248,
  D8_D10_D12_D14 = 249,
  D9_D11_D13_D15 = 250,
  D10_D12_D14_D16 = 251,
  D11_D13_D15_D17 = 252,
  D12_D14_D16_D18 = 253,
  D13_D15_D17_D19 = 254,
  D14_D16_D18_D20 = 255,
  D15_D17_D19_D21 = 256,
  D16_D18_D20_D22 = 257,
  D17_D19_D21_D23 = 258,
  D18_D20_D22_D24 = 259,
  D19_D21_D23_D25 = 260,
  D20_D22_D24_D26 = 261,
  D21_D23_D25_D27 = 262,
  D22_D24_D26_D28 = 263,
  D23_D25_D27_D29 = 264,
  D24_D26_D28_D30 = 265,
  D25_D27_D29_D31 = 266,
  D1_D2 = 267,
  D3_D4 = 268,
  D5_D6 = 269,
  D7_D8 = 270,
  D9_D10 = 271,
  D11_D12 = 272,
  D13_D14 = 273,
  D15_D16 = 274,
  D17_D18 = 275,
  D19_D20 = 276,
  D21_D22 = 277,
  D23_D24 = 278,
  D25_D26 = 279,
  D27_D28 = 280,
  D29_D30 = 281,
  D1_D2_D3_D4 = 282,
  D3_D4_D5_D6 = 283,
  D5_D6_D7_D8 = 284,
  D7_D8_D9_D10 = 285,
  D9_D10_D11_D12 = 286,
  D11_D12_D13_D14 = 287,
  D13_D14_D15_D16 = 288,
  D15_D16_D17_D18 = 289,
  D17_D18_D19_D20 = 290,
  D19_D20_D21_D22 = 291,
  D21_D22_D23_D24 = 292,
  D23_D24_D25_D26 = 293,
  D25_D26_D27_D28 = 294,
  D27_D28_D29_D30 = 295,
  NUM_TARGET_REGS = 296,
};

}
}
}
#endif
