/* Copyright 2017 - 2025 R. Thomas
 * Copyright 2017 - 2025 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "LIEF/PE/CodePage.hpp"
#include "frozen.hpp"

namespace LIEF::PE {
const char* to_string(CODE_PAGES e) {
  #define ENTRY(X) std::pair(CODE_PAGES::X, #X)
  STRING_MAP enums2str {
    ENTRY(IBM037),
    ENTRY(IBM437),
    ENTRY(IBM500),
    ENTRY(ASMO_708),
    ENTRY(DOS_720),
    ENTRY(IBM737),
    ENTRY(IBM775),
    ENTRY(IBM850),
    ENTRY(IBM852),
    ENTRY(IBM855),
    ENTRY(IBM857),
    ENTRY(IBM00858),
    ENTRY(IBM860),
    ENTRY(IBM861),
    ENTRY(DOS_862),
    ENTRY(IBM863),
    ENTRY(IBM864),
    ENTRY(IBM865),
    ENTRY(CP866),
    ENTRY(IBM869),
    ENTRY(IBM870),
    ENTRY(WINDOWS_874),
    ENTRY(CP875),
    ENTRY(SHIFT_JIS),
    ENTRY(GB2312),
    ENTRY(KS_C_5601_1987),
    ENTRY(BIG5),
    ENTRY(IBM1026),
    ENTRY(IBM01047),
    ENTRY(IBM01140),
    ENTRY(IBM01141),
    ENTRY(IBM01142),
    ENTRY(IBM01143),
    ENTRY(IBM01144),
    ENTRY(IBM01145),
    ENTRY(IBM01146),
    ENTRY(IBM01147),
    ENTRY(IBM01148),
    ENTRY(IBM01149),
    ENTRY(UTF_16),
    ENTRY(UNICODEFFFE),
    ENTRY(WINDOWS_1250),
    ENTRY(WINDOWS_1251),
    ENTRY(WINDOWS_1252),
    ENTRY(WINDOWS_1253),
    ENTRY(WINDOWS_1254),
    ENTRY(WINDOWS_1255),
    ENTRY(WINDOWS_1256),
    ENTRY(WINDOWS_1257),
    ENTRY(WINDOWS_1258),
    ENTRY(JOHAB),
    ENTRY(MACINTOSH),
    ENTRY(X_MAC_JAPANESE),
    ENTRY(X_MAC_CHINESETRAD),
    ENTRY(X_MAC_KOREAN),
    ENTRY(X_MAC_ARABIC),
    ENTRY(X_MAC_HEBREW),
    ENTRY(X_MAC_GREEK),
    ENTRY(X_MAC_CYRILLIC),
    ENTRY(X_MAC_CHINESESIMP),
    ENTRY(X_MAC_ROMANIAN),
    ENTRY(X_MAC_UKRAINIAN),
    ENTRY(X_MAC_THAI),
    ENTRY(X_MAC_CE),
    ENTRY(X_MAC_ICELANDIC),
    ENTRY(X_MAC_TURKISH),
    ENTRY(X_MAC_CROATIAN),
    ENTRY(UTF_32),
    ENTRY(UTF_32BE),
    ENTRY(X_CHINESE_CNS),
    ENTRY(X_CP20001),
    ENTRY(X_CHINESE_ETEN),
    ENTRY(X_CP20003),
    ENTRY(X_CP20004),
    ENTRY(X_CP20005),
    ENTRY(X_IA5),
    ENTRY(X_IA5_GERMAN),
    ENTRY(X_IA5_SWEDISH),
    ENTRY(X_IA5_NORWEGIAN),
    ENTRY(US_ASCII),
    ENTRY(X_CP20261),
    ENTRY(X_CP20269),
    ENTRY(IBM273),
    ENTRY(IBM277),
    ENTRY(IBM278),
    ENTRY(IBM280),
    ENTRY(IBM284),
    ENTRY(IBM285),
    ENTRY(IBM290),
    ENTRY(IBM297),
    ENTRY(IBM420),
    ENTRY(IBM423),
    ENTRY(IBM424),
    ENTRY(X_EBCDIC_KOREANEXTENDED),
    ENTRY(IBM_THAI),
    ENTRY(KOI8_R),
    ENTRY(IBM871),
    ENTRY(IBM880),
    ENTRY(IBM905),
    ENTRY(IBM00924),
    ENTRY(EUC_JP_JIS),
    ENTRY(X_CP20936),
    ENTRY(X_CP20949),
    ENTRY(CP1025),
    ENTRY(KOI8_U),
    ENTRY(ISO_8859_1),
    ENTRY(ISO_8859_2),
    ENTRY(ISO_8859_3),
    ENTRY(ISO_8859_4),
    ENTRY(ISO_8859_5),
    ENTRY(ISO_8859_6),
    ENTRY(ISO_8859_7),
    ENTRY(ISO_8859_8),
    ENTRY(ISO_8859_9),
    ENTRY(ISO_8859_13),
    ENTRY(ISO_8859_15),
    ENTRY(X_EUROPA),
    ENTRY(ISO_8859_8_I),
    ENTRY(ISO_2022_JP),
    ENTRY(CSISO2022JP),
    ENTRY(ISO_2022_JP_JIS),
    ENTRY(ISO_2022_KR),
    ENTRY(X_CP50227),
    ENTRY(EUC_JP),
    ENTRY(EUC_CN),
    ENTRY(EUC_KR),
    ENTRY(HZ_GB_2312),
    ENTRY(GB18030),
    ENTRY(X_ISCII_DE),
    ENTRY(X_ISCII_BE),
    ENTRY(X_ISCII_TA),
    ENTRY(X_ISCII_TE),
    ENTRY(X_ISCII_AS),
    ENTRY(X_ISCII_OR),
    ENTRY(X_ISCII_KA),
    ENTRY(X_ISCII_MA),
    ENTRY(X_ISCII_GU),
    ENTRY(X_ISCII_PA),
    ENTRY(UTF_7),
    ENTRY(UTF_8),
  };
  #undef ENTRY

  if (auto it = enums2str.find(e); it != enums2str.end()) {
    return it->second;
  }
  return "UNKNOWN";
}

}
