#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  INIT_UNDEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  FAKE_USE,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_ABDS,
  G_ABDU,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_FMAXIMUM,
  G_ATOMICRMW_FMINIMUM,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_ATOMICRMW_USUB_COND,
  G_ATOMICRMW_USUB_SAT,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_TRUNC_SSAT_S,
  G_TRUNC_SSAT_U,
  G_TRUNC_USAT_U,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FPTOSI_SAT,
  G_FPTOUI_SAT,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_FMINIMUMNUM,
  G_FMAXIMUMNUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_GET_ROUNDING,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_STEP_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FSINCOS,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FATAN2,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ABS,
  ADDSri,
  ADDSrr,
  ADDSrsi,
  ADDSrsr,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  ASRi,
  ASRr,
  ASRs1,
  B,
  BCCZi64,
  BCCi64,
  BLX_noip,
  BLX_pred_noip,
  BL_PUSHLR,
  BMOVPCB_CALL,
  BMOVPCRX_CALL,
  BR_JTadd,
  BR_JTm_i12,
  BR_JTm_rs,
  BR_JTr,
  BX_CALL,
  CMP_SWAP_16,
  CMP_SWAP_32,
  CMP_SWAP_64,
  CMP_SWAP_8,
  CONSTPOOL_ENTRY,
  COPY_STRUCT_BYVAL_I32,
  ITasm,
  Int_eh_sjlj_dispatchsetup,
  Int_eh_sjlj_longjmp,
  Int_eh_sjlj_setjmp,
  Int_eh_sjlj_setjmp_nofp,
  Int_eh_sjlj_setup_dispatch,
  JUMPTABLE_ADDRS,
  JUMPTABLE_INSTS,
  JUMPTABLE_TBB,
  JUMPTABLE_TBH,
  LDMIA_RET,
  LDRBT_POST,
  LDRConstPool,
  LDRHTii,
  LDRLIT_ga_abs,
  LDRLIT_ga_pcrel,
  LDRLIT_ga_pcrel_ldr,
  LDRSBTii,
  LDRSHTii,
  LDRT_POST,
  LEApcrel,
  LEApcrelJT,
  LOADDUAL,
  LSLi,
  LSLr,
  LSRi,
  LSRr,
  LSRs1,
  MEMCPY,
  MLAv5,
  MOVCCi,
  MOVCCi16,
  MOVCCi32imm,
  MOVCCr,
  MOVCCsi,
  MOVCCsr,
  MOVPCRX,
  MOVTi16_ga_pcrel,
  MOV_ga_pcrel,
  MOV_ga_pcrel_ldr,
  MOVi16_ga_pcrel,
  MOVi32imm,
  MQPRCopy,
  MQQPRLoad,
  MQQPRStore,
  MQQQQPRLoad,
  MQQQQPRStore,
  MULv5,
  MVE_MEMCPYLOOPINST,
  MVE_MEMSETLOOPINST,
  MVNCCi,
  PICADD,
  PICLDR,
  PICLDRB,
  PICLDRH,
  PICLDRSB,
  PICLDRSH,
  PICSTR,
  PICSTRB,
  PICSTRH,
  RORi,
  RORr,
  RRX,
  RRXi,
  RSBSri,
  RSBSrsi,
  RSBSrsr,
  SEH_EpilogEnd,
  SEH_EpilogStart,
  SEH_Nop,
  SEH_Nop_Ret,
  SEH_PrologEnd,
  SEH_SaveFRegs,
  SEH_SaveLR,
  SEH_SaveRegs,
  SEH_SaveRegs_Ret,
  SEH_SaveSP,
  SEH_StackAlloc,
  SMLALv5,
  SMULLv5,
  SPACE,
  STOREDUAL,
  STRBT_POST,
  STRBi_preidx,
  STRBr_preidx,
  STRH_preidx,
  STRT_POST,
  STRi_preidx,
  STRr_preidx,
  SUBS_PC_LR,
  SUBSri,
  SUBSrr,
  SUBSrsi,
  SUBSrsr,
  SpeculationBarrierISBDSBEndBB,
  SpeculationBarrierSBEndBB,
  TAILJMPd,
  TAILJMPr,
  TAILJMPr4,
  TCRETURNdi,
  TCRETURNri,
  TCRETURNrinotr12,
  TPsoft,
  UMLALv5,
  UMULLv5,
  VLD1LNdAsm_16,
  VLD1LNdAsm_32,
  VLD1LNdAsm_8,
  VLD1LNdWB_fixed_Asm_16,
  VLD1LNdWB_fixed_Asm_32,
  VLD1LNdWB_fixed_Asm_8,
  VLD1LNdWB_register_Asm_16,
  VLD1LNdWB_register_Asm_32,
  VLD1LNdWB_register_Asm_8,
  VLD2LNdAsm_16,
  VLD2LNdAsm_32,
  VLD2LNdAsm_8,
  VLD2LNdWB_fixed_Asm_16,
  VLD2LNdWB_fixed_Asm_32,
  VLD2LNdWB_fixed_Asm_8,
  VLD2LNdWB_register_Asm_16,
  VLD2LNdWB_register_Asm_32,
  VLD2LNdWB_register_Asm_8,
  VLD2LNqAsm_16,
  VLD2LNqAsm_32,
  VLD2LNqWB_fixed_Asm_16,
  VLD2LNqWB_fixed_Asm_32,
  VLD2LNqWB_register_Asm_16,
  VLD2LNqWB_register_Asm_32,
  VLD3DUPdAsm_16,
  VLD3DUPdAsm_32,
  VLD3DUPdAsm_8,
  VLD3DUPdWB_fixed_Asm_16,
  VLD3DUPdWB_fixed_Asm_32,
  VLD3DUPdWB_fixed_Asm_8,
  VLD3DUPdWB_register_Asm_16,
  VLD3DUPdWB_register_Asm_32,
  VLD3DUPdWB_register_Asm_8,
  VLD3DUPqAsm_16,
  VLD3DUPqAsm_32,
  VLD3DUPqAsm_8,
  VLD3DUPqWB_fixed_Asm_16,
  VLD3DUPqWB_fixed_Asm_32,
  VLD3DUPqWB_fixed_Asm_8,
  VLD3DUPqWB_register_Asm_16,
  VLD3DUPqWB_register_Asm_32,
  VLD3DUPqWB_register_Asm_8,
  VLD3LNdAsm_16,
  VLD3LNdAsm_32,
  VLD3LNdAsm_8,
  VLD3LNdWB_fixed_Asm_16,
  VLD3LNdWB_fixed_Asm_32,
  VLD3LNdWB_fixed_Asm_8,
  VLD3LNdWB_register_Asm_16,
  VLD3LNdWB_register_Asm_32,
  VLD3LNdWB_register_Asm_8,
  VLD3LNqAsm_16,
  VLD3LNqAsm_32,
  VLD3LNqWB_fixed_Asm_16,
  VLD3LNqWB_fixed_Asm_32,
  VLD3LNqWB_register_Asm_16,
  VLD3LNqWB_register_Asm_32,
  VLD3dAsm_16,
  VLD3dAsm_32,
  VLD3dAsm_8,
  VLD3dWB_fixed_Asm_16,
  VLD3dWB_fixed_Asm_32,
  VLD3dWB_fixed_Asm_8,
  VLD3dWB_register_Asm_16,
  VLD3dWB_register_Asm_32,
  VLD3dWB_register_Asm_8,
  VLD3qAsm_16,
  VLD3qAsm_32,
  VLD3qAsm_8,
  VLD3qWB_fixed_Asm_16,
  VLD3qWB_fixed_Asm_32,
  VLD3qWB_fixed_Asm_8,
  VLD3qWB_register_Asm_16,
  VLD3qWB_register_Asm_32,
  VLD3qWB_register_Asm_8,
  VLD4DUPdAsm_16,
  VLD4DUPdAsm_32,
  VLD4DUPdAsm_8,
  VLD4DUPdWB_fixed_Asm_16,
  VLD4DUPdWB_fixed_Asm_32,
  VLD4DUPdWB_fixed_Asm_8,
  VLD4DUPdWB_register_Asm_16,
  VLD4DUPdWB_register_Asm_32,
  VLD4DUPdWB_register_Asm_8,
  VLD4DUPqAsm_16,
  VLD4DUPqAsm_32,
  VLD4DUPqAsm_8,
  VLD4DUPqWB_fixed_Asm_16,
  VLD4DUPqWB_fixed_Asm_32,
  VLD4DUPqWB_fixed_Asm_8,
  VLD4DUPqWB_register_Asm_16,
  VLD4DUPqWB_register_Asm_32,
  VLD4DUPqWB_register_Asm_8,
  VLD4LNdAsm_16,
  VLD4LNdAsm_32,
  VLD4LNdAsm_8,
  VLD4LNdWB_fixed_Asm_16,
  VLD4LNdWB_fixed_Asm_32,
  VLD4LNdWB_fixed_Asm_8,
  VLD4LNdWB_register_Asm_16,
  VLD4LNdWB_register_Asm_32,
  VLD4LNdWB_register_Asm_8,
  VLD4LNqAsm_16,
  VLD4LNqAsm_32,
  VLD4LNqWB_fixed_Asm_16,
  VLD4LNqWB_fixed_Asm_32,
  VLD4LNqWB_register_Asm_16,
  VLD4LNqWB_register_Asm_32,
  VLD4dAsm_16,
  VLD4dAsm_32,
  VLD4dAsm_8,
  VLD4dWB_fixed_Asm_16,
  VLD4dWB_fixed_Asm_32,
  VLD4dWB_fixed_Asm_8,
  VLD4dWB_register_Asm_16,
  VLD4dWB_register_Asm_32,
  VLD4dWB_register_Asm_8,
  VLD4qAsm_16,
  VLD4qAsm_32,
  VLD4qAsm_8,
  VLD4qWB_fixed_Asm_16,
  VLD4qWB_fixed_Asm_32,
  VLD4qWB_fixed_Asm_8,
  VLD4qWB_register_Asm_16,
  VLD4qWB_register_Asm_32,
  VLD4qWB_register_Asm_8,
  VMOVD0,
  VMOVDcc,
  VMOVHcc,
  VMOVQ0,
  VMOVScc,
  VST1LNdAsm_16,
  VST1LNdAsm_32,
  VST1LNdAsm_8,
  VST1LNdWB_fixed_Asm_16,
  VST1LNdWB_fixed_Asm_32,
  VST1LNdWB_fixed_Asm_8,
  VST1LNdWB_register_Asm_16,
  VST1LNdWB_register_Asm_32,
  VST1LNdWB_register_Asm_8,
  VST2LNdAsm_16,
  VST2LNdAsm_32,
  VST2LNdAsm_8,
  VST2LNdWB_fixed_Asm_16,
  VST2LNdWB_fixed_Asm_32,
  VST2LNdWB_fixed_Asm_8,
  VST2LNdWB_register_Asm_16,
  VST2LNdWB_register_Asm_32,
  VST2LNdWB_register_Asm_8,
  VST2LNqAsm_16,
  VST2LNqAsm_32,
  VST2LNqWB_fixed_Asm_16,
  VST2LNqWB_fixed_Asm_32,
  VST2LNqWB_register_Asm_16,
  VST2LNqWB_register_Asm_32,
  VST3LNdAsm_16,
  VST3LNdAsm_32,
  VST3LNdAsm_8,
  VST3LNdWB_fixed_Asm_16,
  VST3LNdWB_fixed_Asm_32,
  VST3LNdWB_fixed_Asm_8,
  VST3LNdWB_register_Asm_16,
  VST3LNdWB_register_Asm_32,
  VST3LNdWB_register_Asm_8,
  VST3LNqAsm_16,
  VST3LNqAsm_32,
  VST3LNqWB_fixed_Asm_16,
  VST3LNqWB_fixed_Asm_32,
  VST3LNqWB_register_Asm_16,
  VST3LNqWB_register_Asm_32,
  VST3dAsm_16,
  VST3dAsm_32,
  VST3dAsm_8,
  VST3dWB_fixed_Asm_16,
  VST3dWB_fixed_Asm_32,
  VST3dWB_fixed_Asm_8,
  VST3dWB_register_Asm_16,
  VST3dWB_register_Asm_32,
  VST3dWB_register_Asm_8,
  VST3qAsm_16,
  VST3qAsm_32,
  VST3qAsm_8,
  VST3qWB_fixed_Asm_16,
  VST3qWB_fixed_Asm_32,
  VST3qWB_fixed_Asm_8,
  VST3qWB_register_Asm_16,
  VST3qWB_register_Asm_32,
  VST3qWB_register_Asm_8,
  VST4LNdAsm_16,
  VST4LNdAsm_32,
  VST4LNdAsm_8,
  VST4LNdWB_fixed_Asm_16,
  VST4LNdWB_fixed_Asm_32,
  VST4LNdWB_fixed_Asm_8,
  VST4LNdWB_register_Asm_16,
  VST4LNdWB_register_Asm_32,
  VST4LNdWB_register_Asm_8,
  VST4LNqAsm_16,
  VST4LNqAsm_32,
  VST4LNqWB_fixed_Asm_16,
  VST4LNqWB_fixed_Asm_32,
  VST4LNqWB_register_Asm_16,
  VST4LNqWB_register_Asm_32,
  VST4dAsm_16,
  VST4dAsm_32,
  VST4dAsm_8,
  VST4dWB_fixed_Asm_16,
  VST4dWB_fixed_Asm_32,
  VST4dWB_fixed_Asm_8,
  VST4dWB_register_Asm_16,
  VST4dWB_register_Asm_32,
  VST4dWB_register_Asm_8,
  VST4qAsm_16,
  VST4qAsm_32,
  VST4qAsm_8,
  VST4qWB_fixed_Asm_16,
  VST4qWB_fixed_Asm_32,
  VST4qWB_fixed_Asm_8,
  VST4qWB_register_Asm_16,
  VST4qWB_register_Asm_32,
  VST4qWB_register_Asm_8,
  WIN__CHKSTK,
  WIN__DBZCHK,
  t2ABS,
  t2ADDSri,
  t2ADDSrr,
  t2ADDSrs,
  t2BF_LabelPseudo,
  t2BR_JT,
  t2CALL_BTI,
  t2DoLoopStart,
  t2DoLoopStartTP,
  t2LDMIA_RET,
  t2LDRB_OFFSET_imm,
  t2LDRB_POST_imm,
  t2LDRB_PRE_imm,
  t2LDRBpcrel,
  t2LDRConstPool,
  t2LDRH_OFFSET_imm,
  t2LDRH_POST_imm,
  t2LDRH_PRE_imm,
  t2LDRHpcrel,
  t2LDRLIT_ga_pcrel,
  t2LDRSB_OFFSET_imm,
  t2LDRSB_POST_imm,
  t2LDRSB_PRE_imm,
  t2LDRSBpcrel,
  t2LDRSH_OFFSET_imm,
  t2LDRSH_POST_imm,
  t2LDRSH_PRE_imm,
  t2LDRSHpcrel,
  t2LDR_POST_imm,
  t2LDR_PRE_imm,
  t2LDRpci_pic,
  t2LDRpcrel,
  t2LEApcrel,
  t2LEApcrelJT,
  t2LoopDec,
  t2LoopEnd,
  t2LoopEndDec,
  t2MOVCCasr,
  t2MOVCCi,
  t2MOVCCi16,
  t2MOVCCi32imm,
  t2MOVCClsl,
  t2MOVCClsr,
  t2MOVCCr,
  t2MOVCCror,
  t2MOVSsi,
  t2MOVSsr,
  t2MOVTi16_ga_pcrel,
  t2MOV_ga_pcrel,
  t2MOVi16_ga_pcrel,
  t2MOVi32imm,
  t2MOVsi,
  t2MOVsr,
  t2MVNCCi,
  t2RSBSri,
  t2RSBSrs,
  t2STRB_OFFSET_imm,
  t2STRB_POST_imm,
  t2STRB_PRE_imm,
  t2STRB_preidx,
  t2STRH_OFFSET_imm,
  t2STRH_POST_imm,
  t2STRH_PRE_imm,
  t2STRH_preidx,
  t2STR_POST_imm,
  t2STR_PRE_imm,
  t2STR_preidx,
  t2SUBSri,
  t2SUBSrr,
  t2SUBSrs,
  t2SpeculationBarrierISBDSBEndBB,
  t2SpeculationBarrierSBEndBB,
  t2TBB_JT,
  t2TBH_JT,
  t2WhileLoopSetup,
  t2WhileLoopStart,
  t2WhileLoopStartLR,
  t2WhileLoopStartTP,
  tADCS,
  tADDSi3,
  tADDSi8,
  tADDSrr,
  tADDframe,
  tADJCALLSTACKDOWN,
  tADJCALLSTACKUP,
  tBLXNS_CALL,
  tBLXr_noip,
  tBL_PUSHLR,
  tBRIND,
  tBR_JTr,
  tBXNS_RET,
  tBX_CALL,
  tBX_RET,
  tBX_RET_vararg,
  tBfar,
  tCMP_SWAP_16,
  tCMP_SWAP_32,
  tCMP_SWAP_8,
  tLDMIA_UPD,
  tLDRConstPool,
  tLDRLIT_ga_abs,
  tLDRLIT_ga_pcrel,
  tLDR_postidx,
  tLDRpci_pic,
  tLEApcrel,
  tLEApcrelJT,
  tLSLSri,
  tMOVCCr_pseudo,
  tMOVi32imm,
  tPOP_RET,
  tRSBS,
  tSBCS,
  tSUBSi3,
  tSUBSi8,
  tSUBSrr,
  tTAILJMPd,
  tTAILJMPdND,
  tTAILJMPr,
  tTBB_JT,
  tTBH_JT,
  tTPsoft,
  ADCri,
  ADCrr,
  ADCrsi,
  ADCrsr,
  ADDri,
  ADDrr,
  ADDrsi,
  ADDrsr,
  ADR,
  AESD,
  AESE,
  AESIMC,
  AESMC,
  ANDri,
  ANDrr,
  ANDrsi,
  ANDrsr,
  BF16VDOTI_VDOTD,
  BF16VDOTI_VDOTQ,
  BF16VDOTS_VDOTD,
  BF16VDOTS_VDOTQ,
  BF16_VCVT,
  BF16_VCVTB,
  BF16_VCVTT,
  BFC,
  BFI,
  BICri,
  BICrr,
  BICrsi,
  BICrsr,
  BKPT,
  BL,
  BLX,
  BLX_pred,
  BLXi,
  BL_pred,
  BX,
  BXJ,
  BX_RET,
  BX_pred,
  Bcc,
  CDE_CX1,
  CDE_CX1A,
  CDE_CX1D,
  CDE_CX1DA,
  CDE_CX2,
  CDE_CX2A,
  CDE_CX2D,
  CDE_CX2DA,
  CDE_CX3,
  CDE_CX3A,
  CDE_CX3D,
  CDE_CX3DA,
  CDE_VCX1A_fpdp,
  CDE_VCX1A_fpsp,
  CDE_VCX1A_vec,
  CDE_VCX1_fpdp,
  CDE_VCX1_fpsp,
  CDE_VCX1_vec,
  CDE_VCX2A_fpdp,
  CDE_VCX2A_fpsp,
  CDE_VCX2A_vec,
  CDE_VCX2_fpdp,
  CDE_VCX2_fpsp,
  CDE_VCX2_vec,
  CDE_VCX3A_fpdp,
  CDE_VCX3A_fpsp,
  CDE_VCX3A_vec,
  CDE_VCX3_fpdp,
  CDE_VCX3_fpsp,
  CDE_VCX3_vec,
  CDP,
  CDP2,
  CLREX,
  CLZ,
  CMNri,
  CMNzrr,
  CMNzrsi,
  CMNzrsr,
  CMPri,
  CMPrr,
  CMPrsi,
  CMPrsr,
  CPS1p,
  CPS2p,
  CPS3p,
  CRC32B,
  CRC32CB,
  CRC32CH,
  CRC32CW,
  CRC32H,
  CRC32W,
  DBG,
  DMB,
  DSB,
  EORri,
  EORrr,
  EORrsi,
  EORrsr,
  ERET,
  FCONSTD,
  FCONSTH,
  FCONSTS,
  FLDMXDB_UPD,
  FLDMXIA,
  FLDMXIA_UPD,
  FMSTAT,
  FSTMXDB_UPD,
  FSTMXIA,
  FSTMXIA_UPD,
  HINT,
  HLT,
  HVC,
  ISB,
  LDA,
  LDAB,
  LDAEX,
  LDAEXB,
  LDAEXD,
  LDAEXH,
  LDAH,
  LDC2L_OFFSET,
  LDC2L_OPTION,
  LDC2L_POST,
  LDC2L_PRE,
  LDC2_OFFSET,
  LDC2_OPTION,
  LDC2_POST,
  LDC2_PRE,
  LDCL_OFFSET,
  LDCL_OPTION,
  LDCL_POST,
  LDCL_PRE,
  LDC_OFFSET,
  LDC_OPTION,
  LDC_POST,
  LDC_PRE,
  LDMDA,
  LDMDA_UPD,
  LDMDB,
  LDMDB_UPD,
  LDMIA,
  LDMIA_UPD,
  LDMIB,
  LDMIB_UPD,
  LDRBT_POST_IMM,
  LDRBT_POST_REG,
  LDRB_POST_IMM,
  LDRB_POST_REG,
  LDRB_PRE_IMM,
  LDRB_PRE_REG,
  LDRBi12,
  LDRBrs,
  LDRD,
  LDRD_POST,
  LDRD_PRE,
  LDREX,
  LDREXB,
  LDREXD,
  LDREXH,
  LDRH,
  LDRHTi,
  LDRHTr,
  LDRH_POST,
  LDRH_PRE,
  LDRSB,
  LDRSBTi,
  LDRSBTr,
  LDRSB_POST,
  LDRSB_PRE,
  LDRSH,
  LDRSHTi,
  LDRSHTr,
  LDRSH_POST,
  LDRSH_PRE,
  LDRT_POST_IMM,
  LDRT_POST_REG,
  LDR_POST_IMM,
  LDR_POST_REG,
  LDR_PRE_IMM,
  LDR_PRE_REG,
  LDRcp,
  LDRi12,
  LDRrs,
  MCR,
  MCR2,
  MCRR,
  MCRR2,
  MLA,
  MLS,
  MOVPCLR,
  MOVTi16,
  MOVi,
  MOVi16,
  MOVr,
  MOVr_TC,
  MOVsi,
  MOVsr,
  MRC,
  MRC2,
  MRRC,
  MRRC2,
  MRS,
  MRSbanked,
  MRSsys,
  MSR,
  MSRbanked,
  MSRi,
  MUL,
  MVE_ASRLi,
  MVE_ASRLr,
  MVE_DLSTP_16,
  MVE_DLSTP_32,
  MVE_DLSTP_64,
  MVE_DLSTP_8,
  MVE_LCTP,
  MVE_LETP,
  MVE_LSLLi,
  MVE_LSLLr,
  MVE_LSRL,
  MVE_SQRSHR,
  MVE_SQRSHRL,
  MVE_SQSHL,
  MVE_SQSHLL,
  MVE_SRSHR,
  MVE_SRSHRL,
  MVE_UQRSHL,
  MVE_UQRSHLL,
  MVE_UQSHL,
  MVE_UQSHLL,
  MVE_URSHR,
  MVE_URSHRL,
  MVE_VABAVs16,
  MVE_VABAVs32,
  MVE_VABAVs8,
  MVE_VABAVu16,
  MVE_VABAVu32,
  MVE_VABAVu8,
  MVE_VABDf16,
  MVE_VABDf32,
  MVE_VABDs16,
  MVE_VABDs32,
  MVE_VABDs8,
  MVE_VABDu16,
  MVE_VABDu32,
  MVE_VABDu8,
  MVE_VABSf16,
  MVE_VABSf32,
  MVE_VABSs16,
  MVE_VABSs32,
  MVE_VABSs8,
  MVE_VADC,
  MVE_VADCI,
  MVE_VADDLVs32acc,
  MVE_VADDLVs32no_acc,
  MVE_VADDLVu32acc,
  MVE_VADDLVu32no_acc,
  MVE_VADDVs16acc,
  MVE_VADDVs16no_acc,
  MVE_VADDVs32acc,
  MVE_VADDVs32no_acc,
  MVE_VADDVs8acc,
  MVE_VADDVs8no_acc,
  MVE_VADDVu16acc,
  MVE_VADDVu16no_acc,
  MVE_VADDVu32acc,
  MVE_VADDVu32no_acc,
  MVE_VADDVu8acc,
  MVE_VADDVu8no_acc,
  MVE_VADD_qr_f16,
  MVE_VADD_qr_f32,
  MVE_VADD_qr_i16,
  MVE_VADD_qr_i32,
  MVE_VADD_qr_i8,
  MVE_VADDf16,
  MVE_VADDf32,
  MVE_VADDi16,
  MVE_VADDi32,
  MVE_VADDi8,
  MVE_VAND,
  MVE_VBIC,
  MVE_VBICimmi16,
  MVE_VBICimmi32,
  MVE_VBRSR16,
  MVE_VBRSR32,
  MVE_VBRSR8,
  MVE_VCADDf16,
  MVE_VCADDf32,
  MVE_VCADDi16,
  MVE_VCADDi32,
  MVE_VCADDi8,
  MVE_VCLSs16,
  MVE_VCLSs32,
  MVE_VCLSs8,
  MVE_VCLZs16,
  MVE_VCLZs32,
  MVE_VCLZs8,
  MVE_VCMLAf16,
  MVE_VCMLAf32,
  MVE_VCMPf16,
  MVE_VCMPf16r,
  MVE_VCMPf32,
  MVE_VCMPf32r,
  MVE_VCMPi16,
  MVE_VCMPi16r,
  MVE_VCMPi32,
  MVE_VCMPi32r,
  MVE_VCMPi8,
  MVE_VCMPi8r,
  MVE_VCMPs16,
  MVE_VCMPs16r,
  MVE_VCMPs32,
  MVE_VCMPs32r,
  MVE_VCMPs8,
  MVE_VCMPs8r,
  MVE_VCMPu16,
  MVE_VCMPu16r,
  MVE_VCMPu32,
  MVE_VCMPu32r,
  MVE_VCMPu8,
  MVE_VCMPu8r,
  MVE_VCMULf16,
  MVE_VCMULf32,
  MVE_VCTP16,
  MVE_VCTP32,
  MVE_VCTP64,
  MVE_VCTP8,
  MVE_VCVTf16f32bh,
  MVE_VCVTf16f32th,
  MVE_VCVTf16s16_fix,
  MVE_VCVTf16s16n,
  MVE_VCVTf16u16_fix,
  MVE_VCVTf16u16n,
  MVE_VCVTf32f16bh,
  MVE_VCVTf32f16th,
  MVE_VCVTf32s32_fix,
  MVE_VCVTf32s32n,
  MVE_VCVTf32u32_fix,
  MVE_VCVTf32u32n,
  MVE_VCVTs16f16_fix,
  MVE_VCVTs16f16a,
  MVE_VCVTs16f16m,
  MVE_VCVTs16f16n,
  MVE_VCVTs16f16p,
  MVE_VCVTs16f16z,
  MVE_VCVTs32f32_fix,
  MVE_VCVTs32f32a,
  MVE_VCVTs32f32m,
  MVE_VCVTs32f32n,
  MVE_VCVTs32f32p,
  MVE_VCVTs32f32z,
  MVE_VCVTu16f16_fix,
  MVE_VCVTu16f16a,
  MVE_VCVTu16f16m,
  MVE_VCVTu16f16n,
  MVE_VCVTu16f16p,
  MVE_VCVTu16f16z,
  MVE_VCVTu32f32_fix,
  MVE_VCVTu32f32a,
  MVE_VCVTu32f32m,
  MVE_VCVTu32f32n,
  MVE_VCVTu32f32p,
  MVE_VCVTu32f32z,
  MVE_VDDUPu16,
  MVE_VDDUPu32,
  MVE_VDDUPu8,
  MVE_VDUP16,
  MVE_VDUP32,
  MVE_VDUP8,
  MVE_VDWDUPu16,
  MVE_VDWDUPu32,
  MVE_VDWDUPu8,
  MVE_VEOR,
  MVE_VFMA_qr_Sf16,
  MVE_VFMA_qr_Sf32,
  MVE_VFMA_qr_f16,
  MVE_VFMA_qr_f32,
  MVE_VFMAf16,
  MVE_VFMAf32,
  MVE_VFMSf16,
  MVE_VFMSf32,
  MVE_VHADD_qr_s16,
  MVE_VHADD_qr_s32,
  MVE_VHADD_qr_s8,
  MVE_VHADD_qr_u16,
  MVE_VHADD_qr_u32,
  MVE_VHADD_qr_u8,
  MVE_VHADDs16,
  MVE_VHADDs32,
  MVE_VHADDs8,
  MVE_VHADDu16,
  MVE_VHADDu32,
  MVE_VHADDu8,
  MVE_VHCADDs16,
  MVE_VHCADDs32,
  MVE_VHCADDs8,
  MVE_VHSUB_qr_s16,
  MVE_VHSUB_qr_s32,
  MVE_VHSUB_qr_s8,
  MVE_VHSUB_qr_u16,
  MVE_VHSUB_qr_u32,
  MVE_VHSUB_qr_u8,
  MVE_VHSUBs16,
  MVE_VHSUBs32,
  MVE_VHSUBs8,
  MVE_VHSUBu16,
  MVE_VHSUBu32,
  MVE_VHSUBu8,
  MVE_VIDUPu16,
  MVE_VIDUPu32,
  MVE_VIDUPu8,
  MVE_VIWDUPu16,
  MVE_VIWDUPu32,
  MVE_VIWDUPu8,
  MVE_VLD20_16,
  MVE_VLD20_16_wb,
  MVE_VLD20_32,
  MVE_VLD20_32_wb,
  MVE_VLD20_8,
  MVE_VLD20_8_wb,
  MVE_VLD21_16,
  MVE_VLD21_16_wb,
  MVE_VLD21_32,
  MVE_VLD21_32_wb,
  MVE_VLD21_8,
  MVE_VLD21_8_wb,
  MVE_VLD40_16,
  MVE_VLD40_16_wb,
  MVE_VLD40_32,
  MVE_VLD40_32_wb,
  MVE_VLD40_8,
  MVE_VLD40_8_wb,
  MVE_VLD41_16,
  MVE_VLD41_16_wb,
  MVE_VLD41_32,
  MVE_VLD41_32_wb,
  MVE_VLD41_8,
  MVE_VLD41_8_wb,
  MVE_VLD42_16,
  MVE_VLD42_16_wb,
  MVE_VLD42_32,
  MVE_VLD42_32_wb,
  MVE_VLD42_8,
  MVE_VLD42_8_wb,
  MVE_VLD43_16,
  MVE_VLD43_16_wb,
  MVE_VLD43_32,
  MVE_VLD43_32_wb,
  MVE_VLD43_8,
  MVE_VLD43_8_wb,
  MVE_VLDRBS16,
  MVE_VLDRBS16_post,
  MVE_VLDRBS16_pre,
  MVE_VLDRBS16_rq,
  MVE_VLDRBS32,
  MVE_VLDRBS32_post,
  MVE_VLDRBS32_pre,
  MVE_VLDRBS32_rq,
  MVE_VLDRBU16,
  MVE_VLDRBU16_post,
  MVE_VLDRBU16_pre,
  MVE_VLDRBU16_rq,
  MVE_VLDRBU32,
  MVE_VLDRBU32_post,
  MVE_VLDRBU32_pre,
  MVE_VLDRBU32_rq,
  MVE_VLDRBU8,
  MVE_VLDRBU8_post,
  MVE_VLDRBU8_pre,
  MVE_VLDRBU8_rq,
  MVE_VLDRDU64_qi,
  MVE_VLDRDU64_qi_pre,
  MVE_VLDRDU64_rq,
  MVE_VLDRDU64_rq_u,
  MVE_VLDRHS32,
  MVE_VLDRHS32_post,
  MVE_VLDRHS32_pre,
  MVE_VLDRHS32_rq,
  MVE_VLDRHS32_rq_u,
  MVE_VLDRHU16,
  MVE_VLDRHU16_post,
  MVE_VLDRHU16_pre,
  MVE_VLDRHU16_rq,
  MVE_VLDRHU16_rq_u,
  MVE_VLDRHU32,
  MVE_VLDRHU32_post,
  MVE_VLDRHU32_pre,
  MVE_VLDRHU32_rq,
  MVE_VLDRHU32_rq_u,
  MVE_VLDRWU32,
  MVE_VLDRWU32_post,
  MVE_VLDRWU32_pre,
  MVE_VLDRWU32_qi,
  MVE_VLDRWU32_qi_pre,
  MVE_VLDRWU32_rq,
  MVE_VLDRWU32_rq_u,
  MVE_VMAXAVs16,
  MVE_VMAXAVs32,
  MVE_VMAXAVs8,
  MVE_VMAXAs16,
  MVE_VMAXAs32,
  MVE_VMAXAs8,
  MVE_VMAXNMAVf16,
  MVE_VMAXNMAVf32,
  MVE_VMAXNMAf16,
  MVE_VMAXNMAf32,
  MVE_VMAXNMVf16,
  MVE_VMAXNMVf32,
  MVE_VMAXNMf16,
  MVE_VMAXNMf32,
  MVE_VMAXVs16,
  MVE_VMAXVs32,
  MVE_VMAXVs8,
  MVE_VMAXVu16,
  MVE_VMAXVu32,
  MVE_VMAXVu8,
  MVE_VMAXs16,
  MVE_VMAXs32,
  MVE_VMAXs8,
  MVE_VMAXu16,
  MVE_VMAXu32,
  MVE_VMAXu8,
  MVE_VMINAVs16,
  MVE_VMINAVs32,
  MVE_VMINAVs8,
  MVE_VMINAs16,
  MVE_VMINAs32,
  MVE_VMINAs8,
  MVE_VMINNMAVf16,
  MVE_VMINNMAVf32,
  MVE_VMINNMAf16,
  MVE_VMINNMAf32,
  MVE_VMINNMVf16,
  MVE_VMINNMVf32,
  MVE_VMINNMf16,
  MVE_VMINNMf32,
  MVE_VMINVs16,
  MVE_VMINVs32,
  MVE_VMINVs8,
  MVE_VMINVu16,
  MVE_VMINVu32,
  MVE_VMINVu8,
  MVE_VMINs16,
  MVE_VMINs32,
  MVE_VMINs8,
  MVE_VMINu16,
  MVE_VMINu32,
  MVE_VMINu8,
  MVE_VMLADAVas16,
  MVE_VMLADAVas32,
  MVE_VMLADAVas8,
  MVE_VMLADAVau16,
  MVE_VMLADAVau32,
  MVE_VMLADAVau8,
  MVE_VMLADAVaxs16,
  MVE_VMLADAVaxs32,
  MVE_VMLADAVaxs8,
  MVE_VMLADAVs16,
  MVE_VMLADAVs32,
  MVE_VMLADAVs8,
  MVE_VMLADAVu16,
  MVE_VMLADAVu32,
  MVE_VMLADAVu8,
  MVE_VMLADAVxs16,
  MVE_VMLADAVxs32,
  MVE_VMLADAVxs8,
  MVE_VMLALDAVas16,
  MVE_VMLALDAVas32,
  MVE_VMLALDAVau16,
  MVE_VMLALDAVau32,
  MVE_VMLALDAVaxs16,
  MVE_VMLALDAVaxs32,
  MVE_VMLALDAVs16,
  MVE_VMLALDAVs32,
  MVE_VMLALDAVu16,
  MVE_VMLALDAVu32,
  MVE_VMLALDAVxs16,
  MVE_VMLALDAVxs32,
  MVE_VMLAS_qr_i16,
  MVE_VMLAS_qr_i32,
  MVE_VMLAS_qr_i8,
  MVE_VMLA_qr_i16,
  MVE_VMLA_qr_i32,
  MVE_VMLA_qr_i8,
  MVE_VMLSDAVas16,
  MVE_VMLSDAVas32,
  MVE_VMLSDAVas8,
  MVE_VMLSDAVaxs16,
  MVE_VMLSDAVaxs32,
  MVE_VMLSDAVaxs8,
  MVE_VMLSDAVs16,
  MVE_VMLSDAVs32,
  MVE_VMLSDAVs8,
  MVE_VMLSDAVxs16,
  MVE_VMLSDAVxs32,
  MVE_VMLSDAVxs8,
  MVE_VMLSLDAVas16,
  MVE_VMLSLDAVas32,
  MVE_VMLSLDAVaxs16,
  MVE_VMLSLDAVaxs32,
  MVE_VMLSLDAVs16,
  MVE_VMLSLDAVs32,
  MVE_VMLSLDAVxs16,
  MVE_VMLSLDAVxs32,
  MVE_VMOVLs16bh,
  MVE_VMOVLs16th,
  MVE_VMOVLs8bh,
  MVE_VMOVLs8th,
  MVE_VMOVLu16bh,
  MVE_VMOVLu16th,
  MVE_VMOVLu8bh,
  MVE_VMOVLu8th,
  MVE_VMOVNi16bh,
  MVE_VMOVNi16th,
  MVE_VMOVNi32bh,
  MVE_VMOVNi32th,
  MVE_VMOV_from_lane_32,
  MVE_VMOV_from_lane_s16,
  MVE_VMOV_from_lane_s8,
  MVE_VMOV_from_lane_u16,
  MVE_VMOV_from_lane_u8,
  MVE_VMOV_q_rr,
  MVE_VMOV_rr_q,
  MVE_VMOV_to_lane_16,
  MVE_VMOV_to_lane_32,
  MVE_VMOV_to_lane_8,
  MVE_VMOVimmf32,
  MVE_VMOVimmi16,
  MVE_VMOVimmi32,
  MVE_VMOVimmi64,
  MVE_VMOVimmi8,
  MVE_VMULHs16,
  MVE_VMULHs32,
  MVE_VMULHs8,
  MVE_VMULHu16,
  MVE_VMULHu32,
  MVE_VMULHu8,
  MVE_VMULLBp16,
  MVE_VMULLBp8,
  MVE_VMULLBs16,
  MVE_VMULLBs32,
  MVE_VMULLBs8,
  MVE_VMULLBu16,
  MVE_VMULLBu32,
  MVE_VMULLBu8,
  MVE_VMULLTp16,
  MVE_VMULLTp8,
  MVE_VMULLTs16,
  MVE_VMULLTs32,
  MVE_VMULLTs8,
  MVE_VMULLTu16,
  MVE_VMULLTu32,
  MVE_VMULLTu8,
  MVE_VMUL_qr_f16,
  MVE_VMUL_qr_f32,
  MVE_VMUL_qr_i16,
  MVE_VMUL_qr_i32,
  MVE_VMUL_qr_i8,
  MVE_VMULf16,
  MVE_VMULf32,
  MVE_VMULi16,
  MVE_VMULi32,
  MVE_VMULi8,
  MVE_VMVN,
  MVE_VMVNimmi16,
  MVE_VMVNimmi32,
  MVE_VNEGf16,
  MVE_VNEGf32,
  MVE_VNEGs16,
  MVE_VNEGs32,
  MVE_VNEGs8,
  MVE_VORN,
  MVE_VORR,
  MVE_VORRimmi16,
  MVE_VORRimmi32,
  MVE_VPNOT,
  MVE_VPSEL,
  MVE_VPST,
  MVE_VPTv16i8,
  MVE_VPTv16i8r,
  MVE_VPTv16s8,
  MVE_VPTv16s8r,
  MVE_VPTv16u8,
  MVE_VPTv16u8r,
  MVE_VPTv4f32,
  MVE_VPTv4f32r,
  MVE_VPTv4i32,
  MVE_VPTv4i32r,
  MVE_VPTv4s32,
  MVE_VPTv4s32r,
  MVE_VPTv4u32,
  MVE_VPTv4u32r,
  MVE_VPTv8f16,
  MVE_VPTv8f16r,
  MVE_VPTv8i16,
  MVE_VPTv8i16r,
  MVE_VPTv8s16,
  MVE_VPTv8s16r,
  MVE_VPTv8u16,
  MVE_VPTv8u16r,
  MVE_VQABSs16,
  MVE_VQABSs32,
  MVE_VQABSs8,
  MVE_VQADD_qr_s16,
  MVE_VQADD_qr_s32,
  MVE_VQADD_qr_s8,
  MVE_VQADD_qr_u16,
  MVE_VQADD_qr_u32,
  MVE_VQADD_qr_u8,
  MVE_VQADDs16,
  MVE_VQADDs32,
  MVE_VQADDs8,
  MVE_VQADDu16,
  MVE_VQADDu32,
  MVE_VQADDu8,
  MVE_VQDMLADHXs16,
  MVE_VQDMLADHXs32,
  MVE_VQDMLADHXs8,
  MVE_VQDMLADHs16,
  MVE_VQDMLADHs32,
  MVE_VQDMLADHs8,
  MVE_VQDMLAH_qrs16,
  MVE_VQDMLAH_qrs32,
  MVE_VQDMLAH_qrs8,
  MVE_VQDMLASH_qrs16,
  MVE_VQDMLASH_qrs32,
  MVE_VQDMLASH_qrs8,
  MVE_VQDMLSDHXs16,
  MVE_VQDMLSDHXs32,
  MVE_VQDMLSDHXs8,
  MVE_VQDMLSDHs16,
  MVE_VQDMLSDHs32,
  MVE_VQDMLSDHs8,
  MVE_VQDMULH_qr_s16,
  MVE_VQDMULH_qr_s32,
  MVE_VQDMULH_qr_s8,
  MVE_VQDMULHi16,
  MVE_VQDMULHi32,
  MVE_VQDMULHi8,
  MVE_VQDMULL_qr_s16bh,
  MVE_VQDMULL_qr_s16th,
  MVE_VQDMULL_qr_s32bh,
  MVE_VQDMULL_qr_s32th,
  MVE_VQDMULLs16bh,
  MVE_VQDMULLs16th,
  MVE_VQDMULLs32bh,
  MVE_VQDMULLs32th,
  MVE_VQMOVNs16bh,
  MVE_VQMOVNs16th,
  MVE_VQMOVNs32bh,
  MVE_VQMOVNs32th,
  MVE_VQMOVNu16bh,
  MVE_VQMOVNu16th,
  MVE_VQMOVNu32bh,
  MVE_VQMOVNu32th,
  MVE_VQMOVUNs16bh,
  MVE_VQMOVUNs16th,
  MVE_VQMOVUNs32bh,
  MVE_VQMOVUNs32th,
  MVE_VQNEGs16,
  MVE_VQNEGs32,
  MVE_VQNEGs8,
  MVE_VQRDMLADHXs16,
  MVE_VQRDMLADHXs32,
  MVE_VQRDMLADHXs8,
  MVE_VQRDMLADHs16,
  MVE_VQRDMLADHs32,
  MVE_VQRDMLADHs8,
  MVE_VQRDMLAH_qrs16,
  MVE_VQRDMLAH_qrs32,
  MVE_VQRDMLAH_qrs8,
  MVE_VQRDMLASH_qrs16,
  MVE_VQRDMLASH_qrs32,
  MVE_VQRDMLASH_qrs8,
  MVE_VQRDMLSDHXs16,
  MVE_VQRDMLSDHXs32,
  MVE_VQRDMLSDHXs8,
  MVE_VQRDMLSDHs16,
  MVE_VQRDMLSDHs32,
  MVE_VQRDMLSDHs8,
  MVE_VQRDMULH_qr_s16,
  MVE_VQRDMULH_qr_s32,
  MVE_VQRDMULH_qr_s8,
  MVE_VQRDMULHi16,
  MVE_VQRDMULHi32,
  MVE_VQRDMULHi8,
  MVE_VQRSHL_by_vecs16,
  MVE_VQRSHL_by_vecs32,
  MVE_VQRSHL_by_vecs8,
  MVE_VQRSHL_by_vecu16,
  MVE_VQRSHL_by_vecu32,
  MVE_VQRSHL_by_vecu8,
  MVE_VQRSHL_qrs16,
  MVE_VQRSHL_qrs32,
  MVE_VQRSHL_qrs8,
  MVE_VQRSHL_qru16,
  MVE_VQRSHL_qru32,
  MVE_VQRSHL_qru8,
  MVE_VQRSHRNbhs16,
  MVE_VQRSHRNbhs32,
  MVE_VQRSHRNbhu16,
  MVE_VQRSHRNbhu32,
  MVE_VQRSHRNths16,
  MVE_VQRSHRNths32,
  MVE_VQRSHRNthu16,
  MVE_VQRSHRNthu32,
  MVE_VQRSHRUNs16bh,
  MVE_VQRSHRUNs16th,
  MVE_VQRSHRUNs32bh,
  MVE_VQRSHRUNs32th,
  MVE_VQSHLU_imms16,
  MVE_VQSHLU_imms32,
  MVE_VQSHLU_imms8,
  MVE_VQSHL_by_vecs16,
  MVE_VQSHL_by_vecs32,
  MVE_VQSHL_by_vecs8,
  MVE_VQSHL_by_vecu16,
  MVE_VQSHL_by_vecu32,
  MVE_VQSHL_by_vecu8,
  MVE_VQSHL_qrs16,
  MVE_VQSHL_qrs32,
  MVE_VQSHL_qrs8,
  MVE_VQSHL_qru16,
  MVE_VQSHL_qru32,
  MVE_VQSHL_qru8,
  MVE_VQSHLimms16,
  MVE_VQSHLimms32,
  MVE_VQSHLimms8,
  MVE_VQSHLimmu16,
  MVE_VQSHLimmu32,
  MVE_VQSHLimmu8,
  MVE_VQSHRNbhs16,
  MVE_VQSHRNbhs32,
  MVE_VQSHRNbhu16,
  MVE_VQSHRNbhu32,
  MVE_VQSHRNths16,
  MVE_VQSHRNths32,
  MVE_VQSHRNthu16,
  MVE_VQSHRNthu32,
  MVE_VQSHRUNs16bh,
  MVE_VQSHRUNs16th,
  MVE_VQSHRUNs32bh,
  MVE_VQSHRUNs32th,
  MVE_VQSUB_qr_s16,
  MVE_VQSUB_qr_s32,
  MVE_VQSUB_qr_s8,
  MVE_VQSUB_qr_u16,
  MVE_VQSUB_qr_u32,
  MVE_VQSUB_qr_u8,
  MVE_VQSUBs16,
  MVE_VQSUBs32,
  MVE_VQSUBs8,
  MVE_VQSUBu16,
  MVE_VQSUBu32,
  MVE_VQSUBu8,
  MVE_VREV16_8,
  MVE_VREV32_16,
  MVE_VREV32_8,
  MVE_VREV64_16,
  MVE_VREV64_32,
  MVE_VREV64_8,
  MVE_VRHADDs16,
  MVE_VRHADDs32,
  MVE_VRHADDs8,
  MVE_VRHADDu16,
  MVE_VRHADDu32,
  MVE_VRHADDu8,
  MVE_VRINTf16A,
  MVE_VRINTf16M,
  MVE_VRINTf16N,
  MVE_VRINTf16P,
  MVE_VRINTf16X,
  MVE_VRINTf16Z,
  MVE_VRINTf32A,
  MVE_VRINTf32M,
  MVE_VRINTf32N,
  MVE_VRINTf32P,
  MVE_VRINTf32X,
  MVE_VRINTf32Z,
  MVE_VRMLALDAVHas32,
  MVE_VRMLALDAVHau32,
  MVE_VRMLALDAVHaxs32,
  MVE_VRMLALDAVHs32,
  MVE_VRMLALDAVHu32,
  MVE_VRMLALDAVHxs32,
  MVE_VRMLSLDAVHas32,
  MVE_VRMLSLDAVHaxs32,
  MVE_VRMLSLDAVHs32,
  MVE_VRMLSLDAVHxs32,
  MVE_VRMULHs16,
  MVE_VRMULHs32,
  MVE_VRMULHs8,
  MVE_VRMULHu16,
  MVE_VRMULHu32,
  MVE_VRMULHu8,
  MVE_VRSHL_by_vecs16,
  MVE_VRSHL_by_vecs32,
  MVE_VRSHL_by_vecs8,
  MVE_VRSHL_by_vecu16,
  MVE_VRSHL_by_vecu32,
  MVE_VRSHL_by_vecu8,
  MVE_VRSHL_qrs16,
  MVE_VRSHL_qrs32,
  MVE_VRSHL_qrs8,
  MVE_VRSHL_qru16,
  MVE_VRSHL_qru32,
  MVE_VRSHL_qru8,
  MVE_VRSHRNi16bh,
  MVE_VRSHRNi16th,
  MVE_VRSHRNi32bh,
  MVE_VRSHRNi32th,
  MVE_VRSHR_imms16,
  MVE_VRSHR_imms32,
  MVE_VRSHR_imms8,
  MVE_VRSHR_immu16,
  MVE_VRSHR_immu32,
  MVE_VRSHR_immu8,
  MVE_VSBC,
  MVE_VSBCI,
  MVE_VSHLC,
  MVE_VSHLL_imms16bh,
  MVE_VSHLL_imms16th,
  MVE_VSHLL_imms8bh,
  MVE_VSHLL_imms8th,
  MVE_VSHLL_immu16bh,
  MVE_VSHLL_immu16th,
  MVE_VSHLL_immu8bh,
  MVE_VSHLL_immu8th,
  MVE_VSHLL_lws16bh,
  MVE_VSHLL_lws16th,
  MVE_VSHLL_lws8bh,
  MVE_VSHLL_lws8th,
  MVE_VSHLL_lwu16bh,
  MVE_VSHLL_lwu16th,
  MVE_VSHLL_lwu8bh,
  MVE_VSHLL_lwu8th,
  MVE_VSHL_by_vecs16,
  MVE_VSHL_by_vecs32,
  MVE_VSHL_by_vecs8,
  MVE_VSHL_by_vecu16,
  MVE_VSHL_by_vecu32,
  MVE_VSHL_by_vecu8,
  MVE_VSHL_immi16,
  MVE_VSHL_immi32,
  MVE_VSHL_immi8,
  MVE_VSHL_qrs16,
  MVE_VSHL_qrs32,
  MVE_VSHL_qrs8,
  MVE_VSHL_qru16,
  MVE_VSHL_qru32,
  MVE_VSHL_qru8,
  MVE_VSHRNi16bh,
  MVE_VSHRNi16th,
  MVE_VSHRNi32bh,
  MVE_VSHRNi32th,
  MVE_VSHR_imms16,
  MVE_VSHR_imms32,
  MVE_VSHR_imms8,
  MVE_VSHR_immu16,
  MVE_VSHR_immu32,
  MVE_VSHR_immu8,
  MVE_VSLIimm16,
  MVE_VSLIimm32,
  MVE_VSLIimm8,
  MVE_VSRIimm16,
  MVE_VSRIimm32,
  MVE_VSRIimm8,
  MVE_VST20_16,
  MVE_VST20_16_wb,
  MVE_VST20_32,
  MVE_VST20_32_wb,
  MVE_VST20_8,
  MVE_VST20_8_wb,
  MVE_VST21_16,
  MVE_VST21_16_wb,
  MVE_VST21_32,
  MVE_VST21_32_wb,
  MVE_VST21_8,
  MVE_VST21_8_wb,
  MVE_VST40_16,
  MVE_VST40_16_wb,
  MVE_VST40_32,
  MVE_VST40_32_wb,
  MVE_VST40_8,
  MVE_VST40_8_wb,
  MVE_VST41_16,
  MVE_VST41_16_wb,
  MVE_VST41_32,
  MVE_VST41_32_wb,
  MVE_VST41_8,
  MVE_VST41_8_wb,
  MVE_VST42_16,
  MVE_VST42_16_wb,
  MVE_VST42_32,
  MVE_VST42_32_wb,
  MVE_VST42_8,
  MVE_VST42_8_wb,
  MVE_VST43_16,
  MVE_VST43_16_wb,
  MVE_VST43_32,
  MVE_VST43_32_wb,
  MVE_VST43_8,
  MVE_VST43_8_wb,
  MVE_VSTRB16,
  MVE_VSTRB16_post,
  MVE_VSTRB16_pre,
  MVE_VSTRB16_rq,
  MVE_VSTRB32,
  MVE_VSTRB32_post,
  MVE_VSTRB32_pre,
  MVE_VSTRB32_rq,
  MVE_VSTRB8_rq,
  MVE_VSTRBU8,
  MVE_VSTRBU8_post,
  MVE_VSTRBU8_pre,
  MVE_VSTRD64_qi,
  MVE_VSTRD64_qi_pre,
  MVE_VSTRD64_rq,
  MVE_VSTRD64_rq_u,
  MVE_VSTRH16_rq,
  MVE_VSTRH16_rq_u,
  MVE_VSTRH32,
  MVE_VSTRH32_post,
  MVE_VSTRH32_pre,
  MVE_VSTRH32_rq,
  MVE_VSTRH32_rq_u,
  MVE_VSTRHU16,
  MVE_VSTRHU16_post,
  MVE_VSTRHU16_pre,
  MVE_VSTRW32_qi,
  MVE_VSTRW32_qi_pre,
  MVE_VSTRW32_rq,
  MVE_VSTRW32_rq_u,
  MVE_VSTRWU32,
  MVE_VSTRWU32_post,
  MVE_VSTRWU32_pre,
  MVE_VSUB_qr_f16,
  MVE_VSUB_qr_f32,
  MVE_VSUB_qr_i16,
  MVE_VSUB_qr_i32,
  MVE_VSUB_qr_i8,
  MVE_VSUBf16,
  MVE_VSUBf32,
  MVE_VSUBi16,
  MVE_VSUBi32,
  MVE_VSUBi8,
  MVE_WLSTP_16,
  MVE_WLSTP_32,
  MVE_WLSTP_64,
  MVE_WLSTP_8,
  MVNi,
  MVNr,
  MVNsi,
  MVNsr,
  NEON_VMAXNMNDf,
  NEON_VMAXNMNDh,
  NEON_VMAXNMNQf,
  NEON_VMAXNMNQh,
  NEON_VMINNMNDf,
  NEON_VMINNMNDh,
  NEON_VMINNMNQf,
  NEON_VMINNMNQh,
  ORRri,
  ORRrr,
  ORRrsi,
  ORRrsr,
  PKHBT,
  PKHTB,
  PLDWi12,
  PLDWrs,
  PLDi12,
  PLDrs,
  PLIi12,
  PLIrs,
  QADD,
  QADD16,
  QADD8,
  QASX,
  QDADD,
  QDSUB,
  QSAX,
  QSUB,
  QSUB16,
  QSUB8,
  RBIT,
  REV,
  REV16,
  REVSH,
  RFEDA,
  RFEDA_UPD,
  RFEDB,
  RFEDB_UPD,
  RFEIA,
  RFEIA_UPD,
  RFEIB,
  RFEIB_UPD,
  RSBri,
  RSBrr,
  RSBrsi,
  RSBrsr,
  RSCri,
  RSCrr,
  RSCrsi,
  RSCrsr,
  SADD16,
  SADD8,
  SASX,
  SB,
  SBCri,
  SBCrr,
  SBCrsi,
  SBCrsr,
  SBFX,
  SDIV,
  SEL,
  SETEND,
  SETPAN,
  SHA1C,
  SHA1H,
  SHA1M,
  SHA1P,
  SHA1SU0,
  SHA1SU1,
  SHA256H,
  SHA256H2,
  SHA256SU0,
  SHA256SU1,
  SHADD16,
  SHADD8,
  SHASX,
  SHSAX,
  SHSUB16,
  SHSUB8,
  SMC,
  SMLABB,
  SMLABT,
  SMLAD,
  SMLADX,
  SMLAL,
  SMLALBB,
  SMLALBT,
  SMLALD,
  SMLALDX,
  SMLALTB,
  SMLALTT,
  SMLATB,
  SMLATT,
  SMLAWB,
  SMLAWT,
  SMLSD,
  SMLSDX,
  SMLSLD,
  SMLSLDX,
  SMMLA,
  SMMLAR,
  SMMLS,
  SMMLSR,
  SMMUL,
  SMMULR,
  SMUAD,
  SMUADX,
  SMULBB,
  SMULBT,
  SMULL,
  SMULTB,
  SMULTT,
  SMULWB,
  SMULWT,
  SMUSD,
  SMUSDX,
  SRSDA,
  SRSDA_UPD,
  SRSDB,
  SRSDB_UPD,
  SRSIA,
  SRSIA_UPD,
  SRSIB,
  SRSIB_UPD,
  SSAT,
  SSAT16,
  SSAX,
  SSUB16,
  SSUB8,
  STC2L_OFFSET,
  STC2L_OPTION,
  STC2L_POST,
  STC2L_PRE,
  STC2_OFFSET,
  STC2_OPTION,
  STC2_POST,
  STC2_PRE,
  STCL_OFFSET,
  STCL_OPTION,
  STCL_POST,
  STCL_PRE,
  STC_OFFSET,
  STC_OPTION,
  STC_POST,
  STC_PRE,
  STL,
  STLB,
  STLEX,
  STLEXB,
  STLEXD,
  STLEXH,
  STLH,
  STMDA,
  STMDA_UPD,
  STMDB,
  STMDB_UPD,
  STMIA,
  STMIA_UPD,
  STMIB,
  STMIB_UPD,
  STRBT_POST_IMM,
  STRBT_POST_REG,
  STRB_POST_IMM,
  STRB_POST_REG,
  STRB_PRE_IMM,
  STRB_PRE_REG,
  STRBi12,
  STRBrs,
  STRD,
  STRD_POST,
  STRD_PRE,
  STREX,
  STREXB,
  STREXD,
  STREXH,
  STRH,
  STRHTi,
  STRHTr,
  STRH_POST,
  STRH_PRE,
  STRT_POST_IMM,
  STRT_POST_REG,
  STR_POST_IMM,
  STR_POST_REG,
  STR_PRE_IMM,
  STR_PRE_REG,
  STRi12,
  STRrs,
  SUBri,
  SUBrr,
  SUBrsi,
  SUBrsr,
  SVC,
  SWP,
  SWPB,
  SXTAB,
  SXTAB16,
  SXTAH,
  SXTB,
  SXTB16,
  SXTH,
  TEQri,
  TEQrr,
  TEQrsi,
  TEQrsr,
  TRAP,
  TRAPNaCl,
  TSB,
  TSTri,
  TSTrr,
  TSTrsi,
  TSTrsr,
  UADD16,
  UADD8,
  UASX,
  UBFX,
  UDF,
  UDIV,
  UHADD16,
  UHADD8,
  UHASX,
  UHSAX,
  UHSUB16,
  UHSUB8,
  UMAAL,
  UMLAL,
  UMULL,
  UQADD16,
  UQADD8,
  UQASX,
  UQSAX,
  UQSUB16,
  UQSUB8,
  USAD8,
  USADA8,
  USAT,
  USAT16,
  USAX,
  USUB16,
  USUB8,
  UXTAB,
  UXTAB16,
  UXTAH,
  UXTB,
  UXTB16,
  UXTH,
  VABALsv2i64,
  VABALsv4i32,
  VABALsv8i16,
  VABALuv2i64,
  VABALuv4i32,
  VABALuv8i16,
  VABAsv16i8,
  VABAsv2i32,
  VABAsv4i16,
  VABAsv4i32,
  VABAsv8i16,
  VABAsv8i8,
  VABAuv16i8,
  VABAuv2i32,
  VABAuv4i16,
  VABAuv4i32,
  VABAuv8i16,
  VABAuv8i8,
  VABDLsv2i64,
  VABDLsv4i32,
  VABDLsv8i16,
  VABDLuv2i64,
  VABDLuv4i32,
  VABDLuv8i16,
  VABDfd,
  VABDfq,
  VABDhd,
  VABDhq,
  VABDsv16i8,
  VABDsv2i32,
  VABDsv4i16,
  VABDsv4i32,
  VABDsv8i16,
  VABDsv8i8,
  VABDuv16i8,
  VABDuv2i32,
  VABDuv4i16,
  VABDuv4i32,
  VABDuv8i16,
  VABDuv8i8,
  VABSD,
  VABSH,
  VABSS,
  VABSfd,
  VABSfq,
  VABShd,
  VABShq,
  VABSv16i8,
  VABSv2i32,
  VABSv4i16,
  VABSv4i32,
  VABSv8i16,
  VABSv8i8,
  VACGEfd,
  VACGEfq,
  VACGEhd,
  VACGEhq,
  VACGTfd,
  VACGTfq,
  VACGThd,
  VACGThq,
  VADDD,
  VADDH,
  VADDHNv2i32,
  VADDHNv4i16,
  VADDHNv8i8,
  VADDLsv2i64,
  VADDLsv4i32,
  VADDLsv8i16,
  VADDLuv2i64,
  VADDLuv4i32,
  VADDLuv8i16,
  VADDS,
  VADDWsv2i64,
  VADDWsv4i32,
  VADDWsv8i16,
  VADDWuv2i64,
  VADDWuv4i32,
  VADDWuv8i16,
  VADDfd,
  VADDfq,
  VADDhd,
  VADDhq,
  VADDv16i8,
  VADDv1i64,
  VADDv2i32,
  VADDv2i64,
  VADDv4i16,
  VADDv4i32,
  VADDv8i16,
  VADDv8i8,
  VANDd,
  VANDq,
  VBF16MALBQ,
  VBF16MALBQI,
  VBF16MALTQ,
  VBF16MALTQI,
  VBICd,
  VBICiv2i32,
  VBICiv4i16,
  VBICiv4i32,
  VBICiv8i16,
  VBICq,
  VBIFd,
  VBIFq,
  VBITd,
  VBITq,
  VBSLd,
  VBSLq,
  VBSPd,
  VBSPq,
  VCADDv2f32,
  VCADDv4f16,
  VCADDv4f32,
  VCADDv8f16,
  VCEQfd,
  VCEQfq,
  VCEQhd,
  VCEQhq,
  VCEQv16i8,
  VCEQv2i32,
  VCEQv4i16,
  VCEQv4i32,
  VCEQv8i16,
  VCEQv8i8,
  VCEQzv16i8,
  VCEQzv2f32,
  VCEQzv2i32,
  VCEQzv4f16,
  VCEQzv4f32,
  VCEQzv4i16,
  VCEQzv4i32,
  VCEQzv8f16,
  VCEQzv8i16,
  VCEQzv8i8,
  VCGEfd,
  VCGEfq,
  VCGEhd,
  VCGEhq,
  VCGEsv16i8,
  VCGEsv2i32,
  VCGEsv4i16,
  VCGEsv4i32,
  VCGEsv8i16,
  VCGEsv8i8,
  VCGEuv16i8,
  VCGEuv2i32,
  VCGEuv4i16,
  VCGEuv4i32,
  VCGEuv8i16,
  VCGEuv8i8,
  VCGEzv16i8,
  VCGEzv2f32,
  VCGEzv2i32,
  VCGEzv4f16,
  VCGEzv4f32,
  VCGEzv4i16,
  VCGEzv4i32,
  VCGEzv8f16,
  VCGEzv8i16,
  VCGEzv8i8,
  VCGTfd,
  VCGTfq,
  VCGThd,
  VCGThq,
  VCGTsv16i8,
  VCGTsv2i32,
  VCGTsv4i16,
  VCGTsv4i32,
  VCGTsv8i16,
  VCGTsv8i8,
  VCGTuv16i8,
  VCGTuv2i32,
  VCGTuv4i16,
  VCGTuv4i32,
  VCGTuv8i16,
  VCGTuv8i8,
  VCGTzv16i8,
  VCGTzv2f32,
  VCGTzv2i32,
  VCGTzv4f16,
  VCGTzv4f32,
  VCGTzv4i16,
  VCGTzv4i32,
  VCGTzv8f16,
  VCGTzv8i16,
  VCGTzv8i8,
  VCLEzv16i8,
  VCLEzv2f32,
  VCLEzv2i32,
  VCLEzv4f16,
  VCLEzv4f32,
  VCLEzv4i16,
  VCLEzv4i32,
  VCLEzv8f16,
  VCLEzv8i16,
  VCLEzv8i8,
  VCLSv16i8,
  VCLSv2i32,
  VCLSv4i16,
  VCLSv4i32,
  VCLSv8i16,
  VCLSv8i8,
  VCLTzv16i8,
  VCLTzv2f32,
  VCLTzv2i32,
  VCLTzv4f16,
  VCLTzv4f32,
  VCLTzv4i16,
  VCLTzv4i32,
  VCLTzv8f16,
  VCLTzv8i16,
  VCLTzv8i8,
  VCLZv16i8,
  VCLZv2i32,
  VCLZv4i16,
  VCLZv4i32,
  VCLZv8i16,
  VCLZv8i8,
  VCMLAv2f32,
  VCMLAv2f32_indexed,
  VCMLAv4f16,
  VCMLAv4f16_indexed,
  VCMLAv4f32,
  VCMLAv4f32_indexed,
  VCMLAv8f16,
  VCMLAv8f16_indexed,
  VCMPD,
  VCMPED,
  VCMPEH,
  VCMPES,
  VCMPEZD,
  VCMPEZH,
  VCMPEZS,
  VCMPH,
  VCMPS,
  VCMPZD,
  VCMPZH,
  VCMPZS,
  VCNTd,
  VCNTq,
  VCVTANSDf,
  VCVTANSDh,
  VCVTANSQf,
  VCVTANSQh,
  VCVTANUDf,
  VCVTANUDh,
  VCVTANUQf,
  VCVTANUQh,
  VCVTASD,
  VCVTASH,
  VCVTASS,
  VCVTAUD,
  VCVTAUH,
  VCVTAUS,
  VCVTBDH,
  VCVTBHD,
  VCVTBHS,
  VCVTBSH,
  VCVTDS,
  VCVTMNSDf,
  VCVTMNSDh,
  VCVTMNSQf,
  VCVTMNSQh,
  VCVTMNUDf,
  VCVTMNUDh,
  VCVTMNUQf,
  VCVTMNUQh,
  VCVTMSD,
  VCVTMSH,
  VCVTMSS,
  VCVTMUD,
  VCVTMUH,
  VCVTMUS,
  VCVTNNSDf,
  VCVTNNSDh,
  VCVTNNSQf,
  VCVTNNSQh,
  VCVTNNUDf,
  VCVTNNUDh,
  VCVTNNUQf,
  VCVTNNUQh,
  VCVTNSD,
  VCVTNSH,
  VCVTNSS,
  VCVTNUD,
  VCVTNUH,
  VCVTNUS,
  VCVTPNSDf,
  VCVTPNSDh,
  VCVTPNSQf,
  VCVTPNSQh,
  VCVTPNUDf,
  VCVTPNUDh,
  VCVTPNUQf,
  VCVTPNUQh,
  VCVTPSD,
  VCVTPSH,
  VCVTPSS,
  VCVTPUD,
  VCVTPUH,
  VCVTPUS,
  VCVTSD,
  VCVTTDH,
  VCVTTHD,
  VCVTTHS,
  VCVTTSH,
  VCVTf2h,
  VCVTf2sd,
  VCVTf2sq,
  VCVTf2ud,
  VCVTf2uq,
  VCVTf2xsd,
  VCVTf2xsq,
  VCVTf2xud,
  VCVTf2xuq,
  VCVTh2f,
  VCVTh2sd,
  VCVTh2sq,
  VCVTh2ud,
  VCVTh2uq,
  VCVTh2xsd,
  VCVTh2xsq,
  VCVTh2xud,
  VCVTh2xuq,
  VCVTs2fd,
  VCVTs2fq,
  VCVTs2hd,
  VCVTs2hq,
  VCVTu2fd,
  VCVTu2fq,
  VCVTu2hd,
  VCVTu2hq,
  VCVTxs2fd,
  VCVTxs2fq,
  VCVTxs2hd,
  VCVTxs2hq,
  VCVTxu2fd,
  VCVTxu2fq,
  VCVTxu2hd,
  VCVTxu2hq,
  VDIVD,
  VDIVH,
  VDIVS,
  VDUP16d,
  VDUP16q,
  VDUP32d,
  VDUP32q,
  VDUP8d,
  VDUP8q,
  VDUPLN16d,
  VDUPLN16q,
  VDUPLN32d,
  VDUPLN32q,
  VDUPLN8d,
  VDUPLN8q,
  VEORd,
  VEORq,
  VEXTd16,
  VEXTd32,
  VEXTd8,
  VEXTq16,
  VEXTq32,
  VEXTq64,
  VEXTq8,
  VFMAD,
  VFMAH,
  VFMALD,
  VFMALDI,
  VFMALQ,
  VFMALQI,
  VFMAS,
  VFMAfd,
  VFMAfq,
  VFMAhd,
  VFMAhq,
  VFMSD,
  VFMSH,
  VFMSLD,
  VFMSLDI,
  VFMSLQ,
  VFMSLQI,
  VFMSS,
  VFMSfd,
  VFMSfq,
  VFMShd,
  VFMShq,
  VFNMAD,
  VFNMAH,
  VFNMAS,
  VFNMSD,
  VFNMSH,
  VFNMSS,
  VFP_VMAXNMD,
  VFP_VMAXNMH,
  VFP_VMAXNMS,
  VFP_VMINNMD,
  VFP_VMINNMH,
  VFP_VMINNMS,
  VGETLNi32,
  VGETLNs16,
  VGETLNs8,
  VGETLNu16,
  VGETLNu8,
  VHADDsv16i8,
  VHADDsv2i32,
  VHADDsv4i16,
  VHADDsv4i32,
  VHADDsv8i16,
  VHADDsv8i8,
  VHADDuv16i8,
  VHADDuv2i32,
  VHADDuv4i16,
  VHADDuv4i32,
  VHADDuv8i16,
  VHADDuv8i8,
  VHSUBsv16i8,
  VHSUBsv2i32,
  VHSUBsv4i16,
  VHSUBsv4i32,
  VHSUBsv8i16,
  VHSUBsv8i8,
  VHSUBuv16i8,
  VHSUBuv2i32,
  VHSUBuv4i16,
  VHSUBuv4i32,
  VHSUBuv8i16,
  VHSUBuv8i8,
  VINSH,
  VJCVT,
  VLD1DUPd16,
  VLD1DUPd16wb_fixed,
  VLD1DUPd16wb_register,
  VLD1DUPd32,
  VLD1DUPd32wb_fixed,
  VLD1DUPd32wb_register,
  VLD1DUPd8,
  VLD1DUPd8wb_fixed,
  VLD1DUPd8wb_register,
  VLD1DUPq16,
  VLD1DUPq16wb_fixed,
  VLD1DUPq16wb_register,
  VLD1DUPq32,
  VLD1DUPq32wb_fixed,
  VLD1DUPq32wb_register,
  VLD1DUPq8,
  VLD1DUPq8wb_fixed,
  VLD1DUPq8wb_register,
  VLD1LNd16,
  VLD1LNd16_UPD,
  VLD1LNd32,
  VLD1LNd32_UPD,
  VLD1LNd8,
  VLD1LNd8_UPD,
  VLD1LNq16Pseudo,
  VLD1LNq16Pseudo_UPD,
  VLD1LNq32Pseudo,
  VLD1LNq32Pseudo_UPD,
  VLD1LNq8Pseudo,
  VLD1LNq8Pseudo_UPD,
  VLD1d16,
  VLD1d16Q,
  VLD1d16QPseudo,
  VLD1d16QPseudoWB_fixed,
  VLD1d16QPseudoWB_register,
  VLD1d16Qwb_fixed,
  VLD1d16Qwb_register,
  VLD1d16T,
  VLD1d16TPseudo,
  VLD1d16TPseudoWB_fixed,
  VLD1d16TPseudoWB_register,
  VLD1d16Twb_fixed,
  VLD1d16Twb_register,
  VLD1d16wb_fixed,
  VLD1d16wb_register,
  VLD1d32,
  VLD1d32Q,
  VLD1d32QPseudo,
  VLD1d32QPseudoWB_fixed,
  VLD1d32QPseudoWB_register,
  VLD1d32Qwb_fixed,
  VLD1d32Qwb_register,
  VLD1d32T,
  VLD1d32TPseudo,
  VLD1d32TPseudoWB_fixed,
  VLD1d32TPseudoWB_register,
  VLD1d32Twb_fixed,
  VLD1d32Twb_register,
  VLD1d32wb_fixed,
  VLD1d32wb_register,
  VLD1d64,
  VLD1d64Q,
  VLD1d64QPseudo,
  VLD1d64QPseudoWB_fixed,
  VLD1d64QPseudoWB_register,
  VLD1d64Qwb_fixed,
  VLD1d64Qwb_register,
  VLD1d64T,
  VLD1d64TPseudo,
  VLD1d64TPseudoWB_fixed,
  VLD1d64TPseudoWB_register,
  VLD1d64Twb_fixed,
  VLD1d64Twb_register,
  VLD1d64wb_fixed,
  VLD1d64wb_register,
  VLD1d8,
  VLD1d8Q,
  VLD1d8QPseudo,
  VLD1d8QPseudoWB_fixed,
  VLD1d8QPseudoWB_register,
  VLD1d8Qwb_fixed,
  VLD1d8Qwb_register,
  VLD1d8T,
  VLD1d8TPseudo,
  VLD1d8TPseudoWB_fixed,
  VLD1d8TPseudoWB_register,
  VLD1d8Twb_fixed,
  VLD1d8Twb_register,
  VLD1d8wb_fixed,
  VLD1d8wb_register,
  VLD1q16,
  VLD1q16HighQPseudo,
  VLD1q16HighQPseudo_UPD,
  VLD1q16HighTPseudo,
  VLD1q16HighTPseudo_UPD,
  VLD1q16LowQPseudo_UPD,
  VLD1q16LowTPseudo_UPD,
  VLD1q16wb_fixed,
  VLD1q16wb_register,
  VLD1q32,
  VLD1q32HighQPseudo,
  VLD1q32HighQPseudo_UPD,
  VLD1q32HighTPseudo,
  VLD1q32HighTPseudo_UPD,
  VLD1q32LowQPseudo_UPD,
  VLD1q32LowTPseudo_UPD,
  VLD1q32wb_fixed,
  VLD1q32wb_register,
  VLD1q64,
  VLD1q64HighQPseudo,
  VLD1q64HighQPseudo_UPD,
  VLD1q64HighTPseudo,
  VLD1q64HighTPseudo_UPD,
  VLD1q64LowQPseudo_UPD,
  VLD1q64LowTPseudo_UPD,
  VLD1q64wb_fixed,
  VLD1q64wb_register,
  VLD1q8,
  VLD1q8HighQPseudo,
  VLD1q8HighQPseudo_UPD,
  VLD1q8HighTPseudo,
  VLD1q8HighTPseudo_UPD,
  VLD1q8LowQPseudo_UPD,
  VLD1q8LowTPseudo_UPD,
  VLD1q8wb_fixed,
  VLD1q8wb_register,
  VLD2DUPd16,
  VLD2DUPd16wb_fixed,
  VLD2DUPd16wb_register,
  VLD2DUPd16x2,
  VLD2DUPd16x2wb_fixed,
  VLD2DUPd16x2wb_register,
  VLD2DUPd32,
  VLD2DUPd32wb_fixed,
  VLD2DUPd32wb_register,
  VLD2DUPd32x2,
  VLD2DUPd32x2wb_fixed,
  VLD2DUPd32x2wb_register,
  VLD2DUPd8,
  VLD2DUPd8wb_fixed,
  VLD2DUPd8wb_register,
  VLD2DUPd8x2,
  VLD2DUPd8x2wb_fixed,
  VLD2DUPd8x2wb_register,
  VLD2DUPq16EvenPseudo,
  VLD2DUPq16OddPseudo,
  VLD2DUPq16OddPseudoWB_fixed,
  VLD2DUPq16OddPseudoWB_register,
  VLD2DUPq32EvenPseudo,
  VLD2DUPq32OddPseudo,
  VLD2DUPq32OddPseudoWB_fixed,
  VLD2DUPq32OddPseudoWB_register,
  VLD2DUPq8EvenPseudo,
  VLD2DUPq8OddPseudo,
  VLD2DUPq8OddPseudoWB_fixed,
  VLD2DUPq8OddPseudoWB_register,
  VLD2LNd16,
  VLD2LNd16Pseudo,
  VLD2LNd16Pseudo_UPD,
  VLD2LNd16_UPD,
  VLD2LNd32,
  VLD2LNd32Pseudo,
  VLD2LNd32Pseudo_UPD,
  VLD2LNd32_UPD,
  VLD2LNd8,
  VLD2LNd8Pseudo,
  VLD2LNd8Pseudo_UPD,
  VLD2LNd8_UPD,
  VLD2LNq16,
  VLD2LNq16Pseudo,
  VLD2LNq16Pseudo_UPD,
  VLD2LNq16_UPD,
  VLD2LNq32,
  VLD2LNq32Pseudo,
  VLD2LNq32Pseudo_UPD,
  VLD2LNq32_UPD,
  VLD2b16,
  VLD2b16wb_fixed,
  VLD2b16wb_register,
  VLD2b32,
  VLD2b32wb_fixed,
  VLD2b32wb_register,
  VLD2b8,
  VLD2b8wb_fixed,
  VLD2b8wb_register,
  VLD2d16,
  VLD2d16wb_fixed,
  VLD2d16wb_register,
  VLD2d32,
  VLD2d32wb_fixed,
  VLD2d32wb_register,
  VLD2d8,
  VLD2d8wb_fixed,
  VLD2d8wb_register,
  VLD2q16,
  VLD2q16Pseudo,
  VLD2q16PseudoWB_fixed,
  VLD2q16PseudoWB_register,
  VLD2q16wb_fixed,
  VLD2q16wb_register,
  VLD2q32,
  VLD2q32Pseudo,
  VLD2q32PseudoWB_fixed,
  VLD2q32PseudoWB_register,
  VLD2q32wb_fixed,
  VLD2q32wb_register,
  VLD2q8,
  VLD2q8Pseudo,
  VLD2q8PseudoWB_fixed,
  VLD2q8PseudoWB_register,
  VLD2q8wb_fixed,
  VLD2q8wb_register,
  VLD3DUPd16,
  VLD3DUPd16Pseudo,
  VLD3DUPd16Pseudo_UPD,
  VLD3DUPd16_UPD,
  VLD3DUPd32,
  VLD3DUPd32Pseudo,
  VLD3DUPd32Pseudo_UPD,
  VLD3DUPd32_UPD,
  VLD3DUPd8,
  VLD3DUPd8Pseudo,
  VLD3DUPd8Pseudo_UPD,
  VLD3DUPd8_UPD,
  VLD3DUPq16,
  VLD3DUPq16EvenPseudo,
  VLD3DUPq16OddPseudo,
  VLD3DUPq16OddPseudo_UPD,
  VLD3DUPq16_UPD,
  VLD3DUPq32,
  VLD3DUPq32EvenPseudo,
  VLD3DUPq32OddPseudo,
  VLD3DUPq32OddPseudo_UPD,
  VLD3DUPq32_UPD,
  VLD3DUPq8,
  VLD3DUPq8EvenPseudo,
  VLD3DUPq8OddPseudo,
  VLD3DUPq8OddPseudo_UPD,
  VLD3DUPq8_UPD,
  VLD3LNd16,
  VLD3LNd16Pseudo,
  VLD3LNd16Pseudo_UPD,
  VLD3LNd16_UPD,
  VLD3LNd32,
  VLD3LNd32Pseudo,
  VLD3LNd32Pseudo_UPD,
  VLD3LNd32_UPD,
  VLD3LNd8,
  VLD3LNd8Pseudo,
  VLD3LNd8Pseudo_UPD,
  VLD3LNd8_UPD,
  VLD3LNq16,
  VLD3LNq16Pseudo,
  VLD3LNq16Pseudo_UPD,
  VLD3LNq16_UPD,
  VLD3LNq32,
  VLD3LNq32Pseudo,
  VLD3LNq32Pseudo_UPD,
  VLD3LNq32_UPD,
  VLD3d16,
  VLD3d16Pseudo,
  VLD3d16Pseudo_UPD,
  VLD3d16_UPD,
  VLD3d32,
  VLD3d32Pseudo,
  VLD3d32Pseudo_UPD,
  VLD3d32_UPD,
  VLD3d8,
  VLD3d8Pseudo,
  VLD3d8Pseudo_UPD,
  VLD3d8_UPD,
  VLD3q16,
  VLD3q16Pseudo_UPD,
  VLD3q16_UPD,
  VLD3q16oddPseudo,
  VLD3q16oddPseudo_UPD,
  VLD3q32,
  VLD3q32Pseudo_UPD,
  VLD3q32_UPD,
  VLD3q32oddPseudo,
  VLD3q32oddPseudo_UPD,
  VLD3q8,
  VLD3q8Pseudo_UPD,
  VLD3q8_UPD,
  VLD3q8oddPseudo,
  VLD3q8oddPseudo_UPD,
  VLD4DUPd16,
  VLD4DUPd16Pseudo,
  VLD4DUPd16Pseudo_UPD,
  VLD4DUPd16_UPD,
  VLD4DUPd32,
  VLD4DUPd32Pseudo,
  VLD4DUPd32Pseudo_UPD,
  VLD4DUPd32_UPD,
  VLD4DUPd8,
  VLD4DUPd8Pseudo,
  VLD4DUPd8Pseudo_UPD,
  VLD4DUPd8_UPD,
  VLD4DUPq16,
  VLD4DUPq16EvenPseudo,
  VLD4DUPq16OddPseudo,
  VLD4DUPq16OddPseudo_UPD,
  VLD4DUPq16_UPD,
  VLD4DUPq32,
  VLD4DUPq32EvenPseudo,
  VLD4DUPq32OddPseudo,
  VLD4DUPq32OddPseudo_UPD,
  VLD4DUPq32_UPD,
  VLD4DUPq8,
  VLD4DUPq8EvenPseudo,
  VLD4DUPq8OddPseudo,
  VLD4DUPq8OddPseudo_UPD,
  VLD4DUPq8_UPD,
  VLD4LNd16,
  VLD4LNd16Pseudo,
  VLD4LNd16Pseudo_UPD,
  VLD4LNd16_UPD,
  VLD4LNd32,
  VLD4LNd32Pseudo,
  VLD4LNd32Pseudo_UPD,
  VLD4LNd32_UPD,
  VLD4LNd8,
  VLD4LNd8Pseudo,
  VLD4LNd8Pseudo_UPD,
  VLD4LNd8_UPD,
  VLD4LNq16,
  VLD4LNq16Pseudo,
  VLD4LNq16Pseudo_UPD,
  VLD4LNq16_UPD,
  VLD4LNq32,
  VLD4LNq32Pseudo,
  VLD4LNq32Pseudo_UPD,
  VLD4LNq32_UPD,
  VLD4d16,
  VLD4d16Pseudo,
  VLD4d16Pseudo_UPD,
  VLD4d16_UPD,
  VLD4d32,
  VLD4d32Pseudo,
  VLD4d32Pseudo_UPD,
  VLD4d32_UPD,
  VLD4d8,
  VLD4d8Pseudo,
  VLD4d8Pseudo_UPD,
  VLD4d8_UPD,
  VLD4q16,
  VLD4q16Pseudo_UPD,
  VLD4q16_UPD,
  VLD4q16oddPseudo,
  VLD4q16oddPseudo_UPD,
  VLD4q32,
  VLD4q32Pseudo_UPD,
  VLD4q32_UPD,
  VLD4q32oddPseudo,
  VLD4q32oddPseudo_UPD,
  VLD4q8,
  VLD4q8Pseudo_UPD,
  VLD4q8_UPD,
  VLD4q8oddPseudo,
  VLD4q8oddPseudo_UPD,
  VLDMDDB_UPD,
  VLDMDIA,
  VLDMDIA_UPD,
  VLDMQIA,
  VLDMSDB_UPD,
  VLDMSIA,
  VLDMSIA_UPD,
  VLDRD,
  VLDRH,
  VLDRS,
  VLDR_FPCXTNS_off,
  VLDR_FPCXTNS_post,
  VLDR_FPCXTNS_pre,
  VLDR_FPCXTS_off,
  VLDR_FPCXTS_post,
  VLDR_FPCXTS_pre,
  VLDR_FPSCR_NZCVQC_off,
  VLDR_FPSCR_NZCVQC_post,
  VLDR_FPSCR_NZCVQC_pre,
  VLDR_FPSCR_off,
  VLDR_FPSCR_post,
  VLDR_FPSCR_pre,
  VLDR_P0_off,
  VLDR_P0_post,
  VLDR_P0_pre,
  VLDR_VPR_off,
  VLDR_VPR_post,
  VLDR_VPR_pre,
  VLLDM,
  VLLDM_T2,
  VLSTM,
  VLSTM_T2,
  VMAXfd,
  VMAXfq,
  VMAXhd,
  VMAXhq,
  VMAXsv16i8,
  VMAXsv2i32,
  VMAXsv4i16,
  VMAXsv4i32,
  VMAXsv8i16,
  VMAXsv8i8,
  VMAXuv16i8,
  VMAXuv2i32,
  VMAXuv4i16,
  VMAXuv4i32,
  VMAXuv8i16,
  VMAXuv8i8,
  VMINfd,
  VMINfq,
  VMINhd,
  VMINhq,
  VMINsv16i8,
  VMINsv2i32,
  VMINsv4i16,
  VMINsv4i32,
  VMINsv8i16,
  VMINsv8i8,
  VMINuv16i8,
  VMINuv2i32,
  VMINuv4i16,
  VMINuv4i32,
  VMINuv8i16,
  VMINuv8i8,
  VMLAD,
  VMLAH,
  VMLALslsv2i32,
  VMLALslsv4i16,
  VMLALsluv2i32,
  VMLALsluv4i16,
  VMLALsv2i64,
  VMLALsv4i32,
  VMLALsv8i16,
  VMLALuv2i64,
  VMLALuv4i32,
  VMLALuv8i16,
  VMLAS,
  VMLAfd,
  VMLAfq,
  VMLAhd,
  VMLAhq,
  VMLAslfd,
  VMLAslfq,
  VMLAslhd,
  VMLAslhq,
  VMLAslv2i32,
  VMLAslv4i16,
  VMLAslv4i32,
  VMLAslv8i16,
  VMLAv16i8,
  VMLAv2i32,
  VMLAv4i16,
  VMLAv4i32,
  VMLAv8i16,
  VMLAv8i8,
  VMLSD,
  VMLSH,
  VMLSLslsv2i32,
  VMLSLslsv4i16,
  VMLSLsluv2i32,
  VMLSLsluv4i16,
  VMLSLsv2i64,
  VMLSLsv4i32,
  VMLSLsv8i16,
  VMLSLuv2i64,
  VMLSLuv4i32,
  VMLSLuv8i16,
  VMLSS,
  VMLSfd,
  VMLSfq,
  VMLShd,
  VMLShq,
  VMLSslfd,
  VMLSslfq,
  VMLSslhd,
  VMLSslhq,
  VMLSslv2i32,
  VMLSslv4i16,
  VMLSslv4i32,
  VMLSslv8i16,
  VMLSv16i8,
  VMLSv2i32,
  VMLSv4i16,
  VMLSv4i32,
  VMLSv8i16,
  VMLSv8i8,
  VMMLA,
  VMOVD,
  VMOVDRR,
  VMOVH,
  VMOVHR,
  VMOVLsv2i64,
  VMOVLsv4i32,
  VMOVLsv8i16,
  VMOVLuv2i64,
  VMOVLuv4i32,
  VMOVLuv8i16,
  VMOVNv2i32,
  VMOVNv4i16,
  VMOVNv8i8,
  VMOVRH,
  VMOVRRD,
  VMOVRRS,
  VMOVRS,
  VMOVS,
  VMOVSR,
  VMOVSRR,
  VMOVv16i8,
  VMOVv1i64,
  VMOVv2f32,
  VMOVv2i32,
  VMOVv2i64,
  VMOVv4f32,
  VMOVv4i16,
  VMOVv4i32,
  VMOVv8i16,
  VMOVv8i8,
  VMRS,
  VMRS_FPCXTNS,
  VMRS_FPCXTS,
  VMRS_FPEXC,
  VMRS_FPINST,
  VMRS_FPINST2,
  VMRS_FPSCR_NZCVQC,
  VMRS_FPSID,
  VMRS_MVFR0,
  VMRS_MVFR1,
  VMRS_MVFR2,
  VMRS_P0,
  VMRS_VPR,
  VMSR,
  VMSR_FPCXTNS,
  VMSR_FPCXTS,
  VMSR_FPEXC,
  VMSR_FPINST,
  VMSR_FPINST2,
  VMSR_FPSCR_NZCVQC,
  VMSR_FPSID,
  VMSR_P0,
  VMSR_VPR,
  VMULD,
  VMULH,
  VMULLp64,
  VMULLp8,
  VMULLslsv2i32,
  VMULLslsv4i16,
  VMULLsluv2i32,
  VMULLsluv4i16,
  VMULLsv2i64,
  VMULLsv4i32,
  VMULLsv8i16,
  VMULLuv2i64,
  VMULLuv4i32,
  VMULLuv8i16,
  VMULS,
  VMULfd,
  VMULfq,
  VMULhd,
  VMULhq,
  VMULpd,
  VMULpq,
  VMULslfd,
  VMULslfq,
  VMULslhd,
  VMULslhq,
  VMULslv2i32,
  VMULslv4i16,
  VMULslv4i32,
  VMULslv8i16,
  VMULv16i8,
  VMULv2i32,
  VMULv4i16,
  VMULv4i32,
  VMULv8i16,
  VMULv8i8,
  VMVNd,
  VMVNq,
  VMVNv2i32,
  VMVNv4i16,
  VMVNv4i32,
  VMVNv8i16,
  VNEGD,
  VNEGH,
  VNEGS,
  VNEGf32q,
  VNEGfd,
  VNEGhd,
  VNEGhq,
  VNEGs16d,
  VNEGs16q,
  VNEGs32d,
  VNEGs32q,
  VNEGs8d,
  VNEGs8q,
  VNMLAD,
  VNMLAH,
  VNMLAS,
  VNMLSD,
  VNMLSH,
  VNMLSS,
  VNMULD,
  VNMULH,
  VNMULS,
  VORNd,
  VORNq,
  VORRd,
  VORRiv2i32,
  VORRiv4i16,
  VORRiv4i32,
  VORRiv8i16,
  VORRq,
  VPADALsv16i8,
  VPADALsv2i32,
  VPADALsv4i16,
  VPADALsv4i32,
  VPADALsv8i16,
  VPADALsv8i8,
  VPADALuv16i8,
  VPADALuv2i32,
  VPADALuv4i16,
  VPADALuv4i32,
  VPADALuv8i16,
  VPADALuv8i8,
  VPADDLsv16i8,
  VPADDLsv2i32,
  VPADDLsv4i16,
  VPADDLsv4i32,
  VPADDLsv8i16,
  VPADDLsv8i8,
  VPADDLuv16i8,
  VPADDLuv2i32,
  VPADDLuv4i16,
  VPADDLuv4i32,
  VPADDLuv8i16,
  VPADDLuv8i8,
  VPADDf,
  VPADDh,
  VPADDi16,
  VPADDi32,
  VPADDi8,
  VPMAXf,
  VPMAXh,
  VPMAXs16,
  VPMAXs32,
  VPMAXs8,
  VPMAXu16,
  VPMAXu32,
  VPMAXu8,
  VPMINf,
  VPMINh,
  VPMINs16,
  VPMINs32,
  VPMINs8,
  VPMINu16,
  VPMINu32,
  VPMINu8,
  VQABSv16i8,
  VQABSv2i32,
  VQABSv4i16,
  VQABSv4i32,
  VQABSv8i16,
  VQABSv8i8,
  VQADDsv16i8,
  VQADDsv1i64,
  VQADDsv2i32,
  VQADDsv2i64,
  VQADDsv4i16,
  VQADDsv4i32,
  VQADDsv8i16,
  VQADDsv8i8,
  VQADDuv16i8,
  VQADDuv1i64,
  VQADDuv2i32,
  VQADDuv2i64,
  VQADDuv4i16,
  VQADDuv4i32,
  VQADDuv8i16,
  VQADDuv8i8,
  VQDMLALslv2i32,
  VQDMLALslv4i16,
  VQDMLALv2i64,
  VQDMLALv4i32,
  VQDMLSLslv2i32,
  VQDMLSLslv4i16,
  VQDMLSLv2i64,
  VQDMLSLv4i32,
  VQDMULHslv2i32,
  VQDMULHslv4i16,
  VQDMULHslv4i32,
  VQDMULHslv8i16,
  VQDMULHv2i32,
  VQDMULHv4i16,
  VQDMULHv4i32,
  VQDMULHv8i16,
  VQDMULLslv2i32,
  VQDMULLslv4i16,
  VQDMULLv2i64,
  VQDMULLv4i32,
  VQMOVNsuv2i32,
  VQMOVNsuv4i16,
  VQMOVNsuv8i8,
  VQMOVNsv2i32,
  VQMOVNsv4i16,
  VQMOVNsv8i8,
  VQMOVNuv2i32,
  VQMOVNuv4i16,
  VQMOVNuv8i8,
  VQNEGv16i8,
  VQNEGv2i32,
  VQNEGv4i16,
  VQNEGv4i32,
  VQNEGv8i16,
  VQNEGv8i8,
  VQRDMLAHslv2i32,
  VQRDMLAHslv4i16,
  VQRDMLAHslv4i32,
  VQRDMLAHslv8i16,
  VQRDMLAHv2i32,
  VQRDMLAHv4i16,
  VQRDMLAHv4i32,
  VQRDMLAHv8i16,
  VQRDMLSHslv2i32,
  VQRDMLSHslv4i16,
  VQRDMLSHslv4i32,
  VQRDMLSHslv8i16,
  VQRDMLSHv2i32,
  VQRDMLSHv4i16,
  VQRDMLSHv4i32,
  VQRDMLSHv8i16,
  VQRDMULHslv2i32,
  VQRDMULHslv4i16,
  VQRDMULHslv4i32,
  VQRDMULHslv8i16,
  VQRDMULHv2i32,
  VQRDMULHv4i16,
  VQRDMULHv4i32,
  VQRDMULHv8i16,
  VQRSHLsv16i8,
  VQRSHLsv1i64,
  VQRSHLsv2i32,
  VQRSHLsv2i64,
  VQRSHLsv4i16,
  VQRSHLsv4i32,
  VQRSHLsv8i16,
  VQRSHLsv8i8,
  VQRSHLuv16i8,
  VQRSHLuv1i64,
  VQRSHLuv2i32,
  VQRSHLuv2i64,
  VQRSHLuv4i16,
  VQRSHLuv4i32,
  VQRSHLuv8i16,
  VQRSHLuv8i8,
  VQRSHRNsv2i32,
  VQRSHRNsv4i16,
  VQRSHRNsv8i8,
  VQRSHRNuv2i32,
  VQRSHRNuv4i16,
  VQRSHRNuv8i8,
  VQRSHRUNv2i32,
  VQRSHRUNv4i16,
  VQRSHRUNv8i8,
  VQSHLsiv16i8,
  VQSHLsiv1i64,
  VQSHLsiv2i32,
  VQSHLsiv2i64,
  VQSHLsiv4i16,
  VQSHLsiv4i32,
  VQSHLsiv8i16,
  VQSHLsiv8i8,
  VQSHLsuv16i8,
  VQSHLsuv1i64,
  VQSHLsuv2i32,
  VQSHLsuv2i64,
  VQSHLsuv4i16,
  VQSHLsuv4i32,
  VQSHLsuv8i16,
  VQSHLsuv8i8,
  VQSHLsv16i8,
  VQSHLsv1i64,
  VQSHLsv2i32,
  VQSHLsv2i64,
  VQSHLsv4i16,
  VQSHLsv4i32,
  VQSHLsv8i16,
  VQSHLsv8i8,
  VQSHLuiv16i8,
  VQSHLuiv1i64,
  VQSHLuiv2i32,
  VQSHLuiv2i64,
  VQSHLuiv4i16,
  VQSHLuiv4i32,
  VQSHLuiv8i16,
  VQSHLuiv8i8,
  VQSHLuv16i8,
  VQSHLuv1i64,
  VQSHLuv2i32,
  VQSHLuv2i64,
  VQSHLuv4i16,
  VQSHLuv4i32,
  VQSHLuv8i16,
  VQSHLuv8i8,
  VQSHRNsv2i32,
  VQSHRNsv4i16,
  VQSHRNsv8i8,
  VQSHRNuv2i32,
  VQSHRNuv4i16,
  VQSHRNuv8i8,
  VQSHRUNv2i32,
  VQSHRUNv4i16,
  VQSHRUNv8i8,
  VQSUBsv16i8,
  VQSUBsv1i64,
  VQSUBsv2i32,
  VQSUBsv2i64,
  VQSUBsv4i16,
  VQSUBsv4i32,
  VQSUBsv8i16,
  VQSUBsv8i8,
  VQSUBuv16i8,
  VQSUBuv1i64,
  VQSUBuv2i32,
  VQSUBuv2i64,
  VQSUBuv4i16,
  VQSUBuv4i32,
  VQSUBuv8i16,
  VQSUBuv8i8,
  VRADDHNv2i32,
  VRADDHNv4i16,
  VRADDHNv8i8,
  VRECPEd,
  VRECPEfd,
  VRECPEfq,
  VRECPEhd,
  VRECPEhq,
  VRECPEq,
  VRECPSfd,
  VRECPSfq,
  VRECPShd,
  VRECPShq,
  VREV16d8,
  VREV16q8,
  VREV32d16,
  VREV32d8,
  VREV32q16,
  VREV32q8,
  VREV64d16,
  VREV64d32,
  VREV64d8,
  VREV64q16,
  VREV64q32,
  VREV64q8,
  VRHADDsv16i8,
  VRHADDsv2i32,
  VRHADDsv4i16,
  VRHADDsv4i32,
  VRHADDsv8i16,
  VRHADDsv8i8,
  VRHADDuv16i8,
  VRHADDuv2i32,
  VRHADDuv4i16,
  VRHADDuv4i32,
  VRHADDuv8i16,
  VRHADDuv8i8,
  VRINTAD,
  VRINTAH,
  VRINTANDf,
  VRINTANDh,
  VRINTANQf,
  VRINTANQh,
  VRINTAS,
  VRINTMD,
  VRINTMH,
  VRINTMNDf,
  VRINTMNDh,
  VRINTMNQf,
  VRINTMNQh,
  VRINTMS,
  VRINTND,
  VRINTNH,
  VRINTNNDf,
  VRINTNNDh,
  VRINTNNQf,
  VRINTNNQh,
  VRINTNS,
  VRINTPD,
  VRINTPH,
  VRINTPNDf,
  VRINTPNDh,
  VRINTPNQf,
  VRINTPNQh,
  VRINTPS,
  VRINTRD,
  VRINTRH,
  VRINTRS,
  VRINTXD,
  VRINTXH,
  VRINTXNDf,
  VRINTXNDh,
  VRINTXNQf,
  VRINTXNQh,
  VRINTXS,
  VRINTZD,
  VRINTZH,
  VRINTZNDf,
  VRINTZNDh,
  VRINTZNQf,
  VRINTZNQh,
  VRINTZS,
  VRSHLsv16i8,
  VRSHLsv1i64,
  VRSHLsv2i32,
  VRSHLsv2i64,
  VRSHLsv4i16,
  VRSHLsv4i32,
  VRSHLsv8i16,
  VRSHLsv8i8,
  VRSHLuv16i8,
  VRSHLuv1i64,
  VRSHLuv2i32,
  VRSHLuv2i64,
  VRSHLuv4i16,
  VRSHLuv4i32,
  VRSHLuv8i16,
  VRSHLuv8i8,
  VRSHRNv2i32,
  VRSHRNv4i16,
  VRSHRNv8i8,
  VRSHRsv16i8,
  VRSHRsv1i64,
  VRSHRsv2i32,
  VRSHRsv2i64,
  VRSHRsv4i16,
  VRSHRsv4i32,
  VRSHRsv8i16,
  VRSHRsv8i8,
  VRSHRuv16i8,
  VRSHRuv1i64,
  VRSHRuv2i32,
  VRSHRuv2i64,
  VRSHRuv4i16,
  VRSHRuv4i32,
  VRSHRuv8i16,
  VRSHRuv8i8,
  VRSQRTEd,
  VRSQRTEfd,
  VRSQRTEfq,
  VRSQRTEhd,
  VRSQRTEhq,
  VRSQRTEq,
  VRSQRTSfd,
  VRSQRTSfq,
  VRSQRTShd,
  VRSQRTShq,
  VRSRAsv16i8,
  VRSRAsv1i64,
  VRSRAsv2i32,
  VRSRAsv2i64,
  VRSRAsv4i16,
  VRSRAsv4i32,
  VRSRAsv8i16,
  VRSRAsv8i8,
  VRSRAuv16i8,
  VRSRAuv1i64,
  VRSRAuv2i32,
  VRSRAuv2i64,
  VRSRAuv4i16,
  VRSRAuv4i32,
  VRSRAuv8i16,
  VRSRAuv8i8,
  VRSUBHNv2i32,
  VRSUBHNv4i16,
  VRSUBHNv8i8,
  VSCCLRMD,
  VSCCLRMS,
  VSDOTD,
  VSDOTDI,
  VSDOTQ,
  VSDOTQI,
  VSELEQD,
  VSELEQH,
  VSELEQS,
  VSELGED,
  VSELGEH,
  VSELGES,
  VSELGTD,
  VSELGTH,
  VSELGTS,
  VSELVSD,
  VSELVSH,
  VSELVSS,
  VSETLNi16,
  VSETLNi32,
  VSETLNi8,
  VSHLLi16,
  VSHLLi32,
  VSHLLi8,
  VSHLLsv2i64,
  VSHLLsv4i32,
  VSHLLsv8i16,
  VSHLLuv2i64,
  VSHLLuv4i32,
  VSHLLuv8i16,
  VSHLiv16i8,
  VSHLiv1i64,
  VSHLiv2i32,
  VSHLiv2i64,
  VSHLiv4i16,
  VSHLiv4i32,
  VSHLiv8i16,
  VSHLiv8i8,
  VSHLsv16i8,
  VSHLsv1i64,
  VSHLsv2i32,
  VSHLsv2i64,
  VSHLsv4i16,
  VSHLsv4i32,
  VSHLsv8i16,
  VSHLsv8i8,
  VSHLuv16i8,
  VSHLuv1i64,
  VSHLuv2i32,
  VSHLuv2i64,
  VSHLuv4i16,
  VSHLuv4i32,
  VSHLuv8i16,
  VSHLuv8i8,
  VSHRNv2i32,
  VSHRNv4i16,
  VSHRNv8i8,
  VSHRsv16i8,
  VSHRsv1i64,
  VSHRsv2i32,
  VSHRsv2i64,
  VSHRsv4i16,
  VSHRsv4i32,
  VSHRsv8i16,
  VSHRsv8i8,
  VSHRuv16i8,
  VSHRuv1i64,
  VSHRuv2i32,
  VSHRuv2i64,
  VSHRuv4i16,
  VSHRuv4i32,
  VSHRuv8i16,
  VSHRuv8i8,
  VSHTOD,
  VSHTOH,
  VSHTOS,
  VSITOD,
  VSITOH,
  VSITOS,
  VSLIv16i8,
  VSLIv1i64,
  VSLIv2i32,
  VSLIv2i64,
  VSLIv4i16,
  VSLIv4i32,
  VSLIv8i16,
  VSLIv8i8,
  VSLTOD,
  VSLTOH,
  VSLTOS,
  VSMMLA,
  VSQRTD,
  VSQRTH,
  VSQRTS,
  VSRAsv16i8,
  VSRAsv1i64,
  VSRAsv2i32,
  VSRAsv2i64,
  VSRAsv4i16,
  VSRAsv4i32,
  VSRAsv8i16,
  VSRAsv8i8,
  VSRAuv16i8,
  VSRAuv1i64,
  VSRAuv2i32,
  VSRAuv2i64,
  VSRAuv4i16,
  VSRAuv4i32,
  VSRAuv8i16,
  VSRAuv8i8,
  VSRIv16i8,
  VSRIv1i64,
  VSRIv2i32,
  VSRIv2i64,
  VSRIv4i16,
  VSRIv4i32,
  VSRIv8i16,
  VSRIv8i8,
  VST1LNd16,
  VST1LNd16_UPD,
  VST1LNd32,
  VST1LNd32_UPD,
  VST1LNd8,
  VST1LNd8_UPD,
  VST1LNq16Pseudo,
  VST1LNq16Pseudo_UPD,
  VST1LNq32Pseudo,
  VST1LNq32Pseudo_UPD,
  VST1LNq8Pseudo,
  VST1LNq8Pseudo_UPD,
  VST1d16,
  VST1d16Q,
  VST1d16QPseudo,
  VST1d16QPseudoWB_fixed,
  VST1d16QPseudoWB_register,
  VST1d16Qwb_fixed,
  VST1d16Qwb_register,
  VST1d16T,
  VST1d16TPseudo,
  VST1d16TPseudoWB_fixed,
  VST1d16TPseudoWB_register,
  VST1d16Twb_fixed,
  VST1d16Twb_register,
  VST1d16wb_fixed,
  VST1d16wb_register,
  VST1d32,
  VST1d32Q,
  VST1d32QPseudo,
  VST1d32QPseudoWB_fixed,
  VST1d32QPseudoWB_register,
  VST1d32Qwb_fixed,
  VST1d32Qwb_register,
  VST1d32T,
  VST1d32TPseudo,
  VST1d32TPseudoWB_fixed,
  VST1d32TPseudoWB_register,
  VST1d32Twb_fixed,
  VST1d32Twb_register,
  VST1d32wb_fixed,
  VST1d32wb_register,
  VST1d64,
  VST1d64Q,
  VST1d64QPseudo,
  VST1d64QPseudoWB_fixed,
  VST1d64QPseudoWB_register,
  VST1d64Qwb_fixed,
  VST1d64Qwb_register,
  VST1d64T,
  VST1d64TPseudo,
  VST1d64TPseudoWB_fixed,
  VST1d64TPseudoWB_register,
  VST1d64Twb_fixed,
  VST1d64Twb_register,
  VST1d64wb_fixed,
  VST1d64wb_register,
  VST1d8,
  VST1d8Q,
  VST1d8QPseudo,
  VST1d8QPseudoWB_fixed,
  VST1d8QPseudoWB_register,
  VST1d8Qwb_fixed,
  VST1d8Qwb_register,
  VST1d8T,
  VST1d8TPseudo,
  VST1d8TPseudoWB_fixed,
  VST1d8TPseudoWB_register,
  VST1d8Twb_fixed,
  VST1d8Twb_register,
  VST1d8wb_fixed,
  VST1d8wb_register,
  VST1q16,
  VST1q16HighQPseudo,
  VST1q16HighQPseudo_UPD,
  VST1q16HighTPseudo,
  VST1q16HighTPseudo_UPD,
  VST1q16LowQPseudo_UPD,
  VST1q16LowTPseudo_UPD,
  VST1q16wb_fixed,
  VST1q16wb_register,
  VST1q32,
  VST1q32HighQPseudo,
  VST1q32HighQPseudo_UPD,
  VST1q32HighTPseudo,
  VST1q32HighTPseudo_UPD,
  VST1q32LowQPseudo_UPD,
  VST1q32LowTPseudo_UPD,
  VST1q32wb_fixed,
  VST1q32wb_register,
  VST1q64,
  VST1q64HighQPseudo,
  VST1q64HighQPseudo_UPD,
  VST1q64HighTPseudo,
  VST1q64HighTPseudo_UPD,
  VST1q64LowQPseudo_UPD,
  VST1q64LowTPseudo_UPD,
  VST1q64wb_fixed,
  VST1q64wb_register,
  VST1q8,
  VST1q8HighQPseudo,
  VST1q8HighQPseudo_UPD,
  VST1q8HighTPseudo,
  VST1q8HighTPseudo_UPD,
  VST1q8LowQPseudo_UPD,
  VST1q8LowTPseudo_UPD,
  VST1q8wb_fixed,
  VST1q8wb_register,
  VST2LNd16,
  VST2LNd16Pseudo,
  VST2LNd16Pseudo_UPD,
  VST2LNd16_UPD,
  VST2LNd32,
  VST2LNd32Pseudo,
  VST2LNd32Pseudo_UPD,
  VST2LNd32_UPD,
  VST2LNd8,
  VST2LNd8Pseudo,
  VST2LNd8Pseudo_UPD,
  VST2LNd8_UPD,
  VST2LNq16,
  VST2LNq16Pseudo,
  VST2LNq16Pseudo_UPD,
  VST2LNq16_UPD,
  VST2LNq32,
  VST2LNq32Pseudo,
  VST2LNq32Pseudo_UPD,
  VST2LNq32_UPD,
  VST2b16,
  VST2b16wb_fixed,
  VST2b16wb_register,
  VST2b32,
  VST2b32wb_fixed,
  VST2b32wb_register,
  VST2b8,
  VST2b8wb_fixed,
  VST2b8wb_register,
  VST2d16,
  VST2d16wb_fixed,
  VST2d16wb_register,
  VST2d32,
  VST2d32wb_fixed,
  VST2d32wb_register,
  VST2d8,
  VST2d8wb_fixed,
  VST2d8wb_register,
  VST2q16,
  VST2q16Pseudo,
  VST2q16PseudoWB_fixed,
  VST2q16PseudoWB_register,
  VST2q16wb_fixed,
  VST2q16wb_register,
  VST2q32,
  VST2q32Pseudo,
  VST2q32PseudoWB_fixed,
  VST2q32PseudoWB_register,
  VST2q32wb_fixed,
  VST2q32wb_register,
  VST2q8,
  VST2q8Pseudo,
  VST2q8PseudoWB_fixed,
  VST2q8PseudoWB_register,
  VST2q8wb_fixed,
  VST2q8wb_register,
  VST3LNd16,
  VST3LNd16Pseudo,
  VST3LNd16Pseudo_UPD,
  VST3LNd16_UPD,
  VST3LNd32,
  VST3LNd32Pseudo,
  VST3LNd32Pseudo_UPD,
  VST3LNd32_UPD,
  VST3LNd8,
  VST3LNd8Pseudo,
  VST3LNd8Pseudo_UPD,
  VST3LNd8_UPD,
  VST3LNq16,
  VST3LNq16Pseudo,
  VST3LNq16Pseudo_UPD,
  VST3LNq16_UPD,
  VST3LNq32,
  VST3LNq32Pseudo,
  VST3LNq32Pseudo_UPD,
  VST3LNq32_UPD,
  VST3d16,
  VST3d16Pseudo,
  VST3d16Pseudo_UPD,
  VST3d16_UPD,
  VST3d32,
  VST3d32Pseudo,
  VST3d32Pseudo_UPD,
  VST3d32_UPD,
  VST3d8,
  VST3d8Pseudo,
  VST3d8Pseudo_UPD,
  VST3d8_UPD,
  VST3q16,
  VST3q16Pseudo_UPD,
  VST3q16_UPD,
  VST3q16oddPseudo,
  VST3q16oddPseudo_UPD,
  VST3q32,
  VST3q32Pseudo_UPD,
  VST3q32_UPD,
  VST3q32oddPseudo,
  VST3q32oddPseudo_UPD,
  VST3q8,
  VST3q8Pseudo_UPD,
  VST3q8_UPD,
  VST3q8oddPseudo,
  VST3q8oddPseudo_UPD,
  VST4LNd16,
  VST4LNd16Pseudo,
  VST4LNd16Pseudo_UPD,
  VST4LNd16_UPD,
  VST4LNd32,
  VST4LNd32Pseudo,
  VST4LNd32Pseudo_UPD,
  VST4LNd32_UPD,
  VST4LNd8,
  VST4LNd8Pseudo,
  VST4LNd8Pseudo_UPD,
  VST4LNd8_UPD,
  VST4LNq16,
  VST4LNq16Pseudo,
  VST4LNq16Pseudo_UPD,
  VST4LNq16_UPD,
  VST4LNq32,
  VST4LNq32Pseudo,
  VST4LNq32Pseudo_UPD,
  VST4LNq32_UPD,
  VST4d16,
  VST4d16Pseudo,
  VST4d16Pseudo_UPD,
  VST4d16_UPD,
  VST4d32,
  VST4d32Pseudo,
  VST4d32Pseudo_UPD,
  VST4d32_UPD,
  VST4d8,
  VST4d8Pseudo,
  VST4d8Pseudo_UPD,
  VST4d8_UPD,
  VST4q16,
  VST4q16Pseudo_UPD,
  VST4q16_UPD,
  VST4q16oddPseudo,
  VST4q16oddPseudo_UPD,
  VST4q32,
  VST4q32Pseudo_UPD,
  VST4q32_UPD,
  VST4q32oddPseudo,
  VST4q32oddPseudo_UPD,
  VST4q8,
  VST4q8Pseudo_UPD,
  VST4q8_UPD,
  VST4q8oddPseudo,
  VST4q8oddPseudo_UPD,
  VSTMDDB_UPD,
  VSTMDIA,
  VSTMDIA_UPD,
  VSTMQIA,
  VSTMSDB_UPD,
  VSTMSIA,
  VSTMSIA_UPD,
  VSTRD,
  VSTRH,
  VSTRS,
  VSTR_FPCXTNS_off,
  VSTR_FPCXTNS_post,
  VSTR_FPCXTNS_pre,
  VSTR_FPCXTS_off,
  VSTR_FPCXTS_post,
  VSTR_FPCXTS_pre,
  VSTR_FPSCR_NZCVQC_off,
  VSTR_FPSCR_NZCVQC_post,
  VSTR_FPSCR_NZCVQC_pre,
  VSTR_FPSCR_off,
  VSTR_FPSCR_post,
  VSTR_FPSCR_pre,
  VSTR_P0_off,
  VSTR_P0_post,
  VSTR_P0_pre,
  VSTR_VPR_off,
  VSTR_VPR_post,
  VSTR_VPR_pre,
  VSUBD,
  VSUBH,
  VSUBHNv2i32,
  VSUBHNv4i16,
  VSUBHNv8i8,
  VSUBLsv2i64,
  VSUBLsv4i32,
  VSUBLsv8i16,
  VSUBLuv2i64,
  VSUBLuv4i32,
  VSUBLuv8i16,
  VSUBS,
  VSUBWsv2i64,
  VSUBWsv4i32,
  VSUBWsv8i16,
  VSUBWuv2i64,
  VSUBWuv4i32,
  VSUBWuv8i16,
  VSUBfd,
  VSUBfq,
  VSUBhd,
  VSUBhq,
  VSUBv16i8,
  VSUBv1i64,
  VSUBv2i32,
  VSUBv2i64,
  VSUBv4i16,
  VSUBv4i32,
  VSUBv8i16,
  VSUBv8i8,
  VSUDOTDI,
  VSUDOTQI,
  VSWPd,
  VSWPq,
  VTBL1,
  VTBL2,
  VTBL3,
  VTBL3Pseudo,
  VTBL4,
  VTBL4Pseudo,
  VTBX1,
  VTBX2,
  VTBX3,
  VTBX3Pseudo,
  VTBX4,
  VTBX4Pseudo,
  VTOSHD,
  VTOSHH,
  VTOSHS,
  VTOSIRD,
  VTOSIRH,
  VTOSIRS,
  VTOSIZD,
  VTOSIZH,
  VTOSIZS,
  VTOSLD,
  VTOSLH,
  VTOSLS,
  VTOUHD,
  VTOUHH,
  VTOUHS,
  VTOUIRD,
  VTOUIRH,
  VTOUIRS,
  VTOUIZD,
  VTOUIZH,
  VTOUIZS,
  VTOULD,
  VTOULH,
  VTOULS,
  VTRNd16,
  VTRNd32,
  VTRNd8,
  VTRNq16,
  VTRNq32,
  VTRNq8,
  VTSTv16i8,
  VTSTv2i32,
  VTSTv4i16,
  VTSTv4i32,
  VTSTv8i16,
  VTSTv8i8,
  VUDOTD,
  VUDOTDI,
  VUDOTQ,
  VUDOTQI,
  VUHTOD,
  VUHTOH,
  VUHTOS,
  VUITOD,
  VUITOH,
  VUITOS,
  VULTOD,
  VULTOH,
  VULTOS,
  VUMMLA,
  VUSDOTD,
  VUSDOTDI,
  VUSDOTQ,
  VUSDOTQI,
  VUSMMLA,
  VUZPd16,
  VUZPd8,
  VUZPq16,
  VUZPq32,
  VUZPq8,
  VZIPd16,
  VZIPd8,
  VZIPq16,
  VZIPq32,
  VZIPq8,
  sysLDMDA,
  sysLDMDA_UPD,
  sysLDMDB,
  sysLDMDB_UPD,
  sysLDMIA,
  sysLDMIA_UPD,
  sysLDMIB,
  sysLDMIB_UPD,
  sysSTMDA,
  sysSTMDA_UPD,
  sysSTMDB,
  sysSTMDB_UPD,
  sysSTMIA,
  sysSTMIA_UPD,
  sysSTMIB,
  sysSTMIB_UPD,
  t2ADCri,
  t2ADCrr,
  t2ADCrs,
  t2ADDri,
  t2ADDri12,
  t2ADDrr,
  t2ADDrs,
  t2ADDspImm,
  t2ADDspImm12,
  t2ADR,
  t2ANDri,
  t2ANDrr,
  t2ANDrs,
  t2ASRri,
  t2ASRrr,
  t2ASRs1,
  t2AUT,
  t2AUTG,
  t2B,
  t2BFC,
  t2BFI,
  t2BFLi,
  t2BFLr,
  t2BFi,
  t2BFic,
  t2BFr,
  t2BICri,
  t2BICrr,
  t2BICrs,
  t2BTI,
  t2BXAUT,
  t2BXJ,
  t2Bcc,
  t2CDP,
  t2CDP2,
  t2CLREX,
  t2CLRM,
  t2CLZ,
  t2CMNri,
  t2CMNzrr,
  t2CMNzrs,
  t2CMPri,
  t2CMPrr,
  t2CMPrs,
  t2CPS1p,
  t2CPS2p,
  t2CPS3p,
  t2CRC32B,
  t2CRC32CB,
  t2CRC32CH,
  t2CRC32CW,
  t2CRC32H,
  t2CRC32W,
  t2CSEL,
  t2CSINC,
  t2CSINV,
  t2CSNEG,
  t2DBG,
  t2DCPS1,
  t2DCPS2,
  t2DCPS3,
  t2DLS,
  t2DMB,
  t2DSB,
  t2EORri,
  t2EORrr,
  t2EORrs,
  t2HINT,
  t2HVC,
  t2ISB,
  t2IT,
  t2Int_eh_sjlj_setjmp,
  t2Int_eh_sjlj_setjmp_nofp,
  t2LDA,
  t2LDAB,
  t2LDAEX,
  t2LDAEXB,
  t2LDAEXD,
  t2LDAEXH,
  t2LDAH,
  t2LDC2L_OFFSET,
  t2LDC2L_OPTION,
  t2LDC2L_POST,
  t2LDC2L_PRE,
  t2LDC2_OFFSET,
  t2LDC2_OPTION,
  t2LDC2_POST,
  t2LDC2_PRE,
  t2LDCL_OFFSET,
  t2LDCL_OPTION,
  t2LDCL_POST,
  t2LDCL_PRE,
  t2LDC_OFFSET,
  t2LDC_OPTION,
  t2LDC_POST,
  t2LDC_PRE,
  t2LDMDB,
  t2LDMDB_UPD,
  t2LDMIA,
  t2LDMIA_UPD,
  t2LDRBT,
  t2LDRB_POST,
  t2LDRB_PRE,
  t2LDRBi12,
  t2LDRBi8,
  t2LDRBpci,
  t2LDRBs,
  t2LDRD_POST,
  t2LDRD_PRE,
  t2LDRDi8,
  t2LDREX,
  t2LDREXB,
  t2LDREXD,
  t2LDREXH,
  t2LDRHT,
  t2LDRH_POST,
  t2LDRH_PRE,
  t2LDRHi12,
  t2LDRHi8,
  t2LDRHpci,
  t2LDRHs,
  t2LDRSBT,
  t2LDRSB_POST,
  t2LDRSB_PRE,
  t2LDRSBi12,
  t2LDRSBi8,
  t2LDRSBpci,
  t2LDRSBs,
  t2LDRSHT,
  t2LDRSH_POST,
  t2LDRSH_PRE,
  t2LDRSHi12,
  t2LDRSHi8,
  t2LDRSHpci,
  t2LDRSHs,
  t2LDRT,
  t2LDR_POST,
  t2LDR_PRE,
  t2LDRi12,
  t2LDRi8,
  t2LDRpci,
  t2LDRs,
  t2LE,
  t2LEUpdate,
  t2LSLri,
  t2LSLrr,
  t2LSRri,
  t2LSRrr,
  t2LSRs1,
  t2MCR,
  t2MCR2,
  t2MCRR,
  t2MCRR2,
  t2MLA,
  t2MLS,
  t2MOVTi16,
  t2MOVi,
  t2MOVi16,
  t2MOVr,
  t2MRC,
  t2MRC2,
  t2MRRC,
  t2MRRC2,
  t2MRS_AR,
  t2MRS_M,
  t2MRSbanked,
  t2MRSsys_AR,
  t2MSR_AR,
  t2MSR_M,
  t2MSRbanked,
  t2MUL,
  t2MVNi,
  t2MVNr,
  t2MVNs,
  t2ORNri,
  t2ORNrr,
  t2ORNrs,
  t2ORRri,
  t2ORRrr,
  t2ORRrs,
  t2PAC,
  t2PACBTI,
  t2PACG,
  t2PKHBT,
  t2PKHTB,
  t2PLDWi12,
  t2PLDWi8,
  t2PLDWs,
  t2PLDi12,
  t2PLDi8,
  t2PLDpci,
  t2PLDs,
  t2PLIi12,
  t2PLIi8,
  t2PLIpci,
  t2PLIs,
  t2QADD,
  t2QADD16,
  t2QADD8,
  t2QASX,
  t2QDADD,
  t2QDSUB,
  t2QSAX,
  t2QSUB,
  t2QSUB16,
  t2QSUB8,
  t2RBIT,
  t2REV,
  t2REV16,
  t2REVSH,
  t2RFEDB,
  t2RFEDBW,
  t2RFEIA,
  t2RFEIAW,
  t2RORri,
  t2RORrr,
  t2RRX,
  t2RSBri,
  t2RSBrr,
  t2RSBrs,
  t2SADD16,
  t2SADD8,
  t2SASX,
  t2SB,
  t2SBCri,
  t2SBCrr,
  t2SBCrs,
  t2SBFX,
  t2SDIV,
  t2SEL,
  t2SETPAN,
  t2SG,
  t2SHADD16,
  t2SHADD8,
  t2SHASX,
  t2SHSAX,
  t2SHSUB16,
  t2SHSUB8,
  t2SMC,
  t2SMLABB,
  t2SMLABT,
  t2SMLAD,
  t2SMLADX,
  t2SMLAL,
  t2SMLALBB,
  t2SMLALBT,
  t2SMLALD,
  t2SMLALDX,
  t2SMLALTB,
  t2SMLALTT,
  t2SMLATB,
  t2SMLATT,
  t2SMLAWB,
  t2SMLAWT,
  t2SMLSD,
  t2SMLSDX,
  t2SMLSLD,
  t2SMLSLDX,
  t2SMMLA,
  t2SMMLAR,
  t2SMMLS,
  t2SMMLSR,
  t2SMMUL,
  t2SMMULR,
  t2SMUAD,
  t2SMUADX,
  t2SMULBB,
  t2SMULBT,
  t2SMULL,
  t2SMULTB,
  t2SMULTT,
  t2SMULWB,
  t2SMULWT,
  t2SMUSD,
  t2SMUSDX,
  t2SRSDB,
  t2SRSDB_UPD,
  t2SRSIA,
  t2SRSIA_UPD,
  t2SSAT,
  t2SSAT16,
  t2SSAX,
  t2SSUB16,
  t2SSUB8,
  t2STC2L_OFFSET,
  t2STC2L_OPTION,
  t2STC2L_POST,
  t2STC2L_PRE,
  t2STC2_OFFSET,
  t2STC2_OPTION,
  t2STC2_POST,
  t2STC2_PRE,
  t2STCL_OFFSET,
  t2STCL_OPTION,
  t2STCL_POST,
  t2STCL_PRE,
  t2STC_OFFSET,
  t2STC_OPTION,
  t2STC_POST,
  t2STC_PRE,
  t2STL,
  t2STLB,
  t2STLEX,
  t2STLEXB,
  t2STLEXD,
  t2STLEXH,
  t2STLH,
  t2STMDB,
  t2STMDB_UPD,
  t2STMIA,
  t2STMIA_UPD,
  t2STRBT,
  t2STRB_POST,
  t2STRB_PRE,
  t2STRBi12,
  t2STRBi8,
  t2STRBs,
  t2STRD_POST,
  t2STRD_PRE,
  t2STRDi8,
  t2STREX,
  t2STREXB,
  t2STREXD,
  t2STREXH,
  t2STRHT,
  t2STRH_POST,
  t2STRH_PRE,
  t2STRHi12,
  t2STRHi8,
  t2STRHs,
  t2STRT,
  t2STR_POST,
  t2STR_PRE,
  t2STRi12,
  t2STRi8,
  t2STRs,
  t2SUBS_PC_LR,
  t2SUBri,
  t2SUBri12,
  t2SUBrr,
  t2SUBrs,
  t2SUBspImm,
  t2SUBspImm12,
  t2SXTAB,
  t2SXTAB16,
  t2SXTAH,
  t2SXTB,
  t2SXTB16,
  t2SXTH,
  t2TBB,
  t2TBH,
  t2TEQri,
  t2TEQrr,
  t2TEQrs,
  t2TSB,
  t2TSTri,
  t2TSTrr,
  t2TSTrs,
  t2TT,
  t2TTA,
  t2TTAT,
  t2TTT,
  t2UADD16,
  t2UADD8,
  t2UASX,
  t2UBFX,
  t2UDF,
  t2UDIV,
  t2UHADD16,
  t2UHADD8,
  t2UHASX,
  t2UHSAX,
  t2UHSUB16,
  t2UHSUB8,
  t2UMAAL,
  t2UMLAL,
  t2UMULL,
  t2UQADD16,
  t2UQADD8,
  t2UQASX,
  t2UQSAX,
  t2UQSUB16,
  t2UQSUB8,
  t2USAD8,
  t2USADA8,
  t2USAT,
  t2USAT16,
  t2USAX,
  t2USUB16,
  t2USUB8,
  t2UXTAB,
  t2UXTAB16,
  t2UXTAH,
  t2UXTB,
  t2UXTB16,
  t2UXTH,
  t2WLS,
  tADC,
  tADDhirr,
  tADDi3,
  tADDi8,
  tADDrSP,
  tADDrSPi,
  tADDrr,
  tADDspi,
  tADDspr,
  tADR,
  tAND,
  tASRri,
  tASRrr,
  tB,
  tBIC,
  tBKPT,
  tBL,
  tBLXNSr,
  tBLXi,
  tBLXr,
  tBX,
  tBXNS,
  tBcc,
  tCBNZ,
  tCBZ,
  tCMNz,
  tCMPhir,
  tCMPi8,
  tCMPr,
  tCPS,
  tEOR,
  tHINT,
  tHLT,
  tInt_WIN_eh_sjlj_longjmp,
  tInt_eh_sjlj_longjmp,
  tInt_eh_sjlj_setjmp,
  tLDMIA,
  tLDRBi,
  tLDRBr,
  tLDRHi,
  tLDRHr,
  tLDRSB,
  tLDRSH,
  tLDRi,
  tLDRpci,
  tLDRr,
  tLDRspi,
  tLSLri,
  tLSLrr,
  tLSRri,
  tLSRrr,
  tMOVSr,
  tMOVi8,
  tMOVr,
  tMUL,
  tMVN,
  tORR,
  tPICADD,
  tPOP,
  tPUSH,
  tREV,
  tREV16,
  tREVSH,
  tROR,
  tRSB,
  tSBC,
  tSETEND,
  tSTMIA_UPD,
  tSTRBi,
  tSTRBr,
  tSTRHi,
  tSTRHr,
  tSTRi,
  tSTRr,
  tSTRspi,
  tSUBi3,
  tSUBi8,
  tSUBrr,
  tSUBspi,
  tSVC,
  tSXTB,
  tSXTH,
  tTRAP,
  tTST,
  tUDF,
  tUXTB,
  tUXTH,
  t__brkdiv0,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::INIT_UNDEF,
          12 => Opcode::SUBREG_TO_REG,
          13 => Opcode::COPY_TO_REGCLASS,
          14 => Opcode::DBG_VALUE,
          15 => Opcode::DBG_VALUE_LIST,
          16 => Opcode::DBG_INSTR_REF,
          17 => Opcode::DBG_PHI,
          18 => Opcode::DBG_LABEL,
          19 => Opcode::REG_SEQUENCE,
          20 => Opcode::COPY,
          21 => Opcode::BUNDLE,
          22 => Opcode::LIFETIME_START,
          23 => Opcode::LIFETIME_END,
          24 => Opcode::PSEUDO_PROBE,
          25 => Opcode::ARITH_FENCE,
          26 => Opcode::STACKMAP,
          27 => Opcode::FENTRY_CALL,
          28 => Opcode::PATCHPOINT,
          29 => Opcode::LOAD_STACK_GUARD,
          30 => Opcode::PREALLOCATED_SETUP,
          31 => Opcode::PREALLOCATED_ARG,
          32 => Opcode::STATEPOINT,
          33 => Opcode::LOCAL_ESCAPE,
          34 => Opcode::FAULTING_OP,
          35 => Opcode::PATCHABLE_OP,
          36 => Opcode::PATCHABLE_FUNCTION_ENTER,
          37 => Opcode::PATCHABLE_RET,
          38 => Opcode::PATCHABLE_FUNCTION_EXIT,
          39 => Opcode::PATCHABLE_TAIL_CALL,
          40 => Opcode::PATCHABLE_EVENT_CALL,
          41 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          42 => Opcode::ICALL_BRANCH_FUNNEL,
          43 => Opcode::FAKE_USE,
          44 => Opcode::MEMBARRIER,
          45 => Opcode::JUMP_TABLE_DEBUG_INFO,
          46 => Opcode::CONVERGENCECTRL_ENTRY,
          47 => Opcode::CONVERGENCECTRL_ANCHOR,
          48 => Opcode::CONVERGENCECTRL_LOOP,
          49 => Opcode::CONVERGENCECTRL_GLUE,
          50 => Opcode::G_ASSERT_SEXT,
          51 => Opcode::G_ASSERT_ZEXT,
          52 => Opcode::G_ASSERT_ALIGN,
          53 => Opcode::G_ADD,
          54 => Opcode::G_SUB,
          55 => Opcode::G_MUL,
          56 => Opcode::G_SDIV,
          57 => Opcode::G_UDIV,
          58 => Opcode::G_SREM,
          59 => Opcode::G_UREM,
          60 => Opcode::G_SDIVREM,
          61 => Opcode::G_UDIVREM,
          62 => Opcode::G_AND,
          63 => Opcode::G_OR,
          64 => Opcode::G_XOR,
          65 => Opcode::G_ABDS,
          66 => Opcode::G_ABDU,
          67 => Opcode::G_IMPLICIT_DEF,
          68 => Opcode::G_PHI,
          69 => Opcode::G_FRAME_INDEX,
          70 => Opcode::G_GLOBAL_VALUE,
          71 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          72 => Opcode::G_CONSTANT_POOL,
          73 => Opcode::G_EXTRACT,
          74 => Opcode::G_UNMERGE_VALUES,
          75 => Opcode::G_INSERT,
          76 => Opcode::G_MERGE_VALUES,
          77 => Opcode::G_BUILD_VECTOR,
          78 => Opcode::G_BUILD_VECTOR_TRUNC,
          79 => Opcode::G_CONCAT_VECTORS,
          80 => Opcode::G_PTRTOINT,
          81 => Opcode::G_INTTOPTR,
          82 => Opcode::G_BITCAST,
          83 => Opcode::G_FREEZE,
          84 => Opcode::G_CONSTANT_FOLD_BARRIER,
          85 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          86 => Opcode::G_INTRINSIC_TRUNC,
          87 => Opcode::G_INTRINSIC_ROUND,
          88 => Opcode::G_INTRINSIC_LRINT,
          89 => Opcode::G_INTRINSIC_LLRINT,
          90 => Opcode::G_INTRINSIC_ROUNDEVEN,
          91 => Opcode::G_READCYCLECOUNTER,
          92 => Opcode::G_READSTEADYCOUNTER,
          93 => Opcode::G_LOAD,
          94 => Opcode::G_SEXTLOAD,
          95 => Opcode::G_ZEXTLOAD,
          96 => Opcode::G_INDEXED_LOAD,
          97 => Opcode::G_INDEXED_SEXTLOAD,
          98 => Opcode::G_INDEXED_ZEXTLOAD,
          99 => Opcode::G_STORE,
          100 => Opcode::G_INDEXED_STORE,
          101 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          102 => Opcode::G_ATOMIC_CMPXCHG,
          103 => Opcode::G_ATOMICRMW_XCHG,
          104 => Opcode::G_ATOMICRMW_ADD,
          105 => Opcode::G_ATOMICRMW_SUB,
          106 => Opcode::G_ATOMICRMW_AND,
          107 => Opcode::G_ATOMICRMW_NAND,
          108 => Opcode::G_ATOMICRMW_OR,
          109 => Opcode::G_ATOMICRMW_XOR,
          110 => Opcode::G_ATOMICRMW_MAX,
          111 => Opcode::G_ATOMICRMW_MIN,
          112 => Opcode::G_ATOMICRMW_UMAX,
          113 => Opcode::G_ATOMICRMW_UMIN,
          114 => Opcode::G_ATOMICRMW_FADD,
          115 => Opcode::G_ATOMICRMW_FSUB,
          116 => Opcode::G_ATOMICRMW_FMAX,
          117 => Opcode::G_ATOMICRMW_FMIN,
          118 => Opcode::G_ATOMICRMW_FMAXIMUM,
          119 => Opcode::G_ATOMICRMW_FMINIMUM,
          120 => Opcode::G_ATOMICRMW_UINC_WRAP,
          121 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          122 => Opcode::G_ATOMICRMW_USUB_COND,
          123 => Opcode::G_ATOMICRMW_USUB_SAT,
          124 => Opcode::G_FENCE,
          125 => Opcode::G_PREFETCH,
          126 => Opcode::G_BRCOND,
          127 => Opcode::G_BRINDIRECT,
          128 => Opcode::G_INVOKE_REGION_START,
          129 => Opcode::G_INTRINSIC,
          130 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          131 => Opcode::G_INTRINSIC_CONVERGENT,
          132 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          133 => Opcode::G_ANYEXT,
          134 => Opcode::G_TRUNC,
          135 => Opcode::G_TRUNC_SSAT_S,
          136 => Opcode::G_TRUNC_SSAT_U,
          137 => Opcode::G_TRUNC_USAT_U,
          138 => Opcode::G_CONSTANT,
          139 => Opcode::G_FCONSTANT,
          140 => Opcode::G_VASTART,
          141 => Opcode::G_VAARG,
          142 => Opcode::G_SEXT,
          143 => Opcode::G_SEXT_INREG,
          144 => Opcode::G_ZEXT,
          145 => Opcode::G_SHL,
          146 => Opcode::G_LSHR,
          147 => Opcode::G_ASHR,
          148 => Opcode::G_FSHL,
          149 => Opcode::G_FSHR,
          150 => Opcode::G_ROTR,
          151 => Opcode::G_ROTL,
          152 => Opcode::G_ICMP,
          153 => Opcode::G_FCMP,
          154 => Opcode::G_SCMP,
          155 => Opcode::G_UCMP,
          156 => Opcode::G_SELECT,
          157 => Opcode::G_UADDO,
          158 => Opcode::G_UADDE,
          159 => Opcode::G_USUBO,
          160 => Opcode::G_USUBE,
          161 => Opcode::G_SADDO,
          162 => Opcode::G_SADDE,
          163 => Opcode::G_SSUBO,
          164 => Opcode::G_SSUBE,
          165 => Opcode::G_UMULO,
          166 => Opcode::G_SMULO,
          167 => Opcode::G_UMULH,
          168 => Opcode::G_SMULH,
          169 => Opcode::G_UADDSAT,
          170 => Opcode::G_SADDSAT,
          171 => Opcode::G_USUBSAT,
          172 => Opcode::G_SSUBSAT,
          173 => Opcode::G_USHLSAT,
          174 => Opcode::G_SSHLSAT,
          175 => Opcode::G_SMULFIX,
          176 => Opcode::G_UMULFIX,
          177 => Opcode::G_SMULFIXSAT,
          178 => Opcode::G_UMULFIXSAT,
          179 => Opcode::G_SDIVFIX,
          180 => Opcode::G_UDIVFIX,
          181 => Opcode::G_SDIVFIXSAT,
          182 => Opcode::G_UDIVFIXSAT,
          183 => Opcode::G_FADD,
          184 => Opcode::G_FSUB,
          185 => Opcode::G_FMUL,
          186 => Opcode::G_FMA,
          187 => Opcode::G_FMAD,
          188 => Opcode::G_FDIV,
          189 => Opcode::G_FREM,
          190 => Opcode::G_FPOW,
          191 => Opcode::G_FPOWI,
          192 => Opcode::G_FEXP,
          193 => Opcode::G_FEXP2,
          194 => Opcode::G_FEXP10,
          195 => Opcode::G_FLOG,
          196 => Opcode::G_FLOG2,
          197 => Opcode::G_FLOG10,
          198 => Opcode::G_FLDEXP,
          199 => Opcode::G_FFREXP,
          200 => Opcode::G_FNEG,
          201 => Opcode::G_FPEXT,
          202 => Opcode::G_FPTRUNC,
          203 => Opcode::G_FPTOSI,
          204 => Opcode::G_FPTOUI,
          205 => Opcode::G_SITOFP,
          206 => Opcode::G_UITOFP,
          207 => Opcode::G_FPTOSI_SAT,
          208 => Opcode::G_FPTOUI_SAT,
          209 => Opcode::G_FABS,
          210 => Opcode::G_FCOPYSIGN,
          211 => Opcode::G_IS_FPCLASS,
          212 => Opcode::G_FCANONICALIZE,
          213 => Opcode::G_FMINNUM,
          214 => Opcode::G_FMAXNUM,
          215 => Opcode::G_FMINNUM_IEEE,
          216 => Opcode::G_FMAXNUM_IEEE,
          217 => Opcode::G_FMINIMUM,
          218 => Opcode::G_FMAXIMUM,
          219 => Opcode::G_FMINIMUMNUM,
          220 => Opcode::G_FMAXIMUMNUM,
          221 => Opcode::G_GET_FPENV,
          222 => Opcode::G_SET_FPENV,
          223 => Opcode::G_RESET_FPENV,
          224 => Opcode::G_GET_FPMODE,
          225 => Opcode::G_SET_FPMODE,
          226 => Opcode::G_RESET_FPMODE,
          227 => Opcode::G_GET_ROUNDING,
          228 => Opcode::G_PTR_ADD,
          229 => Opcode::G_PTRMASK,
          230 => Opcode::G_SMIN,
          231 => Opcode::G_SMAX,
          232 => Opcode::G_UMIN,
          233 => Opcode::G_UMAX,
          234 => Opcode::G_ABS,
          235 => Opcode::G_LROUND,
          236 => Opcode::G_LLROUND,
          237 => Opcode::G_BR,
          238 => Opcode::G_BRJT,
          239 => Opcode::G_VSCALE,
          240 => Opcode::G_INSERT_SUBVECTOR,
          241 => Opcode::G_EXTRACT_SUBVECTOR,
          242 => Opcode::G_INSERT_VECTOR_ELT,
          243 => Opcode::G_EXTRACT_VECTOR_ELT,
          244 => Opcode::G_SHUFFLE_VECTOR,
          245 => Opcode::G_SPLAT_VECTOR,
          246 => Opcode::G_STEP_VECTOR,
          247 => Opcode::G_VECTOR_COMPRESS,
          248 => Opcode::G_CTTZ,
          249 => Opcode::G_CTTZ_ZERO_UNDEF,
          250 => Opcode::G_CTLZ,
          251 => Opcode::G_CTLZ_ZERO_UNDEF,
          252 => Opcode::G_CTPOP,
          253 => Opcode::G_BSWAP,
          254 => Opcode::G_BITREVERSE,
          255 => Opcode::G_FCEIL,
          256 => Opcode::G_FCOS,
          257 => Opcode::G_FSIN,
          258 => Opcode::G_FSINCOS,
          259 => Opcode::G_FTAN,
          260 => Opcode::G_FACOS,
          261 => Opcode::G_FASIN,
          262 => Opcode::G_FATAN,
          263 => Opcode::G_FATAN2,
          264 => Opcode::G_FCOSH,
          265 => Opcode::G_FSINH,
          266 => Opcode::G_FTANH,
          267 => Opcode::G_FSQRT,
          268 => Opcode::G_FFLOOR,
          269 => Opcode::G_FRINT,
          270 => Opcode::G_FNEARBYINT,
          271 => Opcode::G_ADDRSPACE_CAST,
          272 => Opcode::G_BLOCK_ADDR,
          273 => Opcode::G_JUMP_TABLE,
          274 => Opcode::G_DYN_STACKALLOC,
          275 => Opcode::G_STACKSAVE,
          276 => Opcode::G_STACKRESTORE,
          277 => Opcode::G_STRICT_FADD,
          278 => Opcode::G_STRICT_FSUB,
          279 => Opcode::G_STRICT_FMUL,
          280 => Opcode::G_STRICT_FDIV,
          281 => Opcode::G_STRICT_FREM,
          282 => Opcode::G_STRICT_FMA,
          283 => Opcode::G_STRICT_FSQRT,
          284 => Opcode::G_STRICT_FLDEXP,
          285 => Opcode::G_READ_REGISTER,
          286 => Opcode::G_WRITE_REGISTER,
          287 => Opcode::G_MEMCPY,
          288 => Opcode::G_MEMCPY_INLINE,
          289 => Opcode::G_MEMMOVE,
          290 => Opcode::G_MEMSET,
          291 => Opcode::G_BZERO,
          292 => Opcode::G_TRAP,
          293 => Opcode::G_DEBUGTRAP,
          294 => Opcode::G_UBSANTRAP,
          295 => Opcode::G_VECREDUCE_SEQ_FADD,
          296 => Opcode::G_VECREDUCE_SEQ_FMUL,
          297 => Opcode::G_VECREDUCE_FADD,
          298 => Opcode::G_VECREDUCE_FMUL,
          299 => Opcode::G_VECREDUCE_FMAX,
          300 => Opcode::G_VECREDUCE_FMIN,
          301 => Opcode::G_VECREDUCE_FMAXIMUM,
          302 => Opcode::G_VECREDUCE_FMINIMUM,
          303 => Opcode::G_VECREDUCE_ADD,
          304 => Opcode::G_VECREDUCE_MUL,
          305 => Opcode::G_VECREDUCE_AND,
          306 => Opcode::G_VECREDUCE_OR,
          307 => Opcode::G_VECREDUCE_XOR,
          308 => Opcode::G_VECREDUCE_SMAX,
          309 => Opcode::G_VECREDUCE_SMIN,
          310 => Opcode::G_VECREDUCE_UMAX,
          311 => Opcode::G_VECREDUCE_UMIN,
          312 => Opcode::G_SBFX,
          313 => Opcode::G_UBFX,
          314 => Opcode::ABS,
          315 => Opcode::ADDSri,
          316 => Opcode::ADDSrr,
          317 => Opcode::ADDSrsi,
          318 => Opcode::ADDSrsr,
          319 => Opcode::ADJCALLSTACKDOWN,
          320 => Opcode::ADJCALLSTACKUP,
          321 => Opcode::ASRi,
          322 => Opcode::ASRr,
          323 => Opcode::ASRs1,
          324 => Opcode::B,
          325 => Opcode::BCCZi64,
          326 => Opcode::BCCi64,
          327 => Opcode::BLX_noip,
          328 => Opcode::BLX_pred_noip,
          329 => Opcode::BL_PUSHLR,
          330 => Opcode::BMOVPCB_CALL,
          331 => Opcode::BMOVPCRX_CALL,
          332 => Opcode::BR_JTadd,
          333 => Opcode::BR_JTm_i12,
          334 => Opcode::BR_JTm_rs,
          335 => Opcode::BR_JTr,
          336 => Opcode::BX_CALL,
          337 => Opcode::CMP_SWAP_16,
          338 => Opcode::CMP_SWAP_32,
          339 => Opcode::CMP_SWAP_64,
          340 => Opcode::CMP_SWAP_8,
          341 => Opcode::CONSTPOOL_ENTRY,
          342 => Opcode::COPY_STRUCT_BYVAL_I32,
          343 => Opcode::ITasm,
          344 => Opcode::Int_eh_sjlj_dispatchsetup,
          345 => Opcode::Int_eh_sjlj_longjmp,
          346 => Opcode::Int_eh_sjlj_setjmp,
          347 => Opcode::Int_eh_sjlj_setjmp_nofp,
          348 => Opcode::Int_eh_sjlj_setup_dispatch,
          349 => Opcode::JUMPTABLE_ADDRS,
          350 => Opcode::JUMPTABLE_INSTS,
          351 => Opcode::JUMPTABLE_TBB,
          352 => Opcode::JUMPTABLE_TBH,
          353 => Opcode::LDMIA_RET,
          354 => Opcode::LDRBT_POST,
          355 => Opcode::LDRConstPool,
          356 => Opcode::LDRHTii,
          357 => Opcode::LDRLIT_ga_abs,
          358 => Opcode::LDRLIT_ga_pcrel,
          359 => Opcode::LDRLIT_ga_pcrel_ldr,
          360 => Opcode::LDRSBTii,
          361 => Opcode::LDRSHTii,
          362 => Opcode::LDRT_POST,
          363 => Opcode::LEApcrel,
          364 => Opcode::LEApcrelJT,
          365 => Opcode::LOADDUAL,
          366 => Opcode::LSLi,
          367 => Opcode::LSLr,
          368 => Opcode::LSRi,
          369 => Opcode::LSRr,
          370 => Opcode::LSRs1,
          371 => Opcode::MEMCPY,
          372 => Opcode::MLAv5,
          373 => Opcode::MOVCCi,
          374 => Opcode::MOVCCi16,
          375 => Opcode::MOVCCi32imm,
          376 => Opcode::MOVCCr,
          377 => Opcode::MOVCCsi,
          378 => Opcode::MOVCCsr,
          379 => Opcode::MOVPCRX,
          380 => Opcode::MOVTi16_ga_pcrel,
          381 => Opcode::MOV_ga_pcrel,
          382 => Opcode::MOV_ga_pcrel_ldr,
          383 => Opcode::MOVi16_ga_pcrel,
          384 => Opcode::MOVi32imm,
          385 => Opcode::MQPRCopy,
          386 => Opcode::MQQPRLoad,
          387 => Opcode::MQQPRStore,
          388 => Opcode::MQQQQPRLoad,
          389 => Opcode::MQQQQPRStore,
          390 => Opcode::MULv5,
          391 => Opcode::MVE_MEMCPYLOOPINST,
          392 => Opcode::MVE_MEMSETLOOPINST,
          393 => Opcode::MVNCCi,
          394 => Opcode::PICADD,
          395 => Opcode::PICLDR,
          396 => Opcode::PICLDRB,
          397 => Opcode::PICLDRH,
          398 => Opcode::PICLDRSB,
          399 => Opcode::PICLDRSH,
          400 => Opcode::PICSTR,
          401 => Opcode::PICSTRB,
          402 => Opcode::PICSTRH,
          403 => Opcode::RORi,
          404 => Opcode::RORr,
          405 => Opcode::RRX,
          406 => Opcode::RRXi,
          407 => Opcode::RSBSri,
          408 => Opcode::RSBSrsi,
          409 => Opcode::RSBSrsr,
          410 => Opcode::SEH_EpilogEnd,
          411 => Opcode::SEH_EpilogStart,
          412 => Opcode::SEH_Nop,
          413 => Opcode::SEH_Nop_Ret,
          414 => Opcode::SEH_PrologEnd,
          415 => Opcode::SEH_SaveFRegs,
          416 => Opcode::SEH_SaveLR,
          417 => Opcode::SEH_SaveRegs,
          418 => Opcode::SEH_SaveRegs_Ret,
          419 => Opcode::SEH_SaveSP,
          420 => Opcode::SEH_StackAlloc,
          421 => Opcode::SMLALv5,
          422 => Opcode::SMULLv5,
          423 => Opcode::SPACE,
          424 => Opcode::STOREDUAL,
          425 => Opcode::STRBT_POST,
          426 => Opcode::STRBi_preidx,
          427 => Opcode::STRBr_preidx,
          428 => Opcode::STRH_preidx,
          429 => Opcode::STRT_POST,
          430 => Opcode::STRi_preidx,
          431 => Opcode::STRr_preidx,
          432 => Opcode::SUBS_PC_LR,
          433 => Opcode::SUBSri,
          434 => Opcode::SUBSrr,
          435 => Opcode::SUBSrsi,
          436 => Opcode::SUBSrsr,
          437 => Opcode::SpeculationBarrierISBDSBEndBB,
          438 => Opcode::SpeculationBarrierSBEndBB,
          439 => Opcode::TAILJMPd,
          440 => Opcode::TAILJMPr,
          441 => Opcode::TAILJMPr4,
          442 => Opcode::TCRETURNdi,
          443 => Opcode::TCRETURNri,
          444 => Opcode::TCRETURNrinotr12,
          445 => Opcode::TPsoft,
          446 => Opcode::UMLALv5,
          447 => Opcode::UMULLv5,
          448 => Opcode::VLD1LNdAsm_16,
          449 => Opcode::VLD1LNdAsm_32,
          450 => Opcode::VLD1LNdAsm_8,
          451 => Opcode::VLD1LNdWB_fixed_Asm_16,
          452 => Opcode::VLD1LNdWB_fixed_Asm_32,
          453 => Opcode::VLD1LNdWB_fixed_Asm_8,
          454 => Opcode::VLD1LNdWB_register_Asm_16,
          455 => Opcode::VLD1LNdWB_register_Asm_32,
          456 => Opcode::VLD1LNdWB_register_Asm_8,
          457 => Opcode::VLD2LNdAsm_16,
          458 => Opcode::VLD2LNdAsm_32,
          459 => Opcode::VLD2LNdAsm_8,
          460 => Opcode::VLD2LNdWB_fixed_Asm_16,
          461 => Opcode::VLD2LNdWB_fixed_Asm_32,
          462 => Opcode::VLD2LNdWB_fixed_Asm_8,
          463 => Opcode::VLD2LNdWB_register_Asm_16,
          464 => Opcode::VLD2LNdWB_register_Asm_32,
          465 => Opcode::VLD2LNdWB_register_Asm_8,
          466 => Opcode::VLD2LNqAsm_16,
          467 => Opcode::VLD2LNqAsm_32,
          468 => Opcode::VLD2LNqWB_fixed_Asm_16,
          469 => Opcode::VLD2LNqWB_fixed_Asm_32,
          470 => Opcode::VLD2LNqWB_register_Asm_16,
          471 => Opcode::VLD2LNqWB_register_Asm_32,
          472 => Opcode::VLD3DUPdAsm_16,
          473 => Opcode::VLD3DUPdAsm_32,
          474 => Opcode::VLD3DUPdAsm_8,
          475 => Opcode::VLD3DUPdWB_fixed_Asm_16,
          476 => Opcode::VLD3DUPdWB_fixed_Asm_32,
          477 => Opcode::VLD3DUPdWB_fixed_Asm_8,
          478 => Opcode::VLD3DUPdWB_register_Asm_16,
          479 => Opcode::VLD3DUPdWB_register_Asm_32,
          480 => Opcode::VLD3DUPdWB_register_Asm_8,
          481 => Opcode::VLD3DUPqAsm_16,
          482 => Opcode::VLD3DUPqAsm_32,
          483 => Opcode::VLD3DUPqAsm_8,
          484 => Opcode::VLD3DUPqWB_fixed_Asm_16,
          485 => Opcode::VLD3DUPqWB_fixed_Asm_32,
          486 => Opcode::VLD3DUPqWB_fixed_Asm_8,
          487 => Opcode::VLD3DUPqWB_register_Asm_16,
          488 => Opcode::VLD3DUPqWB_register_Asm_32,
          489 => Opcode::VLD3DUPqWB_register_Asm_8,
          490 => Opcode::VLD3LNdAsm_16,
          491 => Opcode::VLD3LNdAsm_32,
          492 => Opcode::VLD3LNdAsm_8,
          493 => Opcode::VLD3LNdWB_fixed_Asm_16,
          494 => Opcode::VLD3LNdWB_fixed_Asm_32,
          495 => Opcode::VLD3LNdWB_fixed_Asm_8,
          496 => Opcode::VLD3LNdWB_register_Asm_16,
          497 => Opcode::VLD3LNdWB_register_Asm_32,
          498 => Opcode::VLD3LNdWB_register_Asm_8,
          499 => Opcode::VLD3LNqAsm_16,
          500 => Opcode::VLD3LNqAsm_32,
          501 => Opcode::VLD3LNqWB_fixed_Asm_16,
          502 => Opcode::VLD3LNqWB_fixed_Asm_32,
          503 => Opcode::VLD3LNqWB_register_Asm_16,
          504 => Opcode::VLD3LNqWB_register_Asm_32,
          505 => Opcode::VLD3dAsm_16,
          506 => Opcode::VLD3dAsm_32,
          507 => Opcode::VLD3dAsm_8,
          508 => Opcode::VLD3dWB_fixed_Asm_16,
          509 => Opcode::VLD3dWB_fixed_Asm_32,
          510 => Opcode::VLD3dWB_fixed_Asm_8,
          511 => Opcode::VLD3dWB_register_Asm_16,
          512 => Opcode::VLD3dWB_register_Asm_32,
          513 => Opcode::VLD3dWB_register_Asm_8,
          514 => Opcode::VLD3qAsm_16,
          515 => Opcode::VLD3qAsm_32,
          516 => Opcode::VLD3qAsm_8,
          517 => Opcode::VLD3qWB_fixed_Asm_16,
          518 => Opcode::VLD3qWB_fixed_Asm_32,
          519 => Opcode::VLD3qWB_fixed_Asm_8,
          520 => Opcode::VLD3qWB_register_Asm_16,
          521 => Opcode::VLD3qWB_register_Asm_32,
          522 => Opcode::VLD3qWB_register_Asm_8,
          523 => Opcode::VLD4DUPdAsm_16,
          524 => Opcode::VLD4DUPdAsm_32,
          525 => Opcode::VLD4DUPdAsm_8,
          526 => Opcode::VLD4DUPdWB_fixed_Asm_16,
          527 => Opcode::VLD4DUPdWB_fixed_Asm_32,
          528 => Opcode::VLD4DUPdWB_fixed_Asm_8,
          529 => Opcode::VLD4DUPdWB_register_Asm_16,
          530 => Opcode::VLD4DUPdWB_register_Asm_32,
          531 => Opcode::VLD4DUPdWB_register_Asm_8,
          532 => Opcode::VLD4DUPqAsm_16,
          533 => Opcode::VLD4DUPqAsm_32,
          534 => Opcode::VLD4DUPqAsm_8,
          535 => Opcode::VLD4DUPqWB_fixed_Asm_16,
          536 => Opcode::VLD4DUPqWB_fixed_Asm_32,
          537 => Opcode::VLD4DUPqWB_fixed_Asm_8,
          538 => Opcode::VLD4DUPqWB_register_Asm_16,
          539 => Opcode::VLD4DUPqWB_register_Asm_32,
          540 => Opcode::VLD4DUPqWB_register_Asm_8,
          541 => Opcode::VLD4LNdAsm_16,
          542 => Opcode::VLD4LNdAsm_32,
          543 => Opcode::VLD4LNdAsm_8,
          544 => Opcode::VLD4LNdWB_fixed_Asm_16,
          545 => Opcode::VLD4LNdWB_fixed_Asm_32,
          546 => Opcode::VLD4LNdWB_fixed_Asm_8,
          547 => Opcode::VLD4LNdWB_register_Asm_16,
          548 => Opcode::VLD4LNdWB_register_Asm_32,
          549 => Opcode::VLD4LNdWB_register_Asm_8,
          550 => Opcode::VLD4LNqAsm_16,
          551 => Opcode::VLD4LNqAsm_32,
          552 => Opcode::VLD4LNqWB_fixed_Asm_16,
          553 => Opcode::VLD4LNqWB_fixed_Asm_32,
          554 => Opcode::VLD4LNqWB_register_Asm_16,
          555 => Opcode::VLD4LNqWB_register_Asm_32,
          556 => Opcode::VLD4dAsm_16,
          557 => Opcode::VLD4dAsm_32,
          558 => Opcode::VLD4dAsm_8,
          559 => Opcode::VLD4dWB_fixed_Asm_16,
          560 => Opcode::VLD4dWB_fixed_Asm_32,
          561 => Opcode::VLD4dWB_fixed_Asm_8,
          562 => Opcode::VLD4dWB_register_Asm_16,
          563 => Opcode::VLD4dWB_register_Asm_32,
          564 => Opcode::VLD4dWB_register_Asm_8,
          565 => Opcode::VLD4qAsm_16,
          566 => Opcode::VLD4qAsm_32,
          567 => Opcode::VLD4qAsm_8,
          568 => Opcode::VLD4qWB_fixed_Asm_16,
          569 => Opcode::VLD4qWB_fixed_Asm_32,
          570 => Opcode::VLD4qWB_fixed_Asm_8,
          571 => Opcode::VLD4qWB_register_Asm_16,
          572 => Opcode::VLD4qWB_register_Asm_32,
          573 => Opcode::VLD4qWB_register_Asm_8,
          574 => Opcode::VMOVD0,
          575 => Opcode::VMOVDcc,
          576 => Opcode::VMOVHcc,
          577 => Opcode::VMOVQ0,
          578 => Opcode::VMOVScc,
          579 => Opcode::VST1LNdAsm_16,
          580 => Opcode::VST1LNdAsm_32,
          581 => Opcode::VST1LNdAsm_8,
          582 => Opcode::VST1LNdWB_fixed_Asm_16,
          583 => Opcode::VST1LNdWB_fixed_Asm_32,
          584 => Opcode::VST1LNdWB_fixed_Asm_8,
          585 => Opcode::VST1LNdWB_register_Asm_16,
          586 => Opcode::VST1LNdWB_register_Asm_32,
          587 => Opcode::VST1LNdWB_register_Asm_8,
          588 => Opcode::VST2LNdAsm_16,
          589 => Opcode::VST2LNdAsm_32,
          590 => Opcode::VST2LNdAsm_8,
          591 => Opcode::VST2LNdWB_fixed_Asm_16,
          592 => Opcode::VST2LNdWB_fixed_Asm_32,
          593 => Opcode::VST2LNdWB_fixed_Asm_8,
          594 => Opcode::VST2LNdWB_register_Asm_16,
          595 => Opcode::VST2LNdWB_register_Asm_32,
          596 => Opcode::VST2LNdWB_register_Asm_8,
          597 => Opcode::VST2LNqAsm_16,
          598 => Opcode::VST2LNqAsm_32,
          599 => Opcode::VST2LNqWB_fixed_Asm_16,
          600 => Opcode::VST2LNqWB_fixed_Asm_32,
          601 => Opcode::VST2LNqWB_register_Asm_16,
          602 => Opcode::VST2LNqWB_register_Asm_32,
          603 => Opcode::VST3LNdAsm_16,
          604 => Opcode::VST3LNdAsm_32,
          605 => Opcode::VST3LNdAsm_8,
          606 => Opcode::VST3LNdWB_fixed_Asm_16,
          607 => Opcode::VST3LNdWB_fixed_Asm_32,
          608 => Opcode::VST3LNdWB_fixed_Asm_8,
          609 => Opcode::VST3LNdWB_register_Asm_16,
          610 => Opcode::VST3LNdWB_register_Asm_32,
          611 => Opcode::VST3LNdWB_register_Asm_8,
          612 => Opcode::VST3LNqAsm_16,
          613 => Opcode::VST3LNqAsm_32,
          614 => Opcode::VST3LNqWB_fixed_Asm_16,
          615 => Opcode::VST3LNqWB_fixed_Asm_32,
          616 => Opcode::VST3LNqWB_register_Asm_16,
          617 => Opcode::VST3LNqWB_register_Asm_32,
          618 => Opcode::VST3dAsm_16,
          619 => Opcode::VST3dAsm_32,
          620 => Opcode::VST3dAsm_8,
          621 => Opcode::VST3dWB_fixed_Asm_16,
          622 => Opcode::VST3dWB_fixed_Asm_32,
          623 => Opcode::VST3dWB_fixed_Asm_8,
          624 => Opcode::VST3dWB_register_Asm_16,
          625 => Opcode::VST3dWB_register_Asm_32,
          626 => Opcode::VST3dWB_register_Asm_8,
          627 => Opcode::VST3qAsm_16,
          628 => Opcode::VST3qAsm_32,
          629 => Opcode::VST3qAsm_8,
          630 => Opcode::VST3qWB_fixed_Asm_16,
          631 => Opcode::VST3qWB_fixed_Asm_32,
          632 => Opcode::VST3qWB_fixed_Asm_8,
          633 => Opcode::VST3qWB_register_Asm_16,
          634 => Opcode::VST3qWB_register_Asm_32,
          635 => Opcode::VST3qWB_register_Asm_8,
          636 => Opcode::VST4LNdAsm_16,
          637 => Opcode::VST4LNdAsm_32,
          638 => Opcode::VST4LNdAsm_8,
          639 => Opcode::VST4LNdWB_fixed_Asm_16,
          640 => Opcode::VST4LNdWB_fixed_Asm_32,
          641 => Opcode::VST4LNdWB_fixed_Asm_8,
          642 => Opcode::VST4LNdWB_register_Asm_16,
          643 => Opcode::VST4LNdWB_register_Asm_32,
          644 => Opcode::VST4LNdWB_register_Asm_8,
          645 => Opcode::VST4LNqAsm_16,
          646 => Opcode::VST4LNqAsm_32,
          647 => Opcode::VST4LNqWB_fixed_Asm_16,
          648 => Opcode::VST4LNqWB_fixed_Asm_32,
          649 => Opcode::VST4LNqWB_register_Asm_16,
          650 => Opcode::VST4LNqWB_register_Asm_32,
          651 => Opcode::VST4dAsm_16,
          652 => Opcode::VST4dAsm_32,
          653 => Opcode::VST4dAsm_8,
          654 => Opcode::VST4dWB_fixed_Asm_16,
          655 => Opcode::VST4dWB_fixed_Asm_32,
          656 => Opcode::VST4dWB_fixed_Asm_8,
          657 => Opcode::VST4dWB_register_Asm_16,
          658 => Opcode::VST4dWB_register_Asm_32,
          659 => Opcode::VST4dWB_register_Asm_8,
          660 => Opcode::VST4qAsm_16,
          661 => Opcode::VST4qAsm_32,
          662 => Opcode::VST4qAsm_8,
          663 => Opcode::VST4qWB_fixed_Asm_16,
          664 => Opcode::VST4qWB_fixed_Asm_32,
          665 => Opcode::VST4qWB_fixed_Asm_8,
          666 => Opcode::VST4qWB_register_Asm_16,
          667 => Opcode::VST4qWB_register_Asm_32,
          668 => Opcode::VST4qWB_register_Asm_8,
          669 => Opcode::WIN__CHKSTK,
          670 => Opcode::WIN__DBZCHK,
          671 => Opcode::t2ABS,
          672 => Opcode::t2ADDSri,
          673 => Opcode::t2ADDSrr,
          674 => Opcode::t2ADDSrs,
          675 => Opcode::t2BF_LabelPseudo,
          676 => Opcode::t2BR_JT,
          677 => Opcode::t2CALL_BTI,
          678 => Opcode::t2DoLoopStart,
          679 => Opcode::t2DoLoopStartTP,
          680 => Opcode::t2LDMIA_RET,
          681 => Opcode::t2LDRB_OFFSET_imm,
          682 => Opcode::t2LDRB_POST_imm,
          683 => Opcode::t2LDRB_PRE_imm,
          684 => Opcode::t2LDRBpcrel,
          685 => Opcode::t2LDRConstPool,
          686 => Opcode::t2LDRH_OFFSET_imm,
          687 => Opcode::t2LDRH_POST_imm,
          688 => Opcode::t2LDRH_PRE_imm,
          689 => Opcode::t2LDRHpcrel,
          690 => Opcode::t2LDRLIT_ga_pcrel,
          691 => Opcode::t2LDRSB_OFFSET_imm,
          692 => Opcode::t2LDRSB_POST_imm,
          693 => Opcode::t2LDRSB_PRE_imm,
          694 => Opcode::t2LDRSBpcrel,
          695 => Opcode::t2LDRSH_OFFSET_imm,
          696 => Opcode::t2LDRSH_POST_imm,
          697 => Opcode::t2LDRSH_PRE_imm,
          698 => Opcode::t2LDRSHpcrel,
          699 => Opcode::t2LDR_POST_imm,
          700 => Opcode::t2LDR_PRE_imm,
          701 => Opcode::t2LDRpci_pic,
          702 => Opcode::t2LDRpcrel,
          703 => Opcode::t2LEApcrel,
          704 => Opcode::t2LEApcrelJT,
          705 => Opcode::t2LoopDec,
          706 => Opcode::t2LoopEnd,
          707 => Opcode::t2LoopEndDec,
          708 => Opcode::t2MOVCCasr,
          709 => Opcode::t2MOVCCi,
          710 => Opcode::t2MOVCCi16,
          711 => Opcode::t2MOVCCi32imm,
          712 => Opcode::t2MOVCClsl,
          713 => Opcode::t2MOVCClsr,
          714 => Opcode::t2MOVCCr,
          715 => Opcode::t2MOVCCror,
          716 => Opcode::t2MOVSsi,
          717 => Opcode::t2MOVSsr,
          718 => Opcode::t2MOVTi16_ga_pcrel,
          719 => Opcode::t2MOV_ga_pcrel,
          720 => Opcode::t2MOVi16_ga_pcrel,
          721 => Opcode::t2MOVi32imm,
          722 => Opcode::t2MOVsi,
          723 => Opcode::t2MOVsr,
          724 => Opcode::t2MVNCCi,
          725 => Opcode::t2RSBSri,
          726 => Opcode::t2RSBSrs,
          727 => Opcode::t2STRB_OFFSET_imm,
          728 => Opcode::t2STRB_POST_imm,
          729 => Opcode::t2STRB_PRE_imm,
          730 => Opcode::t2STRB_preidx,
          731 => Opcode::t2STRH_OFFSET_imm,
          732 => Opcode::t2STRH_POST_imm,
          733 => Opcode::t2STRH_PRE_imm,
          734 => Opcode::t2STRH_preidx,
          735 => Opcode::t2STR_POST_imm,
          736 => Opcode::t2STR_PRE_imm,
          737 => Opcode::t2STR_preidx,
          738 => Opcode::t2SUBSri,
          739 => Opcode::t2SUBSrr,
          740 => Opcode::t2SUBSrs,
          741 => Opcode::t2SpeculationBarrierISBDSBEndBB,
          742 => Opcode::t2SpeculationBarrierSBEndBB,
          743 => Opcode::t2TBB_JT,
          744 => Opcode::t2TBH_JT,
          745 => Opcode::t2WhileLoopSetup,
          746 => Opcode::t2WhileLoopStart,
          747 => Opcode::t2WhileLoopStartLR,
          748 => Opcode::t2WhileLoopStartTP,
          749 => Opcode::tADCS,
          750 => Opcode::tADDSi3,
          751 => Opcode::tADDSi8,
          752 => Opcode::tADDSrr,
          753 => Opcode::tADDframe,
          754 => Opcode::tADJCALLSTACKDOWN,
          755 => Opcode::tADJCALLSTACKUP,
          756 => Opcode::tBLXNS_CALL,
          757 => Opcode::tBLXr_noip,
          758 => Opcode::tBL_PUSHLR,
          759 => Opcode::tBRIND,
          760 => Opcode::tBR_JTr,
          761 => Opcode::tBXNS_RET,
          762 => Opcode::tBX_CALL,
          763 => Opcode::tBX_RET,
          764 => Opcode::tBX_RET_vararg,
          765 => Opcode::tBfar,
          766 => Opcode::tCMP_SWAP_16,
          767 => Opcode::tCMP_SWAP_32,
          768 => Opcode::tCMP_SWAP_8,
          769 => Opcode::tLDMIA_UPD,
          770 => Opcode::tLDRConstPool,
          771 => Opcode::tLDRLIT_ga_abs,
          772 => Opcode::tLDRLIT_ga_pcrel,
          773 => Opcode::tLDR_postidx,
          774 => Opcode::tLDRpci_pic,
          775 => Opcode::tLEApcrel,
          776 => Opcode::tLEApcrelJT,
          777 => Opcode::tLSLSri,
          778 => Opcode::tMOVCCr_pseudo,
          779 => Opcode::tMOVi32imm,
          780 => Opcode::tPOP_RET,
          781 => Opcode::tRSBS,
          782 => Opcode::tSBCS,
          783 => Opcode::tSUBSi3,
          784 => Opcode::tSUBSi8,
          785 => Opcode::tSUBSrr,
          786 => Opcode::tTAILJMPd,
          787 => Opcode::tTAILJMPdND,
          788 => Opcode::tTAILJMPr,
          789 => Opcode::tTBB_JT,
          790 => Opcode::tTBH_JT,
          791 => Opcode::tTPsoft,
          792 => Opcode::ADCri,
          793 => Opcode::ADCrr,
          794 => Opcode::ADCrsi,
          795 => Opcode::ADCrsr,
          796 => Opcode::ADDri,
          797 => Opcode::ADDrr,
          798 => Opcode::ADDrsi,
          799 => Opcode::ADDrsr,
          800 => Opcode::ADR,
          801 => Opcode::AESD,
          802 => Opcode::AESE,
          803 => Opcode::AESIMC,
          804 => Opcode::AESMC,
          805 => Opcode::ANDri,
          806 => Opcode::ANDrr,
          807 => Opcode::ANDrsi,
          808 => Opcode::ANDrsr,
          809 => Opcode::BF16VDOTI_VDOTD,
          810 => Opcode::BF16VDOTI_VDOTQ,
          811 => Opcode::BF16VDOTS_VDOTD,
          812 => Opcode::BF16VDOTS_VDOTQ,
          813 => Opcode::BF16_VCVT,
          814 => Opcode::BF16_VCVTB,
          815 => Opcode::BF16_VCVTT,
          816 => Opcode::BFC,
          817 => Opcode::BFI,
          818 => Opcode::BICri,
          819 => Opcode::BICrr,
          820 => Opcode::BICrsi,
          821 => Opcode::BICrsr,
          822 => Opcode::BKPT,
          823 => Opcode::BL,
          824 => Opcode::BLX,
          825 => Opcode::BLX_pred,
          826 => Opcode::BLXi,
          827 => Opcode::BL_pred,
          828 => Opcode::BX,
          829 => Opcode::BXJ,
          830 => Opcode::BX_RET,
          831 => Opcode::BX_pred,
          832 => Opcode::Bcc,
          833 => Opcode::CDE_CX1,
          834 => Opcode::CDE_CX1A,
          835 => Opcode::CDE_CX1D,
          836 => Opcode::CDE_CX1DA,
          837 => Opcode::CDE_CX2,
          838 => Opcode::CDE_CX2A,
          839 => Opcode::CDE_CX2D,
          840 => Opcode::CDE_CX2DA,
          841 => Opcode::CDE_CX3,
          842 => Opcode::CDE_CX3A,
          843 => Opcode::CDE_CX3D,
          844 => Opcode::CDE_CX3DA,
          845 => Opcode::CDE_VCX1A_fpdp,
          846 => Opcode::CDE_VCX1A_fpsp,
          847 => Opcode::CDE_VCX1A_vec,
          848 => Opcode::CDE_VCX1_fpdp,
          849 => Opcode::CDE_VCX1_fpsp,
          850 => Opcode::CDE_VCX1_vec,
          851 => Opcode::CDE_VCX2A_fpdp,
          852 => Opcode::CDE_VCX2A_fpsp,
          853 => Opcode::CDE_VCX2A_vec,
          854 => Opcode::CDE_VCX2_fpdp,
          855 => Opcode::CDE_VCX2_fpsp,
          856 => Opcode::CDE_VCX2_vec,
          857 => Opcode::CDE_VCX3A_fpdp,
          858 => Opcode::CDE_VCX3A_fpsp,
          859 => Opcode::CDE_VCX3A_vec,
          860 => Opcode::CDE_VCX3_fpdp,
          861 => Opcode::CDE_VCX3_fpsp,
          862 => Opcode::CDE_VCX3_vec,
          863 => Opcode::CDP,
          864 => Opcode::CDP2,
          865 => Opcode::CLREX,
          866 => Opcode::CLZ,
          867 => Opcode::CMNri,
          868 => Opcode::CMNzrr,
          869 => Opcode::CMNzrsi,
          870 => Opcode::CMNzrsr,
          871 => Opcode::CMPri,
          872 => Opcode::CMPrr,
          873 => Opcode::CMPrsi,
          874 => Opcode::CMPrsr,
          875 => Opcode::CPS1p,
          876 => Opcode::CPS2p,
          877 => Opcode::CPS3p,
          878 => Opcode::CRC32B,
          879 => Opcode::CRC32CB,
          880 => Opcode::CRC32CH,
          881 => Opcode::CRC32CW,
          882 => Opcode::CRC32H,
          883 => Opcode::CRC32W,
          884 => Opcode::DBG,
          885 => Opcode::DMB,
          886 => Opcode::DSB,
          887 => Opcode::EORri,
          888 => Opcode::EORrr,
          889 => Opcode::EORrsi,
          890 => Opcode::EORrsr,
          891 => Opcode::ERET,
          892 => Opcode::FCONSTD,
          893 => Opcode::FCONSTH,
          894 => Opcode::FCONSTS,
          895 => Opcode::FLDMXDB_UPD,
          896 => Opcode::FLDMXIA,
          897 => Opcode::FLDMXIA_UPD,
          898 => Opcode::FMSTAT,
          899 => Opcode::FSTMXDB_UPD,
          900 => Opcode::FSTMXIA,
          901 => Opcode::FSTMXIA_UPD,
          902 => Opcode::HINT,
          903 => Opcode::HLT,
          904 => Opcode::HVC,
          905 => Opcode::ISB,
          906 => Opcode::LDA,
          907 => Opcode::LDAB,
          908 => Opcode::LDAEX,
          909 => Opcode::LDAEXB,
          910 => Opcode::LDAEXD,
          911 => Opcode::LDAEXH,
          912 => Opcode::LDAH,
          913 => Opcode::LDC2L_OFFSET,
          914 => Opcode::LDC2L_OPTION,
          915 => Opcode::LDC2L_POST,
          916 => Opcode::LDC2L_PRE,
          917 => Opcode::LDC2_OFFSET,
          918 => Opcode::LDC2_OPTION,
          919 => Opcode::LDC2_POST,
          920 => Opcode::LDC2_PRE,
          921 => Opcode::LDCL_OFFSET,
          922 => Opcode::LDCL_OPTION,
          923 => Opcode::LDCL_POST,
          924 => Opcode::LDCL_PRE,
          925 => Opcode::LDC_OFFSET,
          926 => Opcode::LDC_OPTION,
          927 => Opcode::LDC_POST,
          928 => Opcode::LDC_PRE,
          929 => Opcode::LDMDA,
          930 => Opcode::LDMDA_UPD,
          931 => Opcode::LDMDB,
          932 => Opcode::LDMDB_UPD,
          933 => Opcode::LDMIA,
          934 => Opcode::LDMIA_UPD,
          935 => Opcode::LDMIB,
          936 => Opcode::LDMIB_UPD,
          937 => Opcode::LDRBT_POST_IMM,
          938 => Opcode::LDRBT_POST_REG,
          939 => Opcode::LDRB_POST_IMM,
          940 => Opcode::LDRB_POST_REG,
          941 => Opcode::LDRB_PRE_IMM,
          942 => Opcode::LDRB_PRE_REG,
          943 => Opcode::LDRBi12,
          944 => Opcode::LDRBrs,
          945 => Opcode::LDRD,
          946 => Opcode::LDRD_POST,
          947 => Opcode::LDRD_PRE,
          948 => Opcode::LDREX,
          949 => Opcode::LDREXB,
          950 => Opcode::LDREXD,
          951 => Opcode::LDREXH,
          952 => Opcode::LDRH,
          953 => Opcode::LDRHTi,
          954 => Opcode::LDRHTr,
          955 => Opcode::LDRH_POST,
          956 => Opcode::LDRH_PRE,
          957 => Opcode::LDRSB,
          958 => Opcode::LDRSBTi,
          959 => Opcode::LDRSBTr,
          960 => Opcode::LDRSB_POST,
          961 => Opcode::LDRSB_PRE,
          962 => Opcode::LDRSH,
          963 => Opcode::LDRSHTi,
          964 => Opcode::LDRSHTr,
          965 => Opcode::LDRSH_POST,
          966 => Opcode::LDRSH_PRE,
          967 => Opcode::LDRT_POST_IMM,
          968 => Opcode::LDRT_POST_REG,
          969 => Opcode::LDR_POST_IMM,
          970 => Opcode::LDR_POST_REG,
          971 => Opcode::LDR_PRE_IMM,
          972 => Opcode::LDR_PRE_REG,
          973 => Opcode::LDRcp,
          974 => Opcode::LDRi12,
          975 => Opcode::LDRrs,
          976 => Opcode::MCR,
          977 => Opcode::MCR2,
          978 => Opcode::MCRR,
          979 => Opcode::MCRR2,
          980 => Opcode::MLA,
          981 => Opcode::MLS,
          982 => Opcode::MOVPCLR,
          983 => Opcode::MOVTi16,
          984 => Opcode::MOVi,
          985 => Opcode::MOVi16,
          986 => Opcode::MOVr,
          987 => Opcode::MOVr_TC,
          988 => Opcode::MOVsi,
          989 => Opcode::MOVsr,
          990 => Opcode::MRC,
          991 => Opcode::MRC2,
          992 => Opcode::MRRC,
          993 => Opcode::MRRC2,
          994 => Opcode::MRS,
          995 => Opcode::MRSbanked,
          996 => Opcode::MRSsys,
          997 => Opcode::MSR,
          998 => Opcode::MSRbanked,
          999 => Opcode::MSRi,
          1000 => Opcode::MUL,
          1001 => Opcode::MVE_ASRLi,
          1002 => Opcode::MVE_ASRLr,
          1003 => Opcode::MVE_DLSTP_16,
          1004 => Opcode::MVE_DLSTP_32,
          1005 => Opcode::MVE_DLSTP_64,
          1006 => Opcode::MVE_DLSTP_8,
          1007 => Opcode::MVE_LCTP,
          1008 => Opcode::MVE_LETP,
          1009 => Opcode::MVE_LSLLi,
          1010 => Opcode::MVE_LSLLr,
          1011 => Opcode::MVE_LSRL,
          1012 => Opcode::MVE_SQRSHR,
          1013 => Opcode::MVE_SQRSHRL,
          1014 => Opcode::MVE_SQSHL,
          1015 => Opcode::MVE_SQSHLL,
          1016 => Opcode::MVE_SRSHR,
          1017 => Opcode::MVE_SRSHRL,
          1018 => Opcode::MVE_UQRSHL,
          1019 => Opcode::MVE_UQRSHLL,
          1020 => Opcode::MVE_UQSHL,
          1021 => Opcode::MVE_UQSHLL,
          1022 => Opcode::MVE_URSHR,
          1023 => Opcode::MVE_URSHRL,
          1024 => Opcode::MVE_VABAVs16,
          1025 => Opcode::MVE_VABAVs32,
          1026 => Opcode::MVE_VABAVs8,
          1027 => Opcode::MVE_VABAVu16,
          1028 => Opcode::MVE_VABAVu32,
          1029 => Opcode::MVE_VABAVu8,
          1030 => Opcode::MVE_VABDf16,
          1031 => Opcode::MVE_VABDf32,
          1032 => Opcode::MVE_VABDs16,
          1033 => Opcode::MVE_VABDs32,
          1034 => Opcode::MVE_VABDs8,
          1035 => Opcode::MVE_VABDu16,
          1036 => Opcode::MVE_VABDu32,
          1037 => Opcode::MVE_VABDu8,
          1038 => Opcode::MVE_VABSf16,
          1039 => Opcode::MVE_VABSf32,
          1040 => Opcode::MVE_VABSs16,
          1041 => Opcode::MVE_VABSs32,
          1042 => Opcode::MVE_VABSs8,
          1043 => Opcode::MVE_VADC,
          1044 => Opcode::MVE_VADCI,
          1045 => Opcode::MVE_VADDLVs32acc,
          1046 => Opcode::MVE_VADDLVs32no_acc,
          1047 => Opcode::MVE_VADDLVu32acc,
          1048 => Opcode::MVE_VADDLVu32no_acc,
          1049 => Opcode::MVE_VADDVs16acc,
          1050 => Opcode::MVE_VADDVs16no_acc,
          1051 => Opcode::MVE_VADDVs32acc,
          1052 => Opcode::MVE_VADDVs32no_acc,
          1053 => Opcode::MVE_VADDVs8acc,
          1054 => Opcode::MVE_VADDVs8no_acc,
          1055 => Opcode::MVE_VADDVu16acc,
          1056 => Opcode::MVE_VADDVu16no_acc,
          1057 => Opcode::MVE_VADDVu32acc,
          1058 => Opcode::MVE_VADDVu32no_acc,
          1059 => Opcode::MVE_VADDVu8acc,
          1060 => Opcode::MVE_VADDVu8no_acc,
          1061 => Opcode::MVE_VADD_qr_f16,
          1062 => Opcode::MVE_VADD_qr_f32,
          1063 => Opcode::MVE_VADD_qr_i16,
          1064 => Opcode::MVE_VADD_qr_i32,
          1065 => Opcode::MVE_VADD_qr_i8,
          1066 => Opcode::MVE_VADDf16,
          1067 => Opcode::MVE_VADDf32,
          1068 => Opcode::MVE_VADDi16,
          1069 => Opcode::MVE_VADDi32,
          1070 => Opcode::MVE_VADDi8,
          1071 => Opcode::MVE_VAND,
          1072 => Opcode::MVE_VBIC,
          1073 => Opcode::MVE_VBICimmi16,
          1074 => Opcode::MVE_VBICimmi32,
          1075 => Opcode::MVE_VBRSR16,
          1076 => Opcode::MVE_VBRSR32,
          1077 => Opcode::MVE_VBRSR8,
          1078 => Opcode::MVE_VCADDf16,
          1079 => Opcode::MVE_VCADDf32,
          1080 => Opcode::MVE_VCADDi16,
          1081 => Opcode::MVE_VCADDi32,
          1082 => Opcode::MVE_VCADDi8,
          1083 => Opcode::MVE_VCLSs16,
          1084 => Opcode::MVE_VCLSs32,
          1085 => Opcode::MVE_VCLSs8,
          1086 => Opcode::MVE_VCLZs16,
          1087 => Opcode::MVE_VCLZs32,
          1088 => Opcode::MVE_VCLZs8,
          1089 => Opcode::MVE_VCMLAf16,
          1090 => Opcode::MVE_VCMLAf32,
          1091 => Opcode::MVE_VCMPf16,
          1092 => Opcode::MVE_VCMPf16r,
          1093 => Opcode::MVE_VCMPf32,
          1094 => Opcode::MVE_VCMPf32r,
          1095 => Opcode::MVE_VCMPi16,
          1096 => Opcode::MVE_VCMPi16r,
          1097 => Opcode::MVE_VCMPi32,
          1098 => Opcode::MVE_VCMPi32r,
          1099 => Opcode::MVE_VCMPi8,
          1100 => Opcode::MVE_VCMPi8r,
          1101 => Opcode::MVE_VCMPs16,
          1102 => Opcode::MVE_VCMPs16r,
          1103 => Opcode::MVE_VCMPs32,
          1104 => Opcode::MVE_VCMPs32r,
          1105 => Opcode::MVE_VCMPs8,
          1106 => Opcode::MVE_VCMPs8r,
          1107 => Opcode::MVE_VCMPu16,
          1108 => Opcode::MVE_VCMPu16r,
          1109 => Opcode::MVE_VCMPu32,
          1110 => Opcode::MVE_VCMPu32r,
          1111 => Opcode::MVE_VCMPu8,
          1112 => Opcode::MVE_VCMPu8r,
          1113 => Opcode::MVE_VCMULf16,
          1114 => Opcode::MVE_VCMULf32,
          1115 => Opcode::MVE_VCTP16,
          1116 => Opcode::MVE_VCTP32,
          1117 => Opcode::MVE_VCTP64,
          1118 => Opcode::MVE_VCTP8,
          1119 => Opcode::MVE_VCVTf16f32bh,
          1120 => Opcode::MVE_VCVTf16f32th,
          1121 => Opcode::MVE_VCVTf16s16_fix,
          1122 => Opcode::MVE_VCVTf16s16n,
          1123 => Opcode::MVE_VCVTf16u16_fix,
          1124 => Opcode::MVE_VCVTf16u16n,
          1125 => Opcode::MVE_VCVTf32f16bh,
          1126 => Opcode::MVE_VCVTf32f16th,
          1127 => Opcode::MVE_VCVTf32s32_fix,
          1128 => Opcode::MVE_VCVTf32s32n,
          1129 => Opcode::MVE_VCVTf32u32_fix,
          1130 => Opcode::MVE_VCVTf32u32n,
          1131 => Opcode::MVE_VCVTs16f16_fix,
          1132 => Opcode::MVE_VCVTs16f16a,
          1133 => Opcode::MVE_VCVTs16f16m,
          1134 => Opcode::MVE_VCVTs16f16n,
          1135 => Opcode::MVE_VCVTs16f16p,
          1136 => Opcode::MVE_VCVTs16f16z,
          1137 => Opcode::MVE_VCVTs32f32_fix,
          1138 => Opcode::MVE_VCVTs32f32a,
          1139 => Opcode::MVE_VCVTs32f32m,
          1140 => Opcode::MVE_VCVTs32f32n,
          1141 => Opcode::MVE_VCVTs32f32p,
          1142 => Opcode::MVE_VCVTs32f32z,
          1143 => Opcode::MVE_VCVTu16f16_fix,
          1144 => Opcode::MVE_VCVTu16f16a,
          1145 => Opcode::MVE_VCVTu16f16m,
          1146 => Opcode::MVE_VCVTu16f16n,
          1147 => Opcode::MVE_VCVTu16f16p,
          1148 => Opcode::MVE_VCVTu16f16z,
          1149 => Opcode::MVE_VCVTu32f32_fix,
          1150 => Opcode::MVE_VCVTu32f32a,
          1151 => Opcode::MVE_VCVTu32f32m,
          1152 => Opcode::MVE_VCVTu32f32n,
          1153 => Opcode::MVE_VCVTu32f32p,
          1154 => Opcode::MVE_VCVTu32f32z,
          1155 => Opcode::MVE_VDDUPu16,
          1156 => Opcode::MVE_VDDUPu32,
          1157 => Opcode::MVE_VDDUPu8,
          1158 => Opcode::MVE_VDUP16,
          1159 => Opcode::MVE_VDUP32,
          1160 => Opcode::MVE_VDUP8,
          1161 => Opcode::MVE_VDWDUPu16,
          1162 => Opcode::MVE_VDWDUPu32,
          1163 => Opcode::MVE_VDWDUPu8,
          1164 => Opcode::MVE_VEOR,
          1165 => Opcode::MVE_VFMA_qr_Sf16,
          1166 => Opcode::MVE_VFMA_qr_Sf32,
          1167 => Opcode::MVE_VFMA_qr_f16,
          1168 => Opcode::MVE_VFMA_qr_f32,
          1169 => Opcode::MVE_VFMAf16,
          1170 => Opcode::MVE_VFMAf32,
          1171 => Opcode::MVE_VFMSf16,
          1172 => Opcode::MVE_VFMSf32,
          1173 => Opcode::MVE_VHADD_qr_s16,
          1174 => Opcode::MVE_VHADD_qr_s32,
          1175 => Opcode::MVE_VHADD_qr_s8,
          1176 => Opcode::MVE_VHADD_qr_u16,
          1177 => Opcode::MVE_VHADD_qr_u32,
          1178 => Opcode::MVE_VHADD_qr_u8,
          1179 => Opcode::MVE_VHADDs16,
          1180 => Opcode::MVE_VHADDs32,
          1181 => Opcode::MVE_VHADDs8,
          1182 => Opcode::MVE_VHADDu16,
          1183 => Opcode::MVE_VHADDu32,
          1184 => Opcode::MVE_VHADDu8,
          1185 => Opcode::MVE_VHCADDs16,
          1186 => Opcode::MVE_VHCADDs32,
          1187 => Opcode::MVE_VHCADDs8,
          1188 => Opcode::MVE_VHSUB_qr_s16,
          1189 => Opcode::MVE_VHSUB_qr_s32,
          1190 => Opcode::MVE_VHSUB_qr_s8,
          1191 => Opcode::MVE_VHSUB_qr_u16,
          1192 => Opcode::MVE_VHSUB_qr_u32,
          1193 => Opcode::MVE_VHSUB_qr_u8,
          1194 => Opcode::MVE_VHSUBs16,
          1195 => Opcode::MVE_VHSUBs32,
          1196 => Opcode::MVE_VHSUBs8,
          1197 => Opcode::MVE_VHSUBu16,
          1198 => Opcode::MVE_VHSUBu32,
          1199 => Opcode::MVE_VHSUBu8,
          1200 => Opcode::MVE_VIDUPu16,
          1201 => Opcode::MVE_VIDUPu32,
          1202 => Opcode::MVE_VIDUPu8,
          1203 => Opcode::MVE_VIWDUPu16,
          1204 => Opcode::MVE_VIWDUPu32,
          1205 => Opcode::MVE_VIWDUPu8,
          1206 => Opcode::MVE_VLD20_16,
          1207 => Opcode::MVE_VLD20_16_wb,
          1208 => Opcode::MVE_VLD20_32,
          1209 => Opcode::MVE_VLD20_32_wb,
          1210 => Opcode::MVE_VLD20_8,
          1211 => Opcode::MVE_VLD20_8_wb,
          1212 => Opcode::MVE_VLD21_16,
          1213 => Opcode::MVE_VLD21_16_wb,
          1214 => Opcode::MVE_VLD21_32,
          1215 => Opcode::MVE_VLD21_32_wb,
          1216 => Opcode::MVE_VLD21_8,
          1217 => Opcode::MVE_VLD21_8_wb,
          1218 => Opcode::MVE_VLD40_16,
          1219 => Opcode::MVE_VLD40_16_wb,
          1220 => Opcode::MVE_VLD40_32,
          1221 => Opcode::MVE_VLD40_32_wb,
          1222 => Opcode::MVE_VLD40_8,
          1223 => Opcode::MVE_VLD40_8_wb,
          1224 => Opcode::MVE_VLD41_16,
          1225 => Opcode::MVE_VLD41_16_wb,
          1226 => Opcode::MVE_VLD41_32,
          1227 => Opcode::MVE_VLD41_32_wb,
          1228 => Opcode::MVE_VLD41_8,
          1229 => Opcode::MVE_VLD41_8_wb,
          1230 => Opcode::MVE_VLD42_16,
          1231 => Opcode::MVE_VLD42_16_wb,
          1232 => Opcode::MVE_VLD42_32,
          1233 => Opcode::MVE_VLD42_32_wb,
          1234 => Opcode::MVE_VLD42_8,
          1235 => Opcode::MVE_VLD42_8_wb,
          1236 => Opcode::MVE_VLD43_16,
          1237 => Opcode::MVE_VLD43_16_wb,
          1238 => Opcode::MVE_VLD43_32,
          1239 => Opcode::MVE_VLD43_32_wb,
          1240 => Opcode::MVE_VLD43_8,
          1241 => Opcode::MVE_VLD43_8_wb,
          1242 => Opcode::MVE_VLDRBS16,
          1243 => Opcode::MVE_VLDRBS16_post,
          1244 => Opcode::MVE_VLDRBS16_pre,
          1245 => Opcode::MVE_VLDRBS16_rq,
          1246 => Opcode::MVE_VLDRBS32,
          1247 => Opcode::MVE_VLDRBS32_post,
          1248 => Opcode::MVE_VLDRBS32_pre,
          1249 => Opcode::MVE_VLDRBS32_rq,
          1250 => Opcode::MVE_VLDRBU16,
          1251 => Opcode::MVE_VLDRBU16_post,
          1252 => Opcode::MVE_VLDRBU16_pre,
          1253 => Opcode::MVE_VLDRBU16_rq,
          1254 => Opcode::MVE_VLDRBU32,
          1255 => Opcode::MVE_VLDRBU32_post,
          1256 => Opcode::MVE_VLDRBU32_pre,
          1257 => Opcode::MVE_VLDRBU32_rq,
          1258 => Opcode::MVE_VLDRBU8,
          1259 => Opcode::MVE_VLDRBU8_post,
          1260 => Opcode::MVE_VLDRBU8_pre,
          1261 => Opcode::MVE_VLDRBU8_rq,
          1262 => Opcode::MVE_VLDRDU64_qi,
          1263 => Opcode::MVE_VLDRDU64_qi_pre,
          1264 => Opcode::MVE_VLDRDU64_rq,
          1265 => Opcode::MVE_VLDRDU64_rq_u,
          1266 => Opcode::MVE_VLDRHS32,
          1267 => Opcode::MVE_VLDRHS32_post,
          1268 => Opcode::MVE_VLDRHS32_pre,
          1269 => Opcode::MVE_VLDRHS32_rq,
          1270 => Opcode::MVE_VLDRHS32_rq_u,
          1271 => Opcode::MVE_VLDRHU16,
          1272 => Opcode::MVE_VLDRHU16_post,
          1273 => Opcode::MVE_VLDRHU16_pre,
          1274 => Opcode::MVE_VLDRHU16_rq,
          1275 => Opcode::MVE_VLDRHU16_rq_u,
          1276 => Opcode::MVE_VLDRHU32,
          1277 => Opcode::MVE_VLDRHU32_post,
          1278 => Opcode::MVE_VLDRHU32_pre,
          1279 => Opcode::MVE_VLDRHU32_rq,
          1280 => Opcode::MVE_VLDRHU32_rq_u,
          1281 => Opcode::MVE_VLDRWU32,
          1282 => Opcode::MVE_VLDRWU32_post,
          1283 => Opcode::MVE_VLDRWU32_pre,
          1284 => Opcode::MVE_VLDRWU32_qi,
          1285 => Opcode::MVE_VLDRWU32_qi_pre,
          1286 => Opcode::MVE_VLDRWU32_rq,
          1287 => Opcode::MVE_VLDRWU32_rq_u,
          1288 => Opcode::MVE_VMAXAVs16,
          1289 => Opcode::MVE_VMAXAVs32,
          1290 => Opcode::MVE_VMAXAVs8,
          1291 => Opcode::MVE_VMAXAs16,
          1292 => Opcode::MVE_VMAXAs32,
          1293 => Opcode::MVE_VMAXAs8,
          1294 => Opcode::MVE_VMAXNMAVf16,
          1295 => Opcode::MVE_VMAXNMAVf32,
          1296 => Opcode::MVE_VMAXNMAf16,
          1297 => Opcode::MVE_VMAXNMAf32,
          1298 => Opcode::MVE_VMAXNMVf16,
          1299 => Opcode::MVE_VMAXNMVf32,
          1300 => Opcode::MVE_VMAXNMf16,
          1301 => Opcode::MVE_VMAXNMf32,
          1302 => Opcode::MVE_VMAXVs16,
          1303 => Opcode::MVE_VMAXVs32,
          1304 => Opcode::MVE_VMAXVs8,
          1305 => Opcode::MVE_VMAXVu16,
          1306 => Opcode::MVE_VMAXVu32,
          1307 => Opcode::MVE_VMAXVu8,
          1308 => Opcode::MVE_VMAXs16,
          1309 => Opcode::MVE_VMAXs32,
          1310 => Opcode::MVE_VMAXs8,
          1311 => Opcode::MVE_VMAXu16,
          1312 => Opcode::MVE_VMAXu32,
          1313 => Opcode::MVE_VMAXu8,
          1314 => Opcode::MVE_VMINAVs16,
          1315 => Opcode::MVE_VMINAVs32,
          1316 => Opcode::MVE_VMINAVs8,
          1317 => Opcode::MVE_VMINAs16,
          1318 => Opcode::MVE_VMINAs32,
          1319 => Opcode::MVE_VMINAs8,
          1320 => Opcode::MVE_VMINNMAVf16,
          1321 => Opcode::MVE_VMINNMAVf32,
          1322 => Opcode::MVE_VMINNMAf16,
          1323 => Opcode::MVE_VMINNMAf32,
          1324 => Opcode::MVE_VMINNMVf16,
          1325 => Opcode::MVE_VMINNMVf32,
          1326 => Opcode::MVE_VMINNMf16,
          1327 => Opcode::MVE_VMINNMf32,
          1328 => Opcode::MVE_VMINVs16,
          1329 => Opcode::MVE_VMINVs32,
          1330 => Opcode::MVE_VMINVs8,
          1331 => Opcode::MVE_VMINVu16,
          1332 => Opcode::MVE_VMINVu32,
          1333 => Opcode::MVE_VMINVu8,
          1334 => Opcode::MVE_VMINs16,
          1335 => Opcode::MVE_VMINs32,
          1336 => Opcode::MVE_VMINs8,
          1337 => Opcode::MVE_VMINu16,
          1338 => Opcode::MVE_VMINu32,
          1339 => Opcode::MVE_VMINu8,
          1340 => Opcode::MVE_VMLADAVas16,
          1341 => Opcode::MVE_VMLADAVas32,
          1342 => Opcode::MVE_VMLADAVas8,
          1343 => Opcode::MVE_VMLADAVau16,
          1344 => Opcode::MVE_VMLADAVau32,
          1345 => Opcode::MVE_VMLADAVau8,
          1346 => Opcode::MVE_VMLADAVaxs16,
          1347 => Opcode::MVE_VMLADAVaxs32,
          1348 => Opcode::MVE_VMLADAVaxs8,
          1349 => Opcode::MVE_VMLADAVs16,
          1350 => Opcode::MVE_VMLADAVs32,
          1351 => Opcode::MVE_VMLADAVs8,
          1352 => Opcode::MVE_VMLADAVu16,
          1353 => Opcode::MVE_VMLADAVu32,
          1354 => Opcode::MVE_VMLADAVu8,
          1355 => Opcode::MVE_VMLADAVxs16,
          1356 => Opcode::MVE_VMLADAVxs32,
          1357 => Opcode::MVE_VMLADAVxs8,
          1358 => Opcode::MVE_VMLALDAVas16,
          1359 => Opcode::MVE_VMLALDAVas32,
          1360 => Opcode::MVE_VMLALDAVau16,
          1361 => Opcode::MVE_VMLALDAVau32,
          1362 => Opcode::MVE_VMLALDAVaxs16,
          1363 => Opcode::MVE_VMLALDAVaxs32,
          1364 => Opcode::MVE_VMLALDAVs16,
          1365 => Opcode::MVE_VMLALDAVs32,
          1366 => Opcode::MVE_VMLALDAVu16,
          1367 => Opcode::MVE_VMLALDAVu32,
          1368 => Opcode::MVE_VMLALDAVxs16,
          1369 => Opcode::MVE_VMLALDAVxs32,
          1370 => Opcode::MVE_VMLAS_qr_i16,
          1371 => Opcode::MVE_VMLAS_qr_i32,
          1372 => Opcode::MVE_VMLAS_qr_i8,
          1373 => Opcode::MVE_VMLA_qr_i16,
          1374 => Opcode::MVE_VMLA_qr_i32,
          1375 => Opcode::MVE_VMLA_qr_i8,
          1376 => Opcode::MVE_VMLSDAVas16,
          1377 => Opcode::MVE_VMLSDAVas32,
          1378 => Opcode::MVE_VMLSDAVas8,
          1379 => Opcode::MVE_VMLSDAVaxs16,
          1380 => Opcode::MVE_VMLSDAVaxs32,
          1381 => Opcode::MVE_VMLSDAVaxs8,
          1382 => Opcode::MVE_VMLSDAVs16,
          1383 => Opcode::MVE_VMLSDAVs32,
          1384 => Opcode::MVE_VMLSDAVs8,
          1385 => Opcode::MVE_VMLSDAVxs16,
          1386 => Opcode::MVE_VMLSDAVxs32,
          1387 => Opcode::MVE_VMLSDAVxs8,
          1388 => Opcode::MVE_VMLSLDAVas16,
          1389 => Opcode::MVE_VMLSLDAVas32,
          1390 => Opcode::MVE_VMLSLDAVaxs16,
          1391 => Opcode::MVE_VMLSLDAVaxs32,
          1392 => Opcode::MVE_VMLSLDAVs16,
          1393 => Opcode::MVE_VMLSLDAVs32,
          1394 => Opcode::MVE_VMLSLDAVxs16,
          1395 => Opcode::MVE_VMLSLDAVxs32,
          1396 => Opcode::MVE_VMOVLs16bh,
          1397 => Opcode::MVE_VMOVLs16th,
          1398 => Opcode::MVE_VMOVLs8bh,
          1399 => Opcode::MVE_VMOVLs8th,
          1400 => Opcode::MVE_VMOVLu16bh,
          1401 => Opcode::MVE_VMOVLu16th,
          1402 => Opcode::MVE_VMOVLu8bh,
          1403 => Opcode::MVE_VMOVLu8th,
          1404 => Opcode::MVE_VMOVNi16bh,
          1405 => Opcode::MVE_VMOVNi16th,
          1406 => Opcode::MVE_VMOVNi32bh,
          1407 => Opcode::MVE_VMOVNi32th,
          1408 => Opcode::MVE_VMOV_from_lane_32,
          1409 => Opcode::MVE_VMOV_from_lane_s16,
          1410 => Opcode::MVE_VMOV_from_lane_s8,
          1411 => Opcode::MVE_VMOV_from_lane_u16,
          1412 => Opcode::MVE_VMOV_from_lane_u8,
          1413 => Opcode::MVE_VMOV_q_rr,
          1414 => Opcode::MVE_VMOV_rr_q,
          1415 => Opcode::MVE_VMOV_to_lane_16,
          1416 => Opcode::MVE_VMOV_to_lane_32,
          1417 => Opcode::MVE_VMOV_to_lane_8,
          1418 => Opcode::MVE_VMOVimmf32,
          1419 => Opcode::MVE_VMOVimmi16,
          1420 => Opcode::MVE_VMOVimmi32,
          1421 => Opcode::MVE_VMOVimmi64,
          1422 => Opcode::MVE_VMOVimmi8,
          1423 => Opcode::MVE_VMULHs16,
          1424 => Opcode::MVE_VMULHs32,
          1425 => Opcode::MVE_VMULHs8,
          1426 => Opcode::MVE_VMULHu16,
          1427 => Opcode::MVE_VMULHu32,
          1428 => Opcode::MVE_VMULHu8,
          1429 => Opcode::MVE_VMULLBp16,
          1430 => Opcode::MVE_VMULLBp8,
          1431 => Opcode::MVE_VMULLBs16,
          1432 => Opcode::MVE_VMULLBs32,
          1433 => Opcode::MVE_VMULLBs8,
          1434 => Opcode::MVE_VMULLBu16,
          1435 => Opcode::MVE_VMULLBu32,
          1436 => Opcode::MVE_VMULLBu8,
          1437 => Opcode::MVE_VMULLTp16,
          1438 => Opcode::MVE_VMULLTp8,
          1439 => Opcode::MVE_VMULLTs16,
          1440 => Opcode::MVE_VMULLTs32,
          1441 => Opcode::MVE_VMULLTs8,
          1442 => Opcode::MVE_VMULLTu16,
          1443 => Opcode::MVE_VMULLTu32,
          1444 => Opcode::MVE_VMULLTu8,
          1445 => Opcode::MVE_VMUL_qr_f16,
          1446 => Opcode::MVE_VMUL_qr_f32,
          1447 => Opcode::MVE_VMUL_qr_i16,
          1448 => Opcode::MVE_VMUL_qr_i32,
          1449 => Opcode::MVE_VMUL_qr_i8,
          1450 => Opcode::MVE_VMULf16,
          1451 => Opcode::MVE_VMULf32,
          1452 => Opcode::MVE_VMULi16,
          1453 => Opcode::MVE_VMULi32,
          1454 => Opcode::MVE_VMULi8,
          1455 => Opcode::MVE_VMVN,
          1456 => Opcode::MVE_VMVNimmi16,
          1457 => Opcode::MVE_VMVNimmi32,
          1458 => Opcode::MVE_VNEGf16,
          1459 => Opcode::MVE_VNEGf32,
          1460 => Opcode::MVE_VNEGs16,
          1461 => Opcode::MVE_VNEGs32,
          1462 => Opcode::MVE_VNEGs8,
          1463 => Opcode::MVE_VORN,
          1464 => Opcode::MVE_VORR,
          1465 => Opcode::MVE_VORRimmi16,
          1466 => Opcode::MVE_VORRimmi32,
          1467 => Opcode::MVE_VPNOT,
          1468 => Opcode::MVE_VPSEL,
          1469 => Opcode::MVE_VPST,
          1470 => Opcode::MVE_VPTv16i8,
          1471 => Opcode::MVE_VPTv16i8r,
          1472 => Opcode::MVE_VPTv16s8,
          1473 => Opcode::MVE_VPTv16s8r,
          1474 => Opcode::MVE_VPTv16u8,
          1475 => Opcode::MVE_VPTv16u8r,
          1476 => Opcode::MVE_VPTv4f32,
          1477 => Opcode::MVE_VPTv4f32r,
          1478 => Opcode::MVE_VPTv4i32,
          1479 => Opcode::MVE_VPTv4i32r,
          1480 => Opcode::MVE_VPTv4s32,
          1481 => Opcode::MVE_VPTv4s32r,
          1482 => Opcode::MVE_VPTv4u32,
          1483 => Opcode::MVE_VPTv4u32r,
          1484 => Opcode::MVE_VPTv8f16,
          1485 => Opcode::MVE_VPTv8f16r,
          1486 => Opcode::MVE_VPTv8i16,
          1487 => Opcode::MVE_VPTv8i16r,
          1488 => Opcode::MVE_VPTv8s16,
          1489 => Opcode::MVE_VPTv8s16r,
          1490 => Opcode::MVE_VPTv8u16,
          1491 => Opcode::MVE_VPTv8u16r,
          1492 => Opcode::MVE_VQABSs16,
          1493 => Opcode::MVE_VQABSs32,
          1494 => Opcode::MVE_VQABSs8,
          1495 => Opcode::MVE_VQADD_qr_s16,
          1496 => Opcode::MVE_VQADD_qr_s32,
          1497 => Opcode::MVE_VQADD_qr_s8,
          1498 => Opcode::MVE_VQADD_qr_u16,
          1499 => Opcode::MVE_VQADD_qr_u32,
          1500 => Opcode::MVE_VQADD_qr_u8,
          1501 => Opcode::MVE_VQADDs16,
          1502 => Opcode::MVE_VQADDs32,
          1503 => Opcode::MVE_VQADDs8,
          1504 => Opcode::MVE_VQADDu16,
          1505 => Opcode::MVE_VQADDu32,
          1506 => Opcode::MVE_VQADDu8,
          1507 => Opcode::MVE_VQDMLADHXs16,
          1508 => Opcode::MVE_VQDMLADHXs32,
          1509 => Opcode::MVE_VQDMLADHXs8,
          1510 => Opcode::MVE_VQDMLADHs16,
          1511 => Opcode::MVE_VQDMLADHs32,
          1512 => Opcode::MVE_VQDMLADHs8,
          1513 => Opcode::MVE_VQDMLAH_qrs16,
          1514 => Opcode::MVE_VQDMLAH_qrs32,
          1515 => Opcode::MVE_VQDMLAH_qrs8,
          1516 => Opcode::MVE_VQDMLASH_qrs16,
          1517 => Opcode::MVE_VQDMLASH_qrs32,
          1518 => Opcode::MVE_VQDMLASH_qrs8,
          1519 => Opcode::MVE_VQDMLSDHXs16,
          1520 => Opcode::MVE_VQDMLSDHXs32,
          1521 => Opcode::MVE_VQDMLSDHXs8,
          1522 => Opcode::MVE_VQDMLSDHs16,
          1523 => Opcode::MVE_VQDMLSDHs32,
          1524 => Opcode::MVE_VQDMLSDHs8,
          1525 => Opcode::MVE_VQDMULH_qr_s16,
          1526 => Opcode::MVE_VQDMULH_qr_s32,
          1527 => Opcode::MVE_VQDMULH_qr_s8,
          1528 => Opcode::MVE_VQDMULHi16,
          1529 => Opcode::MVE_VQDMULHi32,
          1530 => Opcode::MVE_VQDMULHi8,
          1531 => Opcode::MVE_VQDMULL_qr_s16bh,
          1532 => Opcode::MVE_VQDMULL_qr_s16th,
          1533 => Opcode::MVE_VQDMULL_qr_s32bh,
          1534 => Opcode::MVE_VQDMULL_qr_s32th,
          1535 => Opcode::MVE_VQDMULLs16bh,
          1536 => Opcode::MVE_VQDMULLs16th,
          1537 => Opcode::MVE_VQDMULLs32bh,
          1538 => Opcode::MVE_VQDMULLs32th,
          1539 => Opcode::MVE_VQMOVNs16bh,
          1540 => Opcode::MVE_VQMOVNs16th,
          1541 => Opcode::MVE_VQMOVNs32bh,
          1542 => Opcode::MVE_VQMOVNs32th,
          1543 => Opcode::MVE_VQMOVNu16bh,
          1544 => Opcode::MVE_VQMOVNu16th,
          1545 => Opcode::MVE_VQMOVNu32bh,
          1546 => Opcode::MVE_VQMOVNu32th,
          1547 => Opcode::MVE_VQMOVUNs16bh,
          1548 => Opcode::MVE_VQMOVUNs16th,
          1549 => Opcode::MVE_VQMOVUNs32bh,
          1550 => Opcode::MVE_VQMOVUNs32th,
          1551 => Opcode::MVE_VQNEGs16,
          1552 => Opcode::MVE_VQNEGs32,
          1553 => Opcode::MVE_VQNEGs8,
          1554 => Opcode::MVE_VQRDMLADHXs16,
          1555 => Opcode::MVE_VQRDMLADHXs32,
          1556 => Opcode::MVE_VQRDMLADHXs8,
          1557 => Opcode::MVE_VQRDMLADHs16,
          1558 => Opcode::MVE_VQRDMLADHs32,
          1559 => Opcode::MVE_VQRDMLADHs8,
          1560 => Opcode::MVE_VQRDMLAH_qrs16,
          1561 => Opcode::MVE_VQRDMLAH_qrs32,
          1562 => Opcode::MVE_VQRDMLAH_qrs8,
          1563 => Opcode::MVE_VQRDMLASH_qrs16,
          1564 => Opcode::MVE_VQRDMLASH_qrs32,
          1565 => Opcode::MVE_VQRDMLASH_qrs8,
          1566 => Opcode::MVE_VQRDMLSDHXs16,
          1567 => Opcode::MVE_VQRDMLSDHXs32,
          1568 => Opcode::MVE_VQRDMLSDHXs8,
          1569 => Opcode::MVE_VQRDMLSDHs16,
          1570 => Opcode::MVE_VQRDMLSDHs32,
          1571 => Opcode::MVE_VQRDMLSDHs8,
          1572 => Opcode::MVE_VQRDMULH_qr_s16,
          1573 => Opcode::MVE_VQRDMULH_qr_s32,
          1574 => Opcode::MVE_VQRDMULH_qr_s8,
          1575 => Opcode::MVE_VQRDMULHi16,
          1576 => Opcode::MVE_VQRDMULHi32,
          1577 => Opcode::MVE_VQRDMULHi8,
          1578 => Opcode::MVE_VQRSHL_by_vecs16,
          1579 => Opcode::MVE_VQRSHL_by_vecs32,
          1580 => Opcode::MVE_VQRSHL_by_vecs8,
          1581 => Opcode::MVE_VQRSHL_by_vecu16,
          1582 => Opcode::MVE_VQRSHL_by_vecu32,
          1583 => Opcode::MVE_VQRSHL_by_vecu8,
          1584 => Opcode::MVE_VQRSHL_qrs16,
          1585 => Opcode::MVE_VQRSHL_qrs32,
          1586 => Opcode::MVE_VQRSHL_qrs8,
          1587 => Opcode::MVE_VQRSHL_qru16,
          1588 => Opcode::MVE_VQRSHL_qru32,
          1589 => Opcode::MVE_VQRSHL_qru8,
          1590 => Opcode::MVE_VQRSHRNbhs16,
          1591 => Opcode::MVE_VQRSHRNbhs32,
          1592 => Opcode::MVE_VQRSHRNbhu16,
          1593 => Opcode::MVE_VQRSHRNbhu32,
          1594 => Opcode::MVE_VQRSHRNths16,
          1595 => Opcode::MVE_VQRSHRNths32,
          1596 => Opcode::MVE_VQRSHRNthu16,
          1597 => Opcode::MVE_VQRSHRNthu32,
          1598 => Opcode::MVE_VQRSHRUNs16bh,
          1599 => Opcode::MVE_VQRSHRUNs16th,
          1600 => Opcode::MVE_VQRSHRUNs32bh,
          1601 => Opcode::MVE_VQRSHRUNs32th,
          1602 => Opcode::MVE_VQSHLU_imms16,
          1603 => Opcode::MVE_VQSHLU_imms32,
          1604 => Opcode::MVE_VQSHLU_imms8,
          1605 => Opcode::MVE_VQSHL_by_vecs16,
          1606 => Opcode::MVE_VQSHL_by_vecs32,
          1607 => Opcode::MVE_VQSHL_by_vecs8,
          1608 => Opcode::MVE_VQSHL_by_vecu16,
          1609 => Opcode::MVE_VQSHL_by_vecu32,
          1610 => Opcode::MVE_VQSHL_by_vecu8,
          1611 => Opcode::MVE_VQSHL_qrs16,
          1612 => Opcode::MVE_VQSHL_qrs32,
          1613 => Opcode::MVE_VQSHL_qrs8,
          1614 => Opcode::MVE_VQSHL_qru16,
          1615 => Opcode::MVE_VQSHL_qru32,
          1616 => Opcode::MVE_VQSHL_qru8,
          1617 => Opcode::MVE_VQSHLimms16,
          1618 => Opcode::MVE_VQSHLimms32,
          1619 => Opcode::MVE_VQSHLimms8,
          1620 => Opcode::MVE_VQSHLimmu16,
          1621 => Opcode::MVE_VQSHLimmu32,
          1622 => Opcode::MVE_VQSHLimmu8,
          1623 => Opcode::MVE_VQSHRNbhs16,
          1624 => Opcode::MVE_VQSHRNbhs32,
          1625 => Opcode::MVE_VQSHRNbhu16,
          1626 => Opcode::MVE_VQSHRNbhu32,
          1627 => Opcode::MVE_VQSHRNths16,
          1628 => Opcode::MVE_VQSHRNths32,
          1629 => Opcode::MVE_VQSHRNthu16,
          1630 => Opcode::MVE_VQSHRNthu32,
          1631 => Opcode::MVE_VQSHRUNs16bh,
          1632 => Opcode::MVE_VQSHRUNs16th,
          1633 => Opcode::MVE_VQSHRUNs32bh,
          1634 => Opcode::MVE_VQSHRUNs32th,
          1635 => Opcode::MVE_VQSUB_qr_s16,
          1636 => Opcode::MVE_VQSUB_qr_s32,
          1637 => Opcode::MVE_VQSUB_qr_s8,
          1638 => Opcode::MVE_VQSUB_qr_u16,
          1639 => Opcode::MVE_VQSUB_qr_u32,
          1640 => Opcode::MVE_VQSUB_qr_u8,
          1641 => Opcode::MVE_VQSUBs16,
          1642 => Opcode::MVE_VQSUBs32,
          1643 => Opcode::MVE_VQSUBs8,
          1644 => Opcode::MVE_VQSUBu16,
          1645 => Opcode::MVE_VQSUBu32,
          1646 => Opcode::MVE_VQSUBu8,
          1647 => Opcode::MVE_VREV16_8,
          1648 => Opcode::MVE_VREV32_16,
          1649 => Opcode::MVE_VREV32_8,
          1650 => Opcode::MVE_VREV64_16,
          1651 => Opcode::MVE_VREV64_32,
          1652 => Opcode::MVE_VREV64_8,
          1653 => Opcode::MVE_VRHADDs16,
          1654 => Opcode::MVE_VRHADDs32,
          1655 => Opcode::MVE_VRHADDs8,
          1656 => Opcode::MVE_VRHADDu16,
          1657 => Opcode::MVE_VRHADDu32,
          1658 => Opcode::MVE_VRHADDu8,
          1659 => Opcode::MVE_VRINTf16A,
          1660 => Opcode::MVE_VRINTf16M,
          1661 => Opcode::MVE_VRINTf16N,
          1662 => Opcode::MVE_VRINTf16P,
          1663 => Opcode::MVE_VRINTf16X,
          1664 => Opcode::MVE_VRINTf16Z,
          1665 => Opcode::MVE_VRINTf32A,
          1666 => Opcode::MVE_VRINTf32M,
          1667 => Opcode::MVE_VRINTf32N,
          1668 => Opcode::MVE_VRINTf32P,
          1669 => Opcode::MVE_VRINTf32X,
          1670 => Opcode::MVE_VRINTf32Z,
          1671 => Opcode::MVE_VRMLALDAVHas32,
          1672 => Opcode::MVE_VRMLALDAVHau32,
          1673 => Opcode::MVE_VRMLALDAVHaxs32,
          1674 => Opcode::MVE_VRMLALDAVHs32,
          1675 => Opcode::MVE_VRMLALDAVHu32,
          1676 => Opcode::MVE_VRMLALDAVHxs32,
          1677 => Opcode::MVE_VRMLSLDAVHas32,
          1678 => Opcode::MVE_VRMLSLDAVHaxs32,
          1679 => Opcode::MVE_VRMLSLDAVHs32,
          1680 => Opcode::MVE_VRMLSLDAVHxs32,
          1681 => Opcode::MVE_VRMULHs16,
          1682 => Opcode::MVE_VRMULHs32,
          1683 => Opcode::MVE_VRMULHs8,
          1684 => Opcode::MVE_VRMULHu16,
          1685 => Opcode::MVE_VRMULHu32,
          1686 => Opcode::MVE_VRMULHu8,
          1687 => Opcode::MVE_VRSHL_by_vecs16,
          1688 => Opcode::MVE_VRSHL_by_vecs32,
          1689 => Opcode::MVE_VRSHL_by_vecs8,
          1690 => Opcode::MVE_VRSHL_by_vecu16,
          1691 => Opcode::MVE_VRSHL_by_vecu32,
          1692 => Opcode::MVE_VRSHL_by_vecu8,
          1693 => Opcode::MVE_VRSHL_qrs16,
          1694 => Opcode::MVE_VRSHL_qrs32,
          1695 => Opcode::MVE_VRSHL_qrs8,
          1696 => Opcode::MVE_VRSHL_qru16,
          1697 => Opcode::MVE_VRSHL_qru32,
          1698 => Opcode::MVE_VRSHL_qru8,
          1699 => Opcode::MVE_VRSHRNi16bh,
          1700 => Opcode::MVE_VRSHRNi16th,
          1701 => Opcode::MVE_VRSHRNi32bh,
          1702 => Opcode::MVE_VRSHRNi32th,
          1703 => Opcode::MVE_VRSHR_imms16,
          1704 => Opcode::MVE_VRSHR_imms32,
          1705 => Opcode::MVE_VRSHR_imms8,
          1706 => Opcode::MVE_VRSHR_immu16,
          1707 => Opcode::MVE_VRSHR_immu32,
          1708 => Opcode::MVE_VRSHR_immu8,
          1709 => Opcode::MVE_VSBC,
          1710 => Opcode::MVE_VSBCI,
          1711 => Opcode::MVE_VSHLC,
          1712 => Opcode::MVE_VSHLL_imms16bh,
          1713 => Opcode::MVE_VSHLL_imms16th,
          1714 => Opcode::MVE_VSHLL_imms8bh,
          1715 => Opcode::MVE_VSHLL_imms8th,
          1716 => Opcode::MVE_VSHLL_immu16bh,
          1717 => Opcode::MVE_VSHLL_immu16th,
          1718 => Opcode::MVE_VSHLL_immu8bh,
          1719 => Opcode::MVE_VSHLL_immu8th,
          1720 => Opcode::MVE_VSHLL_lws16bh,
          1721 => Opcode::MVE_VSHLL_lws16th,
          1722 => Opcode::MVE_VSHLL_lws8bh,
          1723 => Opcode::MVE_VSHLL_lws8th,
          1724 => Opcode::MVE_VSHLL_lwu16bh,
          1725 => Opcode::MVE_VSHLL_lwu16th,
          1726 => Opcode::MVE_VSHLL_lwu8bh,
          1727 => Opcode::MVE_VSHLL_lwu8th,
          1728 => Opcode::MVE_VSHL_by_vecs16,
          1729 => Opcode::MVE_VSHL_by_vecs32,
          1730 => Opcode::MVE_VSHL_by_vecs8,
          1731 => Opcode::MVE_VSHL_by_vecu16,
          1732 => Opcode::MVE_VSHL_by_vecu32,
          1733 => Opcode::MVE_VSHL_by_vecu8,
          1734 => Opcode::MVE_VSHL_immi16,
          1735 => Opcode::MVE_VSHL_immi32,
          1736 => Opcode::MVE_VSHL_immi8,
          1737 => Opcode::MVE_VSHL_qrs16,
          1738 => Opcode::MVE_VSHL_qrs32,
          1739 => Opcode::MVE_VSHL_qrs8,
          1740 => Opcode::MVE_VSHL_qru16,
          1741 => Opcode::MVE_VSHL_qru32,
          1742 => Opcode::MVE_VSHL_qru8,
          1743 => Opcode::MVE_VSHRNi16bh,
          1744 => Opcode::MVE_VSHRNi16th,
          1745 => Opcode::MVE_VSHRNi32bh,
          1746 => Opcode::MVE_VSHRNi32th,
          1747 => Opcode::MVE_VSHR_imms16,
          1748 => Opcode::MVE_VSHR_imms32,
          1749 => Opcode::MVE_VSHR_imms8,
          1750 => Opcode::MVE_VSHR_immu16,
          1751 => Opcode::MVE_VSHR_immu32,
          1752 => Opcode::MVE_VSHR_immu8,
          1753 => Opcode::MVE_VSLIimm16,
          1754 => Opcode::MVE_VSLIimm32,
          1755 => Opcode::MVE_VSLIimm8,
          1756 => Opcode::MVE_VSRIimm16,
          1757 => Opcode::MVE_VSRIimm32,
          1758 => Opcode::MVE_VSRIimm8,
          1759 => Opcode::MVE_VST20_16,
          1760 => Opcode::MVE_VST20_16_wb,
          1761 => Opcode::MVE_VST20_32,
          1762 => Opcode::MVE_VST20_32_wb,
          1763 => Opcode::MVE_VST20_8,
          1764 => Opcode::MVE_VST20_8_wb,
          1765 => Opcode::MVE_VST21_16,
          1766 => Opcode::MVE_VST21_16_wb,
          1767 => Opcode::MVE_VST21_32,
          1768 => Opcode::MVE_VST21_32_wb,
          1769 => Opcode::MVE_VST21_8,
          1770 => Opcode::MVE_VST21_8_wb,
          1771 => Opcode::MVE_VST40_16,
          1772 => Opcode::MVE_VST40_16_wb,
          1773 => Opcode::MVE_VST40_32,
          1774 => Opcode::MVE_VST40_32_wb,
          1775 => Opcode::MVE_VST40_8,
          1776 => Opcode::MVE_VST40_8_wb,
          1777 => Opcode::MVE_VST41_16,
          1778 => Opcode::MVE_VST41_16_wb,
          1779 => Opcode::MVE_VST41_32,
          1780 => Opcode::MVE_VST41_32_wb,
          1781 => Opcode::MVE_VST41_8,
          1782 => Opcode::MVE_VST41_8_wb,
          1783 => Opcode::MVE_VST42_16,
          1784 => Opcode::MVE_VST42_16_wb,
          1785 => Opcode::MVE_VST42_32,
          1786 => Opcode::MVE_VST42_32_wb,
          1787 => Opcode::MVE_VST42_8,
          1788 => Opcode::MVE_VST42_8_wb,
          1789 => Opcode::MVE_VST43_16,
          1790 => Opcode::MVE_VST43_16_wb,
          1791 => Opcode::MVE_VST43_32,
          1792 => Opcode::MVE_VST43_32_wb,
          1793 => Opcode::MVE_VST43_8,
          1794 => Opcode::MVE_VST43_8_wb,
          1795 => Opcode::MVE_VSTRB16,
          1796 => Opcode::MVE_VSTRB16_post,
          1797 => Opcode::MVE_VSTRB16_pre,
          1798 => Opcode::MVE_VSTRB16_rq,
          1799 => Opcode::MVE_VSTRB32,
          1800 => Opcode::MVE_VSTRB32_post,
          1801 => Opcode::MVE_VSTRB32_pre,
          1802 => Opcode::MVE_VSTRB32_rq,
          1803 => Opcode::MVE_VSTRB8_rq,
          1804 => Opcode::MVE_VSTRBU8,
          1805 => Opcode::MVE_VSTRBU8_post,
          1806 => Opcode::MVE_VSTRBU8_pre,
          1807 => Opcode::MVE_VSTRD64_qi,
          1808 => Opcode::MVE_VSTRD64_qi_pre,
          1809 => Opcode::MVE_VSTRD64_rq,
          1810 => Opcode::MVE_VSTRD64_rq_u,
          1811 => Opcode::MVE_VSTRH16_rq,
          1812 => Opcode::MVE_VSTRH16_rq_u,
          1813 => Opcode::MVE_VSTRH32,
          1814 => Opcode::MVE_VSTRH32_post,
          1815 => Opcode::MVE_VSTRH32_pre,
          1816 => Opcode::MVE_VSTRH32_rq,
          1817 => Opcode::MVE_VSTRH32_rq_u,
          1818 => Opcode::MVE_VSTRHU16,
          1819 => Opcode::MVE_VSTRHU16_post,
          1820 => Opcode::MVE_VSTRHU16_pre,
          1821 => Opcode::MVE_VSTRW32_qi,
          1822 => Opcode::MVE_VSTRW32_qi_pre,
          1823 => Opcode::MVE_VSTRW32_rq,
          1824 => Opcode::MVE_VSTRW32_rq_u,
          1825 => Opcode::MVE_VSTRWU32,
          1826 => Opcode::MVE_VSTRWU32_post,
          1827 => Opcode::MVE_VSTRWU32_pre,
          1828 => Opcode::MVE_VSUB_qr_f16,
          1829 => Opcode::MVE_VSUB_qr_f32,
          1830 => Opcode::MVE_VSUB_qr_i16,
          1831 => Opcode::MVE_VSUB_qr_i32,
          1832 => Opcode::MVE_VSUB_qr_i8,
          1833 => Opcode::MVE_VSUBf16,
          1834 => Opcode::MVE_VSUBf32,
          1835 => Opcode::MVE_VSUBi16,
          1836 => Opcode::MVE_VSUBi32,
          1837 => Opcode::MVE_VSUBi8,
          1838 => Opcode::MVE_WLSTP_16,
          1839 => Opcode::MVE_WLSTP_32,
          1840 => Opcode::MVE_WLSTP_64,
          1841 => Opcode::MVE_WLSTP_8,
          1842 => Opcode::MVNi,
          1843 => Opcode::MVNr,
          1844 => Opcode::MVNsi,
          1845 => Opcode::MVNsr,
          1846 => Opcode::NEON_VMAXNMNDf,
          1847 => Opcode::NEON_VMAXNMNDh,
          1848 => Opcode::NEON_VMAXNMNQf,
          1849 => Opcode::NEON_VMAXNMNQh,
          1850 => Opcode::NEON_VMINNMNDf,
          1851 => Opcode::NEON_VMINNMNDh,
          1852 => Opcode::NEON_VMINNMNQf,
          1853 => Opcode::NEON_VMINNMNQh,
          1854 => Opcode::ORRri,
          1855 => Opcode::ORRrr,
          1856 => Opcode::ORRrsi,
          1857 => Opcode::ORRrsr,
          1858 => Opcode::PKHBT,
          1859 => Opcode::PKHTB,
          1860 => Opcode::PLDWi12,
          1861 => Opcode::PLDWrs,
          1862 => Opcode::PLDi12,
          1863 => Opcode::PLDrs,
          1864 => Opcode::PLIi12,
          1865 => Opcode::PLIrs,
          1866 => Opcode::QADD,
          1867 => Opcode::QADD16,
          1868 => Opcode::QADD8,
          1869 => Opcode::QASX,
          1870 => Opcode::QDADD,
          1871 => Opcode::QDSUB,
          1872 => Opcode::QSAX,
          1873 => Opcode::QSUB,
          1874 => Opcode::QSUB16,
          1875 => Opcode::QSUB8,
          1876 => Opcode::RBIT,
          1877 => Opcode::REV,
          1878 => Opcode::REV16,
          1879 => Opcode::REVSH,
          1880 => Opcode::RFEDA,
          1881 => Opcode::RFEDA_UPD,
          1882 => Opcode::RFEDB,
          1883 => Opcode::RFEDB_UPD,
          1884 => Opcode::RFEIA,
          1885 => Opcode::RFEIA_UPD,
          1886 => Opcode::RFEIB,
          1887 => Opcode::RFEIB_UPD,
          1888 => Opcode::RSBri,
          1889 => Opcode::RSBrr,
          1890 => Opcode::RSBrsi,
          1891 => Opcode::RSBrsr,
          1892 => Opcode::RSCri,
          1893 => Opcode::RSCrr,
          1894 => Opcode::RSCrsi,
          1895 => Opcode::RSCrsr,
          1896 => Opcode::SADD16,
          1897 => Opcode::SADD8,
          1898 => Opcode::SASX,
          1899 => Opcode::SB,
          1900 => Opcode::SBCri,
          1901 => Opcode::SBCrr,
          1902 => Opcode::SBCrsi,
          1903 => Opcode::SBCrsr,
          1904 => Opcode::SBFX,
          1905 => Opcode::SDIV,
          1906 => Opcode::SEL,
          1907 => Opcode::SETEND,
          1908 => Opcode::SETPAN,
          1909 => Opcode::SHA1C,
          1910 => Opcode::SHA1H,
          1911 => Opcode::SHA1M,
          1912 => Opcode::SHA1P,
          1913 => Opcode::SHA1SU0,
          1914 => Opcode::SHA1SU1,
          1915 => Opcode::SHA256H,
          1916 => Opcode::SHA256H2,
          1917 => Opcode::SHA256SU0,
          1918 => Opcode::SHA256SU1,
          1919 => Opcode::SHADD16,
          1920 => Opcode::SHADD8,
          1921 => Opcode::SHASX,
          1922 => Opcode::SHSAX,
          1923 => Opcode::SHSUB16,
          1924 => Opcode::SHSUB8,
          1925 => Opcode::SMC,
          1926 => Opcode::SMLABB,
          1927 => Opcode::SMLABT,
          1928 => Opcode::SMLAD,
          1929 => Opcode::SMLADX,
          1930 => Opcode::SMLAL,
          1931 => Opcode::SMLALBB,
          1932 => Opcode::SMLALBT,
          1933 => Opcode::SMLALD,
          1934 => Opcode::SMLALDX,
          1935 => Opcode::SMLALTB,
          1936 => Opcode::SMLALTT,
          1937 => Opcode::SMLATB,
          1938 => Opcode::SMLATT,
          1939 => Opcode::SMLAWB,
          1940 => Opcode::SMLAWT,
          1941 => Opcode::SMLSD,
          1942 => Opcode::SMLSDX,
          1943 => Opcode::SMLSLD,
          1944 => Opcode::SMLSLDX,
          1945 => Opcode::SMMLA,
          1946 => Opcode::SMMLAR,
          1947 => Opcode::SMMLS,
          1948 => Opcode::SMMLSR,
          1949 => Opcode::SMMUL,
          1950 => Opcode::SMMULR,
          1951 => Opcode::SMUAD,
          1952 => Opcode::SMUADX,
          1953 => Opcode::SMULBB,
          1954 => Opcode::SMULBT,
          1955 => Opcode::SMULL,
          1956 => Opcode::SMULTB,
          1957 => Opcode::SMULTT,
          1958 => Opcode::SMULWB,
          1959 => Opcode::SMULWT,
          1960 => Opcode::SMUSD,
          1961 => Opcode::SMUSDX,
          1962 => Opcode::SRSDA,
          1963 => Opcode::SRSDA_UPD,
          1964 => Opcode::SRSDB,
          1965 => Opcode::SRSDB_UPD,
          1966 => Opcode::SRSIA,
          1967 => Opcode::SRSIA_UPD,
          1968 => Opcode::SRSIB,
          1969 => Opcode::SRSIB_UPD,
          1970 => Opcode::SSAT,
          1971 => Opcode::SSAT16,
          1972 => Opcode::SSAX,
          1973 => Opcode::SSUB16,
          1974 => Opcode::SSUB8,
          1975 => Opcode::STC2L_OFFSET,
          1976 => Opcode::STC2L_OPTION,
          1977 => Opcode::STC2L_POST,
          1978 => Opcode::STC2L_PRE,
          1979 => Opcode::STC2_OFFSET,
          1980 => Opcode::STC2_OPTION,
          1981 => Opcode::STC2_POST,
          1982 => Opcode::STC2_PRE,
          1983 => Opcode::STCL_OFFSET,
          1984 => Opcode::STCL_OPTION,
          1985 => Opcode::STCL_POST,
          1986 => Opcode::STCL_PRE,
          1987 => Opcode::STC_OFFSET,
          1988 => Opcode::STC_OPTION,
          1989 => Opcode::STC_POST,
          1990 => Opcode::STC_PRE,
          1991 => Opcode::STL,
          1992 => Opcode::STLB,
          1993 => Opcode::STLEX,
          1994 => Opcode::STLEXB,
          1995 => Opcode::STLEXD,
          1996 => Opcode::STLEXH,
          1997 => Opcode::STLH,
          1998 => Opcode::STMDA,
          1999 => Opcode::STMDA_UPD,
          2000 => Opcode::STMDB,
          2001 => Opcode::STMDB_UPD,
          2002 => Opcode::STMIA,
          2003 => Opcode::STMIA_UPD,
          2004 => Opcode::STMIB,
          2005 => Opcode::STMIB_UPD,
          2006 => Opcode::STRBT_POST_IMM,
          2007 => Opcode::STRBT_POST_REG,
          2008 => Opcode::STRB_POST_IMM,
          2009 => Opcode::STRB_POST_REG,
          2010 => Opcode::STRB_PRE_IMM,
          2011 => Opcode::STRB_PRE_REG,
          2012 => Opcode::STRBi12,
          2013 => Opcode::STRBrs,
          2014 => Opcode::STRD,
          2015 => Opcode::STRD_POST,
          2016 => Opcode::STRD_PRE,
          2017 => Opcode::STREX,
          2018 => Opcode::STREXB,
          2019 => Opcode::STREXD,
          2020 => Opcode::STREXH,
          2021 => Opcode::STRH,
          2022 => Opcode::STRHTi,
          2023 => Opcode::STRHTr,
          2024 => Opcode::STRH_POST,
          2025 => Opcode::STRH_PRE,
          2026 => Opcode::STRT_POST_IMM,
          2027 => Opcode::STRT_POST_REG,
          2028 => Opcode::STR_POST_IMM,
          2029 => Opcode::STR_POST_REG,
          2030 => Opcode::STR_PRE_IMM,
          2031 => Opcode::STR_PRE_REG,
          2032 => Opcode::STRi12,
          2033 => Opcode::STRrs,
          2034 => Opcode::SUBri,
          2035 => Opcode::SUBrr,
          2036 => Opcode::SUBrsi,
          2037 => Opcode::SUBrsr,
          2038 => Opcode::SVC,
          2039 => Opcode::SWP,
          2040 => Opcode::SWPB,
          2041 => Opcode::SXTAB,
          2042 => Opcode::SXTAB16,
          2043 => Opcode::SXTAH,
          2044 => Opcode::SXTB,
          2045 => Opcode::SXTB16,
          2046 => Opcode::SXTH,
          2047 => Opcode::TEQri,
          2048 => Opcode::TEQrr,
          2049 => Opcode::TEQrsi,
          2050 => Opcode::TEQrsr,
          2051 => Opcode::TRAP,
          2052 => Opcode::TRAPNaCl,
          2053 => Opcode::TSB,
          2054 => Opcode::TSTri,
          2055 => Opcode::TSTrr,
          2056 => Opcode::TSTrsi,
          2057 => Opcode::TSTrsr,
          2058 => Opcode::UADD16,
          2059 => Opcode::UADD8,
          2060 => Opcode::UASX,
          2061 => Opcode::UBFX,
          2062 => Opcode::UDF,
          2063 => Opcode::UDIV,
          2064 => Opcode::UHADD16,
          2065 => Opcode::UHADD8,
          2066 => Opcode::UHASX,
          2067 => Opcode::UHSAX,
          2068 => Opcode::UHSUB16,
          2069 => Opcode::UHSUB8,
          2070 => Opcode::UMAAL,
          2071 => Opcode::UMLAL,
          2072 => Opcode::UMULL,
          2073 => Opcode::UQADD16,
          2074 => Opcode::UQADD8,
          2075 => Opcode::UQASX,
          2076 => Opcode::UQSAX,
          2077 => Opcode::UQSUB16,
          2078 => Opcode::UQSUB8,
          2079 => Opcode::USAD8,
          2080 => Opcode::USADA8,
          2081 => Opcode::USAT,
          2082 => Opcode::USAT16,
          2083 => Opcode::USAX,
          2084 => Opcode::USUB16,
          2085 => Opcode::USUB8,
          2086 => Opcode::UXTAB,
          2087 => Opcode::UXTAB16,
          2088 => Opcode::UXTAH,
          2089 => Opcode::UXTB,
          2090 => Opcode::UXTB16,
          2091 => Opcode::UXTH,
          2092 => Opcode::VABALsv2i64,
          2093 => Opcode::VABALsv4i32,
          2094 => Opcode::VABALsv8i16,
          2095 => Opcode::VABALuv2i64,
          2096 => Opcode::VABALuv4i32,
          2097 => Opcode::VABALuv8i16,
          2098 => Opcode::VABAsv16i8,
          2099 => Opcode::VABAsv2i32,
          2100 => Opcode::VABAsv4i16,
          2101 => Opcode::VABAsv4i32,
          2102 => Opcode::VABAsv8i16,
          2103 => Opcode::VABAsv8i8,
          2104 => Opcode::VABAuv16i8,
          2105 => Opcode::VABAuv2i32,
          2106 => Opcode::VABAuv4i16,
          2107 => Opcode::VABAuv4i32,
          2108 => Opcode::VABAuv8i16,
          2109 => Opcode::VABAuv8i8,
          2110 => Opcode::VABDLsv2i64,
          2111 => Opcode::VABDLsv4i32,
          2112 => Opcode::VABDLsv8i16,
          2113 => Opcode::VABDLuv2i64,
          2114 => Opcode::VABDLuv4i32,
          2115 => Opcode::VABDLuv8i16,
          2116 => Opcode::VABDfd,
          2117 => Opcode::VABDfq,
          2118 => Opcode::VABDhd,
          2119 => Opcode::VABDhq,
          2120 => Opcode::VABDsv16i8,
          2121 => Opcode::VABDsv2i32,
          2122 => Opcode::VABDsv4i16,
          2123 => Opcode::VABDsv4i32,
          2124 => Opcode::VABDsv8i16,
          2125 => Opcode::VABDsv8i8,
          2126 => Opcode::VABDuv16i8,
          2127 => Opcode::VABDuv2i32,
          2128 => Opcode::VABDuv4i16,
          2129 => Opcode::VABDuv4i32,
          2130 => Opcode::VABDuv8i16,
          2131 => Opcode::VABDuv8i8,
          2132 => Opcode::VABSD,
          2133 => Opcode::VABSH,
          2134 => Opcode::VABSS,
          2135 => Opcode::VABSfd,
          2136 => Opcode::VABSfq,
          2137 => Opcode::VABShd,
          2138 => Opcode::VABShq,
          2139 => Opcode::VABSv16i8,
          2140 => Opcode::VABSv2i32,
          2141 => Opcode::VABSv4i16,
          2142 => Opcode::VABSv4i32,
          2143 => Opcode::VABSv8i16,
          2144 => Opcode::VABSv8i8,
          2145 => Opcode::VACGEfd,
          2146 => Opcode::VACGEfq,
          2147 => Opcode::VACGEhd,
          2148 => Opcode::VACGEhq,
          2149 => Opcode::VACGTfd,
          2150 => Opcode::VACGTfq,
          2151 => Opcode::VACGThd,
          2152 => Opcode::VACGThq,
          2153 => Opcode::VADDD,
          2154 => Opcode::VADDH,
          2155 => Opcode::VADDHNv2i32,
          2156 => Opcode::VADDHNv4i16,
          2157 => Opcode::VADDHNv8i8,
          2158 => Opcode::VADDLsv2i64,
          2159 => Opcode::VADDLsv4i32,
          2160 => Opcode::VADDLsv8i16,
          2161 => Opcode::VADDLuv2i64,
          2162 => Opcode::VADDLuv4i32,
          2163 => Opcode::VADDLuv8i16,
          2164 => Opcode::VADDS,
          2165 => Opcode::VADDWsv2i64,
          2166 => Opcode::VADDWsv4i32,
          2167 => Opcode::VADDWsv8i16,
          2168 => Opcode::VADDWuv2i64,
          2169 => Opcode::VADDWuv4i32,
          2170 => Opcode::VADDWuv8i16,
          2171 => Opcode::VADDfd,
          2172 => Opcode::VADDfq,
          2173 => Opcode::VADDhd,
          2174 => Opcode::VADDhq,
          2175 => Opcode::VADDv16i8,
          2176 => Opcode::VADDv1i64,
          2177 => Opcode::VADDv2i32,
          2178 => Opcode::VADDv2i64,
          2179 => Opcode::VADDv4i16,
          2180 => Opcode::VADDv4i32,
          2181 => Opcode::VADDv8i16,
          2182 => Opcode::VADDv8i8,
          2183 => Opcode::VANDd,
          2184 => Opcode::VANDq,
          2185 => Opcode::VBF16MALBQ,
          2186 => Opcode::VBF16MALBQI,
          2187 => Opcode::VBF16MALTQ,
          2188 => Opcode::VBF16MALTQI,
          2189 => Opcode::VBICd,
          2190 => Opcode::VBICiv2i32,
          2191 => Opcode::VBICiv4i16,
          2192 => Opcode::VBICiv4i32,
          2193 => Opcode::VBICiv8i16,
          2194 => Opcode::VBICq,
          2195 => Opcode::VBIFd,
          2196 => Opcode::VBIFq,
          2197 => Opcode::VBITd,
          2198 => Opcode::VBITq,
          2199 => Opcode::VBSLd,
          2200 => Opcode::VBSLq,
          2201 => Opcode::VBSPd,
          2202 => Opcode::VBSPq,
          2203 => Opcode::VCADDv2f32,
          2204 => Opcode::VCADDv4f16,
          2205 => Opcode::VCADDv4f32,
          2206 => Opcode::VCADDv8f16,
          2207 => Opcode::VCEQfd,
          2208 => Opcode::VCEQfq,
          2209 => Opcode::VCEQhd,
          2210 => Opcode::VCEQhq,
          2211 => Opcode::VCEQv16i8,
          2212 => Opcode::VCEQv2i32,
          2213 => Opcode::VCEQv4i16,
          2214 => Opcode::VCEQv4i32,
          2215 => Opcode::VCEQv8i16,
          2216 => Opcode::VCEQv8i8,
          2217 => Opcode::VCEQzv16i8,
          2218 => Opcode::VCEQzv2f32,
          2219 => Opcode::VCEQzv2i32,
          2220 => Opcode::VCEQzv4f16,
          2221 => Opcode::VCEQzv4f32,
          2222 => Opcode::VCEQzv4i16,
          2223 => Opcode::VCEQzv4i32,
          2224 => Opcode::VCEQzv8f16,
          2225 => Opcode::VCEQzv8i16,
          2226 => Opcode::VCEQzv8i8,
          2227 => Opcode::VCGEfd,
          2228 => Opcode::VCGEfq,
          2229 => Opcode::VCGEhd,
          2230 => Opcode::VCGEhq,
          2231 => Opcode::VCGEsv16i8,
          2232 => Opcode::VCGEsv2i32,
          2233 => Opcode::VCGEsv4i16,
          2234 => Opcode::VCGEsv4i32,
          2235 => Opcode::VCGEsv8i16,
          2236 => Opcode::VCGEsv8i8,
          2237 => Opcode::VCGEuv16i8,
          2238 => Opcode::VCGEuv2i32,
          2239 => Opcode::VCGEuv4i16,
          2240 => Opcode::VCGEuv4i32,
          2241 => Opcode::VCGEuv8i16,
          2242 => Opcode::VCGEuv8i8,
          2243 => Opcode::VCGEzv16i8,
          2244 => Opcode::VCGEzv2f32,
          2245 => Opcode::VCGEzv2i32,
          2246 => Opcode::VCGEzv4f16,
          2247 => Opcode::VCGEzv4f32,
          2248 => Opcode::VCGEzv4i16,
          2249 => Opcode::VCGEzv4i32,
          2250 => Opcode::VCGEzv8f16,
          2251 => Opcode::VCGEzv8i16,
          2252 => Opcode::VCGEzv8i8,
          2253 => Opcode::VCGTfd,
          2254 => Opcode::VCGTfq,
          2255 => Opcode::VCGThd,
          2256 => Opcode::VCGThq,
          2257 => Opcode::VCGTsv16i8,
          2258 => Opcode::VCGTsv2i32,
          2259 => Opcode::VCGTsv4i16,
          2260 => Opcode::VCGTsv4i32,
          2261 => Opcode::VCGTsv8i16,
          2262 => Opcode::VCGTsv8i8,
          2263 => Opcode::VCGTuv16i8,
          2264 => Opcode::VCGTuv2i32,
          2265 => Opcode::VCGTuv4i16,
          2266 => Opcode::VCGTuv4i32,
          2267 => Opcode::VCGTuv8i16,
          2268 => Opcode::VCGTuv8i8,
          2269 => Opcode::VCGTzv16i8,
          2270 => Opcode::VCGTzv2f32,
          2271 => Opcode::VCGTzv2i32,
          2272 => Opcode::VCGTzv4f16,
          2273 => Opcode::VCGTzv4f32,
          2274 => Opcode::VCGTzv4i16,
          2275 => Opcode::VCGTzv4i32,
          2276 => Opcode::VCGTzv8f16,
          2277 => Opcode::VCGTzv8i16,
          2278 => Opcode::VCGTzv8i8,
          2279 => Opcode::VCLEzv16i8,
          2280 => Opcode::VCLEzv2f32,
          2281 => Opcode::VCLEzv2i32,
          2282 => Opcode::VCLEzv4f16,
          2283 => Opcode::VCLEzv4f32,
          2284 => Opcode::VCLEzv4i16,
          2285 => Opcode::VCLEzv4i32,
          2286 => Opcode::VCLEzv8f16,
          2287 => Opcode::VCLEzv8i16,
          2288 => Opcode::VCLEzv8i8,
          2289 => Opcode::VCLSv16i8,
          2290 => Opcode::VCLSv2i32,
          2291 => Opcode::VCLSv4i16,
          2292 => Opcode::VCLSv4i32,
          2293 => Opcode::VCLSv8i16,
          2294 => Opcode::VCLSv8i8,
          2295 => Opcode::VCLTzv16i8,
          2296 => Opcode::VCLTzv2f32,
          2297 => Opcode::VCLTzv2i32,
          2298 => Opcode::VCLTzv4f16,
          2299 => Opcode::VCLTzv4f32,
          2300 => Opcode::VCLTzv4i16,
          2301 => Opcode::VCLTzv4i32,
          2302 => Opcode::VCLTzv8f16,
          2303 => Opcode::VCLTzv8i16,
          2304 => Opcode::VCLTzv8i8,
          2305 => Opcode::VCLZv16i8,
          2306 => Opcode::VCLZv2i32,
          2307 => Opcode::VCLZv4i16,
          2308 => Opcode::VCLZv4i32,
          2309 => Opcode::VCLZv8i16,
          2310 => Opcode::VCLZv8i8,
          2311 => Opcode::VCMLAv2f32,
          2312 => Opcode::VCMLAv2f32_indexed,
          2313 => Opcode::VCMLAv4f16,
          2314 => Opcode::VCMLAv4f16_indexed,
          2315 => Opcode::VCMLAv4f32,
          2316 => Opcode::VCMLAv4f32_indexed,
          2317 => Opcode::VCMLAv8f16,
          2318 => Opcode::VCMLAv8f16_indexed,
          2319 => Opcode::VCMPD,
          2320 => Opcode::VCMPED,
          2321 => Opcode::VCMPEH,
          2322 => Opcode::VCMPES,
          2323 => Opcode::VCMPEZD,
          2324 => Opcode::VCMPEZH,
          2325 => Opcode::VCMPEZS,
          2326 => Opcode::VCMPH,
          2327 => Opcode::VCMPS,
          2328 => Opcode::VCMPZD,
          2329 => Opcode::VCMPZH,
          2330 => Opcode::VCMPZS,
          2331 => Opcode::VCNTd,
          2332 => Opcode::VCNTq,
          2333 => Opcode::VCVTANSDf,
          2334 => Opcode::VCVTANSDh,
          2335 => Opcode::VCVTANSQf,
          2336 => Opcode::VCVTANSQh,
          2337 => Opcode::VCVTANUDf,
          2338 => Opcode::VCVTANUDh,
          2339 => Opcode::VCVTANUQf,
          2340 => Opcode::VCVTANUQh,
          2341 => Opcode::VCVTASD,
          2342 => Opcode::VCVTASH,
          2343 => Opcode::VCVTASS,
          2344 => Opcode::VCVTAUD,
          2345 => Opcode::VCVTAUH,
          2346 => Opcode::VCVTAUS,
          2347 => Opcode::VCVTBDH,
          2348 => Opcode::VCVTBHD,
          2349 => Opcode::VCVTBHS,
          2350 => Opcode::VCVTBSH,
          2351 => Opcode::VCVTDS,
          2352 => Opcode::VCVTMNSDf,
          2353 => Opcode::VCVTMNSDh,
          2354 => Opcode::VCVTMNSQf,
          2355 => Opcode::VCVTMNSQh,
          2356 => Opcode::VCVTMNUDf,
          2357 => Opcode::VCVTMNUDh,
          2358 => Opcode::VCVTMNUQf,
          2359 => Opcode::VCVTMNUQh,
          2360 => Opcode::VCVTMSD,
          2361 => Opcode::VCVTMSH,
          2362 => Opcode::VCVTMSS,
          2363 => Opcode::VCVTMUD,
          2364 => Opcode::VCVTMUH,
          2365 => Opcode::VCVTMUS,
          2366 => Opcode::VCVTNNSDf,
          2367 => Opcode::VCVTNNSDh,
          2368 => Opcode::VCVTNNSQf,
          2369 => Opcode::VCVTNNSQh,
          2370 => Opcode::VCVTNNUDf,
          2371 => Opcode::VCVTNNUDh,
          2372 => Opcode::VCVTNNUQf,
          2373 => Opcode::VCVTNNUQh,
          2374 => Opcode::VCVTNSD,
          2375 => Opcode::VCVTNSH,
          2376 => Opcode::VCVTNSS,
          2377 => Opcode::VCVTNUD,
          2378 => Opcode::VCVTNUH,
          2379 => Opcode::VCVTNUS,
          2380 => Opcode::VCVTPNSDf,
          2381 => Opcode::VCVTPNSDh,
          2382 => Opcode::VCVTPNSQf,
          2383 => Opcode::VCVTPNSQh,
          2384 => Opcode::VCVTPNUDf,
          2385 => Opcode::VCVTPNUDh,
          2386 => Opcode::VCVTPNUQf,
          2387 => Opcode::VCVTPNUQh,
          2388 => Opcode::VCVTPSD,
          2389 => Opcode::VCVTPSH,
          2390 => Opcode::VCVTPSS,
          2391 => Opcode::VCVTPUD,
          2392 => Opcode::VCVTPUH,
          2393 => Opcode::VCVTPUS,
          2394 => Opcode::VCVTSD,
          2395 => Opcode::VCVTTDH,
          2396 => Opcode::VCVTTHD,
          2397 => Opcode::VCVTTHS,
          2398 => Opcode::VCVTTSH,
          2399 => Opcode::VCVTf2h,
          2400 => Opcode::VCVTf2sd,
          2401 => Opcode::VCVTf2sq,
          2402 => Opcode::VCVTf2ud,
          2403 => Opcode::VCVTf2uq,
          2404 => Opcode::VCVTf2xsd,
          2405 => Opcode::VCVTf2xsq,
          2406 => Opcode::VCVTf2xud,
          2407 => Opcode::VCVTf2xuq,
          2408 => Opcode::VCVTh2f,
          2409 => Opcode::VCVTh2sd,
          2410 => Opcode::VCVTh2sq,
          2411 => Opcode::VCVTh2ud,
          2412 => Opcode::VCVTh2uq,
          2413 => Opcode::VCVTh2xsd,
          2414 => Opcode::VCVTh2xsq,
          2415 => Opcode::VCVTh2xud,
          2416 => Opcode::VCVTh2xuq,
          2417 => Opcode::VCVTs2fd,
          2418 => Opcode::VCVTs2fq,
          2419 => Opcode::VCVTs2hd,
          2420 => Opcode::VCVTs2hq,
          2421 => Opcode::VCVTu2fd,
          2422 => Opcode::VCVTu2fq,
          2423 => Opcode::VCVTu2hd,
          2424 => Opcode::VCVTu2hq,
          2425 => Opcode::VCVTxs2fd,
          2426 => Opcode::VCVTxs2fq,
          2427 => Opcode::VCVTxs2hd,
          2428 => Opcode::VCVTxs2hq,
          2429 => Opcode::VCVTxu2fd,
          2430 => Opcode::VCVTxu2fq,
          2431 => Opcode::VCVTxu2hd,
          2432 => Opcode::VCVTxu2hq,
          2433 => Opcode::VDIVD,
          2434 => Opcode::VDIVH,
          2435 => Opcode::VDIVS,
          2436 => Opcode::VDUP16d,
          2437 => Opcode::VDUP16q,
          2438 => Opcode::VDUP32d,
          2439 => Opcode::VDUP32q,
          2440 => Opcode::VDUP8d,
          2441 => Opcode::VDUP8q,
          2442 => Opcode::VDUPLN16d,
          2443 => Opcode::VDUPLN16q,
          2444 => Opcode::VDUPLN32d,
          2445 => Opcode::VDUPLN32q,
          2446 => Opcode::VDUPLN8d,
          2447 => Opcode::VDUPLN8q,
          2448 => Opcode::VEORd,
          2449 => Opcode::VEORq,
          2450 => Opcode::VEXTd16,
          2451 => Opcode::VEXTd32,
          2452 => Opcode::VEXTd8,
          2453 => Opcode::VEXTq16,
          2454 => Opcode::VEXTq32,
          2455 => Opcode::VEXTq64,
          2456 => Opcode::VEXTq8,
          2457 => Opcode::VFMAD,
          2458 => Opcode::VFMAH,
          2459 => Opcode::VFMALD,
          2460 => Opcode::VFMALDI,
          2461 => Opcode::VFMALQ,
          2462 => Opcode::VFMALQI,
          2463 => Opcode::VFMAS,
          2464 => Opcode::VFMAfd,
          2465 => Opcode::VFMAfq,
          2466 => Opcode::VFMAhd,
          2467 => Opcode::VFMAhq,
          2468 => Opcode::VFMSD,
          2469 => Opcode::VFMSH,
          2470 => Opcode::VFMSLD,
          2471 => Opcode::VFMSLDI,
          2472 => Opcode::VFMSLQ,
          2473 => Opcode::VFMSLQI,
          2474 => Opcode::VFMSS,
          2475 => Opcode::VFMSfd,
          2476 => Opcode::VFMSfq,
          2477 => Opcode::VFMShd,
          2478 => Opcode::VFMShq,
          2479 => Opcode::VFNMAD,
          2480 => Opcode::VFNMAH,
          2481 => Opcode::VFNMAS,
          2482 => Opcode::VFNMSD,
          2483 => Opcode::VFNMSH,
          2484 => Opcode::VFNMSS,
          2485 => Opcode::VFP_VMAXNMD,
          2486 => Opcode::VFP_VMAXNMH,
          2487 => Opcode::VFP_VMAXNMS,
          2488 => Opcode::VFP_VMINNMD,
          2489 => Opcode::VFP_VMINNMH,
          2490 => Opcode::VFP_VMINNMS,
          2491 => Opcode::VGETLNi32,
          2492 => Opcode::VGETLNs16,
          2493 => Opcode::VGETLNs8,
          2494 => Opcode::VGETLNu16,
          2495 => Opcode::VGETLNu8,
          2496 => Opcode::VHADDsv16i8,
          2497 => Opcode::VHADDsv2i32,
          2498 => Opcode::VHADDsv4i16,
          2499 => Opcode::VHADDsv4i32,
          2500 => Opcode::VHADDsv8i16,
          2501 => Opcode::VHADDsv8i8,
          2502 => Opcode::VHADDuv16i8,
          2503 => Opcode::VHADDuv2i32,
          2504 => Opcode::VHADDuv4i16,
          2505 => Opcode::VHADDuv4i32,
          2506 => Opcode::VHADDuv8i16,
          2507 => Opcode::VHADDuv8i8,
          2508 => Opcode::VHSUBsv16i8,
          2509 => Opcode::VHSUBsv2i32,
          2510 => Opcode::VHSUBsv4i16,
          2511 => Opcode::VHSUBsv4i32,
          2512 => Opcode::VHSUBsv8i16,
          2513 => Opcode::VHSUBsv8i8,
          2514 => Opcode::VHSUBuv16i8,
          2515 => Opcode::VHSUBuv2i32,
          2516 => Opcode::VHSUBuv4i16,
          2517 => Opcode::VHSUBuv4i32,
          2518 => Opcode::VHSUBuv8i16,
          2519 => Opcode::VHSUBuv8i8,
          2520 => Opcode::VINSH,
          2521 => Opcode::VJCVT,
          2522 => Opcode::VLD1DUPd16,
          2523 => Opcode::VLD1DUPd16wb_fixed,
          2524 => Opcode::VLD1DUPd16wb_register,
          2525 => Opcode::VLD1DUPd32,
          2526 => Opcode::VLD1DUPd32wb_fixed,
          2527 => Opcode::VLD1DUPd32wb_register,
          2528 => Opcode::VLD1DUPd8,
          2529 => Opcode::VLD1DUPd8wb_fixed,
          2530 => Opcode::VLD1DUPd8wb_register,
          2531 => Opcode::VLD1DUPq16,
          2532 => Opcode::VLD1DUPq16wb_fixed,
          2533 => Opcode::VLD1DUPq16wb_register,
          2534 => Opcode::VLD1DUPq32,
          2535 => Opcode::VLD1DUPq32wb_fixed,
          2536 => Opcode::VLD1DUPq32wb_register,
          2537 => Opcode::VLD1DUPq8,
          2538 => Opcode::VLD1DUPq8wb_fixed,
          2539 => Opcode::VLD1DUPq8wb_register,
          2540 => Opcode::VLD1LNd16,
          2541 => Opcode::VLD1LNd16_UPD,
          2542 => Opcode::VLD1LNd32,
          2543 => Opcode::VLD1LNd32_UPD,
          2544 => Opcode::VLD1LNd8,
          2545 => Opcode::VLD1LNd8_UPD,
          2546 => Opcode::VLD1LNq16Pseudo,
          2547 => Opcode::VLD1LNq16Pseudo_UPD,
          2548 => Opcode::VLD1LNq32Pseudo,
          2549 => Opcode::VLD1LNq32Pseudo_UPD,
          2550 => Opcode::VLD1LNq8Pseudo,
          2551 => Opcode::VLD1LNq8Pseudo_UPD,
          2552 => Opcode::VLD1d16,
          2553 => Opcode::VLD1d16Q,
          2554 => Opcode::VLD1d16QPseudo,
          2555 => Opcode::VLD1d16QPseudoWB_fixed,
          2556 => Opcode::VLD1d16QPseudoWB_register,
          2557 => Opcode::VLD1d16Qwb_fixed,
          2558 => Opcode::VLD1d16Qwb_register,
          2559 => Opcode::VLD1d16T,
          2560 => Opcode::VLD1d16TPseudo,
          2561 => Opcode::VLD1d16TPseudoWB_fixed,
          2562 => Opcode::VLD1d16TPseudoWB_register,
          2563 => Opcode::VLD1d16Twb_fixed,
          2564 => Opcode::VLD1d16Twb_register,
          2565 => Opcode::VLD1d16wb_fixed,
          2566 => Opcode::VLD1d16wb_register,
          2567 => Opcode::VLD1d32,
          2568 => Opcode::VLD1d32Q,
          2569 => Opcode::VLD1d32QPseudo,
          2570 => Opcode::VLD1d32QPseudoWB_fixed,
          2571 => Opcode::VLD1d32QPseudoWB_register,
          2572 => Opcode::VLD1d32Qwb_fixed,
          2573 => Opcode::VLD1d32Qwb_register,
          2574 => Opcode::VLD1d32T,
          2575 => Opcode::VLD1d32TPseudo,
          2576 => Opcode::VLD1d32TPseudoWB_fixed,
          2577 => Opcode::VLD1d32TPseudoWB_register,
          2578 => Opcode::VLD1d32Twb_fixed,
          2579 => Opcode::VLD1d32Twb_register,
          2580 => Opcode::VLD1d32wb_fixed,
          2581 => Opcode::VLD1d32wb_register,
          2582 => Opcode::VLD1d64,
          2583 => Opcode::VLD1d64Q,
          2584 => Opcode::VLD1d64QPseudo,
          2585 => Opcode::VLD1d64QPseudoWB_fixed,
          2586 => Opcode::VLD1d64QPseudoWB_register,
          2587 => Opcode::VLD1d64Qwb_fixed,
          2588 => Opcode::VLD1d64Qwb_register,
          2589 => Opcode::VLD1d64T,
          2590 => Opcode::VLD1d64TPseudo,
          2591 => Opcode::VLD1d64TPseudoWB_fixed,
          2592 => Opcode::VLD1d64TPseudoWB_register,
          2593 => Opcode::VLD1d64Twb_fixed,
          2594 => Opcode::VLD1d64Twb_register,
          2595 => Opcode::VLD1d64wb_fixed,
          2596 => Opcode::VLD1d64wb_register,
          2597 => Opcode::VLD1d8,
          2598 => Opcode::VLD1d8Q,
          2599 => Opcode::VLD1d8QPseudo,
          2600 => Opcode::VLD1d8QPseudoWB_fixed,
          2601 => Opcode::VLD1d8QPseudoWB_register,
          2602 => Opcode::VLD1d8Qwb_fixed,
          2603 => Opcode::VLD1d8Qwb_register,
          2604 => Opcode::VLD1d8T,
          2605 => Opcode::VLD1d8TPseudo,
          2606 => Opcode::VLD1d8TPseudoWB_fixed,
          2607 => Opcode::VLD1d8TPseudoWB_register,
          2608 => Opcode::VLD1d8Twb_fixed,
          2609 => Opcode::VLD1d8Twb_register,
          2610 => Opcode::VLD1d8wb_fixed,
          2611 => Opcode::VLD1d8wb_register,
          2612 => Opcode::VLD1q16,
          2613 => Opcode::VLD1q16HighQPseudo,
          2614 => Opcode::VLD1q16HighQPseudo_UPD,
          2615 => Opcode::VLD1q16HighTPseudo,
          2616 => Opcode::VLD1q16HighTPseudo_UPD,
          2617 => Opcode::VLD1q16LowQPseudo_UPD,
          2618 => Opcode::VLD1q16LowTPseudo_UPD,
          2619 => Opcode::VLD1q16wb_fixed,
          2620 => Opcode::VLD1q16wb_register,
          2621 => Opcode::VLD1q32,
          2622 => Opcode::VLD1q32HighQPseudo,
          2623 => Opcode::VLD1q32HighQPseudo_UPD,
          2624 => Opcode::VLD1q32HighTPseudo,
          2625 => Opcode::VLD1q32HighTPseudo_UPD,
          2626 => Opcode::VLD1q32LowQPseudo_UPD,
          2627 => Opcode::VLD1q32LowTPseudo_UPD,
          2628 => Opcode::VLD1q32wb_fixed,
          2629 => Opcode::VLD1q32wb_register,
          2630 => Opcode::VLD1q64,
          2631 => Opcode::VLD1q64HighQPseudo,
          2632 => Opcode::VLD1q64HighQPseudo_UPD,
          2633 => Opcode::VLD1q64HighTPseudo,
          2634 => Opcode::VLD1q64HighTPseudo_UPD,
          2635 => Opcode::VLD1q64LowQPseudo_UPD,
          2636 => Opcode::VLD1q64LowTPseudo_UPD,
          2637 => Opcode::VLD1q64wb_fixed,
          2638 => Opcode::VLD1q64wb_register,
          2639 => Opcode::VLD1q8,
          2640 => Opcode::VLD1q8HighQPseudo,
          2641 => Opcode::VLD1q8HighQPseudo_UPD,
          2642 => Opcode::VLD1q8HighTPseudo,
          2643 => Opcode::VLD1q8HighTPseudo_UPD,
          2644 => Opcode::VLD1q8LowQPseudo_UPD,
          2645 => Opcode::VLD1q8LowTPseudo_UPD,
          2646 => Opcode::VLD1q8wb_fixed,
          2647 => Opcode::VLD1q8wb_register,
          2648 => Opcode::VLD2DUPd16,
          2649 => Opcode::VLD2DUPd16wb_fixed,
          2650 => Opcode::VLD2DUPd16wb_register,
          2651 => Opcode::VLD2DUPd16x2,
          2652 => Opcode::VLD2DUPd16x2wb_fixed,
          2653 => Opcode::VLD2DUPd16x2wb_register,
          2654 => Opcode::VLD2DUPd32,
          2655 => Opcode::VLD2DUPd32wb_fixed,
          2656 => Opcode::VLD2DUPd32wb_register,
          2657 => Opcode::VLD2DUPd32x2,
          2658 => Opcode::VLD2DUPd32x2wb_fixed,
          2659 => Opcode::VLD2DUPd32x2wb_register,
          2660 => Opcode::VLD2DUPd8,
          2661 => Opcode::VLD2DUPd8wb_fixed,
          2662 => Opcode::VLD2DUPd8wb_register,
          2663 => Opcode::VLD2DUPd8x2,
          2664 => Opcode::VLD2DUPd8x2wb_fixed,
          2665 => Opcode::VLD2DUPd8x2wb_register,
          2666 => Opcode::VLD2DUPq16EvenPseudo,
          2667 => Opcode::VLD2DUPq16OddPseudo,
          2668 => Opcode::VLD2DUPq16OddPseudoWB_fixed,
          2669 => Opcode::VLD2DUPq16OddPseudoWB_register,
          2670 => Opcode::VLD2DUPq32EvenPseudo,
          2671 => Opcode::VLD2DUPq32OddPseudo,
          2672 => Opcode::VLD2DUPq32OddPseudoWB_fixed,
          2673 => Opcode::VLD2DUPq32OddPseudoWB_register,
          2674 => Opcode::VLD2DUPq8EvenPseudo,
          2675 => Opcode::VLD2DUPq8OddPseudo,
          2676 => Opcode::VLD2DUPq8OddPseudoWB_fixed,
          2677 => Opcode::VLD2DUPq8OddPseudoWB_register,
          2678 => Opcode::VLD2LNd16,
          2679 => Opcode::VLD2LNd16Pseudo,
          2680 => Opcode::VLD2LNd16Pseudo_UPD,
          2681 => Opcode::VLD2LNd16_UPD,
          2682 => Opcode::VLD2LNd32,
          2683 => Opcode::VLD2LNd32Pseudo,
          2684 => Opcode::VLD2LNd32Pseudo_UPD,
          2685 => Opcode::VLD2LNd32_UPD,
          2686 => Opcode::VLD2LNd8,
          2687 => Opcode::VLD2LNd8Pseudo,
          2688 => Opcode::VLD2LNd8Pseudo_UPD,
          2689 => Opcode::VLD2LNd8_UPD,
          2690 => Opcode::VLD2LNq16,
          2691 => Opcode::VLD2LNq16Pseudo,
          2692 => Opcode::VLD2LNq16Pseudo_UPD,
          2693 => Opcode::VLD2LNq16_UPD,
          2694 => Opcode::VLD2LNq32,
          2695 => Opcode::VLD2LNq32Pseudo,
          2696 => Opcode::VLD2LNq32Pseudo_UPD,
          2697 => Opcode::VLD2LNq32_UPD,
          2698 => Opcode::VLD2b16,
          2699 => Opcode::VLD2b16wb_fixed,
          2700 => Opcode::VLD2b16wb_register,
          2701 => Opcode::VLD2b32,
          2702 => Opcode::VLD2b32wb_fixed,
          2703 => Opcode::VLD2b32wb_register,
          2704 => Opcode::VLD2b8,
          2705 => Opcode::VLD2b8wb_fixed,
          2706 => Opcode::VLD2b8wb_register,
          2707 => Opcode::VLD2d16,
          2708 => Opcode::VLD2d16wb_fixed,
          2709 => Opcode::VLD2d16wb_register,
          2710 => Opcode::VLD2d32,
          2711 => Opcode::VLD2d32wb_fixed,
          2712 => Opcode::VLD2d32wb_register,
          2713 => Opcode::VLD2d8,
          2714 => Opcode::VLD2d8wb_fixed,
          2715 => Opcode::VLD2d8wb_register,
          2716 => Opcode::VLD2q16,
          2717 => Opcode::VLD2q16Pseudo,
          2718 => Opcode::VLD2q16PseudoWB_fixed,
          2719 => Opcode::VLD2q16PseudoWB_register,
          2720 => Opcode::VLD2q16wb_fixed,
          2721 => Opcode::VLD2q16wb_register,
          2722 => Opcode::VLD2q32,
          2723 => Opcode::VLD2q32Pseudo,
          2724 => Opcode::VLD2q32PseudoWB_fixed,
          2725 => Opcode::VLD2q32PseudoWB_register,
          2726 => Opcode::VLD2q32wb_fixed,
          2727 => Opcode::VLD2q32wb_register,
          2728 => Opcode::VLD2q8,
          2729 => Opcode::VLD2q8Pseudo,
          2730 => Opcode::VLD2q8PseudoWB_fixed,
          2731 => Opcode::VLD2q8PseudoWB_register,
          2732 => Opcode::VLD2q8wb_fixed,
          2733 => Opcode::VLD2q8wb_register,
          2734 => Opcode::VLD3DUPd16,
          2735 => Opcode::VLD3DUPd16Pseudo,
          2736 => Opcode::VLD3DUPd16Pseudo_UPD,
          2737 => Opcode::VLD3DUPd16_UPD,
          2738 => Opcode::VLD3DUPd32,
          2739 => Opcode::VLD3DUPd32Pseudo,
          2740 => Opcode::VLD3DUPd32Pseudo_UPD,
          2741 => Opcode::VLD3DUPd32_UPD,
          2742 => Opcode::VLD3DUPd8,
          2743 => Opcode::VLD3DUPd8Pseudo,
          2744 => Opcode::VLD3DUPd8Pseudo_UPD,
          2745 => Opcode::VLD3DUPd8_UPD,
          2746 => Opcode::VLD3DUPq16,
          2747 => Opcode::VLD3DUPq16EvenPseudo,
          2748 => Opcode::VLD3DUPq16OddPseudo,
          2749 => Opcode::VLD3DUPq16OddPseudo_UPD,
          2750 => Opcode::VLD3DUPq16_UPD,
          2751 => Opcode::VLD3DUPq32,
          2752 => Opcode::VLD3DUPq32EvenPseudo,
          2753 => Opcode::VLD3DUPq32OddPseudo,
          2754 => Opcode::VLD3DUPq32OddPseudo_UPD,
          2755 => Opcode::VLD3DUPq32_UPD,
          2756 => Opcode::VLD3DUPq8,
          2757 => Opcode::VLD3DUPq8EvenPseudo,
          2758 => Opcode::VLD3DUPq8OddPseudo,
          2759 => Opcode::VLD3DUPq8OddPseudo_UPD,
          2760 => Opcode::VLD3DUPq8_UPD,
          2761 => Opcode::VLD3LNd16,
          2762 => Opcode::VLD3LNd16Pseudo,
          2763 => Opcode::VLD3LNd16Pseudo_UPD,
          2764 => Opcode::VLD3LNd16_UPD,
          2765 => Opcode::VLD3LNd32,
          2766 => Opcode::VLD3LNd32Pseudo,
          2767 => Opcode::VLD3LNd32Pseudo_UPD,
          2768 => Opcode::VLD3LNd32_UPD,
          2769 => Opcode::VLD3LNd8,
          2770 => Opcode::VLD3LNd8Pseudo,
          2771 => Opcode::VLD3LNd8Pseudo_UPD,
          2772 => Opcode::VLD3LNd8_UPD,
          2773 => Opcode::VLD3LNq16,
          2774 => Opcode::VLD3LNq16Pseudo,
          2775 => Opcode::VLD3LNq16Pseudo_UPD,
          2776 => Opcode::VLD3LNq16_UPD,
          2777 => Opcode::VLD3LNq32,
          2778 => Opcode::VLD3LNq32Pseudo,
          2779 => Opcode::VLD3LNq32Pseudo_UPD,
          2780 => Opcode::VLD3LNq32_UPD,
          2781 => Opcode::VLD3d16,
          2782 => Opcode::VLD3d16Pseudo,
          2783 => Opcode::VLD3d16Pseudo_UPD,
          2784 => Opcode::VLD3d16_UPD,
          2785 => Opcode::VLD3d32,
          2786 => Opcode::VLD3d32Pseudo,
          2787 => Opcode::VLD3d32Pseudo_UPD,
          2788 => Opcode::VLD3d32_UPD,
          2789 => Opcode::VLD3d8,
          2790 => Opcode::VLD3d8Pseudo,
          2791 => Opcode::VLD3d8Pseudo_UPD,
          2792 => Opcode::VLD3d8_UPD,
          2793 => Opcode::VLD3q16,
          2794 => Opcode::VLD3q16Pseudo_UPD,
          2795 => Opcode::VLD3q16_UPD,
          2796 => Opcode::VLD3q16oddPseudo,
          2797 => Opcode::VLD3q16oddPseudo_UPD,
          2798 => Opcode::VLD3q32,
          2799 => Opcode::VLD3q32Pseudo_UPD,
          2800 => Opcode::VLD3q32_UPD,
          2801 => Opcode::VLD3q32oddPseudo,
          2802 => Opcode::VLD3q32oddPseudo_UPD,
          2803 => Opcode::VLD3q8,
          2804 => Opcode::VLD3q8Pseudo_UPD,
          2805 => Opcode::VLD3q8_UPD,
          2806 => Opcode::VLD3q8oddPseudo,
          2807 => Opcode::VLD3q8oddPseudo_UPD,
          2808 => Opcode::VLD4DUPd16,
          2809 => Opcode::VLD4DUPd16Pseudo,
          2810 => Opcode::VLD4DUPd16Pseudo_UPD,
          2811 => Opcode::VLD4DUPd16_UPD,
          2812 => Opcode::VLD4DUPd32,
          2813 => Opcode::VLD4DUPd32Pseudo,
          2814 => Opcode::VLD4DUPd32Pseudo_UPD,
          2815 => Opcode::VLD4DUPd32_UPD,
          2816 => Opcode::VLD4DUPd8,
          2817 => Opcode::VLD4DUPd8Pseudo,
          2818 => Opcode::VLD4DUPd8Pseudo_UPD,
          2819 => Opcode::VLD4DUPd8_UPD,
          2820 => Opcode::VLD4DUPq16,
          2821 => Opcode::VLD4DUPq16EvenPseudo,
          2822 => Opcode::VLD4DUPq16OddPseudo,
          2823 => Opcode::VLD4DUPq16OddPseudo_UPD,
          2824 => Opcode::VLD4DUPq16_UPD,
          2825 => Opcode::VLD4DUPq32,
          2826 => Opcode::VLD4DUPq32EvenPseudo,
          2827 => Opcode::VLD4DUPq32OddPseudo,
          2828 => Opcode::VLD4DUPq32OddPseudo_UPD,
          2829 => Opcode::VLD4DUPq32_UPD,
          2830 => Opcode::VLD4DUPq8,
          2831 => Opcode::VLD4DUPq8EvenPseudo,
          2832 => Opcode::VLD4DUPq8OddPseudo,
          2833 => Opcode::VLD4DUPq8OddPseudo_UPD,
          2834 => Opcode::VLD4DUPq8_UPD,
          2835 => Opcode::VLD4LNd16,
          2836 => Opcode::VLD4LNd16Pseudo,
          2837 => Opcode::VLD4LNd16Pseudo_UPD,
          2838 => Opcode::VLD4LNd16_UPD,
          2839 => Opcode::VLD4LNd32,
          2840 => Opcode::VLD4LNd32Pseudo,
          2841 => Opcode::VLD4LNd32Pseudo_UPD,
          2842 => Opcode::VLD4LNd32_UPD,
          2843 => Opcode::VLD4LNd8,
          2844 => Opcode::VLD4LNd8Pseudo,
          2845 => Opcode::VLD4LNd8Pseudo_UPD,
          2846 => Opcode::VLD4LNd8_UPD,
          2847 => Opcode::VLD4LNq16,
          2848 => Opcode::VLD4LNq16Pseudo,
          2849 => Opcode::VLD4LNq16Pseudo_UPD,
          2850 => Opcode::VLD4LNq16_UPD,
          2851 => Opcode::VLD4LNq32,
          2852 => Opcode::VLD4LNq32Pseudo,
          2853 => Opcode::VLD4LNq32Pseudo_UPD,
          2854 => Opcode::VLD4LNq32_UPD,
          2855 => Opcode::VLD4d16,
          2856 => Opcode::VLD4d16Pseudo,
          2857 => Opcode::VLD4d16Pseudo_UPD,
          2858 => Opcode::VLD4d16_UPD,
          2859 => Opcode::VLD4d32,
          2860 => Opcode::VLD4d32Pseudo,
          2861 => Opcode::VLD4d32Pseudo_UPD,
          2862 => Opcode::VLD4d32_UPD,
          2863 => Opcode::VLD4d8,
          2864 => Opcode::VLD4d8Pseudo,
          2865 => Opcode::VLD4d8Pseudo_UPD,
          2866 => Opcode::VLD4d8_UPD,
          2867 => Opcode::VLD4q16,
          2868 => Opcode::VLD4q16Pseudo_UPD,
          2869 => Opcode::VLD4q16_UPD,
          2870 => Opcode::VLD4q16oddPseudo,
          2871 => Opcode::VLD4q16oddPseudo_UPD,
          2872 => Opcode::VLD4q32,
          2873 => Opcode::VLD4q32Pseudo_UPD,
          2874 => Opcode::VLD4q32_UPD,
          2875 => Opcode::VLD4q32oddPseudo,
          2876 => Opcode::VLD4q32oddPseudo_UPD,
          2877 => Opcode::VLD4q8,
          2878 => Opcode::VLD4q8Pseudo_UPD,
          2879 => Opcode::VLD4q8_UPD,
          2880 => Opcode::VLD4q8oddPseudo,
          2881 => Opcode::VLD4q8oddPseudo_UPD,
          2882 => Opcode::VLDMDDB_UPD,
          2883 => Opcode::VLDMDIA,
          2884 => Opcode::VLDMDIA_UPD,
          2885 => Opcode::VLDMQIA,
          2886 => Opcode::VLDMSDB_UPD,
          2887 => Opcode::VLDMSIA,
          2888 => Opcode::VLDMSIA_UPD,
          2889 => Opcode::VLDRD,
          2890 => Opcode::VLDRH,
          2891 => Opcode::VLDRS,
          2892 => Opcode::VLDR_FPCXTNS_off,
          2893 => Opcode::VLDR_FPCXTNS_post,
          2894 => Opcode::VLDR_FPCXTNS_pre,
          2895 => Opcode::VLDR_FPCXTS_off,
          2896 => Opcode::VLDR_FPCXTS_post,
          2897 => Opcode::VLDR_FPCXTS_pre,
          2898 => Opcode::VLDR_FPSCR_NZCVQC_off,
          2899 => Opcode::VLDR_FPSCR_NZCVQC_post,
          2900 => Opcode::VLDR_FPSCR_NZCVQC_pre,
          2901 => Opcode::VLDR_FPSCR_off,
          2902 => Opcode::VLDR_FPSCR_post,
          2903 => Opcode::VLDR_FPSCR_pre,
          2904 => Opcode::VLDR_P0_off,
          2905 => Opcode::VLDR_P0_post,
          2906 => Opcode::VLDR_P0_pre,
          2907 => Opcode::VLDR_VPR_off,
          2908 => Opcode::VLDR_VPR_post,
          2909 => Opcode::VLDR_VPR_pre,
          2910 => Opcode::VLLDM,
          2911 => Opcode::VLLDM_T2,
          2912 => Opcode::VLSTM,
          2913 => Opcode::VLSTM_T2,
          2914 => Opcode::VMAXfd,
          2915 => Opcode::VMAXfq,
          2916 => Opcode::VMAXhd,
          2917 => Opcode::VMAXhq,
          2918 => Opcode::VMAXsv16i8,
          2919 => Opcode::VMAXsv2i32,
          2920 => Opcode::VMAXsv4i16,
          2921 => Opcode::VMAXsv4i32,
          2922 => Opcode::VMAXsv8i16,
          2923 => Opcode::VMAXsv8i8,
          2924 => Opcode::VMAXuv16i8,
          2925 => Opcode::VMAXuv2i32,
          2926 => Opcode::VMAXuv4i16,
          2927 => Opcode::VMAXuv4i32,
          2928 => Opcode::VMAXuv8i16,
          2929 => Opcode::VMAXuv8i8,
          2930 => Opcode::VMINfd,
          2931 => Opcode::VMINfq,
          2932 => Opcode::VMINhd,
          2933 => Opcode::VMINhq,
          2934 => Opcode::VMINsv16i8,
          2935 => Opcode::VMINsv2i32,
          2936 => Opcode::VMINsv4i16,
          2937 => Opcode::VMINsv4i32,
          2938 => Opcode::VMINsv8i16,
          2939 => Opcode::VMINsv8i8,
          2940 => Opcode::VMINuv16i8,
          2941 => Opcode::VMINuv2i32,
          2942 => Opcode::VMINuv4i16,
          2943 => Opcode::VMINuv4i32,
          2944 => Opcode::VMINuv8i16,
          2945 => Opcode::VMINuv8i8,
          2946 => Opcode::VMLAD,
          2947 => Opcode::VMLAH,
          2948 => Opcode::VMLALslsv2i32,
          2949 => Opcode::VMLALslsv4i16,
          2950 => Opcode::VMLALsluv2i32,
          2951 => Opcode::VMLALsluv4i16,
          2952 => Opcode::VMLALsv2i64,
          2953 => Opcode::VMLALsv4i32,
          2954 => Opcode::VMLALsv8i16,
          2955 => Opcode::VMLALuv2i64,
          2956 => Opcode::VMLALuv4i32,
          2957 => Opcode::VMLALuv8i16,
          2958 => Opcode::VMLAS,
          2959 => Opcode::VMLAfd,
          2960 => Opcode::VMLAfq,
          2961 => Opcode::VMLAhd,
          2962 => Opcode::VMLAhq,
          2963 => Opcode::VMLAslfd,
          2964 => Opcode::VMLAslfq,
          2965 => Opcode::VMLAslhd,
          2966 => Opcode::VMLAslhq,
          2967 => Opcode::VMLAslv2i32,
          2968 => Opcode::VMLAslv4i16,
          2969 => Opcode::VMLAslv4i32,
          2970 => Opcode::VMLAslv8i16,
          2971 => Opcode::VMLAv16i8,
          2972 => Opcode::VMLAv2i32,
          2973 => Opcode::VMLAv4i16,
          2974 => Opcode::VMLAv4i32,
          2975 => Opcode::VMLAv8i16,
          2976 => Opcode::VMLAv8i8,
          2977 => Opcode::VMLSD,
          2978 => Opcode::VMLSH,
          2979 => Opcode::VMLSLslsv2i32,
          2980 => Opcode::VMLSLslsv4i16,
          2981 => Opcode::VMLSLsluv2i32,
          2982 => Opcode::VMLSLsluv4i16,
          2983 => Opcode::VMLSLsv2i64,
          2984 => Opcode::VMLSLsv4i32,
          2985 => Opcode::VMLSLsv8i16,
          2986 => Opcode::VMLSLuv2i64,
          2987 => Opcode::VMLSLuv4i32,
          2988 => Opcode::VMLSLuv8i16,
          2989 => Opcode::VMLSS,
          2990 => Opcode::VMLSfd,
          2991 => Opcode::VMLSfq,
          2992 => Opcode::VMLShd,
          2993 => Opcode::VMLShq,
          2994 => Opcode::VMLSslfd,
          2995 => Opcode::VMLSslfq,
          2996 => Opcode::VMLSslhd,
          2997 => Opcode::VMLSslhq,
          2998 => Opcode::VMLSslv2i32,
          2999 => Opcode::VMLSslv4i16,
          3000 => Opcode::VMLSslv4i32,
          3001 => Opcode::VMLSslv8i16,
          3002 => Opcode::VMLSv16i8,
          3003 => Opcode::VMLSv2i32,
          3004 => Opcode::VMLSv4i16,
          3005 => Opcode::VMLSv4i32,
          3006 => Opcode::VMLSv8i16,
          3007 => Opcode::VMLSv8i8,
          3008 => Opcode::VMMLA,
          3009 => Opcode::VMOVD,
          3010 => Opcode::VMOVDRR,
          3011 => Opcode::VMOVH,
          3012 => Opcode::VMOVHR,
          3013 => Opcode::VMOVLsv2i64,
          3014 => Opcode::VMOVLsv4i32,
          3015 => Opcode::VMOVLsv8i16,
          3016 => Opcode::VMOVLuv2i64,
          3017 => Opcode::VMOVLuv4i32,
          3018 => Opcode::VMOVLuv8i16,
          3019 => Opcode::VMOVNv2i32,
          3020 => Opcode::VMOVNv4i16,
          3021 => Opcode::VMOVNv8i8,
          3022 => Opcode::VMOVRH,
          3023 => Opcode::VMOVRRD,
          3024 => Opcode::VMOVRRS,
          3025 => Opcode::VMOVRS,
          3026 => Opcode::VMOVS,
          3027 => Opcode::VMOVSR,
          3028 => Opcode::VMOVSRR,
          3029 => Opcode::VMOVv16i8,
          3030 => Opcode::VMOVv1i64,
          3031 => Opcode::VMOVv2f32,
          3032 => Opcode::VMOVv2i32,
          3033 => Opcode::VMOVv2i64,
          3034 => Opcode::VMOVv4f32,
          3035 => Opcode::VMOVv4i16,
          3036 => Opcode::VMOVv4i32,
          3037 => Opcode::VMOVv8i16,
          3038 => Opcode::VMOVv8i8,
          3039 => Opcode::VMRS,
          3040 => Opcode::VMRS_FPCXTNS,
          3041 => Opcode::VMRS_FPCXTS,
          3042 => Opcode::VMRS_FPEXC,
          3043 => Opcode::VMRS_FPINST,
          3044 => Opcode::VMRS_FPINST2,
          3045 => Opcode::VMRS_FPSCR_NZCVQC,
          3046 => Opcode::VMRS_FPSID,
          3047 => Opcode::VMRS_MVFR0,
          3048 => Opcode::VMRS_MVFR1,
          3049 => Opcode::VMRS_MVFR2,
          3050 => Opcode::VMRS_P0,
          3051 => Opcode::VMRS_VPR,
          3052 => Opcode::VMSR,
          3053 => Opcode::VMSR_FPCXTNS,
          3054 => Opcode::VMSR_FPCXTS,
          3055 => Opcode::VMSR_FPEXC,
          3056 => Opcode::VMSR_FPINST,
          3057 => Opcode::VMSR_FPINST2,
          3058 => Opcode::VMSR_FPSCR_NZCVQC,
          3059 => Opcode::VMSR_FPSID,
          3060 => Opcode::VMSR_P0,
          3061 => Opcode::VMSR_VPR,
          3062 => Opcode::VMULD,
          3063 => Opcode::VMULH,
          3064 => Opcode::VMULLp64,
          3065 => Opcode::VMULLp8,
          3066 => Opcode::VMULLslsv2i32,
          3067 => Opcode::VMULLslsv4i16,
          3068 => Opcode::VMULLsluv2i32,
          3069 => Opcode::VMULLsluv4i16,
          3070 => Opcode::VMULLsv2i64,
          3071 => Opcode::VMULLsv4i32,
          3072 => Opcode::VMULLsv8i16,
          3073 => Opcode::VMULLuv2i64,
          3074 => Opcode::VMULLuv4i32,
          3075 => Opcode::VMULLuv8i16,
          3076 => Opcode::VMULS,
          3077 => Opcode::VMULfd,
          3078 => Opcode::VMULfq,
          3079 => Opcode::VMULhd,
          3080 => Opcode::VMULhq,
          3081 => Opcode::VMULpd,
          3082 => Opcode::VMULpq,
          3083 => Opcode::VMULslfd,
          3084 => Opcode::VMULslfq,
          3085 => Opcode::VMULslhd,
          3086 => Opcode::VMULslhq,
          3087 => Opcode::VMULslv2i32,
          3088 => Opcode::VMULslv4i16,
          3089 => Opcode::VMULslv4i32,
          3090 => Opcode::VMULslv8i16,
          3091 => Opcode::VMULv16i8,
          3092 => Opcode::VMULv2i32,
          3093 => Opcode::VMULv4i16,
          3094 => Opcode::VMULv4i32,
          3095 => Opcode::VMULv8i16,
          3096 => Opcode::VMULv8i8,
          3097 => Opcode::VMVNd,
          3098 => Opcode::VMVNq,
          3099 => Opcode::VMVNv2i32,
          3100 => Opcode::VMVNv4i16,
          3101 => Opcode::VMVNv4i32,
          3102 => Opcode::VMVNv8i16,
          3103 => Opcode::VNEGD,
          3104 => Opcode::VNEGH,
          3105 => Opcode::VNEGS,
          3106 => Opcode::VNEGf32q,
          3107 => Opcode::VNEGfd,
          3108 => Opcode::VNEGhd,
          3109 => Opcode::VNEGhq,
          3110 => Opcode::VNEGs16d,
          3111 => Opcode::VNEGs16q,
          3112 => Opcode::VNEGs32d,
          3113 => Opcode::VNEGs32q,
          3114 => Opcode::VNEGs8d,
          3115 => Opcode::VNEGs8q,
          3116 => Opcode::VNMLAD,
          3117 => Opcode::VNMLAH,
          3118 => Opcode::VNMLAS,
          3119 => Opcode::VNMLSD,
          3120 => Opcode::VNMLSH,
          3121 => Opcode::VNMLSS,
          3122 => Opcode::VNMULD,
          3123 => Opcode::VNMULH,
          3124 => Opcode::VNMULS,
          3125 => Opcode::VORNd,
          3126 => Opcode::VORNq,
          3127 => Opcode::VORRd,
          3128 => Opcode::VORRiv2i32,
          3129 => Opcode::VORRiv4i16,
          3130 => Opcode::VORRiv4i32,
          3131 => Opcode::VORRiv8i16,
          3132 => Opcode::VORRq,
          3133 => Opcode::VPADALsv16i8,
          3134 => Opcode::VPADALsv2i32,
          3135 => Opcode::VPADALsv4i16,
          3136 => Opcode::VPADALsv4i32,
          3137 => Opcode::VPADALsv8i16,
          3138 => Opcode::VPADALsv8i8,
          3139 => Opcode::VPADALuv16i8,
          3140 => Opcode::VPADALuv2i32,
          3141 => Opcode::VPADALuv4i16,
          3142 => Opcode::VPADALuv4i32,
          3143 => Opcode::VPADALuv8i16,
          3144 => Opcode::VPADALuv8i8,
          3145 => Opcode::VPADDLsv16i8,
          3146 => Opcode::VPADDLsv2i32,
          3147 => Opcode::VPADDLsv4i16,
          3148 => Opcode::VPADDLsv4i32,
          3149 => Opcode::VPADDLsv8i16,
          3150 => Opcode::VPADDLsv8i8,
          3151 => Opcode::VPADDLuv16i8,
          3152 => Opcode::VPADDLuv2i32,
          3153 => Opcode::VPADDLuv4i16,
          3154 => Opcode::VPADDLuv4i32,
          3155 => Opcode::VPADDLuv8i16,
          3156 => Opcode::VPADDLuv8i8,
          3157 => Opcode::VPADDf,
          3158 => Opcode::VPADDh,
          3159 => Opcode::VPADDi16,
          3160 => Opcode::VPADDi32,
          3161 => Opcode::VPADDi8,
          3162 => Opcode::VPMAXf,
          3163 => Opcode::VPMAXh,
          3164 => Opcode::VPMAXs16,
          3165 => Opcode::VPMAXs32,
          3166 => Opcode::VPMAXs8,
          3167 => Opcode::VPMAXu16,
          3168 => Opcode::VPMAXu32,
          3169 => Opcode::VPMAXu8,
          3170 => Opcode::VPMINf,
          3171 => Opcode::VPMINh,
          3172 => Opcode::VPMINs16,
          3173 => Opcode::VPMINs32,
          3174 => Opcode::VPMINs8,
          3175 => Opcode::VPMINu16,
          3176 => Opcode::VPMINu32,
          3177 => Opcode::VPMINu8,
          3178 => Opcode::VQABSv16i8,
          3179 => Opcode::VQABSv2i32,
          3180 => Opcode::VQABSv4i16,
          3181 => Opcode::VQABSv4i32,
          3182 => Opcode::VQABSv8i16,
          3183 => Opcode::VQABSv8i8,
          3184 => Opcode::VQADDsv16i8,
          3185 => Opcode::VQADDsv1i64,
          3186 => Opcode::VQADDsv2i32,
          3187 => Opcode::VQADDsv2i64,
          3188 => Opcode::VQADDsv4i16,
          3189 => Opcode::VQADDsv4i32,
          3190 => Opcode::VQADDsv8i16,
          3191 => Opcode::VQADDsv8i8,
          3192 => Opcode::VQADDuv16i8,
          3193 => Opcode::VQADDuv1i64,
          3194 => Opcode::VQADDuv2i32,
          3195 => Opcode::VQADDuv2i64,
          3196 => Opcode::VQADDuv4i16,
          3197 => Opcode::VQADDuv4i32,
          3198 => Opcode::VQADDuv8i16,
          3199 => Opcode::VQADDuv8i8,
          3200 => Opcode::VQDMLALslv2i32,
          3201 => Opcode::VQDMLALslv4i16,
          3202 => Opcode::VQDMLALv2i64,
          3203 => Opcode::VQDMLALv4i32,
          3204 => Opcode::VQDMLSLslv2i32,
          3205 => Opcode::VQDMLSLslv4i16,
          3206 => Opcode::VQDMLSLv2i64,
          3207 => Opcode::VQDMLSLv4i32,
          3208 => Opcode::VQDMULHslv2i32,
          3209 => Opcode::VQDMULHslv4i16,
          3210 => Opcode::VQDMULHslv4i32,
          3211 => Opcode::VQDMULHslv8i16,
          3212 => Opcode::VQDMULHv2i32,
          3213 => Opcode::VQDMULHv4i16,
          3214 => Opcode::VQDMULHv4i32,
          3215 => Opcode::VQDMULHv8i16,
          3216 => Opcode::VQDMULLslv2i32,
          3217 => Opcode::VQDMULLslv4i16,
          3218 => Opcode::VQDMULLv2i64,
          3219 => Opcode::VQDMULLv4i32,
          3220 => Opcode::VQMOVNsuv2i32,
          3221 => Opcode::VQMOVNsuv4i16,
          3222 => Opcode::VQMOVNsuv8i8,
          3223 => Opcode::VQMOVNsv2i32,
          3224 => Opcode::VQMOVNsv4i16,
          3225 => Opcode::VQMOVNsv8i8,
          3226 => Opcode::VQMOVNuv2i32,
          3227 => Opcode::VQMOVNuv4i16,
          3228 => Opcode::VQMOVNuv8i8,
          3229 => Opcode::VQNEGv16i8,
          3230 => Opcode::VQNEGv2i32,
          3231 => Opcode::VQNEGv4i16,
          3232 => Opcode::VQNEGv4i32,
          3233 => Opcode::VQNEGv8i16,
          3234 => Opcode::VQNEGv8i8,
          3235 => Opcode::VQRDMLAHslv2i32,
          3236 => Opcode::VQRDMLAHslv4i16,
          3237 => Opcode::VQRDMLAHslv4i32,
          3238 => Opcode::VQRDMLAHslv8i16,
          3239 => Opcode::VQRDMLAHv2i32,
          3240 => Opcode::VQRDMLAHv4i16,
          3241 => Opcode::VQRDMLAHv4i32,
          3242 => Opcode::VQRDMLAHv8i16,
          3243 => Opcode::VQRDMLSHslv2i32,
          3244 => Opcode::VQRDMLSHslv4i16,
          3245 => Opcode::VQRDMLSHslv4i32,
          3246 => Opcode::VQRDMLSHslv8i16,
          3247 => Opcode::VQRDMLSHv2i32,
          3248 => Opcode::VQRDMLSHv4i16,
          3249 => Opcode::VQRDMLSHv4i32,
          3250 => Opcode::VQRDMLSHv8i16,
          3251 => Opcode::VQRDMULHslv2i32,
          3252 => Opcode::VQRDMULHslv4i16,
          3253 => Opcode::VQRDMULHslv4i32,
          3254 => Opcode::VQRDMULHslv8i16,
          3255 => Opcode::VQRDMULHv2i32,
          3256 => Opcode::VQRDMULHv4i16,
          3257 => Opcode::VQRDMULHv4i32,
          3258 => Opcode::VQRDMULHv8i16,
          3259 => Opcode::VQRSHLsv16i8,
          3260 => Opcode::VQRSHLsv1i64,
          3261 => Opcode::VQRSHLsv2i32,
          3262 => Opcode::VQRSHLsv2i64,
          3263 => Opcode::VQRSHLsv4i16,
          3264 => Opcode::VQRSHLsv4i32,
          3265 => Opcode::VQRSHLsv8i16,
          3266 => Opcode::VQRSHLsv8i8,
          3267 => Opcode::VQRSHLuv16i8,
          3268 => Opcode::VQRSHLuv1i64,
          3269 => Opcode::VQRSHLuv2i32,
          3270 => Opcode::VQRSHLuv2i64,
          3271 => Opcode::VQRSHLuv4i16,
          3272 => Opcode::VQRSHLuv4i32,
          3273 => Opcode::VQRSHLuv8i16,
          3274 => Opcode::VQRSHLuv8i8,
          3275 => Opcode::VQRSHRNsv2i32,
          3276 => Opcode::VQRSHRNsv4i16,
          3277 => Opcode::VQRSHRNsv8i8,
          3278 => Opcode::VQRSHRNuv2i32,
          3279 => Opcode::VQRSHRNuv4i16,
          3280 => Opcode::VQRSHRNuv8i8,
          3281 => Opcode::VQRSHRUNv2i32,
          3282 => Opcode::VQRSHRUNv4i16,
          3283 => Opcode::VQRSHRUNv8i8,
          3284 => Opcode::VQSHLsiv16i8,
          3285 => Opcode::VQSHLsiv1i64,
          3286 => Opcode::VQSHLsiv2i32,
          3287 => Opcode::VQSHLsiv2i64,
          3288 => Opcode::VQSHLsiv4i16,
          3289 => Opcode::VQSHLsiv4i32,
          3290 => Opcode::VQSHLsiv8i16,
          3291 => Opcode::VQSHLsiv8i8,
          3292 => Opcode::VQSHLsuv16i8,
          3293 => Opcode::VQSHLsuv1i64,
          3294 => Opcode::VQSHLsuv2i32,
          3295 => Opcode::VQSHLsuv2i64,
          3296 => Opcode::VQSHLsuv4i16,
          3297 => Opcode::VQSHLsuv4i32,
          3298 => Opcode::VQSHLsuv8i16,
          3299 => Opcode::VQSHLsuv8i8,
          3300 => Opcode::VQSHLsv16i8,
          3301 => Opcode::VQSHLsv1i64,
          3302 => Opcode::VQSHLsv2i32,
          3303 => Opcode::VQSHLsv2i64,
          3304 => Opcode::VQSHLsv4i16,
          3305 => Opcode::VQSHLsv4i32,
          3306 => Opcode::VQSHLsv8i16,
          3307 => Opcode::VQSHLsv8i8,
          3308 => Opcode::VQSHLuiv16i8,
          3309 => Opcode::VQSHLuiv1i64,
          3310 => Opcode::VQSHLuiv2i32,
          3311 => Opcode::VQSHLuiv2i64,
          3312 => Opcode::VQSHLuiv4i16,
          3313 => Opcode::VQSHLuiv4i32,
          3314 => Opcode::VQSHLuiv8i16,
          3315 => Opcode::VQSHLuiv8i8,
          3316 => Opcode::VQSHLuv16i8,
          3317 => Opcode::VQSHLuv1i64,
          3318 => Opcode::VQSHLuv2i32,
          3319 => Opcode::VQSHLuv2i64,
          3320 => Opcode::VQSHLuv4i16,
          3321 => Opcode::VQSHLuv4i32,
          3322 => Opcode::VQSHLuv8i16,
          3323 => Opcode::VQSHLuv8i8,
          3324 => Opcode::VQSHRNsv2i32,
          3325 => Opcode::VQSHRNsv4i16,
          3326 => Opcode::VQSHRNsv8i8,
          3327 => Opcode::VQSHRNuv2i32,
          3328 => Opcode::VQSHRNuv4i16,
          3329 => Opcode::VQSHRNuv8i8,
          3330 => Opcode::VQSHRUNv2i32,
          3331 => Opcode::VQSHRUNv4i16,
          3332 => Opcode::VQSHRUNv8i8,
          3333 => Opcode::VQSUBsv16i8,
          3334 => Opcode::VQSUBsv1i64,
          3335 => Opcode::VQSUBsv2i32,
          3336 => Opcode::VQSUBsv2i64,
          3337 => Opcode::VQSUBsv4i16,
          3338 => Opcode::VQSUBsv4i32,
          3339 => Opcode::VQSUBsv8i16,
          3340 => Opcode::VQSUBsv8i8,
          3341 => Opcode::VQSUBuv16i8,
          3342 => Opcode::VQSUBuv1i64,
          3343 => Opcode::VQSUBuv2i32,
          3344 => Opcode::VQSUBuv2i64,
          3345 => Opcode::VQSUBuv4i16,
          3346 => Opcode::VQSUBuv4i32,
          3347 => Opcode::VQSUBuv8i16,
          3348 => Opcode::VQSUBuv8i8,
          3349 => Opcode::VRADDHNv2i32,
          3350 => Opcode::VRADDHNv4i16,
          3351 => Opcode::VRADDHNv8i8,
          3352 => Opcode::VRECPEd,
          3353 => Opcode::VRECPEfd,
          3354 => Opcode::VRECPEfq,
          3355 => Opcode::VRECPEhd,
          3356 => Opcode::VRECPEhq,
          3357 => Opcode::VRECPEq,
          3358 => Opcode::VRECPSfd,
          3359 => Opcode::VRECPSfq,
          3360 => Opcode::VRECPShd,
          3361 => Opcode::VRECPShq,
          3362 => Opcode::VREV16d8,
          3363 => Opcode::VREV16q8,
          3364 => Opcode::VREV32d16,
          3365 => Opcode::VREV32d8,
          3366 => Opcode::VREV32q16,
          3367 => Opcode::VREV32q8,
          3368 => Opcode::VREV64d16,
          3369 => Opcode::VREV64d32,
          3370 => Opcode::VREV64d8,
          3371 => Opcode::VREV64q16,
          3372 => Opcode::VREV64q32,
          3373 => Opcode::VREV64q8,
          3374 => Opcode::VRHADDsv16i8,
          3375 => Opcode::VRHADDsv2i32,
          3376 => Opcode::VRHADDsv4i16,
          3377 => Opcode::VRHADDsv4i32,
          3378 => Opcode::VRHADDsv8i16,
          3379 => Opcode::VRHADDsv8i8,
          3380 => Opcode::VRHADDuv16i8,
          3381 => Opcode::VRHADDuv2i32,
          3382 => Opcode::VRHADDuv4i16,
          3383 => Opcode::VRHADDuv4i32,
          3384 => Opcode::VRHADDuv8i16,
          3385 => Opcode::VRHADDuv8i8,
          3386 => Opcode::VRINTAD,
          3387 => Opcode::VRINTAH,
          3388 => Opcode::VRINTANDf,
          3389 => Opcode::VRINTANDh,
          3390 => Opcode::VRINTANQf,
          3391 => Opcode::VRINTANQh,
          3392 => Opcode::VRINTAS,
          3393 => Opcode::VRINTMD,
          3394 => Opcode::VRINTMH,
          3395 => Opcode::VRINTMNDf,
          3396 => Opcode::VRINTMNDh,
          3397 => Opcode::VRINTMNQf,
          3398 => Opcode::VRINTMNQh,
          3399 => Opcode::VRINTMS,
          3400 => Opcode::VRINTND,
          3401 => Opcode::VRINTNH,
          3402 => Opcode::VRINTNNDf,
          3403 => Opcode::VRINTNNDh,
          3404 => Opcode::VRINTNNQf,
          3405 => Opcode::VRINTNNQh,
          3406 => Opcode::VRINTNS,
          3407 => Opcode::VRINTPD,
          3408 => Opcode::VRINTPH,
          3409 => Opcode::VRINTPNDf,
          3410 => Opcode::VRINTPNDh,
          3411 => Opcode::VRINTPNQf,
          3412 => Opcode::VRINTPNQh,
          3413 => Opcode::VRINTPS,
          3414 => Opcode::VRINTRD,
          3415 => Opcode::VRINTRH,
          3416 => Opcode::VRINTRS,
          3417 => Opcode::VRINTXD,
          3418 => Opcode::VRINTXH,
          3419 => Opcode::VRINTXNDf,
          3420 => Opcode::VRINTXNDh,
          3421 => Opcode::VRINTXNQf,
          3422 => Opcode::VRINTXNQh,
          3423 => Opcode::VRINTXS,
          3424 => Opcode::VRINTZD,
          3425 => Opcode::VRINTZH,
          3426 => Opcode::VRINTZNDf,
          3427 => Opcode::VRINTZNDh,
          3428 => Opcode::VRINTZNQf,
          3429 => Opcode::VRINTZNQh,
          3430 => Opcode::VRINTZS,
          3431 => Opcode::VRSHLsv16i8,
          3432 => Opcode::VRSHLsv1i64,
          3433 => Opcode::VRSHLsv2i32,
          3434 => Opcode::VRSHLsv2i64,
          3435 => Opcode::VRSHLsv4i16,
          3436 => Opcode::VRSHLsv4i32,
          3437 => Opcode::VRSHLsv8i16,
          3438 => Opcode::VRSHLsv8i8,
          3439 => Opcode::VRSHLuv16i8,
          3440 => Opcode::VRSHLuv1i64,
          3441 => Opcode::VRSHLuv2i32,
          3442 => Opcode::VRSHLuv2i64,
          3443 => Opcode::VRSHLuv4i16,
          3444 => Opcode::VRSHLuv4i32,
          3445 => Opcode::VRSHLuv8i16,
          3446 => Opcode::VRSHLuv8i8,
          3447 => Opcode::VRSHRNv2i32,
          3448 => Opcode::VRSHRNv4i16,
          3449 => Opcode::VRSHRNv8i8,
          3450 => Opcode::VRSHRsv16i8,
          3451 => Opcode::VRSHRsv1i64,
          3452 => Opcode::VRSHRsv2i32,
          3453 => Opcode::VRSHRsv2i64,
          3454 => Opcode::VRSHRsv4i16,
          3455 => Opcode::VRSHRsv4i32,
          3456 => Opcode::VRSHRsv8i16,
          3457 => Opcode::VRSHRsv8i8,
          3458 => Opcode::VRSHRuv16i8,
          3459 => Opcode::VRSHRuv1i64,
          3460 => Opcode::VRSHRuv2i32,
          3461 => Opcode::VRSHRuv2i64,
          3462 => Opcode::VRSHRuv4i16,
          3463 => Opcode::VRSHRuv4i32,
          3464 => Opcode::VRSHRuv8i16,
          3465 => Opcode::VRSHRuv8i8,
          3466 => Opcode::VRSQRTEd,
          3467 => Opcode::VRSQRTEfd,
          3468 => Opcode::VRSQRTEfq,
          3469 => Opcode::VRSQRTEhd,
          3470 => Opcode::VRSQRTEhq,
          3471 => Opcode::VRSQRTEq,
          3472 => Opcode::VRSQRTSfd,
          3473 => Opcode::VRSQRTSfq,
          3474 => Opcode::VRSQRTShd,
          3475 => Opcode::VRSQRTShq,
          3476 => Opcode::VRSRAsv16i8,
          3477 => Opcode::VRSRAsv1i64,
          3478 => Opcode::VRSRAsv2i32,
          3479 => Opcode::VRSRAsv2i64,
          3480 => Opcode::VRSRAsv4i16,
          3481 => Opcode::VRSRAsv4i32,
          3482 => Opcode::VRSRAsv8i16,
          3483 => Opcode::VRSRAsv8i8,
          3484 => Opcode::VRSRAuv16i8,
          3485 => Opcode::VRSRAuv1i64,
          3486 => Opcode::VRSRAuv2i32,
          3487 => Opcode::VRSRAuv2i64,
          3488 => Opcode::VRSRAuv4i16,
          3489 => Opcode::VRSRAuv4i32,
          3490 => Opcode::VRSRAuv8i16,
          3491 => Opcode::VRSRAuv8i8,
          3492 => Opcode::VRSUBHNv2i32,
          3493 => Opcode::VRSUBHNv4i16,
          3494 => Opcode::VRSUBHNv8i8,
          3495 => Opcode::VSCCLRMD,
          3496 => Opcode::VSCCLRMS,
          3497 => Opcode::VSDOTD,
          3498 => Opcode::VSDOTDI,
          3499 => Opcode::VSDOTQ,
          3500 => Opcode::VSDOTQI,
          3501 => Opcode::VSELEQD,
          3502 => Opcode::VSELEQH,
          3503 => Opcode::VSELEQS,
          3504 => Opcode::VSELGED,
          3505 => Opcode::VSELGEH,
          3506 => Opcode::VSELGES,
          3507 => Opcode::VSELGTD,
          3508 => Opcode::VSELGTH,
          3509 => Opcode::VSELGTS,
          3510 => Opcode::VSELVSD,
          3511 => Opcode::VSELVSH,
          3512 => Opcode::VSELVSS,
          3513 => Opcode::VSETLNi16,
          3514 => Opcode::VSETLNi32,
          3515 => Opcode::VSETLNi8,
          3516 => Opcode::VSHLLi16,
          3517 => Opcode::VSHLLi32,
          3518 => Opcode::VSHLLi8,
          3519 => Opcode::VSHLLsv2i64,
          3520 => Opcode::VSHLLsv4i32,
          3521 => Opcode::VSHLLsv8i16,
          3522 => Opcode::VSHLLuv2i64,
          3523 => Opcode::VSHLLuv4i32,
          3524 => Opcode::VSHLLuv8i16,
          3525 => Opcode::VSHLiv16i8,
          3526 => Opcode::VSHLiv1i64,
          3527 => Opcode::VSHLiv2i32,
          3528 => Opcode::VSHLiv2i64,
          3529 => Opcode::VSHLiv4i16,
          3530 => Opcode::VSHLiv4i32,
          3531 => Opcode::VSHLiv8i16,
          3532 => Opcode::VSHLiv8i8,
          3533 => Opcode::VSHLsv16i8,
          3534 => Opcode::VSHLsv1i64,
          3535 => Opcode::VSHLsv2i32,
          3536 => Opcode::VSHLsv2i64,
          3537 => Opcode::VSHLsv4i16,
          3538 => Opcode::VSHLsv4i32,
          3539 => Opcode::VSHLsv8i16,
          3540 => Opcode::VSHLsv8i8,
          3541 => Opcode::VSHLuv16i8,
          3542 => Opcode::VSHLuv1i64,
          3543 => Opcode::VSHLuv2i32,
          3544 => Opcode::VSHLuv2i64,
          3545 => Opcode::VSHLuv4i16,
          3546 => Opcode::VSHLuv4i32,
          3547 => Opcode::VSHLuv8i16,
          3548 => Opcode::VSHLuv8i8,
          3549 => Opcode::VSHRNv2i32,
          3550 => Opcode::VSHRNv4i16,
          3551 => Opcode::VSHRNv8i8,
          3552 => Opcode::VSHRsv16i8,
          3553 => Opcode::VSHRsv1i64,
          3554 => Opcode::VSHRsv2i32,
          3555 => Opcode::VSHRsv2i64,
          3556 => Opcode::VSHRsv4i16,
          3557 => Opcode::VSHRsv4i32,
          3558 => Opcode::VSHRsv8i16,
          3559 => Opcode::VSHRsv8i8,
          3560 => Opcode::VSHRuv16i8,
          3561 => Opcode::VSHRuv1i64,
          3562 => Opcode::VSHRuv2i32,
          3563 => Opcode::VSHRuv2i64,
          3564 => Opcode::VSHRuv4i16,
          3565 => Opcode::VSHRuv4i32,
          3566 => Opcode::VSHRuv8i16,
          3567 => Opcode::VSHRuv8i8,
          3568 => Opcode::VSHTOD,
          3569 => Opcode::VSHTOH,
          3570 => Opcode::VSHTOS,
          3571 => Opcode::VSITOD,
          3572 => Opcode::VSITOH,
          3573 => Opcode::VSITOS,
          3574 => Opcode::VSLIv16i8,
          3575 => Opcode::VSLIv1i64,
          3576 => Opcode::VSLIv2i32,
          3577 => Opcode::VSLIv2i64,
          3578 => Opcode::VSLIv4i16,
          3579 => Opcode::VSLIv4i32,
          3580 => Opcode::VSLIv8i16,
          3581 => Opcode::VSLIv8i8,
          3582 => Opcode::VSLTOD,
          3583 => Opcode::VSLTOH,
          3584 => Opcode::VSLTOS,
          3585 => Opcode::VSMMLA,
          3586 => Opcode::VSQRTD,
          3587 => Opcode::VSQRTH,
          3588 => Opcode::VSQRTS,
          3589 => Opcode::VSRAsv16i8,
          3590 => Opcode::VSRAsv1i64,
          3591 => Opcode::VSRAsv2i32,
          3592 => Opcode::VSRAsv2i64,
          3593 => Opcode::VSRAsv4i16,
          3594 => Opcode::VSRAsv4i32,
          3595 => Opcode::VSRAsv8i16,
          3596 => Opcode::VSRAsv8i8,
          3597 => Opcode::VSRAuv16i8,
          3598 => Opcode::VSRAuv1i64,
          3599 => Opcode::VSRAuv2i32,
          3600 => Opcode::VSRAuv2i64,
          3601 => Opcode::VSRAuv4i16,
          3602 => Opcode::VSRAuv4i32,
          3603 => Opcode::VSRAuv8i16,
          3604 => Opcode::VSRAuv8i8,
          3605 => Opcode::VSRIv16i8,
          3606 => Opcode::VSRIv1i64,
          3607 => Opcode::VSRIv2i32,
          3608 => Opcode::VSRIv2i64,
          3609 => Opcode::VSRIv4i16,
          3610 => Opcode::VSRIv4i32,
          3611 => Opcode::VSRIv8i16,
          3612 => Opcode::VSRIv8i8,
          3613 => Opcode::VST1LNd16,
          3614 => Opcode::VST1LNd16_UPD,
          3615 => Opcode::VST1LNd32,
          3616 => Opcode::VST1LNd32_UPD,
          3617 => Opcode::VST1LNd8,
          3618 => Opcode::VST1LNd8_UPD,
          3619 => Opcode::VST1LNq16Pseudo,
          3620 => Opcode::VST1LNq16Pseudo_UPD,
          3621 => Opcode::VST1LNq32Pseudo,
          3622 => Opcode::VST1LNq32Pseudo_UPD,
          3623 => Opcode::VST1LNq8Pseudo,
          3624 => Opcode::VST1LNq8Pseudo_UPD,
          3625 => Opcode::VST1d16,
          3626 => Opcode::VST1d16Q,
          3627 => Opcode::VST1d16QPseudo,
          3628 => Opcode::VST1d16QPseudoWB_fixed,
          3629 => Opcode::VST1d16QPseudoWB_register,
          3630 => Opcode::VST1d16Qwb_fixed,
          3631 => Opcode::VST1d16Qwb_register,
          3632 => Opcode::VST1d16T,
          3633 => Opcode::VST1d16TPseudo,
          3634 => Opcode::VST1d16TPseudoWB_fixed,
          3635 => Opcode::VST1d16TPseudoWB_register,
          3636 => Opcode::VST1d16Twb_fixed,
          3637 => Opcode::VST1d16Twb_register,
          3638 => Opcode::VST1d16wb_fixed,
          3639 => Opcode::VST1d16wb_register,
          3640 => Opcode::VST1d32,
          3641 => Opcode::VST1d32Q,
          3642 => Opcode::VST1d32QPseudo,
          3643 => Opcode::VST1d32QPseudoWB_fixed,
          3644 => Opcode::VST1d32QPseudoWB_register,
          3645 => Opcode::VST1d32Qwb_fixed,
          3646 => Opcode::VST1d32Qwb_register,
          3647 => Opcode::VST1d32T,
          3648 => Opcode::VST1d32TPseudo,
          3649 => Opcode::VST1d32TPseudoWB_fixed,
          3650 => Opcode::VST1d32TPseudoWB_register,
          3651 => Opcode::VST1d32Twb_fixed,
          3652 => Opcode::VST1d32Twb_register,
          3653 => Opcode::VST1d32wb_fixed,
          3654 => Opcode::VST1d32wb_register,
          3655 => Opcode::VST1d64,
          3656 => Opcode::VST1d64Q,
          3657 => Opcode::VST1d64QPseudo,
          3658 => Opcode::VST1d64QPseudoWB_fixed,
          3659 => Opcode::VST1d64QPseudoWB_register,
          3660 => Opcode::VST1d64Qwb_fixed,
          3661 => Opcode::VST1d64Qwb_register,
          3662 => Opcode::VST1d64T,
          3663 => Opcode::VST1d64TPseudo,
          3664 => Opcode::VST1d64TPseudoWB_fixed,
          3665 => Opcode::VST1d64TPseudoWB_register,
          3666 => Opcode::VST1d64Twb_fixed,
          3667 => Opcode::VST1d64Twb_register,
          3668 => Opcode::VST1d64wb_fixed,
          3669 => Opcode::VST1d64wb_register,
          3670 => Opcode::VST1d8,
          3671 => Opcode::VST1d8Q,
          3672 => Opcode::VST1d8QPseudo,
          3673 => Opcode::VST1d8QPseudoWB_fixed,
          3674 => Opcode::VST1d8QPseudoWB_register,
          3675 => Opcode::VST1d8Qwb_fixed,
          3676 => Opcode::VST1d8Qwb_register,
          3677 => Opcode::VST1d8T,
          3678 => Opcode::VST1d8TPseudo,
          3679 => Opcode::VST1d8TPseudoWB_fixed,
          3680 => Opcode::VST1d8TPseudoWB_register,
          3681 => Opcode::VST1d8Twb_fixed,
          3682 => Opcode::VST1d8Twb_register,
          3683 => Opcode::VST1d8wb_fixed,
          3684 => Opcode::VST1d8wb_register,
          3685 => Opcode::VST1q16,
          3686 => Opcode::VST1q16HighQPseudo,
          3687 => Opcode::VST1q16HighQPseudo_UPD,
          3688 => Opcode::VST1q16HighTPseudo,
          3689 => Opcode::VST1q16HighTPseudo_UPD,
          3690 => Opcode::VST1q16LowQPseudo_UPD,
          3691 => Opcode::VST1q16LowTPseudo_UPD,
          3692 => Opcode::VST1q16wb_fixed,
          3693 => Opcode::VST1q16wb_register,
          3694 => Opcode::VST1q32,
          3695 => Opcode::VST1q32HighQPseudo,
          3696 => Opcode::VST1q32HighQPseudo_UPD,
          3697 => Opcode::VST1q32HighTPseudo,
          3698 => Opcode::VST1q32HighTPseudo_UPD,
          3699 => Opcode::VST1q32LowQPseudo_UPD,
          3700 => Opcode::VST1q32LowTPseudo_UPD,
          3701 => Opcode::VST1q32wb_fixed,
          3702 => Opcode::VST1q32wb_register,
          3703 => Opcode::VST1q64,
          3704 => Opcode::VST1q64HighQPseudo,
          3705 => Opcode::VST1q64HighQPseudo_UPD,
          3706 => Opcode::VST1q64HighTPseudo,
          3707 => Opcode::VST1q64HighTPseudo_UPD,
          3708 => Opcode::VST1q64LowQPseudo_UPD,
          3709 => Opcode::VST1q64LowTPseudo_UPD,
          3710 => Opcode::VST1q64wb_fixed,
          3711 => Opcode::VST1q64wb_register,
          3712 => Opcode::VST1q8,
          3713 => Opcode::VST1q8HighQPseudo,
          3714 => Opcode::VST1q8HighQPseudo_UPD,
          3715 => Opcode::VST1q8HighTPseudo,
          3716 => Opcode::VST1q8HighTPseudo_UPD,
          3717 => Opcode::VST1q8LowQPseudo_UPD,
          3718 => Opcode::VST1q8LowTPseudo_UPD,
          3719 => Opcode::VST1q8wb_fixed,
          3720 => Opcode::VST1q8wb_register,
          3721 => Opcode::VST2LNd16,
          3722 => Opcode::VST2LNd16Pseudo,
          3723 => Opcode::VST2LNd16Pseudo_UPD,
          3724 => Opcode::VST2LNd16_UPD,
          3725 => Opcode::VST2LNd32,
          3726 => Opcode::VST2LNd32Pseudo,
          3727 => Opcode::VST2LNd32Pseudo_UPD,
          3728 => Opcode::VST2LNd32_UPD,
          3729 => Opcode::VST2LNd8,
          3730 => Opcode::VST2LNd8Pseudo,
          3731 => Opcode::VST2LNd8Pseudo_UPD,
          3732 => Opcode::VST2LNd8_UPD,
          3733 => Opcode::VST2LNq16,
          3734 => Opcode::VST2LNq16Pseudo,
          3735 => Opcode::VST2LNq16Pseudo_UPD,
          3736 => Opcode::VST2LNq16_UPD,
          3737 => Opcode::VST2LNq32,
          3738 => Opcode::VST2LNq32Pseudo,
          3739 => Opcode::VST2LNq32Pseudo_UPD,
          3740 => Opcode::VST2LNq32_UPD,
          3741 => Opcode::VST2b16,
          3742 => Opcode::VST2b16wb_fixed,
          3743 => Opcode::VST2b16wb_register,
          3744 => Opcode::VST2b32,
          3745 => Opcode::VST2b32wb_fixed,
          3746 => Opcode::VST2b32wb_register,
          3747 => Opcode::VST2b8,
          3748 => Opcode::VST2b8wb_fixed,
          3749 => Opcode::VST2b8wb_register,
          3750 => Opcode::VST2d16,
          3751 => Opcode::VST2d16wb_fixed,
          3752 => Opcode::VST2d16wb_register,
          3753 => Opcode::VST2d32,
          3754 => Opcode::VST2d32wb_fixed,
          3755 => Opcode::VST2d32wb_register,
          3756 => Opcode::VST2d8,
          3757 => Opcode::VST2d8wb_fixed,
          3758 => Opcode::VST2d8wb_register,
          3759 => Opcode::VST2q16,
          3760 => Opcode::VST2q16Pseudo,
          3761 => Opcode::VST2q16PseudoWB_fixed,
          3762 => Opcode::VST2q16PseudoWB_register,
          3763 => Opcode::VST2q16wb_fixed,
          3764 => Opcode::VST2q16wb_register,
          3765 => Opcode::VST2q32,
          3766 => Opcode::VST2q32Pseudo,
          3767 => Opcode::VST2q32PseudoWB_fixed,
          3768 => Opcode::VST2q32PseudoWB_register,
          3769 => Opcode::VST2q32wb_fixed,
          3770 => Opcode::VST2q32wb_register,
          3771 => Opcode::VST2q8,
          3772 => Opcode::VST2q8Pseudo,
          3773 => Opcode::VST2q8PseudoWB_fixed,
          3774 => Opcode::VST2q8PseudoWB_register,
          3775 => Opcode::VST2q8wb_fixed,
          3776 => Opcode::VST2q8wb_register,
          3777 => Opcode::VST3LNd16,
          3778 => Opcode::VST3LNd16Pseudo,
          3779 => Opcode::VST3LNd16Pseudo_UPD,
          3780 => Opcode::VST3LNd16_UPD,
          3781 => Opcode::VST3LNd32,
          3782 => Opcode::VST3LNd32Pseudo,
          3783 => Opcode::VST3LNd32Pseudo_UPD,
          3784 => Opcode::VST3LNd32_UPD,
          3785 => Opcode::VST3LNd8,
          3786 => Opcode::VST3LNd8Pseudo,
          3787 => Opcode::VST3LNd8Pseudo_UPD,
          3788 => Opcode::VST3LNd8_UPD,
          3789 => Opcode::VST3LNq16,
          3790 => Opcode::VST3LNq16Pseudo,
          3791 => Opcode::VST3LNq16Pseudo_UPD,
          3792 => Opcode::VST3LNq16_UPD,
          3793 => Opcode::VST3LNq32,
          3794 => Opcode::VST3LNq32Pseudo,
          3795 => Opcode::VST3LNq32Pseudo_UPD,
          3796 => Opcode::VST3LNq32_UPD,
          3797 => Opcode::VST3d16,
          3798 => Opcode::VST3d16Pseudo,
          3799 => Opcode::VST3d16Pseudo_UPD,
          3800 => Opcode::VST3d16_UPD,
          3801 => Opcode::VST3d32,
          3802 => Opcode::VST3d32Pseudo,
          3803 => Opcode::VST3d32Pseudo_UPD,
          3804 => Opcode::VST3d32_UPD,
          3805 => Opcode::VST3d8,
          3806 => Opcode::VST3d8Pseudo,
          3807 => Opcode::VST3d8Pseudo_UPD,
          3808 => Opcode::VST3d8_UPD,
          3809 => Opcode::VST3q16,
          3810 => Opcode::VST3q16Pseudo_UPD,
          3811 => Opcode::VST3q16_UPD,
          3812 => Opcode::VST3q16oddPseudo,
          3813 => Opcode::VST3q16oddPseudo_UPD,
          3814 => Opcode::VST3q32,
          3815 => Opcode::VST3q32Pseudo_UPD,
          3816 => Opcode::VST3q32_UPD,
          3817 => Opcode::VST3q32oddPseudo,
          3818 => Opcode::VST3q32oddPseudo_UPD,
          3819 => Opcode::VST3q8,
          3820 => Opcode::VST3q8Pseudo_UPD,
          3821 => Opcode::VST3q8_UPD,
          3822 => Opcode::VST3q8oddPseudo,
          3823 => Opcode::VST3q8oddPseudo_UPD,
          3824 => Opcode::VST4LNd16,
          3825 => Opcode::VST4LNd16Pseudo,
          3826 => Opcode::VST4LNd16Pseudo_UPD,
          3827 => Opcode::VST4LNd16_UPD,
          3828 => Opcode::VST4LNd32,
          3829 => Opcode::VST4LNd32Pseudo,
          3830 => Opcode::VST4LNd32Pseudo_UPD,
          3831 => Opcode::VST4LNd32_UPD,
          3832 => Opcode::VST4LNd8,
          3833 => Opcode::VST4LNd8Pseudo,
          3834 => Opcode::VST4LNd8Pseudo_UPD,
          3835 => Opcode::VST4LNd8_UPD,
          3836 => Opcode::VST4LNq16,
          3837 => Opcode::VST4LNq16Pseudo,
          3838 => Opcode::VST4LNq16Pseudo_UPD,
          3839 => Opcode::VST4LNq16_UPD,
          3840 => Opcode::VST4LNq32,
          3841 => Opcode::VST4LNq32Pseudo,
          3842 => Opcode::VST4LNq32Pseudo_UPD,
          3843 => Opcode::VST4LNq32_UPD,
          3844 => Opcode::VST4d16,
          3845 => Opcode::VST4d16Pseudo,
          3846 => Opcode::VST4d16Pseudo_UPD,
          3847 => Opcode::VST4d16_UPD,
          3848 => Opcode::VST4d32,
          3849 => Opcode::VST4d32Pseudo,
          3850 => Opcode::VST4d32Pseudo_UPD,
          3851 => Opcode::VST4d32_UPD,
          3852 => Opcode::VST4d8,
          3853 => Opcode::VST4d8Pseudo,
          3854 => Opcode::VST4d8Pseudo_UPD,
          3855 => Opcode::VST4d8_UPD,
          3856 => Opcode::VST4q16,
          3857 => Opcode::VST4q16Pseudo_UPD,
          3858 => Opcode::VST4q16_UPD,
          3859 => Opcode::VST4q16oddPseudo,
          3860 => Opcode::VST4q16oddPseudo_UPD,
          3861 => Opcode::VST4q32,
          3862 => Opcode::VST4q32Pseudo_UPD,
          3863 => Opcode::VST4q32_UPD,
          3864 => Opcode::VST4q32oddPseudo,
          3865 => Opcode::VST4q32oddPseudo_UPD,
          3866 => Opcode::VST4q8,
          3867 => Opcode::VST4q8Pseudo_UPD,
          3868 => Opcode::VST4q8_UPD,
          3869 => Opcode::VST4q8oddPseudo,
          3870 => Opcode::VST4q8oddPseudo_UPD,
          3871 => Opcode::VSTMDDB_UPD,
          3872 => Opcode::VSTMDIA,
          3873 => Opcode::VSTMDIA_UPD,
          3874 => Opcode::VSTMQIA,
          3875 => Opcode::VSTMSDB_UPD,
          3876 => Opcode::VSTMSIA,
          3877 => Opcode::VSTMSIA_UPD,
          3878 => Opcode::VSTRD,
          3879 => Opcode::VSTRH,
          3880 => Opcode::VSTRS,
          3881 => Opcode::VSTR_FPCXTNS_off,
          3882 => Opcode::VSTR_FPCXTNS_post,
          3883 => Opcode::VSTR_FPCXTNS_pre,
          3884 => Opcode::VSTR_FPCXTS_off,
          3885 => Opcode::VSTR_FPCXTS_post,
          3886 => Opcode::VSTR_FPCXTS_pre,
          3887 => Opcode::VSTR_FPSCR_NZCVQC_off,
          3888 => Opcode::VSTR_FPSCR_NZCVQC_post,
          3889 => Opcode::VSTR_FPSCR_NZCVQC_pre,
          3890 => Opcode::VSTR_FPSCR_off,
          3891 => Opcode::VSTR_FPSCR_post,
          3892 => Opcode::VSTR_FPSCR_pre,
          3893 => Opcode::VSTR_P0_off,
          3894 => Opcode::VSTR_P0_post,
          3895 => Opcode::VSTR_P0_pre,
          3896 => Opcode::VSTR_VPR_off,
          3897 => Opcode::VSTR_VPR_post,
          3898 => Opcode::VSTR_VPR_pre,
          3899 => Opcode::VSUBD,
          3900 => Opcode::VSUBH,
          3901 => Opcode::VSUBHNv2i32,
          3902 => Opcode::VSUBHNv4i16,
          3903 => Opcode::VSUBHNv8i8,
          3904 => Opcode::VSUBLsv2i64,
          3905 => Opcode::VSUBLsv4i32,
          3906 => Opcode::VSUBLsv8i16,
          3907 => Opcode::VSUBLuv2i64,
          3908 => Opcode::VSUBLuv4i32,
          3909 => Opcode::VSUBLuv8i16,
          3910 => Opcode::VSUBS,
          3911 => Opcode::VSUBWsv2i64,
          3912 => Opcode::VSUBWsv4i32,
          3913 => Opcode::VSUBWsv8i16,
          3914 => Opcode::VSUBWuv2i64,
          3915 => Opcode::VSUBWuv4i32,
          3916 => Opcode::VSUBWuv8i16,
          3917 => Opcode::VSUBfd,
          3918 => Opcode::VSUBfq,
          3919 => Opcode::VSUBhd,
          3920 => Opcode::VSUBhq,
          3921 => Opcode::VSUBv16i8,
          3922 => Opcode::VSUBv1i64,
          3923 => Opcode::VSUBv2i32,
          3924 => Opcode::VSUBv2i64,
          3925 => Opcode::VSUBv4i16,
          3926 => Opcode::VSUBv4i32,
          3927 => Opcode::VSUBv8i16,
          3928 => Opcode::VSUBv8i8,
          3929 => Opcode::VSUDOTDI,
          3930 => Opcode::VSUDOTQI,
          3931 => Opcode::VSWPd,
          3932 => Opcode::VSWPq,
          3933 => Opcode::VTBL1,
          3934 => Opcode::VTBL2,
          3935 => Opcode::VTBL3,
          3936 => Opcode::VTBL3Pseudo,
          3937 => Opcode::VTBL4,
          3938 => Opcode::VTBL4Pseudo,
          3939 => Opcode::VTBX1,
          3940 => Opcode::VTBX2,
          3941 => Opcode::VTBX3,
          3942 => Opcode::VTBX3Pseudo,
          3943 => Opcode::VTBX4,
          3944 => Opcode::VTBX4Pseudo,
          3945 => Opcode::VTOSHD,
          3946 => Opcode::VTOSHH,
          3947 => Opcode::VTOSHS,
          3948 => Opcode::VTOSIRD,
          3949 => Opcode::VTOSIRH,
          3950 => Opcode::VTOSIRS,
          3951 => Opcode::VTOSIZD,
          3952 => Opcode::VTOSIZH,
          3953 => Opcode::VTOSIZS,
          3954 => Opcode::VTOSLD,
          3955 => Opcode::VTOSLH,
          3956 => Opcode::VTOSLS,
          3957 => Opcode::VTOUHD,
          3958 => Opcode::VTOUHH,
          3959 => Opcode::VTOUHS,
          3960 => Opcode::VTOUIRD,
          3961 => Opcode::VTOUIRH,
          3962 => Opcode::VTOUIRS,
          3963 => Opcode::VTOUIZD,
          3964 => Opcode::VTOUIZH,
          3965 => Opcode::VTOUIZS,
          3966 => Opcode::VTOULD,
          3967 => Opcode::VTOULH,
          3968 => Opcode::VTOULS,
          3969 => Opcode::VTRNd16,
          3970 => Opcode::VTRNd32,
          3971 => Opcode::VTRNd8,
          3972 => Opcode::VTRNq16,
          3973 => Opcode::VTRNq32,
          3974 => Opcode::VTRNq8,
          3975 => Opcode::VTSTv16i8,
          3976 => Opcode::VTSTv2i32,
          3977 => Opcode::VTSTv4i16,
          3978 => Opcode::VTSTv4i32,
          3979 => Opcode::VTSTv8i16,
          3980 => Opcode::VTSTv8i8,
          3981 => Opcode::VUDOTD,
          3982 => Opcode::VUDOTDI,
          3983 => Opcode::VUDOTQ,
          3984 => Opcode::VUDOTQI,
          3985 => Opcode::VUHTOD,
          3986 => Opcode::VUHTOH,
          3987 => Opcode::VUHTOS,
          3988 => Opcode::VUITOD,
          3989 => Opcode::VUITOH,
          3990 => Opcode::VUITOS,
          3991 => Opcode::VULTOD,
          3992 => Opcode::VULTOH,
          3993 => Opcode::VULTOS,
          3994 => Opcode::VUMMLA,
          3995 => Opcode::VUSDOTD,
          3996 => Opcode::VUSDOTDI,
          3997 => Opcode::VUSDOTQ,
          3998 => Opcode::VUSDOTQI,
          3999 => Opcode::VUSMMLA,
          4000 => Opcode::VUZPd16,
          4001 => Opcode::VUZPd8,
          4002 => Opcode::VUZPq16,
          4003 => Opcode::VUZPq32,
          4004 => Opcode::VUZPq8,
          4005 => Opcode::VZIPd16,
          4006 => Opcode::VZIPd8,
          4007 => Opcode::VZIPq16,
          4008 => Opcode::VZIPq32,
          4009 => Opcode::VZIPq8,
          4010 => Opcode::sysLDMDA,
          4011 => Opcode::sysLDMDA_UPD,
          4012 => Opcode::sysLDMDB,
          4013 => Opcode::sysLDMDB_UPD,
          4014 => Opcode::sysLDMIA,
          4015 => Opcode::sysLDMIA_UPD,
          4016 => Opcode::sysLDMIB,
          4017 => Opcode::sysLDMIB_UPD,
          4018 => Opcode::sysSTMDA,
          4019 => Opcode::sysSTMDA_UPD,
          4020 => Opcode::sysSTMDB,
          4021 => Opcode::sysSTMDB_UPD,
          4022 => Opcode::sysSTMIA,
          4023 => Opcode::sysSTMIA_UPD,
          4024 => Opcode::sysSTMIB,
          4025 => Opcode::sysSTMIB_UPD,
          4026 => Opcode::t2ADCri,
          4027 => Opcode::t2ADCrr,
          4028 => Opcode::t2ADCrs,
          4029 => Opcode::t2ADDri,
          4030 => Opcode::t2ADDri12,
          4031 => Opcode::t2ADDrr,
          4032 => Opcode::t2ADDrs,
          4033 => Opcode::t2ADDspImm,
          4034 => Opcode::t2ADDspImm12,
          4035 => Opcode::t2ADR,
          4036 => Opcode::t2ANDri,
          4037 => Opcode::t2ANDrr,
          4038 => Opcode::t2ANDrs,
          4039 => Opcode::t2ASRri,
          4040 => Opcode::t2ASRrr,
          4041 => Opcode::t2ASRs1,
          4042 => Opcode::t2AUT,
          4043 => Opcode::t2AUTG,
          4044 => Opcode::t2B,
          4045 => Opcode::t2BFC,
          4046 => Opcode::t2BFI,
          4047 => Opcode::t2BFLi,
          4048 => Opcode::t2BFLr,
          4049 => Opcode::t2BFi,
          4050 => Opcode::t2BFic,
          4051 => Opcode::t2BFr,
          4052 => Opcode::t2BICri,
          4053 => Opcode::t2BICrr,
          4054 => Opcode::t2BICrs,
          4055 => Opcode::t2BTI,
          4056 => Opcode::t2BXAUT,
          4057 => Opcode::t2BXJ,
          4058 => Opcode::t2Bcc,
          4059 => Opcode::t2CDP,
          4060 => Opcode::t2CDP2,
          4061 => Opcode::t2CLREX,
          4062 => Opcode::t2CLRM,
          4063 => Opcode::t2CLZ,
          4064 => Opcode::t2CMNri,
          4065 => Opcode::t2CMNzrr,
          4066 => Opcode::t2CMNzrs,
          4067 => Opcode::t2CMPri,
          4068 => Opcode::t2CMPrr,
          4069 => Opcode::t2CMPrs,
          4070 => Opcode::t2CPS1p,
          4071 => Opcode::t2CPS2p,
          4072 => Opcode::t2CPS3p,
          4073 => Opcode::t2CRC32B,
          4074 => Opcode::t2CRC32CB,
          4075 => Opcode::t2CRC32CH,
          4076 => Opcode::t2CRC32CW,
          4077 => Opcode::t2CRC32H,
          4078 => Opcode::t2CRC32W,
          4079 => Opcode::t2CSEL,
          4080 => Opcode::t2CSINC,
          4081 => Opcode::t2CSINV,
          4082 => Opcode::t2CSNEG,
          4083 => Opcode::t2DBG,
          4084 => Opcode::t2DCPS1,
          4085 => Opcode::t2DCPS2,
          4086 => Opcode::t2DCPS3,
          4087 => Opcode::t2DLS,
          4088 => Opcode::t2DMB,
          4089 => Opcode::t2DSB,
          4090 => Opcode::t2EORri,
          4091 => Opcode::t2EORrr,
          4092 => Opcode::t2EORrs,
          4093 => Opcode::t2HINT,
          4094 => Opcode::t2HVC,
          4095 => Opcode::t2ISB,
          4096 => Opcode::t2IT,
          4097 => Opcode::t2Int_eh_sjlj_setjmp,
          4098 => Opcode::t2Int_eh_sjlj_setjmp_nofp,
          4099 => Opcode::t2LDA,
          4100 => Opcode::t2LDAB,
          4101 => Opcode::t2LDAEX,
          4102 => Opcode::t2LDAEXB,
          4103 => Opcode::t2LDAEXD,
          4104 => Opcode::t2LDAEXH,
          4105 => Opcode::t2LDAH,
          4106 => Opcode::t2LDC2L_OFFSET,
          4107 => Opcode::t2LDC2L_OPTION,
          4108 => Opcode::t2LDC2L_POST,
          4109 => Opcode::t2LDC2L_PRE,
          4110 => Opcode::t2LDC2_OFFSET,
          4111 => Opcode::t2LDC2_OPTION,
          4112 => Opcode::t2LDC2_POST,
          4113 => Opcode::t2LDC2_PRE,
          4114 => Opcode::t2LDCL_OFFSET,
          4115 => Opcode::t2LDCL_OPTION,
          4116 => Opcode::t2LDCL_POST,
          4117 => Opcode::t2LDCL_PRE,
          4118 => Opcode::t2LDC_OFFSET,
          4119 => Opcode::t2LDC_OPTION,
          4120 => Opcode::t2LDC_POST,
          4121 => Opcode::t2LDC_PRE,
          4122 => Opcode::t2LDMDB,
          4123 => Opcode::t2LDMDB_UPD,
          4124 => Opcode::t2LDMIA,
          4125 => Opcode::t2LDMIA_UPD,
          4126 => Opcode::t2LDRBT,
          4127 => Opcode::t2LDRB_POST,
          4128 => Opcode::t2LDRB_PRE,
          4129 => Opcode::t2LDRBi12,
          4130 => Opcode::t2LDRBi8,
          4131 => Opcode::t2LDRBpci,
          4132 => Opcode::t2LDRBs,
          4133 => Opcode::t2LDRD_POST,
          4134 => Opcode::t2LDRD_PRE,
          4135 => Opcode::t2LDRDi8,
          4136 => Opcode::t2LDREX,
          4137 => Opcode::t2LDREXB,
          4138 => Opcode::t2LDREXD,
          4139 => Opcode::t2LDREXH,
          4140 => Opcode::t2LDRHT,
          4141 => Opcode::t2LDRH_POST,
          4142 => Opcode::t2LDRH_PRE,
          4143 => Opcode::t2LDRHi12,
          4144 => Opcode::t2LDRHi8,
          4145 => Opcode::t2LDRHpci,
          4146 => Opcode::t2LDRHs,
          4147 => Opcode::t2LDRSBT,
          4148 => Opcode::t2LDRSB_POST,
          4149 => Opcode::t2LDRSB_PRE,
          4150 => Opcode::t2LDRSBi12,
          4151 => Opcode::t2LDRSBi8,
          4152 => Opcode::t2LDRSBpci,
          4153 => Opcode::t2LDRSBs,
          4154 => Opcode::t2LDRSHT,
          4155 => Opcode::t2LDRSH_POST,
          4156 => Opcode::t2LDRSH_PRE,
          4157 => Opcode::t2LDRSHi12,
          4158 => Opcode::t2LDRSHi8,
          4159 => Opcode::t2LDRSHpci,
          4160 => Opcode::t2LDRSHs,
          4161 => Opcode::t2LDRT,
          4162 => Opcode::t2LDR_POST,
          4163 => Opcode::t2LDR_PRE,
          4164 => Opcode::t2LDRi12,
          4165 => Opcode::t2LDRi8,
          4166 => Opcode::t2LDRpci,
          4167 => Opcode::t2LDRs,
          4168 => Opcode::t2LE,
          4169 => Opcode::t2LEUpdate,
          4170 => Opcode::t2LSLri,
          4171 => Opcode::t2LSLrr,
          4172 => Opcode::t2LSRri,
          4173 => Opcode::t2LSRrr,
          4174 => Opcode::t2LSRs1,
          4175 => Opcode::t2MCR,
          4176 => Opcode::t2MCR2,
          4177 => Opcode::t2MCRR,
          4178 => Opcode::t2MCRR2,
          4179 => Opcode::t2MLA,
          4180 => Opcode::t2MLS,
          4181 => Opcode::t2MOVTi16,
          4182 => Opcode::t2MOVi,
          4183 => Opcode::t2MOVi16,
          4184 => Opcode::t2MOVr,
          4185 => Opcode::t2MRC,
          4186 => Opcode::t2MRC2,
          4187 => Opcode::t2MRRC,
          4188 => Opcode::t2MRRC2,
          4189 => Opcode::t2MRS_AR,
          4190 => Opcode::t2MRS_M,
          4191 => Opcode::t2MRSbanked,
          4192 => Opcode::t2MRSsys_AR,
          4193 => Opcode::t2MSR_AR,
          4194 => Opcode::t2MSR_M,
          4195 => Opcode::t2MSRbanked,
          4196 => Opcode::t2MUL,
          4197 => Opcode::t2MVNi,
          4198 => Opcode::t2MVNr,
          4199 => Opcode::t2MVNs,
          4200 => Opcode::t2ORNri,
          4201 => Opcode::t2ORNrr,
          4202 => Opcode::t2ORNrs,
          4203 => Opcode::t2ORRri,
          4204 => Opcode::t2ORRrr,
          4205 => Opcode::t2ORRrs,
          4206 => Opcode::t2PAC,
          4207 => Opcode::t2PACBTI,
          4208 => Opcode::t2PACG,
          4209 => Opcode::t2PKHBT,
          4210 => Opcode::t2PKHTB,
          4211 => Opcode::t2PLDWi12,
          4212 => Opcode::t2PLDWi8,
          4213 => Opcode::t2PLDWs,
          4214 => Opcode::t2PLDi12,
          4215 => Opcode::t2PLDi8,
          4216 => Opcode::t2PLDpci,
          4217 => Opcode::t2PLDs,
          4218 => Opcode::t2PLIi12,
          4219 => Opcode::t2PLIi8,
          4220 => Opcode::t2PLIpci,
          4221 => Opcode::t2PLIs,
          4222 => Opcode::t2QADD,
          4223 => Opcode::t2QADD16,
          4224 => Opcode::t2QADD8,
          4225 => Opcode::t2QASX,
          4226 => Opcode::t2QDADD,
          4227 => Opcode::t2QDSUB,
          4228 => Opcode::t2QSAX,
          4229 => Opcode::t2QSUB,
          4230 => Opcode::t2QSUB16,
          4231 => Opcode::t2QSUB8,
          4232 => Opcode::t2RBIT,
          4233 => Opcode::t2REV,
          4234 => Opcode::t2REV16,
          4235 => Opcode::t2REVSH,
          4236 => Opcode::t2RFEDB,
          4237 => Opcode::t2RFEDBW,
          4238 => Opcode::t2RFEIA,
          4239 => Opcode::t2RFEIAW,
          4240 => Opcode::t2RORri,
          4241 => Opcode::t2RORrr,
          4242 => Opcode::t2RRX,
          4243 => Opcode::t2RSBri,
          4244 => Opcode::t2RSBrr,
          4245 => Opcode::t2RSBrs,
          4246 => Opcode::t2SADD16,
          4247 => Opcode::t2SADD8,
          4248 => Opcode::t2SASX,
          4249 => Opcode::t2SB,
          4250 => Opcode::t2SBCri,
          4251 => Opcode::t2SBCrr,
          4252 => Opcode::t2SBCrs,
          4253 => Opcode::t2SBFX,
          4254 => Opcode::t2SDIV,
          4255 => Opcode::t2SEL,
          4256 => Opcode::t2SETPAN,
          4257 => Opcode::t2SG,
          4258 => Opcode::t2SHADD16,
          4259 => Opcode::t2SHADD8,
          4260 => Opcode::t2SHASX,
          4261 => Opcode::t2SHSAX,
          4262 => Opcode::t2SHSUB16,
          4263 => Opcode::t2SHSUB8,
          4264 => Opcode::t2SMC,
          4265 => Opcode::t2SMLABB,
          4266 => Opcode::t2SMLABT,
          4267 => Opcode::t2SMLAD,
          4268 => Opcode::t2SMLADX,
          4269 => Opcode::t2SMLAL,
          4270 => Opcode::t2SMLALBB,
          4271 => Opcode::t2SMLALBT,
          4272 => Opcode::t2SMLALD,
          4273 => Opcode::t2SMLALDX,
          4274 => Opcode::t2SMLALTB,
          4275 => Opcode::t2SMLALTT,
          4276 => Opcode::t2SMLATB,
          4277 => Opcode::t2SMLATT,
          4278 => Opcode::t2SMLAWB,
          4279 => Opcode::t2SMLAWT,
          4280 => Opcode::t2SMLSD,
          4281 => Opcode::t2SMLSDX,
          4282 => Opcode::t2SMLSLD,
          4283 => Opcode::t2SMLSLDX,
          4284 => Opcode::t2SMMLA,
          4285 => Opcode::t2SMMLAR,
          4286 => Opcode::t2SMMLS,
          4287 => Opcode::t2SMMLSR,
          4288 => Opcode::t2SMMUL,
          4289 => Opcode::t2SMMULR,
          4290 => Opcode::t2SMUAD,
          4291 => Opcode::t2SMUADX,
          4292 => Opcode::t2SMULBB,
          4293 => Opcode::t2SMULBT,
          4294 => Opcode::t2SMULL,
          4295 => Opcode::t2SMULTB,
          4296 => Opcode::t2SMULTT,
          4297 => Opcode::t2SMULWB,
          4298 => Opcode::t2SMULWT,
          4299 => Opcode::t2SMUSD,
          4300 => Opcode::t2SMUSDX,
          4301 => Opcode::t2SRSDB,
          4302 => Opcode::t2SRSDB_UPD,
          4303 => Opcode::t2SRSIA,
          4304 => Opcode::t2SRSIA_UPD,
          4305 => Opcode::t2SSAT,
          4306 => Opcode::t2SSAT16,
          4307 => Opcode::t2SSAX,
          4308 => Opcode::t2SSUB16,
          4309 => Opcode::t2SSUB8,
          4310 => Opcode::t2STC2L_OFFSET,
          4311 => Opcode::t2STC2L_OPTION,
          4312 => Opcode::t2STC2L_POST,
          4313 => Opcode::t2STC2L_PRE,
          4314 => Opcode::t2STC2_OFFSET,
          4315 => Opcode::t2STC2_OPTION,
          4316 => Opcode::t2STC2_POST,
          4317 => Opcode::t2STC2_PRE,
          4318 => Opcode::t2STCL_OFFSET,
          4319 => Opcode::t2STCL_OPTION,
          4320 => Opcode::t2STCL_POST,
          4321 => Opcode::t2STCL_PRE,
          4322 => Opcode::t2STC_OFFSET,
          4323 => Opcode::t2STC_OPTION,
          4324 => Opcode::t2STC_POST,
          4325 => Opcode::t2STC_PRE,
          4326 => Opcode::t2STL,
          4327 => Opcode::t2STLB,
          4328 => Opcode::t2STLEX,
          4329 => Opcode::t2STLEXB,
          4330 => Opcode::t2STLEXD,
          4331 => Opcode::t2STLEXH,
          4332 => Opcode::t2STLH,
          4333 => Opcode::t2STMDB,
          4334 => Opcode::t2STMDB_UPD,
          4335 => Opcode::t2STMIA,
          4336 => Opcode::t2STMIA_UPD,
          4337 => Opcode::t2STRBT,
          4338 => Opcode::t2STRB_POST,
          4339 => Opcode::t2STRB_PRE,
          4340 => Opcode::t2STRBi12,
          4341 => Opcode::t2STRBi8,
          4342 => Opcode::t2STRBs,
          4343 => Opcode::t2STRD_POST,
          4344 => Opcode::t2STRD_PRE,
          4345 => Opcode::t2STRDi8,
          4346 => Opcode::t2STREX,
          4347 => Opcode::t2STREXB,
          4348 => Opcode::t2STREXD,
          4349 => Opcode::t2STREXH,
          4350 => Opcode::t2STRHT,
          4351 => Opcode::t2STRH_POST,
          4352 => Opcode::t2STRH_PRE,
          4353 => Opcode::t2STRHi12,
          4354 => Opcode::t2STRHi8,
          4355 => Opcode::t2STRHs,
          4356 => Opcode::t2STRT,
          4357 => Opcode::t2STR_POST,
          4358 => Opcode::t2STR_PRE,
          4359 => Opcode::t2STRi12,
          4360 => Opcode::t2STRi8,
          4361 => Opcode::t2STRs,
          4362 => Opcode::t2SUBS_PC_LR,
          4363 => Opcode::t2SUBri,
          4364 => Opcode::t2SUBri12,
          4365 => Opcode::t2SUBrr,
          4366 => Opcode::t2SUBrs,
          4367 => Opcode::t2SUBspImm,
          4368 => Opcode::t2SUBspImm12,
          4369 => Opcode::t2SXTAB,
          4370 => Opcode::t2SXTAB16,
          4371 => Opcode::t2SXTAH,
          4372 => Opcode::t2SXTB,
          4373 => Opcode::t2SXTB16,
          4374 => Opcode::t2SXTH,
          4375 => Opcode::t2TBB,
          4376 => Opcode::t2TBH,
          4377 => Opcode::t2TEQri,
          4378 => Opcode::t2TEQrr,
          4379 => Opcode::t2TEQrs,
          4380 => Opcode::t2TSB,
          4381 => Opcode::t2TSTri,
          4382 => Opcode::t2TSTrr,
          4383 => Opcode::t2TSTrs,
          4384 => Opcode::t2TT,
          4385 => Opcode::t2TTA,
          4386 => Opcode::t2TTAT,
          4387 => Opcode::t2TTT,
          4388 => Opcode::t2UADD16,
          4389 => Opcode::t2UADD8,
          4390 => Opcode::t2UASX,
          4391 => Opcode::t2UBFX,
          4392 => Opcode::t2UDF,
          4393 => Opcode::t2UDIV,
          4394 => Opcode::t2UHADD16,
          4395 => Opcode::t2UHADD8,
          4396 => Opcode::t2UHASX,
          4397 => Opcode::t2UHSAX,
          4398 => Opcode::t2UHSUB16,
          4399 => Opcode::t2UHSUB8,
          4400 => Opcode::t2UMAAL,
          4401 => Opcode::t2UMLAL,
          4402 => Opcode::t2UMULL,
          4403 => Opcode::t2UQADD16,
          4404 => Opcode::t2UQADD8,
          4405 => Opcode::t2UQASX,
          4406 => Opcode::t2UQSAX,
          4407 => Opcode::t2UQSUB16,
          4408 => Opcode::t2UQSUB8,
          4409 => Opcode::t2USAD8,
          4410 => Opcode::t2USADA8,
          4411 => Opcode::t2USAT,
          4412 => Opcode::t2USAT16,
          4413 => Opcode::t2USAX,
          4414 => Opcode::t2USUB16,
          4415 => Opcode::t2USUB8,
          4416 => Opcode::t2UXTAB,
          4417 => Opcode::t2UXTAB16,
          4418 => Opcode::t2UXTAH,
          4419 => Opcode::t2UXTB,
          4420 => Opcode::t2UXTB16,
          4421 => Opcode::t2UXTH,
          4422 => Opcode::t2WLS,
          4423 => Opcode::tADC,
          4424 => Opcode::tADDhirr,
          4425 => Opcode::tADDi3,
          4426 => Opcode::tADDi8,
          4427 => Opcode::tADDrSP,
          4428 => Opcode::tADDrSPi,
          4429 => Opcode::tADDrr,
          4430 => Opcode::tADDspi,
          4431 => Opcode::tADDspr,
          4432 => Opcode::tADR,
          4433 => Opcode::tAND,
          4434 => Opcode::tASRri,
          4435 => Opcode::tASRrr,
          4436 => Opcode::tB,
          4437 => Opcode::tBIC,
          4438 => Opcode::tBKPT,
          4439 => Opcode::tBL,
          4440 => Opcode::tBLXNSr,
          4441 => Opcode::tBLXi,
          4442 => Opcode::tBLXr,
          4443 => Opcode::tBX,
          4444 => Opcode::tBXNS,
          4445 => Opcode::tBcc,
          4446 => Opcode::tCBNZ,
          4447 => Opcode::tCBZ,
          4448 => Opcode::tCMNz,
          4449 => Opcode::tCMPhir,
          4450 => Opcode::tCMPi8,
          4451 => Opcode::tCMPr,
          4452 => Opcode::tCPS,
          4453 => Opcode::tEOR,
          4454 => Opcode::tHINT,
          4455 => Opcode::tHLT,
          4456 => Opcode::tInt_WIN_eh_sjlj_longjmp,
          4457 => Opcode::tInt_eh_sjlj_longjmp,
          4458 => Opcode::tInt_eh_sjlj_setjmp,
          4459 => Opcode::tLDMIA,
          4460 => Opcode::tLDRBi,
          4461 => Opcode::tLDRBr,
          4462 => Opcode::tLDRHi,
          4463 => Opcode::tLDRHr,
          4464 => Opcode::tLDRSB,
          4465 => Opcode::tLDRSH,
          4466 => Opcode::tLDRi,
          4467 => Opcode::tLDRpci,
          4468 => Opcode::tLDRr,
          4469 => Opcode::tLDRspi,
          4470 => Opcode::tLSLri,
          4471 => Opcode::tLSLrr,
          4472 => Opcode::tLSRri,
          4473 => Opcode::tLSRrr,
          4474 => Opcode::tMOVSr,
          4475 => Opcode::tMOVi8,
          4476 => Opcode::tMOVr,
          4477 => Opcode::tMUL,
          4478 => Opcode::tMVN,
          4479 => Opcode::tORR,
          4480 => Opcode::tPICADD,
          4481 => Opcode::tPOP,
          4482 => Opcode::tPUSH,
          4483 => Opcode::tREV,
          4484 => Opcode::tREV16,
          4485 => Opcode::tREVSH,
          4486 => Opcode::tROR,
          4487 => Opcode::tRSB,
          4488 => Opcode::tSBC,
          4489 => Opcode::tSETEND,
          4490 => Opcode::tSTMIA_UPD,
          4491 => Opcode::tSTRBi,
          4492 => Opcode::tSTRBr,
          4493 => Opcode::tSTRHi,
          4494 => Opcode::tSTRHr,
          4495 => Opcode::tSTRi,
          4496 => Opcode::tSTRr,
          4497 => Opcode::tSTRspi,
          4498 => Opcode::tSUBi3,
          4499 => Opcode::tSUBi8,
          4500 => Opcode::tSUBrr,
          4501 => Opcode::tSUBspi,
          4502 => Opcode::tSVC,
          4503 => Opcode::tSXTB,
          4504 => Opcode::tSXTH,
          4505 => Opcode::tTRAP,
          4506 => Opcode::tTST,
          4507 => Opcode::tUDF,
          4508 => Opcode::tUXTB,
          4509 => Opcode::tUXTH,
          4510 => Opcode::t__brkdiv0,
          4511 => Opcode::INSTRUCTION_LIST_END,
          _ => Opcode::UNKNOWN(value),
        }
    }
}
