# Допоможіть FastAPI - отримайте допомогу { #help-fastapi-get-help }

Вам подобається **FastAPI**?

Хочете допомогти FastAPI, іншим користувачам та автору?

Або ви хочете отримати допомогу щодо **FastAPI**?

Є дуже прості способи допомогти (деякі потребують лише одного-двох кліків).

І є кілька способів отримати допомогу.

## Підпишіться на розсилку { #subscribe-to-the-newsletter }

Ви можете підписатися на (нечасту) розсилку [**FastAPI and friends**](newsletter.md){.internal-link target=_blank}, щоб бути в курсі:

* Новин про FastAPI та друзів 🚀
* Посібників 📝
* Можливостей ✨
* Несумісних змін 🚨
* Порад і трюків ✅

## Стежте за FastAPI в X (Twitter) { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">Стежте за @fastapi в **X (Twitter)**</a>, щоб отримувати найсвіжіші новини про **FastAPI**. 🐦

## Додайте зірочку **FastAPI** на GitHub { #star-fastapi-in-github }

Ви можете «поставити зірочку» FastAPI на GitHub (натиснувши кнопку зірочки у верхньому правому куті): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Додавши зірочку, іншим користувачам буде легше його знайти і побачити, що він уже був корисним для інших.

## Стежте за випусками в репозиторії GitHub { #watch-the-github-repository-for-releases }

Ви можете «спостерігати» за FastAPI на GitHub (натиснувши кнопку «watch» у верхньому правому куті): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Там ви можете вибрати «Releases only».

Зробивши це, ви отримуватимете сповіщення (на вашу електронну пошту) щоразу, коли вийде новий реліз (нова версія) **FastAPI** з виправленнями помилок і новими можливостями.

## Зв'яжіться з автором { #connect-with-the-author }

Ви можете зв'язатися зі <a href="https://tiangolo.com" class="external-link" target="_blank">мною (Sebastián Ramírez / `tiangolo`)</a>, автором.

Ви можете:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Стежити за мною на **GitHub**</a>.
    * Подивитися інші Open Source-проєкти, які я створив і які можуть вам допомогти.
    * Стежити, щоб бачити, коли я створюю новий Open Source-проєкт.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Стежити за мною в **X (Twitter)**</a> або <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Розкажіть мені, як ви використовуєте FastAPI (мені дуже приємно це чути).
    * Дізнаватися, коли я роблю оголошення або випускаю нові інструменти.
    * Також ви можете <a href="https://x.com/fastapi" class="external-link" target="_blank">стежити за @fastapi в X (Twitter)</a> (окремий акаунт).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Стежити за мною в **LinkedIn**</a>.
    * Дізнаватися, коли я роблю оголошення або випускаю нові інструменти (хоча X (Twitter) я використовую частіше 🤷‍♂).
* Читати, що я пишу (або стежити за мною) на <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> або <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Читати інші ідеї, статті та про інструменти, які я створив.
    * Стежити, щоб читати нове, коли я щось публікую.

## Твітніть про **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Твітніть про **FastAPI**</a> і дайте мені та іншим знати, чому він вам подобається. 🎉

Мені дуже подобається дізнаватися, як використовують **FastAPI**, що вам у ньому сподобалося, у якому проєкті/компанії ви його застосовуєте тощо.

## Голосуйте за FastAPI { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Проголосуйте за **FastAPI** на Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Проголосуйте за **FastAPI** на AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Повідомте, що ви використовуєте **FastAPI**, на StackShare</a>.

## Допомагайте іншим з питаннями на GitHub { #help-others-with-questions-in-github }

Ви можете спробувати допомагати іншим з їхніми питаннями у:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

У багатьох випадках ви вже можете знати відповідь на ці питання. 🤓

Якщо ви багато допомагаєте людям із їхніми питаннями, ви станете офіційним [Експертом FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}. 🎉

Пам'ятайте, найважливіше: намагайтеся бути добрими. Люди приходять зі своєю фрустрацією і часто питають не найкращим чином, але постарайтеся бути якомога доброзичливішими. 🤗

Ідея в тому, щоб спільнота **FastAPI** була доброзичливою та гостинною. Водночас не терпіть булінг чи неповажну поведінку щодо інших. Ми маємо піклуватися одне про одного.

---

Ось як допомагати іншим із питаннями (у discussions або issues):

### Зрозумійте питання { #understand-the-question }

* Перевірте, чи розумієте ви **мету** та варіант використання людини, яка питає.

* Потім перевірте, чи **чітке** саме питання (переважна більшість — це питання).

* Часто запит стосується уявного рішення користувача, але може бути **краще**. Якщо ви краще зрозумієте проблему та варіант використання, зможете запропонувати кращу **альтернативу**.

* Якщо ви не розумієте питання, попросіть більше **подробиць**.

### Відтворіть проблему { #reproduce-the-problem }

У більшості випадків і запитань мова йде про **оригінальний код** людини.

Часто вони наводять лише фрагмент коду, але цього недостатньо, щоб **відтворити проблему**.

* Ви можете попросити надати <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">мінімальний, відтворюваний приклад</a>, який ви зможете **скопіювати-вставити** і запустити локально, щоб побачити ту саму помилку або поведінку, яку бачать вони, або краще зрозуміти їхній варіант використання.

* Якщо ви дуже щедрі, можете спробувати **створити такий приклад** самостійно, лише на основі опису проблеми. Просто майте на увазі, що це може зайняти багато часу, і краще спочатку попросити їх уточнити проблему.

### Запропонуйте рішення { #suggest-solutions }

* Після того як ви змогли зрозуміти питання, дайте можливу **відповідь**.

* Часто краще зрозуміти їхню **первинну проблему або варіант використання**, адже може бути кращий спосіб її вирішити, ніж те, що вони намагаються зробити.

### Попросіть закрити { #ask-to-close }

Якщо вони відповіли, дуже ймовірно, що ви розв'язали їхню проблему. Вітаю, **ви герой**! 🦸

* Тепер, якщо це вирішило їхню проблему, ви можете попросити:

    * У GitHub Discussions: позначити коментар як **відповідь**.
    * У GitHub Issues: **закрити** issue.

## Стежте за репозиторієм GitHub { #watch-the-github-repository }

Ви можете «спостерігати» за FastAPI на GitHub (натиснувши кнопку «watch» у верхньому правому куті): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Якщо вибрати «Watching» замість «Releases only», ви отримуватимете сповіщення, коли хтось створює нове issue або питання. Ви також можете вказати, що хочете отримувати сповіщення лише про нові issues, або discussions, або PR тощо.

Тоді ви зможете спробувати допомогти їм вирішити ці питання.

## Ставте питання { #ask-questions }

Ви можете <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">створити нове питання</a> у репозиторії GitHub, наприклад, щоб:

* Поставити **питання** або запитати про **проблему**.
* Запропонувати нову **можливість**.

**Примітка**: якщо ви це зробите, я попрошу вас також допомагати іншим. 😉

## Переглядайте запити на витяг { #review-pull-requests }

Ви можете допомогти мені переглядати запити на витяг інших.

І знову, будь ласка, намагайтеся бути якомога доброзичливішими. 🤗

---

Ось що слід пам'ятати і як переглядати запит на витяг:

### Зрозумійте проблему { #understand-the-problem }

* Спочатку переконайтеся, що ви **розумієте проблему**, яку намагається вирішити запит на витяг. Може бути довша дискусія у GitHub Discussion або issue.

* Також є велика ймовірність, що запит на витяг насправді не потрібен, бо проблему можна розв'язати **іншим способом**. Тоді ви можете про це запропонувати або запитати.

### Не переймайтеся стилем { #dont-worry-about-style }

* Не надто хвилюйтеся про стиль повідомлень фіксацій, я зроблю squash and merge, налаштувавши фіксацію вручну.

* Також не переймайтеся правилами стилю, вже є автоматизовані інструменти, що це перевіряють.

А якщо будуть інші вимоги щодо стилю чи узгодженості, я попрошу про це безпосередньо або додам зверху фіксації з потрібними змінами.

### Перевірте код { #check-the-code }

* Перегляньте та прочитайте код, оцініть, чи він має сенс, **запустіть його локально** і перевірте, чи справді він розв'язує проблему.

* Потім залиште **коментар**, що ви це зробили, так я знатиму, що ви справді перевірили.

/// info | Інформація

На жаль, я не можу просто довіряти PR, які мають кілька схвалень.

Бувало не раз, що PR мали 3, 5 або більше схвалень, мабуть тому, що опис привабливий, але коли я перевіряв PR, вони виявлялися зламаними, мали помилку або не розв'язували заявлену проблему. 😅

Тож дуже важливо, щоб ви справді прочитали і запустили код та повідомили в коментарях, що ви це зробили. 🤓

///

* Якщо PR можна якось спростити, ви можете про це попросити, але немає потреби бути надто прискіпливими, адже може бути багато суб'єктивних точок зору (і в мене також є своя 🙈), тож краще зосередитися на фундаментальних речах.

### Тести { #tests }

* Допоможіть перевірити, що PR має **тести**.

* Переконайтеся, що тести **падають** до PR. 🚨

* Потім перевірте, що тести **проходять** після PR. ✅

* Багато PRів не мають тестів, ви можете **нагадати** додати тести або навіть **запропонувати** деякі тести самі. Це одна з речей, яка найбільше забирає часу, і ви дуже допоможете.

* Потім також прокоментуйте, що саме ви спробували, так я знатиму, що ви це перевірили. 🤓

## Створіть запит на витяг { #create-a-pull-request }

Ви можете [зробити внесок](contributing.md){.internal-link target=_blank} у вихідний код із запитами на витяг, наприклад:

* Щоб виправити описку, знайдену в документації.
* Щоб поділитися статтею, відео або подкастом про FastAPI, який ви створили або знайшли, <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">відредагувавши цей файл</a>.
    * Обов'язково додайте ваше посилання на початок відповідного розділу.
* Щоб допомогти [перекласти документацію](contributing.md#translations){.internal-link target=_blank} вашою мовою.
    * Ви також можете допомогти з переглядом перекладів, створених іншими.
* Щоб запропонувати нові розділи документації.
* Щоб виправити наявну проблему/помилку.
    * Обов'язково додайте тести.
* Щоб додати нову можливість.
    * Обов'язково додайте тести.
    * Обов'язково додайте документацію, якщо це доречно.

## Допоможіть підтримувати FastAPI { #help-maintain-fastapi }

Допоможіть мені підтримувати **FastAPI**! 🤓

Роботи багато, і більшу її частину можете зробити **ВИ**.

Основні завдання, які ви можете виконувати вже зараз:

* [Допомагайте іншим з питаннями на GitHub](#help-others-with-questions-in-github){.internal-link target=_blank} (див. розділ вище).
* [Переглядайте запити на витяг](#review-pull-requests){.internal-link target=_blank} (див. розділ вище).

Ці два завдання **найбільше споживають час**. Це основна робота з підтримки FastAPI.

Якщо ви можете допомогти мені з цим, **ви допомагаєте підтримувати FastAPI** і гарантуєте, що він **рухатиметься швидше й краще**. 🚀

## Долучайтеся до чату { #join-the-chat }

Долучайтеся до 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">серверу чату Discord</a> 👥 і спілкуйтеся з іншими в спільноті FastAPI.

/// tip | Порада

Для запитань ставте їх у <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>, там значно вища ймовірність, що вам допоможуть [Експерти FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}.

Використовуйте чат лише для інших загальних розмов.

///

### Не використовуйте чат для запитань { #dont-use-the-chat-for-questions }

Майте на увазі, що оскільки чати дозволяють більше «вільної розмови», легко ставити надто загальні питання, на які складніше відповісти, тож ви можете не отримати відповідей.

У GitHub шаблон підкаже вам, як написати правильне питання, щоб ви легше отримали хорошу відповідь, або навіть вирішили проблему самостійно ще до запиту. І в GitHub я можу гарантувати, що завжди на все відповім, навіть якщо це займе трохи часу. Особисто я не можу робити це в чатах. 😅

Розмови в чатах також не так просто шукати, як у GitHub, тож питання та відповіді можуть загубитися. І лише ті, що в GitHub, зараховуються, щоб стати [Експертом FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}, тож швидше за все ви отримаєте більше уваги саме в GitHub.

З іншого боку, у чатах є тисячі користувачів, тож дуже ймовірно, що ви майже завжди знайдете там співрозмовника. 😄

## Спонсоруйте автора { #sponsor-the-author }

Якщо ваш **продукт/компанія** залежить від **FastAPI** або пов'язана з ним і ви хочете охопити його користувачів, ви можете спонсорувати автора (мене) через <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a>. Залежно від рівня ви можете отримати додаткові переваги, наприклад значок у документації. 🎁

---

Дякую! 🚀
