; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes='module(sancov-module)' -sanitizer-coverage-level=2 -S | FileCheck %s
; RUN: opt < %s -passes='module(sancov-module)' -sanitizer-coverage-level=1 -sanitizer-coverage-stack-depth -sanitizer-coverage-stack-depth-callback-min=1 -S | FileCheck %s --check-prefix=CHECK-STACK-CALLBACK
; RUN: opt < %s -passes='module(sancov-module)' -sanitizer-coverage-level=1 -sanitizer-coverage-stack-depth -S | FileCheck %s --check-prefix=CHECK-STACK-DEPTH

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

define i32 @with_dbg(ptr %a, ptr %b) !dbg !3 {
; CHECK-LABEL: define i32 @with_dbg(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]]) comdat !dbg [[DBG3:![0-9]+]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    call void @__sanitizer_cov_trace_pc_guard(ptr @__sancov_gen_) #[[ATTR1:[0-9]+]], !dbg [[DBG6:![0-9]+]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP1]], 42
; CHECK-NEXT:    br i1 [[CMP]], label %[[BB0:.*]], label %[[BB1:.*]]
; CHECK:       [[BB0]]:
; CHECK-NEXT:    call void @__sanitizer_cov_trace_pc_guard(ptr getelementptr inbounds ([2 x i32], ptr @__sancov_gen_, i64 0, i64 1)) #[[ATTR1]], !dbg [[DBG7:![0-9]+]]
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[B]], align 4
; CHECK-NEXT:    br label %[[BB1]]
; CHECK:       [[BB1]]:
; CHECK-NEXT:    ret i32 [[TMP1]]
;
entry:
  %t = load i32, ptr %a, align 4
  %cmp = icmp eq i32 %t, 42
  br i1 %cmp, label %0, label %1
0:
  store i32 %t, ptr %b
  br label %1
1:
  ret i32 %t
}

define i32 @without_dbg(ptr %a, ptr %b) {
; CHECK-LABEL: define i32 @without_dbg(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]]) comdat {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    call void @__sanitizer_cov_trace_pc_guard(ptr @__sancov_gen_.1) #[[ATTR1]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP1]], 42
; CHECK-NEXT:    br i1 [[CMP]], label %[[BB0:.*]], label %[[BB1:.*]]
; CHECK:       [[BB0]]:
; CHECK-NEXT:    call void @__sanitizer_cov_trace_pc_guard(ptr getelementptr inbounds ([2 x i32], ptr @__sancov_gen_.1, i64 0, i64 1)) #[[ATTR1]]
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[B]], align 4
; CHECK-NEXT:    br label %[[BB1]]
; CHECK:       [[BB1]]:
; CHECK-NEXT:    ret i32 [[TMP1]]
;
entry:
  %t = load i32, ptr %a, align 4
  %cmp = icmp eq i32 %t, 42
  br i1 %cmp, label %0, label %1
0:
  store i32 %t, ptr %b
  br label %1
1:
  ret i32 %t
}

define i32 @with_dbg_stack_callback(ptr %a) !dbg !8 {
; CHECK-STACK-CALLBACK-LABEL: define i32 @with_dbg_stack_callback(
; CHECK-STACK-CALLBACK-SAME: ptr [[A:%.*]]) !dbg [[DBG8:![0-9]+]] {
; CHECK-STACK-CALLBACK-NEXT:  entry:
; CHECK-STACK-CALLBACK-NEXT:    [[BUF:%.*]] = alloca [64 x i8], align 1
; CHECK-STACK-CALLBACK-NEXT:    call void @__sanitizer_cov_stack_depth() #[[ATTR1:[0-9]+]], !dbg [[DBG9:![0-9]+]]
; CHECK-STACK-CALLBACK-NEXT:    %t = load i32, ptr [[A]], align 4
; CHECK-STACK-CALLBACK-NEXT:    call void @external_func()
; CHECK-STACK-CALLBACK-NEXT:    ret i32 %t
;
entry:
  %buf = alloca [64 x i8], align 1
  %t = load i32, ptr %a, align 4
  call void @external_func()
  ret i32 %t
}

define i32 @with_dbg_stack_depth(ptr %a) !dbg !10 {
; CHECK-STACK-DEPTH-LABEL: define i32 @with_dbg_stack_depth(
; CHECK-STACK-DEPTH-SAME: ptr [[A:%.*]]) !dbg [[DBG10:![0-9]+]] {
; CHECK-STACK-DEPTH-NEXT:  entry:
; CHECK-STACK-DEPTH-NEXT:    [[BUF:%.*]] = alloca [64 x i8], align 1
; CHECK-STACK-DEPTH-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; CHECK-STACK-DEPTH-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; CHECK-STACK-DEPTH-NEXT:    [[TMP3:%.*]] = load i64, ptr @__sancov_lowest_stack, align 8
; CHECK-STACK-DEPTH-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP2]], [[TMP3]]
; CHECK-STACK-DEPTH-NEXT:    br i1 [[TMP4]], label {{%.*}}, label {{%.*}}
; CHECK-STACK-DEPTH:       store i64 [[TMP2]], ptr @__sancov_lowest_stack, align 8, !dbg [[DBG11:![0-9]+]], {{.*}}!nosanitize
; CHECK-STACK-DEPTH:       %t = load i32, ptr [[A]], align 4
; CHECK-STACK-DEPTH-NEXT:    call void @external_func()
; CHECK-STACK-DEPTH-NEXT:    ret i32 %t
;
entry:
  %buf = alloca [64 x i8], align 1
  %t = load i32, ptr %a, align 4
  call void @external_func()
  ret i32 %t
}

define i32 @without_dbg_stack_callback(ptr %a) {
; CHECK-STACK-CALLBACK-LABEL: define i32 @without_dbg_stack_callback(
; CHECK-STACK-CALLBACK-SAME: ptr [[A:%.*]]) {
; CHECK-STACK-CALLBACK-NEXT:  entry:
; CHECK-STACK-CALLBACK-NEXT:    [[BUF:%.*]] = alloca [64 x i8], align 1
; CHECK-STACK-CALLBACK-NEXT:    call void @__sanitizer_cov_stack_depth() #[[ATTR1]]
; CHECK-STACK-CALLBACK-NEXT:    %t = load i32, ptr [[A]], align 4
; CHECK-STACK-CALLBACK-NEXT:    call void @external_func()
; CHECK-STACK-CALLBACK-NEXT:    ret i32 %t
;
entry:
  %buf = alloca [64 x i8], align 1
  %t = load i32, ptr %a, align 4
  call void @external_func()
  ret i32 %t
}

define i32 @without_dbg_stack_depth(ptr %a) {
; CHECK-STACK-DEPTH-LABEL: define i32 @without_dbg_stack_depth(
; CHECK-STACK-DEPTH-SAME: ptr [[A:%.*]]) {
; CHECK-STACK-DEPTH-NEXT:  entry:
; CHECK-STACK-DEPTH-NEXT:    [[BUF:%.*]] = alloca [64 x i8], align 1
; CHECK-STACK-DEPTH-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; CHECK-STACK-DEPTH-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; CHECK-STACK-DEPTH-NEXT:    [[TMP3:%.*]] = load i64, ptr @__sancov_lowest_stack, align 8
; CHECK-STACK-DEPTH-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP2]], [[TMP3]]
; CHECK-STACK-DEPTH-NEXT:    br i1 [[TMP4]], label {{%.*}}, label {{%.*}}
; CHECK-STACK-DEPTH:       store i64 [[TMP2]], ptr @__sancov_lowest_stack, align 8, {{.*}}!nosanitize
; CHECK-STACK-DEPTH:       %t = load i32, ptr [[A]], align 4
; CHECK-STACK-DEPTH-NEXT:    call void @external_func()
; CHECK-STACK-DEPTH-NEXT:    ret i32 %t
;
entry:
  %buf = alloca [64 x i8], align 1
  %t = load i32, ptr %a, align 4
  call void @external_func()
  ret i32 %t
}

declare void @external_func()

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!2}

!0 = distinct !DICompileUnit(language: DW_LANG_C89, file: !1, producer: "", isOptimized: true, runtimeVersion: 0, emissionKind: LineTablesOnly, splitDebugInlining: false, nameTableKind: None)
!1 = !DIFile(filename: "foo.c", directory: "")
!2 = !{i32 2, !"Debug Info Version", i32 3}
!3 = distinct !DISubprogram(name: "foo", scope: !1, file: !1, line: 190, type: !4, scopeLine: 192, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !0)
!4 = !DISubroutineType(types: !5)
!5 = !{}
!6 = !DILocation(line: 192, scope: !3)
!7 = !DILocation(line: 0, scope: !3)
!8 = distinct !DISubprogram(name: "with_dbg_stack_callback", scope: !1, file: !1, line: 200, type: !4, scopeLine: 200, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !0)
!9 = !DILocation(line: 200, scope: !8)
!10 = distinct !DISubprogram(name: "with_dbg_stack_depth", scope: !1, file: !1, line: 210, type: !4, scopeLine: 210, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !0)
!11 = !DILocation(line: 210, scope: !10)

;.
; CHECK: [[META0:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C89, file: [[META1:![0-9]+]], isOptimized: true, runtimeVersion: 0, emissionKind: LineTablesOnly, splitDebugInlining: false, nameTableKind: None)
; CHECK: [[META1]] = !DIFile(filename: "foo.c", directory: "")
; CHECK: [[DBG3]] = distinct !DISubprogram(name: "foo", scope: [[META1]], file: [[META1]], line: 190, type: [[META4:![0-9]+]], scopeLine: 192, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: [[META0]])
; CHECK: [[META4]] = !DISubroutineType(types: [[META5:![0-9]+]])
; CHECK: [[META5]] = !{}
; CHECK: [[DBG6]] = !DILocation(line: 192, scope: [[DBG3]])
; CHECK: [[DBG7]] = !DILocation(line: 0, scope: [[DBG3]])
;.
; CHECK-STACK-CALLBACK: [[DBG8]] = distinct !DISubprogram(name: "with_dbg_stack_callback", scope: {{.*}}, file: {{.*}}, line: 200
; CHECK-STACK-CALLBACK: [[DBG9]] = !DILocation(line: 200, scope: [[DBG8]])
;.
; CHECK-STACK-DEPTH: [[DBG10]] = distinct !DISubprogram(name: "with_dbg_stack_depth", scope: {{.*}}, file: {{.*}}, line: 210
; CHECK-STACK-DEPTH: [[DBG11]] = !DILocation(line: 210, scope: [[DBG10]])
;.
