; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX942 %s


define void @v_shuffle_v2i64_v8i64__u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v8i64__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> poison
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v14
; GFX900-NEXT:    v_mov_b32_e32 v1, v15
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    global_store_dwordx4 v2, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v14
; GFX90A-NEXT:    v_mov_b32_e32 v1, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v14
; GFX942-NEXT:    v_mov_b32_e32 v1, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v8i64__8_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v14
; GFX900-NEXT:    v_mov_b32_e32 v1, v15
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    global_store_dwordx4 v2, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v14
; GFX90A-NEXT:    v_mov_b32_e32 v1, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v14
; GFX942-NEXT:    v_mov_b32_e32 v1, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, v14
; GFX900-NEXT:    v_mov_b32_e32 v17, v15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v18, v0
; GFX900-NEXT:    v_mov_b32_e32 v19, v1
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[16:19], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v16
; GFX90A-NEXT:    v_mov_b32_e32 v3, v17
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v18, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v16
; GFX942-NEXT:    v_mov_b32_e32 v3, v17
; GFX942-NEXT:    v_mov_b32_e32 v4, v0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx4 v18, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v18
; GFX900-NEXT:    v_mov_b32_e32 v1, v19
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v18
; GFX90A-NEXT:    v_mov_b32_e32 v1, v19
; GFX90A-NEXT:    global_store_dwordx4 v20, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v18
; GFX942-NEXT:    v_mov_b32_e32 v1, v19
; GFX942-NEXT:    global_store_dwordx4 v20, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v20
; GFX900-NEXT:    v_mov_b32_e32 v3, v21
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v20
; GFX90A-NEXT:    v_mov_b32_e32 v3, v21
; GFX90A-NEXT:    global_store_dwordx4 v22, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v20
; GFX942-NEXT:    v_mov_b32_e32 v3, v21
; GFX942-NEXT:    global_store_dwordx4 v22, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v22
; GFX900-NEXT:    v_mov_b32_e32 v5, v23
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, v22
; GFX90A-NEXT:    v_mov_b32_e32 v5, v23
; GFX90A-NEXT:    global_store_dwordx4 v24, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v22
; GFX942-NEXT:    v_mov_b32_e32 v5, v23
; GFX942-NEXT:    global_store_dwordx4 v24, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v24
; GFX900-NEXT:    v_mov_b32_e32 v7, v25
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, v24
; GFX90A-NEXT:    v_mov_b32_e32 v7, v25
; GFX90A-NEXT:    global_store_dwordx4 v26, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v24
; GFX942-NEXT:    v_mov_b32_e32 v7, v25
; GFX942-NEXT:    global_store_dwordx4 v26, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v26
; GFX900-NEXT:    v_mov_b32_e32 v9, v27
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, v26
; GFX90A-NEXT:    v_mov_b32_e32 v9, v27
; GFX90A-NEXT:    global_store_dwordx4 v28, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v26
; GFX942-NEXT:    v_mov_b32_e32 v9, v27
; GFX942-NEXT:    global_store_dwordx4 v28, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v28
; GFX900-NEXT:    v_mov_b32_e32 v11, v29
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, v28
; GFX90A-NEXT:    v_mov_b32_e32 v11, v29
; GFX90A-NEXT:    global_store_dwordx4 v30, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v28
; GFX942-NEXT:    v_mov_b32_e32 v11, v29
; GFX942-NEXT:    global_store_dwordx4 v30, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v30
; GFX900-NEXT:    v_mov_b32_e32 v13, v31
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v32, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, v30
; GFX90A-NEXT:    v_mov_b32_e32 v13, v31
; GFX90A-NEXT:    global_store_dwordx4 v32, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v32, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v30
; GFX942-NEXT:    v_mov_b32_e32 v13, v31
; GFX942-NEXT:    global_store_dwordx4 v32, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v14
; GFX900-NEXT:    v_mov_b32_e32 v3, v15
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v14
; GFX90A-NEXT:    v_mov_b32_e32 v3, v15
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v14
; GFX942-NEXT:    v_mov_b32_e32 v3, v15
; GFX942-NEXT:    v_mov_b32_e32 v4, v0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v14
; GFX900-NEXT:    v_mov_b32_e32 v1, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v14
; GFX90A-NEXT:    v_mov_b32_e32 v1, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v14
; GFX942-NEXT:    v_mov_b32_e32 v1, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v14
; GFX900-NEXT:    v_mov_b32_e32 v3, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v14
; GFX90A-NEXT:    v_mov_b32_e32 v3, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v14
; GFX942-NEXT:    v_mov_b32_e32 v3, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v14
; GFX900-NEXT:    v_mov_b32_e32 v5, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v14
; GFX90A-NEXT:    v_mov_b32_e32 v5, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v14
; GFX942-NEXT:    v_mov_b32_e32 v5, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v14
; GFX900-NEXT:    v_mov_b32_e32 v7, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v14
; GFX90A-NEXT:    v_mov_b32_e32 v7, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v14
; GFX942-NEXT:    v_mov_b32_e32 v7, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v14
; GFX900-NEXT:    v_mov_b32_e32 v9, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v14
; GFX90A-NEXT:    v_mov_b32_e32 v9, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v14
; GFX942-NEXT:    v_mov_b32_e32 v9, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v14
; GFX900-NEXT:    v_mov_b32_e32 v11, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v14
; GFX90A-NEXT:    v_mov_b32_e32 v11, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v14
; GFX942-NEXT:    v_mov_b32_e32 v11, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__15_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__15_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v14
; GFX900-NEXT:    v_mov_b32_e32 v13, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__15_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v14
; GFX90A-NEXT:    v_mov_b32_e32 v13, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__15_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v14
; GFX942-NEXT:    v_mov_b32_e32 v13, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> zeroinitializer
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v0
; GFX942-NEXT:    v_mov_b32_e32 v7, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v0
; GFX900-NEXT:    v_mov_b32_e32 v9, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v0
; GFX942-NEXT:    v_mov_b32_e32 v9, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v0
; GFX900-NEXT:    v_mov_b32_e32 v11, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v0
; GFX90A-NEXT:    v_mov_b32_e32 v11, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v0
; GFX942-NEXT:    v_mov_b32_e32 v11, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v0
; GFX900-NEXT:    v_mov_b32_e32 v13, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v0
; GFX90A-NEXT:    v_mov_b32_e32 v13, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v0
; GFX942-NEXT:    v_mov_b32_e32 v13, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v0
; GFX900-NEXT:    v_mov_b32_e32 v15, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v0
; GFX90A-NEXT:    v_mov_b32_e32 v15, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v0
; GFX942-NEXT:    v_mov_b32_e32 v15, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v14
; GFX900-NEXT:    v_mov_b32_e32 v3, v15
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v14
; GFX90A-NEXT:    v_mov_b32_e32 v3, v15
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v14
; GFX942-NEXT:    v_mov_b32_e32 v3, v15
; GFX942-NEXT:    v_mov_b32_e32 v4, v0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx4 v18, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v0
; GFX942-NEXT:    v_mov_b32_e32 v7, v1
; GFX942-NEXT:    global_store_dwordx4 v18, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v1
; GFX90A-NEXT:    global_store_dwordx4 v18, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v0
; GFX942-NEXT:    v_mov_b32_e32 v9, v1
; GFX942-NEXT:    global_store_dwordx4 v18, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v0
; GFX90A-NEXT:    v_mov_b32_e32 v11, v1
; GFX90A-NEXT:    global_store_dwordx4 v18, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v0
; GFX942-NEXT:    v_mov_b32_e32 v11, v1
; GFX942-NEXT:    global_store_dwordx4 v18, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v0
; GFX90A-NEXT:    v_mov_b32_e32 v13, v1
; GFX90A-NEXT:    global_store_dwordx4 v18, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v0
; GFX942-NEXT:    v_mov_b32_e32 v13, v1
; GFX942-NEXT:    global_store_dwordx4 v18, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v0
; GFX90A-NEXT:    v_mov_b32_e32 v15, v1
; GFX90A-NEXT:    global_store_dwordx4 v18, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v0
; GFX942-NEXT:    v_mov_b32_e32 v15, v1
; GFX942-NEXT:    global_store_dwordx4 v18, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v16, v0
; GFX90A-NEXT:    v_mov_b32_e32 v17, v1
; GFX90A-NEXT:    global_store_dwordx4 v18, v[14:17], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v16, v0
; GFX942-NEXT:    v_mov_b32_e32 v17, v1
; GFX942-NEXT:    global_store_dwordx4 v18, v[14:17], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v2
; GFX900-NEXT:    v_mov_b32_e32 v5, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v2
; GFX942-NEXT:    v_mov_b32_e32 v5, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v2
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v2
; GFX942-NEXT:    v_mov_b32_e32 v7, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v2
; GFX900-NEXT:    v_mov_b32_e32 v9, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v2
; GFX90A-NEXT:    v_mov_b32_e32 v9, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v2
; GFX942-NEXT:    v_mov_b32_e32 v9, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v2
; GFX900-NEXT:    v_mov_b32_e32 v11, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v2
; GFX90A-NEXT:    v_mov_b32_e32 v11, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v2
; GFX942-NEXT:    v_mov_b32_e32 v11, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v2
; GFX900-NEXT:    v_mov_b32_e32 v13, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v2
; GFX90A-NEXT:    v_mov_b32_e32 v13, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v2
; GFX942-NEXT:    v_mov_b32_e32 v13, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v2
; GFX900-NEXT:    v_mov_b32_e32 v15, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v2
; GFX90A-NEXT:    v_mov_b32_e32 v15, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v2
; GFX942-NEXT:    v_mov_b32_e32 v15, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v14
; GFX900-NEXT:    v_mov_b32_e32 v1, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v14
; GFX90A-NEXT:    v_mov_b32_e32 v1, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v14
; GFX942-NEXT:    v_mov_b32_e32 v1, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v2
; GFX90A-NEXT:    v_mov_b32_e32 v9, v3
; GFX90A-NEXT:    global_store_dwordx4 v20, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v2
; GFX942-NEXT:    v_mov_b32_e32 v9, v3
; GFX942-NEXT:    global_store_dwordx4 v20, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v2
; GFX90A-NEXT:    v_mov_b32_e32 v11, v3
; GFX90A-NEXT:    global_store_dwordx4 v20, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v2
; GFX942-NEXT:    v_mov_b32_e32 v11, v3
; GFX942-NEXT:    global_store_dwordx4 v20, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v2
; GFX90A-NEXT:    v_mov_b32_e32 v13, v3
; GFX90A-NEXT:    global_store_dwordx4 v20, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v2
; GFX942-NEXT:    v_mov_b32_e32 v13, v3
; GFX942-NEXT:    global_store_dwordx4 v20, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v2
; GFX90A-NEXT:    v_mov_b32_e32 v15, v3
; GFX90A-NEXT:    global_store_dwordx4 v20, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v2
; GFX942-NEXT:    v_mov_b32_e32 v15, v3
; GFX942-NEXT:    global_store_dwordx4 v20, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v16, v2
; GFX90A-NEXT:    v_mov_b32_e32 v17, v3
; GFX90A-NEXT:    global_store_dwordx4 v20, v[14:17], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v16, v2
; GFX942-NEXT:    v_mov_b32_e32 v17, v3
; GFX942-NEXT:    global_store_dwordx4 v20, v[14:17], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v18, v2
; GFX90A-NEXT:    v_mov_b32_e32 v19, v3
; GFX90A-NEXT:    global_store_dwordx4 v20, v[16:19], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v18, v2
; GFX942-NEXT:    v_mov_b32_e32 v19, v3
; GFX942-NEXT:    global_store_dwordx4 v20, v[16:19], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v4
; GFX900-NEXT:    v_mov_b32_e32 v7, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v4
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v4
; GFX942-NEXT:    v_mov_b32_e32 v7, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v4
; GFX900-NEXT:    v_mov_b32_e32 v9, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v4
; GFX90A-NEXT:    v_mov_b32_e32 v9, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v4
; GFX942-NEXT:    v_mov_b32_e32 v9, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v4
; GFX900-NEXT:    v_mov_b32_e32 v11, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v4
; GFX90A-NEXT:    v_mov_b32_e32 v11, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v4
; GFX942-NEXT:    v_mov_b32_e32 v11, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v4
; GFX900-NEXT:    v_mov_b32_e32 v13, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v4
; GFX90A-NEXT:    v_mov_b32_e32 v13, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v4
; GFX942-NEXT:    v_mov_b32_e32 v13, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v4
; GFX900-NEXT:    v_mov_b32_e32 v15, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v4
; GFX90A-NEXT:    v_mov_b32_e32 v15, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v4
; GFX942-NEXT:    v_mov_b32_e32 v15, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v14
; GFX900-NEXT:    v_mov_b32_e32 v3, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v14
; GFX90A-NEXT:    v_mov_b32_e32 v3, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v14
; GFX942-NEXT:    v_mov_b32_e32 v3, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v4
; GFX90A-NEXT:    v_mov_b32_e32 v11, v5
; GFX90A-NEXT:    global_store_dwordx4 v22, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v4
; GFX942-NEXT:    v_mov_b32_e32 v11, v5
; GFX942-NEXT:    global_store_dwordx4 v22, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v4
; GFX90A-NEXT:    v_mov_b32_e32 v13, v5
; GFX90A-NEXT:    global_store_dwordx4 v22, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v4
; GFX942-NEXT:    v_mov_b32_e32 v13, v5
; GFX942-NEXT:    global_store_dwordx4 v22, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v4
; GFX90A-NEXT:    v_mov_b32_e32 v15, v5
; GFX90A-NEXT:    global_store_dwordx4 v22, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v4
; GFX942-NEXT:    v_mov_b32_e32 v15, v5
; GFX942-NEXT:    global_store_dwordx4 v22, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v16, v4
; GFX90A-NEXT:    v_mov_b32_e32 v17, v5
; GFX90A-NEXT:    global_store_dwordx4 v22, v[14:17], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v16, v4
; GFX942-NEXT:    v_mov_b32_e32 v17, v5
; GFX942-NEXT:    global_store_dwordx4 v22, v[14:17], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v18, v4
; GFX90A-NEXT:    v_mov_b32_e32 v19, v5
; GFX90A-NEXT:    global_store_dwordx4 v22, v[16:19], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v18, v4
; GFX942-NEXT:    v_mov_b32_e32 v19, v5
; GFX942-NEXT:    global_store_dwordx4 v22, v[16:19], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v20, v4
; GFX90A-NEXT:    v_mov_b32_e32 v21, v5
; GFX90A-NEXT:    global_store_dwordx4 v22, v[18:21], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v20, v4
; GFX942-NEXT:    v_mov_b32_e32 v21, v5
; GFX942-NEXT:    global_store_dwordx4 v22, v[18:21], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v6
; GFX942-NEXT:    v_mov_b32_e32 v5, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v6
; GFX900-NEXT:    v_mov_b32_e32 v9, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v6
; GFX90A-NEXT:    v_mov_b32_e32 v9, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v6
; GFX942-NEXT:    v_mov_b32_e32 v9, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v6
; GFX900-NEXT:    v_mov_b32_e32 v11, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v6
; GFX90A-NEXT:    v_mov_b32_e32 v11, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v6
; GFX942-NEXT:    v_mov_b32_e32 v11, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v6
; GFX900-NEXT:    v_mov_b32_e32 v13, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v6
; GFX90A-NEXT:    v_mov_b32_e32 v13, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v6
; GFX942-NEXT:    v_mov_b32_e32 v13, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v6
; GFX900-NEXT:    v_mov_b32_e32 v15, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v6
; GFX90A-NEXT:    v_mov_b32_e32 v15, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v6
; GFX942-NEXT:    v_mov_b32_e32 v15, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v14
; GFX900-NEXT:    v_mov_b32_e32 v5, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v14
; GFX90A-NEXT:    v_mov_b32_e32 v5, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v14
; GFX942-NEXT:    v_mov_b32_e32 v5, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v6
; GFX90A-NEXT:    v_mov_b32_e32 v13, v7
; GFX90A-NEXT:    global_store_dwordx4 v24, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v6
; GFX942-NEXT:    v_mov_b32_e32 v13, v7
; GFX942-NEXT:    global_store_dwordx4 v24, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v6
; GFX90A-NEXT:    v_mov_b32_e32 v15, v7
; GFX90A-NEXT:    global_store_dwordx4 v24, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v6
; GFX942-NEXT:    v_mov_b32_e32 v15, v7
; GFX942-NEXT:    global_store_dwordx4 v24, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v16, v6
; GFX90A-NEXT:    v_mov_b32_e32 v17, v7
; GFX90A-NEXT:    global_store_dwordx4 v24, v[14:17], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v16, v6
; GFX942-NEXT:    v_mov_b32_e32 v17, v7
; GFX942-NEXT:    global_store_dwordx4 v24, v[14:17], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v18, v6
; GFX90A-NEXT:    v_mov_b32_e32 v19, v7
; GFX90A-NEXT:    global_store_dwordx4 v24, v[16:19], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v18, v6
; GFX942-NEXT:    v_mov_b32_e32 v19, v7
; GFX942-NEXT:    global_store_dwordx4 v24, v[16:19], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v20, v6
; GFX90A-NEXT:    v_mov_b32_e32 v21, v7
; GFX90A-NEXT:    global_store_dwordx4 v24, v[18:21], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v20, v6
; GFX942-NEXT:    v_mov_b32_e32 v21, v7
; GFX942-NEXT:    global_store_dwordx4 v24, v[18:21], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v22, v6
; GFX90A-NEXT:    v_mov_b32_e32 v23, v7
; GFX90A-NEXT:    global_store_dwordx4 v24, v[20:23], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v22, v6
; GFX942-NEXT:    v_mov_b32_e32 v23, v7
; GFX942-NEXT:    global_store_dwordx4 v24, v[20:23], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v8
; GFX900-NEXT:    v_mov_b32_e32 v3, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v8
; GFX90A-NEXT:    v_mov_b32_e32 v3, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v8
; GFX942-NEXT:    v_mov_b32_e32 v3, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v8
; GFX900-NEXT:    v_mov_b32_e32 v5, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v8
; GFX90A-NEXT:    v_mov_b32_e32 v5, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v8
; GFX942-NEXT:    v_mov_b32_e32 v5, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v8
; GFX900-NEXT:    v_mov_b32_e32 v7, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v8
; GFX90A-NEXT:    v_mov_b32_e32 v7, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v8
; GFX942-NEXT:    v_mov_b32_e32 v7, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v8
; GFX900-NEXT:    v_mov_b32_e32 v11, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v8
; GFX90A-NEXT:    v_mov_b32_e32 v11, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v8
; GFX942-NEXT:    v_mov_b32_e32 v11, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v8
; GFX900-NEXT:    v_mov_b32_e32 v13, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v8
; GFX90A-NEXT:    v_mov_b32_e32 v13, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v8
; GFX942-NEXT:    v_mov_b32_e32 v13, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v8
; GFX900-NEXT:    v_mov_b32_e32 v15, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v8
; GFX90A-NEXT:    v_mov_b32_e32 v15, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v8
; GFX942-NEXT:    v_mov_b32_e32 v15, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v14
; GFX900-NEXT:    v_mov_b32_e32 v7, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v14
; GFX90A-NEXT:    v_mov_b32_e32 v7, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v14
; GFX942-NEXT:    v_mov_b32_e32 v7, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v8
; GFX90A-NEXT:    v_mov_b32_e32 v15, v9
; GFX90A-NEXT:    global_store_dwordx4 v26, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v8
; GFX942-NEXT:    v_mov_b32_e32 v15, v9
; GFX942-NEXT:    global_store_dwordx4 v26, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v16, v8
; GFX90A-NEXT:    v_mov_b32_e32 v17, v9
; GFX90A-NEXT:    global_store_dwordx4 v26, v[14:17], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v16, v8
; GFX942-NEXT:    v_mov_b32_e32 v17, v9
; GFX942-NEXT:    global_store_dwordx4 v26, v[14:17], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v18, v8
; GFX90A-NEXT:    v_mov_b32_e32 v19, v9
; GFX90A-NEXT:    global_store_dwordx4 v26, v[16:19], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v18, v8
; GFX942-NEXT:    v_mov_b32_e32 v19, v9
; GFX942-NEXT:    global_store_dwordx4 v26, v[16:19], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v20, v8
; GFX90A-NEXT:    v_mov_b32_e32 v21, v9
; GFX90A-NEXT:    global_store_dwordx4 v26, v[18:21], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v20, v8
; GFX942-NEXT:    v_mov_b32_e32 v21, v9
; GFX942-NEXT:    global_store_dwordx4 v26, v[18:21], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v22, v8
; GFX90A-NEXT:    v_mov_b32_e32 v23, v9
; GFX90A-NEXT:    global_store_dwordx4 v26, v[20:23], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v22, v8
; GFX942-NEXT:    v_mov_b32_e32 v23, v9
; GFX942-NEXT:    global_store_dwordx4 v26, v[20:23], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v24, v8
; GFX90A-NEXT:    v_mov_b32_e32 v25, v9
; GFX90A-NEXT:    global_store_dwordx4 v26, v[22:25], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v24, v8
; GFX942-NEXT:    v_mov_b32_e32 v25, v9
; GFX942-NEXT:    global_store_dwordx4 v26, v[22:25], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v10
; GFX900-NEXT:    v_mov_b32_e32 v3, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v10
; GFX90A-NEXT:    v_mov_b32_e32 v3, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v10
; GFX942-NEXT:    v_mov_b32_e32 v3, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v10
; GFX900-NEXT:    v_mov_b32_e32 v5, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v10
; GFX90A-NEXT:    v_mov_b32_e32 v5, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v10
; GFX942-NEXT:    v_mov_b32_e32 v5, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v10
; GFX900-NEXT:    v_mov_b32_e32 v7, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v10
; GFX90A-NEXT:    v_mov_b32_e32 v7, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v10
; GFX942-NEXT:    v_mov_b32_e32 v7, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v10
; GFX900-NEXT:    v_mov_b32_e32 v9, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v10
; GFX90A-NEXT:    v_mov_b32_e32 v9, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v10
; GFX942-NEXT:    v_mov_b32_e32 v9, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v10
; GFX900-NEXT:    v_mov_b32_e32 v13, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v10
; GFX90A-NEXT:    v_mov_b32_e32 v13, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v10
; GFX942-NEXT:    v_mov_b32_e32 v13, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v10
; GFX900-NEXT:    v_mov_b32_e32 v15, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v10
; GFX90A-NEXT:    v_mov_b32_e32 v15, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v10
; GFX942-NEXT:    v_mov_b32_e32 v15, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v14
; GFX900-NEXT:    v_mov_b32_e32 v9, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v14
; GFX90A-NEXT:    v_mov_b32_e32 v9, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v14
; GFX942-NEXT:    v_mov_b32_e32 v9, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v16, v10
; GFX90A-NEXT:    v_mov_b32_e32 v17, v11
; GFX90A-NEXT:    global_store_dwordx4 v28, v[14:17], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v16, v10
; GFX942-NEXT:    v_mov_b32_e32 v17, v11
; GFX942-NEXT:    global_store_dwordx4 v28, v[14:17], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v18, v10
; GFX90A-NEXT:    v_mov_b32_e32 v19, v11
; GFX90A-NEXT:    global_store_dwordx4 v28, v[16:19], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v18, v10
; GFX942-NEXT:    v_mov_b32_e32 v19, v11
; GFX942-NEXT:    global_store_dwordx4 v28, v[16:19], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v20, v10
; GFX90A-NEXT:    v_mov_b32_e32 v21, v11
; GFX90A-NEXT:    global_store_dwordx4 v28, v[18:21], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v20, v10
; GFX942-NEXT:    v_mov_b32_e32 v21, v11
; GFX942-NEXT:    global_store_dwordx4 v28, v[18:21], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v22, v10
; GFX90A-NEXT:    v_mov_b32_e32 v23, v11
; GFX90A-NEXT:    global_store_dwordx4 v28, v[20:23], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v22, v10
; GFX942-NEXT:    v_mov_b32_e32 v23, v11
; GFX942-NEXT:    global_store_dwordx4 v28, v[20:23], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v24, v10
; GFX90A-NEXT:    v_mov_b32_e32 v25, v11
; GFX90A-NEXT:    global_store_dwordx4 v28, v[22:25], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v24, v10
; GFX942-NEXT:    v_mov_b32_e32 v25, v11
; GFX942-NEXT:    global_store_dwordx4 v28, v[22:25], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v26, v10
; GFX90A-NEXT:    v_mov_b32_e32 v27, v11
; GFX90A-NEXT:    global_store_dwordx4 v28, v[24:27], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v26, v10
; GFX942-NEXT:    v_mov_b32_e32 v27, v11
; GFX942-NEXT:    global_store_dwordx4 v28, v[24:27], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v12
; GFX900-NEXT:    v_mov_b32_e32 v3, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v12
; GFX90A-NEXT:    v_mov_b32_e32 v3, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v12
; GFX942-NEXT:    v_mov_b32_e32 v3, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v12
; GFX900-NEXT:    v_mov_b32_e32 v5, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v12
; GFX90A-NEXT:    v_mov_b32_e32 v5, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v12
; GFX942-NEXT:    v_mov_b32_e32 v5, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v12
; GFX900-NEXT:    v_mov_b32_e32 v7, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v12
; GFX90A-NEXT:    v_mov_b32_e32 v7, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v12
; GFX942-NEXT:    v_mov_b32_e32 v7, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v12
; GFX900-NEXT:    v_mov_b32_e32 v9, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v12
; GFX90A-NEXT:    v_mov_b32_e32 v9, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v12
; GFX942-NEXT:    v_mov_b32_e32 v9, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v12
; GFX900-NEXT:    v_mov_b32_e32 v11, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v12
; GFX90A-NEXT:    v_mov_b32_e32 v11, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v12
; GFX942-NEXT:    v_mov_b32_e32 v11, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v12
; GFX900-NEXT:    v_mov_b32_e32 v15, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v12
; GFX90A-NEXT:    v_mov_b32_e32 v15, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v12
; GFX942-NEXT:    v_mov_b32_e32 v15, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v14
; GFX900-NEXT:    v_mov_b32_e32 v11, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v14
; GFX90A-NEXT:    v_mov_b32_e32 v11, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v14
; GFX942-NEXT:    v_mov_b32_e32 v11, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v18, v12
; GFX90A-NEXT:    v_mov_b32_e32 v19, v13
; GFX90A-NEXT:    global_store_dwordx4 v30, v[16:19], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v18, v12
; GFX942-NEXT:    v_mov_b32_e32 v19, v13
; GFX942-NEXT:    global_store_dwordx4 v30, v[16:19], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v20, v12
; GFX90A-NEXT:    v_mov_b32_e32 v21, v13
; GFX90A-NEXT:    global_store_dwordx4 v30, v[18:21], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v20, v12
; GFX942-NEXT:    v_mov_b32_e32 v21, v13
; GFX942-NEXT:    global_store_dwordx4 v30, v[18:21], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v22, v12
; GFX90A-NEXT:    v_mov_b32_e32 v23, v13
; GFX90A-NEXT:    global_store_dwordx4 v30, v[20:23], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v22, v12
; GFX942-NEXT:    v_mov_b32_e32 v23, v13
; GFX942-NEXT:    global_store_dwordx4 v30, v[20:23], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v24, v12
; GFX90A-NEXT:    v_mov_b32_e32 v25, v13
; GFX90A-NEXT:    global_store_dwordx4 v30, v[22:25], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v24, v12
; GFX942-NEXT:    v_mov_b32_e32 v25, v13
; GFX942-NEXT:    global_store_dwordx4 v30, v[22:25], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v26, v12
; GFX90A-NEXT:    v_mov_b32_e32 v27, v13
; GFX90A-NEXT:    global_store_dwordx4 v30, v[24:27], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v26, v12
; GFX942-NEXT:    v_mov_b32_e32 v27, v13
; GFX942-NEXT:    global_store_dwordx4 v30, v[24:27], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v28, v12
; GFX90A-NEXT:    v_mov_b32_e32 v29, v13
; GFX90A-NEXT:    global_store_dwordx4 v30, v[26:29], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v28, v12
; GFX942-NEXT:    v_mov_b32_e32 v29, v13
; GFX942-NEXT:    global_store_dwordx4 v30, v[26:29], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v14
; GFX900-NEXT:    v_mov_b32_e32 v3, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v14
; GFX90A-NEXT:    v_mov_b32_e32 v3, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v14
; GFX942-NEXT:    v_mov_b32_e32 v3, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v14
; GFX900-NEXT:    v_mov_b32_e32 v5, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v14
; GFX90A-NEXT:    v_mov_b32_e32 v5, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v14
; GFX942-NEXT:    v_mov_b32_e32 v5, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v14
; GFX900-NEXT:    v_mov_b32_e32 v7, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v14
; GFX90A-NEXT:    v_mov_b32_e32 v7, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v14
; GFX942-NEXT:    v_mov_b32_e32 v7, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v14
; GFX900-NEXT:    v_mov_b32_e32 v9, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v14
; GFX90A-NEXT:    v_mov_b32_e32 v9, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v14
; GFX942-NEXT:    v_mov_b32_e32 v9, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v14
; GFX900-NEXT:    v_mov_b32_e32 v11, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v14
; GFX90A-NEXT:    v_mov_b32_e32 v11, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v14
; GFX942-NEXT:    v_mov_b32_e32 v11, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v14
; GFX900-NEXT:    v_mov_b32_e32 v13, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v14
; GFX90A-NEXT:    v_mov_b32_e32 v13, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v14
; GFX942-NEXT:    v_mov_b32_e32 v13, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v14
; GFX900-NEXT:    v_mov_b32_e32 v13, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v14
; GFX90A-NEXT:    v_mov_b32_e32 v13, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v14
; GFX942-NEXT:    v_mov_b32_e32 v13, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v32, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, v14
; GFX90A-NEXT:    v_mov_b32_e32 v21, v15
; GFX90A-NEXT:    global_store_dwordx4 v32, v[18:21], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v32, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v20, v14
; GFX942-NEXT:    v_mov_b32_e32 v21, v15
; GFX942-NEXT:    global_store_dwordx4 v32, v[18:21], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v32, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, v14
; GFX90A-NEXT:    v_mov_b32_e32 v23, v15
; GFX90A-NEXT:    global_store_dwordx4 v32, v[20:23], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v32, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v22, v14
; GFX942-NEXT:    v_mov_b32_e32 v23, v15
; GFX942-NEXT:    global_store_dwordx4 v32, v[20:23], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v32, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, v14
; GFX90A-NEXT:    v_mov_b32_e32 v25, v15
; GFX90A-NEXT:    global_store_dwordx4 v32, v[22:25], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v32, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v24, v14
; GFX942-NEXT:    v_mov_b32_e32 v25, v15
; GFX942-NEXT:    global_store_dwordx4 v32, v[22:25], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v32, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, v14
; GFX90A-NEXT:    v_mov_b32_e32 v27, v15
; GFX90A-NEXT:    global_store_dwordx4 v32, v[24:27], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v32, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v26, v14
; GFX942-NEXT:    v_mov_b32_e32 v27, v15
; GFX942-NEXT:    global_store_dwordx4 v32, v[24:27], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v32, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, v14
; GFX90A-NEXT:    v_mov_b32_e32 v29, v15
; GFX90A-NEXT:    global_store_dwordx4 v32, v[26:29], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v32, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v28, v14
; GFX942-NEXT:    v_mov_b32_e32 v29, v15
; GFX942-NEXT:    global_store_dwordx4 v32, v[26:29], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v32, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, v14
; GFX90A-NEXT:    v_mov_b32_e32 v31, v15
; GFX90A-NEXT:    global_store_dwordx4 v32, v[28:31], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v32, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v30, v14
; GFX942-NEXT:    v_mov_b32_e32 v31, v15
; GFX942-NEXT:    global_store_dwordx4 v32, v[28:31], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_8(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v8i64__u_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v14
; GFX900-NEXT:    v_mov_b32_e32 v1, v15
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    global_store_dwordx4 v2, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v14
; GFX90A-NEXT:    v_mov_b32_e32 v1, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v14
; GFX942-NEXT:    v_mov_b32_e32 v1, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_8(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v8i64__8_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v0
; GFX942-NEXT:    v_mov_b32_e32 v5, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v0
; GFX942-NEXT:    v_mov_b32_e32 v7, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v0
; GFX900-NEXT:    v_mov_b32_e32 v9, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v0
; GFX942-NEXT:    v_mov_b32_e32 v9, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v0
; GFX900-NEXT:    v_mov_b32_e32 v11, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v0
; GFX90A-NEXT:    v_mov_b32_e32 v11, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v0
; GFX942-NEXT:    v_mov_b32_e32 v11, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v0
; GFX900-NEXT:    v_mov_b32_e32 v13, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v0
; GFX90A-NEXT:    v_mov_b32_e32 v13, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v0
; GFX942-NEXT:    v_mov_b32_e32 v13, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_8(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v0
; GFX900-NEXT:    v_mov_b32_e32 v15, v1
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v0
; GFX90A-NEXT:    v_mov_b32_e32 v15, v1
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v0
; GFX942-NEXT:    v_mov_b32_e32 v15, v1
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 8>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v20, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v6
; GFX942-NEXT:    v_mov_b32_e32 v5, v7
; GFX942-NEXT:    global_store_dwordx4 v20, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v8
; GFX900-NEXT:    v_mov_b32_e32 v7, v9
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v8
; GFX90A-NEXT:    v_mov_b32_e32 v7, v9
; GFX90A-NEXT:    global_store_dwordx4 v22, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v8
; GFX942-NEXT:    v_mov_b32_e32 v7, v9
; GFX942-NEXT:    global_store_dwordx4 v22, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v10
; GFX900-NEXT:    v_mov_b32_e32 v9, v11
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v10
; GFX90A-NEXT:    v_mov_b32_e32 v9, v11
; GFX90A-NEXT:    global_store_dwordx4 v24, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v10
; GFX942-NEXT:    v_mov_b32_e32 v9, v11
; GFX942-NEXT:    global_store_dwordx4 v24, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v12
; GFX900-NEXT:    v_mov_b32_e32 v11, v13
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v12
; GFX90A-NEXT:    v_mov_b32_e32 v11, v13
; GFX90A-NEXT:    global_store_dwordx4 v26, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v12
; GFX942-NEXT:    v_mov_b32_e32 v11, v13
; GFX942-NEXT:    global_store_dwordx4 v26, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v14
; GFX900-NEXT:    v_mov_b32_e32 v13, v15
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v14
; GFX90A-NEXT:    v_mov_b32_e32 v13, v15
; GFX90A-NEXT:    global_store_dwordx4 v28, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v14
; GFX942-NEXT:    v_mov_b32_e32 v13, v15
; GFX942-NEXT:    global_store_dwordx4 v28, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v16
; GFX900-NEXT:    v_mov_b32_e32 v15, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v16
; GFX90A-NEXT:    v_mov_b32_e32 v15, v17
; GFX90A-NEXT:    global_store_dwordx4 v30, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v16
; GFX942-NEXT:    v_mov_b32_e32 v15, v17
; GFX942-NEXT:    global_store_dwordx4 v30, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v16
; GFX900-NEXT:    v_mov_b32_e32 v1, v17
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v16
; GFX90A-NEXT:    v_mov_b32_e32 v1, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v16
; GFX942-NEXT:    v_mov_b32_e32 v1, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v2
; GFX900-NEXT:    v_mov_b32_e32 v5, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v2
; GFX942-NEXT:    v_mov_b32_e32 v5, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v2
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v2
; GFX942-NEXT:    v_mov_b32_e32 v7, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v2
; GFX900-NEXT:    v_mov_b32_e32 v9, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v2
; GFX90A-NEXT:    v_mov_b32_e32 v9, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v2
; GFX942-NEXT:    v_mov_b32_e32 v9, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v2
; GFX900-NEXT:    v_mov_b32_e32 v11, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v2
; GFX90A-NEXT:    v_mov_b32_e32 v11, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v2
; GFX942-NEXT:    v_mov_b32_e32 v11, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v2
; GFX900-NEXT:    v_mov_b32_e32 v13, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v2
; GFX90A-NEXT:    v_mov_b32_e32 v13, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v2
; GFX942-NEXT:    v_mov_b32_e32 v13, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_9(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v2
; GFX900-NEXT:    v_mov_b32_e32 v15, v3
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v2
; GFX90A-NEXT:    v_mov_b32_e32 v15, v3
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v2
; GFX942-NEXT:    v_mov_b32_e32 v15, v3
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 9>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v7
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v8
; GFX900-NEXT:    v_mov_b32_e32 v5, v9
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v8
; GFX90A-NEXT:    v_mov_b32_e32 v5, v9
; GFX90A-NEXT:    global_store_dwordx4 v20, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v8
; GFX942-NEXT:    v_mov_b32_e32 v5, v9
; GFX942-NEXT:    global_store_dwordx4 v20, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v10
; GFX900-NEXT:    v_mov_b32_e32 v7, v11
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v10
; GFX90A-NEXT:    v_mov_b32_e32 v7, v11
; GFX90A-NEXT:    global_store_dwordx4 v22, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v10
; GFX942-NEXT:    v_mov_b32_e32 v7, v11
; GFX942-NEXT:    global_store_dwordx4 v22, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v12
; GFX900-NEXT:    v_mov_b32_e32 v9, v13
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v12
; GFX90A-NEXT:    v_mov_b32_e32 v9, v13
; GFX90A-NEXT:    global_store_dwordx4 v24, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v12
; GFX942-NEXT:    v_mov_b32_e32 v9, v13
; GFX942-NEXT:    global_store_dwordx4 v24, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v14
; GFX900-NEXT:    v_mov_b32_e32 v11, v15
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v14
; GFX90A-NEXT:    v_mov_b32_e32 v11, v15
; GFX90A-NEXT:    global_store_dwordx4 v26, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v14
; GFX942-NEXT:    v_mov_b32_e32 v11, v15
; GFX942-NEXT:    global_store_dwordx4 v26, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v16
; GFX90A-NEXT:    v_mov_b32_e32 v13, v17
; GFX90A-NEXT:    global_store_dwordx4 v28, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v16
; GFX942-NEXT:    v_mov_b32_e32 v13, v17
; GFX942-NEXT:    global_store_dwordx4 v28, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v18
; GFX900-NEXT:    v_mov_b32_e32 v15, v19
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v18
; GFX90A-NEXT:    v_mov_b32_e32 v15, v19
; GFX90A-NEXT:    global_store_dwordx4 v30, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v18
; GFX942-NEXT:    v_mov_b32_e32 v15, v19
; GFX942-NEXT:    global_store_dwordx4 v30, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v16
; GFX900-NEXT:    v_mov_b32_e32 v3, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v16
; GFX90A-NEXT:    v_mov_b32_e32 v3, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v16
; GFX942-NEXT:    v_mov_b32_e32 v3, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v4
; GFX900-NEXT:    v_mov_b32_e32 v7, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v4
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v4
; GFX942-NEXT:    v_mov_b32_e32 v7, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v4
; GFX900-NEXT:    v_mov_b32_e32 v9, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v4
; GFX90A-NEXT:    v_mov_b32_e32 v9, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v4
; GFX942-NEXT:    v_mov_b32_e32 v9, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v4
; GFX900-NEXT:    v_mov_b32_e32 v11, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v4
; GFX90A-NEXT:    v_mov_b32_e32 v11, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v4
; GFX942-NEXT:    v_mov_b32_e32 v11, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v4
; GFX900-NEXT:    v_mov_b32_e32 v13, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v4
; GFX90A-NEXT:    v_mov_b32_e32 v13, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v4
; GFX942-NEXT:    v_mov_b32_e32 v13, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_10(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v4
; GFX900-NEXT:    v_mov_b32_e32 v15, v5
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v4
; GFX90A-NEXT:    v_mov_b32_e32 v15, v5
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v4
; GFX942-NEXT:    v_mov_b32_e32 v15, v5
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 10>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v8
; GFX900-NEXT:    v_mov_b32_e32 v3, v9
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v8
; GFX90A-NEXT:    v_mov_b32_e32 v3, v9
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v8
; GFX942-NEXT:    v_mov_b32_e32 v3, v9
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v10
; GFX900-NEXT:    v_mov_b32_e32 v5, v11
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v10
; GFX90A-NEXT:    v_mov_b32_e32 v5, v11
; GFX90A-NEXT:    global_store_dwordx4 v20, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v10
; GFX942-NEXT:    v_mov_b32_e32 v5, v11
; GFX942-NEXT:    global_store_dwordx4 v20, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v12
; GFX900-NEXT:    v_mov_b32_e32 v7, v13
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v12
; GFX90A-NEXT:    v_mov_b32_e32 v7, v13
; GFX90A-NEXT:    global_store_dwordx4 v22, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v12
; GFX942-NEXT:    v_mov_b32_e32 v7, v13
; GFX942-NEXT:    global_store_dwordx4 v22, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v14
; GFX900-NEXT:    v_mov_b32_e32 v9, v15
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v14
; GFX90A-NEXT:    v_mov_b32_e32 v9, v15
; GFX90A-NEXT:    global_store_dwordx4 v24, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v14
; GFX942-NEXT:    v_mov_b32_e32 v9, v15
; GFX942-NEXT:    global_store_dwordx4 v24, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v16
; GFX90A-NEXT:    v_mov_b32_e32 v11, v17
; GFX90A-NEXT:    global_store_dwordx4 v26, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v16
; GFX942-NEXT:    v_mov_b32_e32 v11, v17
; GFX942-NEXT:    global_store_dwordx4 v26, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v18
; GFX900-NEXT:    v_mov_b32_e32 v13, v19
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v18
; GFX90A-NEXT:    v_mov_b32_e32 v13, v19
; GFX90A-NEXT:    global_store_dwordx4 v28, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v18
; GFX942-NEXT:    v_mov_b32_e32 v13, v19
; GFX942-NEXT:    global_store_dwordx4 v28, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v20
; GFX900-NEXT:    v_mov_b32_e32 v15, v21
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v20
; GFX90A-NEXT:    v_mov_b32_e32 v15, v21
; GFX90A-NEXT:    global_store_dwordx4 v30, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v20
; GFX942-NEXT:    v_mov_b32_e32 v15, v21
; GFX942-NEXT:    global_store_dwordx4 v30, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v16
; GFX90A-NEXT:    v_mov_b32_e32 v5, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v16
; GFX942-NEXT:    v_mov_b32_e32 v5, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v6
; GFX942-NEXT:    v_mov_b32_e32 v5, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v6
; GFX900-NEXT:    v_mov_b32_e32 v9, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v6
; GFX90A-NEXT:    v_mov_b32_e32 v9, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v6
; GFX942-NEXT:    v_mov_b32_e32 v9, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v6
; GFX900-NEXT:    v_mov_b32_e32 v11, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v6
; GFX90A-NEXT:    v_mov_b32_e32 v11, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v6
; GFX942-NEXT:    v_mov_b32_e32 v11, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v6
; GFX900-NEXT:    v_mov_b32_e32 v13, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v6
; GFX90A-NEXT:    v_mov_b32_e32 v13, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v6
; GFX942-NEXT:    v_mov_b32_e32 v13, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_11(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v6
; GFX900-NEXT:    v_mov_b32_e32 v15, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v6
; GFX90A-NEXT:    v_mov_b32_e32 v15, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v6
; GFX942-NEXT:    v_mov_b32_e32 v15, v7
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 11>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v10
; GFX900-NEXT:    v_mov_b32_e32 v3, v11
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v10
; GFX90A-NEXT:    v_mov_b32_e32 v3, v11
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v10
; GFX942-NEXT:    v_mov_b32_e32 v3, v11
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v12
; GFX900-NEXT:    v_mov_b32_e32 v5, v13
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v12
; GFX90A-NEXT:    v_mov_b32_e32 v5, v13
; GFX90A-NEXT:    global_store_dwordx4 v20, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v12
; GFX942-NEXT:    v_mov_b32_e32 v5, v13
; GFX942-NEXT:    global_store_dwordx4 v20, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v14
; GFX900-NEXT:    v_mov_b32_e32 v7, v15
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v14
; GFX90A-NEXT:    v_mov_b32_e32 v7, v15
; GFX90A-NEXT:    global_store_dwordx4 v22, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v14
; GFX942-NEXT:    v_mov_b32_e32 v7, v15
; GFX942-NEXT:    global_store_dwordx4 v22, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v16
; GFX90A-NEXT:    v_mov_b32_e32 v9, v17
; GFX90A-NEXT:    global_store_dwordx4 v24, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v16
; GFX942-NEXT:    v_mov_b32_e32 v9, v17
; GFX942-NEXT:    global_store_dwordx4 v24, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v18
; GFX900-NEXT:    v_mov_b32_e32 v11, v19
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v18
; GFX90A-NEXT:    v_mov_b32_e32 v11, v19
; GFX90A-NEXT:    global_store_dwordx4 v26, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v18
; GFX942-NEXT:    v_mov_b32_e32 v11, v19
; GFX942-NEXT:    global_store_dwordx4 v26, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v20
; GFX900-NEXT:    v_mov_b32_e32 v13, v21
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v20
; GFX90A-NEXT:    v_mov_b32_e32 v13, v21
; GFX90A-NEXT:    global_store_dwordx4 v28, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v20
; GFX942-NEXT:    v_mov_b32_e32 v13, v21
; GFX942-NEXT:    global_store_dwordx4 v28, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v22
; GFX900-NEXT:    v_mov_b32_e32 v15, v23
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v22
; GFX90A-NEXT:    v_mov_b32_e32 v15, v23
; GFX90A-NEXT:    global_store_dwordx4 v30, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v22
; GFX942-NEXT:    v_mov_b32_e32 v15, v23
; GFX942-NEXT:    global_store_dwordx4 v30, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v16
; GFX90A-NEXT:    v_mov_b32_e32 v7, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v16
; GFX942-NEXT:    v_mov_b32_e32 v7, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v8
; GFX900-NEXT:    v_mov_b32_e32 v3, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v8
; GFX90A-NEXT:    v_mov_b32_e32 v3, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v8
; GFX942-NEXT:    v_mov_b32_e32 v3, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v8
; GFX900-NEXT:    v_mov_b32_e32 v5, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v8
; GFX90A-NEXT:    v_mov_b32_e32 v5, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v8
; GFX942-NEXT:    v_mov_b32_e32 v5, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v8
; GFX900-NEXT:    v_mov_b32_e32 v7, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v8
; GFX90A-NEXT:    v_mov_b32_e32 v7, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v8
; GFX942-NEXT:    v_mov_b32_e32 v7, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v8
; GFX900-NEXT:    v_mov_b32_e32 v11, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v8
; GFX90A-NEXT:    v_mov_b32_e32 v11, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v8
; GFX942-NEXT:    v_mov_b32_e32 v11, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v8
; GFX900-NEXT:    v_mov_b32_e32 v13, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v8
; GFX90A-NEXT:    v_mov_b32_e32 v13, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v8
; GFX942-NEXT:    v_mov_b32_e32 v13, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_12(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v8
; GFX900-NEXT:    v_mov_b32_e32 v15, v9
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v8
; GFX90A-NEXT:    v_mov_b32_e32 v15, v9
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v8
; GFX942-NEXT:    v_mov_b32_e32 v15, v9
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 12>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v12
; GFX900-NEXT:    v_mov_b32_e32 v3, v13
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v12
; GFX90A-NEXT:    v_mov_b32_e32 v3, v13
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v12
; GFX942-NEXT:    v_mov_b32_e32 v3, v13
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v14
; GFX900-NEXT:    v_mov_b32_e32 v5, v15
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v14
; GFX90A-NEXT:    v_mov_b32_e32 v5, v15
; GFX90A-NEXT:    global_store_dwordx4 v20, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v14
; GFX942-NEXT:    v_mov_b32_e32 v5, v15
; GFX942-NEXT:    global_store_dwordx4 v20, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v16
; GFX900-NEXT:    v_mov_b32_e32 v7, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v16
; GFX90A-NEXT:    v_mov_b32_e32 v7, v17
; GFX90A-NEXT:    global_store_dwordx4 v22, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v16
; GFX942-NEXT:    v_mov_b32_e32 v7, v17
; GFX942-NEXT:    global_store_dwordx4 v22, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v18
; GFX900-NEXT:    v_mov_b32_e32 v9, v19
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v18
; GFX90A-NEXT:    v_mov_b32_e32 v9, v19
; GFX90A-NEXT:    global_store_dwordx4 v24, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v18
; GFX942-NEXT:    v_mov_b32_e32 v9, v19
; GFX942-NEXT:    global_store_dwordx4 v24, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v20
; GFX900-NEXT:    v_mov_b32_e32 v11, v21
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v20
; GFX90A-NEXT:    v_mov_b32_e32 v11, v21
; GFX90A-NEXT:    global_store_dwordx4 v26, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v20
; GFX942-NEXT:    v_mov_b32_e32 v11, v21
; GFX942-NEXT:    global_store_dwordx4 v26, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v22
; GFX900-NEXT:    v_mov_b32_e32 v13, v23
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v22
; GFX90A-NEXT:    v_mov_b32_e32 v13, v23
; GFX90A-NEXT:    global_store_dwordx4 v28, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v22
; GFX942-NEXT:    v_mov_b32_e32 v13, v23
; GFX942-NEXT:    global_store_dwordx4 v28, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v24
; GFX900-NEXT:    v_mov_b32_e32 v15, v25
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v24
; GFX90A-NEXT:    v_mov_b32_e32 v15, v25
; GFX90A-NEXT:    global_store_dwordx4 v30, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v24
; GFX942-NEXT:    v_mov_b32_e32 v15, v25
; GFX942-NEXT:    global_store_dwordx4 v30, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v16
; GFX900-NEXT:    v_mov_b32_e32 v9, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v16
; GFX90A-NEXT:    v_mov_b32_e32 v9, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v16
; GFX942-NEXT:    v_mov_b32_e32 v9, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v10
; GFX900-NEXT:    v_mov_b32_e32 v3, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v10
; GFX90A-NEXT:    v_mov_b32_e32 v3, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v10
; GFX942-NEXT:    v_mov_b32_e32 v3, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v10
; GFX900-NEXT:    v_mov_b32_e32 v5, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v10
; GFX90A-NEXT:    v_mov_b32_e32 v5, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v10
; GFX942-NEXT:    v_mov_b32_e32 v5, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v10
; GFX900-NEXT:    v_mov_b32_e32 v7, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v10
; GFX90A-NEXT:    v_mov_b32_e32 v7, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v10
; GFX942-NEXT:    v_mov_b32_e32 v7, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v10
; GFX900-NEXT:    v_mov_b32_e32 v9, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v10
; GFX90A-NEXT:    v_mov_b32_e32 v9, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v10
; GFX942-NEXT:    v_mov_b32_e32 v9, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v10
; GFX900-NEXT:    v_mov_b32_e32 v13, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v10
; GFX90A-NEXT:    v_mov_b32_e32 v13, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v10
; GFX942-NEXT:    v_mov_b32_e32 v13, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_13(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v10
; GFX900-NEXT:    v_mov_b32_e32 v15, v11
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v10
; GFX90A-NEXT:    v_mov_b32_e32 v15, v11
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v10
; GFX942-NEXT:    v_mov_b32_e32 v15, v11
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 13>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v14
; GFX900-NEXT:    v_mov_b32_e32 v3, v15
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v14
; GFX90A-NEXT:    v_mov_b32_e32 v3, v15
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v14
; GFX942-NEXT:    v_mov_b32_e32 v3, v15
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v16
; GFX900-NEXT:    v_mov_b32_e32 v5, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v16
; GFX90A-NEXT:    v_mov_b32_e32 v5, v17
; GFX90A-NEXT:    global_store_dwordx4 v20, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v16
; GFX942-NEXT:    v_mov_b32_e32 v5, v17
; GFX942-NEXT:    global_store_dwordx4 v20, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v18
; GFX900-NEXT:    v_mov_b32_e32 v7, v19
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v18
; GFX90A-NEXT:    v_mov_b32_e32 v7, v19
; GFX90A-NEXT:    global_store_dwordx4 v22, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v18
; GFX942-NEXT:    v_mov_b32_e32 v7, v19
; GFX942-NEXT:    global_store_dwordx4 v22, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v20
; GFX900-NEXT:    v_mov_b32_e32 v9, v21
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v20
; GFX90A-NEXT:    v_mov_b32_e32 v9, v21
; GFX90A-NEXT:    global_store_dwordx4 v24, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v20
; GFX942-NEXT:    v_mov_b32_e32 v9, v21
; GFX942-NEXT:    global_store_dwordx4 v24, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v22
; GFX900-NEXT:    v_mov_b32_e32 v11, v23
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v22
; GFX90A-NEXT:    v_mov_b32_e32 v11, v23
; GFX90A-NEXT:    global_store_dwordx4 v26, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v22
; GFX942-NEXT:    v_mov_b32_e32 v11, v23
; GFX942-NEXT:    global_store_dwordx4 v26, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v24
; GFX900-NEXT:    v_mov_b32_e32 v13, v25
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v24
; GFX90A-NEXT:    v_mov_b32_e32 v13, v25
; GFX90A-NEXT:    global_store_dwordx4 v28, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v24
; GFX942-NEXT:    v_mov_b32_e32 v13, v25
; GFX942-NEXT:    global_store_dwordx4 v28, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v26
; GFX900-NEXT:    v_mov_b32_e32 v15, v27
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v26
; GFX90A-NEXT:    v_mov_b32_e32 v15, v27
; GFX90A-NEXT:    global_store_dwordx4 v30, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v26
; GFX942-NEXT:    v_mov_b32_e32 v15, v27
; GFX942-NEXT:    global_store_dwordx4 v30, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v16
; GFX900-NEXT:    v_mov_b32_e32 v11, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v16
; GFX90A-NEXT:    v_mov_b32_e32 v11, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v16
; GFX942-NEXT:    v_mov_b32_e32 v11, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v12
; GFX900-NEXT:    v_mov_b32_e32 v3, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v12
; GFX90A-NEXT:    v_mov_b32_e32 v3, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v12
; GFX942-NEXT:    v_mov_b32_e32 v3, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v12
; GFX900-NEXT:    v_mov_b32_e32 v5, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v12
; GFX90A-NEXT:    v_mov_b32_e32 v5, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v12
; GFX942-NEXT:    v_mov_b32_e32 v5, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v12
; GFX900-NEXT:    v_mov_b32_e32 v7, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v12
; GFX90A-NEXT:    v_mov_b32_e32 v7, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v12
; GFX942-NEXT:    v_mov_b32_e32 v7, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v12
; GFX900-NEXT:    v_mov_b32_e32 v9, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v12
; GFX90A-NEXT:    v_mov_b32_e32 v9, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v12
; GFX942-NEXT:    v_mov_b32_e32 v9, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v12
; GFX900-NEXT:    v_mov_b32_e32 v11, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v12
; GFX90A-NEXT:    v_mov_b32_e32 v11, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v12
; GFX942-NEXT:    v_mov_b32_e32 v11, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_14(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v14, v12
; GFX900-NEXT:    v_mov_b32_e32 v15, v13
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v12
; GFX90A-NEXT:    v_mov_b32_e32 v15, v13
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v12
; GFX942-NEXT:    v_mov_b32_e32 v15, v13
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 14>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__u_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__u_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__u_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__u_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__0_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__0_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v16
; GFX900-NEXT:    v_mov_b32_e32 v3, v17
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__0_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v16
; GFX90A-NEXT:    v_mov_b32_e32 v3, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__0_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v16
; GFX942-NEXT:    v_mov_b32_e32 v3, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__1_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__1_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v18
; GFX900-NEXT:    v_mov_b32_e32 v5, v19
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__1_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v20, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v18
; GFX90A-NEXT:    v_mov_b32_e32 v5, v19
; GFX90A-NEXT:    global_store_dwordx4 v20, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__1_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v20, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v18
; GFX942-NEXT:    v_mov_b32_e32 v5, v19
; GFX942-NEXT:    global_store_dwordx4 v20, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__2_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__2_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:21]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v20
; GFX900-NEXT:    v_mov_b32_e32 v7, v21
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__2_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:21]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v22, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v20
; GFX90A-NEXT:    v_mov_b32_e32 v7, v21
; GFX90A-NEXT:    global_store_dwordx4 v22, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__2_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v22, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:21]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v20
; GFX942-NEXT:    v_mov_b32_e32 v7, v21
; GFX942-NEXT:    global_store_dwordx4 v22, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__3_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__3_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v22
; GFX900-NEXT:    v_mov_b32_e32 v9, v23
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__3_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v24, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v22
; GFX90A-NEXT:    v_mov_b32_e32 v9, v23
; GFX90A-NEXT:    global_store_dwordx4 v24, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__3_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v24, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v22
; GFX942-NEXT:    v_mov_b32_e32 v9, v23
; GFX942-NEXT:    global_store_dwordx4 v24, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__4_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__4_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[10:25]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v24
; GFX900-NEXT:    v_mov_b32_e32 v11, v25
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__4_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[10:25]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v26, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v24
; GFX90A-NEXT:    v_mov_b32_e32 v11, v25
; GFX90A-NEXT:    global_store_dwordx4 v26, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__4_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v26, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[10:25]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v24
; GFX942-NEXT:    v_mov_b32_e32 v11, v25
; GFX942-NEXT:    global_store_dwordx4 v26, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__5_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__5_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v26
; GFX900-NEXT:    v_mov_b32_e32 v13, v27
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__5_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v28, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v26
; GFX90A-NEXT:    v_mov_b32_e32 v13, v27
; GFX90A-NEXT:    global_store_dwordx4 v28, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__5_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v28, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v26
; GFX942-NEXT:    v_mov_b32_e32 v13, v27
; GFX942-NEXT:    global_store_dwordx4 v28, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__6_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__6_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[14:29]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v28
; GFX900-NEXT:    v_mov_b32_e32 v15, v29
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__6_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[14:29]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v30, 0
; GFX90A-NEXT:    v_mov_b32_e32 v14, v28
; GFX90A-NEXT:    v_mov_b32_e32 v15, v29
; GFX90A-NEXT:    global_store_dwordx4 v30, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__6_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[14:29]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v14, v28
; GFX942-NEXT:    v_mov_b32_e32 v15, v29
; GFX942-NEXT:    global_store_dwordx4 v30, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__7_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__7_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:17]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v16
; GFX900-NEXT:    v_mov_b32_e32 v13, v17
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    global_store_dwordx4 v0, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__7_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:17]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v18, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v16
; GFX90A-NEXT:    v_mov_b32_e32 v13, v17
; GFX90A-NEXT:    global_store_dwordx4 v18, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__7_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:17]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v16
; GFX942-NEXT:    v_mov_b32_e32 v13, v17
; GFX942-NEXT:    global_store_dwordx4 v18, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__8_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__8_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v14
; GFX900-NEXT:    v_mov_b32_e32 v3, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__8_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v14
; GFX90A-NEXT:    v_mov_b32_e32 v3, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__8_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v14
; GFX942-NEXT:    v_mov_b32_e32 v3, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__9_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__9_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v14
; GFX900-NEXT:    v_mov_b32_e32 v5, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__9_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v14
; GFX90A-NEXT:    v_mov_b32_e32 v5, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__9_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v4, v14
; GFX942-NEXT:    v_mov_b32_e32 v5, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[2:5], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__10_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__10_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v14
; GFX900-NEXT:    v_mov_b32_e32 v7, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__10_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v14
; GFX90A-NEXT:    v_mov_b32_e32 v7, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__10_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, v14
; GFX942-NEXT:    v_mov_b32_e32 v7, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__11_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__11_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v14
; GFX900-NEXT:    v_mov_b32_e32 v9, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__11_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v14
; GFX90A-NEXT:    v_mov_b32_e32 v9, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__11_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v8, v14
; GFX942-NEXT:    v_mov_b32_e32 v9, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[6:9], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__12_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__12_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v14
; GFX900-NEXT:    v_mov_b32_e32 v11, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__12_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v14
; GFX90A-NEXT:    v_mov_b32_e32 v11, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__12_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, v14
; GFX942-NEXT:    v_mov_b32_e32 v11, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__13_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__13_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v14
; GFX900-NEXT:    v_mov_b32_e32 v13, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__13_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v14
; GFX90A-NEXT:    v_mov_b32_e32 v13, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__13_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v12, v14
; GFX942-NEXT:    v_mov_b32_e32 v13, v15
; GFX942-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v8i64__14_15(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v8i64__14_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v8i64__14_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v2i64_v8i64__14_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=v"()
  %vec1 = call <8 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 15>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_u() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> poison
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_u() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__8_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_u() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s26
; GFX900-NEXT:    s_mov_b32 s9, s27
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s26
; GFX90A-NEXT:    s_mov_b32 s9, s27
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s26
; GFX942-NEXT:    s_mov_b32 s9, s27
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s30
; GFX900-NEXT:    s_mov_b32 s9, s31
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s30
; GFX90A-NEXT:    s_mov_b32 s9, s31
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s26
; GFX900-NEXT:    s_mov_b32 s9, s27
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s26
; GFX90A-NEXT:    s_mov_b32 s9, s27
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s26
; GFX942-NEXT:    s_mov_b32 s9, s27
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s30
; GFX900-NEXT:    s_mov_b32 s9, s31
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s30
; GFX90A-NEXT:    s_mov_b32 s9, s31
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s30
; GFX942-NEXT:    s_mov_b32 s9, s31
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s30
; GFX900-NEXT:    s_mov_b32 s13, s31
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s30
; GFX90A-NEXT:    s_mov_b32 s13, s31
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s26
; GFX942-NEXT:    s_mov_b32 s9, s27
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s50
; GFX900-NEXT:    s_mov_b32 s9, s51
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s50
; GFX90A-NEXT:    s_mov_b32 s9, s51
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s30
; GFX942-NEXT:    s_mov_b32 s9, s31
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s50
; GFX900-NEXT:    s_mov_b32 s17, s51
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s50
; GFX90A-NEXT:    s_mov_b32 s17, s51
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s30
; GFX942-NEXT:    s_mov_b32 s13, s31
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_9() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__15_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s22
; GFX9-NEXT:    s_mov_b32 s9, s23
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_11() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__15_11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s18
; GFX9-NEXT:    s_mov_b32 s9, s19
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_12() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__15_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s18
; GFX9-NEXT:    s_mov_b32 s9, s19
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s18
; GFX900-NEXT:    s_mov_b32 s13, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s18
; GFX90A-NEXT:    s_mov_b32 s13, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 13>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_14() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_14:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_14:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_14:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 14>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__15_15() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__15_15:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s18
; GFX900-NEXT:    s_mov_b32 s17, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__15_15:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s18
; GFX90A-NEXT:    s_mov_b32 s17, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__15_15:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s14
; GFX942-NEXT:    s_mov_b32 s13, s15
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 15, i32 15>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_0() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__0_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_0() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__2_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s4
; GFX9-NEXT:    s_mov_b32 s11, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s4
; GFX900-NEXT:    s_mov_b32 s15, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s4
; GFX90A-NEXT:    s_mov_b32 s15, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s4
; GFX900-NEXT:    s_mov_b32 s19, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s4
; GFX90A-NEXT:    s_mov_b32 s19, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s0
; GFX942-NEXT:    s_mov_b32 s15, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s36
; GFX900-NEXT:    s_mov_b32 s11, s37
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s36
; GFX90A-NEXT:    s_mov_b32 s11, s37
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s4
; GFX900-NEXT:    s_mov_b32 s19, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s4
; GFX90A-NEXT:    s_mov_b32 s19, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_0() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s22, s4
; GFX900-NEXT:    s_mov_b32 s23, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s22, s4
; GFX90A-NEXT:    s_mov_b32 s23, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s18, s0
; GFX942-NEXT:    s_mov_b32 s19, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_1() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_1() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__2_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_1() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__3_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s6
; GFX900-NEXT:    s_mov_b32 s15, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s6
; GFX90A-NEXT:    s_mov_b32 s15, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_1() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__5_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s18
; GFX9-NEXT:    s_mov_b32 s9, s19
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s6
; GFX900-NEXT:    s_mov_b32 s19, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s6
; GFX90A-NEXT:    s_mov_b32 s19, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s2
; GFX942-NEXT:    s_mov_b32 s15, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_1() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__7_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s22
; GFX9-NEXT:    s_mov_b32 s9, s23
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s38
; GFX900-NEXT:    s_mov_b32 s11, s39
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s38
; GFX90A-NEXT:    s_mov_b32 s11, s39
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s6
; GFX900-NEXT:    s_mov_b32 s19, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s6
; GFX90A-NEXT:    s_mov_b32 s19, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s18
; GFX942-NEXT:    s_mov_b32 s11, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_1() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s22, s6
; GFX900-NEXT:    s_mov_b32 s23, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s22, s6
; GFX90A-NEXT:    s_mov_b32 s23, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s18, s2
; GFX942-NEXT:    s_mov_b32 s19, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s8
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s8
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_2() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__0_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_2() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s8
; GFX900-NEXT:    s_mov_b32 s15, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s8
; GFX90A-NEXT:    s_mov_b32 s15, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s8
; GFX900-NEXT:    s_mov_b32 s19, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s8
; GFX90A-NEXT:    s_mov_b32 s19, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s4
; GFX942-NEXT:    s_mov_b32 s15, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s8
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s8
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s20
; GFX900-NEXT:    s_mov_b32 s11, s21
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s20
; GFX90A-NEXT:    s_mov_b32 s11, s21
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s22, s8
; GFX900-NEXT:    s_mov_b32 s23, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s22, s8
; GFX90A-NEXT:    s_mov_b32 s23, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s26
; GFX900-NEXT:    s_mov_b32 s9, s27
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s26
; GFX90A-NEXT:    s_mov_b32 s9, s27
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_2() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s26, s8
; GFX900-NEXT:    s_mov_b32 s27, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s26, s8
; GFX90A-NEXT:    s_mov_b32 s27, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s22, s4
; GFX942-NEXT:    s_mov_b32 s23, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_3() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__0_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s14
; GFX9-NEXT:    s_mov_b32 s11, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_3() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__1_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s6
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_3() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s10
; GFX900-NEXT:    s_mov_b32 s15, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s10
; GFX90A-NEXT:    s_mov_b32 s15, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s6
; GFX942-NEXT:    s_mov_b32 s11, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_3() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__5_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s10
; GFX900-NEXT:    s_mov_b32 s19, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s10
; GFX90A-NEXT:    s_mov_b32 s19, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s6
; GFX942-NEXT:    s_mov_b32 s15, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_3() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__7_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s18
; GFX9-NEXT:    s_mov_b32 s9, s19
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s22
; GFX900-NEXT:    s_mov_b32 s11, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s22
; GFX90A-NEXT:    s_mov_b32 s11, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s22
; GFX942-NEXT:    s_mov_b32 s11, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s22, s10
; GFX900-NEXT:    s_mov_b32 s23, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s22, s10
; GFX90A-NEXT:    s_mov_b32 s23, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s18
; GFX942-NEXT:    s_mov_b32 s11, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_3() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s26, s10
; GFX900-NEXT:    s_mov_b32 s27, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s26, s10
; GFX90A-NEXT:    s_mov_b32 s27, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s22, s6
; GFX942-NEXT:    s_mov_b32 s23, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s8
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_4() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__0_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s16
; GFX9-NEXT:    s_mov_b32 s11, s17
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_4() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__1_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s6
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_4() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__2_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_4() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__3_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s12
; GFX900-NEXT:    s_mov_b32 s15, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s12
; GFX90A-NEXT:    s_mov_b32 s15, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s8
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_4() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__5_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s12
; GFX900-NEXT:    s_mov_b32 s19, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s12
; GFX90A-NEXT:    s_mov_b32 s19, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s8
; GFX942-NEXT:    s_mov_b32 s15, s9
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_4() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__7_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s18
; GFX9-NEXT:    s_mov_b32 s9, s19
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s8
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s20
; GFX900-NEXT:    s_mov_b32 s11, s21
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s20
; GFX90A-NEXT:    s_mov_b32 s11, s21
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s26, s12
; GFX900-NEXT:    s_mov_b32 s27, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s26, s12
; GFX90A-NEXT:    s_mov_b32 s27, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s26
; GFX900-NEXT:    s_mov_b32 s9, s27
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s26
; GFX90A-NEXT:    s_mov_b32 s9, s27
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s26
; GFX942-NEXT:    s_mov_b32 s9, s27
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_4() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s30, s12
; GFX900-NEXT:    s_mov_b32 s31, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[28:29]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[30:31]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s30, s12
; GFX90A-NEXT:    s_mov_b32 s31, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[28:29]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[30:31]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s26, s8
; GFX942-NEXT:    s_mov_b32 s27, s9
; GFX942-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_5() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__0_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s18
; GFX9-NEXT:    s_mov_b32 s11, s19
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s6
; GFX900-NEXT:    s_mov_b32 s13, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s6
; GFX90A-NEXT:    s_mov_b32 s13, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_5() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__2_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s14
; GFX9-NEXT:    s_mov_b32 s11, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s10
; GFX900-NEXT:    s_mov_b32 s13, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s10
; GFX90A-NEXT:    s_mov_b32 s13, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s14
; GFX900-NEXT:    s_mov_b32 s13, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s14
; GFX90A-NEXT:    s_mov_b32 s13, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s14
; GFX900-NEXT:    s_mov_b32 s19, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s14
; GFX90A-NEXT:    s_mov_b32 s19, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s10
; GFX942-NEXT:    s_mov_b32 s15, s11
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s18
; GFX900-NEXT:    s_mov_b32 s13, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s18
; GFX90A-NEXT:    s_mov_b32 s13, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s18
; GFX900-NEXT:    s_mov_b32 s13, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s18
; GFX90A-NEXT:    s_mov_b32 s13, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s22
; GFX900-NEXT:    s_mov_b32 s11, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s22
; GFX90A-NEXT:    s_mov_b32 s11, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s22
; GFX942-NEXT:    s_mov_b32 s11, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s22
; GFX900-NEXT:    s_mov_b32 s13, s23
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s22
; GFX90A-NEXT:    s_mov_b32 s13, s23
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s26, s14
; GFX900-NEXT:    s_mov_b32 s27, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s26, s14
; GFX90A-NEXT:    s_mov_b32 s27, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s18
; GFX942-NEXT:    s_mov_b32 s11, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s12, s26
; GFX900-NEXT:    s_mov_b32 s13, s27
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s12, s26
; GFX90A-NEXT:    s_mov_b32 s13, s27
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_5() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s30, s14
; GFX900-NEXT:    s_mov_b32 s31, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[28:29]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[30:31]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s30, s14
; GFX90A-NEXT:    s_mov_b32 s31, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[28:29]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[30:31]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s26, s10
; GFX942-NEXT:    s_mov_b32 s27, s11
; GFX942-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[26:27]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_6() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__0_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s20
; GFX9-NEXT:    s_mov_b32 s11, s21
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_6() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__2_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s16
; GFX9-NEXT:    s_mov_b32 s11, s17
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s16
; GFX900-NEXT:    s_mov_b32 s15, s17
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s16
; GFX90A-NEXT:    s_mov_b32 s15, s17
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s16
; GFX900-NEXT:    s_mov_b32 s19, s17
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s16
; GFX90A-NEXT:    s_mov_b32 s19, s17
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s12
; GFX942-NEXT:    s_mov_b32 s15, s13
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s38
; GFX900-NEXT:    s_mov_b32 s9, s39
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s38
; GFX90A-NEXT:    s_mov_b32 s9, s39
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s20
; GFX900-NEXT:    s_mov_b32 s11, s21
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s20
; GFX90A-NEXT:    s_mov_b32 s11, s21
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s42
; GFX900-NEXT:    s_mov_b32 s9, s43
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s42
; GFX90A-NEXT:    s_mov_b32 s9, s43
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s46, s16
; GFX900-NEXT:    s_mov_b32 s47, s17
; GFX900-NEXT:    s_mov_b64 s[8:9], s[44:45]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[46:47]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s46, s16
; GFX90A-NEXT:    s_mov_b32 s47, s17
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[44:45]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[46:47]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s46
; GFX900-NEXT:    s_mov_b32 s9, s47
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s46
; GFX90A-NEXT:    s_mov_b32 s9, s47
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s26
; GFX942-NEXT:    s_mov_b32 s9, s27
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_6() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s50, s16
; GFX900-NEXT:    s_mov_b32 s51, s17
; GFX900-NEXT:    s_mov_b64 s[8:9], s[48:49]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[50:51]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s50, s16
; GFX90A-NEXT:    s_mov_b32 s51, s17
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[48:49]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[50:51]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_6:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s30, s12
; GFX942-NEXT:    s_mov_b32 s31, s13
; GFX942-NEXT:    s_mov_b64 s[8:9], s[28:29]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[30:31]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_7() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__0_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s22
; GFX9-NEXT:    s_mov_b32 s11, s23
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s6
; GFX900-NEXT:    s_mov_b32 s17, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s6
; GFX90A-NEXT:    s_mov_b32 s17, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s2
; GFX942-NEXT:    s_mov_b32 s13, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_7() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__2_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s18
; GFX9-NEXT:    s_mov_b32 s11, s19
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s10
; GFX900-NEXT:    s_mov_b32 s17, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s10
; GFX90A-NEXT:    s_mov_b32 s17, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s6
; GFX942-NEXT:    s_mov_b32 s13, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s18
; GFX900-NEXT:    s_mov_b32 s15, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s18
; GFX90A-NEXT:    s_mov_b32 s15, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s14
; GFX942-NEXT:    s_mov_b32 s11, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s14
; GFX900-NEXT:    s_mov_b32 s17, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s14
; GFX90A-NEXT:    s_mov_b32 s17, s15
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s10
; GFX942-NEXT:    s_mov_b32 s13, s11
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s18
; GFX900-NEXT:    s_mov_b32 s17, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s18
; GFX90A-NEXT:    s_mov_b32 s17, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s14
; GFX942-NEXT:    s_mov_b32 s13, s15
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s38
; GFX900-NEXT:    s_mov_b32 s17, s39
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s38
; GFX90A-NEXT:    s_mov_b32 s17, s39
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s18
; GFX942-NEXT:    s_mov_b32 s13, s19
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s22
; GFX900-NEXT:    s_mov_b32 s11, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s22
; GFX90A-NEXT:    s_mov_b32 s11, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s22
; GFX942-NEXT:    s_mov_b32 s11, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s42
; GFX900-NEXT:    s_mov_b32 s17, s43
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s42
; GFX90A-NEXT:    s_mov_b32 s17, s43
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s22
; GFX942-NEXT:    s_mov_b32 s13, s23
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s46, s18
; GFX900-NEXT:    s_mov_b32 s47, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[44:45]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[46:47]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s46, s18
; GFX90A-NEXT:    s_mov_b32 s47, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[44:45]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[46:47]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s18
; GFX942-NEXT:    s_mov_b32 s11, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s46
; GFX900-NEXT:    s_mov_b32 s17, s47
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s46
; GFX90A-NEXT:    s_mov_b32 s17, s47
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s12, s26
; GFX942-NEXT:    s_mov_b32 s13, s27
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_7() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s50, s18
; GFX900-NEXT:    s_mov_b32 s51, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[48:49]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[50:51]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s50, s18
; GFX90A-NEXT:    s_mov_b32 s51, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[48:49]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[50:51]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_7:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s30, s14
; GFX942-NEXT:    s_mov_b32 s31, s15
; GFX942-NEXT:    s_mov_b64 s[8:9], s[28:29]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[30:31]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_8() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__u_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 poison, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 0, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 1, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 2, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 3, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 4, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 5, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 6, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 7, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_8() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__8_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> poison, <2 x i32> <i32 8, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_8() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__10_8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s4
; GFX9-NEXT:    s_mov_b32 s11, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s4
; GFX900-NEXT:    s_mov_b32 s15, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s4
; GFX90A-NEXT:    s_mov_b32 s15, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_8() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_8:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s4
; GFX900-NEXT:    s_mov_b32 s19, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_8:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s4
; GFX90A-NEXT:    s_mov_b32 s19, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_8:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s0
; GFX942-NEXT:    s_mov_b32 s15, s1
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 8>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s14
; GFX900-NEXT:    s_mov_b32 s11, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s14
; GFX90A-NEXT:    s_mov_b32 s11, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s14
; GFX942-NEXT:    s_mov_b32 s11, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s14
; GFX900-NEXT:    s_mov_b32 s11, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s14
; GFX90A-NEXT:    s_mov_b32 s11, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s14
; GFX942-NEXT:    s_mov_b32 s11, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s42
; GFX900-NEXT:    s_mov_b32 s9, s43
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s42
; GFX90A-NEXT:    s_mov_b32 s9, s43
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s18
; GFX900-NEXT:    s_mov_b32 s15, s19
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s18
; GFX90A-NEXT:    s_mov_b32 s15, s19
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s14
; GFX942-NEXT:    s_mov_b32 s11, s15
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s26
; GFX900-NEXT:    s_mov_b32 s9, s27
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s26
; GFX90A-NEXT:    s_mov_b32 s9, s27
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s26
; GFX942-NEXT:    s_mov_b32 s9, s27
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s38
; GFX900-NEXT:    s_mov_b32 s19, s39
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s38
; GFX90A-NEXT:    s_mov_b32 s19, s39
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s18
; GFX942-NEXT:    s_mov_b32 s15, s19
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s26
; GFX900-NEXT:    s_mov_b32 s9, s27
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s26
; GFX90A-NEXT:    s_mov_b32 s9, s27
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s26
; GFX942-NEXT:    s_mov_b32 s9, s27
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__8_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__8_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__8_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_9() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__9_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_9() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__10_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_9() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__11_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s6
; GFX900-NEXT:    s_mov_b32 s15, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s6
; GFX90A-NEXT:    s_mov_b32 s15, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_9() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__13_9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s18
; GFX9-NEXT:    s_mov_b32 s9, s19
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_9() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_9:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s6
; GFX900-NEXT:    s_mov_b32 s19, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_9:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s6
; GFX90A-NEXT:    s_mov_b32 s19, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_9:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s2
; GFX942-NEXT:    s_mov_b32 s15, s3
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 9>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s8
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s8
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s20
; GFX900-NEXT:    s_mov_b32 s15, s21
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s20
; GFX90A-NEXT:    s_mov_b32 s15, s21
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s20
; GFX900-NEXT:    s_mov_b32 s11, s21
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s20
; GFX90A-NEXT:    s_mov_b32 s11, s21
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s40
; GFX900-NEXT:    s_mov_b32 s19, s41
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s40
; GFX90A-NEXT:    s_mov_b32 s19, s41
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s20
; GFX942-NEXT:    s_mov_b32 s15, s21
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s40
; GFX900-NEXT:    s_mov_b32 s11, s41
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s40
; GFX90A-NEXT:    s_mov_b32 s11, s41
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_10() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__8_10:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__9_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__9_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__9_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_10() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__10_10:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__11_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__11_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__11_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s8
; GFX900-NEXT:    s_mov_b32 s15, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s8
; GFX90A-NEXT:    s_mov_b32 s15, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__13_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__13_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__13_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_10() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_10:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s8
; GFX900-NEXT:    s_mov_b32 s19, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_10:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s8
; GFX90A-NEXT:    s_mov_b32 s19, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_10:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s4
; GFX942-NEXT:    s_mov_b32 s15, s5
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 10>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s18
; GFX900-NEXT:    s_mov_b32 s11, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s18
; GFX90A-NEXT:    s_mov_b32 s11, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s18
; GFX942-NEXT:    s_mov_b32 s11, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s38
; GFX900-NEXT:    s_mov_b32 s9, s39
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s38
; GFX90A-NEXT:    s_mov_b32 s9, s39
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s18
; GFX900-NEXT:    s_mov_b32 s11, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s18
; GFX90A-NEXT:    s_mov_b32 s11, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s18
; GFX942-NEXT:    s_mov_b32 s11, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s22
; GFX900-NEXT:    s_mov_b32 s15, s23
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s22
; GFX90A-NEXT:    s_mov_b32 s15, s23
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s18
; GFX942-NEXT:    s_mov_b32 s11, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s42
; GFX900-NEXT:    s_mov_b32 s19, s43
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s42
; GFX90A-NEXT:    s_mov_b32 s19, s43
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s22
; GFX942-NEXT:    s_mov_b32 s15, s23
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s22
; GFX900-NEXT:    s_mov_b32 s9, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s22
; GFX90A-NEXT:    s_mov_b32 s9, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s22
; GFX942-NEXT:    s_mov_b32 s9, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_11() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__8_11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s14
; GFX9-NEXT:    s_mov_b32 s11, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_11() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__9_11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s6
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__10_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__10_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__10_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_11() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__11_11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s10
; GFX900-NEXT:    s_mov_b32 s15, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s10
; GFX90A-NEXT:    s_mov_b32 s15, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s6
; GFX942-NEXT:    s_mov_b32 s11, s7
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_11() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__13_11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_11() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_11:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s10
; GFX900-NEXT:    s_mov_b32 s19, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_11:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s10
; GFX90A-NEXT:    s_mov_b32 s19, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_11:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s6
; GFX942-NEXT:    s_mov_b32 s15, s7
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 11>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s8
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s20
; GFX900-NEXT:    s_mov_b32 s11, s21
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s20
; GFX90A-NEXT:    s_mov_b32 s11, s21
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s3
; GFX942-NEXT:    s_mov_b32 s10, s12
; GFX942-NEXT:    s_mov_b32 s11, s13
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s20
; GFX900-NEXT:    s_mov_b32 s11, s21
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s20
; GFX90A-NEXT:    s_mov_b32 s11, s21
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s20
; GFX900-NEXT:    s_mov_b32 s11, s21
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s20
; GFX90A-NEXT:    s_mov_b32 s11, s21
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s7
; GFX942-NEXT:    s_mov_b32 s10, s16
; GFX942-NEXT:    s_mov_b32 s11, s17
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s24
; GFX900-NEXT:    s_mov_b32 s15, s25
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s24
; GFX90A-NEXT:    s_mov_b32 s15, s25
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s24
; GFX900-NEXT:    s_mov_b32 s11, s25
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__5_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s24
; GFX90A-NEXT:    s_mov_b32 s11, s25
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__5_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s11
; GFX942-NEXT:    s_mov_b32 s10, s20
; GFX942-NEXT:    s_mov_b32 s11, s21
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 5, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__6_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__6_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s44
; GFX900-NEXT:    s_mov_b32 s19, s45
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__6_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s44
; GFX90A-NEXT:    s_mov_b32 s19, s45
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__6_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s24
; GFX942-NEXT:    s_mov_b32 s15, s25
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 6, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__7_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__7_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s36, 0
; GFX900-NEXT:    v_writelane_b32 v0, s37, 1
; GFX900-NEXT:    v_writelane_b32 v0, s38, 2
; GFX900-NEXT:    v_writelane_b32 v0, s39, 3
; GFX900-NEXT:    v_writelane_b32 v0, s48, 4
; GFX900-NEXT:    v_writelane_b32 v0, s49, 5
; GFX900-NEXT:    v_writelane_b32 v0, s50, 6
; GFX900-NEXT:    v_writelane_b32 v0, s51, 7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[36:51]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    s_mov_b32 s10, s44
; GFX900-NEXT:    s_mov_b32 s11, s45
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s51, v0, 7
; GFX900-NEXT:    v_readlane_b32 s50, v0, 6
; GFX900-NEXT:    v_readlane_b32 s49, v0, 5
; GFX900-NEXT:    v_readlane_b32 s48, v0, 4
; GFX900-NEXT:    v_readlane_b32 s39, v0, 3
; GFX900-NEXT:    v_readlane_b32 s38, v0, 2
; GFX900-NEXT:    v_readlane_b32 s37, v0, 1
; GFX900-NEXT:    v_readlane_b32 s36, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__7_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s36, 0
; GFX90A-NEXT:    v_writelane_b32 v0, s37, 1
; GFX90A-NEXT:    v_writelane_b32 v0, s38, 2
; GFX90A-NEXT:    v_writelane_b32 v0, s39, 3
; GFX90A-NEXT:    v_writelane_b32 v0, s48, 4
; GFX90A-NEXT:    v_writelane_b32 v0, s49, 5
; GFX90A-NEXT:    v_writelane_b32 v0, s50, 6
; GFX90A-NEXT:    v_writelane_b32 v0, s51, 7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[36:51]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    s_mov_b32 s10, s44
; GFX90A-NEXT:    s_mov_b32 s11, s45
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s51, v0, 7
; GFX90A-NEXT:    v_readlane_b32 s50, v0, 6
; GFX90A-NEXT:    v_readlane_b32 s49, v0, 5
; GFX90A-NEXT:    v_readlane_b32 s48, v0, 4
; GFX90A-NEXT:    v_readlane_b32 s39, v0, 3
; GFX90A-NEXT:    v_readlane_b32 s38, v0, 2
; GFX90A-NEXT:    v_readlane_b32 s37, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s36, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__7_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s14
; GFX942-NEXT:    s_mov_b32 s9, s15
; GFX942-NEXT:    s_mov_b32 s10, s24
; GFX942-NEXT:    s_mov_b32 s11, s25
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 7, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__8_12() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__8_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:23]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s16
; GFX9-NEXT:    s_mov_b32 s11, s17
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 8, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__9_12() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__9_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s6
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 9, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__10_12() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__10_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 10, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__11_12() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__11_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 11, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__12_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__12_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s12
; GFX900-NEXT:    s_mov_b32 s15, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__12_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s12
; GFX90A-NEXT:    s_mov_b32 s15, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__12_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s8
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 12, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__13_12() {
; GFX9-LABEL: s_shuffle_v2i64_v8i64__13_12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:19]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 13, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__14_12() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__14_12:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s18, s12
; GFX900-NEXT:    s_mov_b32 s19, s13
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__14_12:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s18, s12
; GFX90A-NEXT:    s_mov_b32 s19, s13
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__14_12:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s14, s8
; GFX942-NEXT:    s_mov_b32 s15, s9
; GFX942-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX942-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 14, i32 12>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__u_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__u_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__u_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__u_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 poison, i32 13>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__0_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__0_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s22
; GFX900-NEXT:    s_mov_b32 s11, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__0_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s22
; GFX90A-NEXT:    s_mov_b32 s11, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__0_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:23]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s22
; GFX942-NEXT:    s_mov_b32 s11, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 0, i32 13>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__1_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__1_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:23]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s16, s6
; GFX900-NEXT:    s_mov_b32 s17, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__1_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:23]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s16, s6
; GFX90A-NEXT:    s_mov_b32 s17, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[16:17]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[18:19]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__1_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_store_dword off, v0, s32 ; 4-byte Folded Spill
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    v_writelane_b32 v0, s30, 0
; GFX942-NEXT:    v_writelane_b32 v0, s31, 1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[16:31]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_readlane_b32 s31, v0, 1
; GFX942-NEXT:    v_readlane_b32 s30, v0, 0
; GFX942-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-NEXT:    scratch_load_dword v0, off, s32 ; 4-byte Folded Reload
; GFX942-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 1, i32 13>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__2_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__2_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s22
; GFX900-NEXT:    s_mov_b32 s11, s23
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__2_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s22
; GFX90A-NEXT:    s_mov_b32 s11, s23
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__2_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:19]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s22
; GFX942-NEXT:    s_mov_b32 s11, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 2, i32 13>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__3_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__3_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:27]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s20, s10
; GFX900-NEXT:    s_mov_b32 s21, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__3_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:27]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s20, s10
; GFX90A-NEXT:    s_mov_b32 s21, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[20:21]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[22:23]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__3_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s18
; GFX942-NEXT:    s_mov_b32 s9, s19
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 3, i32 13>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__4_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__4_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s14, s26
; GFX900-NEXT:    s_mov_b32 s15, s27
; GFX900-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX900-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_readlane_b32 s31, v0, 1
; GFX900-NEXT:    v_readlane_b32 s30, v0, 0
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v8i64__4_13:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    v_writelane_b32 v0, s30, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_writelane_b32 v0, s31, 1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[16:31]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s14, s26
; GFX90A-NEXT:    s_mov_b32 s15, s27
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[12:13]
; GFX90A-NEXT:    s_mov_b64 s[10:11], s[14:15]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_readlane_b32 s31, v0, 1
; GFX90A-NEXT:    v_readlane_b32 s30, v0, 0
; GFX90A-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX90A-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX90A-NEXT:    s_mov_b64 exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v2i64_v8i64__4_13:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:15]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[12:27]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s10, s22
; GFX942-NEXT:    s_mov_b32 s11, s23
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <8 x i64> asm "; def $0", "=s"()
  %vec1 = call <8 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <8 x i64> %vec0, <8 x i64> %vec1, <2 x i32> <i32 4, i32 13>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v8i64__5_13() {
; GFX900-LABEL: s_shuffle_v2i64_v8i64__5_13:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX900-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX900-NEXT:    s_mov_b64 exec, s[4:5]
; GFX900-NEXT:    v_writelane_b32 v0, s30, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_writelane_b32 v0, s31, 1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[16:31]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s24, s14
; GFX900-NEXT:    s_mov_b32 s25, s15
; GFX900-NEXT:    s_mov_b64 s[8:9], s[24:25]
; GFX900-NEXT:    s_mov_b64 s[10:11],