# Contributing

First of all, thank you very much for taking the time to contribute to the
`EnTT` library.<br/>
How to do it mostly depends on the type of contribution:

* If you have a question, **please** ensure there isn't already an answer for
  you by searching on GitHub under
  [issues](https://github.com/skypjack/entt/issues). Do not forget to search
  also through the closed ones. If you are unable to find a proper answer, feel
  free to [open a new issue](https://github.com/skypjack/entt/issues/new).
  Usually, questions are marked as such and closed in a few days.

* If you want to fix a typo in the inline documentation or in the README file,
  if you want to add some new sections or if you want to help me with the
  language by reviewing what I wrote so far (I'm not a native speaker after
  all), **please** open a new
  [pull request](https://github.com/skypjack/entt/pulls) with your changes.

* If you found a bug, **please** ensure there isn't already an answer for you by
  searching on GitHub under [issues](https://github.com/skypjack/entt/issues).
  If you are unable to find an open issue addressing the problem, feel free to
  [open a new one](https://github.com/skypjack/entt/issues/new). **Please**, do
  not forget to carefully describe how to reproduce the problem, then add all
  the information about the system on which you are experiencing it and point
  out the version of `EnTT` you are using (tag or commit).

* If you found a bug and you wrote a patch to fix it, open a new
  [pull request](https://github.com/skypjack/entt/pulls) with your code.
  **Please**, add some tests to avoid regressions in future if possible, it
  would be really appreciated. Note that the `EnTT` library has a
  [coverage at 100%](https://coveralls.io/github/skypjack/entt?branch=master)
  (at least it was at 100% at the time I wrote this file) and this is the reason
  for which you can be confident with using it in a production environment.

* If you want to propose a new feature and you know how to code it, **please**
  do not issue directly a pull request. Before to do it,
  [create a new issue](https://github.com/skypjack/entt/issues/new) to discuss
  your proposal. Other users could be interested in your idea and the discussion
  that will follow can refine it and therefore give us a better solution.

* If you want to request a new feature, I'm available for hiring. Take a look at
  [my profile](https://github.com/skypjack) and feel free to write me.
