--
-- ### function and procedure checks with clob parameters
--

drop if exists table t1;
create table t1 ( a int, b clob );

drop if exists procedure putClobFunction;
drop if exists procedure putClobProcedure;
drop if exists procedure putStringProcedure;


@
create procedure putClobFunction ( a in int, b in clob, c out string(10) ) return int
begin 

   insert into t1 ( a, b ) values ( :a, :b );
   :c = 'the result';

   return 4288;
end;
@


@
create procedure putStringProcedure ( a in int, b in string(1000), c out string(10), d out int )
begin 

   -- string is casted to clob here
   :d = ( select putClobFunction(:a, :b, :c) );
end;
@

@
create procedure putClobProcedure ( a in int, b in clob, c out string(10), d out int )
begin 

   :d = ( select putClobFunction(:a, :b, :c) );
   -- insert into t1 ( a, b ) values ( :a, :b );
   -- :c = 'the result';
end;
@


-- string is casted here for procedure
call putClobProcedure(1, 'CLOBDATA_FROM_PROCEDURE', :x, :y);
print :x;
print :y;

-- string is casted here for function
select putClobFunction(2, 'CLOBDATA_FROM_FUNCTION', :z);

-- string is casted here for function
:d = call putClobFunction(2, 'CLOBDATA_FROM_FUNCTION', :z);


select * from t1;
select clob2str(b) from t1;


