# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.10

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.globalization
import winsdk.windows.storage

class SpeechContinuousRecognitionMode(enum.IntEnum):
    DEFAULT = 0
    PAUSE_ON_RECOGNITION = 1

class SpeechRecognitionAudioProblem(enum.IntEnum):
    NONE = 0
    TOO_NOISY = 1
    NO_SIGNAL = 2
    TOO_LOUD = 3
    TOO_QUIET = 4
    TOO_FAST = 5
    TOO_SLOW = 6

class SpeechRecognitionConfidence(enum.IntEnum):
    HIGH = 0
    MEDIUM = 1
    LOW = 2
    REJECTED = 3

class SpeechRecognitionConstraintProbability(enum.IntEnum):
    DEFAULT = 0
    MIN = 1
    MAX = 2

class SpeechRecognitionConstraintType(enum.IntEnum):
    TOPIC = 0
    LIST = 1
    GRAMMAR = 2
    VOICE_COMMAND_DEFINITION = 3

class SpeechRecognitionResultStatus(enum.IntEnum):
    SUCCESS = 0
    TOPIC_LANGUAGE_NOT_SUPPORTED = 1
    GRAMMAR_LANGUAGE_MISMATCH = 2
    GRAMMAR_COMPILATION_FAILURE = 3
    AUDIO_QUALITY_FAILURE = 4
    USER_CANCELED = 5
    UNKNOWN = 6
    TIMEOUT_EXCEEDED = 7
    PAUSE_LIMIT_EXCEEDED = 8
    NETWORK_FAILURE = 9
    MICROPHONE_UNAVAILABLE = 10

class SpeechRecognitionScenario(enum.IntEnum):
    WEB_SEARCH = 0
    DICTATION = 1
    FORM_FILLING = 2

class SpeechRecognizerState(enum.IntEnum):
    IDLE = 0
    CAPTURING = 1
    PROCESSING = 2
    SOUND_STARTED = 3
    SOUND_ENDED = 4
    SPEECH_DETECTED = 5
    PAUSED = 6

Self = typing.TypeVar('Self')

class SpeechContinuousRecognitionCompletedEventArgs(winsdk.system.Object):
    status: SpeechRecognitionResultStatus
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechContinuousRecognitionCompletedEventArgs: ...

class SpeechContinuousRecognitionResultGeneratedEventArgs(winsdk.system.Object):
    result: typing.Optional[SpeechRecognitionResult]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechContinuousRecognitionResultGeneratedEventArgs: ...

class SpeechContinuousRecognitionSession(winsdk.system.Object):
    auto_stop_silence_timeout: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechContinuousRecognitionSession: ...
    def cancel_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def pause_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def resume(self) -> None: ...
    @typing.overload
    def start_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def start_async(self, mode: SpeechContinuousRecognitionMode, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def stop_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def add_completed(self, value: winsdk.windows.foundation.TypedEventHandler[SpeechContinuousRecognitionSession, SpeechContinuousRecognitionCompletedEventArgs], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_completed(self, value: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...
    def add_result_generated(self, value: winsdk.windows.foundation.TypedEventHandler[SpeechContinuousRecognitionSession, SpeechContinuousRecognitionResultGeneratedEventArgs], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_result_generated(self, value: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...

class SpeechRecognitionCompilationResult(winsdk.system.Object):
    status: SpeechRecognitionResultStatus
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionCompilationResult: ...

class SpeechRecognitionGrammarFileConstraint(winsdk.system.Object):
    tag: str
    probability: SpeechRecognitionConstraintProbability
    is_enabled: winsdk.system.Boolean
    type: SpeechRecognitionConstraintType
    grammar_file: typing.Optional[winsdk.windows.storage.StorageFile]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionGrammarFileConstraint: ...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognitionGrammarFileConstraint], file: typing.Optional[winsdk.windows.storage.StorageFile]) -> SpeechRecognitionGrammarFileConstraint:...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognitionGrammarFileConstraint], file: typing.Optional[winsdk.windows.storage.StorageFile], tag: str) -> SpeechRecognitionGrammarFileConstraint:...

class SpeechRecognitionHypothesis(winsdk.system.Object):
    text: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionHypothesis: ...

class SpeechRecognitionHypothesisGeneratedEventArgs(winsdk.system.Object):
    hypothesis: typing.Optional[SpeechRecognitionHypothesis]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionHypothesisGeneratedEventArgs: ...

class SpeechRecognitionListConstraint(winsdk.system.Object):
    tag: str
    probability: SpeechRecognitionConstraintProbability
    is_enabled: winsdk.system.Boolean
    type: SpeechRecognitionConstraintType
    commands: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionListConstraint: ...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognitionListConstraint], commands: typing.Iterable[str]) -> SpeechRecognitionListConstraint:...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognitionListConstraint], commands: typing.Iterable[str], tag: str) -> SpeechRecognitionListConstraint:...

class SpeechRecognitionQualityDegradingEventArgs(winsdk.system.Object):
    problem: SpeechRecognitionAudioProblem
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionQualityDegradingEventArgs: ...

class SpeechRecognitionResult(winsdk.system.Object):
    confidence: SpeechRecognitionConfidence
    constraint: typing.Optional[ISpeechRecognitionConstraint]
    raw_confidence: winsdk.system.Double
    rule_path: typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]
    semantic_interpretation: typing.Optional[SpeechRecognitionSemanticInterpretation]
    status: SpeechRecognitionResultStatus
    text: str
    phrase_duration: datetime.timedelta
    phrase_start_time: datetime.datetime
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionResult: ...
    def get_alternates(self, max_alternates: winsdk.system.UInt32, /) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[SpeechRecognitionResult]]: ...

class SpeechRecognitionSemanticInterpretation(winsdk.system.Object):
    properties: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, winsdk.windows.foundation.collections.IVectorView[str]]]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionSemanticInterpretation: ...

class SpeechRecognitionTopicConstraint(winsdk.system.Object):
    tag: str
    probability: SpeechRecognitionConstraintProbability
    is_enabled: winsdk.system.Boolean
    type: SpeechRecognitionConstraintType
    scenario: SpeechRecognitionScenario
    topic_hint: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionTopicConstraint: ...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognitionTopicConstraint], scenario: SpeechRecognitionScenario, topic_hint: str) -> SpeechRecognitionTopicConstraint:...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognitionTopicConstraint], scenario: SpeechRecognitionScenario, topic_hint: str, tag: str) -> SpeechRecognitionTopicConstraint:...

class SpeechRecognitionVoiceCommandDefinitionConstraint(winsdk.system.Object):
    tag: str
    probability: SpeechRecognitionConstraintProbability
    is_enabled: winsdk.system.Boolean
    type: SpeechRecognitionConstraintType
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognitionVoiceCommandDefinitionConstraint: ...

class SpeechRecognizer(winsdk.system.Object):
    constraints: typing.Optional[winsdk.windows.foundation.collections.IVector[ISpeechRecognitionConstraint]]
    current_language: typing.Optional[winsdk.windows.globalization.Language]
    timeouts: typing.Optional[SpeechRecognizerTimeouts]
    u_i_options: typing.Optional[SpeechRecognizerUIOptions]
    continuous_recognition_session: typing.Optional[SpeechContinuousRecognitionSession]
    state: SpeechRecognizerState
    supported_grammar_languages: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.globalization.Language]]]
    supported_topic_languages: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.globalization.Language]]]
    system_speech_language: typing.ClassVar[typing.Optional[winsdk.windows.globalization.Language]]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognizer: ...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognizer], language: typing.Optional[winsdk.windows.globalization.Language]) -> SpeechRecognizer:...
    @typing.overload
    def __new__(cls: typing.Type[SpeechRecognizer]) -> SpeechRecognizer:...
    def close(self) -> None: ...
    def compile_constraints_async(self) -> winsdk.windows.foundation.IAsyncOperation[SpeechRecognitionCompilationResult]: ...
    def recognize_async(self) -> winsdk.windows.foundation.IAsyncOperation[SpeechRecognitionResult]: ...
    def recognize_with_u_i_async(self) -> winsdk.windows.foundation.IAsyncOperation[SpeechRecognitionResult]: ...
    def stop_recognition_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def try_set_system_speech_language_async(speech_language: typing.Optional[winsdk.windows.globalization.Language], /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def add_recognition_quality_degrading(self, speech_recognition_quality_degrading_handler: winsdk.windows.foundation.TypedEventHandler[SpeechRecognizer, SpeechRecognitionQualityDegradingEventArgs], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_recognition_quality_degrading(self, cookie: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...
    def add_state_changed(self, state_changed_handler: winsdk.windows.foundation.TypedEventHandler[SpeechRecognizer, SpeechRecognizerStateChangedEventArgs], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_state_changed(self, cookie: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...
    def add_hypothesis_generated(self, value: winsdk.windows.foundation.TypedEventHandler[SpeechRecognizer, SpeechRecognitionHypothesisGeneratedEventArgs], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_hypothesis_generated(self, value: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...

class SpeechRecognizerStateChangedEventArgs(winsdk.system.Object):
    state: SpeechRecognizerState
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognizerStateChangedEventArgs: ...

class SpeechRecognizerTimeouts(winsdk.system.Object):
    initial_silence_timeout: datetime.timedelta
    end_silence_timeout: datetime.timedelta
    babble_timeout: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognizerTimeouts: ...

class SpeechRecognizerUIOptions(winsdk.system.Object):
    show_confirmation: winsdk.system.Boolean
    is_read_back_enabled: winsdk.system.Boolean
    example_text: str
    audible_prompt: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SpeechRecognizerUIOptions: ...

class VoiceCommandManager(winsdk.system.Object):
    installed_command_sets: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IMapView[str, VoiceCommandSet]]]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> VoiceCommandManager: ...
    @staticmethod
    def install_command_sets_from_storage_file_async(file: typing.Optional[winsdk.windows.storage.StorageFile], /) -> winsdk.windows.foundation.IAsyncAction: ...

class VoiceCommandSet(winsdk.system.Object):
    language: str
    name: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> VoiceCommandSet: ...
    def set_phrase_list_async(self, phrase_list_name: str, phrase_list: typing.Iterable[str], /) -> winsdk.windows.foundation.IAsyncAction: ...

class ISpeechRecognitionConstraint(winsdk.system.Object):
    is_enabled: winsdk.system.Boolean
    probability: SpeechRecognitionConstraintProbability
    tag: str
    type: SpeechRecognitionConstraintType
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> ISpeechRecognitionConstraint: ...

