#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortedreal_ PETSCSORTEDREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortedreal_ petscsortedreal
#endif
PETSC_EXTERN void petscsortedreal_(PetscCount *a, const PetscReal b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSortedReal(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortreal_ PETSCSORTREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortreal_ petscsortreal
#endif
PETSC_EXTERN void petscsortreal_(PetscCount *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PetscSortReal(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortrealwitharrayint_ PETSCSORTREALWITHARRAYINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortrealwitharrayint_ petscsortrealwitharrayint
#endif
PETSC_EXTERN void petscsortrealwitharrayint_(PetscCount *a, PetscReal b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSortRealWithArrayInt(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfindreal_ PETSCFINDREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfindreal_ petscfindreal
#endif
PETSC_EXTERN void petscfindreal_(PetscReal *a, PetscCount *b, const PetscReal c[], PetscReal *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLINTEGER(e);
  *ierr = PetscFindReal(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortremovedupsreal_ PETSCSORTREMOVEDUPSREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortremovedupsreal_ petscsortremovedupsreal
#endif
PETSC_EXTERN void petscsortremovedupsreal_(PetscInt *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(a);
  CHKFORTRANNULLREAL(b);
  *ierr = PetscSortRemoveDupsReal(a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortsplit_ PETSCSORTSPLIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortsplit_ petscsortsplit
#endif
PETSC_EXTERN void petscsortsplit_(PetscInt *a, PetscInt *b, PetscScalar c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSortSplit(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortsplitreal_ PETSCSORTSPLITREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortsplitreal_ petscsortsplitreal
#endif
PETSC_EXTERN void petscsortsplitreal_(PetscInt *a, PetscInt *b, PetscReal c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSortSplitReal(*a, *b, c, d);
  if (*ierr) return;
}
