#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectdestroy_ PETSCOBJECTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectdestroy_ petscobjectdestroy
#endif
PETSC_EXTERN void petscobjectdestroy_(PetscObject *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscObjectDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectview_ PETSCOBJECTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectview_ petscobjectview
#endif
PETSC_EXTERN void petscobjectview_(PetscObject *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscObjectView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectviewfromoptions_ PETSCOBJECTVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectviewfromoptions_ petscobjectviewfromoptions
#endif
PETSC_EXTERN void petscobjectviewfromoptions_(PetscObject *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscObjectViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjecttypecompare_ PETSCOBJECTTYPECOMPARE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjecttypecompare_ petscobjecttypecompare
#endif
PETSC_EXTERN void petscobjecttypecompare_(PetscObject *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscObjectTypeCompare(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectobjecttypecompare_ PETSCOBJECTOBJECTTYPECOMPARE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectobjecttypecompare_ petscobjectobjecttypecompare
#endif
PETSC_EXTERN void petscobjectobjecttypecompare_(PetscObject *a, PetscObject *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscObjectObjectTypeCompare(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectbasetypecompare_ PETSCOBJECTBASETYPECOMPARE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectbasetypecompare_ petscobjectbasetypecompare
#endif
PETSC_EXTERN void petscobjectbasetypecompare_(PetscObject *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscObjectBaseTypeCompare(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectregisterdestroy_ PETSCOBJECTREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectregisterdestroy_ petscobjectregisterdestroy
#endif
PETSC_EXTERN void petscobjectregisterdestroy_(PetscObject *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  *ierr = PetscObjectRegisterDestroy(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectregisterdestroyall_ PETSCOBJECTREGISTERDESTROYALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectregisterdestroyall_ petscobjectregisterdestroyall
#endif
PETSC_EXTERN void petscobjectregisterdestroyall_(PetscErrorCode *ierr)
{
  *ierr = PetscObjectRegisterDestroyAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregisterfinalizeall_ PETSCREGISTERFINALIZEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregisterfinalizeall_ petscregisterfinalizeall
#endif
PETSC_EXTERN void petscregisterfinalizeall_(PetscErrorCode *ierr)
{
  *ierr = PetscRegisterFinalizeAll();
  if (*ierr) return;
}
