#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetresidualnorm_ KSPGETRESIDUALNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetresidualnorm_ kspgetresidualnorm
#endif
PETSC_EXTERN void kspgetresidualnorm_(KSP *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = KSPGetResidualNorm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetiterationnumber_ KSPGETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetiterationnumber_ kspgetiterationnumber
#endif
PETSC_EXTERN void kspgetiterationnumber_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = KSPGetIterationNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgettotaliterations_ KSPGETTOTALITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgettotaliterations_ kspgettotaliterations
#endif
PETSC_EXTERN void kspgettotaliterations_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = KSPGetTotalIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorresidual_ KSPMONITORRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorresidual_ kspmonitorresidual
#endif
PETSC_EXTERN void kspmonitorresidual_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorResidual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorresidualdraw_ KSPMONITORRESIDUALDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorresidualdraw_ kspmonitorresidualdraw
#endif
PETSC_EXTERN void kspmonitorresidualdraw_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorResidualDraw(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorresidualdrawlg_ KSPMONITORRESIDUALDRAWLG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorresidualdrawlg_ kspmonitorresidualdrawlg
#endif
PETSC_EXTERN void kspmonitorresidualdrawlg_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorResidualDrawLG(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorresidualshort_ KSPMONITORRESIDUALSHORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorresidualshort_ kspmonitorresidualshort
#endif
PETSC_EXTERN void kspmonitorresidualshort_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorResidualShort(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorresidualrange_ KSPMONITORRESIDUALRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorresidualrange_ kspmonitorresidualrange
#endif
PETSC_EXTERN void kspmonitorresidualrange_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorResidualRange(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitortrueresidual_ KSPMONITORTRUERESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitortrueresidual_ kspmonitortrueresidual
#endif
PETSC_EXTERN void kspmonitortrueresidual_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorTrueResidual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitortrueresidualdraw_ KSPMONITORTRUERESIDUALDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitortrueresidualdraw_ kspmonitortrueresidualdraw
#endif
PETSC_EXTERN void kspmonitortrueresidualdraw_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorTrueResidualDraw(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitortrueresidualdrawlg_ KSPMONITORTRUERESIDUALDRAWLG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitortrueresidualdrawlg_ kspmonitortrueresidualdrawlg
#endif
PETSC_EXTERN void kspmonitortrueresidualdrawlg_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorTrueResidualDrawLG(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitortrueresidualmax_ KSPMONITORTRUERESIDUALMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitortrueresidualmax_ kspmonitortrueresidualmax
#endif
PETSC_EXTERN void kspmonitortrueresidualmax_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorTrueResidualMax(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorerror_ KSPMONITORERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorerror_ kspmonitorerror
#endif
PETSC_EXTERN void kspmonitorerror_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorError(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorerrordraw_ KSPMONITORERRORDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorerrordraw_ kspmonitorerrordraw
#endif
PETSC_EXTERN void kspmonitorerrordraw_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorErrorDraw(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorerrordrawlg_ KSPMONITORERRORDRAWLG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorerrordrawlg_ kspmonitorerrordrawlg
#endif
PETSC_EXTERN void kspmonitorerrordrawlg_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorErrorDrawLG(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorsolution_ KSPMONITORSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorsolution_ kspmonitorsolution
#endif
PETSC_EXTERN void kspmonitorsolution_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorSolution(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorsolutiondraw_ KSPMONITORSOLUTIONDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorsolutiondraw_ kspmonitorsolutiondraw
#endif
PETSC_EXTERN void kspmonitorsolutiondraw_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorSolutionDraw(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorsolutiondrawlg_ KSPMONITORSOLUTIONDRAWLG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorsolutiondrawlg_ kspmonitorsolutiondrawlg
#endif
PETSC_EXTERN void kspmonitorsolutiondrawlg_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorSolutionDrawLG(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorsingularvalue_ KSPMONITORSINGULARVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorsingularvalue_ kspmonitorsingularvalue
#endif
PETSC_EXTERN void kspmonitorsingularvalue_(KSP *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorSingularValue(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitordynamictolerancecreate_ KSPMONITORDYNAMICTOLERANCECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitordynamictolerancecreate_ kspmonitordynamictolerancecreate
#endif
PETSC_EXTERN void kspmonitordynamictolerancecreate_(void *a, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorDynamicToleranceCreate(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitordynamictolerancesetcoefficient_ KSPMONITORDYNAMICTOLERANCESETCOEFFICIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitordynamictolerancesetcoefficient_ kspmonitordynamictolerancesetcoefficient
#endif
PETSC_EXTERN void kspmonitordynamictolerancesetcoefficient_(void *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorDynamicToleranceSetCoefficient(a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitordynamictolerance_ KSPMONITORDYNAMICTOLERANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitordynamictolerance_ kspmonitordynamictolerance
#endif
PETSC_EXTERN void kspmonitordynamictolerance_(KSP *a, PetscInt *b, PetscReal *c, void *d, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorDynamicTolerance(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergedskip_ KSPCONVERGEDSKIP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergedskip_ kspconvergedskip
#endif
PETSC_EXTERN void kspconvergedskip_(KSP *a, PetscInt *b, PetscReal *c, KSPConvergedReason *d, void *e, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedSkip(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetconvergednegativecurvature_ KSPSETCONVERGEDNEGATIVECURVATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetconvergednegativecurvature_ kspsetconvergednegativecurvature
#endif
PETSC_EXTERN void kspsetconvergednegativecurvature_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetConvergedNegativeCurvature(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetconvergednegativecurvature_ KSPGETCONVERGEDNEGATIVECURVATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetconvergednegativecurvature_ kspgetconvergednegativecurvature
#endif
PETSC_EXTERN void kspgetconvergednegativecurvature_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetConvergedNegativeCurvature(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergeddefaultsetuirnorm_ KSPCONVERGEDDEFAULTSETUIRNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergeddefaultsetuirnorm_ kspconvergeddefaultsetuirnorm
#endif
PETSC_EXTERN void kspconvergeddefaultsetuirnorm_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedDefaultSetUIRNorm(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergeddefaultsetumirnorm_ KSPCONVERGEDDEFAULTSETUMIRNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergeddefaultsetumirnorm_ kspconvergeddefaultsetumirnorm
#endif
PETSC_EXTERN void kspconvergeddefaultsetumirnorm_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedDefaultSetUMIRNorm(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergeddefaultsetconvergedmaxits_ KSPCONVERGEDDEFAULTSETCONVERGEDMAXITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergeddefaultsetconvergedmaxits_ kspconvergeddefaultsetconvergedmaxits
#endif
PETSC_EXTERN void kspconvergeddefaultsetconvergedmaxits_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedDefaultSetConvergedMaxits(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergeddefault_ KSPCONVERGEDDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergeddefault_ kspconvergeddefault
#endif
PETSC_EXTERN void kspconvergeddefault_(KSP *a, PetscInt *b, PetscReal *c, KSPConvergedReason *d, void *e, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedDefault(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergeddefaultdestroy_ KSPCONVERGEDDEFAULTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergeddefaultdestroy_ kspconvergeddefaultdestroy
#endif
PETSC_EXTERN void kspconvergeddefaultdestroy_(void *a, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedDefaultDestroy(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspbuildsolutiondefault_ KSPBUILDSOLUTIONDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspbuildsolutiondefault_ kspbuildsolutiondefault
#endif
PETSC_EXTERN void kspbuildsolutiondefault_(KSP *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = KSPBuildSolutionDefault(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspbuildresidualdefault_ KSPBUILDRESIDUALDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspbuildresidualdefault_ kspbuildresidualdefault
#endif
PETSC_EXTERN void kspbuildresidualdefault_(KSP *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = KSPBuildResidualDefault(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetworkvecs_ KSPSETWORKVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetworkvecs_ kspsetworkvecs
#endif
PETSC_EXTERN void kspsetworkvecs_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetWorkVecs(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspdestroydefault_ KSPDESTROYDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspdestroydefault_ kspdestroydefault
#endif
PETSC_EXTERN void kspdestroydefault_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPDestroyDefault(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetconvergedreason_ KSPGETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetconvergedreason_ kspgetconvergedreason
#endif
PETSC_EXTERN void kspgetconvergedreason_(KSP *a, KSPConvergedReason *b, PetscErrorCode *ierr)
{
  *ierr = KSPGetConvergedReason(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetconvergedreasonstring_ KSPGETCONVERGEDREASONSTRING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetconvergedreasonstring_ kspgetconvergedreasonstring
#endif
PETSC_EXTERN void kspgetconvergedreasonstring_(KSP *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = KSPGetConvergedReasonString(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetdm_ KSPSETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetdm_ kspsetdm
#endif
PETSC_EXTERN void kspsetdm_(KSP *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetdmactive_ KSPSETDMACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetdmactive_ kspsetdmactive
#endif
PETSC_EXTERN void kspsetdmactive_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetDMActive(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetdm_ KSPGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetdm_ kspgetdm
#endif
PETSC_EXTERN void kspgetdm_(KSP *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = KSPGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetapplicationcontext_ KSPSETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetapplicationcontext_ kspsetapplicationcontext
#endif
PETSC_EXTERN void kspsetapplicationcontext_(KSP *a, void *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetapplicationcontext_ KSPGETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetapplicationcontext_ kspgetapplicationcontext
#endif
PETSC_EXTERN void kspgetapplicationcontext_(KSP *a, PeCtx b, PetscErrorCode *ierr)
{
  *ierr = KSPGetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspchecksolve_ KSPCHECKSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspchecksolve_ kspchecksolve
#endif
PETSC_EXTERN void kspchecksolve_(KSP *a, PC *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = KSPCheckSolve(*a, *b, *c);
  if (*ierr) return;
}
