#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattersetup_ VECSCATTERSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattersetup_ vecscattersetup
#endif
PETSC_EXTERN void vecscattersetup_(VecScatter *a, PetscErrorCode *ierr)
{
  *ierr = VecScatterSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattersettype_ VECSCATTERSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattersettype_ vecscattersettype
#endif
PETSC_EXTERN void vecscattersettype_(VecScatter *a, VecScatterType *b, PetscErrorCode *ierr)
{
  *ierr = VecScatterSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattergettype_ VECSCATTERGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattergettype_ vecscattergettype
#endif
PETSC_EXTERN void vecscattergettype_(VecScatter *a, VecScatterType *b, PetscErrorCode *ierr)
{
  *ierr = VecScatterGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattergetmerged_ VECSCATTERGETMERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattergetmerged_ vecscattergetmerged
#endif
PETSC_EXTERN void vecscattergetmerged_(VecScatter *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = VecScatterGetMerged(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterdestroy_ VECSCATTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterdestroy_ vecscatterdestroy
#endif
PETSC_EXTERN void vecscatterdestroy_(VecScatter *a, PetscErrorCode *ierr)
{
  *ierr = VecScatterDestroy(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattercopy_ VECSCATTERCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattercopy_ vecscattercopy
#endif
PETSC_EXTERN void vecscattercopy_(VecScatter *a, VecScatter *b, PetscErrorCode *ierr)
{
  *ierr = VecScatterCopy(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterviewfromoptions_ VECSCATTERVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterviewfromoptions_ vecscatterviewfromoptions
#endif
PETSC_EXTERN void vecscatterviewfromoptions_(VecScatter *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = VecScatterViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterview_ VECSCATTERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterview_ vecscatterview
#endif
PETSC_EXTERN void vecscatterview_(VecScatter *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = VecScatterView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterremap_ VECSCATTERREMAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterremap_ vecscatterremap
#endif
PETSC_EXTERN void vecscatterremap_(VecScatter *a, PetscInt b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = VecScatterRemap(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattersetfromoptions_ VECSCATTERSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattersetfromoptions_ vecscattersetfromoptions
#endif
PETSC_EXTERN void vecscattersetfromoptions_(VecScatter *a, PetscErrorCode *ierr)
{
  *ierr = VecScatterSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattercreate_ VECSCATTERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattercreate_ vecscattercreate
#endif
PETSC_EXTERN void vecscattercreate_(Vec *a, IS *b, Vec *c, IS *d, VecScatter *e, PetscErrorCode *ierr)
{
  *ierr = VecScatterCreate(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattercreatetoall_ VECSCATTERCREATETOALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattercreatetoall_ vecscattercreatetoall
#endif
PETSC_EXTERN void vecscattercreatetoall_(Vec *a, VecScatter *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecScatterCreateToAll(*a, b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscattercreatetozero_ VECSCATTERCREATETOZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscattercreatetozero_ vecscattercreatetozero
#endif
PETSC_EXTERN void vecscattercreatetozero_(Vec *a, VecScatter *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecScatterCreateToZero(*a, b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterbegin_ VECSCATTERBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterbegin_ vecscatterbegin
#endif
PETSC_EXTERN void vecscatterbegin_(VecScatter *a, Vec *b, Vec *c, InsertMode *d, ScatterMode *e, PetscErrorCode *ierr)
{
  *ierr = VecScatterBegin(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterend_ VECSCATTEREND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterend_ vecscatterend
#endif
PETSC_EXTERN void vecscatterend_(VecScatter *a, Vec *b, Vec *c, InsertMode *d, ScatterMode *e, PetscErrorCode *ierr)
{
  *ierr = VecScatterEnd(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
