#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascreatecoarsevec_ SNESFASCREATECOARSEVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascreatecoarsevec_ snesfascreatecoarsevec
#endif
PETSC_EXTERN void snesfascreatecoarsevec_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCreateCoarseVec(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasrestrict_ SNESFASRESTRICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasrestrict_ snesfasrestrict
#endif
PETSC_EXTERN void snesfasrestrict_(SNES *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = SNESFASRestrict(*a, *b, *c);
  if (*ierr) return;
}
