#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetrandom_ MATSETRANDOM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetrandom_ matsetrandom
#endif
PETSC_EXTERN void matsetrandom_(Mat *a, PetscRandom *b, PetscErrorCode *ierr)
{
  *ierr = MatSetRandom(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcopyhashtoxaij_ MATCOPYHASHTOXAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcopyhashtoxaij_ matcopyhashtoxaij
#endif
PETSC_EXTERN void matcopyhashtoxaij_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatCopyHashToXAIJ(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorgeterrorzeropivot_ MATFACTORGETERRORZEROPIVOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorgeterrorzeropivot_ matfactorgeterrorzeropivot
#endif
PETSC_EXTERN void matfactorgeterrorzeropivot_(Mat *a, PetscReal *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatFactorGetErrorZeroPivot(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorgeterror_ MATFACTORGETERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorgeterror_ matfactorgeterror
#endif
PETSC_EXTERN void matfactorgeterror_(Mat *a, MatFactorError *b, PetscErrorCode *ierr)
{
  *ierr = MatFactorGetError(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorclearerror_ MATFACTORCLEARERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorclearerror_ matfactorclearerror
#endif
PETSC_EXTERN void matfactorclearerror_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatFactorClearError(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfindnonzerorows_ MATFINDNONZEROROWS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfindnonzerorows_ matfindnonzerorows
#endif
PETSC_EXTERN void matfindnonzerorows_(Mat *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatFindNonzeroRows(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfindzerorows_ MATFINDZEROROWS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfindzerorows_ matfindzerorows
#endif
PETSC_EXTERN void matfindzerorows_(Mat *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatFindZeroRows(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetdiagonalblock_ MATGETDIAGONALBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetdiagonalblock_ matgetdiagonalblock
#endif
PETSC_EXTERN void matgetdiagonalblock_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatGetDiagonalBlock(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgettrace_ MATGETTRACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgettrace_ matgettrace
#endif
PETSC_EXTERN void matgettrace_(Mat *a, PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatGetTrace(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matrealpart_ MATREALPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matrealpart_ matrealpart
#endif
PETSC_EXTERN void matrealpart_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatRealPart(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matimaginarypart_ MATIMAGINARYPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matimaginarypart_ matimaginarypart
#endif
PETSC_EXTERN void matimaginarypart_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatImaginaryPart(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmissingdiagonal_ MATMISSINGDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmissingdiagonal_ matmissingdiagonal
#endif
PETSC_EXTERN void matmissingdiagonal_(Mat *a, PetscBool *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatMissingDiagonal(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matconjugate_ MATCONJUGATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matconjugate_ matconjugate
#endif
PETSC_EXTERN void matconjugate_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatConjugate(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetrowuppertriangular_ MATGETROWUPPERTRIANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetrowuppertriangular_ matgetrowuppertriangular
#endif
PETSC_EXTERN void matgetrowuppertriangular_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatGetRowUpperTriangular(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matrestorerowuppertriangular_ MATRESTOREROWUPPERTRIANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matrestorerowuppertriangular_ matrestorerowuppertriangular
#endif
PETSC_EXTERN void matrestorerowuppertriangular_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatRestoreRowUpperTriangular(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetoptionsprefix_ MATSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetoptionsprefix_ matsetoptionsprefix
#endif
PETSC_EXTERN void matsetoptionsprefix_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetoptionsprefixfactor_ MATSETOPTIONSPREFIXFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetoptionsprefixfactor_ matsetoptionsprefixfactor
#endif
PETSC_EXTERN void matsetoptionsprefixfactor_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatSetOptionsPrefixFactor(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matappendoptionsprefixfactor_ MATAPPENDOPTIONSPREFIXFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matappendoptionsprefixfactor_ matappendoptionsprefixfactor
#endif
PETSC_EXTERN void matappendoptionsprefixfactor_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatAppendOptionsPrefixFactor(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matappendoptionsprefix_ MATAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matappendoptionsprefix_ matappendoptionsprefix
#endif
PETSC_EXTERN void matappendoptionsprefix_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetoptionsprefix_ MATGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetoptionsprefix_ matgetoptionsprefix
#endif
PETSC_EXTERN void matgetoptionsprefix_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = MatGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetstate_ MATGETSTATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetstate_ matgetstate
#endif
PETSC_EXTERN void matgetstate_(Mat *a, PetscObjectState *b, PetscErrorCode *ierr)
{
  *ierr = MatGetState(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matresetpreallocation_ MATRESETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matresetpreallocation_ matresetpreallocation
#endif
PETSC_EXTERN void matresetpreallocation_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatResetPreallocation(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matresethash_ MATRESETHASH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matresethash_ matresethash
#endif
PETSC_EXTERN void matresethash_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatResetHash(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetup_ MATSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetup_ matsetup
#endif
PETSC_EXTERN void matsetup_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matviewfromoptions_ MATVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matviewfromoptions_ matviewfromoptions
#endif
PETSC_EXTERN void matviewfromoptions_(Mat *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = MatViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matview_ MATVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matview_ matview
#endif
PETSC_EXTERN void matview_(Mat *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matload_ MATLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matload_ matload
#endif
PETSC_EXTERN void matload_(Mat *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdestroy_ MATDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdestroy_ matdestroy
#endif
PETSC_EXTERN void matdestroy_(Mat *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvalues_ MATSETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvalues_ matsetvalues
#endif
PETSC_EXTERN void matsetvalues_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatSetValues(*a, *b, c, *d, e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesis_ MATSETVALUESIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesis_ matsetvaluesis
#endif
PETSC_EXTERN void matsetvaluesis_(Mat *a, IS *b, IS *c, const PetscScalar d[], InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatSetValuesIS(*a, *b, *c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesrowlocal_ MATSETVALUESROWLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesrowlocal_ matsetvaluesrowlocal
#endif
PETSC_EXTERN void matsetvaluesrowlocal_(Mat *a, PetscInt *b, const PetscScalar c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = MatSetValuesRowLocal(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesrow_ MATSETVALUESROW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesrow_ matsetvaluesrow
#endif
PETSC_EXTERN void matsetvaluesrow_(Mat *a, PetscInt *b, const PetscScalar c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = MatSetValuesRow(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesstencil_ MATSETVALUESSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesstencil_ matsetvaluesstencil
#endif
PETSC_EXTERN void matsetvaluesstencil_(Mat *a, PetscInt *b, const MatStencil c[], PetscInt *d, const MatStencil e[], const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatSetValuesStencil(*a, *b, c, *d, e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesblockedstencil_ MATSETVALUESBLOCKEDSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesblockedstencil_ matsetvaluesblockedstencil
#endif
PETSC_EXTERN void matsetvaluesblockedstencil_(Mat *a, PetscInt *b, const MatStencil c[], PetscInt *d, const MatStencil e[], const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatSetValuesBlockedStencil(*a, *b, c, *d, e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetstencil_ MATSETSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetstencil_ matsetstencil
#endif
PETSC_EXTERN void matsetstencil_(Mat *a, PetscInt *b, const PetscInt c[], const PetscInt d[], PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = MatSetStencil(*a, *b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesblocked_ MATSETVALUESBLOCKED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesblocked_ matsetvaluesblocked
#endif
PETSC_EXTERN void matsetvaluesblocked_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatSetValuesBlocked(*a, *b, c, *d, e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetvalues_ MATGETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetvalues_ matgetvalues
#endif
PETSC_EXTERN void matgetvalues_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], PetscScalar f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatGetValues(*a, *b, c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetvalueslocal_ MATGETVALUESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetvalueslocal_ matgetvalueslocal
#endif
PETSC_EXTERN void matgetvalueslocal_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], PetscScalar f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatGetValuesLocal(*a, *b, c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesbatch_ MATSETVALUESBATCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesbatch_ matsetvaluesbatch
#endif
PETSC_EXTERN void matsetvaluesbatch_(Mat *a, PetscInt *b, PetscInt *c, PetscInt d[], const PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLSCALAR(e);
  *ierr = MatSetValuesBatch(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetlocaltoglobalmapping_ MATSETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetlocaltoglobalmapping_ matsetlocaltoglobalmapping
#endif
PETSC_EXTERN void matsetlocaltoglobalmapping_(Mat *a, ISLocalToGlobalMapping *b, ISLocalToGlobalMapping *c, PetscErrorCode *ierr)
{
  *ierr = MatSetLocalToGlobalMapping(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetlocaltoglobalmapping_ MATGETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetlocaltoglobalmapping_ matgetlocaltoglobalmapping
#endif
PETSC_EXTERN void matgetlocaltoglobalmapping_(Mat *a, ISLocalToGlobalMapping *b, ISLocalToGlobalMapping *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatGetLocalToGlobalMapping(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetlayouts_ MATSETLAYOUTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetlayouts_ matsetlayouts
#endif
PETSC_EXTERN void matsetlayouts_(Mat *a, PetscLayout *b, PetscLayout *c, PetscErrorCode *ierr)
{
  *ierr = MatSetLayouts(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetlayouts_ MATGETLAYOUTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetlayouts_ matgetlayouts
#endif
PETSC_EXTERN void matgetlayouts_(Mat *a, PetscLayout *b, PetscLayout *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatGetLayouts(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvalueslocal_ MATSETVALUESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvalueslocal_ matsetvalueslocal
#endif
PETSC_EXTERN void matsetvalueslocal_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatSetValuesLocal(*a, *b, c, *d, e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluesblockedlocal_ MATSETVALUESBLOCKEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluesblockedlocal_ matsetvaluesblockedlocal
#endif
PETSC_EXTERN void matsetvaluesblockedlocal_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatSetValuesBlockedLocal(*a, *b, c, *d, e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmultdiagonalblock_ MATMULTDIAGONALBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmultdiagonalblock_ matmultdiagonalblock
#endif
PETSC_EXTERN void matmultdiagonalblock_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatMultDiagonalBlock(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmult_ MATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmult_ matmult
#endif
PETSC_EXTERN void matmult_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatMult(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulttranspose_ MATMULTTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulttranspose_ matmulttranspose
#endif
PETSC_EXTERN void matmulttranspose_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatMultTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulthermitiantranspose_ MATMULTHERMITIANTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulthermitiantranspose_ matmulthermitiantranspose
#endif
PETSC_EXTERN void matmulthermitiantranspose_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatMultHermitianTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmultadd_ MATMULTADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmultadd_ matmultadd
#endif
PETSC_EXTERN void matmultadd_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = MatMultAdd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulttransposeadd_ MATMULTTRANSPOSEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulttransposeadd_ matmulttransposeadd
#endif
PETSC_EXTERN void matmulttransposeadd_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = MatMultTransposeAdd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulthermitiantransposeadd_ MATMULTHERMITIANTRANSPOSEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulthermitiantransposeadd_ matmulthermitiantransposeadd
#endif
PETSC_EXTERN void matmulthermitiantransposeadd_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = MatMultHermitianTransposeAdd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetfactortype_ MATGETFACTORTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetfactortype_ matgetfactortype
#endif
PETSC_EXTERN void matgetfactortype_(Mat *a, MatFactorType *b, PetscErrorCode *ierr)
{
  *ierr = MatGetFactorType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetfactortype_ MATSETFACTORTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetfactortype_ matsetfactortype
#endif
PETSC_EXTERN void matsetfactortype_(Mat *a, MatFactorType *b, PetscErrorCode *ierr)
{
  *ierr = MatSetFactorType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetinfo_ MATGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetinfo_ matgetinfo
#endif
PETSC_EXTERN void matgetinfo_(Mat *a, MatInfoType *b, MatInfo *c, PetscErrorCode *ierr)
{
  *ierr = MatGetInfo(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlufactor_ MATLUFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlufactor_ matlufactor
#endif
PETSC_EXTERN void matlufactor_(Mat *a, IS *b, IS *c, const MatFactorInfo *d, PetscErrorCode *ierr)
{
  *ierr = MatLUFactor(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matilufactor_ MATILUFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matilufactor_ matilufactor
#endif
PETSC_EXTERN void matilufactor_(Mat *a, IS *b, IS *c, const MatFactorInfo *d, PetscErrorCode *ierr)
{
  *ierr = MatILUFactor(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlufactorsymbolic_ MATLUFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlufactorsymbolic_ matlufactorsymbolic
#endif
PETSC_EXTERN void matlufactorsymbolic_(Mat *a, Mat *b, IS *c, IS *d, const MatFactorInfo *e, PetscErrorCode *ierr)
{
  *ierr = MatLUFactorSymbolic(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlufactornumeric_ MATLUFACTORNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlufactornumeric_ matlufactornumeric
#endif
PETSC_EXTERN void matlufactornumeric_(Mat *a, Mat *b, const MatFactorInfo *c, PetscErrorCode *ierr)
{
  *ierr = MatLUFactorNumeric(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcholeskyfactor_ MATCHOLESKYFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcholeskyfactor_ matcholeskyfactor
#endif
PETSC_EXTERN void matcholeskyfactor_(Mat *a, IS *b, const MatFactorInfo *c, PetscErrorCode *ierr)
{
  *ierr = MatCholeskyFactor(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcholeskyfactorsymbolic_ MATCHOLESKYFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcholeskyfactorsymbolic_ matcholeskyfactorsymbolic
#endif
PETSC_EXTERN void matcholeskyfactorsymbolic_(Mat *a, Mat *b, IS *c, const MatFactorInfo *d, PetscErrorCode *ierr)
{
  *ierr = MatCholeskyFactorSymbolic(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcholeskyfactornumeric_ MATCHOLESKYFACTORNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcholeskyfactornumeric_ matcholeskyfactornumeric
#endif
PETSC_EXTERN void matcholeskyfactornumeric_(Mat *a, Mat *b, const MatFactorInfo *c, PetscErrorCode *ierr)
{
  *ierr = MatCholeskyFactorNumeric(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matqrfactor_ MATQRFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matqrfactor_ matqrfactor
#endif
PETSC_EXTERN void matqrfactor_(Mat *a, IS *b, const MatFactorInfo *c, PetscErrorCode *ierr)
{
  *ierr = MatQRFactor(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matqrfactorsymbolic_ MATQRFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matqrfactorsymbolic_ matqrfactorsymbolic
#endif
PETSC_EXTERN void matqrfactorsymbolic_(Mat *a, Mat *b, IS *c, const MatFactorInfo *d, PetscErrorCode *ierr)
{
  *ierr = MatQRFactorSymbolic(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matqrfactornumeric_ MATQRFACTORNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matqrfactornumeric_ matqrfactornumeric
#endif
PETSC_EXTERN void matqrfactornumeric_(Mat *a, Mat *b, const MatFactorInfo *c, PetscErrorCode *ierr)
{
  *ierr = MatQRFactorNumeric(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsolve_ MATSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsolve_ matsolve
#endif
PETSC_EXTERN void matsolve_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatsolve_ MATMATSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatsolve_ matmatsolve
#endif
PETSC_EXTERN void matmatsolve_(Mat *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = MatMatSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatsolvetranspose_ MATMATSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatsolvetranspose_ matmatsolvetranspose
#endif
PETSC_EXTERN void matmatsolvetranspose_(Mat *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = MatMatSolveTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmattransposesolve_ MATMATTRANSPOSESOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmattransposesolve_ matmattransposesolve
#endif
PETSC_EXTERN void matmattransposesolve_(Mat *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = MatMatTransposeSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matforwardsolve_ MATFORWARDSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matforwardsolve_ matforwardsolve
#endif
PETSC_EXTERN void matforwardsolve_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatForwardSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matbackwardsolve_ MATBACKWARDSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matbackwardsolve_ matbackwardsolve
#endif
PETSC_EXTERN void matbackwardsolve_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatBackwardSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsolveadd_ MATSOLVEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsolveadd_ matsolveadd
#endif
PETSC_EXTERN void matsolveadd_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = MatSolveAdd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsolvetranspose_ MATSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsolvetranspose_ matsolvetranspose
#endif
PETSC_EXTERN void matsolvetranspose_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatSolveTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsolvetransposeadd_ MATSOLVETRANSPOSEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsolvetransposeadd_ matsolvetransposeadd
#endif
PETSC_EXTERN void matsolvetransposeadd_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = MatSolveTransposeAdd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsor_ MATSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsor_ matsor
#endif
PETSC_EXTERN void matsor_(Mat *a, Vec *b, PetscReal *c, MatSORType *d, PetscReal *e, PetscInt *f, PetscInt *g, Vec *h, PetscErrorCode *ierr)
{
  *ierr = MatSOR(*a, *b, *c, *d, *e, *f, *g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcopy_ MATCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcopy_ matcopy
#endif
PETSC_EXTERN void matcopy_(Mat *a, Mat *b, MatStructure *c, PetscErrorCode *ierr)
{
  *ierr = MatCopy(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matconvert_ MATCONVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matconvert_ matconvert
#endif
PETSC_EXTERN void matconvert_(Mat *a, char * b, MatReuse *c, Mat *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatConvert(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorgetsolvertype_ MATFACTORGETSOLVERTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorgetsolvertype_ matfactorgetsolvertype
#endif
PETSC_EXTERN void matfactorgetsolvertype_(Mat *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = MatFactorGetSolverType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorgetcanuseordering_ MATFACTORGETCANUSEORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorgetcanuseordering_ matfactorgetcanuseordering
#endif
PETSC_EXTERN void matfactorgetcanuseordering_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatFactorGetCanUseOrdering(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorgetpreferredordering_ MATFACTORGETPREFERREDORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorgetpreferredordering_ matfactorgetpreferredordering
#endif
PETSC_EXTERN void matfactorgetpreferredordering_(Mat *a, MatFactorType *b, char * c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = MatFactorGetPreferredOrdering(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetfactor_ MATGETFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetfactor_ matgetfactor
#endif
PETSC_EXTERN void matgetfactor_(Mat *a, char * b, MatFactorType *c, Mat *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatGetFactor(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetfactoravailable_ MATGETFACTORAVAILABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetfactoravailable_ matgetfactoravailable
#endif
PETSC_EXTERN void matgetfactoravailable_(Mat *a, char * b, MatFactorType *c, PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(d);
  *ierr = MatGetFactorAvailable(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matduplicate_ MATDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matduplicate_ matduplicate
#endif
PETSC_EXTERN void matduplicate_(Mat *a, MatDuplicateOption *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatDuplicate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetdiagonal_ MATGETDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetdiagonal_ matgetdiagonal
#endif
PETSC_EXTERN void matgetdiagonal_(Mat *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = MatGetDiagonal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetrowmin_ MATGETROWMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetrowmin_ matgetrowmin
#endif
PETSC_EXTERN void matgetrowmin_(Mat *a, Vec *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetRowMin(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetrowminabs_ MATGETROWMINABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetrowminabs_ matgetrowminabs
#endif
PETSC_EXTERN void matgetrowminabs_(Mat *a, Vec *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetRowMinAbs(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetrowmax_ MATGETROWMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetrowmax_ matgetrowmax
#endif
PETSC_EXTERN void matgetrowmax_(Mat *a, Vec *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetRowMax(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetrowmaxabs_ MATGETROWMAXABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetrowmaxabs_ matgetrowmaxabs
#endif
PETSC_EXTERN void matgetrowmaxabs_(Mat *a, Vec *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetRowMaxAbs(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetrowsumabs_ MATGETROWSUMABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetrowsumabs_ matgetrowsumabs
#endif
PETSC_EXTERN void matgetrowsumabs_(Mat *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = MatGetRowSumAbs(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetrowsum_ MATGETROWSUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetrowsum_ matgetrowsum
#endif
PETSC_EXTERN void matgetrowsum_(Mat *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = MatGetRowSum(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattransposesetprecursor_ MATTRANSPOSESETPRECURSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattransposesetprecursor_ mattransposesetprecursor
#endif
PETSC_EXTERN void mattransposesetprecursor_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatTransposeSetPrecursor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattranspose_ MATTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattranspose_ mattranspose
#endif
PETSC_EXTERN void mattranspose_(Mat *a, MatReuse *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatTranspose(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattransposesymbolic_ MATTRANSPOSESYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattransposesymbolic_ mattransposesymbolic
#endif
PETSC_EXTERN void mattransposesymbolic_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatTransposeSymbolic(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matistranspose_ MATISTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matistranspose_ matistranspose
#endif
PETSC_EXTERN void matistranspose_(Mat *a, Mat *b, PetscReal *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatIsTranspose(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mathermitiantranspose_ MATHERMITIANTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mathermitiantranspose_ mathermitiantranspose
#endif
PETSC_EXTERN void mathermitiantranspose_(Mat *a, MatReuse *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatHermitianTranspose(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matishermitiantranspose_ MATISHERMITIANTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matishermitiantranspose_ matishermitiantranspose
#endif
PETSC_EXTERN void matishermitiantranspose_(Mat *a, Mat *b, PetscReal *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatIsHermitianTranspose(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpermute_ MATPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpermute_ matpermute
#endif
PETSC_EXTERN void matpermute_(Mat *a, IS *b, IS *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatPermute(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matequal_ MATEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matequal_ matequal
#endif
PETSC_EXTERN void matequal_(Mat *a, Mat *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = MatEqual(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdiagonalscale_ MATDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdiagonalscale_ matdiagonalscale
#endif
PETSC_EXTERN void matdiagonalscale_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatDiagonalScale(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matscale_ MATSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matscale_ matscale
#endif
PETSC_EXTERN void matscale_(Mat *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = MatScale(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnorm_ MATNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnorm_ matnorm
#endif
PETSC_EXTERN void matnorm_(Mat *a, NormType *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = MatNorm(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matassemblybegin_ MATASSEMBLYBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matassemblybegin_ matassemblybegin
#endif
PETSC_EXTERN void matassemblybegin_(Mat *a, MatAssemblyType *b, PetscErrorCode *ierr)
{
  *ierr = MatAssemblyBegin(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matassembled_ MATASSEMBLED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matassembled_ matassembled
#endif
PETSC_EXTERN void matassembled_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatAssembled(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matassemblyend_ MATASSEMBLYEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matassemblyend_ matassemblyend
#endif
PETSC_EXTERN void matassemblyend_(Mat *a, MatAssemblyType *b, PetscErrorCode *ierr)
{
  *ierr = MatAssemblyEnd(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetoption_ MATSETOPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetoption_ matsetoption
#endif
PETSC_EXTERN void matsetoption_(Mat *a, MatOption *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = MatSetOption(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetoption_ MATGETOPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetoption_ matgetoption
#endif
PETSC_EXTERN void matgetoption_(Mat *a, MatOption *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = MatGetOption(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzeroentries_ MATZEROENTRIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzeroentries_ matzeroentries
#endif
PETSC_EXTERN void matzeroentries_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatZeroEntries(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowscolumns_ MATZEROROWSCOLUMNS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowscolumns_ matzerorowscolumns
#endif
PETSC_EXTERN void matzerorowscolumns_(Mat *a, PetscInt *b, const PetscInt c[], PetscScalar *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatZeroRowsColumns(*a, *b, c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowscolumnsis_ MATZEROROWSCOLUMNSIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowscolumnsis_ matzerorowscolumnsis
#endif
PETSC_EXTERN void matzerorowscolumnsis_(Mat *a, IS *b, PetscScalar *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = MatZeroRowsColumnsIS(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorows_ MATZEROROWS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorows_ matzerorows
#endif
PETSC_EXTERN void matzerorows_(Mat *a, PetscInt *b, const PetscInt c[], PetscScalar *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatZeroRows(*a, *b, c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowsis_ MATZEROROWSIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowsis_ matzerorowsis
#endif
PETSC_EXTERN void matzerorowsis_(Mat *a, IS *b, PetscScalar *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = MatZeroRowsIS(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowsstencil_ MATZEROROWSSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowsstencil_ matzerorowsstencil
#endif
PETSC_EXTERN void matzerorowsstencil_(Mat *a, PetscInt *b, const MatStencil c[], PetscScalar *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = MatZeroRowsStencil(*a, *b, c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowscolumnsstencil_ MATZEROROWSCOLUMNSSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowscolumnsstencil_ matzerorowscolumnsstencil
#endif
PETSC_EXTERN void matzerorowscolumnsstencil_(Mat *a, PetscInt *b, const MatStencil c[], PetscScalar *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = MatZeroRowsColumnsStencil(*a, *b, c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowslocal_ MATZEROROWSLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowslocal_ matzerorowslocal
#endif
PETSC_EXTERN void matzerorowslocal_(Mat *a, PetscInt *b, const PetscInt c[], PetscScalar *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatZeroRowsLocal(*a, *b, c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowslocalis_ MATZEROROWSLOCALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowslocalis_ matzerorowslocalis
#endif
PETSC_EXTERN void matzerorowslocalis_(Mat *a, IS *b, PetscScalar *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = MatZeroRowsLocalIS(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowscolumnslocal_ MATZEROROWSCOLUMNSLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowscolumnslocal_ matzerorowscolumnslocal
#endif
PETSC_EXTERN void matzerorowscolumnslocal_(Mat *a, PetscInt *b, const PetscInt c[], PetscScalar *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatZeroRowsColumnsLocal(*a, *b, c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matzerorowscolumnslocalis_ MATZEROROWSCOLUMNSLOCALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matzerorowscolumnslocalis_ matzerorowscolumnslocalis
#endif
PETSC_EXTERN void matzerorowscolumnslocalis_(Mat *a, IS *b, PetscScalar *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = MatZeroRowsColumnsLocalIS(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetsize_ MATGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetsize_ matgetsize
#endif
PETSC_EXTERN void matgetsize_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetSize(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetlocalsize_ MATGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetlocalsize_ matgetlocalsize
#endif
PETSC_EXTERN void matgetlocalsize_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetLocalSize(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetownershiprangecolumn_ MATGETOWNERSHIPRANGECOLUMN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetownershiprangecolumn_ matgetownershiprangecolumn
#endif
PETSC_EXTERN void matgetownershiprangecolumn_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetOwnershipRangeColumn(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetownershiprange_ MATGETOWNERSHIPRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetownershiprange_ matgetownershiprange
#endif
PETSC_EXTERN void matgetownershiprange_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetOwnershipRange(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetownershipis_ MATGETOWNERSHIPIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetownershipis_ matgetownershipis
#endif
PETSC_EXTERN void matgetownershipis_(Mat *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatGetOwnershipIS(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matilufactorsymbolic_ MATILUFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matilufactorsymbolic_ matilufactorsymbolic
#endif
PETSC_EXTERN void matilufactorsymbolic_(Mat *a, Mat *b, IS *c, IS *d, const MatFactorInfo *e, PetscErrorCode *ierr)
{
  *ierr = MatILUFactorSymbolic(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define maticcfactorsymbolic_ MATICCFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define maticcfactorsymbolic_ maticcfactorsymbolic
#endif
PETSC_EXTERN void maticcfactorsymbolic_(Mat *a, Mat *b, IS *c, const MatFactorInfo *d, PetscErrorCode *ierr)
{
  *ierr = MatICCFactorSymbolic(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetseqnonzerostructure_ MATGETSEQNONZEROSTRUCTURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetseqnonzerostructure_ matgetseqnonzerostructure
#endif
PETSC_EXTERN void matgetseqnonzerostructure_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatGetSeqNonzeroStructure(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdestroyseqnonzerostructure_ MATDESTROYSEQNONZEROSTRUCTURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdestroyseqnonzerostructure_ matdestroyseqnonzerostructure
#endif
PETSC_EXTERN void matdestroyseqnonzerostructure_(Mat *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatDestroySeqNonzeroStructure(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matincreaseoverlap_ MATINCREASEOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matincreaseoverlap_ matincreaseoverlap
#endif
PETSC_EXTERN void matincreaseoverlap_(Mat *a, PetscInt *b, IS c[], PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = MatIncreaseOverlap(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matincreaseoverlapsplit_ MATINCREASEOVERLAPSPLIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matincreaseoverlapsplit_ matincreaseoverlapsplit
#endif
PETSC_EXTERN void matincreaseoverlapsplit_(Mat *a, PetscInt *b, IS c[], PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = MatIncreaseOverlapSplit(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetblocksize_ MATGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetblocksize_ matgetblocksize
#endif
PETSC_EXTERN void matgetblocksize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetblocksizes_ MATGETBLOCKSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetblocksizes_ matgetblocksizes
#endif
PETSC_EXTERN void matgetblocksizes_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatGetBlockSizes(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetblocksize_ MATSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetblocksize_ matsetblocksize
#endif
PETSC_EXTERN void matsetblocksize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcomputevariableblockenvelope_ MATCOMPUTEVARIABLEBLOCKENVELOPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcomputevariableblockenvelope_ matcomputevariableblockenvelope
#endif
PETSC_EXTERN void matcomputevariableblockenvelope_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatComputeVariableBlockEnvelope(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matinvertvariableblockenvelope_ MATINVERTVARIABLEBLOCKENVELOPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matinvertvariableblockenvelope_ matinvertvariableblockenvelope
#endif
PETSC_EXTERN void matinvertvariableblockenvelope_(Mat *a, MatReuse *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatInvertVariableBlockEnvelope(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvariableblocksizes_ MATSETVARIABLEBLOCKSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvariableblocksizes_ matsetvariableblocksizes
#endif
PETSC_EXTERN void matsetvariableblocksizes_(Mat *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatSetVariableBlockSizes(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetblocksizes_ MATSETBLOCKSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetblocksizes_ matsetblocksizes
#endif
PETSC_EXTERN void matsetblocksizes_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = MatSetBlockSizes(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetblocksizesfrommats_ MATSETBLOCKSIZESFROMMATS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetblocksizesfrommats_ matsetblocksizesfrommats
#endif
PETSC_EXTERN void matsetblocksizesfrommats_(Mat *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = MatSetBlockSizesFromMats(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matresidual_ MATRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matresidual_ matresidual
#endif
PETSC_EXTERN void matresidual_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = MatResidual(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetunfactored_ MATSETUNFACTORED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetunfactored_ matsetunfactored
#endif
PETSC_EXTERN void matsetunfactored_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatSetUnfactored(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatesubmatrix_ MATCREATESUBMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatesubmatrix_ matcreatesubmatrix
#endif
PETSC_EXTERN void matcreatesubmatrix_(Mat *a, IS *b, IS *c, MatReuse *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatCreateSubMatrix(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpropagatesymmetryoptions_ MATPROPAGATESYMMETRYOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpropagatesymmetryoptions_ matpropagatesymmetryoptions
#endif
PETSC_EXTERN void matpropagatesymmetryoptions_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatPropagateSymmetryOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstashsetinitialsize_ MATSTASHSETINITIALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstashsetinitialsize_ matstashsetinitialsize
#endif
PETSC_EXTERN void matstashsetinitialsize_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = MatStashSetInitialSize(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matinterpolateadd_ MATINTERPOLATEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matinterpolateadd_ matinterpolateadd
#endif
PETSC_EXTERN void matinterpolateadd_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = MatInterpolateAdd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matinterpolate_ MATINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matinterpolate_ matinterpolate
#endif
PETSC_EXTERN void matinterpolate_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatInterpolate(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matrestrict_ MATRESTRICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matrestrict_ matrestrict
#endif
PETSC_EXTERN void matrestrict_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatRestrict(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatinterpolateadd_ MATMATINTERPOLATEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatinterpolateadd_ matmatinterpolateadd
#endif
PETSC_EXTERN void matmatinterpolateadd_(Mat *a, Mat *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatMatInterpolateAdd(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatinterpolate_ MATMATINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatinterpolate_ matmatinterpolate
#endif
PETSC_EXTERN void matmatinterpolate_(Mat *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatMatInterpolate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatrestrict_ MATMATRESTRICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatrestrict_ matmatrestrict
#endif
PETSC_EXTERN void matmatrestrict_(Mat *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatMatRestrict(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetnullspace_ MATGETNULLSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetnullspace_ matgetnullspace
#endif
PETSC_EXTERN void matgetnullspace_(Mat *a, MatNullSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatGetNullSpace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetnullspace_ MATSETNULLSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetnullspace_ matsetnullspace
#endif
PETSC_EXTERN void matsetnullspace_(Mat *a, MatNullSpace *b, PetscErrorCode *ierr)
{
  *ierr = MatSetNullSpace(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgettransposenullspace_ MATGETTRANSPOSENULLSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgettransposenullspace_ matgettransposenullspace
#endif
PETSC_EXTERN void matgettransposenullspace_(Mat *a, MatNullSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatGetTransposeNullSpace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsettransposenullspace_ MATSETTRANSPOSENULLSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsettransposenullspace_ matsettransposenullspace
#endif
PETSC_EXTERN void matsettransposenullspace_(Mat *a, MatNullSpace *b, PetscErrorCode *ierr)
{
  *ierr = MatSetTransposeNullSpace(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetnearnullspace_ MATSETNEARNULLSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetnearnullspace_ matsetnearnullspace
#endif
PETSC_EXTERN void matsetnearnullspace_(Mat *a, MatNullSpace *b, PetscErrorCode *ierr)
{
  *ierr = MatSetNearNullSpace(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetnearnullspace_ MATGETNEARNULLSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetnearnullspace_ matgetnearnullspace
#endif
PETSC_EXTERN void matgetnearnullspace_(Mat *a, MatNullSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatGetNearNullSpace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define maticcfactor_ MATICCFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define maticcfactor_ maticcfactor
#endif
PETSC_EXTERN void maticcfactor_(Mat *a, IS *b, const MatFactorInfo *c, PetscErrorCode *ierr)
{
  *ierr = MatICCFactor(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdiagonalscalelocal_ MATDIAGONALSCALELOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdiagonalscalelocal_ matdiagonalscalelocal
#endif
PETSC_EXTERN void matdiagonalscalelocal_(Mat *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = MatDiagonalScaleLocal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetinertia_ MATGETINERTIA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetinertia_ matgetinertia
#endif
PETSC_EXTERN void matgetinertia_(Mat *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = MatGetInertia(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsolves_ MATSOLVES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsolves_ matsolves
#endif
PETSC_EXTERN void matsolves_(Mat *a, Vecs *b, Vecs *c, PetscErrorCode *ierr)
{
  *ierr = MatSolves(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matissymmetric_ MATISSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matissymmetric_ matissymmetric
#endif
PETSC_EXTERN void matissymmetric_(Mat *a, PetscReal *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = MatIsSymmetric(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matishermitian_ MATISHERMITIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matishermitian_ matishermitian
#endif
PETSC_EXTERN void matishermitian_(Mat *a, PetscReal *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = MatIsHermitian(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matissymmetricknown_ MATISSYMMETRICKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matissymmetricknown_ matissymmetricknown
#endif
PETSC_EXTERN void matissymmetricknown_(Mat *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = MatIsSymmetricKnown(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisspdknown_ MATISSPDKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisspdknown_ matisspdknown
#endif
PETSC_EXTERN void matisspdknown_(Mat *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = MatIsSPDKnown(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matishermitianknown_ MATISHERMITIANKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matishermitianknown_ matishermitianknown
#endif
PETSC_EXTERN void matishermitianknown_(Mat *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = MatIsHermitianKnown(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisstructurallysymmetric_ MATISSTRUCTURALLYSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisstructurallysymmetric_ matisstructurallysymmetric
#endif
PETSC_EXTERN void matisstructurallysymmetric_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatIsStructurallySymmetric(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisstructurallysymmetricknown_ MATISSTRUCTURALLYSYMMETRICKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisstructurallysymmetricknown_ matisstructurallysymmetricknown
#endif
PETSC_EXTERN void matisstructurallysymmetricknown_(Mat *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = MatIsStructurallySymmetricKnown(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstashgetinfo_ MATSTASHGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstashgetinfo_ matstashgetinfo
#endif
PETSC_EXTERN void matstashgetinfo_(Mat *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = MatStashGetInfo(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatevecs_ MATCREATEVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatevecs_ matcreatevecs
#endif
PETSC_EXTERN void matcreatevecs_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatCreateVecs(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorinfoinitialize_ MATFACTORINFOINITIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorinfoinitialize_ matfactorinfoinitialize
#endif
PETSC_EXTERN void matfactorinfoinitialize_(MatFactorInfo *a, PetscErrorCode *ierr)
{
  *ierr = MatFactorInfoInitialize(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorsetschuris_ MATFACTORSETSCHURIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorsetschuris_ matfactorsetschuris
#endif
PETSC_EXTERN void matfactorsetschuris_(Mat *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = MatFactorSetSchurIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorcreateschurcomplement_ MATFACTORCREATESCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorcreateschurcomplement_ matfactorcreateschurcomplement
#endif
PETSC_EXTERN void matfactorcreateschurcomplement_(Mat *a, Mat *b, MatFactorSchurStatus *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatFactorCreateSchurComplement(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorgetschurcomplement_ MATFACTORGETSCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorgetschurcomplement_ matfactorgetschurcomplement
#endif
PETSC_EXTERN void matfactorgetschurcomplement_(Mat *a, Mat *b, MatFactorSchurStatus *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatFactorGetSchurComplement(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorrestoreschurcomplement_ MATFACTORRESTORESCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorrestoreschurcomplement_ matfactorrestoreschurcomplement
#endif
PETSC_EXTERN void matfactorrestoreschurcomplement_(Mat *a, Mat *b, MatFactorSchurStatus *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatFactorRestoreSchurComplement(*a, b, *c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorsolveschurcomplementtranspose_ MATFACTORSOLVESCHURCOMPLEMENTTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorsolveschurcomplementtranspose_ matfactorsolveschurcomplementtranspose
#endif
PETSC_EXTERN void matfactorsolveschurcomplementtranspose_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatFactorSolveSchurComplementTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorsolveschurcomplement_ MATFACTORSOLVESCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorsolveschurcomplement_ matfactorsolveschurcomplement
#endif
PETSC_EXTERN void matfactorsolveschurcomplement_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatFactorSolveSchurComplement(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorinvertschurcomplement_ MATFACTORINVERTSCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorinvertschurcomplement_ matfactorinvertschurcomplement
#endif
PETSC_EXTERN void matfactorinvertschurcomplement_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatFactorInvertSchurComplement(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfactorfactorizeschurcomplement_ MATFACTORFACTORIZESCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfactorfactorizeschurcomplement_ matfactorfactorizeschurcomplement
#endif
PETSC_EXTERN void matfactorfactorizeschurcomplement_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatFactorFactorizeSchurComplement(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matptap_ MATPTAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matptap_ matptap
#endif
PETSC_EXTERN void matptap_(Mat *a, Mat *b, MatReuse *c, PetscReal *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatPtAP(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matrart_ MATRART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matrart_ matrart
#endif
PETSC_EXTERN void matrart_(Mat *a, Mat *b, MatReuse *c, PetscReal *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatRARt(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatmult_ MATMATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatmult_ matmatmult
#endif
PETSC_EXTERN void matmatmult_(Mat *a, Mat *b, MatReuse *c, PetscReal *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatMatMult(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmattransposemult_ MATMATTRANSPOSEMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmattransposemult_ matmattransposemult
#endif
PETSC_EXTERN void matmattransposemult_(Mat *a, Mat *b, MatReuse *c, PetscReal *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatMatTransposeMult(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattransposematmult_ MATTRANSPOSEMATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattransposematmult_ mattransposematmult
#endif
PETSC_EXTERN void mattransposematmult_(Mat *a, Mat *b, MatReuse *c, PetscReal *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatTransposeMatMult(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatmatmult_ MATMATMATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatmatmult_ matmatmatmult
#endif
PETSC_EXTERN void matmatmatmult_(Mat *a, Mat *b, Mat *c, MatReuse *d, PetscReal *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatMatMatMult(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateredundantmatrix_ MATCREATEREDUNDANTMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateredundantmatrix_ matcreateredundantmatrix
#endif
PETSC_EXTERN void matcreateredundantmatrix_(Mat *a, PetscInt *b, MPI_Fint *c, MatReuse *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatCreateRedundantMatrix(*a, *b, MPI_Comm_f2c(*(c)), *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetmultiprocblock_ MATGETMULTIPROCBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetmultiprocblock_ matgetmultiprocblock
#endif
PETSC_EXTERN void matgetmultiprocblock_(Mat *a, MPI_Fint *b, MatReuse *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatGetMultiProcBlock(*a, MPI_Comm_f2c(*(b)), *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetlocalsubmatrix_ MATGETLOCALSUBMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetlocalsubmatrix_ matgetlocalsubmatrix
#endif
PETSC_EXTERN void matgetlocalsubmatrix_(Mat *a, IS *b, IS *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatGetLocalSubMatrix(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matrestorelocalsubmatrix_ MATRESTORELOCALSUBMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matrestorelocalsubmatrix_ matrestorelocalsubmatrix
#endif
PETSC_EXTERN void matrestorelocalsubmatrix_(Mat *a, IS *b, IS *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatRestoreLocalSubMatrix(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfindzerodiagonals_ MATFINDZERODIAGONALS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfindzerodiagonals_ matfindzerodiagonals
#endif
PETSC_EXTERN void matfindzerodiagonals_(Mat *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatFindZeroDiagonals(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfindoffblockdiagonalentries_ MATFINDOFFBLOCKDIAGONALENTRIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfindoffblockdiagonalentries_ matfindoffblockdiagonalentries
#endif
PETSC_EXTERN void matfindoffblockdiagonalentries_(Mat *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatFindOffBlockDiagonalEntries(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matinvertvariableblockdiagonal_ MATINVERTVARIABLEBLOCKDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matinvertvariableblockdiagonal_ matinvertvariableblockdiagonal
#endif
PETSC_EXTERN void matinvertvariableblockdiagonal_(Mat *a, PetscInt *b, const PetscInt c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatInvertVariableBlockDiagonal(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matinvertblockdiagonalmat_ MATINVERTBLOCKDIAGONALMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matinvertblockdiagonalmat_ matinvertblockdiagonalmat
#endif
PETSC_EXTERN void matinvertblockdiagonalmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatInvertBlockDiagonalMat(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattranscoloringapplysptoden_ MATTRANSCOLORINGAPPLYSPTODEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattranscoloringapplysptoden_ mattranscoloringapplysptoden
#endif
PETSC_EXTERN void mattranscoloringapplysptoden_(MatTransposeColoring *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = MatTransColoringApplySpToDen(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattranscoloringapplydentosp_ MATTRANSCOLORINGAPPLYDENTOSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattranscoloringapplydentosp_ mattranscoloringapplydentosp
#endif
PETSC_EXTERN void mattranscoloringapplydentosp_(MatTransposeColoring *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = MatTransColoringApplyDenToSp(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetnonzerostate_ MATGETNONZEROSTATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetnonzerostate_ matgetnonzerostate
#endif
PETSC_EXTERN void matgetnonzerostate_(Mat *a, PetscObjectState *b, PetscErrorCode *ierr)
{
  *ierr = MatGetNonzeroState(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempimatconcatenateseqmat_ MATCREATEMPIMATCONCATENATESEQMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempimatconcatenateseqmat_ matcreatempimatconcatenateseqmat
#endif
PETSC_EXTERN void matcreatempimatconcatenateseqmat_(MPI_Fint *a, Mat *b, PetscInt *c, MatReuse *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatCreateMPIMatConcatenateSeqMat(MPI_Comm_f2c(*(a)), *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgalerkin_ MATGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgalerkin_ matgalerkin
#endif
PETSC_EXTERN void matgalerkin_(Mat *a, Mat *b, Mat *c, MatReuse *d, PetscReal *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatGalerkin(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mathasoperation_ MATHASOPERATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mathasoperation_ mathasoperation
#endif
PETSC_EXTERN void mathasoperation_(Mat *a, MatOperation *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = MatHasOperation(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mathascongruentlayouts_ MATHASCONGRUENTLAYOUTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mathascongruentlayouts_ mathascongruentlayouts
#endif
PETSC_EXTERN void mathascongruentlayouts_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatHasCongruentLayouts(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetinf_ MATSETINF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetinf_ matsetinf
#endif
PETSC_EXTERN void matsetinf_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatSetInf(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreategraph_ MATCREATEGRAPH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreategraph_ matcreategraph
#endif
PETSC_EXTERN void matcreategraph_(Mat *a, PetscBool *b, PetscBool *c, PetscReal *d, PetscInt *e, PetscInt f[], Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateGraph(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mateliminatezeros_ MATELIMINATEZEROS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mateliminatezeros_ mateliminatezeros
#endif
PETSC_EXTERN void mateliminatezeros_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatEliminateZeros(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringpatch_ MATCOLORINGPATCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringpatch_ matcoloringpatch
#endif
PETSC_EXTERN void matcoloringpatch_(Mat *a, PetscInt *b, PetscInt *c, ISColoringValue d[], ISColoring *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatColoringPatch(*a, *b, *c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattransposecoloringdestroy_ MATTRANSPOSECOLORINGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattransposecoloringdestroy_ mattransposecoloringdestroy
#endif
PETSC_EXTERN void mattransposecoloringdestroy_(MatTransposeColoring *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatTransposeColoringDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattransposecoloringcreate_ MATTRANSPOSECOLORINGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattransposecoloringcreate_ mattransposecoloringcreate
#endif
PETSC_EXTERN void mattransposecoloringcreate_(Mat *a, ISColoring *b, MatTransposeColoring *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatTransposeColoringCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
