# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Graphical output."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _graph
else:
    import _graph

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.common
import openturns.typ
class DrawableImplementation(openturns.common.PersistentObject):
    r"""
    Drawable object.

    Notes
    -----
    A drawable element is described by:

    - its data,
    - its attributes: color, line stype, point style, fill style, legend ...

    The different drawable elements are:

    - :class:`~openturns.BarPlot`

    - :class:`~openturns.Cloud`

    - :class:`~openturns.Contour`

    - :class:`~openturns.Curve`

    - :class:`~openturns.Pie`

    - :class:`~openturns.Polygon`

    - :class:`~openturns.Staircase`

    - :class:`~openturns.Text`

    Examples
    --------
    >>> import openturns as ot
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, 'upper right')
    >>> sample = ot.Normal([0.0,0.0], [1.0,1.0], ot.CorrelationMatrix(2)).getSample(10)
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'A Cloud')
    >>> myGraph.add(myCloud)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.DrawableImplementation_getClassName(self)

    def __repr__(self):
        return _graph.DrawableImplementation___repr__(self)

    def __str__(self, *args):
        return _graph.DrawableImplementation___str__(self, *args)

    def __eq__(self, *args):
        return _graph.DrawableImplementation___eq__(self, *args)

    def getLegend(self):
        r"""
        Accessor to the legend of the drawable element.

        Returns
        -------
        legend : str
            Legend of the drawable element.
        """
        return _graph.DrawableImplementation_getLegend(self)

    def setLegend(self, legend):
        r"""
        Accessor to the legend of the drawable element.

        Parameters
        ----------
        legend : str
            Legend of the drawable element.
        """
        return _graph.DrawableImplementation_setLegend(self, legend)

    def getData(self):
        r"""
        Accessor to the data from which the Drawable is built.

        Returns
        -------
        data : :class:`~openturns.Sample`
            Data from which the Drawable is built.
        """
        return _graph.DrawableImplementation_getData(self)

    def getLineStyle(self):
        r"""
        Accessor to the line style of the drawable element.

        Returns
        -------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getLineStyle())
        solid
        """
        return _graph.DrawableImplementation_getLineStyle(self)

    def setLineStyle(self, lineStyle):
        r"""
        Accessor to the line style of the drawable element.

        Parameters
        ----------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.
        """
        return _graph.DrawableImplementation_setLineStyle(self, lineStyle)

    def getColor(self):
        r"""
        Accessor to the color of the drawable element.

        Returns
        -------
        color : str
            Name of the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColor())
        #1f77b4

        See Also
        --------
        setColor, GetValidColors, getColorCode
        """
        return _graph.DrawableImplementation_getColor(self)

    def getColorCode(self):
        r"""
        Accessor to the code of the color of the drawable element.

        Returns
        -------
        color : str
            Hexadecimal code corresponding to the RGB (Red, Green, Blue) components
            of the color of the lines within the drawable element
            or the RGBA (Red, Green, Blue, Alpha) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColorCode())
        #1f77b4

        See Also
        --------
        setColor, getColor, GetValidColors
        """
        return _graph.DrawableImplementation_getColorCode(self)

    def setColor(self, color):
        r"""
        Accessor to the color of the drawable element.

        Parameters
        ----------
        color : str
            Describes the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        See Also
        --------
        getColor, GetValidColors, getColorCode
        """
        return _graph.DrawableImplementation_setColor(self, color)

    def getEdgeColor(self):
        r"""
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.DrawableImplementation_getEdgeColor(self)

    def getAlpha(self):
        r"""
        Accessor to the alpha blending value.

        Returns
        -------
        alpha : float
            The alpha blending value, between 0 (transparent) and 1 (opaque).

        See Also
        --------
        setAlpha
        """
        return _graph.DrawableImplementation_getAlpha(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the alpha blending value.

        Parameters
        ----------
        alpha : float
            The alpha blending value, between 0 (transparent) and 1 (opaque).

        See Also
        --------
        getAlpha
        """
        return _graph.DrawableImplementation_setAlpha(self, alpha)

    def getPointStyle(self):
        r"""
        Accessor to the point style of the drawable element.

        Returns
        -------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:GetValidPointStyles for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getPointStyle())
        none
        """
        return _graph.DrawableImplementation_getPointStyle(self)

    def setPointStyle(self, pointStyle):
        r"""
        Accessor to the point style of the drawable element.

        Parameters
        ----------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:`GetValidPointStyles` for a list of available values.
        """
        return _graph.DrawableImplementation_setPointStyle(self, pointStyle)

    def getFillStyle(self):
        r"""
        Accessor to the fill style of the drawable element.

        Returns
        -------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getFillStyle())
        solid
        """
        return _graph.DrawableImplementation_getFillStyle(self)

    def setFillStyle(self, fillStyle):
        r"""
        Accessor to the fill style of the drawable element.

        Parameters
        ----------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.
        """
        return _graph.DrawableImplementation_setFillStyle(self, fillStyle)

    def getLineWidth(self):
        r"""
        Accessor to the line width of the drawable element.

        Returns
        -------
        lineWidth : float
            Width of the line within the drawable element.
        """
        return _graph.DrawableImplementation_getLineWidth(self)

    def setLineWidth(self, lineWidth):
        r"""
        Accessor to the line width of the drawable element.

        Parameters
        ----------
        lineWidth : positive float
            Width of the line within the drawable element.
        """
        return _graph.DrawableImplementation_setLineWidth(self, lineWidth)

    def getPattern(self):
        r"""
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.DrawableImplementation_getPattern(self)

    def setPattern(self, style):
        r"""
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.DrawableImplementation_setPattern(self, style)

    def getCenter(self):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.Point`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.DrawableImplementation_getCenter(self)

    def setCenter(self, center):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.DrawableImplementation_setCenter(self, center)

    def getRadius(self):
        r"""
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.DrawableImplementation_getRadius(self)

    def setRadius(self, radius):
        r"""
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.DrawableImplementation_setRadius(self, radius)

    def getLabels(self):
        r"""
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.DrawableImplementation_getLabels(self)

    def setLabels(self, labels):
        r"""
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.DrawableImplementation_setLabels(self, labels)

    def getPalette(self):
        r"""
        Accessor to the names of the colors used for the Drawable.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Drawable`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.DrawableImplementation_getPalette(self)

    def setPalette(self, palette):
        r"""
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.DrawableImplementation_setPalette(self, palette)

    def getPaletteAsNormalizedRGBA(self):
        r"""
        Accessor to the Red, Green, Blue, Alpha components of the palette on a unit scale.

        Returns
        -------
        normalizedRGBAPalette : :class:`~openturns.Sample`
            Sample of the four components of each color of the palette on a unit :math:`[0,1]` scale.
        """
        return _graph.DrawableImplementation_getPaletteAsNormalizedRGBA(self)

    def getOrigin(self):
        r"""
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.DrawableImplementation_getOrigin(self)

    def setOrigin(self, origin):
        r"""
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.DrawableImplementation_setOrigin(self, origin)

    def getX(self):
        r"""
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.Sample`
            Values of the first coordinate.
        """
        return _graph.DrawableImplementation_getX(self)

    def setX(self, x):
        r"""
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph.DrawableImplementation_setX(self, x)

    def getY(self):
        r"""
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.Sample`
            Values of the second coordinate.
        """
        return _graph.DrawableImplementation_getY(self)

    def setY(self, y):
        r"""
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph.DrawableImplementation_setY(self, y)

    def getLevels(self):
        r"""
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.Point`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph.DrawableImplementation_getLevels(self)

    def setLevels(self, levels):
        r"""
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph.DrawableImplementation_setLevels(self, levels)

    def getDrawLabels(self):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.DrawableImplementation_getDrawLabels(self)

    def setDrawLabels(self, drawLabels):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.DrawableImplementation_setDrawLabels(self, drawLabels)

    def getTextAnnotations(self):
        r"""
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.DrawableImplementation_getTextAnnotations(self)

    def setTextAnnotations(self, textAnnotations):
        r"""
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.DrawableImplementation_setTextAnnotations(self, textAnnotations)

    def getTextPositions(self):
        r"""
        Accessor to the position of annotations.

        Returns
        -------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  
            Text is written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.DrawableImplementation_getTextPositions(self)

    def setTextPositions(self, textPositions):
        r"""
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.DrawableImplementation_setTextPositions(self, textPositions)

    def getTextSize(self):
        r"""
        Accessor to the text size.

        Returns
        -------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph.DrawableImplementation_getTextSize(self)

    def setTextSize(self, size):
        r"""
        Accessor to the text size.

        Parameters
        ----------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph.DrawableImplementation_setTextSize(self, size)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element
        """
        return _graph.DrawableImplementation_getBoundingBox(self)

    @staticmethod
    def GetValidColors():
        r"""
        Return the list of the valid colors of the drawable element.

        Returns
        -------
        validColors : :class:`~openturns.Description`
            List of the valid colors of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColors()[:5])
        [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
        """
        return _graph.DrawableImplementation_GetValidColors()

    @staticmethod
    def GetValidLineStyles():
        r"""
        Return the list of the valid line styles of the drawable element.

        Returns
        -------
        validLineStyles : :class:`~openturns.Description`
            List of the valid line styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidLineStyles())
        [blank,solid,dashed,dotted,dotdash,longdash,twodash]
        """
        return _graph.DrawableImplementation_GetValidLineStyles()

    @staticmethod
    def GetValidFillStyles():
        r"""
        Return the list of the valid fill styles of the drawable element.

        Returns
        -------
        validFillStyles : :class:`~openturns.Description`
            List of the valid fill styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidFillStyles()[:2])
        [solid,shaded]

        """
        return _graph.DrawableImplementation_GetValidFillStyles()

    @staticmethod
    def GetValidPointStyles():
        r"""
        Return the list of the valid point styles of the drawable element.

        Returns
        -------
        validPointStyles : :class:`~openturns.Description`
            List of the valid point styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().GetValidPointStyles())
        [square,circle,triangleup,plus,times,...
        """
        return _graph.DrawableImplementation_GetValidPointStyles()

    @staticmethod
    def GetValidColorMaps():
        r"""
        Return the list of the valid color maps of contour drawables.

        Returns
        -------
        validColorMaps : :class:`~openturns.Description`
            List of the valid color map names of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColorMaps()[:3])
        [,magma,inferno]

        """
        return _graph.DrawableImplementation_GetValidColorMaps()

    @staticmethod
    def GetValidExtends():
        r"""
        Return the list of the valid coloration extends of contour drawables.

        Returns
        -------
        validExtends : :class:`~openturns.Description`
            List of the valid coloration extends of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidExtends())
        [neither,both,min,max]

        """
        return _graph.DrawableImplementation_GetValidExtends()

    @staticmethod
    def GetValidColorBarPositions():
        r"""
        Return the list of the valid color bar positions of contour drawables.

        Returns
        -------
        validColorBarPositions : :class:`~openturns.Description`
            List of the valid color bar positions of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColorBarPositions())
        [,left,right,top,bottom]

        """
        return _graph.DrawableImplementation_GetValidColorBarPositions()

    @staticmethod
    def GetValidNorms():
        r"""
        Return the list of the valid norms of contour drawables.

        Returns
        -------
        validNorms : :class:`~openturns.Description`
            List of the valid norms of contour drawables.

        Notes
        -----
        These norms are strings that can be passed as the *norm* parameter
        of a Matplotlib
        `contour <https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.contour.html>`_
        object, except *rank* which scales the colormap based on the ranks of the data values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidNorms())
        [asinh,linear,log,logit,symlog,rank]

        """
        return _graph.DrawableImplementation_GetValidNorms()

    @staticmethod
    def ConvertFromName(name):
        r"""
        Convert a color name to a valid hexadecimal code.

        Parameters
        ----------
        name : str
            Name of the color. The valid color names are given by the
            :meth:`GetValidColors` method.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromName('red'))
        #FF0000
        """
        return _graph.DrawableImplementation_ConvertFromName(name)

    @staticmethod
    def ConvertToRGB(key):
        r"""
        Convert an hexadecimal code into an RGB triplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components of the color.
            A value of 0 meaning that the component is absent in the color, a value
            of 255 meaning that the component is fully saturated.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
        [255,0,0]
        """
        return _graph.DrawableImplementation_ConvertToRGB(key)

    @staticmethod
    def ConvertToRGBA(key):
        r"""
        Convert an hexadecimal code into an RGBA quadruplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBAComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components. A value of 0
            meaning that the component is absent in the color, a value of 255 meaning
            that the component is fully saturated. It contains also alpha, the
            level of transparency of the color. Alpha equal to 0 meaning that the
            color is fully transparent and 255 meaning that the color is fully opaque.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
        [255,0,0,255]
        """
        return _graph.DrawableImplementation_ConvertToRGBA(key)

    @staticmethod
    def ConvertFromRGB(*args):
        r"""
        Convert an RGB triplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
        #ff0000
        """
        return _graph.DrawableImplementation_ConvertFromRGB(*args)

    @staticmethod
    def ConvertFromRGBA(*args):
        r"""
        Convert an RGBA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.
        alpha : either nonnegative integer or nonnegative float
            Level of the color's transparency, 0 (or 0.0) meaning that the color is
            fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
            The alpha channel is only supported by a few devices, namely the PDF and
            PNG formats, for the other format the color is fully transparent as soon as
            its alpha channel is less than 255 (or 1.0).

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
        #ff0000ff
        """
        return _graph.DrawableImplementation_ConvertFromRGBA(*args)

    @staticmethod
    def ConvertFromHSVIntoRGB(hue, saturation, value):
        r"""
        Convert an HSV triplet into an RGB triplet.

        Parameters
        ----------
        hue : float
            Hue with 0<=hue<=360.
        saturation : float
            Saturation with 0<=saturation<=1.
        value : float
            Value with 0<=value<=1.

        Returns
        -------
        RGBComponents : :class:`~openturns.Point`
            RGB (Red, Green and Blue) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromHSVIntoRGB(215.0, 0.2, 0.3))
        [0.24,0.265,0.3]
        """
        return _graph.DrawableImplementation_ConvertFromHSVIntoRGB(hue, saturation, value)

    @staticmethod
    def ConvertFromRGBIntoHSV(*args):
        r"""
        Convert an RGB triplet to HSV triplet.

        Parameters
        ----------
        red : float
            Red with 0<=red<=1.
        green : float
            Green with 0<=green<=1.
        blue : float
            Blue with 0<=blue<=1.

        Returns
        -------
        HSVComponents : :class:`~openturns.Point`
            HSV (hue, saturation and value) components of the color
            where 0<=hue<=360, 0<=saturation<=1, 0<=value<=255.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBIntoHSV(0.8, 0.6, 0.4))
        [30,0.5,0.8]
        """
        return _graph.DrawableImplementation_ConvertFromRGBIntoHSV(*args)

    @staticmethod
    def ConvertFromHSV(hue, saturation, value):
        r"""
        Convert an HSV triplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.DrawableImplementation_ConvertFromHSV(hue, saturation, value)

    @staticmethod
    def ConvertFromHSVA(hue, saturation, value, alpha):
        r"""
        Convert an HSVA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.
        alpha : float
            Alpha component.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.DrawableImplementation_ConvertFromHSVA(hue, saturation, value, alpha)

    @staticmethod
    def BuildDefaultPalette(size):
        r"""
        Build default palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the default palette.

        Notes
        -----
        This function uses the 'Drawable-DefaultPaletteName' key of the 
        :class:`~openturns.ResourceMap`, which can be equal to either 
        'Tableau' or 'Rainbow'.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().BuildDefaultPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        >>> ot.ResourceMap.SetAsString('Drawable-DefaultPaletteName', 'Rainbow')
        >>> print(ot.Drawable.BuildDefaultPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        >>> ot.ResourceMap.SetAsString('Drawable-DefaultPaletteName', 'Tableau')
        >>> print(ot.Drawable.BuildDefaultPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        >>> ot.ResourceMap.Reload()
        """
        return _graph.DrawableImplementation_BuildDefaultPalette(size)

    @staticmethod
    def BuildRainbowPalette(size):
        r"""
        Build rainbow palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the rainbow palette.

        Notes
        -----
        The colors are generated in the HSV space, with H (the hue) varying in a number
        of different values given by 'Drawable-DefaultPalettePhase' in
        :class:`~openturns.ResourceMap` and V (the value) being decreased linearly at each
        cycle of the hue.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.BuildRainbowPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        """
        return _graph.DrawableImplementation_BuildRainbowPalette(size)

    @staticmethod
    def BuildTableauPalette(size):
        r"""
        Build tableau palette.

        Parameters
        ----------
        n : int :math:`n > 0` and :math:`n < 10`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the tableau palette.

        Notes
        -----
        The colors are generated in the HSV space. 
        When the number of colors is greater than 10, the value V decreases 
        linearily depending on the 'Drawable-DefaultPalettePhase' key of the 
        :class:`~openturns.ResourceMap` for each block of 10 colors.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.BuildTableauPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        """
        return _graph.DrawableImplementation_BuildTableauPalette(size)

    def __init__(self, *args):
        _graph.DrawableImplementation_swiginit(self, _graph.new_DrawableImplementation(*args))
    __swig_destroy__ = _graph.delete_DrawableImplementation

# Register DrawableImplementation in _graph:
_graph.DrawableImplementation_swigregister(DrawableImplementation)

def DrawableImplementation__repr_png_(self):
    """Get the PNG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'png':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
DrawableImplementation._repr_png_ = DrawableImplementation__repr_png_

def DrawableImplementation__repr_svg_(self):
    """Get the SVG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'svg':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
DrawableImplementation._repr_svg_ = DrawableImplementation__repr_svg_

def DrawableImplementation__repr_html_(self):
    """Get the HTML representation."""
    raise NotImplementedError
DrawableImplementation._repr_html_ = DrawableImplementation__repr_html_

class _DrawableImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _graph._DrawableImplementationTypedInterfaceObject_swiginit(self, _graph.new__DrawableImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _graph._DrawableImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph._DrawableImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph._DrawableImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _graph._DrawableImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _graph._DrawableImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _graph.delete__DrawableImplementationTypedInterfaceObject

# Register _DrawableImplementationTypedInterfaceObject in _graph:
_graph._DrawableImplementationTypedInterfaceObject_swigregister(_DrawableImplementationTypedInterfaceObject)
class DrawableCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _graph.delete_DrawableCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _graph.DrawableCollection_clear(self)

    def __len__(self):
        return _graph.DrawableCollection___len__(self)

    def __eq__(self, rhs):
        return _graph.DrawableCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _graph.DrawableCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _graph.DrawableCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _graph.DrawableCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _graph.DrawableCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _graph.DrawableCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _graph.DrawableCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _graph.DrawableCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _graph.DrawableCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _graph.DrawableCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _graph.DrawableCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _graph.DrawableCollection_find(self, val)

    def __repr__(self):
        return _graph.DrawableCollection___repr__(self)

    def __str__(self, *args):
        return _graph.DrawableCollection___str__(self, *args)

    def __init__(self, *args):
        _graph.DrawableCollection_swiginit(self, _graph.new_DrawableCollection(*args))

# Register DrawableCollection in _graph:
_graph.DrawableCollection_swigregister(DrawableCollection)
class Drawable(_DrawableImplementationTypedInterfaceObject):
    r"""
    Drawable object.

    Notes
    -----
    A drawable element is described by:

    - its data,
    - its attributes: color, line stype, point style, fill style, legend ...

    The different drawable elements are:

    - :class:`~openturns.BarPlot`

    - :class:`~openturns.Cloud`

    - :class:`~openturns.Contour`

    - :class:`~openturns.Curve`

    - :class:`~openturns.Pie`

    - :class:`~openturns.Polygon`

    - :class:`~openturns.Staircase`

    - :class:`~openturns.Text`

    Examples
    --------
    >>> import openturns as ot
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, 'upper right')
    >>> sample = ot.Normal([0.0,0.0], [1.0,1.0], ot.CorrelationMatrix(2)).getSample(10)
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'A Cloud')
    >>> myGraph.add(myCloud)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Drawable_getClassName(self)

    def __repr__(self):
        return _graph.Drawable___repr__(self)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element
        """
        return _graph.Drawable_getBoundingBox(self)

    def getLegend(self):
        r"""
        Accessor to the legend of the drawable element.

        Returns
        -------
        legend : str
            Legend of the drawable element.
        """
        return _graph.Drawable_getLegend(self)

    def setLegend(self, legend):
        r"""
        Accessor to the legend of the drawable element.

        Parameters
        ----------
        legend : str
            Legend of the drawable element.
        """
        return _graph.Drawable_setLegend(self, legend)

    def getLineStyle(self):
        r"""
        Accessor to the line style of the drawable element.

        Returns
        -------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getLineStyle())
        solid
        """
        return _graph.Drawable_getLineStyle(self)

    def setLineStyle(self, lineStyle):
        r"""
        Accessor to the line style of the drawable element.

        Parameters
        ----------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.
        """
        return _graph.Drawable_setLineStyle(self, lineStyle)

    def getPointStyle(self):
        r"""
        Accessor to the point style of the drawable element.

        Returns
        -------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:GetValidPointStyles for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getPointStyle())
        none
        """
        return _graph.Drawable_getPointStyle(self)

    def setPointStyle(self, pointStyle):
        r"""
        Accessor to the point style of the drawable element.

        Parameters
        ----------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:`GetValidPointStyles` for a list of available values.
        """
        return _graph.Drawable_setPointStyle(self, pointStyle)

    def getFillStyle(self):
        r"""
        Accessor to the fill style of the drawable element.

        Returns
        -------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getFillStyle())
        solid
        """
        return _graph.Drawable_getFillStyle(self)

    def setFillStyle(self, fillStyle):
        r"""
        Accessor to the fill style of the drawable element.

        Parameters
        ----------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.
        """
        return _graph.Drawable_setFillStyle(self, fillStyle)

    def getLineWidth(self):
        r"""
        Accessor to the line width of the drawable element.

        Returns
        -------
        lineWidth : float
            Width of the line within the drawable element.
        """
        return _graph.Drawable_getLineWidth(self)

    def setLineWidth(self, lineWidth):
        r"""
        Accessor to the line width of the drawable element.

        Parameters
        ----------
        lineWidth : positive float
            Width of the line within the drawable element.
        """
        return _graph.Drawable_setLineWidth(self, lineWidth)

    def getColor(self):
        r"""
        Accessor to the color of the drawable element.

        Returns
        -------
        color : str
            Name of the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColor())
        #1f77b4

        See Also
        --------
        setColor, GetValidColors, getColorCode
        """
        return _graph.Drawable_getColor(self)

    def getColorCode(self):
        r"""
        Accessor to the code of the color of the drawable element.

        Returns
        -------
        color : str
            Hexadecimal code corresponding to the RGB (Red, Green, Blue) components
            of the color of the lines within the drawable element
            or the RGBA (Red, Green, Blue, Alpha) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColorCode())
        #1f77b4

        See Also
        --------
        setColor, getColor, GetValidColors
        """
        return _graph.Drawable_getColorCode(self)

    def setColor(self, color):
        r"""
        Accessor to the color of the drawable element.

        Parameters
        ----------
        color : str
            Describes the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        See Also
        --------
        getColor, GetValidColors, getColorCode
        """
        return _graph.Drawable_setColor(self, color)

    def getEdgeColor(self):
        r"""
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.Drawable_getEdgeColor(self)

    def getAlpha(self):
        r"""
        Accessor to the alpha blending value.

        Returns
        -------
        alpha : float
            The alpha blending value, between 0 (transparent) and 1 (opaque).

        See Also
        --------
        setAlpha
        """
        return _graph.Drawable_getAlpha(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the alpha blending value.

        Parameters
        ----------
        alpha : float
            The alpha blending value, between 0 (transparent) and 1 (opaque).

        See Also
        --------
        getAlpha
        """
        return _graph.Drawable_setAlpha(self, alpha)

    def getPattern(self):
        r"""
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Drawable_getPattern(self)

    def setPattern(self, style):
        r"""
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Drawable_setPattern(self, style)

    def getCenter(self):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.Point`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Drawable_getCenter(self)

    def setCenter(self, center):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Drawable_setCenter(self, center)

    def getRadius(self):
        r"""
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Drawable_getRadius(self)

    def setRadius(self, radius):
        r"""
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Drawable_setRadius(self, radius)

    def getLabels(self):
        r"""
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.Drawable_getLabels(self)

    def setLabels(self, labels):
        r"""
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.Drawable_setLabels(self, labels)

    def getPalette(self):
        r"""
        Accessor to the names of the colors used for the Drawable.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Drawable`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.Drawable_getPalette(self)

    def setPalette(self, palette):
        r"""
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.Drawable_setPalette(self, palette)

    def getPaletteAsNormalizedRGBA(self):
        r"""
        Accessor to the Red, Green, Blue, Alpha components of the palette on a unit scale.

        Returns
        -------
        normalizedRGBAPalette : :class:`~openturns.Sample`
            Sample of the four components of each color of the palette on a unit :math:`[0,1]` scale.
        """
        return _graph.Drawable_getPaletteAsNormalizedRGBA(self)

    def getOrigin(self):
        r"""
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.Drawable_getOrigin(self)

    def setOrigin(self, origin):
        r"""
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.Drawable_setOrigin(self, origin)

    def getX(self):
        r"""
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.Sample`
            Values of the first coordinate.
        """
        return _graph.Drawable_getX(self)

    def setX(self, x):
        r"""
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph.Drawable_setX(self, x)

    def getY(self):
        r"""
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.Sample`
            Values of the second coordinate.
        """
        return _graph.Drawable_getY(self)

    def setY(self, y):
        r"""
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph.Drawable_setY(self, y)

    def getLevels(self):
        r"""
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.Point`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph.Drawable_getLevels(self)

    def setLevels(self, levels):
        r"""
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph.Drawable_setLevels(self, levels)

    def getDrawLabels(self):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Drawable_getDrawLabels(self)

    def setDrawLabels(self, drawLabels):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Drawable_setDrawLabels(self, drawLabels)

    def getTextAnnotations(self):
        r"""
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Drawable_getTextAnnotations(self)

    def setTextAnnotations(self, textAnnotations):
        r"""
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Drawable_setTextAnnotations(self, textAnnotations)

    def getTextPositions(self):
        r"""
        Accessor to the position of annotations.

        Returns
        -------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  
            Text is written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Drawable_getTextPositions(self)

    def setTextPositions(self, textPositions):
        r"""
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Drawable_setTextPositions(self, textPositions)

    def getTextSize(self):
        r"""
        Accessor to the text size.

        Returns
        -------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph.Drawable_getTextSize(self)

    def setTextSize(self, size):
        r"""
        Accessor to the text size.

        Parameters
        ----------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph.Drawable_setTextSize(self, size)

    def getData(self):
        r"""
        Accessor to the data from which the Drawable is built.

        Returns
        -------
        data : :class:`~openturns.Sample`
            Data from which the Drawable is built.
        """
        return _graph.Drawable_getData(self)

    @staticmethod
    def GetValidColors():
        r"""
        Return the list of the valid colors of the drawable element.

        Returns
        -------
        validColors : :class:`~openturns.Description`
            List of the valid colors of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColors()[:5])
        [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
        """
        return _graph.Drawable_GetValidColors()

    @staticmethod
    def GetValidLineStyles():
        r"""
        Return the list of the valid line styles of the drawable element.

        Returns
        -------
        validLineStyles : :class:`~openturns.Description`
            List of the valid line styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidLineStyles())
        [blank,solid,dashed,dotted,dotdash,longdash,twodash]
        """
        return _graph.Drawable_GetValidLineStyles()

    @staticmethod
    def GetValidFillStyles():
        r"""
        Return the list of the valid fill styles of the drawable element.

        Returns
        -------
        validFillStyles : :class:`~openturns.Description`
            List of the valid fill styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidFillStyles()[:2])
        [solid,shaded]

        """
        return _graph.Drawable_GetValidFillStyles()

    @staticmethod
    def GetValidPointStyles():
        r"""
        Return the list of the valid point styles of the drawable element.

        Returns
        -------
        validPointStyles : :class:`~openturns.Description`
            List of the valid point styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().GetValidPointStyles())
        [square,circle,triangleup,plus,times,...
        """
        return _graph.Drawable_GetValidPointStyles()

    @staticmethod
    def GetValidColorMaps():
        r"""
        Return the list of the valid color maps of contour drawables.

        Returns
        -------
        validColorMaps : :class:`~openturns.Description`
            List of the valid color map names of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColorMaps()[:3])
        [,magma,inferno]

        """
        return _graph.Drawable_GetValidColorMaps()

    @staticmethod
    def GetValidExtends():
        r"""
        Return the list of the valid coloration extends of contour drawables.

        Returns
        -------
        validExtends : :class:`~openturns.Description`
            List of the valid coloration extends of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidExtends())
        [neither,both,min,max]

        """
        return _graph.Drawable_GetValidExtends()

    @staticmethod
    def GetValidColorBarPositions():
        r"""
        Return the list of the valid color bar positions of contour drawables.

        Returns
        -------
        validColorBarPositions : :class:`~openturns.Description`
            List of the valid color bar positions of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColorBarPositions())
        [,left,right,top,bottom]

        """
        return _graph.Drawable_GetValidColorBarPositions()

    @staticmethod
    def GetValidNorms():
        r"""
        Return the list of the valid norms of contour drawables.

        Returns
        -------
        validNorms : :class:`~openturns.Description`
            List of the valid norms of contour drawables.

        Notes
        -----
        These norms are strings that can be passed as the *norm* parameter
        of a Matplotlib
        `contour <https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.contour.html>`_
        object, except *rank* which scales the colormap based on the ranks of the data values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidNorms())
        [asinh,linear,log,logit,symlog,rank]

        """
        return _graph.Drawable_GetValidNorms()

    @staticmethod
    def ConvertFromName(name):
        r"""
        Convert a color name to a valid hexadecimal code.

        Parameters
        ----------
        name : str
            Name of the color. The valid color names are given by the
            :meth:`GetValidColors` method.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromName('red'))
        #FF0000
        """
        return _graph.Drawable_ConvertFromName(name)

    @staticmethod
    def ConvertToRGB(key):
        r"""
        Convert an hexadecimal code into an RGB triplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components of the color.
            A value of 0 meaning that the component is absent in the color, a value
            of 255 meaning that the component is fully saturated.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
        [255,0,0]
        """
        return _graph.Drawable_ConvertToRGB(key)

    @staticmethod
    def ConvertToRGBA(key):
        r"""
        Convert an hexadecimal code into an RGBA quadruplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBAComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components. A value of 0
            meaning that the component is absent in the color, a value of 255 meaning
            that the component is fully saturated. It contains also alpha, the
            level of transparency of the color. Alpha equal to 0 meaning that the
            color is fully transparent and 255 meaning that the color is fully opaque.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
        [255,0,0,255]
        """
        return _graph.Drawable_ConvertToRGBA(key)

    @staticmethod
    def ConvertFromRGB(*args):
        r"""
        Convert an RGB triplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
        #ff0000
        """
        return _graph.Drawable_ConvertFromRGB(*args)

    @staticmethod
    def ConvertFromRGBA(*args):
        r"""
        Convert an RGBA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.
        alpha : either nonnegative integer or nonnegative float
            Level of the color's transparency, 0 (or 0.0) meaning that the color is
            fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
            The alpha channel is only supported by a few devices, namely the PDF and
            PNG formats, for the other format the color is fully transparent as soon as
            its alpha channel is less than 255 (or 1.0).

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
        #ff0000ff
        """
        return _graph.Drawable_ConvertFromRGBA(*args)

    @staticmethod
    def ConvertFromHSVIntoRGB(hue, saturation, value):
        r"""
        Convert an HSV triplet into an RGB triplet.

        Parameters
        ----------
        hue : float
            Hue with 0<=hue<=360.
        saturation : float
            Saturation with 0<=saturation<=1.
        value : float
            Value with 0<=value<=1.

        Returns
        -------
        RGBComponents : :class:`~openturns.Point`
            RGB (Red, Green and Blue) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromHSVIntoRGB(215.0, 0.2, 0.3))
        [0.24,0.265,0.3]
        """
        return _graph.Drawable_ConvertFromHSVIntoRGB(hue, saturation, value)

    @staticmethod
    def ConvertFromRGBIntoHSV(*args):
        r"""
        Convert an RGB triplet to HSV triplet.

        Parameters
        ----------
        red : float
            Red with 0<=red<=1.
        green : float
            Green with 0<=green<=1.
        blue : float
            Blue with 0<=blue<=1.

        Returns
        -------
        HSVComponents : :class:`~openturns.Point`
            HSV (hue, saturation and value) components of the color
            where 0<=hue<=360, 0<=saturation<=1, 0<=value<=255.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBIntoHSV(0.8, 0.6, 0.4))
        [30,0.5,0.8]
        """
        return _graph.Drawable_ConvertFromRGBIntoHSV(*args)

    @staticmethod
    def ConvertFromHSV(hue, saturation, value):
        r"""
        Convert an HSV triplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.Drawable_ConvertFromHSV(hue, saturation, value)

    @staticmethod
    def ConvertFromHSVA(hue, saturation, value, alpha):
        r"""
        Convert an HSVA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.
        alpha : float
            Alpha component.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.Drawable_ConvertFromHSVA(hue, saturation, value, alpha)

    @staticmethod
    def BuildDefaultPalette(size):
        r"""
        Build default palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the default palette.

        Notes
        -----
        This function uses the 'Drawable-DefaultPaletteName' key of the 
        :class:`~openturns.ResourceMap`, which can be equal to either 
        'Tableau' or 'Rainbow'.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().BuildDefaultPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        >>> ot.ResourceMap.SetAsString('Drawable-DefaultPaletteName', 'Rainbow')
        >>> print(ot.Drawable.BuildDefaultPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        >>> ot.ResourceMap.SetAsString('Drawable-DefaultPaletteName', 'Tableau')
        >>> print(ot.Drawable.BuildDefaultPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        >>> ot.ResourceMap.Reload()
        """
        return _graph.Drawable_BuildDefaultPalette(size)

    @staticmethod
    def BuildRainbowPalette(size):
        r"""
        Build rainbow palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the rainbow palette.

        Notes
        -----
        The colors are generated in the HSV space, with H (the hue) varying in a number
        of different values given by 'Drawable-DefaultPalettePhase' in
        :class:`~openturns.ResourceMap` and V (the value) being decreased linearly at each
        cycle of the hue.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.BuildRainbowPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        """
        return _graph.Drawable_BuildRainbowPalette(size)

    @staticmethod
    def BuildTableauPalette(size):
        r"""
        Build tableau palette.

        Parameters
        ----------
        n : int :math:`n > 0` and :math:`n < 10`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the tableau palette.

        Notes
        -----
        The colors are generated in the HSV space. 
        When the number of colors is greater than 10, the value V decreases 
        linearily depending on the 'Drawable-DefaultPalettePhase' key of the 
        :class:`~openturns.ResourceMap` for each block of 10 colors.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.BuildTableauPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        """
        return _graph.Drawable_BuildTableauPalette(size)

    def __init__(self, *args):
        _graph.Drawable_swiginit(self, _graph.new_Drawable(*args))
    __swig_destroy__ = _graph.delete_Drawable

# Register Drawable in _graph:
_graph.Drawable_swigregister(Drawable)

def Drawable__repr_png_(self):
    """Get the PNG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'png':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
Drawable._repr_png_ = Drawable__repr_png_

def Drawable__repr_svg_(self):
    """Get the SVG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'svg':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
Drawable._repr_svg_ = Drawable__repr_svg_

def Drawable__repr_html_(self):
    """Get the HTML representation."""
    raise NotImplementedError
Drawable._repr_html_ = Drawable__repr_html_

class GraphImplementation(openturns.common.PersistentObject):
    r"""
    Class Graph containing drawable elements and a graphical context.

    Available constructors:
        Graph(*title*)

        Graph(*title, xTitle, yTitle, showAxes, legendPosition*)

    Parameters
    ----------
    title : str
        Title of the graph.
    xTitle : str
        Legend of the X axe.
    yTitle : str
        Legend of the Y axe.
    showAxes : bool
        *True* to draw the axes. *False* to hide them.
    legendPosition : str, optional
        Indication of the legend's position. If *legendPosition* is not specified,
        the Graph has no legend. The valid strings are given by the
        :meth:`GetValidLegendPositions` method.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.GraphImplementation_getClassName(self)
    PNG = _graph.GraphImplementation_PNG
    EPS = _graph.GraphImplementation_EPS
    FIG = _graph.GraphImplementation_FIG
    PDF = _graph.GraphImplementation_PDF
    ALL = _graph.GraphImplementation_ALL
    NONE = _graph.GraphImplementation_NONE
    LOGX = _graph.GraphImplementation_LOGX
    LOGY = _graph.GraphImplementation_LOGY
    LOGXY = _graph.GraphImplementation_LOGXY
    TICKNONE = _graph.GraphImplementation_TICKNONE
    TICKX = _graph.GraphImplementation_TICKX
    TICKY = _graph.GraphImplementation_TICKY
    TICKXY = _graph.GraphImplementation_TICKXY

    def __repr__(self):
        return _graph.GraphImplementation___repr__(self)

    def add(self, *args):
        r"""
        Add drawable instances to the collection of drawables contained in Graph.

        Available usages:
            add(*drawables*)

            add(*aGraph*)

        Parameters
        ----------
        drawables : :class:`~openturns.Drawable` or list of :class:`~openturns.Drawable`
            Drawable to add in the Graph.
        aGraph : :class:`~openturns.Graph`
            Graph to add in the Graph.

        Notes
        -----
        It adds the new drawables or graph inside the first one, with their legend.
        It keeps the graphical context of the first graph. Each drawable keeps
        its graphical context.
        Drawables that do not have an explicitly set color will be assigned the default
        palette color corresponding to their rank in the graph.


        .. warning::
            Different drawables might be colored the same...
        """
        return _graph.GraphImplementation_add(self, *args)

    def erase(self, i):
        r"""
        Erase a drawable instance from the collection of drawables contained in Graph.

        Parameters
        ----------
        index : int
            Index of the drawable instance to erase from the collection of drawables
            contained in Graph.
        """
        return _graph.GraphImplementation_erase(self, i)

    def getDrawables(self):
        r"""
        Accessor to the Drawables included in the Graph.

        Returns
        -------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.GraphImplementation_getDrawables(self)

    def setDrawables(self, drawableCollection):
        r"""
        Accessor to the Drawables included in the Graph.

        Parameters
        ----------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.

        Notes
        -----
        Drawables that do not have an explicitly set color will be assigned the
        default palette color corresponding to their rank in the graph.
        """
        return _graph.GraphImplementation_setDrawables(self, drawableCollection)

    def getDrawable(self, index):
        r"""
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : positive int
            Position of the Drawable.

        Returns
        -------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph at the index.
        """
        return _graph.GraphImplementation_getDrawable(self, index)

    def setDrawable(self, *args):
        r"""
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : int
            Position of the Drawable.
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph.

        Notes
        -----
        If the drawable does not have an explicitly set color, it will be assigned
        the default palette color corresponding to its rank in the graph.
        """
        return _graph.GraphImplementation_setDrawable(self, *args)

    def getColors(self):
        r"""
        Accessor to the colors of the Drawables included in the Graph.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of all the colors used for the Drawables contained inside the graph.
        """
        return _graph.GraphImplementation_getColors(self)

    def setColors(self, colors):
        r"""
        Update the colors of the Drawables inside the Graph.

        Parameters
        ----------
        listColors : sequence of str
            List of the colors used for each Drawable of the Graph.
            If the *listColors*'s size is lower than the number of Drawables, the
            first colors of *listColors* are re-used. If it is greated than
            the number of Drawables, the last colors of the list are ignored.

            The *listColors* argument can be the result of the static method
            :meth:`~openturns.Drawable.BuildDefaultPalette` 
            or :meth:`~openturns.Drawable.BuildTableauPalette` of the Drawable object.
        """
        return _graph.GraphImplementation_setColors(self, colors)

    def setDefaultColors(self):
        r"""
        Assign colors to a default palette to all the drawables of the Graph.

        Notes
        -----
        This method ensures that drawables of the Graph have different colors.
        """
        return _graph.GraphImplementation_setDefaultColors(self)

    def getLegends(self):
        r"""
        Accessor to the legends of the Drawables inside the Graph.

        Returns
        -------
        legends : :class:`~openturns.Description`
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.GraphImplementation_getLegends(self)

    def setLegends(self, legends):
        r"""
        Accessor to the legends of the Drawables inside the Graph.

        Parameters
        ----------
        legends : sequence of str
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.GraphImplementation_setLegends(self, legends)

    def setAxes(self, showAxes):
        r"""
        Accessor to the indication of axes' presence on the Graph.

        Parameters
        ----------
        axes : bool
            *True* to draw the axes, *False* to hide the axes.
        """
        return _graph.GraphImplementation_setAxes(self, showAxes)

    def getAxes(self):
        r"""
        Accessor to the indication of axes' presence on the Graph.

        Returns
        -------
        axes : bool
            *True* if the axes are drawn, *False* if they are hidden.
        """
        return _graph.GraphImplementation_getAxes(self)

    def setTickLocation(self, tickLocation):
        r"""
        Accessor to the ticks location flag.

        Parameters
        ----------
        loc : int
            Indicates the ticks location:

            - ot.GraphImplementation.TICKNONE: no ticks,

            - ot.GraphImplementation.TICKX: horizontal ticks,

            - ot.GraphImplementation.TICKY: vertical ticks,

            - ot.GraphImplementation.TICKXY: horizontal and vertical ticks.
        """
        return _graph.GraphImplementation_setTickLocation(self, tickLocation)

    def getTickLocation(self):
        r"""
        Accessor to the ticks location flag.

        Returns
        -------
        loc : int
            Indicates the ticks location.
        """
        return _graph.GraphImplementation_getTickLocation(self)

    def setIntegerXTick(self, integerXTick):
        r"""
        Accessor to the integer x-axis ticks flag.

        Parameters
        ----------
        integerXTick : bool
            Whether to draw only integer ticks on the x-axis.
        """
        return _graph.GraphImplementation_setIntegerXTick(self, integerXTick)

    def getIntegerXTick(self):
        r"""
        Accessor to the integer x-axis ticks flag.

        Returns
        -------
        integerXTick : bool
            Whether to draw only integer ticks on the x-axis.
        """
        return _graph.GraphImplementation_getIntegerXTick(self)

    def setIntegerYTick(self, integerYTick):
        r"""
        Accessor to the integer y-axis ticks flag.

        Parameters
        ----------
        integerYTick : bool
            Whether to draw only integer ticks on the y-axis.
        """
        return _graph.GraphImplementation_setIntegerYTick(self, integerYTick)

    def getIntegerYTick(self):
        r"""
        Accessor to the integer y-axis ticks flag.

        Returns
        -------
        integerYTick : bool
            Whether to draw only integer ticks on the y-axis.
        """
        return _graph.GraphImplementation_getIntegerYTick(self)

    def setLogScale(self, logScale):
        r"""
        Accessor to the indication of axes' scale of the Graph.

        Parameters
        ----------
        scale : int
            Indicates the type of the axes's scale:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        """
        return _graph.GraphImplementation_setLogScale(self, logScale)

    def getLogScale(self):
        r"""
        Accessor to the indication of axes' scale of the Graph.

        Returns
        -------
        scale : int
            Indicates the type of the axes's scale:

            - 0: no log scale is used,

            - 1: log scale is used only for horizontal data,

            - 2: log scale is used only for vertical data,

            - 3: log scale is used for both data.
        """
        return _graph.GraphImplementation_getLogScale(self)

    def setGrid(self, showGrid):
        r"""
        Hide or shows grid of the Graph.

        Parameters
        ----------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
        """
        return _graph.GraphImplementation_setGrid(self, showGrid)

    def getGrid(self):
        r"""
        Accessor to the indication of grid's presence on the Graph.

        Returns
        -------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
            By default there is a gray grid.
        """
        return _graph.GraphImplementation_getGrid(self)

    def setGridColor(self, color):
        r"""
        Accessor to the indication of grid's color on the Graph.

        Parameters
        ----------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.GraphImplementation_setGridColor(self, color)

    def getGridColor(self):
        r"""
        Accessor to the indication of grid's color on the Graph.

        Returns
        -------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.GraphImplementation_getGridColor(self)

    def getXTitle(self):
        r"""
        Accessor to the title of the X axe.

        Returns
        -------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.GraphImplementation_getXTitle(self)

    def setXTitle(self, title):
        r"""
        Accessor to the title of the X axe.

        Parameters
        ----------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.GraphImplementation_setXTitle(self, title)

    def getYTitle(self):
        r"""
        Accessor to the title of the Y axe.

        Returns
        -------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.GraphImplementation_getYTitle(self)

    def setYTitle(self, title):
        r"""
        Accessor to the title of the Y axe.

        Parameters
        ----------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.GraphImplementation_setYTitle(self, title)

    def getTitle(self):
        r"""
        Accessor to the title of the Graph.

        Returns
        -------
        title : str
            Title of the Graph.
        """
        return _graph.GraphImplementation_getTitle(self)

    def setTitle(self, title):
        r"""
        Accessor to the title of the Graph.

        Parameters
        ----------
        title : str
            Title of the Graph.
        """
        return _graph.GraphImplementation_setTitle(self, title)

    def setXMargin(self, xMargin):
        r"""
        Accessor to the horizontal margin size.

        Parameters
        ----------
        xMargin : float
            Horizontal margin ratio, defaults to 5% of the range on each side.
            In log-scale, it is interpreted as a power of 10;
            setting a value of 1 means a margin of one decade on each side.
            Defaults to *Graph-DefaultHorizontalMargin* map value.
        """
        return _graph.GraphImplementation_setXMargin(self, xMargin)

    def setYMargin(self, yMargin):
        r"""
        Accessor to the vertical margin size.

        Parameters
        ----------
        yMargin : float
            Vertical margin ratio, defaults to 5% of the range on each side.
            In log-scale, it is interpreted as a power of 10;
            setting a value of 1 means a margin of one decade on each side.
            Defaults to *Graph-DefaultVerticalMargin* map value.
        """
        return _graph.GraphImplementation_setYMargin(self, yMargin)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            This methods adds x/y margins according to the margin attributes.
        """
        return _graph.GraphImplementation_getBoundingBox(self)

    def setBoundingBox(self, boundingBox):
        r"""
        Accessor to the bounding box of the whole plot.

        Parameters
        ----------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph.GraphImplementation_setBoundingBox(self, boundingBox)

    def getAutomaticBoundingBox(self):
        r"""
        Accessor to the indication of automatic bounding box.

        Returns
        -------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph.GraphImplementation_getAutomaticBoundingBox(self)

    def setAutomaticBoundingBox(self, automaticBoundingBox):
        r"""
        Accessor to the indication of automatic bounding box.

        Parameters
        ----------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph.GraphImplementation_setAutomaticBoundingBox(self, automaticBoundingBox)

    def getLegendFontSize(self):
        r"""
        Accessor to the legends' font size of the Drawables inside the Graph.

        Returns
        -------
        fontSize : float
            Legends' font size used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendFontSize
        """
        return _graph.GraphImplementation_getLegendFontSize(self)

    def setLegendFontSize(self, legendFontSize):
        r"""
        Accessor to the legend's font size of the Drawables inside the Graph.

        Parameters
        ----------
        fontSize : float
            Legend's font size used for the drawables contained inside the Graph.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an empty graph
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, 'upper right')
        >>> graph.setLegendFontSize(15.0)
        >>> print(graph.getLegendFontSize())
        15.0
        """
        return _graph.GraphImplementation_setLegendFontSize(self, legendFontSize)

    @staticmethod
    def IsValidLegendPosition(position):
        r"""
        Test if the proposed legend position is valid or not.

        Parameters
        ----------
        position : str
            Proposed legend position of the Drawables inside the Graph.

        Returns
        -------
        validity : bool
            *True* if the proposed legend position is valid, *False* if it is not.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
        False
        >>> print(ot.Graph.IsValidLegendPosition('upper left'))
        True
        """
        return _graph.GraphImplementation_IsValidLegendPosition(position)

    @staticmethod
    def GetValidLegendPositions():
        r"""
        Accessor to the list of valid legend positions.

        Returns
        -------
        listPositions : :class:`~openturns.Description`
            All the valid legend positions.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.GetValidLegendPositions())
        [,best,upper right,upper left,lower right,lower left,center right,...
        """
        return _graph.GraphImplementation_GetValidLegendPositions()

    def setLegendPosition(self, position):
        r"""
        Accessor to the legend's position of the Drawables inside the Graph.

        Parameters
        ----------
        position : str
            Legend's position used for the drawables contained inside the Graph.
            The valid positions are given by the method :meth:`GetValidLegendPositions`.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'upper right'
        >>> # Create an empty graph
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
        >>> graph.setLegendPosition('lower left')
        >>> print(graph.getLegendPosition())
        lower left
        """
        return _graph.GraphImplementation_setLegendPosition(self, position)

    def getLegendPosition(self):
        r"""
        Accessor to the legend's position of the Drawables inside the Graph.

        Returns
        -------
        position : str
            Legend's position used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions
        """
        return _graph.GraphImplementation_getLegendPosition(self)

    def setLegendCorner(self, corner):
        r"""
        Accessor to the legend's corner.

        Parameters
        ----------
        corner : sequence of float
            Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
            The position of the legend relatively to this point will depend on the orientation
            given by the :meth:`getLegendPosition` value.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'upper left'  # the legend's upper left corner with be set below
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
        >>> graph.setLegendCorner([1.0, 1.0])  # legend will begin in top right corner

        Notes
        -----
        This enables the legend to be located outside the graph.

        """
        return _graph.GraphImplementation_setLegendCorner(self, corner)

    def getLegendCorner(self):
        r"""
        Accessor to the legend's corner.

        Returns
        -------
        corner : :class:`~openturns.Point`
            Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
            The position of the legend relatively to this point will depend on the orientation
            given by the :meth:`getLegendPosition` value.

        """
        return _graph.GraphImplementation_getLegendCorner(self)

    def __init__(self, *args):
        _graph.GraphImplementation_swiginit(self, _graph.new_GraphImplementation(*args))
    __swig_destroy__ = _graph.delete_GraphImplementation

# Register GraphImplementation in _graph:
_graph.GraphImplementation_swigregister(GraphImplementation)
class _GraphImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _graph._GraphImplementationTypedInterfaceObject_swiginit(self, _graph.new__GraphImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _graph._GraphImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph._GraphImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph._GraphImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _graph._GraphImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _graph._GraphImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _graph.delete__GraphImplementationTypedInterfaceObject

# Register _GraphImplementationTypedInterfaceObject in _graph:
_graph._GraphImplementationTypedInterfaceObject_swigregister(_GraphImplementationTypedInterfaceObject)
class _GraphCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _graph.delete__GraphCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _graph._GraphCollection_clear(self)

    def __len__(self):
        return _graph._GraphCollection___len__(self)

    def __eq__(self, rhs):
        return _graph._GraphCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _graph._GraphCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _graph._GraphCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _graph._GraphCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _graph._GraphCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _graph._GraphCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _graph._GraphCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _graph._GraphCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _graph._GraphCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _graph._GraphCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _graph._GraphCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _graph._GraphCollection_find(self, val)

    def __repr__(self):
        return _graph._GraphCollection___repr__(self)

    def __str__(self, *args):
        return _graph._GraphCollection___str__(self, *args)

    def __init__(self, *args):
        _graph._GraphCollection_swiginit(self, _graph.new__GraphCollection(*args))

# Register _GraphCollection in _graph:
_graph._GraphCollection_swigregister(_GraphCollection)
class Graph(_GraphImplementationTypedInterfaceObject):
    r"""
    Class Graph containing drawable elements and a graphical context.

    Available constructors:
        Graph(*title*)

        Graph(*title, xTitle, yTitle, showAxes, legendPosition*)

    Parameters
    ----------
    title : str
        Title of the graph.
    xTitle : str
        Legend of the X axe.
    yTitle : str
        Legend of the Y axe.
    showAxes : bool
        *True* to draw the axes. *False* to hide them.
    legendPosition : str, optional
        Indication of the legend's position. If *legendPosition* is not specified,
        the Graph has no legend. The valid strings are given by the
        :meth:`GetValidLegendPositions` method.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Graph_getClassName(self)

    def __repr__(self):
        return _graph.Graph___repr__(self)

    def __str__(self, *args):
        return _graph.Graph___str__(self, *args)

    def add(self, *args):
        r"""
        Add drawable instances to the collection of drawables contained in Graph.

        Available usages:
            add(*drawables*)

            add(*aGraph*)

        Parameters
        ----------
        drawables : :class:`~openturns.Drawable` or list of :class:`~openturns.Drawable`
            Drawable to add in the Graph.
        aGraph : :class:`~openturns.Graph`
            Graph to add in the Graph.

        Notes
        -----
        It adds the new drawables or graph inside the first one, with their legend.
        It keeps the graphical context of the first graph. Each drawable keeps
        its graphical context.
        Drawables that do not have an explicitly set color will be assigned the default
        palette color corresponding to their rank in the graph.


        .. warning::
            Different drawables might be colored the same...
        """
        return _graph.Graph_add(self, *args)

    def erase(self, i):
        r"""
        Erase a drawable instance from the collection of drawables contained in Graph.

        Parameters
        ----------
        index : int
            Index of the drawable instance to erase from the collection of drawables
            contained in Graph.
        """
        return _graph.Graph_erase(self, i)

    def getDrawables(self):
        r"""
        Accessor to the Drawables included in the Graph.

        Returns
        -------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.Graph_getDrawables(self)

    def setDrawables(self, drawableCollection):
        r"""
        Accessor to the Drawables included in the Graph.

        Parameters
        ----------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.

        Notes
        -----
        Drawables that do not have an explicitly set color will be assigned the
        default palette color corresponding to their rank in the graph.
        """
        return _graph.Graph_setDrawables(self, drawableCollection)

    def getDrawable(self, index):
        r"""
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : positive int
            Position of the Drawable.

        Returns
        -------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph at the index.
        """
        return _graph.Graph_getDrawable(self, index)

    def setDrawable(self, *args):
        r"""
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : int
            Position of the Drawable.
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph.

        Notes
        -----
        If the drawable does not have an explicitly set color, it will be assigned
        the default palette color corresponding to its rank in the graph.
        """
        return _graph.Graph_setDrawable(self, *args)

    def getColors(self):
        r"""
        Accessor to the colors of the Drawables included in the Graph.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of all the colors used for the Drawables contained inside the graph.
        """
        return _graph.Graph_getColors(self)

    def setColors(self, colors):
        r"""
        Update the colors of the Drawables inside the Graph.

        Parameters
        ----------
        listColors : sequence of str
            List of the colors used for each Drawable of the Graph.
            If the *listColors*'s size is lower than the number of Drawables, the
            first colors of *listColors* are re-used. If it is greated than
            the number of Drawables, the last colors of the list are ignored.

            The *listColors* argument can be the result of the static method
            :meth:`~openturns.Drawable.BuildDefaultPalette` 
            or :meth:`~openturns.Drawable.BuildTableauPalette` of the Drawable object.
        """
        return _graph.Graph_setColors(self, colors)

    def setDefaultColors(self):
        r"""
        Assign colors to a default palette to all the drawables of the Graph.

        Notes
        -----
        This method ensures that drawables of the Graph have different colors.
        """
        return _graph.Graph_setDefaultColors(self)

    def getLegends(self):
        r"""
        Accessor to the legends of the Drawables inside the Graph.

        Returns
        -------
        legends : :class:`~openturns.Description`
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.Graph_getLegends(self)

    def setLegends(self, legends):
        r"""
        Accessor to the legends of the Drawables inside the Graph.

        Parameters
        ----------
        legends : sequence of str
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.Graph_setLegends(self, legends)

    def setAxes(self, showAxes):
        r"""
        Accessor to the indication of axes' presence on the Graph.

        Parameters
        ----------
        axes : bool
            *True* to draw the axes, *False* to hide the axes.
        """
        return _graph.Graph_setAxes(self, showAxes)

    def getAxes(self):
        r"""
        Accessor to the indication of axes' presence on the Graph.

        Returns
        -------
        axes : bool
            *True* if the axes are drawn, *False* if they are hidden.
        """
        return _graph.Graph_getAxes(self)

    def setTickLocation(self, tickLocation):
        r"""
        Accessor to the ticks location flag.

        Parameters
        ----------
        loc : int
            Indicates the ticks location:

            - ot.GraphImplementation.TICKNONE: no ticks,

            - ot.GraphImplementation.TICKX: horizontal ticks,

            - ot.GraphImplementation.TICKY: vertical ticks,

            - ot.GraphImplementation.TICKXY: horizontal and vertical ticks.
        """
        return _graph.Graph_setTickLocation(self, tickLocation)

    def getTickLocation(self):
        r"""
        Accessor to the ticks location flag.

        Returns
        -------
        loc : int
            Indicates the ticks location.
        """
        return _graph.Graph_getTickLocation(self)

    def setIntegerXTick(self, integerXTick):
        r"""
        Accessor to the integer x-axis ticks flag.

        Parameters
        ----------
        integerXTick : bool
            Whether to draw only integer ticks on the x-axis.
        """
        return _graph.Graph_setIntegerXTick(self, integerXTick)

    def getIntegerXTick(self):
        r"""
        Accessor to the integer x-axis ticks flag.

        Returns
        -------
        integerXTick : bool
            Whether to draw only integer ticks on the x-axis.
        """
        return _graph.Graph_getIntegerXTick(self)

    def setIntegerYTick(self, integerYTick):
        r"""
        Accessor to the integer y-axis ticks flag.

        Parameters
        ----------
        integerYTick : bool
            Whether to draw only integer ticks on the y-axis.
        """
        return _graph.Graph_setIntegerYTick(self, integerYTick)

    def getIntegerYTick(self):
        r"""
        Accessor to the integer y-axis ticks flag.

        Returns
        -------
        integerYTick : bool
            Whether to draw only integer ticks on the y-axis.
        """
        return _graph.Graph_getIntegerYTick(self)

    def setLogScale(self, logScale):
        r"""
        Accessor to the indication of axes' scale of the Graph.

        Parameters
        ----------
        scale : int
            Indicates the type of the axes's scale:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        """
        return _graph.Graph_setLogScale(self, logScale)

    def getLogScale(self):
        r"""
        Accessor to the indication of axes' scale of the Graph.

        Returns
        -------
        scale : int
            Indicates the type of the axes's scale:

            - 0: no log scale is used,

            - 1: log scale is used only for horizontal data,

            - 2: log scale is used only for vertical data,

            - 3: log scale is used for both data.
        """
        return _graph.Graph_getLogScale(self)

    def setGrid(self, showGrid):
        r"""
        Hide or shows grid of the Graph.

        Parameters
        ----------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
        """
        return _graph.Graph_setGrid(self, showGrid)

    def getGrid(self):
        r"""
        Accessor to the indication of grid's presence on the Graph.

        Returns
        -------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
            By default there is a gray grid.
        """
        return _graph.Graph_getGrid(self)

    def setGridColor(self, color):
        r"""
        Accessor to the indication of grid's color on the Graph.

        Parameters
        ----------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.Graph_setGridColor(self, color)

    def getGridColor(self):
        r"""
        Accessor to the indication of grid's color on the Graph.

        Returns
        -------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.Graph_getGridColor(self)

    def getXTitle(self):
        r"""
        Accessor to the title of the X axe.

        Returns
        -------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.Graph_getXTitle(self)

    def setXTitle(self, title):
        r"""
        Accessor to the title of the X axe.

        Parameters
        ----------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.Graph_setXTitle(self, title)

    def getYTitle(self):
        r"""
        Accessor to the title of the Y axe.

        Returns
        -------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.Graph_getYTitle(self)

    def setYTitle(self, title):
        r"""
        Accessor to the title of the Y axe.

        Parameters
        ----------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.Graph_setYTitle(self, title)

    def getTitle(self):
        r"""
        Accessor to the title of the Graph.

        Returns
        -------
        title : str
            Title of the Graph.
        """
        return _graph.Graph_getTitle(self)

    def setTitle(self, title):
        r"""
        Accessor to the title of the Graph.

        Parameters
        ----------
        title : str
            Title of the Graph.
        """
        return _graph.Graph_setTitle(self, title)

    def setXMargin(self, xMargin):
        r"""
        Accessor to the horizontal margin size.

        Parameters
        ----------
        xMargin : float
            Horizontal margin ratio, defaults to 5% of the range on each side.
            In log-scale, it is interpreted as a power of 10;
            setting a value of 1 means a margin of one decade on each side.
            Defaults to *Graph-DefaultHorizontalMargin* map value.
        """
        return _graph.Graph_setXMargin(self, xMargin)

    def setYMargin(self, yMargin):
        r"""
        Accessor to the vertical margin size.

        Parameters
        ----------
        yMargin : float
            Vertical margin ratio, defaults to 5% of the range on each side.
            In log-scale, it is interpreted as a power of 10;
            setting a value of 1 means a margin of one decade on each side.
            Defaults to *Graph-DefaultVerticalMargin* map value.
        """
        return _graph.Graph_setYMargin(self, yMargin)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            This methods adds x/y margins according to the margin attributes.
        """
        return _graph.Graph_getBoundingBox(self)

    def setBoundingBox(self, boundingBox):
        r"""
        Accessor to the bounding box of the whole plot.

        Parameters
        ----------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph.Graph_setBoundingBox(self, boundingBox)

    def getAutomaticBoundingBox(self):
        r"""
        Accessor to the indication of automatic bounding box.

        Returns
        -------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph.Graph_getAutomaticBoundingBox(self)

    def setAutomaticBoundingBox(self, automaticBoundingBox):
        r"""
        Accessor to the indication of automatic bounding box.

        Parameters
        ----------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph.Graph_setAutomaticBoundingBox(self, automaticBoundingBox)

    def getLegendPosition(self):
        r"""
        Accessor to the legend's position of the Drawables inside the Graph.

        Returns
        -------
        position : str
            Legend's position used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions
        """
        return _graph.Graph_getLegendPosition(self)

    def setLegendPosition(self, position):
        r"""
        Accessor to the legend's position of the Drawables inside the Graph.

        Parameters
        ----------
        position : str
            Legend's position used for the drawables contained inside the Graph.
            The valid positions are given by the method :meth:`GetValidLegendPositions`.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'upper right'
        >>> # Create an empty graph
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
        >>> graph.setLegendPosition('lower left')
        >>> print(graph.getLegendPosition())
        lower left
        """
        return _graph.Graph_setLegendPosition(self, position)

    def getLegendFontSize(self):
        r"""
        Accessor to the legends' font size of the Drawables inside the Graph.

        Returns
        -------
        fontSize : float
            Legends' font size used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendFontSize
        """
        return _graph.Graph_getLegendFontSize(self)

    def setLegendFontSize(self, legendFontSize):
        r"""
        Accessor to the legend's font size of the Drawables inside the Graph.

        Parameters
        ----------
        fontSize : float
            Legend's font size used for the drawables contained inside the Graph.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an empty graph
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, 'upper right')
        >>> graph.setLegendFontSize(15.0)
        >>> print(graph.getLegendFontSize())
        15.0
        """
        return _graph.Graph_setLegendFontSize(self, legendFontSize)

    @staticmethod
    def IsValidLegendPosition(position):
        r"""
        Test if the proposed legend position is valid or not.

        Parameters
        ----------
        position : str
            Proposed legend position of the Drawables inside the Graph.

        Returns
        -------
        validity : bool
            *True* if the proposed legend position is valid, *False* if it is not.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
        False
        >>> print(ot.Graph.IsValidLegendPosition('upper left'))
        True
        """
        return _graph.Graph_IsValidLegendPosition(position)

    @staticmethod
    def GetValidLegendPositions():
        r"""
        Accessor to the list of valid legend positions.

        Returns
        -------
        listPositions : :class:`~openturns.Description`
            All the valid legend positions.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.GetValidLegendPositions())
        [,best,upper right,upper left,lower right,lower left,center right,...
        """
        return _graph.Graph_GetValidLegendPositions()

    def setLegendCorner(self, corner):
        r"""
        Accessor to the legend's corner.

        Parameters
        ----------
        corner : sequence of float
            Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
            The position of the legend relatively to this point will depend on the orientation
            given by the :meth:`getLegendPosition` value.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'upper left'  # the legend's upper left corner with be set below
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
        >>> graph.setLegendCorner([1.0, 1.0])  # legend will begin in top right corner

        Notes
        -----
        This enables the legend to be located outside the graph.

        """
        return _graph.Graph_setLegendCorner(self, corner)

    def getLegendCorner(self):
        r"""
        Accessor to the legend's corner.

        Returns
        -------
        corner : :class:`~openturns.Point`
            Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
            The position of the legend relatively to this point will depend on the orientation
            given by the :meth:`getLegendPosition` value.

        """
        return _graph.Graph_getLegendCorner(self)

    def __init__(self, *args):
        _graph.Graph_swiginit(self, _graph.new_Graph(*args))
    __swig_destroy__ = _graph.delete_Graph

# Register Graph in _graph:
_graph.Graph_swigregister(Graph)

def Graph__repr_png_(self):
    """Get the PNG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'png':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
Graph._repr_png_ = Graph__repr_png_

def Graph__repr_svg_(self):
    """Get the SVG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'svg':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
Graph._repr_svg_ = Graph__repr_svg_

def Graph__repr_html_(self):
    """Get the HTML representation."""
    raise NotImplementedError
Graph._repr_html_ = Graph__repr_html_

class BarPlot(DrawableImplementation):
    r"""
    Bar plot.

    Available constructors:
        BarPlot(*data, origin, legend=' '*)

        BarPlot(*data, origin, color, fillStyle, lineStyle, legend=' '*)

        BarPlot(*data, origin, color, fillStyle, lineStyle, lineWidth, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Data from which the BarPlot is built, must be of dimension 2: the
        discontinuous points and their corresponding height.
    origin : float
        Scalar defining where the BarPlot begins.
    legend : str
        Legend of the BarPlot.
    color : str
        Color of the curve. If not specified, the default color is the first color in the default palette.
    fillStyle : str
        Fill style of the surfaces. If not specified, by default it is 'solid'.
    lineStyle : str
        Style of the curve. If not specified, by default it is 'solid'.
    lineWidth : float
        Width of the curve. If not specified, by default it is 1.

    Examples
    --------
    >>> import openturns as ot
    >>> graph = ot.Graph('BarPlot', 'X', 'Y', True, 'topright')
    >>> origin = 0.0
    >>> data = [[1.0, 2.0], [3.0, 4.0], [2.0, 3.0]]
    >>> barPlot = ot.BarPlot(data, origin, 'orange', 'shaded', 'dashed', 'label')
    >>> graph.add(barPlot)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.BarPlot_getClassName(self)

    def __repr__(self):
        return _graph.BarPlot___repr__(self)

    def getOrigin(self):
        r"""
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.BarPlot_getOrigin(self)

    def setOrigin(self, origin):
        r"""
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.BarPlot_setOrigin(self, origin)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element
        """
        return _graph.BarPlot_getBoundingBox(self)

    def __init__(self, *args):
        _graph.BarPlot_swiginit(self, _graph.new_BarPlot(*args))
    __swig_destroy__ = _graph.delete_BarPlot

# Register BarPlot in _graph:
_graph.BarPlot_swigregister(BarPlot)
class Cloud(DrawableImplementation):
    r"""
    Cloud.

    Available constructors:
        Cloud(*data, legend=' '*)

        Cloud(*dataX, dataY, legend=' '*)

        Cloud(*data, color, pointStyle, legend=' '*)

        Cloud(*dataComplex, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Points from which the cloud is built.
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        Points from which the cloud is built.
    legend : str
        Legend of the Cloud.
    color : str
        Color of the points. If not specified, the default color is the first color in the default palette.
    pointStyle : str
        Style of the points. If not specified, by default it is 'plus'.
    dataComplex : :class:`~openturns.ComplexCollection`
        Collection of complex points.

    Examples
    --------
    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(2)
    >>> R[1, 0] = -0.25
    >>> distribution = ot.Normal([-1.5, 0.5], [4.0, 1.0], R)
    >>> sample = distribution.getSample(100)
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, '')
    >>> # Create the cloud
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'My Cloud')
    >>> myGraph.add(myCloud)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Cloud_getClassName(self)

    def __repr__(self):
        return _graph.Cloud___repr__(self)

    def __init__(self, *args):
        _graph.Cloud_swiginit(self, _graph.new_Cloud(*args))
    __swig_destroy__ = _graph.delete_Cloud

# Register Cloud in _graph:
_graph.Cloud_swigregister(Cloud)
class Contour(DrawableImplementation):
    r"""
    Contour.

    Available constructors:

        Contour(*dimX, dimY, data*)

        Contour(*sampleX, sampleY, data*)

    Parameters
    ----------
    dimX, dimY : int
        Dimensions of *data*.
    data : 2-d sequence of float of dimension 1 and of size :math:`dimX*dimY`
        These values are those of a function :math:`f: \Rset^2 \rightarrow \Rset`
        on each point of the grid with *dimX* points along the :math:`X`-direction
        and *dimY* points along the :math:`Y`-direction. The :math:`(X, Y)`-
        values are stored row-by-row.
    sampleX, sampleY : two 2-d sequences of float of dimension 1
        First and second coordinates. If not specified the points are equally
        spaced in :math:`[0, 1]` along the :math:`X` and :math:`Y`-directions.

    Examples
    --------

    Using the first constructor:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x', 'y'], ['exp(-sin(cos(y)^2*x^2+sin(x)^2*y^2))'])
    >>> # Generate the data for the curves to be drawn
    >>> nX = 75
    >>> nY = 75
    >>> inputData = ot.Box([nX, nY]).generate()
    >>> inputData *= [10.0] * 2
    >>> inputData += [-5.0] * 2
    >>> data = f(inputData)
    >>> levels = [(0.5 + i) / 5 for i in range(5)]
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('Complex iso lines', 'u1', 'u2', True)
    >>> # Create the contour
    >>> myContour = ot.Contour(nX + 2, nY + 2, data)
    >>> myContour.setLevels(levels)
    >>> myGraph.add(myContour)

    Using the second constructor:

    >>> import openturns as ot
    >>> g = ot.SymbolicFunction(['R','S'],['(R * S)^0.75'])
    >>> # Generate the data for the curves to be drawn
    >>> nX = 10
    >>> nY = 10
    >>> lowerBound = [1.6, 0.0]
    >>> upperBound = [6.3, 4.3]
    >>> bounds = ot.Interval(lowerBound, upperBound)
    >>> boxExperiment = ot.Box([nX, nY], bounds)
    >>> inputSample = boxExperiment.generate()
    >>> outputSample = g(inputSample)
    >>> # Generate the grid for the contour plot
    >>> xstep = (upperBound[0] - lowerBound[0])/(nX + 1)
    >>> x = ot.RegularGrid(lowerBound[0], xstep, nX + 2).getVertices()
    >>> ystep = (upperBound[1] - lowerBound[1])/(nY + 1)
    >>> y = ot.RegularGrid(lowerBound[1], ystep, nY + 2).getVertices()
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('Complex iso lines', 'u1', 'u2', True, '')
    >>> levels = [-1.0, 1.0, 3.0, 5.0, 7.0, 9.0]
    >>> labels = ['Level 0', 'Level 1', 'Level 2', 'Level 3', 'Level 4', 'Level 5']
    >>> drawLabels = True
    >>> # Create the contour and plot it
    >>> myContour = ot.Contour(x, y, outputSample)
    >>> myContour.setLevels(levels)
    >>> myContour.setLabels(labels)
    >>> myContour.setDrawLabels(drawLabels)
    >>> myGraph.add(myContour)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Contour_getClassName(self)

    def __repr__(self):
        return _graph.Contour___repr__(self)

    def setColor(self, color):
        r"""
        Accessor to the color of the drawable element.

        Parameters
        ----------
        color : str
            Describes the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        See Also
        --------
        getColor, GetValidColors, getColorCode
        """
        return _graph.Contour_setColor(self, color)

    def getX(self):
        r"""
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.Sample`
            Values of the first coordinate.
        """
        return _graph.Contour_getX(self)

    def setX(self, x):
        r"""
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph.Contour_setX(self, x)

    def getY(self):
        r"""
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.Sample`
            Values of the second coordinate.
        """
        return _graph.Contour_getY(self)

    def setY(self, y):
        r"""
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph.Contour_setY(self, y)

    def getLevels(self):
        r"""
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.Point`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph.Contour_getLevels(self)

    def setLevels(self, levels):
        r"""
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph.Contour_setLevels(self, levels)

    def getLabels(self):
        r"""
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.Contour_getLabels(self)

    def setLabels(self, labels):
        r"""
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.Contour_setLabels(self, labels)

    def getDrawLabels(self):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Contour_getDrawLabels(self)

    def setDrawLabels(self, drawLabels):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Contour_setDrawLabels(self, drawLabels)

    def isFilled(self):
        r"""
        Accessor to the isFilled flag of the Contour element.

        Returns
        -------
        isFilled : bool
            True if the iso-curves must be filled.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Contour(2,2,ot.Sample(4,1)).isFilled())
        False

        See Also
        --------
        setIsFilled
        """
        return _graph.Contour_isFilled(self)

    def setIsFilled(self, isFilled):
        r"""
        Accessor to the flag isFilled of the Contour element.

        Parameters
        ----------
        isFilled : bool
            True if the iso-curves must be filled.

        See Also
        --------
        isFilled
        """
        return _graph.Contour_setIsFilled(self, isFilled)

    def getColorBarPosition(self):
        r"""
        Accessor to the color position inside the graph containing the Contour element.

        Returns
        -------
        colorBarPosition : str
            The name of the color bar position or '' if the color bar should not be displayed.

        Examples
        --------
        >>> import openturns as ot
        >>> contour = ot.Contour(2,2,ot.Sample(4,1))
        >>> contour.setColorBarPosition('right')
        >>> print(contour.getColorBarPosition())
        right

        See Also
        --------
        setColorBarPosition
        """
        return _graph.Contour_getColorBarPosition(self)

    def setColorBarPosition(self, colorBarPosition):
        r"""
        Accessor to the color position inside the graph containing the Contour element.

        Parameters
        ----------
        colorBarPosition : str
            The name of the color bar position or '' if the color bar should not be displayed.

        See Also
        --------
        getColorBarPosition
        """
        return _graph.Contour_setColorBarPosition(self, colorBarPosition)

    def isVminUsed(self):
        r"""
        Accessor to the flag isVminUsed of the Contour element.
        If false, the *vmin* value is ignored.

        Returns
        -------
        isVminUsed : bool
            The flag isVminUsed of the Contour element.

        Examples
        --------
        >>> import openturns as ot
        >>> contour = ot.Contour(2,2,ot.Sample(4,1))
        >>> print(contour.isVminUsed())
        False

        See Also
        --------
        setIsVminUsed
        """
        return _graph.Contour_isVminUsed(self)

    def setIsVminUsed(self, used):
        r"""
        Accessor to the flag isVminUsed of the Contour element.
        If false, the *vmin* value is ignored.

        Parameters
        ----------
        used : bool
            The flag isVminUsed of the Contour element.

        See Also
        --------
        isVminUsed
        """
        return _graph.Contour_setIsVminUsed(self, used)

    def getVmin(self):
        r"""
        Accessor to the vmin value of the Contour element.

        Returns
        -------
        vmin : float
            The vmin value of the Contour element.

        Examples
        --------
        >>> import openturns as ot
        >>> contour = ot.Contour(2,2,ot.Sample(4,1))
        >>> contour.setVmin(5.0)
        >>> print(contour.getVmin())
        5.0

        Notes
        -----
        The full documentation is available in the Matplotlib
        `contour <https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.contour.html>`_
        page.

        See Also
        --------
        setVmin
        """
        return _graph.Contour_getVmin(self)

    def setVmin(self, vmin):
        r"""
        Accessor to the vmin value of the Contour element.

        Parameters
        ----------
        vmin : float
            The vmin value of the Contour element.

        Notes
        -----
        The full documentation is available in the Matplotlib
        `contour <https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.contour.html>`_
        page.

        See Also
        --------
        getVmin
        """
        return _graph.Contour_setVmin(self, vmin)

    def isVmaxUsed(self):
        r"""
        Accessor to the flag isVmaxUsed of the Contour element.
        If false, the *vmax* value is ignored.

        Returns
        -------
        isVmaxUsed : bool
            The flag isVmaxUsed of the Contour element.

        Examples
        --------
        >>> import openturns as ot
        >>> contour = ot.Contour(2,2,ot.Sample(4,1))
        >>> print(contour.isVmaxUsed())
        False

        See Also
        --------
        setIsVmaxUsed
        """
        return _graph.Contour_isVmaxUsed(self)

    def setIsVmaxUsed(self, used):
        r"""
        Accessor to the flag isVmaxUsed of the Contour element.
        If false, the *vmax* value is ignored.

        Parameters
        ----------
        used : bool
            The flag isVmaxUsed of the Contour element.

        See Also
        --------
        isVmaxUsed
        """
        return _graph.Contour_setIsVmaxUsed(self, used)

    def getVmax(self):
        r"""
        Accessor to the vmax value of the Contour element.

        Returns
        -------
        vmax : float
            The vmax value of the Contour element.

        Examples
        --------
        >>> import openturns as ot
        >>> contour = ot.Contour(2,2,ot.Sample(4,1))
        >>> contour.setVmax(5.0)
        >>> print(contour.getVmax())
        5.0

        Notes
        -----
        The full documentation is available in the Matplotlib
        `contour <https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.contour.html>`_
        page.

        See Also
        --------
        setVmax
        """
        return _graph.Contour_getVmax(self)

    def setVmax(self, vmax):
        r"""
        Accessor to the vmax value of the Contour element.

        Parameters
        ----------
        vmax : float
            The vmax value of the Contour element.

        Notes
        -----
        The full documentation is available in the Matplotlib
        `contour <https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.contour.html>`_
        page.

        See Also
        --------
        getVmax
        """
        return _graph.Contour_setVmax(self, vmax)

    def getColorMap(self):
        r"""
        Accessor to the color map name of the Contour element.

        Returns
        -------
        colorMap : str
            The name of the color map used to color the Contour element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Contour(2,2,ot.Sample(4,1)).getColorMap())
        viridis

        See Also
        --------
        setColorMap, GetValidColorMaps
        """
        return _graph.Contour_getColorMap(self)

    def setColorMap(self, colorMap):
        r"""
        Accessor to the name of the color map used to color the Contour element.

        Parameters
        ----------
        colorMap : str
            The name of the color map used to color the Contour element. Use :meth:`GetValidColorMaps`
            for a list of available values.

        See Also
        --------
        getColorMap, GetValidColorMaps
        """
        return _graph.Contour_setColorMap(self, colorMap)

    def getColorMapNorm(self):
        r"""
        Accessor to the normalization method of the Contour element.

        Returns
        -------
        norm : str
            The name of the normalization method used to scale scalar data to the [0, 1] range before
            mapping to colors using the color map.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Contour(2,2,ot.Sample(4,1)).getColorMapNorm())
        linear

        See Also
        --------
        setColorMapNorm, GetValidNorms
        """
        return _graph.Contour_getColorMapNorm(self)

    def setColorMapNorm(self, norm):
        r"""
        Accessor to the normalization method of the Contour element.

        Parameters
        ----------
        norm : str
            The name of the normalization method used to scale scalar data to the [0, 1] range before
            mapping to colors using the color map. Use :meth:`GetValidNorms` for a list of
            available values.

        See Also
        --------
        getColorMapNorm, GetValidNorms
        """
        return _graph.Contour_setColorMapNorm(self, norm)

    def getExtend(self):
        r"""
        Accessor to the filling mode of values that are outside the levels range of the Contour element.

        Returns
        -------
        extend : str
            Determines the color filling of values that are outside the levels range.
            If 'neither', values outside the levels range are not colored. If 'min',
            'max' or 'both', color the values below, above or below and above the levels range.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Contour(2,2,ot.Sample(4,1)).getExtend())
        both

        See Also
        --------
        setExtend, GetValidExtends
        """
        return _graph.Contour_getExtend(self)

    def setExtend(self, extend):
        r"""
        Accessor to the filling mode of values that are outside the levels range of the Contour element.

        Parameters
        ----------
        extend : str
            Determines the color filling of values that are outside the levels range.
            If 'neither', values outside the levels range are not colored. If 'min',
            'max' or 'both', color the values below, above or below and above the levels range.
            Use :meth:`GetValidExtends` for a list of available values.

        See Also
        --------
        getExtend, GetValidExtends
        """
        return _graph.Contour_setExtend(self, extend)

    def getHatches(self):
        r"""
        Accessor to the hatches used for filling the contour element.

        Returns
        -------
        hatches : :class:`~openturns.Description`
            A list of cross hatch patterns to use on the filled areas.
            Hatches can use following characters : /\|-+xoO.*
        """
        return _graph.Contour_getHatches(self)

    def setHatches(self, hatches):
        r"""
        Accessor to the hatches used for filling the contour element.

        Parameters
        ----------
        hatches : sequence of str
            A list of cross hatch patterns to use on the filled areas.
            Hatches can use following characters : /\|-+xoO.*
        """
        return _graph.Contour_setHatches(self, hatches)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element
        """
        return _graph.Contour_getBoundingBox(self)

    def buildDefaultLevels(self, *args):
        r"""
        Build default levels.

        Parameters
        ----------
        n : int
            Number of levels. If not specified, the default value is taken in the
            :class:`~openturns.ResourceMap` in the `Contour-DefaultLevelsNumber` key and :math:`n=10`.

        Notes
        -----
        It builds :math:`n` level values and the associated labels which are the level
        values. The level values are the empirical quantiles of the data to be sliced
        at orders :math:`q_k` regularly distributed over :math:`]0,1[`:
        :math:`q_k = \frac{1}{n} \left( k+ \frac{1}{2} \right)` for
        :math:`0 \leq k \leq n-1`.

        """
        return _graph.Contour_buildDefaultLevels(self, *args)

    def buildDefaultLabels(self):
        r"""Build default labels by taking the level values."""
        return _graph.Contour_buildDefaultLabels(self)

    def __init__(self, *args):
        _graph.Contour_swiginit(self, _graph.new_Contour(*args))
    __swig_destroy__ = _graph.delete_Contour

# Register Contour in _graph:
_graph.Contour_swigregister(Contour)
class Curve(DrawableImplementation):
    r"""
    Curve.

    Available constructors:
        Curve(*data, legend=' '*)

        Curve(*dataX, dataY, legend=' '*)

        Curve(*data, color, lineStyle, lineWidth, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Points from which the curve is built.
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        Points from which the curve is built.
    legend : str
        Legend of the Curve.
    color : str
        Color of the curve. If not specified, by default it is the first color of the default palette.
    lineStyle : str
        Style of the curve. If not specified, by default it is 'solid'.
    lineWidth : float
        Width of the curve. If not specified, by default it is 1.

    Examples
    --------
    >>> import openturns as ot
    >>> from math import pi, sin
    >>> # Generate the data for the curve to be drawn
    >>> data = [[-3 * pi + 6 * pi * i / 100, sin(-3 * pi + 6 * pi * i / 100)] for i in range(100)]
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('A curve', 'x', 'sin(x)', True, '')
    >>> # Create the curve
    >>> myCurve = ot.Curve(data, 'blue', 'solid', 2, '')
    >>> myGraph.add(myCurve)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Curve_getClassName(self)

    def __repr__(self):
        return _graph.Curve___repr__(self)

    def __init__(self, *args):
        _graph.Curve_swiginit(self, _graph.new_Curve(*args))
    __swig_destroy__ = _graph.delete_Curve

# Register Curve in _graph:
_graph.Curve_swigregister(Curve)
class GridLayout(openturns.common.PersistentObject):
    r"""
    Organize subgraphs in a grid.

    Parameters
    ----------
    nb_rows : int
        Number of grid rows
    nb_cols : int
        Number of grid columns

    Examples
    --------
    >>> import openturns as ot
    >>> grid = ot.GridLayout(2, 3)
    >>> for j in range(grid.getNbColumns()):
    ...    beta = 1.0 + j
    ...    grid.setGraph(0, j, ot.Gumbel(beta, 0.0).drawPDF())
    ...    grid.setGraph(1, j, ot.Gumbel(beta, 0.0).drawCDF())
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.GridLayout_getClassName(self)

    def __init__(self, nbRows=0, nbColumns=0):
        _graph.GridLayout_swiginit(self, _graph.new_GridLayout(nbRows, nbColumns))

    def __repr__(self):
        return _graph.GridLayout___repr__(self)

    def getNbRows(self):
        r"""
        Row count accessor (grid layout only).

        Returns
        -------
        nb_rows : int
            Number of grid rows.
        """
        return _graph.GridLayout_getNbRows(self)

    def getNbColumns(self):
        r"""
        Column count accessor (grid layout only).

        Returns
        -------
        nb_rows : int
            Number of grid columns.
        """
        return _graph.GridLayout_getNbColumns(self)

    def getGraph(self, i, j):
        r"""
        Subgraph accessor (grid layout only).

        Parameters
        ----------
        i : int
            Row index
        j : int
            Column index

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Subgraph at (i, j).
        """
        return _graph.GridLayout_getGraph(self, i, j)

    def setGraph(self, i, j, elt):
        r"""
        Subgraph accessor (grid layout only).

        Parameters
        ----------
        i : int
            Row index
        j : int
            Column index
        graph : :class:`~openturns.Graph`
            Subgraph at (i, j).
        """
        return _graph.GridLayout_setGraph(self, i, j, elt)

    def getGraphCollection(self):
        r"""
        Accessor to the collection of graphs.

        Returns
        -------
        coll : Collection of :class:`~openturns.Graph`
            The graphs stored into the :class:`~openturns.GridLayout`.
        """
        return _graph.GridLayout_getGraphCollection(self)

    def setGraphCollection(self, coll):
        r"""
        Accessor to the collection of graphs.

        Parameters
        ----------
        coll : sequence of :class:`~openturns.Graph`
            The graphs to store into the :class:`~openturns.GridLayout`. The collection must have at most :math:`nbRows\times nbColumns` elements.
        """
        return _graph.GridLayout_setGraphCollection(self, coll)

    def setLayout(self, nbRows, nbColumns):
        r"""
        Accessor to the layout.

        Parameters
        ----------
        nbRows : int
            The new number of rows.
        nbColumns : int
            The new number of columns.

        Notes
        -----
        If the new layout contains fewer graphs than the old layout, the remaining graphs are removed from the layout.
        """
        return _graph.GridLayout_setLayout(self, nbRows, nbColumns)

    def setAxes(self, showAxes):
        r"""
        Accessor to the indication of axes' presence on the Graph.

        Parameters
        ----------
        axes : bool
            *True* to draw the axes, *False* to hide the axes.
        """
        return _graph.GridLayout_setAxes(self, showAxes)

    def setLegendPosition(self, position):
        r"""
        Accessor to the legend's position of the subgraphs.

        Parameters
        ----------
        position : str
            Legend's position used for the subgraphs contained inside the Graph.
        """
        return _graph.GridLayout_setLegendPosition(self, position)

    def setTitle(self, title):
        r"""
        Accessor to the title.

        Parameters
        ----------
        title : str
            Graph title.
        """
        return _graph.GridLayout_setTitle(self, title)

    def getTitle(self):
        r"""
        Accessor to the title.

        Returns
        -------
        title : str
            Graph title.
        """
        return _graph.GridLayout_getTitle(self)

    def add(self, grid):
        r"""
        Add subgraphs from a different grid to the corresponding subgraphs in the current grid.

        Parameters
        ----------
        grid : :class:`~openturns.GridLayout`
            GridLayout containing the subgraphs to add.

        Notes
        -----
        Only works if both grids have the same number of rows and columns,
        because the (i,j)-th graph of the provided *grid* is added to the (i,j)-th graph of the original grid
        with the :meth:`~openturns.Graph.add` method.
        """
        return _graph.GridLayout_add(self, grid)
    __swig_destroy__ = _graph.delete_GridLayout

# Register GridLayout in _graph:
_graph.GridLayout_swigregister(GridLayout)

def GridLayout__repr_png_(self):
    """Get the PNG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'png':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
GridLayout._repr_png_ = Drawable__repr_png_

def GridLayout__repr_svg_(self):
    """Get the SVG representation."""
    if openturns.common.ResourceMap.Get('View-ImageFormat') != 'svg':
        raise NotImplementedError
    from .viewer import _ToImageString
    return _ToImageString(self)
GridLayout._repr_svg_ = Drawable__repr_svg_

def GridLayout__repr_html_(self):
    """Get the HTML representation."""
    raise NotImplementedError
GridLayout._repr_html_ = Drawable__repr_html_

class Pie(DrawableImplementation):
    r"""
    Pie.

    Available constructors:
        Pie(*data*)

        Pie(*data, labels*)

        Pie(*data, labels, center, radius, palette*)

    Parameters
    ----------
    data : sequence of float
        Sequence giving the percentiles of the pie.
    labels : sequence of str
        Names of each group. If not specified, by default equal to the description
        of the probabilistic input vector.
    center : sequence of float
        Center of the pie inside the bounding box. If not specified, by default it
        is (0,0).
    radius : positive float
        Radius of the pie. If not specified, by default it is 1.
    palette : sequence of str
        Names of the colors. If not specified, colors are successively taken from
        the list given by :meth:`buildDefaultPalette`, in the same order.

    Examples
    --------
    >>> import openturns as ot
    >>> # Create the Pie
    >>> myPie = ot.Pie([0.4, 0.3, 0.2, 0.1], ['a0', 'a1', 'a2', 'a3'])
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('A Pie', ' ', ' ', True, '')
    >>> myGraph.add(myPie)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Pie_getClassName(self)

    def __repr__(self):
        return _graph.Pie___repr__(self)

    def getCenter(self):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.Point`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Pie_getCenter(self)

    def setCenter(self, center):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Pie_setCenter(self, center)

    def getRadius(self):
        r"""
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Pie_getRadius(self)

    def setRadius(self, radius):
        r"""
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Pie_setRadius(self, radius)

    def getLabels(self):
        r"""
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.Pie_getLabels(self)

    def setLabels(self, labels):
        r"""
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.Pie_setLabels(self, labels)

    def getPalette(self):
        r"""
        Accessor to the names of the colors used for the Drawable.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Drawable`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.Pie_getPalette(self)

    def setPalette(self, palette):
        r"""
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.Pie_setPalette(self, palette)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element
        """
        return _graph.Pie_getBoundingBox(self)

    def buildDefaultPalette(self):
        r"""
        Build default palette.

        Call :meth:`BuildDefaultPalette` with :math:`n` the size of *data* as argument.
        """
        return _graph.Pie_buildDefaultPalette(self)

    def buildDefaultLabels(self):
        r"""Build default labels by taking the percentiles."""
        return _graph.Pie_buildDefaultLabels(self)

    @staticmethod
    def IsValidColorPalette(palette):
        r"""
        Test the validity of a color palette.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors.

        Returns
        -------
        validity : bool
            *True* if *palette* is valid or *False* otherwise.

        Examples
        --------
        >>> import openturns as ot
        >>> pie = ot.Pie([0.5,0.2,0.3])
        >>> print(pie.IsValidColorPalette(['#ff0000','#ccff00','#00ff66']))
        True
        >>> print(pie.IsValidColorPalette(['green','red','darkorange']))
        True
        >>> print(pie.IsValidColorPalette(['green','red','darkpink']))
        False
        """
        return _graph.Pie_IsValidColorPalette(palette)

    def __init__(self, *args):
        _graph.Pie_swiginit(self, _graph.new_Pie(*args))
    __swig_destroy__ = _graph.delete_Pie

# Register Pie in _graph:
_graph.Pie_swigregister(Pie)
class Polygon(DrawableImplementation):
    r"""
    Polygon.

    Available constructors:
        Polygon(*legend=' '*)

        Polygon(*data, legend=' '*)

        Polygon(*dataX, dataY, legend=' '*)

        Polygon(*data, color, edgeColor, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float of dimension 2
        Vertices of the polygon.
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        List of the first and second coordinates of the vertices.
    legend : str
        Legend of the polygon.
    color, edgeColor : two str
        Fill color and the edge color. If not specified, the default color is the first color in the default palette.

    Examples
    --------
    >>> import openturns as ot
    >>> # Generate the data for the polygons to be drawn
    >>> data =[[9.0*i/51, (9.0*i/51)*(9.0*i/51)] for i in range(50)]
    >>> # Create an empty graph
    >>> graph = ot.Graph('Polygon example', 'x1', 'x2', True)
    >>> polygon = ot.Polygon(data)
    >>> polygon.setColor('red')
    >>> graph.add(polygon)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Polygon_getClassName(self)

    def __repr__(self):
        return _graph.Polygon___repr__(self)

    def setEdgeColor(self, edgeColor):
        r"""
        Set the color of the Polygon edge.

        Parameters
        ----------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.Polygon_setEdgeColor(self, edgeColor)

    def getEdgeColor(self):
        r"""
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.Polygon_getEdgeColor(self)

    @staticmethod
    def FillBetween(*args):
        r"""
        Fill an area between two curves.

        Parameters
        ----------
        dataX : 2-d sequence of float of dimension 1, or sequence of float
            First coordinates common to the curves.
        dataY1 : 2-d sequence of float of dimension 1, or sequence of float
            Second coordinates of the first curve.
        dataY2 : 2-d sequence of float of dimension 1, or sequence of float
            Second coordinates of the second curve.

        Returns
        -------
        polygon : :class:`~openturns.Polygon`
            Polygon which fills the surface between the two curves.

        Examples
        --------
        >>> import openturns as ot
        >>> from math import pi, sin
        >>> # Generate the data for the curve to be drawn
        >>> data = [[-3 * pi + 6 * pi * i / 100, sin(-3 * pi + 6 * pi * i / 100)] for i in range(100)]
        >>> # Create the curve
        >>> curve = ot.Curve(data, 'blue', 'solid', 2, '')
        >>> # Create the polygon to fill between the curve and the x-axis
        >>> x = [xy[0] for xy in data]
        >>> y = [xy[1] for xy in data]
        >>> polygon = ot.Polygon.FillBetween(x, y, [0.] * len(data))
        >>> # Create an empty graph
        >>> graph = ot.Graph('A filled curve', 'x', 'sin(x)', True, '')
        >>> # Add drawables into the graph
        >>> graph.add(curve)
        >>> graph.add(polygon)
        """
        return _graph.Polygon_FillBetween(*args)

    def __init__(self, *args):
        _graph.Polygon_swiginit(self, _graph.new_Polygon(*args))
    __swig_destroy__ = _graph.delete_Polygon

# Register Polygon in _graph:
_graph.Polygon_swigregister(Polygon)
class _PolygonCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _graph.delete__PolygonCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _graph._PolygonCollection_clear(self)

    def __len__(self):
        return _graph._PolygonCollection___len__(self)

    def __eq__(self, rhs):
        return _graph._PolygonCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _graph._PolygonCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _graph._PolygonCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _graph._PolygonCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _graph._PolygonCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _graph._PolygonCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _graph._PolygonCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _graph._PolygonCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _graph._PolygonCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _graph._PolygonCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _graph._PolygonCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _graph._PolygonCollection_find(self, val)

    def __repr__(self):
        return _graph._PolygonCollection___repr__(self)

    def __str__(self, *args):
        return _graph._PolygonCollection___str__(self, *args)

    def __init__(self, *args):
        _graph._PolygonCollection_swiginit(self, _graph.new__PolygonCollection(*args))

# Register _PolygonCollection in _graph:
_graph._PolygonCollection_swigregister(_PolygonCollection)
class PolygonArray(DrawableImplementation):
    r"""
    Polygon array.

    Available constructors:
        PolygonArray(*legend=' '*)

        PolygonArray(*polygons, legend=' '*)

        PolygonArray(*coordinates, verticesNumber, palette, legend=' '*)

    Parameters
    ----------
    legend : str
        Legend of the Cloud.
    polygons : sequence of :class:`~openturns.Polygon`
        Sequence of polygons.
    coordinates : 2-d sequence of float
        The list of coordinates.
    verticesNumber : int
        Number of vertices.
    palette : sequence of str
        Polygon colors.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> generator = ot.Normal(2)
    >>> size = 5
    >>> array = []
    >>> palette = ot.Drawable.BuildDefaultPalette(size)
    >>> for i in range(size):
    ...     vertices = generator.getSample(3)
    ...     array.append(ot.Polygon(vertices, palette[i], palette[size - i - 1]))
    >>> graph = ot.Graph('An array of polygons', 'x', 'y', True, '')
    >>> graph.add(ot.PolygonArray(array))
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.PolygonArray_getClassName(self)

    def __repr__(self):
        return _graph.PolygonArray___repr__(self)

    def setPalette(self, palette):
        r"""
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.PolygonArray_setPalette(self, palette)

    def getPalette(self):
        r"""
        Accessor to the names of the colors used for the Drawable.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Drawable`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.PolygonArray_getPalette(self)

    def setCoordinatesAndVerticesNumber(self, coordinates, verticesNumber):
        r"""
        Accessor to the coordinates of polygons.

        Parameters
        ----------
        coordinates : 2-d sequence of float
            The list of coordinates.
        verticesNumber : int
            number of vertices.
        """
        return _graph.PolygonArray_setCoordinatesAndVerticesNumber(self, coordinates, verticesNumber)

    def getCoordinates(self):
        r"""
        Accessor to the color of each polygon.

        Returns
        -------
        coordinates : :class:`~openturns.Sample`
            Polygon coordinates.
        """
        return _graph.PolygonArray_getCoordinates(self)

    def getVerticesNumber(self):
        r"""
        Accessor to the number of vertices.

        Returns
        -------
        verticesNumber : int
            Number of vertices.
        """
        return _graph.PolygonArray_getVerticesNumber(self)

    def __init__(self, *args):
        _graph.PolygonArray_swiginit(self, _graph.new_PolygonArray(*args))
    __swig_destroy__ = _graph.delete_PolygonArray

# Register PolygonArray in _graph:
_graph.PolygonArray_swigregister(PolygonArray)
class Staircase(DrawableImplementation):
    r"""
    Staircase.

    Available constructors:
        Staircase(*data, legend=' '*)

        Staircase(*data, color, lineStyle, lineWidth, pattern, legend=' '*)

        Staircase(*data, color, lineStyle, pattern, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Points from which the Staircase is built, must be of dimension 2: the
        discontinuous points and their corresponding height.
    legend : str
        Legend of the Staircase.
    color : str
        Color of the curve. If not specified, the default color is the first color in the default palette.
    lineStyle : str
        Style of the curve. If not specified, by default it is 'solid'.
    lineWidth : float 
        Width of the curve. If not specified, by default it is 1.
    pattern : str
        Pattern which is 'S' or 's'. By default the pattern is equal to 's'. Going
        from :math:`(x_1, y_1)` to :math:`(x_2, y_2)` with :math:`x_1<x_2`,
        pattern='s' moves first horizontal then vertical, whereas pattern='S' moves
        the other way around.

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.Normal([0.5], [2.], ot.CorrelationMatrix(1))
    >>> sample = distribution.getSample(200)
    >>> # Construct empirical CDF for the sample
    >>> data = ot.Sample(20, 2)
    >>> for i in range(20):
    ...     c0 = 13.0 * i / 20.0 - 6.5
    ...     count = 0
    ...     for j in range(200):
    ...         if sample[j, 0] < c0:
    ...             count += 1
    ...     c1 = count / 200.0
    ...     data[i] = [c0, c1]
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('A staircase', 'x1', 'x2', True, 'upper left')
    >>> # Create the staircase
    >>> myStaircase = ot.Staircase(data, 'blue', 'solid', 's', 'Normal CDF')
    >>> myGraph.add(myStaircase)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Staircase_getClassName(self)

    def __repr__(self):
        return _graph.Staircase___repr__(self)

    def getPattern(self):
        r"""
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Staircase_getPattern(self)

    def setPattern(self, style):
        r"""
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Staircase_setPattern(self, style)

    def __init__(self, *args):
        _graph.Staircase_swiginit(self, _graph.new_Staircase(*args))
    __swig_destroy__ = _graph.delete_Staircase

# Register Staircase in _graph:
_graph.Staircase_swigregister(Staircase)
class Text(DrawableImplementation):
    r"""
    Text.

    Available constructors:
        Text(*data, texts, position='top', legend=''*)

        Text(*dataX, dataY, texts, position='top', legend=''*)

    Parameters
    ----------
    data : 2-d sequence of float
        Locations of texts
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        X and Y-locations of texts
    texts : sequence of str
        Text content
    position : str, default='top'
        Text position; valid values are 'top', 'bottom', 'left' or 'right'
    legend : str, default=''
        Legend of the Text.

    Examples
    --------
    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(2)
    >>> R[1, 0] = -0.25
    >>> distribution = ot.Normal([-1.5, 0.5], [4.0, 1.0], R)
    >>> sample = distribution.getSample(20)
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, '')
    >>> # Create the cloud
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'My Cloud')
    >>> myGraph.add(myCloud)
    >>> # Add annotations
    >>> texts = ot.Description(5)
    >>> for i in range(5): texts[i] = str(i+1)
    >>> myText = ot.Text(sample[0:5,:], texts)
    >>> myGraph.add(myText)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Text_getClassName(self)

    @staticmethod
    def IsValidTextPosition(textPosition):
        r"""
        Text position identifier check.

        Parameters
        ----------
        pos : str
            Text position identifier

        Returns
        -------
        isValid : bool
            Whether the position is a valid identifier
        """
        return _graph.Text_IsValidTextPosition(textPosition)

    def __repr__(self):
        return _graph.Text___repr__(self)

    def getTextAnnotations(self):
        r"""
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Text_getTextAnnotations(self)

    def setTextAnnotations(self, textAnnotations):
        r"""
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Text_setTextAnnotations(self, textAnnotations)

    def getTextPositions(self):
        r"""
        Accessor to the position of annotations.

        Returns
        -------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  
            Text is written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Text_getTextPositions(self)

    def setTextPositions(self, textPositions):
        r"""
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Text_setTextPositions(self, textPositions)

    def getTextSize(self):
        r"""
        Accessor to the text size.

        Returns
        -------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph.Text_getTextSize(self)

    def setTextSize(self, size):
        r"""
        Accessor to the text size.

        Parameters
        ----------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph.Text_setTextSize(self, size)

    def getRotation(self):
        r"""
        Text rotation accessor.

        Returns
        -------
        rotation : float
            Rotation angle, default value is 0.0
        """
        return _graph.Text_getRotation(self)

    def setRotation(self, rotation):
        r"""
        Text rotation accessor.

        Parameters
        ----------
        rotation : float
            Rotation angle, default value is 0.0
        """
        return _graph.Text_setRotation(self, rotation)

    def __init__(self, *args):
        _graph.Text_swiginit(self, _graph.new_Text(*args))
    __swig_destroy__ = _graph.delete_Text

# Register Text in _graph:
_graph.Text_swigregister(Text)
class _DrawableImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_graph._DrawableImplementationPointer_ptr__get, _graph._DrawableImplementationPointer_ptr__set)

    def __init__(self, *args):
        _graph._DrawableImplementationPointer_swiginit(self, _graph.new__DrawableImplementationPointer(*args))
    __swig_destroy__ = _graph.delete__DrawableImplementationPointer

    def reset(self):
        return _graph._DrawableImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _graph._DrawableImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _graph._DrawableImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _graph._DrawableImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _graph._DrawableImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _graph._DrawableImplementationPointer_get(self)

    def getImplementation(self):
        return _graph._DrawableImplementationPointer_getImplementation(self)

    def unique(self):
        return _graph._DrawableImplementationPointer_unique(self)

    def use_count(self):
        return _graph._DrawableImplementationPointer_use_count(self)

    def swap(self, other):
        return _graph._DrawableImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph._DrawableImplementationPointer_getClassName(self)

    def __repr__(self):
        return _graph._DrawableImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _graph._DrawableImplementationPointer___str__(self, *args)

    def __eq__(self, *args):
        return _graph._DrawableImplementationPointer___eq__(self, *args)

    def getLegend(self):
        r"""
        Accessor to the legend of the drawable element.

        Returns
        -------
        legend : str
            Legend of the drawable element.
        """
        return _graph._DrawableImplementationPointer_getLegend(self)

    def setLegend(self, legend):
        r"""
        Accessor to the legend of the drawable element.

        Parameters
        ----------
        legend : str
            Legend of the drawable element.
        """
        return _graph._DrawableImplementationPointer_setLegend(self, legend)

    def getData(self):
        r"""
        Accessor to the data from which the Drawable is built.

        Returns
        -------
        data : :class:`~openturns.Sample`
            Data from which the Drawable is built.
        """
        return _graph._DrawableImplementationPointer_getData(self)

    def getLineStyle(self):
        r"""
        Accessor to the line style of the drawable element.

        Returns
        -------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getLineStyle())
        solid
        """
        return _graph._DrawableImplementationPointer_getLineStyle(self)

    def setLineStyle(self, lineStyle):
        r"""
        Accessor to the line style of the drawable element.

        Parameters
        ----------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.
        """
        return _graph._DrawableImplementationPointer_setLineStyle(self, lineStyle)

    def getColor(self):
        r"""
        Accessor to the color of the drawable element.

        Returns
        -------
        color : str
            Name of the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColor())
        #1f77b4

        See Also
        --------
        setColor, GetValidColors, getColorCode
        """
        return _graph._DrawableImplementationPointer_getColor(self)

    def getColorCode(self):
        r"""
        Accessor to the code of the color of the drawable element.

        Returns
        -------
        color : str
            Hexadecimal code corresponding to the RGB (Red, Green, Blue) components
            of the color of the lines within the drawable element
            or the RGBA (Red, Green, Blue, Alpha) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColorCode())
        #1f77b4

        See Also
        --------
        setColor, getColor, GetValidColors
        """
        return _graph._DrawableImplementationPointer_getColorCode(self)

    def setColor(self, color):
        r"""
        Accessor to the color of the drawable element.

        Parameters
        ----------
        color : str
            Describes the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        See Also
        --------
        getColor, GetValidColors, getColorCode
        """
        return _graph._DrawableImplementationPointer_setColor(self, color)

    def getEdgeColor(self):
        r"""
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph._DrawableImplementationPointer_getEdgeColor(self)

    def getAlpha(self):
        r"""
        Accessor to the alpha blending value.

        Returns
        -------
        alpha : float
            The alpha blending value, between 0 (transparent) and 1 (opaque).

        See Also
        --------
        setAlpha
        """
        return _graph._DrawableImplementationPointer_getAlpha(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the alpha blending value.

        Parameters
        ----------
        alpha : float
            The alpha blending value, between 0 (transparent) and 1 (opaque).

        See Also
        --------
        getAlpha
        """
        return _graph._DrawableImplementationPointer_setAlpha(self, alpha)

    def getPointStyle(self):
        r"""
        Accessor to the point style of the drawable element.

        Returns
        -------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:GetValidPointStyles for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getPointStyle())
        none
        """
        return _graph._DrawableImplementationPointer_getPointStyle(self)

    def setPointStyle(self, pointStyle):
        r"""
        Accessor to the point style of the drawable element.

        Parameters
        ----------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:`GetValidPointStyles` for a list of available values.
        """
        return _graph._DrawableImplementationPointer_setPointStyle(self, pointStyle)

    def getFillStyle(self):
        r"""
        Accessor to the fill style of the drawable element.

        Returns
        -------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getFillStyle())
        solid
        """
        return _graph._DrawableImplementationPointer_getFillStyle(self)

    def setFillStyle(self, fillStyle):
        r"""
        Accessor to the fill style of the drawable element.

        Parameters
        ----------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.
        """
        return _graph._DrawableImplementationPointer_setFillStyle(self, fillStyle)

    def getLineWidth(self):
        r"""
        Accessor to the line width of the drawable element.

        Returns
        -------
        lineWidth : float
            Width of the line within the drawable element.
        """
        return _graph._DrawableImplementationPointer_getLineWidth(self)

    def setLineWidth(self, lineWidth):
        r"""
        Accessor to the line width of the drawable element.

        Parameters
        ----------
        lineWidth : positive float
            Width of the line within the drawable element.
        """
        return _graph._DrawableImplementationPointer_setLineWidth(self, lineWidth)

    def getPattern(self):
        r"""
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph._DrawableImplementationPointer_getPattern(self)

    def setPattern(self, style):
        r"""
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph._DrawableImplementationPointer_setPattern(self, style)

    def getCenter(self):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.Point`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph._DrawableImplementationPointer_getCenter(self)

    def setCenter(self, center):
        r"""
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph._DrawableImplementationPointer_setCenter(self, center)

    def getRadius(self):
        r"""
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph._DrawableImplementationPointer_getRadius(self)

    def setRadius(self, radius):
        r"""
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph._DrawableImplementationPointer_setRadius(self, radius)

    def getLabels(self):
        r"""
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph._DrawableImplementationPointer_getLabels(self)

    def setLabels(self, labels):
        r"""
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph._DrawableImplementationPointer_setLabels(self, labels)

    def getPalette(self):
        r"""
        Accessor to the names of the colors used for the Drawable.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Drawable`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph._DrawableImplementationPointer_getPalette(self)

    def setPalette(self, palette):
        r"""
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph._DrawableImplementationPointer_setPalette(self, palette)

    def getPaletteAsNormalizedRGBA(self):
        r"""
        Accessor to the Red, Green, Blue, Alpha components of the palette on a unit scale.

        Returns
        -------
        normalizedRGBAPalette : :class:`~openturns.Sample`
            Sample of the four components of each color of the palette on a unit :math:`[0,1]` scale.
        """
        return _graph._DrawableImplementationPointer_getPaletteAsNormalizedRGBA(self)

    def getOrigin(self):
        r"""
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph._DrawableImplementationPointer_getOrigin(self)

    def setOrigin(self, origin):
        r"""
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph._DrawableImplementationPointer_setOrigin(self, origin)

    def getX(self):
        r"""
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.Sample`
            Values of the first coordinate.
        """
        return _graph._DrawableImplementationPointer_getX(self)

    def setX(self, x):
        r"""
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph._DrawableImplementationPointer_setX(self, x)

    def getY(self):
        r"""
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.Sample`
            Values of the second coordinate.
        """
        return _graph._DrawableImplementationPointer_getY(self)

    def setY(self, y):
        r"""
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph._DrawableImplementationPointer_setY(self, y)

    def getLevels(self):
        r"""
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.Point`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph._DrawableImplementationPointer_getLevels(self)

    def setLevels(self, levels):
        r"""
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.

        Notes
        -----
        If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
        """
        return _graph._DrawableImplementationPointer_setLevels(self, levels)

    def getDrawLabels(self):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph._DrawableImplementationPointer_getDrawLabels(self)

    def setDrawLabels(self, drawLabels):
        r"""
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph._DrawableImplementationPointer_setDrawLabels(self, drawLabels)

    def getTextAnnotations(self):
        r"""
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph._DrawableImplementationPointer_getTextAnnotations(self)

    def setTextAnnotations(self, textAnnotations):
        r"""
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph._DrawableImplementationPointer_setTextAnnotations(self, textAnnotations)

    def getTextPositions(self):
        r"""
        Accessor to the position of annotations.

        Returns
        -------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  
            Text is written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph._DrawableImplementationPointer_getTextPositions(self)

    def setTextPositions(self, textPositions):
        r"""
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph._DrawableImplementationPointer_setTextPositions(self, textPositions)

    def getTextSize(self):
        r"""
        Accessor to the text size.

        Returns
        -------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph._DrawableImplementationPointer_getTextSize(self)

    def setTextSize(self, size):
        r"""
        Accessor to the text size.

        Parameters
        ----------
        size : float
               Size of the Text.

        Notes
        -----
        The default value is `0.75`.
        """
        return _graph._DrawableImplementationPointer_setTextSize(self, size)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element
        """
        return _graph._DrawableImplementationPointer_getBoundingBox(self)

    def GetValidColors(self):
        r"""
        Return the list of the valid colors of the drawable element.

        Returns
        -------
        validColors : :class:`~openturns.Description`
            List of the valid colors of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColors()[:5])
        [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
        """
        return _graph._DrawableImplementationPointer_GetValidColors(self)

    def GetValidLineStyles(self):
        r"""
        Return the list of the valid line styles of the drawable element.

        Returns
        -------
        validLineStyles : :class:`~openturns.Description`
            List of the valid line styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidLineStyles())
        [blank,solid,dashed,dotted,dotdash,longdash,twodash]
        """
        return _graph._DrawableImplementationPointer_GetValidLineStyles(self)

    def GetValidFillStyles(self):
        r"""
        Return the list of the valid fill styles of the drawable element.

        Returns
        -------
        validFillStyles : :class:`~openturns.Description`
            List of the valid fill styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidFillStyles()[:2])
        [solid,shaded]

        """
        return _graph._DrawableImplementationPointer_GetValidFillStyles(self)

    def GetValidPointStyles(self):
        r"""
        Return the list of the valid point styles of the drawable element.

        Returns
        -------
        validPointStyles : :class:`~openturns.Description`
            List of the valid point styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().GetValidPointStyles())
        [square,circle,triangleup,plus,times,...
        """
        return _graph._DrawableImplementationPointer_GetValidPointStyles(self)

    def GetValidColorMaps(self):
        r"""
        Return the list of the valid color maps of contour drawables.

        Returns
        -------
        validColorMaps : :class:`~openturns.Description`
            List of the valid color map names of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColorMaps()[:3])
        [,magma,inferno]

        """
        return _graph._DrawableImplementationPointer_GetValidColorMaps(self)

    def GetValidExtends(self):
        r"""
        Return the list of the valid coloration extends of contour drawables.

        Returns
        -------
        validExtends : :class:`~openturns.Description`
            List of the valid coloration extends of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidExtends())
        [neither,both,min,max]

        """
        return _graph._DrawableImplementationPointer_GetValidExtends(self)

    def GetValidColorBarPositions(self):
        r"""
        Return the list of the valid color bar positions of contour drawables.

        Returns
        -------
        validColorBarPositions : :class:`~openturns.Description`
            List of the valid color bar positions of contour drawables.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColorBarPositions())
        [,left,right,top,bottom]

        """
        return _graph._DrawableImplementationPointer_GetValidColorBarPositions(self)

    def GetValidNorms(self):
        r"""
        Return the list of the valid norms of contour drawables.

        Returns
        -------
        validNorms : :class:`~openturns.Description`
            List of the valid norms of contour drawables.

        Notes
        -----
        These norms are strings that can be passed as the *norm* parameter
        of a Matplotlib
        `contour <https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.contour.html>`_
        object, except *rank* which scales the colormap based on the ranks of the data values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidNorms())
        [asinh,linear,log,logit,symlog,rank]

        """
        return _graph._DrawableImplementationPointer_GetValidNorms(self)

    def ConvertFromName(self, name):
        r"""
        Convert a color name to a valid hexadecimal code.

        Parameters
        ----------
        name : str
            Name of the color. The valid color names are given by the
            :meth:`GetValidColors` method.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromName('red'))
        #FF0000
        """
        return _graph._DrawableImplementationPointer_ConvertFromName(self, name)

    def ConvertToRGB(self, key):
        r"""
        Convert an hexadecimal code into an RGB triplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components of the color.
            A value of 0 meaning that the component is absent in the color, a value
            of 255 meaning that the component is fully saturated.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
        [255,0,0]
        """
        return _graph._DrawableImplementationPointer_ConvertToRGB(self, key)

    def ConvertToRGBA(self, key):
        r"""
        Convert an hexadecimal code into an RGBA quadruplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBAComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components. A value of 0
            meaning that the component is absent in the color, a value of 255 meaning
            that the component is fully saturated. It contains also alpha, the
            level of transparency of the color. Alpha equal to 0 meaning that the
            color is fully transparent and 255 meaning that the color is fully opaque.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
        [255,0,0,255]
        """
        return _graph._DrawableImplementationPointer_ConvertToRGBA(self, key)

    def ConvertFromRGB(self, *args):
        r"""
        Convert an RGB triplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
        #ff0000
        """
        return _graph._DrawableImplementationPointer_ConvertFromRGB(self, *args)

    def ConvertFromRGBA(self, *args):
        r"""
        Convert an RGBA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.
        alpha : either nonnegative integer or nonnegative float
            Level of the color's transparency, 0 (or 0.0) meaning that the color is
            fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
            The alpha channel is only supported by a few devices, namely the PDF and
            PNG formats, for the other format the color is fully transparent as soon as
            its alpha channel is less than 255 (or 1.0).

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
        #ff0000ff
        """
        return _graph._DrawableImplementationPointer_ConvertFromRGBA(self, *args)

    def ConvertFromHSVIntoRGB(self, hue, saturation, value):
        r"""
        Convert an HSV triplet into an RGB triplet.

        Parameters
        ----------
        hue : float
            Hue with 0<=hue<=360.
        saturation : float
            Saturation with 0<=saturation<=1.
        value : float
            Value with 0<=value<=1.

        Returns
        -------
        RGBComponents : :class:`~openturns.Point`
            RGB (Red, Green and Blue) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromHSVIntoRGB(215.0, 0.2, 0.3))
        [0.24,0.265,0.3]
        """
        return _graph._DrawableImplementationPointer_ConvertFromHSVIntoRGB(self, hue, saturation, value)

    def ConvertFromRGBIntoHSV(self, *args):
        r"""
        Convert an RGB triplet to HSV triplet.

        Parameters
        ----------
        red : float
            Red with 0<=red<=1.
        green : float
            Green with 0<=green<=1.
        blue : float
            Blue with 0<=blue<=1.

        Returns
        -------
        HSVComponents : :class:`~openturns.Point`
            HSV (hue, saturation and value) components of the color
            where 0<=hue<=360, 0<=saturation<=1, 0<=value<=255.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBIntoHSV(0.8, 0.6, 0.4))
        [30,0.5,0.8]
        """
        return _graph._DrawableImplementationPointer_ConvertFromRGBIntoHSV(self, *args)

    def ConvertFromHSV(self, hue, saturation, value):
        r"""
        Convert an HSV triplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph._DrawableImplementationPointer_ConvertFromHSV(self, hue, saturation, value)

    def ConvertFromHSVA(self, hue, saturation, value, alpha):
        r"""
        Convert an HSVA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.
        alpha : float
            Alpha component.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph._DrawableImplementationPointer_ConvertFromHSVA(self, hue, saturation, value, alpha)

    def BuildDefaultPalette(self, size):
        r"""
        Build default palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the default palette.

        Notes
        -----
        This function uses the 'Drawable-DefaultPaletteName' key of the 
        :class:`~openturns.ResourceMap`, which can be equal to either 
        'Tableau' or 'Rainbow'.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().BuildDefaultPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        >>> ot.ResourceMap.SetAsString('Drawable-DefaultPaletteName', 'Rainbow')
        >>> print(ot.Drawable.BuildDefaultPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        >>> ot.ResourceMap.SetAsString('Drawable-DefaultPaletteName', 'Tableau')
        >>> print(ot.Drawable.BuildDefaultPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        >>> ot.ResourceMap.Reload()
        """
        return _graph._DrawableImplementationPointer_BuildDefaultPalette(self, size)

    def BuildRainbowPalette(self, size):
        r"""
        Build rainbow palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the rainbow palette.

        Notes
        -----
        The colors are generated in the HSV space, with H (the hue) varying in a number
        of different values given by 'Drawable-DefaultPalettePhase' in
        :class:`~openturns.ResourceMap` and V (the value) being decreased linearly at each
        cycle of the hue.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.BuildRainbowPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        """
        return _graph._DrawableImplementationPointer_BuildRainbowPalette(self, size)

    def BuildTableauPalette(self, size):
        r"""
        Build tableau palette.

        Parameters
        ----------
        n : int :math:`n > 0` and :math:`n < 10`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the tableau palette.

        Notes
        -----
        The colors are generated in the HSV space. 
        When the number of colors is greater than 10, the value V decreases 
        linearily depending on the 'Drawable-DefaultPalettePhase' key of the 
        :class:`~openturns.ResourceMap` for each block of 10 colors.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.BuildTableauPalette(4))
        [#1f77b4,#ff7f0e,#2ca02c,#d62728]
        """
        return _graph._DrawableImplementationPointer_BuildTableauPalette(self, size)

    def __ne__(self, other):
        return _graph._DrawableImplementationPointer___ne__(self, other)

    def __repr_markdown__(self):
        return _graph._DrawableImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _graph._DrawableImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _graph._DrawableImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph._DrawableImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph._DrawableImplementationPointer_setName(self, name)

# Register _DrawableImplementationPointer in _graph:
_graph._DrawableImplementationPointer_swigregister(_DrawableImplementationPointer)
class _GraphImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_graph._GraphImplementationPointer_ptr__get, _graph._GraphImplementationPointer_ptr__set)

    def __init__(self, *args):
        _graph._GraphImplementationPointer_swiginit(self, _graph.new__GraphImplementationPointer(*args))
    __swig_destroy__ = _graph.delete__GraphImplementationPointer

    def reset(self):
        return _graph._GraphImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _graph._GraphImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _graph._GraphImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _graph._GraphImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _graph._GraphImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _graph._GraphImplementationPointer_get(self)

    def getImplementation(self):
        return _graph._GraphImplementationPointer_getImplementation(self)

    def unique(self):
        return _graph._GraphImplementationPointer_unique(self)

    def use_count(self):
        return _graph._GraphImplementationPointer_use_count(self)

    def swap(self, other):
        return _graph._GraphImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph._GraphImplementationPointer_getClassName(self)

    def __repr__(self):
        return _graph._GraphImplementationPointer___repr__(self)

    def add(self, *args):
        r"""
        Add drawable instances to the collection of drawables contained in Graph.

        Available usages:
            add(*drawables*)

            add(*aGraph*)

        Parameters
        ----------
        drawables : :class:`~openturns.Drawable` or list of :class:`~openturns.Drawable`
            Drawable to add in the Graph.
        aGraph : :class:`~openturns.Graph`
            Graph to add in the Graph.

        Notes
        -----
        It adds the new drawables or graph inside the first one, with their legend.
        It keeps the graphical context of the first graph. Each drawable keeps
        its graphical context.
        Drawables that do not have an explicitly set color will be assigned the default
        palette color corresponding to their rank in the graph.


        .. warning::
            Different drawables might be colored the same...
        """
        return _graph._GraphImplementationPointer_add(self, *args)

    def erase(self, i):
        r"""
        Erase a drawable instance from the collection of drawables contained in Graph.

        Parameters
        ----------
        index : int
            Index of the drawable instance to erase from the collection of drawables
            contained in Graph.
        """
        return _graph._GraphImplementationPointer_erase(self, i)

    def getDrawables(self):
        r"""
        Accessor to the Drawables included in the Graph.

        Returns
        -------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph._GraphImplementationPointer_getDrawables(self)

    def setDrawables(self, drawableCollection):
        r"""
        Accessor to the Drawables included in the Graph.

        Parameters
        ----------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.

        Notes
        -----
        Drawables that do not have an explicitly set color will be assigned the
        default palette color corresponding to their rank in the graph.
        """
        return _graph._GraphImplementationPointer_setDrawables(self, drawableCollection)

    def getDrawable(self, index):
        r"""
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : positive int
            Position of the Drawable.

        Returns
        -------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph at the index.
        """
        return _graph._GraphImplementationPointer_getDrawable(self, index)

    def setDrawable(self, *args):
        r"""
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : int
            Position of the Drawable.
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph.

        Notes
        -----
        If the drawable does not have an explicitly set color, it will be assigned
        the default palette color corresponding to its rank in the graph.
        """
        return _graph._GraphImplementationPointer_setDrawable(self, *args)

    def getColors(self):
        r"""
        Accessor to the colors of the Drawables included in the Graph.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of all the colors used for the Drawables contained inside the graph.
        """
        return _graph._GraphImplementationPointer_getColors(self)

    def setColors(self, colors):
        r"""
        Update the colors of the Drawables inside the Graph.

        Parameters
        ----------
        listColors : sequence of str
            List of the colors used for each Drawable of the Graph.
            If the *listColors*'s size is lower than the number of Drawables, the
            first colors of *listColors* are re-used. If it is greated than
            the number of Drawables, the last colors of the list are ignored.

            The *listColors* argument can be the result of the static method
            :meth:`~openturns.Drawable.BuildDefaultPalette` 
            or :meth:`~openturns.Drawable.BuildTableauPalette` of the Drawable object.
        """
        return _graph._GraphImplementationPointer_setColors(self, colors)

    def setDefaultColors(self):
        r"""
        Assign colors to a default palette to all the drawables of the Graph.

        Notes
        -----
        This method ensures that drawables of the Graph have different colors.
        """
        return _graph._GraphImplementationPointer_setDefaultColors(self)

    def getLegends(self):
        r"""
        Accessor to the legends of the Drawables inside the Graph.

        Returns
        -------
        legends : :class:`~openturns.Description`
            Legends used for the drawables contained inside the Graph.
        """
        return _graph._GraphImplementationPointer_getLegends(self)

    def setLegends(self, legends):
        r"""
        Accessor to the legends of the Drawables inside the Graph.

        Parameters
        ----------
        legends : sequence of str
            Legends used for the drawables contained inside the Graph.
        """
        return _graph._GraphImplementationPointer_setLegends(self, legends)

    def setAxes(self, showAxes):
        r"""
        Accessor to the indication of axes' presence on the Graph.

        Parameters
        ----------
        axes : bool
            *True* to draw the axes, *False* to hide the axes.
        """
        return _graph._GraphImplementationPointer_setAxes(self, showAxes)

    def getAxes(self):
        r"""
        Accessor to the indication of axes' presence on the Graph.

        Returns
        -------
        axes : bool
            *True* if the axes are drawn, *False* if they are hidden.
        """
        return _graph._GraphImplementationPointer_getAxes(self)

    def setTickLocation(self, tickLocation):
        r"""
        Accessor to the ticks location flag.

        Parameters
        ----------
        loc : int
            Indicates the ticks location:

            - ot.GraphImplementation.TICKNONE: no ticks,

            - ot.GraphImplementation.TICKX: horizontal ticks,

            - ot.GraphImplementation.TICKY: vertical ticks,

            - ot.GraphImplementation.TICKXY: horizontal and vertical ticks.
        """
        return _graph._GraphImplementationPointer_setTickLocation(self, tickLocation)

    def getTickLocation(self):
        r"""
        Accessor to the ticks location flag.

        Returns
        -------
        loc : int
            Indicates the ticks location.
        """
        return _graph._GraphImplementationPointer_getTickLocation(self)

    def setIntegerXTick(self, integerXTick):
        r"""
        Accessor to the integer x-axis ticks flag.

        Parameters
        ----------
        integerXTick : bool
            Whether to draw only integer ticks on the x-axis.
        """
        return _graph._GraphImplementationPointer_setIntegerXTick(self, integerXTick)

    def getIntegerXTick(self):
        r"""
        Accessor to the integer x-axis ticks flag.

        Returns
        -------
        integerXTick : bool
            Whether to draw only integer ticks on the x-axis.
        """
        return _graph._GraphImplementationPointer_getIntegerXTick(self)

    def setIntegerYTick(self, integerYTick):
        r"""
        Accessor to the integer y-axis ticks flag.

        Parameters
        ----------
        integerYTick : bool
            Whether to draw only integer ticks on the y-axis.
        """
        return _graph._GraphImplementationPointer_setIntegerYTick(self, integerYTick)

    def getIntegerYTick(self):
        r"""
        Accessor to the integer y-axis ticks flag.

        Returns
        -------
        integerYTick : bool
            Whether to draw only integer ticks on the y-axis.
        """
        return _graph._GraphImplementationPointer_getIntegerYTick(self)

    def setLogScale(self, logScale):
        r"""
        Accessor to the indication of axes' scale of the Graph.

        Parameters
        ----------
        scale : int
            Indicates the type of the axes's scale:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        """
        return _graph._GraphImplementationPointer_setLogScale(self, logScale)

    def getLogScale(self):
        r"""
        Accessor to the indication of axes' scale of the Graph.

        Returns
        -------
        scale : int
            Indicates the type of the axes's scale:

            - 0: no log scale is used,

            - 1: log scale is used only for horizontal data,

            - 2: log scale is used only for vertical data,

            - 3: log scale is used for both data.
        """
        return _graph._GraphImplementationPointer_getLogScale(self)

    def setGrid(self, showGrid):
        r"""
        Hide or shows grid of the Graph.

        Parameters
        ----------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
        """
        return _graph._GraphImplementationPointer_setGrid(self, showGrid)

    def getGrid(self):
        r"""
        Accessor to the indication of grid's presence on the Graph.

        Returns
        -------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
            By default there is a gray grid.
        """
        return _graph._GraphImplementationPointer_getGrid(self)

    def setGridColor(self, color):
        r"""
        Accessor to the indication of grid's color on the Graph.

        Parameters
        ----------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph._GraphImplementationPointer_setGridColor(self, color)

    def getGridColor(self):
        r"""
        Accessor to the indication of grid's color on the Graph.

        Returns
        -------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph._GraphImplementationPointer_getGridColor(self)

    def getXTitle(self):
        r"""
        Accessor to the title of the X axe.

        Returns
        -------
        Xtitle : str
            Title of the X axe.
        """
        return _graph._GraphImplementationPointer_getXTitle(self)

    def setXTitle(self, title):
        r"""
        Accessor to the title of the X axe.

        Parameters
        ----------
        Xtitle : str
            Title of the X axe.
        """
        return _graph._GraphImplementationPointer_setXTitle(self, title)

    def getYTitle(self):
        r"""
        Accessor to the title of the Y axe.

        Returns
        -------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph._GraphImplementationPointer_getYTitle(self)

    def setYTitle(self, title):
        r"""
        Accessor to the title of the Y axe.

        Parameters
        ----------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph._GraphImplementationPointer_setYTitle(self, title)

    def getTitle(self):
        r"""
        Accessor to the title of the Graph.

        Returns
        -------
        title : str
            Title of the Graph.
        """
        return _graph._GraphImplementationPointer_getTitle(self)

    def setTitle(self, title):
        r"""
        Accessor to the title of the Graph.

        Parameters
        ----------
        title : str
            Title of the Graph.
        """
        return _graph._GraphImplementationPointer_setTitle(self, title)

    def setXMargin(self, xMargin):
        r"""
        Accessor to the horizontal margin size.

        Parameters
        ----------
        xMargin : float
            Horizontal margin ratio, defaults to 5% of the range on each side.
            In log-scale, it is interpreted as a power of 10;
            setting a value of 1 means a margin of one decade on each side.
            Defaults to *Graph-DefaultHorizontalMargin* map value.
        """
        return _graph._GraphImplementationPointer_setXMargin(self, xMargin)

    def setYMargin(self, yMargin):
        r"""
        Accessor to the vertical margin size.

        Parameters
        ----------
        yMargin : float
            Vertical margin ratio, defaults to 5% of the range on each side.
            In log-scale, it is interpreted as a power of 10;
            setting a value of 1 means a margin of one decade on each side.
            Defaults to *Graph-DefaultVerticalMargin* map value.
        """
        return _graph._GraphImplementationPointer_setYMargin(self, yMargin)

    def getBoundingBox(self):
        r"""
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            This methods adds x/y margins according to the margin attributes.
        """
        return _graph._GraphImplementationPointer_getBoundingBox(self)

    def setBoundingBox(self, boundingBox):
        r"""
        Accessor to the bounding box of the whole plot.

        Parameters
        ----------
        boundingBox : :class:`~openturns.Interval` of dimension 2
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph._GraphImplementationPointer_setBoundingBox(self, boundingBox)

    def getAutomaticBoundingBox(self):
        r"""
        Accessor to the indication of automatic bounding box.

        Returns
        -------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph._GraphImplementationPointer_getAutomaticBoundingBox(self)

    def setAutomaticBoundingBox(self, automaticBoundingBox):
        r"""
        Accessor to the indication of automatic bounding box.

        Parameters
        ----------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
        """
        return _graph._GraphImplementationPointer_setAutomaticBoundingBox(self, automaticBoundingBox)

    def getLegendFontSize(self):
        r"""
        Accessor to the legends' font size of the Drawables inside the Graph.

        Returns
        -------
        fontSize : float
            Legends' font size used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendFontSize
        """
        return _graph._GraphImplementationPointer_getLegendFontSize(self)

    def setLegendFontSize(self, legendFontSize):
        r"""
        Accessor to the legend's font size of the Drawables inside the Graph.

        Parameters
        ----------
        fontSize : float
            Legend's font size used for the drawables contained inside the Graph.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an empty graph
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, 'upper right')
        >>> graph.setLegendFontSize(15.0)
        >>> print(graph.getLegendFontSize())
        15.0
        """
        return _graph._GraphImplementationPointer_setLegendFontSize(self, legendFontSize)

    def IsValidLegendPosition(self, position):
        r"""
        Test if the proposed legend position is valid or not.

        Parameters
        ----------
        position : str
            Proposed legend position of the Drawables inside the Graph.

        Returns
        -------
        validity : bool
            *True* if the proposed legend position is valid, *False* if it is not.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
        False
        >>> print(ot.Graph.IsValidLegendPosition('upper left'))
        True
        """
        return _graph._GraphImplementationPointer_IsValidLegendPosition(self, position)

    def GetValidLegendPositions(self):
        r"""
        Accessor to the list of valid legend positions.

        Returns
        -------
        listPositions : :class:`~openturns.Description`
            All the valid legend positions.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.GetValidLegendPositions())
        [,best,upper right,upper left,lower right,lower left,center right,...
        """
        return _graph._GraphImplementationPointer_GetValidLegendPositions(self)

    def setLegendPosition(self, position):
        r"""
        Accessor to the legend's position of the Drawables inside the Graph.

        Parameters
        ----------
        position : str
            Legend's position used for the drawables contained inside the Graph.
            The valid positions are given by the method :meth:`GetValidLegendPositions`.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'upper right'
        >>> # Create an empty graph
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
        >>> graph.setLegendPosition('lower left')
        >>> print(graph.getLegendPosition())
        lower left
        """
        return _graph._GraphImplementationPointer_setLegendPosition(self, position)

    def getLegendPosition(self):
        r"""
        Accessor to the legend's position of the Drawables inside the Graph.

        Returns
        -------
        position : str
            Legend's position used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions
        """
        return _graph._GraphImplementationPointer_getLegendPosition(self)

    def setLegendCorner(self, corner):
        r"""
        Accessor to the legend's corner.

        Parameters
        ----------
        corner : sequence of float
            Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
            The position of the legend relatively to this point will depend on the orientation
            given by the :meth:`getLegendPosition` value.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'upper left'  # the legend's upper left corner with be set below
        >>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
        >>> graph.setLegendCorner([1.0, 1.0])  # legend will begin in top right corner

        Notes
        -----
        This enables the legend to be located outside the graph.

        """
        return _graph._GraphImplementationPointer_setLegendCorner(self, corner)

    def getLegendCorner(self):
        r"""
        Accessor to the legend's corner.

        Returns
        -------
        corner : :class:`~openturns.Point`
            Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
            The position of the legend relatively to this point will depend on the orientation
            given by the :meth:`getLegendPosition` value.

        """
        return _graph._GraphImplementationPointer_getLegendCorner(self)

    def __eq__(self, other):
        return _graph._GraphImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _graph._GraphImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _graph._GraphImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _graph._GraphImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _graph._GraphImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _graph._GraphImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph._GraphImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph._GraphImplementationPointer_setName(self, name)

# Register _GraphImplementationPointer in _graph:
_graph._GraphImplementationPointer_swigregister(_GraphImplementationPointer)

