# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Experimental features."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _experimental
else:
    import _experimental

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _experimental.delete_SwigPyIterator

    def value(self):
        return _experimental.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _experimental.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _experimental.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _experimental.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _experimental.SwigPyIterator_equal(self, x)

    def copy(self):
        return _experimental.SwigPyIterator_copy(self)

    def next(self):
        return _experimental.SwigPyIterator_next(self)

    def __next__(self):
        return _experimental.SwigPyIterator___next__(self)

    def previous(self):
        return _experimental.SwigPyIterator_previous(self)

    def advance(self, n):
        return _experimental.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _experimental.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _experimental.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _experimental.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _experimental.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _experimental.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _experimental.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _experimental:
_experimental.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.typ
import openturns.common
import openturns.base
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
class BoundaryMesher(openturns.common.PersistentObject):
    r"""
    Creation of the boundary mesh of a given mesh.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Notes
    -----
    The boundary extraction is based on the remark that a :math:`(d-1)` face of a
    :math:`d` dimensional simplex of a mesh is a boundary face if and only if this
    face is not shared by any other simplex of the mesh. By convention, a face is
    represented as a *flat* simplex, by repeating the :math:`d` th vertex so the
    two last indices of the simplex are equal.
    A *thick* version of the boundary can also be built, where each face is replaced
    by a simplex with a last vertex at distance *offset* from the face hyperplane.
    If *offset* is positive, this new vertex is in the open half-space not containing
    the simplex associated to the face, otherwise it is in the open half-space
    containing the simplex.

    Examples
    --------
    Create a mesh:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> mesher = ot.LevelSetMesher([5, 10])
    >>> level = 1.0
    >>> function = ot.SymbolicFunction(['x0', 'x1'], ['x0^2+x1^2'])
    >>> levelSet = ot.LevelSet(function, ot.LessOrEqual(), level)
    >>> mesh = mesher.build(levelSet, ot.Interval([-2.0]*2, [2.0]*2))
    >>> boundaryFactory = otexp.BoundaryMesher()
    >>> boundaryMesh = boundaryFactory.build(mesh)
    >>> thickBoundaryMeshOutside = boundaryFactory.build(mesh, 1e-5)
    >>> thickBoundaryMeshInside = boundaryFactory.build(mesh, -1e-5)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.BoundaryMesher_getClassName(self)

    def __repr__(self):
        return _experimental.BoundaryMesher___repr__(self)

    def __str__(self, *args):
        return _experimental.BoundaryMesher___str__(self, *args)

    def build(self, mesh, offset=0.0):
        r"""
        Build the boundary of the given mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            The mesh from which the boundary is extracted.
        offset : float
            The thickness of the boundary to be generated, see Notes.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh built.
        """
        return _experimental.BoundaryMesher_build(self, mesh, offset)

    def __init__(self, *args):
        _experimental.BoundaryMesher_swiginit(self, _experimental.new_BoundaryMesher(*args))
    __swig_destroy__ = _experimental.delete_BoundaryMesher

# Register BoundaryMesher in _experimental:
_experimental.BoundaryMesher_swigregister(BoundaryMesher)
class LatentVariableModel(openturns.statistics.CovarianceModelImplementation):
    r"""
    Latent variable covariance function.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Available constructors:
        LatentVariableModel(*nLevels, latentDim*)

    Parameters
    ----------
    nLevels : int
        Number of levels :math:`\ell` characterizing the categorical variable.
    latentDim : int
        The dimension :math:`d_\ell` of the latent space onto which the categorical variable levels are projected.

    Notes
    -----
    The *Latent variable covariance function* is a covariance model allowing to compute the covariance between 
    different unordered values (or levels) of a categorical variable :math:`z`.

    The underlying idea is that each categorical level is mapped onto a distinct point in a :math:`d_l`-dimensional latent space. 
    The covariance between the various levels is then computed as the :class:`~openturns.SquaredExponential` covariance between 
    the mappings in the latent space.
    Let :math:`\phi(\cdot):\mathcal{Z}\rightarrow\mathbb{R}^{d_l}` be the mapping function, the covariance function between
    two discrete values :math:`z_i` and :math:`z_j` is computed as:

    .. math::
        C(z_i, z_j) = e^{-\frac{1}{2}  \left\| \vect{s}- \vect{t} \right\|_{2}^{2}}, \quad \forall (\phi(z_i), \phi(z_j)) \in \cD

    The coordinates of the mapping points are part of the covariance model parameters, together with the latent squared 
    exponential model scale and amplitude. It is important to note that in order to compensate for possible rotations 
    and translations of the mapping points, the coordinates of the first level mapping are fixed to the latent space 
    origin, whereas all of the coordinates of the second level mapping are fixed to :math:`0`, except for the first one. 
    As a result, the number of active latent variable coordinates is equal to:

    .. math::
        d_\ell (\ell - 2) + 1.

    In practice, the class distinguishes between the `fullLatentVariables` attribute, which contains the actual latent variables
    coordinates, and the `activeLatentVariables` attribute, which contains only the coordinates that can be modified.
    Additional information can be found in [zhang2020]_.

    Is is important to note that for the sake of simplicity, the categorical variable levels **must be** represented as integers, 
    ranging from :math:`0` to :math:`l-1`. However, this representation is purely practical, and the actual values
    assigned to each level have no practical meaning or effect: only the latent variables coordinates have an effect on the
    covariance value. Moreover, these categorical variables, which are encoded using numerical values, can be of a non-numerical
    nature (e.g., types of material, architectural choices, colors, etc.).

    Finally, for a similar reason, when using this type of kernel when defining a Gaussian process, it is suggested to 
    rely on a constant functional basis: please use the :class:`~openturns.ConstantBasisFactory` class.


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a latent model covariance function with a latent space of dimension 2, for a categorical variable 
    characterized by 3 levels:

    >>> import openturns.experimental as otexp
    >>> covModel = otexp.LatentVariableModel(3, 2)
    >>> activeCoordinates = [0.1, 0.3, -0.4]
    >>> covModel.setLatentVariables(activeCoordinates)
    >>> print(covModel(1, 2))
    [[ 0.904837 ]]
    >>> print(covModel(0, 2))
    [[ 0.882497 ]]
    >>> print(covModel(1, 1))
    [[ 1 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LatentVariableModel_getClassName(self)

    def computeAsScalar(self, *args):
        r"""
        Compute the covariance function for scalar model.

        Parameters
        ----------
        s, t : floats
        	Must have integer values between :math:`0` and :math:`l-1`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(s, t)`.
        """
        return _experimental.LatentVariableModel_computeAsScalar(self, *args)

    def __repr__(self):
        return _experimental.LatentVariableModel___repr__(self)

    def __str__(self, *args):
        return _experimental.LatentVariableModel___str__(self, *args)

    def setFullParameter(self, parameter):
        r"""
        Set the full parameters of the covariance function.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            List of the full parameter of the covariance function i.e.
            the scale parameter :math:`\vect{\theta} \in \Rset`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset`, and
            the latent variables coordinates,  :math:`\vect{x}_{lat} \in \Rset^{latentDim * nLevels - 2 * latentDim + 1}`
        """
        return _experimental.LatentVariableModel_setFullParameter(self, parameter)

    def getFullParameter(self):
        r"""
        Get the full parameters of the covariance function.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            List of the full parameter of the covariance function i.e.
            the scale parameter :math:`\vect{\theta} \in \Rset`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset`, and
            the latent variables coordinates,  :math:`\vect{x}_{lat} \in \Rset^{latentDim * nLevels - 2 * latentDim + 1}`
        """
        return _experimental.LatentVariableModel_getFullParameter(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _experimental.LatentVariableModel_setScale(self, scale)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function.
            Its size must be equal to the dimension of the covariance function.
        """
        return _experimental.LatentVariableModel_setAmplitude(self, amplitude)

    def setNuggetFactor(self, nuggetFactor):
        r"""
        Set the nugget factor for the variance of the observation error.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used to model the variance of the observation error.
        """
        return _experimental.LatentVariableModel_setNuggetFactor(self, nuggetFactor)

    def setLatentVariables(self, latentVariablesCoordinates):
        r"""
        Number of levels accessor.

        Parameters
        ----------
        LatentVariables : sequence of float 
            Active coordinates of the categorical levels in the latent space.
        """
        return _experimental.LatentVariableModel_setLatentVariables(self, latentVariablesCoordinates)

    def getFullLatentVariables(self):
        r"""
        Latent variables accessor.

        Returns
        -------
        activeLatentVariables : :class:`~openturns.Point`
            Coordinates of the categorical levels in the latent space.
        """
        return _experimental.LatentVariableModel_getFullLatentVariables(self)

    def getActiveLatentVariables(self):
        r"""
        Active latent variables accessor.

        Parameters
        ----------
        activeLatentVariables : :class:`~openturns.Point`
            Active coordinates of the categorical levels in the latent space. 
            The inactive coordinates are set to 0 (i.e., the first latent 
            variable is projected onto the Euclidean space origin, and the second
            latent variable can only be located along the first axis).
        """
        return _experimental.LatentVariableModel_getActiveLatentVariables(self)

    def getFullParameterDescription(self):
        r"""
        Get the description full parameters of the covariance function.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the full parameter of the covariance function.

        """
        return _experimental.LatentVariableModel_getFullParameterDescription(self)

    def getLatentDimension(self):
        r"""
        Latent dimension accessor.

        Returns
        -------
        latentDimension : int
            Dimension of the latent space.
        """
        return _experimental.LatentVariableModel_getLatentDimension(self)

    def getLevelNumber(self):
        return _experimental.LatentVariableModel_getLevelNumber(self)

    def draw(self, *args):
        r"""Not yet implemented"""
        return _experimental.LatentVariableModel_draw(self, *args)

    def __init__(self, *args):
        _experimental.LatentVariableModel_swiginit(self, _experimental.new_LatentVariableModel(*args))
    __swig_destroy__ = _experimental.delete_LatentVariableModel

# Register LatentVariableModel in _experimental:
_experimental.LatentVariableModel_swigregister(LatentVariableModel)
import openturns.model_copula
import openturns.orthogonalbasis
import openturns.weightedexperiment
import openturns.bayesian
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.randomvector
import openturns.metamodel
import openturns.transformation
import openturns.analytical
class ANCOVA(object):
    r"""
    ANalysis of COVAriance method (ANCOVA).

    Refer to :ref:`sensitivity_ancova`.

    Parameters
    ----------
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        Functional chaos result approximating the model response with
        uncorrelated inputs.
    correlatedInput : 2-d sequence of float
        Correlated inputs used to compute the real values of the output.
        Its dimension must be equal to the number of inputs of the model.

    Notes
    -----
    ANCOVA, a variance-based method described in [caniou2012]_, is a generalization
    of the ANOVA (ANalysis Of VAriance) decomposition for models with correlated
    input parameters.

    Let us consider a model :math:`Y = h(\vect{X})` without making any hypothesis
    on the dependence structure of :math:`\vect{X} = \{X^1, \ldots, X^{n_X} \}`, a
    n_X-dimensional random vector. The covariance decomposition requires a functional
    decomposition of the model. Thus the model response :math:`Y` is expanded as a
    sum of functions of increasing dimension as follows:

    .. math::
        :label: model

        h(\vect{X}) = h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)

    :math:`h_0` is the mean of :math:`Y`. Each function :math:`h_u` represents,
    for any non empty set :math:`u\subseteq\{1, \dots, n_X\}`, the combined
    contribution of the variables :math:`X_u` to :math:`Y`.

    Using the properties of the covariance, the variance of :math:`Y` can be
    decomposed into a variance part and a covariance part as follows:

    .. math::

        Var[Y]&= Cov\left[h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u), h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)\right] \\
              &= \sum_{u\subseteq\{1,\dots,n_X\}} \left[Var[h_u(X_u)] + Cov[h_u(X_u), \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)]\right]

    This variance formula enables to define each total part of variance of
    :math:`Y` due to :math:`X_u`, :math:`S_u`, as the sum of a *physical*
    (or *uncorrelated*) part and a *correlated* part such as:

    .. math::

        S_u = \frac{Cov[Y, h_u(X_u)]} {Var[Y]} = S_u^U + S_u^C

    where :math:`S_u^U` is the uncorrelated part of variance of Y due to :math:`X_u`:

    .. math::

        S_u^U = \frac{Var[h_u(X_u)]} {Var[Y]}

    and :math:`S_u^C` is the contribution of the correlation of :math:`X_u` with the
    other parameters:

    .. math::

        S_u^C = \frac{Cov\left[h_u(X_u), \displaystyle \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)\right]}
                     {Var[Y]}

    As the computational cost of the indices with the numerical model :math:`h`
    can be very high, [caniou2012]_ suggests to approximate the model response with
    a polynomial chaos expansion:

    .. math::

        Y \simeq \hat{h} = \sum_{j=0}^{P-1} \alpha_j \Psi_j(x)

    However, for the sake of computational simplicity, the latter is constructed
    considering *independent* components :math:`\{X^1,\dots,X^{n_X}\}`. Thus the
    chaos basis is not orthogonal with respect to the correlated inputs under
    consideration, and it is only used as a metamodel to generate approximated
    evaluations of the model response and its summands :eq:`model`.

    The next step consists in identifying the component functions. For instance, for
    :math:`u = \{1\}`:

    .. math::

        h_1(X_1) = \sum_{\alpha | \alpha_1 \neq 0, \alpha_{i \neq 1} = 0} y_{\alpha} \Psi_{\alpha}(\vect{X})

    where :math:`\alpha` is a set of degrees associated to the :math:`n_X` univariate
    polynomial :math:`\psi_i^{\alpha_i}(X_i)`.

    Then the model response :math:`Y` is evaluated using a sample
    :math:`X=\{x_k, k=1,\dots,N\}` of the correlated joint distribution. Finally,
    the several indices are computed using the model response and its component
    functions that have been identified on the polynomial chaos.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Model and distribution definition
    >>> model = ot.SymbolicFunction(['X1','X2'], ['4.*X1 + 5.*X2'])
    >>> distribution = ot.ComposedDistribution([ot.Normal()] * 2)
    >>> S = ot.CorrelationMatrix(2)
    >>> S[1, 0] = 0.3
    >>> R = ot.NormalCopula().GetCorrelationFromSpearmanCorrelation(S)
    >>> CorrelatedInputDistribution = ot.ComposedDistribution([ot.Normal()] * 2, ot.NormalCopula(R))
    >>> sample = CorrelatedInputDistribution.getSample(200)
    >>> # Functional chaos computation
    >>> productBasis = ot.OrthogonalProductPolynomialFactory([ot.HermiteFactory()] * 2, ot.LinearEnumerateFunction(2))
    >>> adaptiveStrategy = ot.FixedStrategy(productBasis, 15)
    >>> experiment = ot.MonteCarloExperiment(distribution, 100)
    >>> X = experiment.generate()
    >>> Y = model(X)
    >>> algo = ot.FunctionalChaosAlgorithm(X, Y, distribution, adaptiveStrategy)
    >>> algo.run()
    >>> ancovaResult = ot.ANCOVA(algo.getResult(), sample)
    >>> indices = ancovaResult.getIndices()
    >>> print(indices)
    [0.408398,0.591602]
    >>> uncorrelatedIndices = ancovaResult.getUncorrelatedIndices()
    >>> print(uncorrelatedIndices)
    [0.284905,0.468108]
    >>> # Get indices measuring the correlated effects
    >>> print(indices - uncorrelatedIndices)
    [0.123494,0.123494]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getUncorrelatedIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices measuring uncorrelated effects.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring uncorrelated effects of the inputs.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _experimental.ANCOVA_getUncorrelatedIndices(self, marginalIndex)

    def getIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring the contribution of the
            input variables to the variance of the model. These indices are made up
            of a *physical* part and a *correlated* part. The first one is obtained
            thanks to :meth:`getUncorrelatedIndices`.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _experimental.ANCOVA_getIndices(self, marginalIndex)

    def __init__(self, *args):
        _experimental.ANCOVA_swiginit(self, _experimental.new_ANCOVA(*args))
    __swig_destroy__ = _experimental.delete_ANCOVA

# Register ANCOVA in _experimental:
_experimental.ANCOVA_swigregister(ANCOVA)
class FAST(object):
    r"""
    Fourier Amplitude Sensitivity Testing (FAST).

    Refer to :ref:`sensitivity_fast`.

    Available constructor:
        FAST(*model, distribution, N, Nr=1, M=4*)

    Parameters
    ----------
    model : :class:`~openturns.Function`
        Definition of the model to analyse.
    distribution : :class:`~openturns.Distribution`
        Contains the distributions of each model's input.
        Its dimension must be equal to the number of inputs.
    N : int, :math:`N > Nr`
        Size of the sample from which the Fourier series are calculated.
        It represents the length of the discretization of the s-space.
    Nr : int, :math:`Nr \geq 1`
        Number of resamplings. The extended FAST method involves a part of
        randomness in the computation of the indices. So it can be asked to
        realize the procedure *Nr* times and then to calculate the
        arithmetic means of the results over the *Nr* estimates.
    M : int, :math:`0 < M < N`
        Interference factor usually equal to 4 or higher.
        It corresponds to the truncation level of the Fourier series, i.e. the
        number of harmonics that are retained in the decomposition.

    Notes
    -----
    FAST is a sensitivity analysis method which is based upon the ANOVA
    decomposition of the variance of the model response :math:`y = f(\vect{X})`,
    the latter being represented by its Fourier expansion.
    :math:`\vect{X}=\{X^1,\dots,X^{n_X}\}` is an input random vector of :math:`n_X`
    independent components.

    OpenTURNS implements the extended FAST method consisting in computing
    alternately the first order and the total-effect indices of each input.
    This approach, widely described in the paper by [saltelli1999]_, relies upon a
    Fourier decomposition of the model response. Its key idea is to recast this
    representation as a function of a *scalar* parameter :math:`s`, by defining
    parametric curves :math:`s \mapsto x_i(s), i=1, \dots, n_X` exploring the
    support of the input random vector :math:`\vect{X}`.

    Then the Fourier expansion of the model response is:

    .. math::

        f(s) = \sum_{k \in \Zset^N} A_k cos(ks) + B_k sin(ks)

    where :math:`A_k` and :math:`B_k` are Fourier coefficients whose estimates are:

    .. math::

        \hat{A}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) cos\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2} \\
        \hat{B}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) sin\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2}


    The first order indices are estimated by:

    .. math::

        \hat{S}_i = \frac{\hat{D}_i}{\hat{D}}
                  = \frac{\sum_{p=1}^M(\hat{A}_{p\omega_i}^2 + \hat{B}_{p\omega_i}^2)^2}
                          {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    and the total order indices by:

    .. math::

        \hat{T}_i = 1 - \frac{\hat{D}_{-i}}{\hat{D}}
                  = 1 - \frac{\sum_{k=1}^{\omega_i/2}(\hat{A}_k^2 + \hat{B}_k^2)^2}
                              {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    where :math:`\hat{D}` is the total variance, :math:`\hat{D}_i` the portion
    of :math:`D` arising from the uncertainty of the :math:`i^{th}` input and
    :math:`\hat{D}_{-i}` is the part of the variance due to all the inputs
    except the :math:`i^{th}` input.

    :math:`N` is the size of the sample using to compute the Fourier series and
    :math:`M` is the interference factor. *Saltelli et al.* (1999) recommended to
    set :math:`M` to a value in the range :math:`[4, 6]`.
    :math:`\{\omega_i\}, \forall i=1, \dots, n_X` is a set of integer frequencies
    assigned to each input :math:`X^i`. The frequency associated with the input
    for which the sensitivity indices are computed, is set to the maximum admissible
    frequency satisfying the Nyquist criterion (which ensures to avoid aliasing effects):

    .. math::

        \omega_i = \frac{N - 1}{2M}

    In the paper by Saltelli et al. (1999), for high sample size, it is suggested
    that :math:`16 \leq \omega_i/N_r \leq 64`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> sensitivityAnalysis = ot.FAST(model, distribution, 101)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311097,0.441786,0.000396837]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the first order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the first order indices of all the inputs.
        """
        return _experimental.FAST_getFirstOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the total order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's  marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the total-effect order indices of all the inputs.
        """
        return _experimental.FAST_getTotalOrderIndices(self, marginalIndex)

    def getFFTAlgorithm(self):
        r"""
        Accessor to the FFT algorithm implementation.

        Returns
        -------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _experimental.FAST_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        r"""
        Accessor to the FFT algorithm implementation.

        Parameters
        ----------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _experimental.FAST_setFFTAlgorithm(self, fft)

    def setBlockSize(self, blockSize):
        r"""
        Set the block size.

        Parameters
        ----------
        k : positive int
            Size of each block the sample is split into, this allows one to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to :math:`1`.
        """
        return _experimental.FAST_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Get the block size.

        Returns
        -------
        k : positive int
            Size of each block the sample is split into, this allows one to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to 1.
        """
        return _experimental.FAST_getBlockSize(self)

    def __init__(self, *args):
        _experimental.FAST_swiginit(self, _experimental.new_FAST(*args))
    __swig_destroy__ = _experimental.delete_FAST

# Register FAST in _experimental:
_experimental.FAST_swigregister(FAST)
class SobolIndicesAlgorithmImplementation(openturns.common.PersistentObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method measures the influence of each component of an input random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on an output random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see [sobol1993]_).
    It computes, for every output random variable :math:`Y_k` (:math:`1 \leqslant k \leqslant n_Y`),
    the part of its variance due to each input component :math:`X_i` (:math:`1 \leqslant i \leqslant n_X`) of :math:`\vect{X}`.
    Sobol' indices are introduced in :ref:`sensitivity_sobol`. 

    Several estimators of :math:`V_i`, :math:`V_i^T` and :math:`V_{-i}` are provided by the :class:`SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
    - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
    - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method.

    Specific formulas for :math:`\widehat{V}_i`, :math:`\widehat{V}_i^T` and :math:`\widehat{V}_{-i}` are given in the corresponding documentation pages.


    For multivariate outputs i.e. when :math:`n_Y>1`, we compute the Sobol' indices with respect to each output variable. 
    In this case, the methods :meth:`getFirstOrderIndices` and 
    :meth:`getTotalOrderIndices` return the Sobol' indices of the first output, 
    but the index of the output can be specified as input argument.
    Aggregated indices can be retrieved with the :meth:`getAggregatedFirstOrderIndices` 
    and :meth:`getAggregatedTotalOrderIndices` methods. 


    Notice that the distribution of the estimators of the first
    and total order indices can be estimated
    thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.
    This is done either through bootstrapping or using an asymptotic estimator.
    The :class:`~openturns.ResourceMap` key `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution`
    stores a boolean that decides the default behavior,
    but it can be overridden by the method :meth:`setUseAsymptoticDistribution`.

    Corresponding confidence intervals are provided by the methods
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    Their confidence level can be adjusted with :meth:`setConfidenceLevel`.
    The default confidence level is stored in the :class:`~openturns.ResourceMap`
    and can be accessed with the `SobolIndicesAlgorithm-DefaultConfidenceLevel` key.

    Indices estimates can be slightly outside of [0,1] if the estimator has not converged.
    For the same reason some first order indices estimates can be greater than the corresponding total order indices estimates.

    The asymptotic estimator of the distribution requires an asymptotic estimate
    of its variance, which is computed using the [janon2014]_
    delta method, as expained in the technical report [pmfre01116]_.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesDistribution(self)

    def __repr__(self):
        return _experimental.SobolIndicesAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _experimental.SobolIndicesAlgorithmImplementation___str__(self, *args)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(*args):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values
        fo_ci : :class:`~openturns.Interval`, optional
            First order indices confidence interval
        to_ci : :class:`~openturns.Interval`, optional
            Total order indices confidence interval

        Returns
        -------
        graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _experimental.SobolIndicesAlgorithmImplementation_DrawSobolIndices(*args)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        r"""
        Draw the correlation coefficients. 
         As correlation coefficients are considered, values might be positive or negative.

        Available usages:
            DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

            DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

        Parameters
        ----------
        correlationCoefficients : :class:`~openturns.PointWithDescription`
            Sequence containing the correlation coefficients with a description for each
            component. The descriptions are used to build labels for the created graph.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Correlation coefficients.
        names : sequence of str
            Variables' names used to build labels for the created the graph.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
            of the correlation coefficients.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _experimental.SobolIndicesAlgorithmImplementation_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Allows one to estimate indices from a predefined Sobol design.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Base size of the Sobol design
        """
        return _experimental.SobolIndicesAlgorithmImplementation_setDesign(self, inputDesign, outputDesign, size)

    def __init__(self, *args):
        _experimental.SobolIndicesAlgorithmImplementation_swiginit(self, _experimental.new_SobolIndicesAlgorithmImplementation(*args))
    __swig_destroy__ = _experimental.delete_SobolIndicesAlgorithmImplementation

# Register SobolIndicesAlgorithmImplementation in _experimental:
_experimental.SobolIndicesAlgorithmImplementation_swigregister(SobolIndicesAlgorithmImplementation)
class _SobolIndicesAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_swiginit(self, _experimental.new__SobolIndicesAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _experimental.delete__SobolIndicesAlgorithmImplementationTypedInterfaceObject

# Register _SobolIndicesAlgorithmImplementationTypedInterfaceObject in _experimental:
_experimental._SobolIndicesAlgorithmImplementationTypedInterfaceObject_swigregister(_SobolIndicesAlgorithmImplementationTypedInterfaceObject)
class SobolIndicesAlgorithm(_SobolIndicesAlgorithmImplementationTypedInterfaceObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method measures the influence of each component of an input random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on an output random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see [sobol1993]_).
    It computes, for every output random variable :math:`Y_k` (:math:`1 \leqslant k \leqslant n_Y`),
    the part of its variance due to each input component :math:`X_i` (:math:`1 \leqslant i \leqslant n_X`) of :math:`\vect{X}`.
    Sobol' indices are introduced in :ref:`sensitivity_sobol`. 

    Several estimators of :math:`V_i`, :math:`V_i^T` and :math:`V_{-i}` are provided by the :class:`SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
    - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
    - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method.

    Specific formulas for :math:`\widehat{V}_i`, :math:`\widehat{V}_i^T` and :math:`\widehat{V}_{-i}` are given in the corresponding documentation pages.


    For multivariate outputs i.e. when :math:`n_Y>1`, we compute the Sobol' indices with respect to each output variable. 
    In this case, the methods :meth:`getFirstOrderIndices` and 
    :meth:`getTotalOrderIndices` return the Sobol' indices of the first output, 
    but the index of the output can be specified as input argument.
    Aggregated indices can be retrieved with the :meth:`getAggregatedFirstOrderIndices` 
    and :meth:`getAggregatedTotalOrderIndices` methods. 


    Notice that the distribution of the estimators of the first
    and total order indices can be estimated
    thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.
    This is done either through bootstrapping or using an asymptotic estimator.
    The :class:`~openturns.ResourceMap` key `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution`
    stores a boolean that decides the default behavior,
    but it can be overridden by the method :meth:`setUseAsymptoticDistribution`.

    Corresponding confidence intervals are provided by the methods
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    Their confidence level can be adjusted with :meth:`setConfidenceLevel`.
    The default confidence level is stored in the :class:`~openturns.ResourceMap`
    and can be accessed with the `SobolIndicesAlgorithm-DefaultConfidenceLevel` key.

    Indices estimates can be slightly outside of [0,1] if the estimator has not converged.
    For the same reason some first order indices estimates can be greater than the corresponding total order indices estimates.

    The asymptotic estimator of the distribution requires an asymptotic estimate
    of its variance, which is computed using the [janon2014]_
    delta method, as expained in the technical report [pmfre01116]_.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolIndicesAlgorithm_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithm_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the output marginal of the function, equal to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _experimental.SobolIndicesAlgorithm_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _experimental.SobolIndicesAlgorithm_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithm_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootstrap sampling
        """
        return _experimental.SobolIndicesAlgorithm_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithm_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _experimental.SobolIndicesAlgorithm_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithm_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _experimental.SobolIndicesAlgorithm_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithm_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _experimental.SobolIndicesAlgorithm_getTotalOrderIndicesDistribution(self)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _experimental.SobolIndicesAlgorithm_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(*args):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values
        fo_ci : :class:`~openturns.Interval`, optional
            First order indices confidence interval
        to_ci : :class:`~openturns.Interval`, optional
            Total order indices confidence interval

        Returns
        -------
        graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _experimental.SobolIndicesAlgorithm_DrawSobolIndices(*args)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        r"""
        Draw the correlation coefficients. 
         As correlation coefficients are considered, values might be positive or negative.

        Available usages:
            DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

            DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

        Parameters
        ----------
        correlationCoefficients : :class:`~openturns.PointWithDescription`
            Sequence containing the correlation coefficients with a description for each
            component. The descriptions are used to build labels for the created graph.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Correlation coefficients.
        names : sequence of str
            Variables' names used to build labels for the created the graph.
        title : str
            Title of the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
            of the correlation coefficients.
        """
        return _experimental.SobolIndicesAlgorithm_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _experimental.SobolIndicesAlgorithm_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Allows one to estimate indices from a predefined Sobol design.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Base size of the Sobol design
        """
        return _experimental.SobolIndicesAlgorithm_setDesign(self, inputDesign, outputDesign, size)

    def __repr__(self):
        return _experimental.SobolIndicesAlgorithm___repr__(self)

    def __str__(self, *args):
        return _experimental.SobolIndicesAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _experimental.SobolIndicesAlgorithm_swiginit(self, _experimental.new_SobolIndicesAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_SobolIndicesAlgorithm

# Register SobolIndicesAlgorithm in _experimental:
_experimental.SobolIndicesAlgorithm_swigregister(SobolIndicesAlgorithm)
class MartinezSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Martinez method.

    Available constructors:
        MartinezSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MartinezSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MartinezSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [martinez2011]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of the first and total order Sobol' indices used by this class are respectively:

    .. math::

       \hat{S}_i & = \tilde{\rho}_n\left(\tilde{\vect{g}}(\mat{B}), \tilde{\vect{g}}(\mat{E}^i)\right) \\
       \widehat{S}_i^T & = 1 - \tilde{\rho}_n\left(\tilde{\vect{g}}(\mat{A}), \tilde{\vect{g}}(\mat{E}^i)\right) \\

    where :math:`\tilde{\rho}_n` is the modified sample correlation (under the assumption that the
    sample has a zero mean) defined by:

    .. math::

       \tilde{\rho}_n \left(\vect{z}, \vect{z}'\right) = 
       \frac{\sum_{k=1}^N z_k z_k'}
       {\sqrt{\sum_{k=1}^N z_k^2} \sqrt{\sum_{k=1}^N \left( z_k' \right)^2}}

    and :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``MartinezSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MartinezSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.308902,0.459187,0.00683867]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.567786,0.430754,0.244293]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.MartinezSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.MartinezSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.MartinezSensitivityAlgorithm_swiginit(self, _experimental.new_MartinezSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_MartinezSensitivityAlgorithm

# Register MartinezSensitivityAlgorithm in _experimental:
_experimental.MartinezSensitivityAlgorithm_swigregister(MartinezSensitivityAlgorithm)
class SaltelliSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Saltelli method.

    Available constructors:
        SaltelliSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        SaltelliSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        SaltelliSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [saltelli2002]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_{-i}` used by this class are respectively:

    .. math::

       \widehat{V}_i & =  \frac{1}{N-1}\sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)  \tilde{\vect{g}}(\vect{E}_k) 
       - \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)\right) 
       \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)\right) \\
       \widehat{V}_{-i} & =  \frac{1}{N-1}\sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)  \tilde{\vect{g}}(\vect{E}_k) 
       - \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k)\right) 
       \left(\frac{1}{N} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k)\right)

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``SaltelliSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the  ``outputDesign``, and therefore for the  ``inputDesign`` .
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.SaltelliSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.302745,0.460846,0.0066916]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.574996,0.427126,0.256689]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SaltelliSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.SaltelliSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.SaltelliSensitivityAlgorithm_swiginit(self, _experimental.new_SaltelliSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_SaltelliSensitivityAlgorithm

# Register SaltelliSensitivityAlgorithm in _experimental:
_experimental.SaltelliSensitivityAlgorithm_swigregister(SaltelliSensitivityAlgorithm)
class JansenSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Jansen method.

    Available constructors:
        JansenSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        JansenSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        JansenSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [jansen1999]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_i^T` used by this class are respectively:

    .. math::

       \widehat{V}_i & = \frac{1}{N-1} \sum_{k=1}^N \tilde{\vect{g}}(\vect{A}_k)^2 - \frac{1}{2N-1} \sum_{k=1}^N \left( \tilde{\vect{g}}(\vect{E}_k) - \tilde{\vect{g}}(\vect{B}_k) \right)^2 \\
       \widehat{V}_i^T & = \frac{1}{2N-1} \sum_{k=1}^N \left( \tilde{\vect{g}}(\vect{E}_k) -  \tilde{\vect{g}}(\vect{A}_k) \right)^2

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``JansenSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.



    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 10000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.JansenSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.322419,0.457314,0.0260925]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.55841,0.433746,0.240408]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.JansenSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.JansenSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.JansenSensitivityAlgorithm_swiginit(self, _experimental.new_JansenSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_JansenSensitivityAlgorithm

# Register JansenSensitivityAlgorithm in _experimental:
_experimental.JansenSensitivityAlgorithm_swigregister(JansenSensitivityAlgorithm)
class MauntzKucherenkoSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using MauntzKucherenko method.

    Available constructors:
        MauntzKucherenkoSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MauntzKucherenkoSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MauntzKucherenkoSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained with the
        :class:`~openturns.SobolIndicesExperiment`:code:`.`:meth:`~openturns.SobolIndicesExperiment.generate`
        method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class analyzes the influence of each component of a random vector
    :math:`\vect{X} = \left( X_1, \ldots, X_{n_X} \right)` on a random vector
    :math:`\vect{Y} = \left( Y_1, \ldots, Y_{n_Y} \right)` by computing Sobol' indices (see also [sobol1993]_).
    The [sobol2007]_ method is used to estimate both first
    and total order indices.
    Notations are defined in the documentation page of the :class:`~openturns.SobolIndicesAlgorithm` class.
    The estimators of :math:`V_i` and :math:`V_{-i}` used by this class are respectively:

    .. math::

       \widehat{V}_i & = \frac{1}{N-1} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{B}_k) \left( \tilde{\vect{g}}(\vect{E}_k) - \tilde{\vect{g}}(\vect{A}_k) \right) \\
       \widehat{VT}_{i} & = \frac{1}{N-1} \sum_{k=1}^{N} \tilde{\vect{g}}(\vect{A}_k) \left( \tilde{\vect{g}}(\vect{A}_k) -  \tilde{\vect{g}}(\vect{E}_k) \right)

    where :math:`\tilde{\vect{g}}` is the centered model based on the sample. 

    The class constructor ``MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, N)``
    requires a specific structure for the ``outputDesign``, and therefore for the  ``inputDesign``.
    The latter should be generated using :class:`~openturns.SobolIndicesExperiment`
    (see example below). Otherwise, results will be **worthless**.

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100000
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311678,0.439075,0.00401876]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.556564,0.439185,0.24036]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.MauntzKucherenkoSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _experimental.MauntzKucherenkoSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _experimental.MauntzKucherenkoSensitivityAlgorithm_swiginit(self, _experimental.new_MauntzKucherenkoSensitivityAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_MauntzKucherenkoSensitivityAlgorithm

# Register MauntzKucherenkoSensitivityAlgorithm in _experimental:
_experimental.MauntzKucherenkoSensitivityAlgorithm_swigregister(MauntzKucherenkoSensitivityAlgorithm)
class SobolIndicesExperiment(openturns.weightedexperiment.WeightedExperimentImplementation):
    r"""
    Experiment to computeSobol' indices.

    Available constructors:
        SobolIndicesExperiment(*distribution, size, computeSecondOrder=False*)

        SobolIndicesExperiment(*experiment, computeSecondOrder=False*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Size :math:`N` of each of the two independent initial samples.
        For the total size of the experiment see notes below.
    experiment : :class:`~openturns.WeightedExperiment`
        Design of experiment used to sample the distribution.
    computeSecondOrder : bool, defaults to False
        Whether to add points to compute second order indices

    Notes
    -----
    Sensitivity algorithms rely on the definition of specific designs.

    The :meth:`generate` method of this class produces a :class:`~openturns.Sample`
    to be supplied to the constructor of one of the :class:`~openturns.SobolIndicesAlgorithm` implementations:

    - :class:`~openturns.SaltelliSensitivityAlgorithm`,
    - :class:`~openturns.MartinezSensitivityAlgorithm`,
    - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm`,
    - :class:`~openturns.JansenSensitivityAlgorithm`.

    The chosen :class:`~openturns.SobolIndicesAlgorithm` implementation then uses the sample as *input design*,
    which means it represents (but is not a realization of) a random vector :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)`.

    Either the :class:`~openturns.Distribution` of :math:`\vect{X}`
    or a :class:`~openturns.WeightedExperiment` that represents it
    must be supplied to the class constructor.

    If a :class:`~openturns.WeightedExperiment` is supplied, the class uses it directly.

    If the distribution of :math:`\vect{X}` is supplied, the class generates a :class:`~openturns.WeightedExperiment`.
    To do this, it duplicates the distribution: every marginal is repeated once to produce
    a :math:`2 n_X`-dimensional distribution.
    This trick makes it possible to choose a :class:`~openturns.WeightedExperiment` with non-iid samples
    (that is a :class:`~openturns.LHSExperiment` or a :class:`~openturns.LowDiscrepancyExperiment`)
    to represent the original :math:`n_X`-dimensional distribution.

    The type of :class:`~openturns.WeightedExperiment` depends on the value of ``'SobolIndicesExperiment-SamplingMethod'`` in the :class:`~openturns.ResourceMap`:

        - ``'MonteCarlo'`` for a :class:`~openturns.MonteCarloExperiment`.
        - ``'LHS'`` for an :class:`~openturns.LHSExperiment` with *alwaysShuffle* and *randomShift* set to *True*.
        - ``'QMC'`` for a :class:`~openturns.LowDiscrepancyExperiment` (with *randomize* flag set to *False*) built from a :class:`~openturns.SobolSequence`.

    ``'MonteCarlo'`` is the default choice because it allows the chosen :class:`~openturns.SobolIndicesAlgorithm` implementation to use the asymptotic distribution of the estimators of the Sobol' indices.

    Note that ``'QMC'`` is only possible if :math:`2 n_X \leqslant` :class:`~openturns.SobolSequence`:code:`.`:attr:`~openturns.SobolSequence.MaximumDimension`.
    If ``'QMC'`` is specified but :math:`2 n_X >` :class:`~openturns.SobolSequence`:code:`.`:attr:`~openturns.SobolSequence.MaximumDimension`, the class falls back to ``'LHS'``.

    >>> from openturns import SobolSequence
    >>> print(SobolSequence.MaximumDimension)
    1111

    Regardless of the type of :class:`~openturns.WeightedExperiment`,
    the class splits it into two samples with the same size :math:`N`:
    :math:`\mat{A}` and :math:`\mat{B}`.
    Their columns are mixed in order to produce a very large sample: the *inputDesign* argument
    taken by one of the constructors of every :class:`~openturns.SobolIndicesAlgorithm` implementation.

    If *computeSecondOrder* is set to *False*, the input design is of size :math:`N(2+n_X)`.
    The first :math:`N` rows contain the sample :math:`\mat{A}` and the next :math:`N` rows the sample :math:`\mat{B}`.
    The last :math:`N n_X` rows contain :math:`n_X` copies of :math:`\mat{A}`,
    each with a different column replaced by the corresponding column from :math:`\mat{B}`
    (they are the matrices :math:`\mat{E}^i` from the documentation page of :class:`~openturns.SobolIndicesAlgorithm`).

    If *computeSecondOrder* is set to *True* and :math:`n_X = 2`, the input design is the same as in
    the case where *computeSecondOrder* is *False* (see [saltelli2002]_).

    If *computeSecondOrder* is set to *True* and :math:`n_X \neq 2`, the input design size is :math:`N(2+2 n_X)`.
    The first :math:`N(2+n_X)` rows are the same as when *computeSecondOrder* is *False*.
    The last :math:`N n_X` rows contain :math:`n_X` copies of :math:`\mat{B}`,
    each with a different column replaced by the corresponding column from :math:`\mat{A}`
    (they are the matrices :math:`\mat{C}^i` from the documentation page of :class:`~openturns.SobolIndicesAlgorithm`).

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Create a sample suitable to estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> experiment = ot.SobolIndicesExperiment(distribution, size)
    >>> sample = experiment.generate()

    Create a sample suitable to estimate first, total order and second order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> computeSecondOrder = True
    >>> experiment = ot.SobolIndicesExperiment(distribution, size, computeSecondOrder)
    >>> sample = experiment.generate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolIndicesExperiment_getClassName(self)

    def __repr__(self):
        return _experimental.SobolIndicesExperiment___repr__(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _experimental.SobolIndicesExperiment_setSize(self, size)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _experimental.SobolIndicesExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _experimental.SobolIndicesExperiment_getDistribution(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _experimental.SobolIndicesExperiment_hasUniformWeights(self)

    def generateWithWeights(self, weights):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _experimental.SobolIndicesExperiment_generateWithWeights(self, weights)

    def getWeightedExperiment(self):
        return _experimental.SobolIndicesExperiment_getWeightedExperiment(self)

    def __init__(self, *args):
        _experimental.SobolIndicesExperiment_swiginit(self, _experimental.new_SobolIndicesExperiment(*args))
    __swig_destroy__ = _experimental.delete_SobolIndicesExperiment

# Register SobolIndicesExperiment in _experimental:
_experimental.SobolIndicesExperiment_swigregister(SobolIndicesExperiment)
class SimulationResult(openturns.common.PersistentObject):
    r"""
    EventSimulation result base class.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SimulationResult_getClassName(self)

    def getOuterSampling(self):
        r"""
        Accessor to the outer sampling.

        Returns
        -------
        outerSampling : int
            Number of groups of terms in the probability simulation estimator.
        """
        return _experimental.SimulationResult_getOuterSampling(self)

    def setOuterSampling(self, outerSampling):
        r"""
        Accessor to the outer sampling.

        Parameters
        ----------
        outerSampling : int, :math:`outerSampling \geq 0`
            Number of groups of terms in the probability simulation estimator.
        """
        return _experimental.SimulationResult_setOuterSampling(self, outerSampling)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
        """
        return _experimental.SimulationResult_getBlockSize(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 0`
            Number of terms in the probability simulation estimator grouped together.
        """
        return _experimental.SimulationResult_setBlockSize(self, blockSize)

    def __repr__(self):
        return _experimental.SimulationResult___repr__(self)

    def __init__(self, *args):
        _experimental.SimulationResult_swiginit(self, _experimental.new_SimulationResult(*args))
    __swig_destroy__ = _experimental.delete_SimulationResult

# Register SimulationResult in _experimental:
_experimental.SimulationResult_swigregister(SimulationResult)
class ProbabilitySimulationResult(SimulationResult):
    r"""
    Probability simulation result.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> limitState = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3.*E*I)'])
    >>> # Enable the history mechanism in order to use the getImportanceFactors method
    >>> limitState = ot.MemoizeFunction(limitState)
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> output = ot.CompositeRandomVector(limitState, ot.RandomVector(distribution))
    >>> event = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> importanceFactors = result.getImportanceFactors()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ProbabilitySimulationResult_getClassName(self)

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _experimental.ProbabilitySimulationResult_getEvent(self)

    def setEvent(self, event):
        r"""
        Accessor to the event.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _experimental.ProbabilitySimulationResult_setEvent(self, event)

    def getProbabilityEstimate(self):
        r"""
        Accessor to the probability estimate.

        Returns
        -------
        probaEstimate : float
            Estimate of the event probability.
        """
        return _experimental.ProbabilitySimulationResult_getProbabilityEstimate(self)

    def setProbabilityEstimate(self, probabilityEstimate):
        r"""
        Accessor to the probability estimate.

        Parameters
        ----------
        probaEstimate : float, :math:`0 \leq P_e \leq 1`
            Estimate of the event probability.
        """
        return _experimental.ProbabilitySimulationResult_setProbabilityEstimate(self, probabilityEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        varianceEstimate : float
            Variance estimate.
        """
        return _experimental.ProbabilitySimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        varianceEstimate : float, :math:`Var_e \geq 0`
            Variance estimate.
        """
        return _experimental.ProbabilitySimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getProbabilityDistribution(self):
        r"""
        Accessor to the asymptotic probability distribution.

        Returns
        -------
        probaDistribution : :class:`~openturns.Normal`
            Asymptotic normal distribution of the event probability estimate.
        """
        return _experimental.ProbabilitySimulationResult_getProbabilityDistribution(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.ProbabilitySimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation of the estimator at the end of the simulation.
        """
        return _experimental.ProbabilitySimulationResult_getStandardDeviation(self)

    def getMeanPointInEventDomain(self):
        r"""
        Accessor to the mean point conditioned to the event realization.

        Returns
        -------
        meanPoint : :class:`~openturns.Point`
            Mean point in the physical space of all the simulations generated by the
            :class:`~openturns.EventSimulation` algorithm that failed into the event domain.

        Notes
        -----
        .. warning::
            This notion is only available if the history mechanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).
        """
        return _experimental.ProbabilitySimulationResult_getMeanPointInEventDomain(self)

    def getImportanceFactors(self):
        r"""
        Accessor to the importance factors.

        Returns
        -------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component.

        Notes
        -----
        The importance factors :math:`\alpha_i` are evaluated from the coordinates of
        the mean point of event domain :math:`\vect{X}^*_{event}`, mapped into the
        standard space as follows:

        .. math::

          \alpha_i = \displaystyle \frac{\left(U_{i}^*\right)^2}{||\vect{U}^*||^2}

        where :math:`\vect{U}^* = T(\vect{X}^*_{event})`
        with :math:`T` the iso-probabilistic transformation and the mean point
        :math:`\vect{X}^*_{event} = \displaystyle \frac{1}{n} \sum_{i=1}^{n} \vect{X}_i 1_{event}(\vect{X}_i)`.

        .. warning::
            This notion is only available if the history mechanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).

        See also
        --------
        drawImportanceFactors
        """
        return _experimental.ProbabilitySimulationResult_getImportanceFactors(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        .. warning::
            It is necessary to enable the history of the model to perform this analysis
            (see :class:`~openturns.MemoizeFunction`).

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Importance factor graph.

        See also
        --------
        getImportanceFactors
        """
        return _experimental.ProbabilitySimulationResult_drawImportanceFactors(self)

    def getConfidenceLength(self, *args):
        r"""
        Accessor to the confidence length.

        Parameters
        ----------
        level : float, :math:`level \in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _experimental.ProbabilitySimulationResult_getConfidenceLength(self, *args)

    def __repr__(self):
        return _experimental.ProbabilitySimulationResult___repr__(self)

    def __init__(self, *args):
        _experimental.ProbabilitySimulationResult_swiginit(self, _experimental.new_ProbabilitySimulationResult(*args))
    __swig_destroy__ = _experimental.delete_ProbabilitySimulationResult

# Register ProbabilitySimulationResult in _experimental:
_experimental.ProbabilitySimulationResult_swigregister(ProbabilitySimulationResult)
class SimulationAlgorithm(openturns.common.PersistentObject):
    r"""
    Base class for simulation algorithms.

    See also
    --------
    ProbabilitySimulationAlgorithm, ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SimulationAlgorithm_getClassName(self)

    def setMaximumOuterSampling(self, maximumOuterSampling):
        r"""
        Accessor to the maximum sample size.

        Parameters
        ----------
        outerSampling : int
            Maximum number of groups of terms in the probability simulation estimator.
        """
        return _experimental.SimulationAlgorithm_setMaximumOuterSampling(self, maximumOuterSampling)

    def getMaximumOuterSampling(self):
        r"""
        Accessor to the maximum sample size.

        Returns
        -------
        outerSampling : int
            Maximum number of groups of terms in the probability simulation estimator.
        """
        return _experimental.SimulationAlgorithm_getMaximumOuterSampling(self)

    def setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation):
        r"""
        Accessor to the maximum coefficient of variation.

        Parameters
        ----------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _experimental.SimulationAlgorithm_setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation)

    def getMaximumCoefficientOfVariation(self):
        r"""
        Accessor to the maximum coefficient of variation.

        Returns
        -------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _experimental.SimulationAlgorithm_getMaximumCoefficientOfVariation(self)

    def setMaximumStandardDeviation(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _experimental.SimulationAlgorithm_setMaximumStandardDeviation(self, maximumStandardDeviation)

    def getMaximumStandardDeviation(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _experimental.SimulationAlgorithm_getMaximumStandardDeviation(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.

        Notes
        -----
        For Monte Carlo, LHS and Importance Sampling methods, this allows one to save space
        while allowing multithreading, when available we recommend
        to use the number of available CPUs; for the Directional Sampling, we recommend
        to set it to 1.
        """
        return _experimental.SimulationAlgorithm_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.
        """
        return _experimental.SimulationAlgorithm_getBlockSize(self)

    def setVerbose(self, verbose):
        return _experimental.SimulationAlgorithm_setVerbose(self, verbose)

    def getVerbose(self):
        return _experimental.SimulationAlgorithm_getVerbose(self)

    def __repr__(self):
        return _experimental.SimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.SimulationAlgorithm_run(self)

    def setConvergenceStrategy(self, convergenceStrategy):
        r"""
        Accessor to the convergence strategy.

        Parameters
        ----------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _experimental.SimulationAlgorithm_setConvergenceStrategy(self, convergenceStrategy)

    def getConvergenceStrategy(self):
        r"""
        Accessor to the convergence strategy.

        Returns
        -------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _experimental.SimulationAlgorithm_getConvergenceStrategy(self)

    def __init__(self, *args):
        _experimental.SimulationAlgorithm_swiginit(self, _experimental.new_SimulationAlgorithm(*args))

    def setProgressCallback(self, *args):
        r"""
        Set up a progress callback.

        Can be used to programmatically report the progress of a simulation.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.

        Examples
        --------
        >>> import sys
        >>> import openturns as ot
        >>> experiment = ot.MonteCarloExperiment()
        >>> X = ot.RandomVector(ot.Normal())
        >>> Y = ot.CompositeRandomVector(ot.SymbolicFunction(['X'], ['1.1*X']), X)
        >>> event = ot.ThresholdEvent(Y, ot.Less(), -2.0)
        >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
        >>> algo.setMaximumOuterSampling(100)
        >>> algo.setMaximumCoefficientOfVariation(-1.0)
        >>> def report_progress(progress):
        ...     sys.stderr.write('-- progress=' + str(progress) + '%\n')
        >>> algo.setProgressCallback(report_progress)
        >>> algo.run()
        """
        return _experimental.SimulationAlgorithm_setProgressCallback(self, *args)

    def setStopCallback(self, *args):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop a simulation.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.

        Examples
        --------
        Stop a Monte Carlo simulation algorithm using a time limit

        >>> import openturns as ot
        >>> experiment = ot.MonteCarloExperiment()
        >>> X = ot.RandomVector(ot.Normal())
        >>> Y = ot.CompositeRandomVector(ot.SymbolicFunction(['X'], ['1.1*X']), X)
        >>> event = ot.ThresholdEvent(Y, ot.Less(), -2.0)
        >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
        >>> algo.setMaximumOuterSampling(10000000)
        >>> algo.setMaximumCoefficientOfVariation(-1.0)
        >>> timer = ot.TimerCallback(0.1)
        >>> algo.setStopCallback(timer)
        >>> algo.run()
        """
        return _experimental.SimulationAlgorithm_setStopCallback(self, *args)
    __swig_destroy__ = _experimental.delete_SimulationAlgorithm

# Register SimulationAlgorithm in _experimental:
_experimental.SimulationAlgorithm_swigregister(SimulationAlgorithm)

def TimerCallback(duration):
    """
    Time stopping criterion.

    Usable as stopping callback for simulation, optimization algorithms.

    Parameters
    ----------
    duration : float
        Maximum duration in seconds of the algorithm.

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.SymbolicFunction(['R', 'S'], ['R-S'])
    >>> distribution = ot.Normal(2)
    >>> vect = ot.RandomVector(distribution)
    >>> output = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(output, ot.Less(), 0.0)
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(int(1e9))
    >>> algo.setMaximumCoefficientOfVariation(-1.0)
    >>> timer = ot.TimerCallback(1.5)
    >>> algo.setStopCallback(timer)
    >>> algo.run()
    """
    from time import time
    try:
        float(duration)
    except ValueError:
        raise ValueError('duration must be a float')
    tmax = time() + duration
    def inner():
        if not hasattr(inner, 'tmax'):
            inner.tmax = tmax
        stop = time() > inner.tmax
        return stop
    return inner

class EventSimulation(SimulationAlgorithm):
    r"""
    Base class for sampling methods.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of.
    convergenceStrategy : :class:`~openturns.HistoryStrategy`, optional
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Base class for sampling methods, using the probability distribution of a random
    vector :math:`\vect{X}` to evaluate the failure probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    The EventSimulation object provides a generic simulation service for non-composite
    events, and its derived classes provide dedicated algorithms:

    - :class:`~openturns.ProbabilitySimulationAlgorithm`

    - :class:`~openturns.DirectionalSampling`

    - :class:`~openturns.LHS`,

    - :class:`~openturns.PostAnalyticalControlledImportanceSampling`,

    - :class:`~openturns.PostAnalyticalImportanceSampling`,

    See also
    --------
    SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.EventSimulation_getClassName(self)

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _experimental.EventSimulation_getEvent(self)

    def getResult(self):
        r"""
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _experimental.EventSimulation_getResult(self)

    def __repr__(self):
        return _experimental.EventSimulation___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.EventSimulation_run(self)

    def drawProbabilityConvergence(self, *args):
        r"""
        Draw the probability convergence at a given level.

        Parameters
        ----------
        level : float, optional
            The probability convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            probability convergence graph
        """
        return _experimental.EventSimulation_drawProbabilityConvergence(self, *args)

    def __init__(self, *args):
        _experimental.EventSimulation_swiginit(self, _experimental.new_EventSimulation(*args))
    __swig_destroy__ = _experimental.delete_EventSimulation

# Register EventSimulation in _experimental:
_experimental.EventSimulation_swigregister(EventSimulation)
class ProbabilitySimulationAlgorithm(EventSimulation):
    r"""
    Iterative sampling methods.

    Refer to :ref:`monte_carlo_simulation`, :ref:`importance_simulation`, :ref:`lhs_simulation`, :ref:`qmc_simulation`.

    Available constructor:
        ProbabilitySimulationAlgorithm(*event, experiment, convergenceStrategy=ot.Compact()*)

        ProbabilitySimulationAlgorithm(*event, convergenceStrategy=ot.Compact()*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of, must be composite.
    experiment : :class:`~openturns.WeightedExperiment`
        Sequential experiment
    convergenceStrategy : :class:`~openturns.HistoryStrategy`, optional
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event 

    .. math::

        \cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\} 

    If we have the set :math:`\left\{ \vect{x}_1,\ldots,\vect{x}_N \right\}` of
    :math:`N` independent samples of the random vector :math:`\vect{X}`, we can
    estimate :math:`\widehat{P}_f` as follows:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows one to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.


    A ProbabilitySimulationAlgorithm object makes sense with the following sequential experiments:

    - :class:`~openturns.MonteCarloExperiment`

    - :class:`~openturns.ImportanceSamplingExperiment`

    - :class:`~openturns.LowDiscrepancyExperiment`

    - :class:`~openturns.LHSExperiment` (for the non randomized version see :class:`~openturns.LHS`)

    The estimator built by Monte Carlo method is:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows one to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.

    The estimator built by Importance Sampling method is:

    .. math::

        \widehat{P}_{f,IS} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{\{g(\vect{Y}_{\:i}),\vect{d}) \leq 0 \}}
                                          \frac{f_{\uX}(\vect{Y}_{\:i})}
                                               {f_{\vect{Y}}(\vect{Y}_{\:i})}


    where:

    - :math:`N` is the total number of computations,

    - the random vectors :math:`\{\vect{Y}_i, i=1\hdots N\}` are independent,
      identically distributed and following the probability density function
      :math:`f_{\uY}`.


    See also
    --------
    EventSimulation

    Examples
    --------
    Estimate a probability by Monte Carlo

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> event = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a Monte Carlo algorithm
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000

    Estimate a probability by Importance Sampling

    >>> ot.RandomGenerator.SetSeed(0)
    >>> # assume we obtained a design point from FORM
    >>> standardSpaceDesignPoint = [-0.0310363,0.841879,0.445462,-0.332318]
    >>> standardEvent = ot.StandardEvent(event)
    >>> importanceDensity = ot.Normal(standardSpaceDesignPoint, ot.CovarianceMatrix(4))
    >>> experiment = ot.ImportanceSamplingExperiment(importanceDensity)
    >>> algo = ot.ProbabilitySimulationAlgorithm(standardEvent, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.153315

    Estimate a probability by Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.141667

    Estimate a probability by Randomized Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> experiment.setRandomize(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.160000

    Estimate a probability by Randomized LHS

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment()
    >>> experiment.setAlwaysShuffle(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ProbabilitySimulationAlgorithm_getClassName(self)

    def getExperiment(self):
        r"""
        Accessor to the experiment.

        Returns
        -------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _experimental.ProbabilitySimulationAlgorithm_getExperiment(self)

    def setExperiment(self, experiment):
        r"""
        Accessor to the experiment.

        Parameters
        ----------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _experimental.ProbabilitySimulationAlgorithm_setExperiment(self, experiment)

    def __repr__(self):
        return _experimental.ProbabilitySimulationAlgorithm___repr__(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.

        Notes
        -----
        For Monte Carlo, LHS and Importance Sampling methods, this allows one to save space
        while allowing multithreading, when available we recommend
        to use the number of available CPUs; for the Directional Sampling, we recommend
        to set it to 1.
        """
        return _experimental.ProbabilitySimulationAlgorithm_setBlockSize(self, blockSize)

    def __init__(self, *args):
        _experimental.ProbabilitySimulationAlgorithm_swiginit(self, _experimental.new_ProbabilitySimulationAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_ProbabilitySimulationAlgorithm

# Register ProbabilitySimulationAlgorithm in _experimental:
_experimental.ProbabilitySimulationAlgorithm_swigregister(ProbabilitySimulationAlgorithm)
class PostAnalyticalSimulation(EventSimulation):
    r"""
    Post analytical simulation.

    See also
    --------
    PostAnalyticalImportanceSampling, PostAnalyticalControlledImportanceSampling

    Notes
    -----
    This class inherits from EventSimulation.

    The principle is to perform a simulation study to evaluate the threshold
    exceedance probability according to an importance density centered around the
    design point, in the standard space. The importance distribution is the standard
    distribution of the standard space.

    A PostAnalyticalSimulation object can be created only through its derivative
    classes : :class:`~openturns.PostAnalyticalImportanceSampling` or
    :class:`~openturns.PostAnalyticalControlledImportanceSampling`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PostAnalyticalSimulation_getClassName(self)

    def getAnalyticalResult(self):
        r"""
        Accessor to the analytical result.

        Returns
        -------
        result : :class:`~openturns.AnalyticalResult`
            Result of the analytical study which has been performed just before the 
            simulation study centered around the importance factor.
        """
        return _experimental.PostAnalyticalSimulation_getAnalyticalResult(self)

    def getControlProbability(self):
        r"""
        Accessor to the control probability.

        Returns
        -------
        p : float,
            The probability of the analytical result.

        Notes
        -----
        The control probability :math:`p` is deduced from the corresponding analytical result:

        .. math::

            p = E(-\beta_{HL})

        where :math:`\beta_{HL}` denotes the Hasofer reliability index and :math:`E`
        the univariate standard CDF of the elliptical distribution in the standard space.
        """
        return _experimental.PostAnalyticalSimulation_getControlProbability(self)

    def __repr__(self):
        return _experimental.PostAnalyticalSimulation___repr__(self)

    def __init__(self, *args):
        _experimental.PostAnalyticalSimulation_swiginit(self, _experimental.new_PostAnalyticalSimulation(*args))
    __swig_destroy__ = _experimental.delete_PostAnalyticalSimulation

# Register PostAnalyticalSimulation in _experimental:
_experimental.PostAnalyticalSimulation_swigregister(PostAnalyticalSimulation)
class Wilks(openturns.common.Object):
    r"""
    Class to evaluate the Wilks number.

    Refer to :ref:`quantile_estimation_wilks`.

    Parameters
    ----------
    randomVector : :class:`~openturns.RandomVector` of dimension 1
        Output variable of interest.

    Notes
    -----
    This class is a static class which enables the evaluation of the Wilks number:
    the minimal sample size :math:`N_{\alpha, \beta, i}` to perform in order to
    guarantee that the empirical quantile :math:`\alpha`, noted
    :math:`\tilde{q}_{\alpha} N_{\alpha, \beta, i}` evaluated with the
    :math:`(n - i)^{th}` maximum of the sample, noted :math:`X_{n - i}` be greater
    than the theoretical quantile :math:`q_{\alpha}` with a probability at least
    :math:`\beta`:

    .. math::

        \Pset (\tilde{q}_{\alpha} N_{\alpha, \beta, i} > q_{\alpha}) > \beta

    where :math:`\tilde{q}_{\alpha} N_{\alpha, \beta, i} = X_{n-i}`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate the size of the sample.

        Parameters
        ----------
        alpha : positive float :math:`< 1`
            The order of the quantile we want to evaluate.
        beta : positive float :math:`< 1`
            Confidence on the evaluation of the empirical quantile.
        i : int
            Rank of the maximum which will evaluate the empirical quantile. Default
            :math:`i = 0` (maximum of the sample)

        Returns
        -------
        w : int
            the Wilks number.
        """
        return _experimental.Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex)

    def computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate the bound of the quantile.

        Parameters
        ----------
        alpha : positive float :math:`< 1`
            The order of the quantile we want to evaluate.
        beta : positive float :math:`< 1`
            Confidence on the evaluation of the empirical quantile.
        i : int
            Rank of the maximum which will evaluate the empirical quantile. Default
            :math:`i = 0` (maximum of the sample)

        Returns
        -------
        q : :class:`~openturns.Point`
            The estimate of the quantile upper bound for the given quantile level, at
            the given confidence level and using the given upper statistics.
        """
        return _experimental.Wilks_computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex)

    def __init__(self, *args):
        _experimental.Wilks_swiginit(self, _experimental.new_Wilks(*args))
    __swig_destroy__ = _experimental.delete_Wilks

# Register Wilks in _experimental:
_experimental.Wilks_swigregister(Wilks)
class LHS(EventSimulation):
    r"""
    Latin Hypercube Sampling (LHS) method.

    Available constructors:
        LHS(*event=ot.Event()*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    LHS or Latin Hypercube Sampling is a sampling method enabling to better cover
    the domain of variations of the input variables, thanks to a stratified
    sampling strategy. This method is applicable in the case of independent input
    variables. The sampling procedure is based on dividing the range of each
    variable into several intervals of equal probability. The sampling is
    undertaken as follows:

    - Step 1: The range of each input variable is stratified into isoprobabilistic
      cells,

    - Step 2: A cell is uniformly chosen among all the available cells,

    - Step 3: The random number is obtained by inverting the Cumulative Density
      Function locally in the chosen cell,

    - Step 4: All the cells having a common strate with the previous cell are put
      apart from the list of available cells.

    The estimator of the probability of failure with LHS is given by:

    .. math::

        \widehat{P}_{f,LHS} = \frac{1}{N}
                              \sum_{i=1}^N \mathbf{1}_{\{g(\uX^i,\vect{d}) \leq 0 \}}

    where the sample of :math:`\{ \uX^i,i=1 \hdots N \}` is obtained as described
    previously.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an event from this RandomVector
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a LHS algorithm
    >>> myAlgo = ot.LHS(myEvent)
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.151667
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LHS_getClassName(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.LHS_run(self)

    def __repr__(self):
        return _experimental.LHS___repr__(self)

    def __init__(self, *args):
        _experimental.LHS_swiginit(self, _experimental.new_LHS(*args))
    __swig_destroy__ = _experimental.delete_LHS

# Register LHS in _experimental:
_experimental.LHS_swigregister(LHS)
class PostAnalyticalControlledImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical controlled importance sampling.

    Simulation method where the original distribution is replaced by the
    distribution in the standard space centered around the provided design point
    and is controlled by the value of the linearized limit state function.

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study: in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalImportanceSampling

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)
    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)
    >>> solver = ot.AbdoRackwitz()
    >>> analytical = ot.FORM(solver, event, [50.0, 1.0, 10.0, 5.0])
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()
    >>> algo = ot.PostAnalyticalControlledImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PostAnalyticalControlledImportanceSampling_getClassName(self)

    def __repr__(self):
        return _experimental.PostAnalyticalControlledImportanceSampling___repr__(self)

    def __init__(self, *args):
        _experimental.PostAnalyticalControlledImportanceSampling_swiginit(self, _experimental.new_PostAnalyticalControlledImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_PostAnalyticalControlledImportanceSampling

# Register PostAnalyticalControlledImportanceSampling in _experimental:
_experimental.PostAnalyticalControlledImportanceSampling_swigregister(PostAnalyticalControlledImportanceSampling)
class PostAnalyticalImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical importance sampling.

    Simulation method where the original distribution is replaced by the
    distribution in the standard space centered around the provided design point.

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study: in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalControlledImportanceSampling

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)
    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)
    >>> solver = ot.AbdoRackwitz()
    >>> analytical = ot.FORM(solver, event, [50.0, 1.0, 10.0, 5.0])
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()
    >>> algo = ot.PostAnalyticalImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PostAnalyticalImportanceSampling_getClassName(self)

    def __repr__(self):
        return _experimental.PostAnalyticalImportanceSampling___repr__(self)

    def __init__(self, *args):
        _experimental.PostAnalyticalImportanceSampling_swiginit(self, _experimental.new_PostAnalyticalImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_PostAnalyticalImportanceSampling

# Register PostAnalyticalImportanceSampling in _experimental:
_experimental.PostAnalyticalImportanceSampling_swigregister(PostAnalyticalImportanceSampling)
class RootStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RootStrategyImplementation_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.RootStrategyImplementation_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategyImplementation_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategyImplementation_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategyImplementation_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategyImplementation_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategyImplementation_getOriginValue(self)

    def __repr__(self):
        return _experimental.RootStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _experimental.RootStrategyImplementation_swiginit(self, _experimental.new_RootStrategyImplementation(*args))
    __swig_destroy__ = _experimental.delete_RootStrategyImplementation

# Register RootStrategyImplementation in _experimental:
_experimental.RootStrategyImplementation_swigregister(RootStrategyImplementation)
class _RootStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _experimental._RootStrategyImplementationTypedInterfaceObject_swiginit(self, _experimental.new__RootStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _experimental._RootStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _experimental._RootStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _experimental._RootStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _experimental.delete__RootStrategyImplementationTypedInterfaceObject

# Register _RootStrategyImplementationTypedInterfaceObject in _experimental:
_experimental._RootStrategyImplementationTypedInterfaceObject_swigregister(_RootStrategyImplementationTypedInterfaceObject)
class RootStrategy(_RootStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RootStrategy_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.RootStrategy_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategy_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental.RootStrategy_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental.RootStrategy_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategy_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental.RootStrategy_getOriginValue(self)

    def __repr__(self):
        return _experimental.RootStrategy___repr__(self)

    def __init__(self, *args):
        _experimental.RootStrategy_swiginit(self, _experimental.new_RootStrategy(*args))
    __swig_destroy__ = _experimental.delete_RootStrategy

# Register RootStrategy in _experimental:
_experimental.RootStrategy_swigregister(RootStrategy)
class SamplingStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for sampling strategies.

    Available constructor:
        SamplingStrategyImplementation()

        SamplingStrategyImplementation(*samplingStratImp*)

        SamplingStrategyImplementation(*dimension*)

    Parameters
    ----------
    samplingStratImp : SamplingStrategyImplementationImplementation
        An implementation of the sampling strategy adopted, which is
        :class:`~openturns.RandomDirection` or :class:`~openturns.OrthogonalDirection`.
    dimension : int
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SamplingStrategyImplementation_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _experimental.SamplingStrategyImplementation_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _experimental.SamplingStrategyImplementation_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategyImplementation_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategyImplementation_getDimension(self)

    def __repr__(self):
        return _experimental.SamplingStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _experimental.SamplingStrategyImplementation_swiginit(self, _experimental.new_SamplingStrategyImplementation(*args))
    __swig_destroy__ = _experimental.delete_SamplingStrategyImplementation

# Register SamplingStrategyImplementation in _experimental:
_experimental.SamplingStrategyImplementation_swigregister(SamplingStrategyImplementation)
class _SamplingStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _experimental._SamplingStrategyImplementationTypedInterfaceObject_swiginit(self, _experimental.new__SamplingStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _experimental._SamplingStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _experimental.delete__SamplingStrategyImplementationTypedInterfaceObject

# Register _SamplingStrategyImplementationTypedInterfaceObject in _experimental:
_experimental._SamplingStrategyImplementationTypedInterfaceObject_swigregister(_SamplingStrategyImplementationTypedInterfaceObject)
class SamplingStrategy(_SamplingStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for sampling strategies.

    Available constructor:
        SamplingStrategyImplementation()

        SamplingStrategyImplementation(*samplingStratImp*)

        SamplingStrategyImplementation(*dimension*)

    Parameters
    ----------
    samplingStratImp : SamplingStrategyImplementationImplementation
        An implementation of the sampling strategy adopted, which is
        :class:`~openturns.RandomDirection` or :class:`~openturns.OrthogonalDirection`.
    dimension : int
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SamplingStrategy_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _experimental.SamplingStrategy_generate(self)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategy_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental.SamplingStrategy_getDimension(self)

    def __repr__(self):
        return _experimental.SamplingStrategy___repr__(self)

    def __init__(self, *args):
        _experimental.SamplingStrategy_swiginit(self, _experimental.new_SamplingStrategy(*args))
    __swig_destroy__ = _experimental.delete_SamplingStrategy

# Register SamplingStrategy in _experimental:
_experimental.SamplingStrategy_swigregister(SamplingStrategy)
class DirectionalSampling(EventSimulation):
    r"""
    Directional simulation.

    Refer to :ref:`directional_simulation`.

    Available constructors:
        DirectionalSampling(*event=ot.Event()*)

        DirectionalSampling(*event, rootStrategy, samplingStrategy*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability. By default,
        *rootStrategy = ot.RootStrategy(ot.SafeAndSlow())*.
    samplingStrategy : :class:`~openturns.SamplingStrategy`
        Strategy adopted to sample directions. By default,
        *samplingStrategy=ot.SamplingStrategy(ot.RandomDirection())*.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    The directional simulation method is an accelerated sampling method. It implies
    a preliminary iso-probabilistic transformation, as for :class:`~openturns.FORM`
    and :class:`~openturns.SORM` methods; however, it remains based on sampling and
    is thus not an approximation method.
    In the transformed space, the (transformed) uncertain variables :math:`\vect{U}`
    are independent standard gaussian variables (mean equal to zero and standard
    deviation equal to 1).

    Roughly speaking, each simulation of the directional simulation algorithm is
    made of three steps. For the :math:`i^\textrm{th}` iteration, these steps are
    the following:

    - Let :math:`\cS = \big\{ \vect{u} \big| ||\vect{u}|| = 1 \big\}`. A point
      :math:`P_i` is drawn randomly on :math:`\cS` according to an uniform
      distribution.

    - In the direction starting from the origin and passing through :math:`P_i`,
      solutions of the equation :math:`g(\vect{X},\vect{d}) = 0` (i.e. limits of
      :math:`\cD_f`) are searched. The set of values of :math:`\vect{u}` that
      belong to :math:`\cD_f` is deduced for these solutions: it is a subset
      :math:`I_i \subset \Rset`.

    - Then, one calculates the probability :math:`q_i = \Prob{ ||\vect{U}|| \in I_i }`.
      By property of independent standard variable, :math:`||\vect{U}||^2` is a
      random variable distributed according to a chi-square distribution, which
      makes the computation effortless.

    Finally, the estimate of the probability :math:`P_f` after :math:`N` simulations
    is the following:

    .. math::

        \widehat{P}_{f,DS} = \frac{1}{N} \sum_{i=1}^N q_i

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a DirectionalSampling algorithm
    >>> myAlgo = ot.DirectionalSampling(myEvent, ot.MediumSafe(), ot.OrthogonalDirection())
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.169716
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.DirectionalSampling_getClassName(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _experimental.DirectionalSampling_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _experimental.DirectionalSampling_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _experimental.DirectionalSampling_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _experimental.DirectionalSampling_getSamplingStrategy(self)

    def __repr__(self):
        return _experimental.DirectionalSampling___repr__(self)

    def __init__(self, *args):
        _experimental.DirectionalSampling_swiginit(self, _experimental.new_DirectionalSampling(*args))
    __swig_destroy__ = _experimental.delete_DirectionalSampling

# Register DirectionalSampling in _experimental:
_experimental.DirectionalSampling_swigregister(DirectionalSampling)
class OrthogonalDirection(SamplingStrategyImplementation):
    r"""
    Sampling following the orthogonal direction strategy.

    Available constructor:
        OrthogonalDirection()

        OrthogonalDirection(*dimension, k*)

    Parameters
    ----------
    dimension : integer
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.
    k : int
        The number of elements in the linear combinations. By default,
        :math:`k = 1` but automatically updated by the calling class.

    See also
    --------
    RandomDirection

    Notes
    -----
    This strategy is parameterized by :math:`k \in \{1, \ldots, n\}`, where :math:`n` is
    the dimension of the input random vector :math:`\vect{X}`. We generate one
    direct orthonormalized basis :math:`(\vect{e}_1, \ldots, \vect{e}_n)` uniformly distributed in
    the set of direct orthonormal bases. We consider all the normalized linear
    combinations of :math:`k` vectors chosen within the :math:`n` vectors of the basis, where
    the coefficients of the linear combinations are in :math:`\{+1, -1\}`. This
    generates :math:`\binom{k}{n} 2^k` new vectors :math:`\vect{v}_i`. We sample according
    to all the directions defined by the vectors :math:`\vect{v}_i`.

    If :math:`k = 1`, we consider all the axes of the standard space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.OrthogonalDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the orthogonal direction strategy.
        """
        return _experimental.OrthogonalDirection_generate(self)

    def __repr__(self):
        return _experimental.OrthogonalDirection___repr__(self)

    def getUniformOrientationRealization(self):
        return _experimental.OrthogonalDirection_getUniformOrientationRealization(self)

    def __init__(self, *args):
        _experimental.OrthogonalDirection_swiginit(self, _experimental.new_OrthogonalDirection(*args))
    __swig_destroy__ = _experimental.delete_OrthogonalDirection

# Register OrthogonalDirection in _experimental:
_experimental.OrthogonalDirection_swigregister(OrthogonalDirection)
class RandomDirection(SamplingStrategyImplementation):
    r"""
    Sampling following the random direction strategy.

    Available constructor:
        RandomDirection()

        RandomDirection(*dimension*)

    Parameters
    ----------
    dimension : integer
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    OrthogonalDirection

    Notes
    -----
    The RandomDirection strategy is the following : we generate some points on the
    sphere unity in the standard space according to the uniform distribution and we
    consider both opposite directions so built.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RandomDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated in two opposite random directions.
        """
        return _experimental.RandomDirection_generate(self)

    def __repr__(self):
        return _experimental.RandomDirection___repr__(self)

    def __init__(self, *args):
        _experimental.RandomDirection_swiginit(self, _experimental.new_RandomDirection(*args))
    __swig_destroy__ = _experimental.delete_RandomDirection

# Register RandomDirection in _experimental:
_experimental.RandomDirection_swigregister(RandomDirection)
class MediumSafe(RootStrategyImplementation):
    r"""
    MediumSafe method.

    Available constructors:
        MediumSafe(*solver=ot.Brent()*)

        MediumSafe(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *MediumSafe* strategy is the following: for each direction, we go along the
    direction by step of length *stepSize* from the origin to the maximum distant
    point (at distance *maximumDistance* from the center of the standard space) and
    we check whether there is a sign changement on each segment so formed.

    At the first sign changement, we research one root in the concerned segment
    with the selected non linear solver. Then, the segment
    *[root, maximum distant point]* is considered within the failure space.

    If *stepSize* is small enough, this strategy guarantees us to find the root which
    is the nearest from the origin.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.MediumSafe_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.MediumSafe_solve(self, function, value)

    def __repr__(self):
        return _experimental.MediumSafe___repr__(self)

    def __init__(self, *args):
        _experimental.MediumSafe_swiginit(self, _experimental.new_MediumSafe(*args))
    __swig_destroy__ = _experimental.delete_MediumSafe

# Register MediumSafe in _experimental:
_experimental.MediumSafe_swigregister(MediumSafe)
class RiskyAndFast(RootStrategyImplementation):
    r"""
    RiskyAndFast method.

    Available constructors:
        RiskyAndFast(*solver=ot.Brent()*)

        RiskyAndFast(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *RiskyAndFast* strategy is the following: for each direction, we check
    whether there is a sign changement of the standard limit state function between
    the maximum distant point (at distance *maximumDistance* from the center of the
    standard space) and the center of the standard space.

    In case of sign changement, we search one root in the segment
    *[origin, maximum distant point]* with the selected non linear solver.

    As soon as founded, the segment *[root, infinity point]* is considered within
    the failure space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.RiskyAndFast_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.RiskyAndFast_solve(self, function, value)

    def __repr__(self):
        return _experimental.RiskyAndFast___repr__(self)

    def __init__(self, *args):
        _experimental.RiskyAndFast_swiginit(self, _experimental.new_RiskyAndFast(*args))
    __swig_destroy__ = _experimental.delete_RiskyAndFast

# Register RiskyAndFast in _experimental:
_experimental.RiskyAndFast_swigregister(RiskyAndFast)
class SafeAndSlow(RootStrategyImplementation):
    r"""
    SafeAndSlow method.

    Available constructors:
        SafeAndSlow(*solver=ot.Brent()*)

        SafeAndSlow(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *SafeAndSlow* strategy is the following: for each direction, we go along
    the direction by step of length *stepSize* from the origin to the maximum
    distant point(at distance *maximumDistance* from the center of the standard
    space) and we check whether there is a sign changement on each segment so
    formed.

    We go until the maximum distant point. Then, for all the segments where we
    detected the presence of a root, we research the root with the selected non
    linear solver. We evaluate the contribution to the failure probability of each
    segment.

    If *stepSize* is small enough, this strategy guarantees us to find all the roots
    in the direction and the contribution of this direction to the failure
    probability is precisely evaluated.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SafeAndSlow_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental.SafeAndSlow_solve(self, function, value)

    def __repr__(self):
        return _experimental.SafeAndSlow___repr__(self)

    def __init__(self, *args):
        _experimental.SafeAndSlow_swiginit(self, _experimental.new_SafeAndSlow(*args))
    __swig_destroy__ = _experimental.delete_SafeAndSlow

# Register SafeAndSlow in _experimental:
_experimental.SafeAndSlow_swigregister(SafeAndSlow)
class SimulationSensitivityAnalysis(openturns.common.PersistentObject):
    r"""
    Class to perform a sensitivity analysis based on a reliability event.

    Available constructor:
        SimulationSensitivityAnalysis(*event, inputSample, outputSample*)

        SimulationSensitivityAnalysis(*event*)

        SimulationSensitivityAnalysis(*simulationRes*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        An event which it composite (test is with the method
        :meth:`isComposite <openturns.Event.isComposite>`).
    inputSample, outputSample : 2-d sequence of float
        Input sample and output sample of a model evaluated apart.
    simulationRes : :class:`~openturns.ProbabilitySimulationResult`
        A simulation result.

    Notes
    -----
    The simulation sensitivity analysis is based on:

    - in the first usage, the *inputSample* and *outputSample* given:
    - in the second usage, the samples which have been stored by the function
      defining the event. Care if the sample is not a statistical sample: post
      treatment proposed by the object might not be right.
    - in the third usage, the samples generated by the
      :class:`~openturns.EventSimulation` that produced *simulationRes*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SimulationSensitivityAnalysis_getClassName(self)

    def computeMeanPointInEventDomain(self, *args):
        r"""
        Accessor to the mean point.

        Returns
        -------
        mean : :class:`~openturns.Point`
            The mean point in the failure domain.

        Notes
        -----
        This method computes the mean point in the physical space of all the simulations
        generated by the simulation that failed into the event domain.

        Be careful: this notion is only valid for Monte Carlo or LHS sampling as the
        mean is evaluated from the equation :eq:`mean_point` (only uniform weights over
        the realizations :math:`\vect{X}_i`.
        """
        return _experimental.SimulationSensitivityAnalysis_computeMeanPointInEventDomain(self, *args)

    def computeImportanceFactors(self, *args):
        r"""
        Compute the importance factors.

        Returns
        -------
        impFactors : :class:`~openturns.PointWithDescription`
            The importance factors.

        Notes
        -----
        The importance factors, given in :eq:`importance_factor`, are evaluated from the
        coordinates of the mean point :eq:`mean_point` of the event domain, mapped into
        the standard space as follows:

        .. math::
            :label: mean_point

            \vect{X}^*_{event} = \frac{1}{n} \sum_{i=1}^n \vect{X}_i 1_{event} (\vect{X}_i)

        .. math::
            :label: importance_factor

            \alpha_i = \frac{ (U_i^*)^2 }{ \left\| \vect{U}^* \right\| }

        where

        .. math::

            \vect{U}^* = T(\vect{X}^*_{event})

        Be careful: this notion is only valid for :class:`~openturns.MonteCarlo` or
        :class:`~openturns.LHS` sampling as the mean is evaluated from the equation
        :eq:`importance_factor` (only uniform weights over the realizations
        :math:`\vect{X}_i`.
        """
        return _experimental.SimulationSensitivityAnalysis_computeImportanceFactors(self, *args)

    def computeEventProbabilitySensitivity(self):
        r"""
        Compute the sensitivity to the probability.

        The sensitivity of the probability Pf wrt the distribution parameters :math:`\theta` is written:

        .. math::

            \vect{sens_{Pf}}_j = \frac{1}{n} \sum_{i=1}^n \mathbf{1}_{event} \vect{\frac{\delta log(f_{\uX})(\vect{X}_i)}{\delta \theta_j}}

        Returns
        -------
        sensitivity_pf : :class:`~openturns.PointWithDescription`
            The probability sensitivity.
        """
        return _experimental.SimulationSensitivityAnalysis_computeEventProbabilitySensitivity(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph containing the pie corresponding to the importance factors of the probabilistic variables.
        """
        return _experimental.SimulationSensitivityAnalysis_drawImportanceFactors(self)

    def drawImportanceFactorsRange(self, *args):
        r"""
        Draw the importance factors evolution.

        Parameters
        ----------
        probabilityScale : boolean
            Set True if the limits are the probability levels; set False if the limits are
            the thresholds defining the event.
        lower, upper : floats
            Define the boundaries of the probability levels :math:`p_{min}` and
            :math:`p_{max}` or those of the thresholds :math:`s_{min}` and :math:`s_{max}`. 

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph that draws the evolution of the importance factors of each direction
            with respect to :math:`p \in [p_{min}, p_{max}]` or
            :math:`s \in [s_{min}, s_{max}]`. The importance factors are evaluated from
            the definition :eq:`importance_factor` for each threshold *s* or probability
            *p*.
        """
        return _experimental.SimulationSensitivityAnalysis_drawImportanceFactorsRange(self, *args)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample.
        """
        return _experimental.SimulationSensitivityAnalysis_getInputSample(self)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample.
        """
        return _experimental.SimulationSensitivityAnalysis_getOutputSample(self)

    def getThreshold(self):
        r"""
        Accessor to the threshold.

        Returns
        -------
        s : float
            The threshold.
        """
        return _experimental.SimulationSensitivityAnalysis_getThreshold(self)

    def getTransformation(self):
        r"""
        Accessor to the isoprobabilistic transformation function.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            The isoprobabilistic transformation function.
        """
        return _experimental.SimulationSensitivityAnalysis_getTransformation(self)

    def getComparisonOperator(self):
        r"""
        Accessor to the comparison operator.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            The comparison operator.
        """
        return _experimental.SimulationSensitivityAnalysis_getComparisonOperator(self)

    def __repr__(self):
        return _experimental.SimulationSensitivityAnalysis___repr__(self)

    def __init__(self, *args):
        _experimental.SimulationSensitivityAnalysis_swiginit(self, _experimental.new_SimulationSensitivityAnalysis(*args))
    __swig_destroy__ = _experimental.delete_SimulationSensitivityAnalysis

# Register SimulationSensitivityAnalysis in _experimental:
_experimental.SimulationSensitivityAnalysis_swigregister(SimulationSensitivityAnalysis)
class SubsetSamplingResult(ProbabilitySimulationResult):
    r"""
    Subset sampling result.

    See also
    --------
    SubsetSampling, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SubsetSamplingResult_getClassName(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.SubsetSamplingResult_getCoefficientOfVariation(self)

    def __repr__(self):
        return _experimental.SubsetSamplingResult___repr__(self)

    def __init__(self, *args):
        _experimental.SubsetSamplingResult_swiginit(self, _experimental.new_SubsetSamplingResult(*args))
    __swig_destroy__ = _experimental.delete_SubsetSamplingResult

# Register SubsetSamplingResult in _experimental:
_experimental.SubsetSamplingResult_swigregister(SubsetSamplingResult)
class SubsetSampling(EventSimulation):
    r"""
    Subset simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability.
    proposalRange : float, optional
        Proposal range length
    targetProbability : float, optional
        Value of :math:`P(F_i|F_{i-1})` between successive steps

    Notes
    -----
    The goal is to estimate the following probability

    .. math::

        P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux}\\
            = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \:\leq 0\: \}}f_{\uX}(\ux)\di{\ux}\\
            = \Prob {\{g(\uX,\underline{d}) \leq 0\}}


    The idea of the subset simulation method [au2001]_ is to replace simulating a
    rare failure event in the original probability space by a sequence of
    simulations of more frequent conditional events :math:`F_i`

    .. math::

        F_1 \supset F_2 \supset \dots \supset F_m = F


    The original probability estimate rewrites

    .. math::

        P_f = P(F_m) = P(\bigcap \limits_{i=1}^m F_i) = P(F_1) \prod_{i=2}^m P(F_i|F_{i-1})


    And each conditional subset failure region is chosen by setting the threshold
    :math:`g_i` so that :math:`P(F_i|F_{i-1})` leads to a conditional failure
    probability of order :math:`0.1`

    .. math::

        F_i =\Prob {\{g(\uX,\underline{d}) \leq g_i\}}


    The conditional samples are generated by the means of Markov Chains,
    using the Metropolis Hastings algorithm.

    :math:`N` being the number of simulations per subset, and :math:`p_{0i}` the
    conditional probability of each subset event, and :math:`\gamma_i` the
    autocorrelation between Markov chain samples.

    .. math::

        \delta^2 = \sum_{i=1}^m \delta^2_i = \sum_{i=1}^m (1+\gamma_i) \frac{1-p_{0i}}{p_{0i}N}


    The first event :math:`F_1` not being conditional, :math:`\delta^2_1`
    expresses as the classic Monte Carlo c.o.v.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SubsetSampling_getClassName(self)

    def setProposalRange(self, proposalRange):
        r"""
        Proposal range length accessor.

        Parameters
        ----------
        range : float
            Range length.
        """
        return _experimental.SubsetSampling_setProposalRange(self, proposalRange)

    def getProposalRange(self):
        r"""
        Proposal range length accessor.

        Returns
        -------
        range : float
            Range length.
        """
        return _experimental.SubsetSampling_getProposalRange(self)

    def setConditionalProbability(self, conditionalProbability):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Parameters
        ----------
        prob : float
            Conditional probability value.
        """
        return _experimental.SubsetSampling_setConditionalProbability(self, conditionalProbability)

    def getConditionalProbability(self):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Returns
        -------
        prob : float
            Conditional probability value.
        """
        return _experimental.SubsetSampling_getConditionalProbability(self)

    def setMinimumProbability(self, minimumProbability):
        r"""
        Minimum probability accessor.

        Allows one to stop the algorithm if the probability becomes too small.

        Parameters
        ----------
        prob_min : float, defaults to the square root of SpecFunc.MinScalar
            Minimum probability.
        """
        return _experimental.SubsetSampling_setMinimumProbability(self, minimumProbability)

    def getMinimumProbability(self):
        r"""
        Minimum probability accessor.

        Returns
        -------
        prob_min : float
            Minimum probability.
        """
        return _experimental.SubsetSampling_getMinimumProbability(self)

    def getStepsNumber(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps, including the initial Monte Carlo sampling.
        """
        return _experimental.SubsetSampling_getStepsNumber(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            Threshold values at each step.
        """
        return _experimental.SubsetSampling_getThresholdPerStep(self)

    def getGammaPerStep(self):
        r"""
        Autocorrelation accessor.

        Returns
        -------
        prob : :class:`~openturns.Point`
            Autocorrelation values at each step.
        """
        return _experimental.SubsetSampling_getGammaPerStep(self)

    def getCoefficientOfVariationPerStep(self):
        r"""
        Coefficient of variation per step accessor.

        Returns
        -------
        coef : :class:`~openturns.Point`
            Coefficient of variation at each subset step.
        """
        return _experimental.SubsetSampling_getCoefficientOfVariationPerStep(self)

    def getProbabilityEstimatePerStep(self):
        r"""
        Probability estimate accessor.

        Returns
        -------
        prob : :class:`~openturns.Point`
            Probability estimate at each step.
        """
        return _experimental.SubsetSampling_getProbabilityEstimatePerStep(self)

    def setKeepEventSample(self, keepEventSample):
        return _experimental.SubsetSampling_setKeepEventSample(self, keepEventSample)

    def getEventInputSample(self):
        return _experimental.SubsetSampling_getEventInputSample(self)

    def getEventOutputSample(self):
        return _experimental.SubsetSampling_getEventOutputSample(self)

    def setKeepSample(self, keepSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        keepsample : bool
            Whether to keep the working samples at each iteration.
        """
        return _experimental.SubsetSampling_setKeepSample(self, keepSample)
    EVENT0 = _experimental.SubsetSampling_EVENT0
    EVENT1 = _experimental.SubsetSampling_EVENT1
    BOTH = _experimental.SubsetSampling_BOTH

    def getInputSample(self, *args):
        r"""
        Input sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _experimental.SubsetSampling_getInputSample(self, *args)

    def getOutputSample(self, *args):
        r"""
        Output sample accessor.

        Parameters
        ----------
        step : int
            Iteration index
        select : int, optional
            Selection flag:

            - EVENT0 : points not realizing the event are selected
            - EVENT1 : points realizing the event are selected
            - BOTH : all points are selected (default)

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _experimental.SubsetSampling_getOutputSample(self, *args)

    def setISubset(self, iSubset):
        return _experimental.SubsetSampling_setISubset(self, iSubset)

    def setBetaMin(self, betaMin):
        return _experimental.SubsetSampling_setBetaMin(self, betaMin)

    def setInitialExperiment(self, initialExperiment):
        r"""
        Initial experiment accessor.

        Parameters
        ----------
        initialExperiment : :class:`~openturns.WeightedExperiment`
            Experiment for first step.
        """
        return _experimental.SubsetSampling_setInitialExperiment(self, initialExperiment)

    def getInitialExperiment(self):
        r"""
        Initial experiment accessor.

        Returns
        -------
        initialExperiment : :class:`~openturns.WeightedExperiment`
            Experiment for first step.
        """
        return _experimental.SubsetSampling_getInitialExperiment(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.SubsetSampling_run(self)

    def __repr__(self):
        return _experimental.SubsetSampling___repr__(self)

    def __init__(self, *args):
        _experimental.SubsetSampling_swiginit(self, _experimental.new_SubsetSampling(*args))
    __swig_destroy__ = _experimental.delete_SubsetSampling

# Register SubsetSampling in _experimental:
_experimental.SubsetSampling_swigregister(SubsetSampling)
class AdaptiveDirectionalStratification(EventSimulation):
    r"""
    Adaptive directional simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability.
        Set to :class:`~openturns.SafeAndSlow` by default.
    samplingStrategy : :class:`~openturns.SamplingStrategy`, optional
        Strategy adopted to sample directions.
        Set to :class:`~openturns.RandomDirection` by default.

    Notes
    -----
    Let :math:`\mathcal D_f` denote the failure domain defined as
    :math:`\mathcal D_f = \{\ux \in \mathbb R^{n_X} | g(\ux) \leq 0\}`, where
    :math:`\ux` are realization of the random vector :math:`\uX` and :math:`g` is the limit-state
    function as defined elsewhere in the documentation.

    The purpose of the ADS-2 algorithm and its variants is to estimate the
    following probability:

    .. math::

      P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux} \\
          = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux) \:\leq 0\: \}}\,f_{\uX}(\ux)\di{\ux} \\
          = \Prob{\{g(\uX) \leq 0\}}.

    Principles

    The ADS-2 method [munoz2011]_ combines the stratified and directional sampling concepts.
    Stratified sampling consists in splitting the support of the random vector
    :math:`\ux` into :math:`m` mutually exclusive and collectively exhaustive subsets.
    Here, ADS-2 splits the standard space into :math:`m = 2^d` quadrants, where
    :math:`d` is the dimension of the random vector :math:`\uX`.
    Stratified sampling is often run in two steps: (i) a learning step is used for
    polling the input space and detect the subsets that contribute most to the
    probability and (ii) an estimation step is used for estimating
    the probability by weighted sampling (some subsets are more sampled than the others).
    Directional sampling uses the spheric symmetry of the standard space for
    estimating the failure probability as the average of conditional probabilities
    calculated on directions drawn at random in the standard space.

    The learning step uses an a priori number of random directions that is
    uniformly distributed over the quadrants, meaning the weights are as follows:

    .. math::

        \omega^1_i = \frac{1}{m}, \quad i = 1, \ldots, m.


    Directional sampling is used for estimating the failure probability in each quadrant:

    .. math::

        \hat P_i^{DS} = \Prob{\{g(\uX) \leq 0\} \mid \uX \in \mathbb{Q}_i},\,i = 1, \ldots, m.


    and the corresponding estimation variances are denoted as :math:`\sigma_i^{DS\,2}`.
    These probabilities are estimated using the same number :math:`N^0_i` of random
    directions per quadrant as told by the uniform weights distribution.

    The probability of interest is then computed as a weighted average of the
    previously defined conditional probabilities:

    .. math::

        \hat P_f = \sum\limits_{i=1}^m \omega_i \hat P_i^{DS}


    where :math:`\hat P_i^{DS}` is the conditional probability estimator in the i-th quadrant. The corresponding variance of the stratified estimator reads:

    .. math::

        \sigma^2 = \frac{1}{N_l} \left( \sum\limits_{i=1}^m \omega_i \sigma_i^{DS} \right) ^2


    where :math:`\sigma_i^{DS\,2}` is the variance of the conditional probability
    estimator in the i-th quadrant.

    At the end of the learning step, the weights :math:`\omega_i` are updated so
    as to minimize the stratified estimator variance.
    Indeed, it can be shown that the updated weights:

    .. math::

        \omega^2_i = \frac{\omega^1_i \sigma_i^{DS}}{\sum\limits_{j=1}^m \omega^1_j \sigma_j^{DS}}, i = 1, \ldots, m,


    minimize the final estimation variance in \eqref{eq:pf_est_sda2_var}.
    Note that some weights might be zero (due to a somewhat arbitrary rounding of
    the conditional probabilities' estimation variance). The quadrants associated
    with a zero-weight will not be sampled in the estimation step.

    Eventually, the estimation step proceeds in essentially the same way as the
    learning step with different weights for the quadrants though.
    \eqref{eq:pf_est_sda2} and \eqref{eq:pf_est_sda2_var} are used for evaluating
    the final probability probability estimate and its variance.

    The computational budget per step is parametrized by a fraction
    :math:`\gamma_l, l = 1,\,2` of the total budget :math:`N`, such that :math:`\gamma_1 + \gamma_2 = 1`.
    The number of directions sampled in quadrant :math:`i` at step :math:`l` is then defined as follows:

    .. math::

        N^l_i = N * \gamma_l * \omega_i.


    The number of evaluation of the limit-state function :math:`g` is of course
    greater than the total budget :math:`N` since directional sampling is used.

    Variants

    The ADS-2+ variant performs a dimension reduction step after the learning step
    for reducing the number of stratified quadrants. The statistic :math:`\tilde T_k`
    aggregates the sensitivity of expectation along dimension :math:`k`.
    It is defined as follows:

    .. math::

        \tilde T_k = \sum\limits_{i_l \in \lbrace -1,1 \rbrace,l \neq k} \lvert \tilde I_{(i_1,\dots,i_{k-1},-1,i_{k+1},\dots,i_p)} - \tilde I_{(i_1,\dots,i_{k-1},1,i_{k+1},\dots,i_p)} \rvert.

    It is used for ranking the contributions of the quadrants.
    Then, only the :math:`d' < d` most influential variables according to
    :math:`\tilde T_k` are stratified, leaving the remaining variables simulated without
    stratification. The corresponding quadrants will not be sampled.

    The DP-ADS-2 variant combines the ADS method with a rotation of the quadrants.
    The idea is to get a possible design point (available e.g. after a
    preliminary FORM analysis) on the bisector of one of the quadrants to make the
    stratification even more efficient and thus save some evaluations of the model.

    This 2-step algorithm can be generalized to :math:`L > 2` steps by adding more
    than one learning step. For now, only ADS-2 is implemented.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.AdaptiveDirectionalStratification_getClassName(self)

    def __repr__(self):
        return _experimental.AdaptiveDirectionalStratification___repr__(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _experimental.AdaptiveDirectionalStratification_getSamplingStrategy(self)

    def setGamma(self, gamma):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Parameters
        ----------
        gamma : sequence of float
            Gamma value.
        """
        return _experimental.AdaptiveDirectionalStratification_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            Gamma value.
        """
        return _experimental.AdaptiveDirectionalStratification_getGamma(self)

    def setQuadrantOrientation(self, quadrantOrientation):
        r"""
        Quadrant orientation accessor.

        Parameters
        ----------
        orientation : sequence of float
            Quadrant orientation.
        """
        return _experimental.AdaptiveDirectionalStratification_setQuadrantOrientation(self, quadrantOrientation)

    def getQuadrantOrientation(self):
        r"""
        Quadrant orientation accessor.

        Returns
        -------
        orientation : :class:`~openturns.Point`
            Quadrant orientation.
        """
        return _experimental.AdaptiveDirectionalStratification_getQuadrantOrientation(self)

    def setPartialStratification(self, partialStratification):
        r"""
        Partial stratification accessor.

        Parameters
        ----------
        partialStratification : bool
            Partial stratification.
        """
        return _experimental.AdaptiveDirectionalStratification_setPartialStratification(self, partialStratification)

    def getPartialStratification(self):
        r"""
        Partial stratification accessor.

        Returns
        -------
        partialStratification : bool
            Partial stratification.
        """
        return _experimental.AdaptiveDirectionalStratification_getPartialStratification(self)

    def setMaximumStratificationDimension(self, maximumStratificationDimension):
        r"""
        Maximum stratification dimension accessor.

        Parameters
        ----------
        max : int
            Maximum stratification dimension.
        """
        return _experimental.AdaptiveDirectionalStratification_setMaximumStratificationDimension(self, maximumStratificationDimension)

    def getMaximumStratificationDimension(self):
        r"""
        Maximum stratification dimension accessor.

        Returns
        -------
        max : int
            Maximum stratification dimension.
        """
        return _experimental.AdaptiveDirectionalStratification_getMaximumStratificationDimension(self)

    def getTStatistic(self):
        r"""
        T statistic accessor.

        The statistic :math:`\tilde T_k` aggregates the sensitivity of expectation.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            T statistic value.
        """
        return _experimental.AdaptiveDirectionalStratification_getTStatistic(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.AdaptiveDirectionalStratification_run(self)

    def __init__(self, *args):
        _experimental.AdaptiveDirectionalStratification_swiginit(self, _experimental.new_AdaptiveDirectionalStratification(*args))
    __swig_destroy__ = _experimental.delete_AdaptiveDirectionalStratification

# Register AdaptiveDirectionalStratification in _experimental:
_experimental.AdaptiveDirectionalStratification_swigregister(AdaptiveDirectionalStratification)
class ExpectationSimulationResult(SimulationResult):
    r"""
    Expectation simulation result.

    Gathers the results of a :class:`~openturns.ExpectationSimulationAlgorithm`
    algorithm.

    See also
    --------
    ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ExpectationSimulationResult_getClassName(self)

    def getRandomVector(self):
        r"""
        Accessor to the random variable.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _experimental.ExpectationSimulationResult_getRandomVector(self)

    def setRandomVector(self, randomVector):
        r"""
        Accessor to the random variable.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _experimental.ExpectationSimulationResult_setRandomVector(self, randomVector)

    def getExpectationEstimate(self):
        r"""
        Accessor to the expectation estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _experimental.ExpectationSimulationResult_getExpectationEstimate(self)

    def setExpectationEstimate(self, expectationEstimate):
        r"""
        Accessor to the expectation estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _experimental.ExpectationSimulationResult_setExpectationEstimate(self, expectationEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _experimental.ExpectationSimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _experimental.ExpectationSimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        coefficientOfVariation : :class:`~openturns.Point`
            Coefficient of variation.
        """
        return _experimental.ExpectationSimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        standardDeviation : :class:`~openturns.Point`
            Standard deviation.
        """
        return _experimental.ExpectationSimulationResult_getStandardDeviation(self)

    def getExpectationDistribution(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Distribution`
            Distribution of the expectation.
        """
        return _experimental.ExpectationSimulationResult_getExpectationDistribution(self)

    def __repr__(self):
        return _experimental.ExpectationSimulationResult___repr__(self)

    def __init__(self, *args):
        _experimental.ExpectationSimulationResult_swiginit(self, _experimental.new_ExpectationSimulationResult(*args))
    __swig_destroy__ = _experimental.delete_ExpectationSimulationResult

# Register ExpectationSimulationResult in _experimental:
_experimental.ExpectationSimulationResult_swigregister(ExpectationSimulationResult)
class ExpectationSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Expectation computation using sampling.

    Incremental Monte Carlo sampling algorithm to estimate the mean :math:`\Expect{\vect{X}}` of a random vector
    :math:`\vect{X}`.

    Parameters
    ----------
    X : :class:`~openturns.RandomVector`
        The random vector to study.

    Notes
    -----
    Let :math:`\vect{X}\in\Rset^{n_X}` be a random vector. 
    This algorithm estimates :math:`\Expect{\vect{X}}` using the smallest possible sample 
    size which satisfies pre-defined stopping rules. 
    It increases the sample size :math:`n` incrementally until a stopping criterion is met. 
    Hence, both the mean and the variance must be finite. 
    For example, consider the Student distribution with :math:`\nu` degrees of freedom. 
    If :math:`\nu=1` (where the expectation is undefined) 
    or :math:`\nu=2` (where the variance is undefined), 
    then the algorithm cannot succeed. 

    The algorithm is based on two nested loops:

    - the outer loop sets the number of iterations of the algorithm; 
      this can be configured using :meth:`setMaximumOuterSampling`,

    - the inner loop sets the number of function calls which can be parallelized; 
      this can be configured using :meth:`setBlockSize`.

    The algorithm allows one to get the best possible performance on distributed
    supercomputers and multi-core workstations. 
    For example, if the block size is equal to 100, then the sample size 
    is successively equal to 100, 200, etc... 
    Each block of evaluation of the outputs can be parallelized, which may improve the performance of the algorithm.
    We suggest to set the block size as a multiple of the number of cores. 

    The algorithm stops either when the maximum number of outer iterations is reached or when the target precision is met. 
    The latter stopping criterion is based on either the coefficient of variation of the 
    sample mean (relative criterion) or the standard deviation of the sample 
    mean (absolute criterion). 

    We consider :math:`\vect{n}` independent realizations :math:`\vect{x}^{(1)}`, 
    ..., :math:`\vect{x}^{(n)}\in\Rset^{n_X}` of the random vector :math:`\vect{X}`. 
    We estimate :math:`\Expect{\vect{X}}` with the sample mean:

    .. math::

        \overline{\vect{x}} = \frac{1}{n} \sum_{j=1}^n \vect{x}^{(j)}.

    We estimate :math:`\Var{X_i}` for :math:`i = 1, \ldots, n_X` 
    with the unbiased sample variance:

    .. math::

        \hat{\sigma}^2_i = \frac{1}{n - 1} \sum_{j=1}^n \left(x^{(j)}_i - \overline{x}_i\right)^2.

    for :math:`i = 1, \ldots, n_X`.

    The expected value of the sample mean is:

    .. math::

        \Expect{\overline{X}_i} = \Expect{X_i}

    and, since the observations are independent, the variance of the sample mean is:

    .. math::

        \Var{\overline{X}_i} = \frac{\Var{X_i}}{n}.

    for :math:`i = 1, \ldots, n_X`, since the observations are independent.

    Moreover, we can estimate the standard deviation of the sample mean with:

    .. math::

        \hat{\sigma}\left(\overline{X}_i\right) = \frac{\hat{\sigma}_i}{\sqrt{n}}

    for :math:`i = 1, \ldots, n_X`.

    If the expectation :math:`\Expect{X_i}` is nonzero, the coefficient of variation of the sample mean is:

    .. math::

        CV\left(\overline{X}_i\right) = \frac{\sqrt{\Var{\overline{X}_i}}}{\left|\Expect{\overline{X}_i}\right|} = \frac{\sqrt{\Var{X_i}}/\sqrt{n}}{\left|\Expect{X_i}\right|}

    for :math:`i = 1, \ldots, n_X`.

    We can estimate it with

    .. math::

        \widehat{CV}\left(\overline{X}_i\right) = \frac{\hat{\sigma}_i/\sqrt{n}}{\left|\overline{x}_i\right|}

    for :math:`i = 1, \ldots, n_X`.

    When the sample size :math:`n` increases, the sample standard deviation and the sample coefficient of variation decrease to zero at the Monte-Carlo rate of :math:`1/\sqrt{n}`. 

    There are 3 mathematical stopping criteria available:

    - through an operator on the componentwise coefficients of variation (by default),
    - through an operator on the componentwise standard deviations,
    - on the maximum standard deviation per component.

    A low coefficient of variation guarantees relative accuracy, while a low standard deviation guarantees absolute accuracy. 

    If the chosen condition is found to be true, the algorithm stops.

    Let :math:`n_X` be the dimension of the random vector :math:`\vect{X}`. 
    Let :math:`\max_{cov}\in\Rset` be the maximum coefficient of variation. 
    The criterion on the componentwise coefficients of variation is defined using either:

    - the maximum (by default):

    .. math::

        \max_{i=1,\ldots,n_X} \frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|} \leq \max_{cov},

    - the norm-1:

    .. math::

        \sum_{i=1}^{n_X} \frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|} \leq \max_{cov},

    - the norm-2:

    .. math::

        \sqrt{\sum_{i=1}^{n_X} \left(\frac{\hat{\sigma}_i / \sqrt{n}}{|\overline{x}_i|}\right)^2} \leq \max_{cov},

    - or disabled.

    The type of operator on the coefficient of variation is set using :meth:`setCoefficientOfVariationCriterionType`.

    The default type is set by the `ExpectationSimulationAlgorithm-DefaultCoefficientOfVariationCriterionType` key of the :class:`~openturns.ResourceMap`.

    The threshold :math:`\max_{cov}` can be set using :meth:`setMaximumCoefficientOfVariation`.

    Let :math:`\max_{\sigma}\in\Rset` be the maximum value of the standard deviation. 
    The criterion on the componentwise standard deviations is defined using either:

    - the maximum (by default): 

    .. math::

        \max_{i=1,\ldots,n_X} \hat{\sigma}_i / \sqrt{n} \leq \max_{\sigma},

    - the norm-1: 

    .. math::

        \sum_{i=1}^{n_X} \left|\hat{\sigma}_i / \sqrt{n}\right| \leq \max_{\sigma},

    - the norm-2: 

    .. math::

        \sqrt{\sum_{i=1}^{n_X} \left(\hat{\sigma}_i / \sqrt{n} \right)^2} \leq \max_{\sigma},

    - or disabled. 

    The type of operator on the coefficient of variation can be set using :meth:`setStandardDeviationCriterionType`.

    The default type is set by the `ExpectationSimulationAlgorithm-DefaultStandardDeviationCriterionType` key of the :class:`~openturns.ResourceMap`.

    The threshold :math:`\max_{\sigma}` can be set using :meth:`setMaximumStandardDeviation`.

    Let :math:`\max_{\sigma_1}, \ldots, \max_{\sigma_{n_X}}` be the 
    componentwise maximum standard deviations. 
    The criterion on the maximum deviation per component is defined by:

    .. math::

        \sigma_i \leq \max_{\sigma_i}

    for :math:`i = 1, \ldots, n_X`.

    The threshold vector :math:`\max_{\sigma_i}` can be set using :meth:`setMaximumStandardDeviationPerComponent`.

    By default this criterion is disabled.

    The default values of the parameters are based on the 
    following keys of the :class:`~openturns.ResourceMap`:

    - `SimulationAlgorithm-DefaultMaximumOuterSampling`,
    - `SimulationAlgorithm-DefaultMaximumCoefficientOfVariation`,
    - `SimulationAlgorithm-DefaultMaximumStandardDeviation`.

    In general, criteria based on coefficients of variation (C.O.V.) should be used because
    they guarantee a relative accuracy on the estimate of the mean.
    However, we may happen to estimate an expected value equal to zero
    (perhaps for teaching or research purposes).
    The default value of `SimulationAlgorithm-DefaultMaximumStandardDeviation` is
    :math:`0`, which means that standard deviation-based criteria are disabled by default
    (in order to let C.O.V.-based criteria be used by default).
    If the expected value of :math:`\vect{X}` is zero,
    the algorithm is likely to reach the maximum number of outer iterations.
    If this happens, please configure the maximum standard deviation
    in order to match the scale of the random variable at hand.

    See also
    --------
    ExpectationSimulationResult, SimulationAlgorithm

    Examples
    --------

    In the following example, we perform at most :math:`8 \times 10000 = 80000` evaluations 
    of the model. 
    However, the algorithm may stop earlier if the coefficient of variation 
    of the sample mean falls below the threshold. 

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Create a composite random vector
    >>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0] * 4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(distribution)
    >>> X = ot.CompositeRandomVector(model, vect)
    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(10000)
    >>> algo.setBlockSize(8)  # The number of cores we usually have.
    >>> algo.setMaximumCoefficientOfVariation(0.01)  # 1% C.O.V.
    >>> algo.run()
    >>> result = algo.getResult()
    >>> expectation = result.getExpectationEstimate()
    >>> print(expectation)
    [-1.41067]

    The following statement retrieves the asymptotically Gaussian distribution 
    of the sample mean. 
    This may be useful for users who want to compute a confidence interval of 
    the sample mean. 

    >>> expectationDistribution = result.getExpectationDistribution()

    The following code prints the outer sample (i.e. the number of outer iterations 
    of the algorithm) and the sample size. 
    We see that the algorithm stops based on the accuracy criterion. 

    >>> outer_sampling = result.getOuterSampling()
    >>> print('outer_sampling=', outer_sampling)
    outer_sampling= 1662
    >>> block_size = result.getBlockSize()
    >>> sample_size = outer_sampling * block_size
    >>> print('sample_size=', sample_size)
    sample_size= 13296

    In the following example, we disable the coefficient of variation criterion. 
    Therefore, the only remaining criterion is based on the number of iterations. 

    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(1000)
    >>> algo.setBlockSize(1)
    >>> algo.setCoefficientOfVariationCriterionType('NONE')
    >>> algo.run()
    >>> result = algo.getResult()
    >>> outer_sampling = result.getOuterSampling()
    >>> print('outer_sampling=', outer_sampling)
    outer_sampling= 1000

    In the following example, we compute the mean of a dimension 4 random vector. 
    We use a standard deviation-based stopping criterion with a different threshold for every component. 
    We must disable the coefficient of variation-based stopping criterion, otherwise,
    in this example, it will trigger first.
    The comparison with the exact mean is satisfactory, given the relatively 
    small sample size.

    >>> from openturns.usecases import cantilever_beam
    >>> cb = cantilever_beam.CantileverBeam()
    >>> sigma = cb.distribution.getStandardDeviation()
    >>> print('sigma=', sigma)
    sigma= [1.73582e+09,30,0.0288675,7.10585e-09]
    >>> componentwise_max_sigma = sigma / 32.0
    >>> print('componentwise_max_sigma=', componentwise_max_sigma)
    componentwise_max_sigma= [5.42445e+07,0.9375,0.00090211,2.22058e-10]
    >>> X = ot.RandomVector(cb.distribution)
    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(1000)
    >>> algo.setBlockSize(8)
    >>> algo.setCoefficientOfVariationCriterionType('NONE')
    >>> algo.setMaximumStandardDeviationPerComponent(componentwise_max_sigma)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> expectation = result.getExpectationEstimate()
    >>> print(expectation)
    [6.7125e+10,298.637,2.55074,1.45427e-07]
    >>> print(cb.distribution.getMean())
    [6.70455e+10,300,2.55,1.45385e-07]
    >>> outer_sampling = result.getOuterSampling()
    >>> print('outer_sampling=', outer_sampling)
    outer_sampling= 126
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.ExpectationSimulationAlgorithm_getClassName(self)

    def getRandomVector(self):
        r"""
        Accessor to the random vector.

        Returns
        -------
        X : :class:`~openturns.RandomVector`
            Random vector we want to study.
        """
        return _experimental.ExpectationSimulationAlgorithm_getRandomVector(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.ExpectationSimulationResult`
            The simulation result.
        """
        return _experimental.ExpectationSimulationAlgorithm_getResult(self)

    def setCoefficientOfVariationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2.
        """
        return _experimental.ExpectationSimulationAlgorithm_setCoefficientOfVariationCriterionType(self, criterionType)

    def getCoefficientOfVariationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _experimental.ExpectationSimulationAlgorithm_getCoefficientOfVariationCriterionType(self)

    def setStandardDeviationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2
        """
        return _experimental.ExpectationSimulationAlgorithm_setStandardDeviationCriterionType(self, criterionType)

    def getStandardDeviationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _experimental.ExpectationSimulationAlgorithm_getStandardDeviationCriterionType(self)

    def setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.

            If empty, the stopping criterion is not applied.
        """
        return _experimental.ExpectationSimulationAlgorithm_setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation)

    def getMaximumStandardDeviationPerComponent(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.
        """
        return _experimental.ExpectationSimulationAlgorithm_getMaximumStandardDeviationPerComponent(self)

    def __repr__(self):
        return _experimental.ExpectationSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.ExpectationSimulationAlgorithm_run(self)

    def drawExpectationConvergence(self, *args):
        r"""
        Draw the expectation convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _experimental.ExpectationSimulationAlgorithm_drawExpectationConvergence(self, *args)

    def __init__(self, *args):
        _experimental.ExpectationSimulationAlgorithm_swiginit(self, _experimental.new_ExpectationSimulationAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_ExpectationSimulationAlgorithm

# Register ExpectationSimulationAlgorithm in _experimental:
_experimental.ExpectationSimulationAlgorithm_swigregister(ExpectationSimulationAlgorithm)
class SobolSimulationResult(SimulationResult):
    r"""
    Sobol simulation result.

    Gathers the results of a :class:`~openturns.SobolSimulationAlgorithm`
    algorithm.

    Parameters
    ----------
    fo_dist : :class:`~openturns.Distribution`
        The random vector to study.
    to_dist : :class:`~openturns.Distribution`
        The function to study.
    outer_sampling : int
        The number of iterations.
    block_size : int
        The batch size.

    See also
    --------
    SobolSimulationAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> fo_dist = ot.Normal([0.154081,0.872087,0.0122877,0.0433801], [0.00982468,0.0302524,0.00911937,0.00926643], ot.CorrelationMatrix(4))
    >>> to_dist = ot.Normal([0.16743,0.795477,0.0124454,0.045178], [0.0068919,0.00950876,0.00204324,0.0038844], ot.CorrelationMatrix(4))
    >>> result = ot.SobolSimulationResult(fo_dist, to_dist, 250, 100)
    >>> fo = result.getFirstOrderIndicesEstimate()
    >>> to = result.getTotalOrderIndicesEstimate()
    >>> fo_dist = result.getFirstOrderIndicesDistribution()
    >>> to_dist = result.getTotalOrderIndicesDistribution()
    >>> graph = result.draw()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolSimulationResult_getClassName(self)

    def getFirstOrderIndicesEstimate(self):
        r"""
        Accessor to the first order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the first order indices.
        """
        return _experimental.SobolSimulationResult_getFirstOrderIndicesEstimate(self)

    def getTotalOrderIndicesEstimate(self):
        r"""
        Accessor to the total order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the total order indices.
        """
        return _experimental.SobolSimulationResult_getTotalOrderIndicesEstimate(self)

    def setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution):
        r"""
        Accessor to the first order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _experimental.SobolSimulationResult_setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution)

    def setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution):
        r"""
        Accessor to the total order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _experimental.SobolSimulationResult_setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Accessor to the first order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _experimental.SobolSimulationResult_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Accessor to the total order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _experimental.SobolSimulationResult_getTotalOrderIndicesDistribution(self)

    def __repr__(self):
        return _experimental.SobolSimulationResult___repr__(self)

    def draw(self, confidenceLevel=0.95):
        r"""
        Draw sensitivity indices.

        Parameters
        ----------
        confidence_level : float, default=0.95
            Confidence level for intervals

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.
        """
        return _experimental.SobolSimulationResult_draw(self, confidenceLevel)

    def __init__(self, *args):
        _experimental.SobolSimulationResult_swiginit(self, _experimental.new_SobolSimulationResult(*args))
    __swig_destroy__ = _experimental.delete_SobolSimulationResult

# Register SobolSimulationResult in _experimental:
_experimental.SobolSimulationResult_swigregister(SobolSimulationResult)
class SobolSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Sobol indices computation using iterative sampling.

    The algorithm uses sampling of the distribution of the random vector :math:`\vect{X}` through the model :math:`f`
    to iteratively estimate the Sobol indices.

    At each iteration a fixed number :math:`N = blockSize * (d + 2)` of replications inputs is generated.
    These inputs are evaluated by blocks of size :math:`batchSize` through the model :math:`f`.
    Then the distribution of the indices (first and total order) is computed on this current replication sample.
    At the end of each iteration we update the global distribution of the indices.

    Parameters
    ----------
    X : :class:`~openturns.Distribution`
        The random vector to study.
    f : :class:`~openturns.Function`
        The function to study.
    estimator : :class:`~openturns.SobolIndicesAlgorithm`
        The estimator of the indices.

    Notes
    -----
    The algorithm can operate on a multivariate model :math:`f`, in this case it operates on aggregated indices.

    Several estimators are available (Saltelli, Jansen, ...).

    Let us denote by :math:`n_X` the number of input variables. 
    For any :math:`j = 1, \ldots, n_X`, let us denote by :math:`\Phi_j^F` (resp. :math:`\Phi_j^T`) the cumulative distribution 
    function of the gaussian asymptotic distribution of the estimator 
    of the Sobol' first (resp. total) order indice.
    Let :math:`\alpha\in[0,1]` be the level of the confidence interval and :math:`\epsilon\in(0,1]` the 
    length of this confidence interval. 
    The algorithms stops when, on all components, first and total order indices haved been 
    estimated with enough precision.

    The precision is said to be sufficient if the length of the :math:`\alpha`-level confidence interval 
    is smaller than :math:`\epsilon`:

    .. math::

        (\Phi_j^F)^{-1}(1-\alpha/2) - (\Phi_j^F)^{-1}(\alpha/2) \leq \epsilon \textrm{ and } 
        (\Phi_j^T)^{-1}(1-\alpha/2) - (\Phi_j^T)^{-1}(\alpha/2) \leq \epsilon

    for all :math:`j = 1, \ldots, n_X`.

    See also
    --------
    SobolSimulationResult

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> model = ot.SymbolicFunction(['x1', 'x2', 'x3'], ['x1*x2+x3'])
    >>> estimator = ot.SaltelliSensitivityAlgorithm()
    >>> estimator.setUseAsymptoticDistribution(True)
    >>> algo = ot.SobolSimulationAlgorithm(distribution, model, estimator)
    >>> algo.setMaximumOuterSampling(25) # number of iterations
    >>> algo.setBlockSize(100) # size of Sobol experiment at each iteration
    >>> algo.setBatchSize(4) # number of points evaluated simultaneously
    >>> algo.setIndexQuantileLevel(0.05) # alpha
    >>> algo.setIndexQuantileEpsilon(1e-2) # epsilon
    >>> algo.run()
    >>> result = algo.getResult()
    >>> fo = result.getFirstOrderIndicesEstimate()
    >>> foDist = result.getFirstOrderIndicesDistribution()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SobolSimulationAlgorithm_getClassName(self)

    def getDistribution(self):
        r"""
        Accessor to the batch size.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the random variable.
        """
        return _experimental.SobolSimulationAlgorithm_getDistribution(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.SobolSimulationResult`
            The simulation result.
        """
        return _experimental.SobolSimulationAlgorithm_getResult(self)

    def setIndexQuantileLevel(self, indexQuantileLevel):
        r"""
        Accessor to the quantile level.

        Parameters
        ----------
        alpha : float
            The quantile level.
        """
        return _experimental.SobolSimulationAlgorithm_setIndexQuantileLevel(self, indexQuantileLevel)

    def getIndexQuantileLevel(self):
        r"""
        Accessor to the quantile level.

        Returns
        -------
        alpha : float
            The quantile level.
        """
        return _experimental.SobolSimulationAlgorithm_getIndexQuantileLevel(self)

    def setIndexQuantileEpsilon(self, indexQuantileEpsilon):
        r"""
        Accessor to the quantile tolerance.

        Parameters
        ----------
        epsilon : float
            The quantile tolerance
        """
        return _experimental.SobolSimulationAlgorithm_setIndexQuantileEpsilon(self, indexQuantileEpsilon)

    def getIndexQuantileEpsilon(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        epsilon : float
            The quantile tolerance
        """
        return _experimental.SobolSimulationAlgorithm_getIndexQuantileEpsilon(self)

    def setEstimator(self, estimator):
        r"""
        Sobol estimator accessor.

        Parameters
        ----------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _experimental.SobolSimulationAlgorithm_setEstimator(self, estimator)

    def getEstimator(self):
        r"""
        Sobol estimator accessor.

        Returns
        -------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _experimental.SobolSimulationAlgorithm_getEstimator(self)

    def setBatchSize(self, replicationSize):
        r"""
        Accessor to the batch size.

        Parameters
        ----------
        batchSize : int
            Number of points evaluated simultaneously.
        """
        return _experimental.SobolSimulationAlgorithm_setBatchSize(self, replicationSize)

    def getBatchSize(self):
        r"""
        Accessor to the batch size.

        Returns
        -------
        batchSize : int
            Number of points evaluated simultaneously.
        """
        return _experimental.SobolSimulationAlgorithm_getBatchSize(self)

    def __repr__(self):
        return _experimental.SobolSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.SobolSimulationAlgorithm_run(self)

    def drawFirstOrderIndexConvergence(self, *args):
        r"""
        Draw the first order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _experimental.SobolSimulationAlgorithm_drawFirstOrderIndexConvergence(self, *args)

    def drawTotalOrderIndexConvergence(self, *args):
        r"""
        Draw the total order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _experimental.SobolSimulationAlgorithm_drawTotalOrderIndexConvergence(self, *args)

    def __init__(self, *args):
        _experimental.SobolSimulationAlgorithm_swiginit(self, _experimental.new_SobolSimulationAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_SobolSimulationAlgorithm

# Register SobolSimulationAlgorithm in _experimental:
_experimental.SobolSimulationAlgorithm_swigregister(SobolSimulationAlgorithm)
class NAISResult(ProbabilitySimulationResult):
    r"""
    NAIS result.

    See also
    --------
    NAIS, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.NAISResult_getClassName(self)

    def getAuxiliaryInputSample(self):
        r"""
        Accessor of the auxiliary distribution input sample at the final NAIS step.

        Returns
        -------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final NAIS step.
        """
        return _experimental.NAISResult_getAuxiliaryInputSample(self)

    def setAuxiliaryInputSample(self, auxiliaryInputSample):
        r"""
        Accessor of the auxiliary distribution input sample at the final NAIS step.

        Parameters
        ----------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final NAIS step.
        """
        return _experimental.NAISResult_setAuxiliaryInputSample(self, auxiliaryInputSample)

    def getWeights(self):
        r"""
        Auxiliary distribution input sample associated weights accessor of the final NAIS step.

        Returns
        -------
        weights : :class:`~openturns.Point`
            Auxiliary distribution input sample associated weights.
        """
        return _experimental.NAISResult_getWeights(self)

    def setWeights(self, weights):
        r"""
        Auxiliary distribution input sample associated weights accessor of the final NAIS step.

        Parameters
        ----------
        weights : :class:`~openturns.Point`
            Auxiliary distribution input sample associated weights.
        """
        return _experimental.NAISResult_setWeights(self, weights)

    def getAuxiliaryOutputSample(self):
        r"""
        Accessor of the auxiliary distribution output sample at the final NAIS step.

        Returns
        -------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final NAIS step.
        """
        return _experimental.NAISResult_getAuxiliaryOutputSample(self)

    def setAuxiliaryOutputSample(self, auxiliaryInputSample):
        r"""
        Accessor of the auxiliary distribution output sample at the final NAIS step.

        Parameters
        ----------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final NAIS step.
        """
        return _experimental.NAISResult_setAuxiliaryOutputSample(self, auxiliaryInputSample)

    def getAuxiliaryDistribution(self):
        r"""
        Accessor of the auxiliary distribution at the final NAIS step.

        Returns
        -------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final NAIS step.
        """
        return _experimental.NAISResult_getAuxiliaryDistribution(self)

    def setAuxiliaryDistribution(self, auxiliaryDistribution):
        r"""
        Accessor of the auxiliary distribution at the final NAIS step.

        Parameters
        ----------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final NAIS step.
        """
        return _experimental.NAISResult_setAuxiliaryDistribution(self, auxiliaryDistribution)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.NAISResult_getCoefficientOfVariation(self)

    def __init__(self, *args):
        _experimental.NAISResult_swiginit(self, _experimental.new_NAISResult(*args))
    __swig_destroy__ = _experimental.delete_NAISResult

# Register NAISResult in _experimental:
_experimental.NAISResult_swigregister(NAISResult)
class NAIS(EventSimulation):
    r"""
    Nonparametric Adaptive Importance Sampling (NAIS) algorithm.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level.

    Notes
    -----
    The following explanations are given for a failure event defined as :math:`g(\mathbf{X})<T` with :math:`\mathbf{X}` 
    a random vector following a joint PDF :math:`f_\mathbf{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\mathbf{1}}_{g(\mathbf{x}_i)<T} \frac{h_0(\mathbf{x}_i)}{h(\mathbf{x}_i)},

    with :math:`h_0 = f_\mathbf{X}` the PDF of :math:`\mathbf{X}`, :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\mathbf{1}}_{g(\mathbf{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density minimizing the variance of the estimator :math:`h_{opt}` is defined as:

    .. math::

        h_{opt}=\frac{{\mathbf{1}}_{g(x)<T}h_0}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest
    and unknown. 

    The objective of Non parametric Adaptive Importance Sampling (NAIS) [morio2015]_ is to approximate 
    the IS optimal auxiliary density :math:`h_{opt}` from the preceding equation 
    with a kernel density function (e.g. Gaussian kernel). 
    Its iterative principle is described by the following steps.

    1. :math:`k=1` and set the quantile level :math:`\rho \in [0,1]`

    2. Generate the population :math:`\mathbf{x}_1^{(k)},...,\mathbf{x}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`g` in order to have :math:`y_1^{(k)}=g(\mathbf{x}_1^{(k)}),...,y_N^{(k)} = g(\mathbf{x}_N^{(k)})`

    3. Compute the empirical quantile of level :math:`\rho` :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})`

    4. Estimate :math:`I_k= \frac{1}{kN} \displaystyle \sum_{j=1}^{k}\sum_{i=1}^{N} {\mathbf{1}}_{g(\mathbf{x}_i^{(j)}) \leq q_k} \frac{h_0(\mathbf{x}_i^{(j)})}{h_{j-1}(\mathbf{x}_i^{(j)})}` 

    5. Update the Gaussian kernel sampling PDF with:

       .. math::

           h_{k}(\mathbf{x})=\frac{1}{k N I_k \det\left(B_{k+1}\right)}\sum_{j=1}^{k}\sum_{i=1}^{N}  w_{j}(\mathbf{x}_i^{(j)})K_d\left(B_{k+1}^{-1}\left(\mathbf{x}-\mathbf{x}_i^{(j)}\right)\right)

       where :math:`K_d` is the PDF of the standard :math:`d`-dimensional normal distribution,
       :math:`B_{k+1}=\text{diag}(b^1_{k+1},...,b^d_{k+1})` 
       and :math:`w_j={\mathbf{1}}_{g(\mathbf{x}_i^{(j)}) \leq q_k} \frac{h_0(\mathbf{x}_i^{(j)})}{h_{j-1}(\mathbf{x}_i^{(j)})}`. 
       The coefficients of the matrix :math:`B_{k+1}` can be approximated (Silverman Rule) or postulated according to the AMISE 
       (Asymptotic Mean Integrated Square Error) criterion for example.

    6. If :math:`q_k>T`, :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{NAIS}(g(\mathbf{\mathbf{X}}<T))=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \mathbf{1}_{g(\mathbf{x}_i^{(k)})<T} \frac{h_0(\mathbf{x}_i^{(k)})}{h_{k-1}(\mathbf{x}_i^{(k)})}`

    The NAIS algorithm with the Silverman rule is implemented in the current NAIS class.

    See also
    --------
    SubsetSampling

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # We create the function defining the limit state
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> # We define a joint PDF of interest 
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an event from this RandomVector
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -10.0)
    >>> # We create a NAIS algorithm
    >>> algo = ot.NAIS(myEvent, 0.1)
    >>> # Perform the simulation
    >>> algo.run()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.NAIS_getClassName(self)

    def getQuantileLevel(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        quantileLevel : float
            Intermediate quantile level.
        """
        return _experimental.NAIS_getQuantileLevel(self)

    def setQuantileLevel(self, quantileLevel):
        r"""
        Accessor to the intermediate quantile level.

        Parameters
        ----------
        quantileLevel : float  :math:`0<quantileLevel<1`
            Intermediate quantile level.
        """
        return _experimental.NAIS_setQuantileLevel(self, quantileLevel)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.NAIS_run(self)

    def getResult(self):
        r"""
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _experimental.NAIS_getResult(self)

    def __init__(self, *args):
        _experimental.NAIS_swiginit(self, _experimental.new_NAIS(*args))
    __swig_destroy__ = _experimental.delete_NAIS

# Register NAIS in _experimental:
_experimental.NAIS_swigregister(NAIS)
class _RootStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_experimental._RootStrategyImplementationPointer_ptr__get, _experimental._RootStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _experimental._RootStrategyImplementationPointer_swiginit(self, _experimental.new__RootStrategyImplementationPointer(*args))
    __swig_destroy__ = _experimental.delete__RootStrategyImplementationPointer

    def reset(self):
        return _experimental._RootStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _experimental._RootStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _experimental._RootStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _experimental._RootStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _experimental._RootStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _experimental._RootStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _experimental._RootStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _experimental._RootStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _experimental._RootStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _experimental._RootStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental._RootStrategyImplementationPointer_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _experimental._RootStrategyImplementationPointer_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental._RootStrategyImplementationPointer_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _experimental._RootStrategyImplementationPointer_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _experimental._RootStrategyImplementationPointer_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental._RootStrategyImplementationPointer_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _experimental._RootStrategyImplementationPointer_getOriginValue(self)

    def __repr__(self):
        return _experimental._RootStrategyImplementationPointer___repr__(self)

    def __eq__(self, other):
        return _experimental._RootStrategyImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _experimental._RootStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _experimental._RootStrategyImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _experimental._RootStrategyImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _experimental._RootStrategyImplementationPointer__repr_html_(self)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _experimental._RootStrategyImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _experimental._RootStrategyImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _experimental._RootStrategyImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _experimental._RootStrategyImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _experimental._RootStrategyImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _experimental._RootStrategyImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _experimental._RootStrategyImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._RootStrategyImplementationPointer_setName(self, name)

# Register _RootStrategyImplementationPointer in _experimental:
_experimental._RootStrategyImplementationPointer_swigregister(_RootStrategyImplementationPointer)
class _SamplingStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_experimental._SamplingStrategyImplementationPointer_ptr__get, _experimental._SamplingStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _experimental._SamplingStrategyImplementationPointer_swiginit(self, _experimental.new__SamplingStrategyImplementationPointer(*args))
    __swig_destroy__ = _experimental.delete__SamplingStrategyImplementationPointer

    def reset(self):
        return _experimental._SamplingStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _experimental._SamplingStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _experimental._SamplingStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _experimental._SamplingStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _experimental._SamplingStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _experimental._SamplingStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _experimental._SamplingStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _experimental._SamplingStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _experimental._SamplingStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _experimental._SamplingStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental._SamplingStrategyImplementationPointer_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _experimental._SamplingStrategyImplementationPointer_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _experimental._SamplingStrategyImplementationPointer_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental._SamplingStrategyImplementationPointer_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _experimental._SamplingStrategyImplementationPointer_getDimension(self)

    def __repr__(self):
        return _experimental._SamplingStrategyImplementationPointer___repr__(self)

    def __eq__(self, other):
        return _experimental._SamplingStrategyImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _experimental._SamplingStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _experimental._SamplingStrategyImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _experimental._SamplingStrategyImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _experimental._SamplingStrategyImplementationPointer__repr_html_(self)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _experimental._SamplingStrategyImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _experimental._SamplingStrategyImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _experimental._SamplingStrategyImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _experimental._SamplingStrategyImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _experimental._SamplingStrategyImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _experimental._SamplingStrategyImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _experimental._SamplingStrategyImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experimental._SamplingStrategyImplementationPointer_setName(self, name)

# Register _SamplingStrategyImplementationPointer in _experimental:
_experimental._SamplingStrategyImplementationPointer_swigregister(_SamplingStrategyImplementationPointer)
class SimplicialCubature(openturns.common.PersistentObject):
    r"""
    Integration over a simplex.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Notes
    -----
    This is a reimplementation of the method described in [genz2003]_.
    The original matlab file can be found at https://www.math.wsu.edu/faculty/genz/software/software.html.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> vertices = [[0.0, 0.0], [1.0, 0.0], [0.0, 1.0]]
    >>> simplicies = [[0, 1, 2]]
    >>> mesh = ot.Mesh(vertices, simplicies)
    >>> algo = otexp.SimplicialCubature()
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['exp(x1 + x2)'])
    >>> value = algo.integrate(f, mesh)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SimplicialCubature_getClassName(self)

    def integrate(self, function, mesh):
        r"""
        Evaluation of the integral of :math:`f` on an interval.

        Parameters
        ----------
        f : :class:`~openturns.Function`, :math:`f: \Rset^d \mapsto \Rset^p`
            The integrand function.
        mesh : :class:`~openturns.Mesh`
            The domain on which to integrate.

        Returns
        -------
        value : :class:`~openturns.Point`
            Approximation of the integral.


        Examples
        --------
        >>> import openturns as ot
        >>> import openturns.experimental as otexp
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [0.0, 1.0]]
        >>> simplicies = [[0, 1, 2]]
        >>> mesh = ot.Mesh(vertices, simplicies)
        >>> algo = otexp.SimplicialCubature()
        >>> f = ot.SymbolicFunction(['x1', 'x2'], ['exp(x1 + x2)'])
        >>> value = algo.integrate(f, mesh)
        """
        return _experimental.SimplicialCubature_integrate(self, function, mesh)

    def setRule(self, rule):
        r"""
        Integration rule accessor.

        Parameters
        ----------
        rule : int in [1, 4]
            The integration rule.
        """
        return _experimental.SimplicialCubature_setRule(self, rule)

    def getRule(self):
        r"""
        Integration rule accessor.

        Returns
        -------
        rule : int in [1, 4]
            The integration rule.
        """
        return _experimental.SimplicialCubature_getRule(self)

    def setMaximumAbsoluteError(self, maximumAbsoluteError):
        r"""
        Maximum absolute error accessor.

        Parameters
        ----------
        maxAbsError : float
            The maximum absolute error.
        """
        return _experimental.SimplicialCubature_setMaximumAbsoluteError(self, maximumAbsoluteError)

    def getMaximumAbsoluteError(self):
        r"""
        Maximum absolute error accessor.

        Returns
        -------
        maxAbsError : float
            The maximum absolute error.
        """
        return _experimental.SimplicialCubature_getMaximumAbsoluteError(self)

    def setMaximumRelativeError(self, maximumRelativeError):
        r"""
        Maximum relative error accessor.

        Parameters
        ----------
        maxRelError : float
            The maximum relative error.
        """
        return _experimental.SimplicialCubature_setMaximumRelativeError(self, maximumRelativeError)

    def getMaximumRelativeError(self):
        r"""
        Maximum relative error accessor.

        Returns
        -------
        maxRelError : float
            The maximum relative error.
        """
        return _experimental.SimplicialCubature_getMaximumRelativeError(self)

    def setMaximumEvaluationNumber(self, maximumEvaluationNumber):
        r"""
        Maximum evaluation number accessor.

        Parameters
        ----------
        maxEval : int
            The maximum function evaluation number.
        """
        return _experimental.SimplicialCubature_setMaximumEvaluationNumber(self, maximumEvaluationNumber)

    def getMaximumEvaluationNumber(self):
        r"""
        Maximum evaluation number accessor.

        Returns
        -------
        maxEval : int
            The maximum function evaluation number.
        """
        return _experimental.SimplicialCubature_getMaximumEvaluationNumber(self)

    def __repr__(self):
        return _experimental.SimplicialCubature___repr__(self)

    def __str__(self, *args):
        return _experimental.SimplicialCubature___str__(self, *args)

    def __init__(self, *args):
        _experimental.SimplicialCubature_swiginit(self, _experimental.new_SimplicialCubature(*args))
    __swig_destroy__ = _experimental.delete_SimplicialCubature

# Register SimplicialCubature in _experimental:
_experimental.SimplicialCubature_swigregister(SimplicialCubature)
class UserDefinedMetropolisHastings(openturns.bayesian.MetropolisHastingsImplementation):
    r"""
    User-defined Metropolis-Hastings method.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Available constructor:
        UserDefinedMetropolisHastings(*targetDistribution, initialState, proposal, linkFunction, marginalIndices*)

        UserDefinedMetropolisHastings(*targetLogPDF, support, initialState, proposal, linkFunction, marginalIndices*)

    Parameters
    ----------
    targetDistribution : :class:`~openturns.Distribution`
        Target distribution sampled
    targetLogPDF : :class:`~openturns.Function`
        Target log-density up to an additive constant
    support : :class:`~openturns.Domain`
        Support of the target when defined with *targetLogPDF*
    initialState : sequence of float
        Initial state of the chain
    proposal : :class:`~openturns.Distribution`
        Proposal distribution, its parameters depend on the state of the chain.
    linkFunction : :class:`~openturns.Function`
        Link between the state of the chain and the parameters of *proposal*.
    marginalIndices : sequence of int, optional
        Indices of the components to be updated.
        If not specified, all components are updated.
        The number of updated components must be equal to the dimension of *proposal*.

    Notes
    -----

    Using the notations from :ref:`metropolis_hastings` page,
    this class allows one to completely specify the transition kernel :math:`Q`.
    This is done by specifying:

    - a :class:`~openturns.Distribution` :math:`\Pi` (called *proposal* below) which admits :math:`p` parameters,
    - a :class:`~openturns.Function` :math:`g: \Omega \rightarrow \Rset^p` (called *linkFunction* below).

    If :math:`\vect{\lambda} \in \Rset^p` is a set of parameters for :math:`\Pi` (i.e. a :class:`~openturns.Point`
    that could be provided to the :meth:`~openturns.Distribution.setParameter` method of :math:`\Pi`),
    then let us denote by :math:`\Pi_{\vect{\lambda}}` the distribution :math:`\Pi` with parameter :math:`\vect{\lambda}`.

    The transition kernel :math:`Q` is then defined by

    .. math::
        \forall \vect{x} \in \Omega \quad Q(\vect{x}, \cdot) = \Pi_{g(\vect{x})}.

    This class therefore applies the Metropolis-Hastings algorithm this way:

    Let :math:`t` be the density up to a multiplicative constant of the target probability distribution
    (specified by *targetDistribution* or *targetLogPDF* and possibly penalized by a likelihood function
    in a Bayesian setting - see :meth:`setLikelihood`).
    For all :math:`\vect{x} \in \Omega`, let :math:`\pi_{g(\vect{x})}` denote the PDF of the distribution :math:`\Pi_{g(\vect{x})}`.
    With an *initialState* :math:`\vect{x}_0`, the steps of the Metropolis-Hastings algorithm are the following.

    For :math:`k=1,2,...`:

    1. Sample a realization :math:`\tilde{\vect{x}}` from the distribution :math:`\Pi_{g(\vect{x}_{k-1})}`.
    2. Compute the ratio:

    .. math::
        \rho_k := \frac{t(\tilde{\vect{x}}) / \pi_{g(\vect{x}_{k-1})}(\tilde{\vect{x}})}{t(\vect{x}_{k-1}) / \pi_{g(\tilde{\vect{x}})}(\vect{x}_{k-1}) }.

    3. Sample a realization :math:`u_k \sim \cU([0,1])`. If :math:`u_k \leq \rho_k`, then :math:`\vect{x}_k := \tilde{\vect{x}}`, otherwise :math:`\vect{x}_k := \vect{x}_{k-1}`.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> import math as m
    >>> ot.RandomGenerator.SetSeed(0)

    Sample from a target distribution defined through its log-PDF (defined up to some additive constant) and its support:

    >>> log_density = ot.SymbolicFunction('x', 'log(2 + sin(x)^2)')
    >>> support = ot.Interval([0.0], [2.0 * m.pi])

    Apply a *Metropolis adjusted Langevin algorithm* (MALA) [robert2015]_ (page 10).
    The idea is to use a normal proposal distribution,
    whose mean will depend on the state of the chain
    (but will not be equal to that state, otherwise the algorithm
    would be easier to implement with the :class:`~openturns.RandomWalkMetropolisHastings` class).

    >>> initialState = [3.0]
    >>> proposal = ot.Normal()
    >>> h = 0.1
    >>> std_deviation = m.sqrt(h)

    The mean of the proposal normal distribution is the current state,
    but moved according to the derivative of the target log-density.

    >>> def python_link(x):
    ...     derivative_log_density = log_density.getGradient().gradient(x)[0, 0]
    ...     mean = x[0] + h / 2 * derivative_log_density
    ...     return [mean, std_deviation]
    >>> link = ot.PythonFunction(1, 2, python_link)
    >>> mala = otexp.UserDefinedMetropolisHastings(log_density, support, initialState, proposal, link)
    >>> x = mala.getSample(10)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.UserDefinedMetropolisHastings_getClassName(self)

    def __repr__(self):
        return _experimental.UserDefinedMetropolisHastings___repr__(self)

    def getProposal(self):
        r"""
        Get the proposal distribution.

        Returns
        -------
        proposal : :class:`~openturns.Distribution`
            The distribution from which the transition kernels of the
            Metropolis-Hastings algorithm is defined.
        """
        return _experimental.UserDefinedMetropolisHastings_getProposal(self)

    def getProposalLinkFunction(self):
        r"""
        Get the proposal link function.

        Returns
        -------
        proposalLinkFunction : :class:`~openturns.Function`
            The function which takes the state of the chain as input
            and outputs the parameters of the proposal distribution.
            Used to condition the proposal distribution on the state of the chain.
        """
        return _experimental.UserDefinedMetropolisHastings_getProposalLinkFunction(self)

    def __init__(self, *args):
        _experimental.UserDefinedMetropolisHastings_swiginit(self, _experimental.new_UserDefinedMetropolisHastings(*args))
    __swig_destroy__ = _experimental.delete_UserDefinedMetropolisHastings

# Register UserDefinedMetropolisHastings in _experimental:
_experimental.UserDefinedMetropolisHastings_swigregister(UserDefinedMetropolisHastings)
class _IndicesCollection2(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _experimental.delete__IndicesCollection2

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _experimental._IndicesCollection2_clear(self)

    def __len__(self):
        return _experimental._IndicesCollection2___len__(self)

    def __eq__(self, rhs):
        return _experimental._IndicesCollection2___eq__(self, rhs)

    def __contains__(self, val):
        return _experimental._IndicesCollection2___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _experimental._IndicesCollection2_select(self, marginalIndices)

    def __getitem__(self, i):
        return _experimental._IndicesCollection2___getitem__(self, i)

    def __setitem__(self, i, val):
        return _experimental._IndicesCollection2___setitem__(self, i, val)

    def __delitem__(self, i):
        return _experimental._IndicesCollection2___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _experimental._IndicesCollection2_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _experimental._IndicesCollection2_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _experimental._IndicesCollection2_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _experimental._IndicesCollection2_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _experimental._IndicesCollection2_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _experimental._IndicesCollection2_find(self, val)

    def __repr__(self):
        return _experimental._IndicesCollection2___repr__(self)

    def __str__(self, *args):
        return _experimental._IndicesCollection2___str__(self, *args)

    def __init__(self, *args):
        _experimental._IndicesCollection2_swiginit(self, _experimental.new__IndicesCollection2(*args))

# Register _IndicesCollection2 in _experimental:
_experimental._IndicesCollection2_swigregister(_IndicesCollection2)
class FieldFunctionalChaosResult(openturns.common.PersistentObject):
    r"""
    Functional metamodel result.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    inputKLResultCollection : sequence of :class:`~openturns.KarhunenLoeveResult`
        List of input fields decompositions.
    fceResult : :class:`~openturns.FunctionalChaosResult`
        Functional chaos decomposition.
    outputKLResultCollection : sequence of :class:`~openturns.KarhunenLoeveResult`
        List of output fields decompositions.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.FieldFunctionalChaosResult_getClassName(self)

    def __repr__(self):
        return _experimental.FieldFunctionalChaosResult___repr__(self)

    def getInputKLResultCollection(self):
        r"""
        Accessor to the input fields decompositions.

        Returns
        -------
        inputKLResultCollection : Collection of :class:`~openturns.KarhunenLoeveResult`
            List of input fields decompositions.
        """
        return _experimental.FieldFunctionalChaosResult_getInputKLResultCollection(self)

    def getOutputKLResultCollection(self):
        r"""
        Accessor to the output fields decompositions.

        Returns
        -------
        outputKLResultCollection : Collection of :class:`~openturns.KarhunenLoeveResult`
            List of output fields decompositions.
        """
        return _experimental.FieldFunctionalChaosResult_getOutputKLResultCollection(self)

    def getFCEResult(self):
        r"""
        Accessor to the chaos decomposition.

        Returns
        -------
        fceResult : :class:`~openturns.FunctionalChaosResult`
            Functional chaos decomposition.
        """
        return _experimental.FieldFunctionalChaosResult_getFCEResult(self)

    def getBlockIndices(self):
        r"""
        Accessor to the block indices.

        Returns
        -------
        blockIndices : :class:`~openturns.IndicesCollection`
            Independent components indices.
        """
        return _experimental.FieldFunctionalChaosResult_getBlockIndices(self)

    def setBlockIndices(self, blockIndices):
        r"""
        Accessor to the block indices.

        Parameters
        ----------
        blockIndices : 2-d sequence of int
            Independent components indices.
        """
        return _experimental.FieldFunctionalChaosResult_setBlockIndices(self, blockIndices)

    def getFieldToPointMetamodel(self):
        r"""
        Accessor to the metamodel.

        Returns
        -------
        metamodel : :class:`~openturns.FieldToPointFunction`
            Metamodel function.
        """
        return _experimental.FieldFunctionalChaosResult_getFieldToPointMetamodel(self)

    def getPointToFieldMetamodel(self):
        r"""
        Accessor to the metamodel.

        Returns
        -------
        metamodel : :class:`~openturns.PointToFieldFunction`
            Metamodel function.
        """
        return _experimental.FieldFunctionalChaosResult_getPointToFieldMetamodel(self)

    def getFieldMetamodel(self):
        r"""
        Accessor to the metamodel.

        Returns
        -------
        metamodel : :class:`~openturns.FieldFunction`
            Metamodel function.
        """
        return _experimental.FieldFunctionalChaosResult_getFieldMetamodel(self)

    def setMetamodel(self, *args):
        r"""
        Accessor to the metamodel.

        Parameters
        ----------
        metamodel : :class:`~openturns.FieldToPointFunction`
            Metamodel function.
        """
        return _experimental.FieldFunctionalChaosResult_setMetamodel(self, *args)

    def setInputProcessSample(self, inputProcessSample):
        r"""
        Accessor to the input process sample.

        Parameters
        ----------
        inputProcessSample : :class:`~openturns.ProcessSample`
            Input process sample.
        """
        return _experimental.FieldFunctionalChaosResult_setInputProcessSample(self, inputProcessSample)

    def getInputProcessSample(self):
        r"""
        Accessor to the input process sample.

        Returns
        -------
        inputProcessSample : :class:`~openturns.ProcessSample`
            Input process sample.
        """
        return _experimental.FieldFunctionalChaosResult_getInputProcessSample(self)

    def setOutputProcessSample(self, outputProcessSample):
        r"""
        Accessor to the output process sample.

        Parameters
        ----------
        outputProcessSample : :class:`~openturns.ProcessSample`
            Output process sample.
        """
        return _experimental.FieldFunctionalChaosResult_setOutputProcessSample(self, outputProcessSample)

    def getOutputProcessSample(self):
        r"""
        Accessor to the output process sample.

        Returns
        -------
        outputProcessSample : :class:`~openturns.ProcessSample`
            Output process sample.
        """
        return _experimental.FieldFunctionalChaosResult_getOutputProcessSample(self)

    def setInputSample(self, inputSample):
        r"""
        Accessor to the input sample.

        Parameters
        ----------
        inputSample : :class:`~openturns.Sample`
            Input values.
        """
        return _experimental.FieldFunctionalChaosResult_setInputSample(self, inputSample)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input values.
        """
        return _experimental.FieldFunctionalChaosResult_getInputSample(self)

    def setOutputSample(self, outputSample):
        r"""
        Accessor to the output sample.

        Parameters
        ----------
        outputSample : :class:`~openturns.Sample`
            Output values.
        """
        return _experimental.FieldFunctionalChaosResult_setOutputSample(self, outputSample)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output values.
        """
        return _experimental.FieldFunctionalChaosResult_getOutputSample(self)

    def setModesSample(self, modesSample):
        r"""
        Accessor to the modes sample.

        Parameters
        ----------
        modes : :class:`~openturns.Sample`
            Projected modes values.
        """
        return _experimental.FieldFunctionalChaosResult_setModesSample(self, modesSample)

    def getModesSample(self):
        r"""
        Accessor to the modes sample.

        Returns
        -------
        modes : :class:`~openturns.Sample`
             Projected modes values.
        """
        return _experimental.FieldFunctionalChaosResult_getModesSample(self)

    def __init__(self, *args):
        _experimental.FieldFunctionalChaosResult_swiginit(self, _experimental.new_FieldFunctionalChaosResult(*args))
    __swig_destroy__ = _experimental.delete_FieldFunctionalChaosResult

# Register FieldFunctionalChaosResult in _experimental:
_experimental.FieldFunctionalChaosResult_swigregister(FieldFunctionalChaosResult)
class KarhunenLoeveResultCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _experimental.delete_KarhunenLoeveResultCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _experimental.KarhunenLoeveResultCollection_clear(self)

    def __len__(self):
        return _experimental.KarhunenLoeveResultCollection___len__(self)

    def __eq__(self, rhs):
        return _experimental.KarhunenLoeveResultCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _experimental.KarhunenLoeveResultCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _experimental.KarhunenLoeveResultCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _experimental.KarhunenLoeveResultCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _experimental.KarhunenLoeveResultCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _experimental.KarhunenLoeveResultCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _experimental.KarhunenLoeveResultCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _experimental.KarhunenLoeveResultCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _experimental.KarhunenLoeveResultCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _experimental.KarhunenLoeveResultCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _experimental.KarhunenLoeveResultCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _experimental.KarhunenLoeveResultCollection_find(self, val)

    def __repr__(self):
        return _experimental.KarhunenLoeveResultCollection___repr__(self)

    def __str__(self, *args):
        return _experimental.KarhunenLoeveResultCollection___str__(self, *args)

    def __init__(self, *args):
        _experimental.KarhunenLoeveResultCollection_swiginit(self, _experimental.new_KarhunenLoeveResultCollection(*args))

# Register KarhunenLoeveResultCollection in _experimental:
_experimental.KarhunenLoeveResultCollection_swigregister(KarhunenLoeveResultCollection)
class FieldToPointFunctionalChaosAlgorithm(openturns.common.PersistentObject):
    r"""
    Functional metamodel algorithm based on chaos decomposition.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    The present algorithm allows one to build a response surface of the application :math:`h` of the form:

    .. math::
        h: \left|
          \begin{array}{ccl}
             \cM_N \times (\Rset^d)^N & \rightarrow & \Rset^p \\
             \mat{X} & \mapsto & \vect{Y}
          \end{array}
        \right.

    The application :math:`h` is known from :math:`n` fields :math:`(\mat{X_1}, \dots, \mat{X_n})`
    of the associated input process :math:`\mat{X}`
    and :math:`n` vectors :math:`(\vect{Y_1},\dots,\vect{Y_n})`
    that fully characterize the output vector :math:`\vect{Y}`

    The linear projection function :math:`\pi_{ \vect{\lambda}, \vect{\varphi}}` of
    the Karhunen-Loeve decomposition by SVD is used to project the input fields,
    see :class:`~openturns.KarhunenLoeveSVDAlgorithm` and :class:`~openturns.KarhunenLoeveAlgorithm` for the notations.

    .. math::
        \pi_{\vect{\lambda}, \vect{\varphi}}: \left|
          \begin{array}{ccl}
            L^2(\cD, \Rset^d) & \rightarrow & \cS^{\Nset} \\
            f & \mapsto &\left(\dfrac{1}{\sqrt{\lambda_k}}\int_{\cD}f(\vect{t}) \vect{\varphi}_k(\vect{t})\, d\vect{t}\right)_{k \geq 1}
          \end{array}
        \right.

    The Karhunen-Loeve algorithm allows one to replace this integral by a specific weighted and finite sum
    and to write the projections of the j-th marginal of i-th input field :math:`\vect{X_i^j}` by multiplication
    with the projection matrix :math:`\mat{M^j} \in \Rset^{K_j} \times \Rset^{Nd}`:

    .. math::

        \mat{M_j} \vect{X_i^j} = \left( \begin{array}{l} \xi_1^j \\ \dots \\ \xi_{K_j}^j \end{array} \right)
        \in \Rset^{K_j}, \forall i \in [1, n], \forall j \in [1, d]

    with :math:`K_j` the retained number of modes in the decomposition of the j-th input.
    The projections of all the :math:`d` components of :math:`n` fields are assembled in the :math:`Q` matrix:

    .. math::

        \begin{align*}
            \mat{Q} = \mat{M} \mat{X} =
            \left(
              \begin{array}{l}
                \mat{M_1} \mat{X^1} \\
                \dots \\
                \mat{M_d} \mat{X^d}
              \end{array}
            \right) \in \Rset^{K_T} \times \Rset^n
         \end{align*}

    with :math:`K_T = \sum_{j=1}^d{K_j}` the total number of modes across input components.

    Then a functional chaos decomposition is built between the projected modes
    sample :math:`\mat{Q}` and the output samples :math:`\mat{Y}`,
    see :class:`~openturns.FunctionalChaosAlgorithm` for details.

    .. math::

        \tilde{g}(x) = \sum_{k=1}^{K_c} \beta_{\vect{\alpha}_k} \Psi_{\vect{\alpha}_k}(x)

    with :math:`K_c` the number of terms in the chaos decomposition.

    The final metamodel consists in the composition of the Karhunen-Loeve
    projections and the functional chaos metamodel.

    .. math::
        \tilde{h}: \left|
          \begin{array}{ccccl}
             \cM_N \times (\Rset^d)^N & \rightarrow & \Rset^{K_T} & \rightarrow & \Rset^p \\
             \mat{X} & \mapsto & \vect{Q} & \mapsto & \vect{Y}
          \end{array}
        \right.

    A limitation of this approach is that the projected modes sample has a dimension
    :math:`K_T` so the dimension of the input fields :math:`\mat{X_i}`
    and the associated number of modes must remain modest (curse of dimensionality).

    Parameters
    ----------
    x : :class:`~openturns.ProcessSample`
        Input process sample.
    y : :class:`~openturns.Sample`
        Output sample.

    See also
    --------
    FieldFunctionalChaosSobolIndices, KarhunenLoeveAlgorithm, FunctionalChaosAlgorithm

    Notes
    -----
    As the input process decomposition is done with the values decomposition approach,
    it is possible to control the number of modes retained per input,
    the idea being to avoid a large input dimension for the chaos decomposition step.
    As done in :class:`~openturns.KarhunenLoeveSVDAlgorithm`, the :func:`setThreshold`
    and :func:`setNbModes` methods allow one to control the spectrum ratio and maximum count.

    By default the input process data is assumed to not be centered, and the method
    :func:`setCenteredSample` allows one to skip centering of the data for both the
    computation of modes coefficients and inside the metamodel.

    In the case of homogenous data (if variables have the same unit or scale),
    it is also possible to recompress the modes at the global level with :func:`setRecompress`.
    When enabled, the eigenvalues are gathered and sorted so as to find a global
    spectrum cut-off value by which the spectrum of each input is truncated.
    The default value can be set through the :class:`~openturns.ResourceMap` key
    *FieldToPointFunctionalChaosAlgorithm-DefaultRecompress*.

    For the chaos metamodel step, it is possible to specify the basis size with
    the :class:`~openturns.ResourceMap` key *FunctionalChaosAlgorithm-BasisSize*.

    It is possible to group input variables by independent blocks with :func:`setBlockIndices`,
    this way Karhunen-Loeve process decompositions are done on each block rather
    than on each variable thus reducing the total number of modes and help reduce
    the chaos input dimension.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> mesh = ot.RegularGrid(0.0, 0.1, 20)
    >>> cov = ot.KroneckerCovarianceModel(ot.MaternModel([2.0], 1.5), ot.CovarianceMatrix(4))
    >>> X = ot.GaussianProcess(cov, mesh)
    >>> x = X.getSample(500)
    >>> y = [[m[0] + m[1] + m[2] - m[3] + m[0] * m[1] - m[2] * m[3] - 0.1 * m[0] * m[1] * m[2]] for m in [xi.computeMean() for xi in x]]
    >>> algo = otexp.FieldToPointFunctionalChaosAlgorithm(x, y)
    >>> algo.setThreshold(4e-2)
    >>> # Temporarily lower the basis size for the sake of this example.
    >>> ot.ResourceMap.SetAsUnsignedInteger('FunctionalChaosAlgorithm-BasisSize', 100)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> metamodel = result.getFieldToPointMetamodel()
    >>> y0hat = metamodel(x[0])
    >>> ot.ResourceMap.Reload()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getClassName(self)

    def getInputProcessSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.ProcessSample`
            Input sample.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getInputProcessSample(self)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getOutputSample(self)

    def getBlockIndices(self):
        r"""
        Accessor to the block indices.

        Returns
        -------
        blockIndices : :class:`~openturns.IndicesCollection`
            Independent components indices.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getBlockIndices(self)

    def setBlockIndices(self, blockIndices):
        r"""
        Accessor to the block indices.

        Parameters
        ----------
        blockIndices : 2-d sequence of int
            Independent components indices.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_setBlockIndices(self, blockIndices)

    def getThreshold(self):
        r"""
        Accessor to the eigenvalues cutoff ratio.

        Returns
        -------
        s : float, :math:`\geq 0`
            The threshold :math:`s`.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getThreshold(self)

    def setThreshold(self, threshold):
        r"""
        Accessor to the eigenvalues cutoff ratio.

        Parameters
        ----------
        s : float, :math:`\geq 0`
            The threshold :math:`s`.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_setThreshold(self, threshold)

    def getNbModes(self):
        r"""
        Accessor to the maximum number of modes to compute.

        Returns
        -------
        n : int
            The maximum number of modes to compute.
            The actual number of modes also depends on the threshold criterion.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getNbModes(self)

    def setNbModes(self, nbModes):
        r"""
        Accessor to the maximum number of modes to compute.

        Parameters
        ----------
        n : int
            The maximum number of modes to compute.
            The actual number of modes also depends on the threshold criterion.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_setNbModes(self, nbModes)

    def getRecompress(self):
        r"""
        Accessor to the recompression flag.

        Returns
        -------
        recompress : bool
            Whether to recompress the input Karhunen-Loeve decompositions.
            This can only be enabled if the scale of the input variable blocks is the same.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getRecompress(self)

    def setRecompress(self, recompress):
        r"""
        Accessor to the recompression flag.

        Parameters
        ----------
        recompress : bool
            Whether to recompress the input Karhunen-Loeve decompositions.
            The modes are truncated a second time according to a global eigen value
            bound across input decompositions.
            This can only be enabled if the scale of the input variable blocks is the same.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_setRecompress(self, recompress)

    def setCenteredSample(self, centered):
        r"""
        Accessor to centered sample flag.

        Parameters
        ----------
        centered : bool
            Whether the input sample is centered.
            When set to True, it allows one to skip centering of the input process data.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_setCenteredSample(self, centered)

    def getCenteredSample(self):
        r"""
        Accessor to centered sample flag.

        Parameters
        ----------
        centered : bool
            Whether the input sample is centered.
            When set to True, it allows one to skip centering of the input process data.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getCenteredSample(self)

    def __repr__(self):
        return _experimental.FieldToPointFunctionalChaosAlgorithm___repr__(self)

    def run(self):
        r"""
        Compute the response surfaces.

        Notes
        -----
        It computes the response surfaces and creates a
        :class:`~openturns.MetaModelResult` structure containing all the results.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_run(self)

    def getResult(self):
        r"""
        Result accessor.

        Returns
        -------
        result : :class:`~openturns.FieldFunctionalChaosResult`
            Result class.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_getResult(self)

    @staticmethod
    def BuildDistribution(modesSample):
        r"""
        Build the distribution of Karhunen-Loeve coefficients.

        This method aims at building a possibly parametric representation of
        Karhunen-Loeve coefficients based on their Gaussian or independent theorical
        properties in order to build efficient metamodels.
        When this is not possible it falls back to non-parametric representations for
        the marginals and the dependence structure.

        Parameters
        ----------
        modesSample : :class:`~openturns.Sample`
            Karhunen-Loeve modes sample.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of coefficients.

        Notes
        -----
        The strategy for marginals is to test for a :class:`~openturns.Normal` hypothesis
        via the :py:meth:`~openturns.NormalityTest.CramerVonMisesNormal` test, else fallback to :class:`~openturns.Histogram`.

        For the dependence structure it tests for an :class:`~openturns.IndependentCopula`
        thanks to the :py:meth:`~openturns.HypothesisTest.Spearman` test, else fallback
        to the Normal or Beta copula (see :class:`~openturns.EmpiricalBernsteinCopula`)
        according to the :class:`~openturns.ResourceMap` key *FieldToPointFunctionalChaosAlgorithm-CopulaType*.
        """
        return _experimental.FieldToPointFunctionalChaosAlgorithm_BuildDistribution(modesSample)

    def __init__(self, *args):
        _experimental.FieldToPointFunctionalChaosAlgorithm_swiginit(self, _experimental.new_FieldToPointFunctionalChaosAlgorithm(*args))
    __swig_destroy__ = _experimental.delete_FieldToPointFunctionalChaosAlgorithm

# Register FieldToPointFunctionalChaosAlgorithm in _experimental:
_experimental.FieldToPointFunctionalChaosAlgorithm_swigregister(FieldToPointFunctionalChaosAlgorithm)
class FieldFunctionalChaosSobolIndices(openturns.common.PersistentObject):
    r"""
    Sobol indices from a functional decomposition.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    This class allows one to perform sensitivity analysis from field chaos decomposition.
    The process decomposition is done by Karhunen-Loeve and the modes interpolation
    is performed by functional chaos:

    .. math::

        \tilde{g}(x) = \sum_{k \in K_c} \beta_{\vect{\alpha}_k} \Psi_{\vect{\alpha}_k}(x)

    Let us expand the multi indices notation:

    .. math::

        \Psi_{\vect{\alpha}}(x) = \prod_{j=1}^{K_T} P^j_{\alpha_j}(x_j)

    with

    .. math::

        \vect{\alpha} \in \mathbb{N}^{K_T} = \{\underbrace{\alpha_1, \dots, \alpha_{K_1}}_{K_1},\dots,\underbrace{\alpha_{K_T-K_d}, \dots, \alpha_{K_T}}_{K_d}\}

    see :class:`~openturns.FunctionalChaosAlgorithm` for details.

    Sobol indices of the input field component :math:`j \in [1,d]` can be computed
    from the coefficients of the chaos decomposition that involve the
    matching Karhunen-Loeve coefficients.

    For the first order Sobol indices we sum over the multi-indices :math:`\vect{\alpha}_k`
    that are non-zero on the :math:`K_j` indices corresponding to the Karhunen-Loeve
    decomposition of j-th input and zero on the other :math:`K_T - K_j` indices (noted :math:`G_j`):

    .. math::

        S_j = \frac{\sum_{k=1, \vect{\alpha}_k \in G_j}^{K_c} \beta_{\vect{\alpha}_k}^2}{\sum_{k=1}^{K_c} \beta_{\vect{\alpha}_k}^2}

    For the total order Sobol indices we sum over the multi-indices :math:`\vect{\alpha}_k`
    that are non-zero on the :math:`K_j` indices corresponding to the Karhunen-Loeve
    decomposition of the j-th input (noted :math:`GT_j`):

    .. math::

        S_{T_j} = \frac{\sum_{k=1, \vect{\alpha}_k \in GT_j}^{K_c} \beta_{\vect{\alpha}_k}^2}{\sum_{k=1}^{K_c} \beta_{\vect{\alpha}_k}^2} 

    This generalizes to higher order indices.

    Parameters
    ----------
    result : :class:`~openturns.FieldFunctionalChaosResult`
        Result.

    See also
    --------
    FieldToPointFunctionalChaosAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> mesh = ot.RegularGrid(0.0, 0.1, 20)
    >>> cov = ot.KroneckerCovarianceModel(ot.MaternModel([2.0], 1.5), ot.CovarianceMatrix(4))
    >>> X = ot.GaussianProcess(cov, mesh)
    >>> x = X.getSample(500)
    >>> y = []
    >>> for xi in x:
    ...     m = xi.computeMean()
    ...     y.append([m[0] + m[1] + m[2] - m[3] + m[0] * m[1] - m[2] * m[3] - 0.1 * m[0] * m[1] * m[2]])
    >>> algo = otexp.FieldToPointFunctionalChaosAlgorithm(x, y)
    >>> algo.setThreshold(4e-2)
    >>> # Temporarily lower the basis size for the sake of this example.
    >>> # We need to store the original size.
    >>> bs = ot.ResourceMap.GetAsUnsignedInteger('FunctionalChaosAlgorithm-BasisSize')
    >>> ot.ResourceMap.SetAsUnsignedInteger('FunctionalChaosAlgorithm-BasisSize', 100)
    >>> algo.run()
    >>> # The algorithm has been run with the lower basis size:
    >>> # we can now restore the original value.
    >>> ot.ResourceMap.SetAsUnsignedInteger('FunctionalChaosAlgorithm-BasisSize', bs)
    >>> result = algo.getResult()
    >>> sensitivity = otexp.FieldFunctionalChaosSobolIndices(result)
    >>> sobol_1 = sensitivity.getFirstOrderIndices()
    >>> sobol_t = sensitivity.getTotalOrderIndices()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.FieldFunctionalChaosSobolIndices_getClassName(self)

    def __repr__(self):
        return _experimental.FieldFunctionalChaosSobolIndices___repr__(self)

    def getSobolIndex(self, *args):
        r"""
        Get a single Sobol index.

        Parameters
        ----------
        i : int or list of int
            Input index
        j : int, default=0
            Output index

        Returns
        -------
        s : float
            Sobol index
        """
        return _experimental.FieldFunctionalChaosSobolIndices_getSobolIndex(self, *args)

    def getSobolTotalIndex(self, *args):
        r"""
        Get a single Sobol index.

        Parameters
        ----------
        i : int or list of int
            Input index
        j : int, default=0
            Output index

        Returns
        -------
        s : float
            Sobol index
        """
        return _experimental.FieldFunctionalChaosSobolIndices_getSobolTotalIndex(self, *args)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get the first order Sobol indices.

        Parameters
        ----------
        j : int, default=0
            Output index

        Returns
        -------
        indices : :class:`~openturns.Point`
            First order Sobol indices
        """
        return _experimental.FieldFunctionalChaosSobolIndices_getFirstOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get the total order Sobol indices.

        Parameters
        ----------
        j : int, default=0
            Output index

        Returns
        -------
        indices : :class:`~openturns.Point`
            Total order Sobol indices
        """
        return _experimental.FieldFunctionalChaosSobolIndices_getTotalOrderIndices(self, marginalIndex)

    def draw(self, marginalIndex=0):
        r"""
        Draw sensitivity indices.

        Parameters
        ----------
        marginalIndex : int, default=0
            Marginal index

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph showing the first and total order indices per input.
        """
        return _experimental.FieldFunctionalChaosSobolIndices_draw(self, marginalIndex)

    def __init__(self, *args):
        _experimental.FieldFunctionalChaosSobolIndices_swiginit(self, _experimental.new_FieldFunctionalChaosSobolIndices(*args))
    __swig_destroy__ = _experimental.delete_FieldFunctionalChaosSobolIndices

# Register FieldFunctionalChaosSobolIndices in _experimental:
_experimental.FieldFunctionalChaosSobolIndices_swigregister(FieldFunctionalChaosSobolIndices)
class LeastSquaresExpansion(openturns.metamodel.FunctionalChaosAlgorithm):
    r"""
    L2 approximation on an orthonormal basis using least-squares and a fixed basis.

    Available constructors:
        LeastSquaresExpansion(*inputSample, outputSample, distribution*)

        LeastSquaresExpansion(*inputSample, weights, outputSample, distribution*)

        LeastSquaresExpansion(*inputSample, outputSample, distribution, basis, basisSize, methodName*)

        LeastSquaresExpansion(*inputSample, weights, outputSample, distribution, basis, basisSize, methodName*)

    Parameters
    ----------
    inputSample : 2-d sequence of float of size :math:`n>0`
        Input sample.
    weight : sequence of float of size :math:`n>0`, optional
        Input weights. By default, a uniform weight equals to :math:`1/n` is used.
    outputSample : 2-d sequence of floats of size :math:`n>0`
        Output sample.
    distribution : :class:`~openturns.Distribution`
        The distribution associated to the weighted sample *(inputSample, weights)*
    basis : :class:`~openturns.OrthogonalBasis`, optional
        The orthonormal basis of the vector space on which the approximation is built.
        By default, a basis is built using an hyperbolic enumerate function
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` associated to the
        :math:`q-` norm specified by the `FunctionalChaosAlgorithm-QNorm` key in
        :class:`~openturns.ResourceMap`.
        The basis is obtained through a tensorization of the univariate orthonormal
        polynomial bases associated to each marginal distributions of *distribution*.
    basisSize : int, optional
        The size of the basis on which the approximation is built. If not given, it is
        given by the `FunctionalChaosAlgorithm-BasisSize` key in
        :class:`~openturns.ResourceMap` if this value is positive, or as the cardinal
        of the set of basis functions up to a degree given by the
        `FunctionalChaosAlgorithm-MaximumTotalDegree` key in
        :class:`~openturns.ResourceMap`.
    methodName : str, optional
        The decomposition method used to solve the least-squares problem, of
        type :class:`~openturns.LeastSquaresMethod`. If not given, it is given by the
        `LeastSquaresExpansion-DecompositionMethod` key in
        :class:`~openturns.ResourceMap`.

    See also
    --------
    IntegrationExpansion, FunctionalChaosAlgorithm, LeastSquaresMethod

    Examples
    --------
    Solves a functional linear least squares approximation using residual minimization with QR method:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> g = ot.SymbolicFunction('x', 'sin(x)')
    >>> distribution = ot.Uniform(-2.0, 2.0)
    >>> inSample = distribution.getSample(10)
    >>> outSample = g(inSample)
    >>> basis = ot.OrthogonalProductPolynomialFactory([ot.LegendreFactory()])
    >>> basisSize = 5
    >>> algo = otexp.LeastSquaresExpansion(inSample, outSample, distribution, basis, basisSize, 'QR')
    >>> algo.run()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.LeastSquaresExpansion_getClassName(self)

    def run(self):
        r"""
        Compute the metamodel.

        Notes
        -----
        Evaluates the metamodel and stores all the results in a result structure.
        """
        return _experimental.LeastSquaresExpansion_run(self)

    def getActiveFunctions(self):
        r"""
        Accessor to the active functions in the basis.

        Returns
        -------
        activeFunctions : sequence of `int`
            The indices of the functions used for the approximation in the basis.
        """
        return _experimental.LeastSquaresExpansion_getActiveFunctions(self)

    def setActiveFunctions(self, activeFunctions):
        r"""
        Accessor to the active functions in the basis.

        Parameters
        ----------
        activeFunctions : sequence of `int`
            The indices of the functions used for the approximation in the basis.
        """
        return _experimental.LeastSquaresExpansion_setActiveFunctions(self, activeFunctions)

    def __repr__(self):
        return _experimental.LeastSquaresExpansion___repr__(self)

    def __str__(self, *args):
        return _experimental.LeastSquaresExpansion___str__(self, *args)

    def __init__(self, *args):
        _experimental.LeastSquaresExpansion_swiginit(self, _experimental.new_LeastSquaresExpansion(*args))
    __swig_destroy__ = _experimental.delete_LeastSquaresExpansion

# Register LeastSquaresExpansion in _experimental:
_experimental.LeastSquaresExpansion_swigregister(LeastSquaresExpansion)
class IntegrationExpansion(openturns.metamodel.FunctionalChaosAlgorithm):
    r"""
    L2 approximation on an orthonormal basis using least-squares and a fixed basis.

    Available constructors:
        IntegrationExpansion(*inputSample, outputSample, distribution*)

        IntegrationExpansion(*inputSample, weights, outputSample, distribution*)

        IntegrationExpansion(*inputSample, outputSample, distribution, basis, basisSize*)

        IntegrationExpansion(*inputSample, weights, outputSample, distribution, basis, basisSize*)

    Parameters
    ----------
    inputSample : 2-d sequence of float of size :math:`n>0`
        Input sample.
    weight : sequence of float of size :math:`n>0`, optional
        Input weights. By default, a uniform weight equals to :math:`1/n` is used.
    outputSample : 2-d sequence of floats of size :math:`n>0`
        Output sample.
    distribution : :class:`~openturns.Distribution`
        The distribution associated to the weighted sample *(inputSample, weights)*
    basis : :class:`~openturns.OrthogonalBasis`, optional
        The orthonormal basis of the vector space on which the approximation is built.
        By default, a basis is built using an hyperbolic enumerate function
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` associated to the
        :math:`q-` norm specified by the `FunctionalChaosAlgorithm-QNorm` key in
        :class:`~openturns.ResourceMap`.
        The basis is obtained through a tensorization of the univariate orthonormal
        polynomial bases associated to each marginal distributions of *distribution*.
    basisSize : int, optional
        The size of the basis on which the approximation is built. If not given, it is
        given by the `FunctionalChaosAlgorithm-BasisSize` key in
        :class:`~openturns.ResourceMap` if this value is positive, or as the cardinal
        of the set of basis functions up to a degree given by the
        `FunctionalChaosAlgorithm-MaximumTotalDegree` key in
        :class:`~openturns.ResourceMap`.

    See also
    --------
    LeastSquaresExpansion, FunctionalChaosAlgorithm, IntegrationMethod

    Examples
    --------
    Solves a functional least-squares approximation using a projection on an orthonormal basis:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> g = ot.SymbolicFunction('x', 'sin(x)')
    >>> distribution = ot.Uniform(-2.0, 2.0)
    >>> inSample = distribution.getSample(10)
    >>> outSample = g(inSample)
    >>> basis = ot.OrthogonalProductPolynomialFactory([ot.LegendreFactory()])
    >>> basisSize = 5
    >>> algo = otexp.IntegrationExpansion(inSample, outSample, distribution, basis, basisSize)
    >>> algo.run()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.IntegrationExpansion_getClassName(self)

    def getActiveFunctions(self):
        r"""
        Accessor to the active functions in the basis.

        Returns
        -------
        activeFunctions : sequence of `int`
            The indices of the functions used for the approximation in the basis.
        """
        return _experimental.IntegrationExpansion_getActiveFunctions(self)

    def setActiveFunctions(self, activeFunctions):
        r"""
        Accessor to the active functions in the basis.

        Parameters
        ----------
        activeFunctions : sequence of `int`
            The indices of the functions used for the approximation in the basis.
        """
        return _experimental.IntegrationExpansion_setActiveFunctions(self, activeFunctions)

    def run(self):
        r"""
        Compute the metamodel.

        Notes
        -----
        Evaluates the metamodel and stores all the results in a result structure.
        """
        return _experimental.IntegrationExpansion_run(self)

    def __repr__(self):
        return _experimental.IntegrationExpansion___repr__(self)

    def __str__(self, *args):
        return _experimental.IntegrationExpansion___str__(self, *args)

    def __init__(self, *args):
        _experimental.IntegrationExpansion_swiginit(self, _experimental.new_IntegrationExpansion(*args))
    __swig_destroy__ = _experimental.delete_IntegrationExpansion

# Register IntegrationExpansion in _experimental:
_experimental.IntegrationExpansion_swigregister(IntegrationExpansion)
class CrossEntropyResult(ProbabilitySimulationResult):
    r"""
    Cross Entropy result.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    See also
    --------
    CrossEntropyImportanceSampling, PhysicalSpaceCrossEntropyImportanceSampling, StandardSpaceCrossEntropyImportanceSampling, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.CrossEntropyResult_getClassName(self)

    def getAuxiliaryInputSample(self):
        r"""
        Accessor to the auxiliary distribution input sample at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_getAuxiliaryInputSample(self)

    def setAuxiliaryInputSample(self, auxiliaryInputSample):
        r"""
        Accessor to the auxiliary distribution input sample at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryInputSample : :class:`~openturns.Sample`
            Auxiliary distribution input sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_setAuxiliaryInputSample(self, auxiliaryInputSample)

    def getAuxiliaryOutputSample(self):
        r"""
        Accessor to the auxiliary distribution output sample at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_getAuxiliaryOutputSample(self)

    def setAuxiliaryOutputSample(self, auxiliaryInputSample):
        r"""
        Accessor to the auxiliary distribution output sample at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryOutputSample : :class:`~openturns.Sample`
            Auxiliary distribution output sample at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_setAuxiliaryOutputSample(self, auxiliaryInputSample)

    def getAuxiliaryDistribution(self):
        r"""
        Accessor to the auxiliary distribution at the final Cross Entropy algorithm step.

        Returns
        -------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_getAuxiliaryDistribution(self)

    def setAuxiliaryDistribution(self, auxiliaryDistribution):
        r"""
        Accessor to the auxiliary distribution at the final Cross Entropy algorithm step.

        Parameters
        ----------
        auxiliaryDistribution : :class:`~openturns.Distribution`
            Auxiliary distribution at the final Cross Entropy algorithm step.
        """
        return _experimental.CrossEntropyResult_setAuxiliaryDistribution(self, auxiliaryDistribution)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _experimental.CrossEntropyResult_getCoefficientOfVariation(self)

    def __init__(self, *args):
        _experimental.CrossEntropyResult_swiginit(self, _experimental.new_CrossEntropyResult(*args))
    __swig_destroy__ = _experimental.delete_CrossEntropyResult

# Register CrossEntropyResult in _experimental:
_experimental.CrossEntropyResult_swigregister(CrossEntropyResult)
class CrossEntropyImportanceSampling(EventSimulation):
    r"""
    Cross-Entropy Importance Sampling algorithm.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    See also
    --------
    StandardSpaceCrossEntropyImportanceSampling, PhysicalSpaceCrossEntropyImportanceSampling, CrossEntropyResult


    Notes
    -----
    This class inherits from :class:`~openturns.EventSimulation`.

    The principle is to perform a simulation study to evaluate the threshold exceedance probability according to an importance density obtained using Cross Entropy algorithm.

    A CrossEntropyImportanceSampling object can be created only through its derivative classes, :class:`~openturns.experimental.StandardSpaceCrossEntropyImportanceSampling` or :class:`~openturns.experimental.PhysicalSpaceCrossEntropyImportanceSampling`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.CrossEntropyImportanceSampling_getClassName(self)

    def getQuantileLevel(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        quantileLevel : : float
            Result of Cross Entropy algorithm.
        """
        return _experimental.CrossEntropyImportanceSampling_getQuantileLevel(self)

    def setQuantileLevel(self, quantileLevel):
        r"""
        Accessor to the intermediate quantile level.

        Parameters
        ----------
        quantileLevel : : float
            Intermediate quantile level, must belong to the interval (0,1).
        """
        return _experimental.CrossEntropyImportanceSampling_setQuantileLevel(self, quantileLevel)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurrence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows one to use
        efficiently the distribution of the computation as well as it allows one to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _experimental.CrossEntropyImportanceSampling_run(self)

    def getResult(self):
        r"""
        Accessor to the intermediate quantile level.

        Returns
        -------
        CrossEntropyResult : : class:`~openturns.CrossEntropyResult`
            Contains all the results of the Cross Entropy algorithm simulation.
        """
        return _experimental.CrossEntropyImportanceSampling_getResult(self)

    def __init__(self, *args):
        _experimental.CrossEntropyImportanceSampling_swiginit(self, _experimental.new_CrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_CrossEntropyImportanceSampling

# Register CrossEntropyImportanceSampling in _experimental:
_experimental.CrossEntropyImportanceSampling_swigregister(CrossEntropyImportanceSampling)
class StandardSpaceCrossEntropyImportanceSampling(CrossEntropyImportanceSampling):
    r"""
    Standard Space Cross-Entropy Importance Sampling.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    event : :class:`~openturns.ThresholdEvent`
        Event we are computing the probability of.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level. The default number can be tweaked with the `CrossEntropyImportanceSampling-DefaultQuantileLevel` key from :class:`~openturns.ResourceMap`.

    Notes
    -----
    The following explanations are given for a failure event defined as :math:`g(\vect{X})<T` with :math:`\vect{X}` 
    a random vector following a joint PDF :math:`f_\vect{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\vect{1}}_{g(\vect{x}_i)<T} \frac{f_\vect{X}(\vect{x}_i)}{h(\vect{x}_i)},

    with :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\vect{1}}_{g(\vect{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density :math:`h_{opt}` minimizing the variance of the estimator :math:`h_{opt}` is defined as:

    .. math::

        h_{opt}=\frac{{\vect{1}}_{g(\vect{x})<T}f_\vect{X}}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest and unknown.

    The Standard Space Cross-Entropy Importance Sampling [rubinstein2017]_ uses a parametric auxiliary distribution :math:`h_\vect{\lambda}` in order to optimize its parameters to compute the probability of interest with accuracy. 
    This process is performed in the standard space using a Normal distribution as the auxiliary distribution. Indeed, in the standard space, the optimal value of the mean and standard deviations are given analytically, see [morio2015]_ for details. 

    We note  :math:`G(\vect{u})` the limit state function in standard space and  :math:`g(\vect{x})` its counterpart in the physical space. :math:`f_\vect{U}` stands for the initial distribution in standard space, i.e. the Normal law. The algorithm is as follows:


    1. :math:`k=1`, set the quantile level :math:`\rho \in [0,1]` and :math:`h_0 = f_{\vect{U}}`

    2. Generate the population :math:`\vect{u}_1^{(k)},...,\vect{u}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`G` in order to have :math:`y_1^{(k)}=G(\vect{u}_1^{(k)}),...,y_N^{(k)} = G(\vect{u}_N^{(k)})`

    3. Compute the   :math:`\rho`-quantile :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})` using the floor of :math:`\rho N`.

    4. If :math:`q_k>T`, go to Step 7

    4. Update the mean and standard deviation of the auxiliary distribution:

    .. math::

           \mu_{k}= \frac{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} \vect{u}_i^{(k)}}{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} }

    .. math::

           \sigma_{k}= \frac{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} (\vect{u}_i^{(k)}-\mu_k)^2}{\frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{G(\vect{u}_i^{(k)}) \leq q_k} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{u}_i^{(k)})} }


    6. :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{CE}(g(\vect{\vect{X}})<T)=\widehat{P}^{CE}(G(\vect{\vect{U}})<T)=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \vect{1}_{G(\vect{u}_i^{(k)})<T} \frac{f_\vect{U}(\vect{u}_i^{(k)})}{h_{\vect{\lambda}_{k-1}(\vect{u}_i^{(k)})}}`




    See also
    --------
    PhysicalSpaceCrossEntropyImportanceSampling, CrossEntropyImportanceSampling, CrossEntropyResult


    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution_R = ot.LogNormalMuSigma(300.0, 30.0, 0.0).getDistribution()
    >>> distribution_F = ot.Normal(75e3, 5e3)
    >>> marginals = [distribution_R, distribution_F]
    >>> distribution = ot.ComposedDistribution(marginals)
    >>> # create the model
    >>> model = ot.SymbolicFunction(['R', 'F'], ['R - F / (pi_ * 100.0)'])  
    >>> # create the event 
    >>> vect = ot.RandomVector(distribution)
    >>> g = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(g, ot.Less(), 0.0)
    >>> myIS = otexp.StandardSpaceCrossEntropyImportanceSampling(event, 0.3)
    >>> # run StandardSpaceCrossEntropyImportanceSampling
    >>> myIS.run()
    >>> myResult = myIS.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.StandardSpaceCrossEntropyImportanceSampling_getClassName(self)

    def __init__(self, *args):
        _experimental.StandardSpaceCrossEntropyImportanceSampling_swiginit(self, _experimental.new_StandardSpaceCrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_StandardSpaceCrossEntropyImportanceSampling

# Register StandardSpaceCrossEntropyImportanceSampling in _experimental:
_experimental.StandardSpaceCrossEntropyImportanceSampling_swigregister(StandardSpaceCrossEntropyImportanceSampling)
class PhysicalSpaceCrossEntropyImportanceSampling(CrossEntropyImportanceSampling):
    r"""
    Physical Space Cross-Entropy Importance Sampling.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    event : :class:`~openturns.ThresholdEvent`
        Event we are computing the probability of.

    activeParameters : sequence of integers
        List of active parameters indices for the auxiliary distribution.

    initialAuxiliaryDistributionParameters : sequence of floats
        Initial value of active parameters of the auxiliary distribution.

    bounds : :class:`~openturns.Interval`
        Bounds on the active parameters of the auxiliary distribution.

    auxiliaryDistribution : :class:`~openturns.Distribution`
        Auxiliary distribution for the Cross Entropy Importance Sampling algorithm.

    quantileLevel : float  :math:`0<quantileLevel<1`
        Intermediate quantile level. The default number can be tweaked with the `CrossEntropyImportanceSampling-DefaultQuantileLevel` key from :class:`~openturns.ResourceMap`.

    Notes
    -----    

    The following explanations are given for a failure event defined as :math:`g(\vect{X})<T` with :math:`\vect{X}` 
    a random vector following a joint PDF :math:`f_\vect{X}`, :math:`T` a threshold and :math:`g` a limit state function,
    without loss of generality.

    The Importance Sampling (IS) probability estimate :math:`\widehat{P}^\text{IS}` is given by:

    .. math::

        \widehat{P}^\text{IS}=\frac{1}{N} \sum_{i=1}^{N} {\vect{1}}_{g(\vect{x}_i)<T} \frac{f_\vect{X}(\vect{x}_i)}{h(\vect{x}_i)},

    with :math:`h` the auxiliary PDF of Importance Sampling, 
    :math:`N` the number of independent samples generated with :math:`h` and :math:`{\vect{1}}_{g(\vect{x}_i)<T}` the 
    indicator function of the failure domain. 

    The optimal density :math:`h_{opt}` minimizing the variance of the estimator is defined as:

    .. math::

        h_{opt}=\frac{{\vect{1}}_{g(\vect{x})<T}f_\vect{X}}{P},

    with :math:`P` the failure probability which is inaccessible in practice since this probability is the quantity of interest
    and unknown.

    The Physical Space Cross-Entropy Importance Sampling algorithm [rubinstein2017]_ uses a parametric auxiliary distribution :math:`h_\vect{\lambda}` in order to optimize its parameters to compute the probability of interest with accuracy.

    It involves an auxiliary optimization problem to find the auxiliary distribution parameters :math:`\vect{\lambda}` minimizing the Kullback-Leibler divergence with respect to :math:`h_{opt}`. The following algorithm is used:

    1. :math:`k=1`, set the quantile level :math:`\rho \in [0,1]` and :math:`h_0 = f_{\vect{X}}`

    2. Generate the population :math:`\vect{x}_1^{(k)},...,\vect{x}_N^{(k)}` according to the PDF :math:`h_{k-1}`, apply the 
       function :math:`g` in order to have :math:`y_1^{(k)}=g(\vect{x}_1^{(k)}),...,y_N^{(k)} = g(\vect{x}_N^{(k)})`

    3. Compute the empirical :math:`\rho`-quantile :math:`q_k=\max(T,y^{(k)}_{\left \lfloor \rho N \right\rfloor})` using the floor of :math:`\rho N`.

    4. If :math:`q_k>T`: go to Step 7

    5. Estimate the auxiliary distribution parameters:

       .. math::

           \vect{\lambda}_{k}= \textrm{argmax}_{\lambda} \frac{1}{N} \sum_{i=1}^{N}{\vect{1}}_{g(\vect{x}_i^{(k)}) \leq q_k} \frac{f_\vect{X}(\vect{x}_i^{(k)})}{h_{\vect{\lambda}_{k-1}}(\vect{x}_i^{(k)})} \log(h_{\vect{\lambda}}(\vect{x}_i^{(k)}))

    6. :math:`k\leftarrow k+1`, go to Step 2

    7. Estimate the probability :math:`\widehat{P}^{CE}(g(\vect{\vect{X}})<T)=\frac{1}{N}\displaystyle \sum_{i=1}^{N} \vect{1}_{g(\vect{x}_i^{(k)})<T} \frac{f_\vect{X}(\vect{x}_i^{(k)})}{h_{\vect{\lambda}_{k-1}(\vect{x}_i^{(k)})}}`.


    Default solver for the optimization of auxiliary distribution is `LD_LBFGS` from :class:`~openturns.NLopt`.

    See also
    --------
    StandardSpaceCrossEntropyImportanceSampling, CrossEntropyImportanceSampling, CrossEntropyResult


    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution_R = ot.LogNormalMuSigma(300.0, 30.0, 0.0).getDistribution()
    >>> distribution_F = ot.Normal(75e3, 5e3)
    >>> marginals = [distribution_R, distribution_F]
    >>> distribution = ot.ComposedDistribution(marginals)
    >>> # create the model
    >>> model = ot.SymbolicFunction(['R', 'F'], ['R-F/(pi_*100.0)'])   
    >>> # create the event 
    >>> vect = ot.RandomVector(distribution)
    >>> G = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(G, ot.Less(), 0.0)
    >>> distribution_marginR = ot.LogNormalMuSigma().getDistribution()
    >>> distribution_marginF = ot.Normal()
    >>> aux_marginals = [distribution_marginR, distribution_marginF]
    >>> aux_distribution = ot.ComposedDistribution(aux_marginals)
    >>> # definition of auxiliary distribution parameters to be optimized
    >>> active_parameters = [0,1,2,3,4]
    >>> ### WARNING : native parameters of distribution have to be considered
    >>> bounds = ot.Interval([3,0.09,0.,50e3,2e3], [7,0.5,0.5,100e3,10e3])# bounds on the active parameters
    >>> initial_theta= [5.70,0.1,0.,75e3,5e3] # initial value of the active parameters
    >>> my_IS_physical = otexp.PhysicalSpaceCrossEntropyImportanceSampling(event,aux_distribution,active_parameters,initial_theta,bounds,0.3)
    >>> my_IS_physical.run()
    >>> myResult = my_IS_physical.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PhysicalSpaceCrossEntropyImportanceSampling_getClassName(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the optimization algorithm used to update auxiliary distribution parameters.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
        """
        return _experimental.PhysicalSpaceCrossEntropyImportanceSampling_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm used to update auxiliary distribution parameters.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
        """
        return _experimental.PhysicalSpaceCrossEntropyImportanceSampling_getOptimizationAlgorithm(self)

    def __init__(self, *args):
        _experimental.PhysicalSpaceCrossEntropyImportanceSampling_swiginit(self, _experimental.new_PhysicalSpaceCrossEntropyImportanceSampling(*args))
    __swig_destroy__ = _experimental.delete_PhysicalSpaceCrossEntropyImportanceSampling

# Register PhysicalSpaceCrossEntropyImportanceSampling in _experimental:
_experimental.PhysicalSpaceCrossEntropyImportanceSampling_swigregister(PhysicalSpaceCrossEntropyImportanceSampling)
class StudentCopula(openturns.model_copula.SklarCopula):
    r"""
    Student copula.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        Generalised number degrees of freedom.
    R : :class:`~openturns.CorrelationMatrix` :math:`\mat{R} \in  \cM_{d \times d}(\Rset)`, optional
        If :math:`\nu > 2`: correlation matrix.
        If :math:`\nu \leq 2`: generalized correlation matrix.
        By default the identity matrix.

    Notes
    -----
    The Student copula is a multivariate copula defined by:

    .. math::

        C(u_1, \cdots, u_n) = \boldsymbol{t}_{\nu,\mat{R}}(\boldsymbol{t}_{\nu}^{-1}(u_1),
                                                   \cdots, \boldsymbol{t}_{\nu}^{-1}(u_n))

    where :math:`\boldsymbol{t}_{\nu,\mat{R}}` is the cumulative distribution
    function of the Student distribution with zero mean,
    unit marginal variances and correlation :math:`\mat{R}`

    for :math:`(u_1, \cdots, u_n) \in [0, 1]^n`

    See also
    --------
    Student, SklarCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> R = ot.CorrelationMatrix([[1.0, 0.5], [0.5, 1.0]])
    >>> copula = otexp.StudentCopula(2.5, R)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.StudentCopula_getClassName(self)

    def __repr__(self):
        return _experimental.StudentCopula___repr__(self)

    def __str__(self, *args):
        return _experimental.StudentCopula___str__(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _experimental.StudentCopula_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _experimental.StudentCopula_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _experimental.StudentCopula_getParameterDescription(self)

    def setNu(self, nu):
        r"""
        Accessor to the distribution's generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Generalised number degrees of freedom.
        """
        return _experimental.StudentCopula_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the distribution's generalised number degrees of freedom.

        Returns
        -------
        nu : float
            Generalised number degrees of freedom.
        """
        return _experimental.StudentCopula_getNu(self)

    def setR(self, R):
        r"""
        Accessor to the correlation matrix.

        Parameters
        ----------
        R : 2-d sequence of float
            Correlation matrix :math:`\mat{R}`.
        """
        return _experimental.StudentCopula_setR(self, R)

    def getR(self):
        r"""
        Accessor to the correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R}`.
        """
        return _experimental.StudentCopula_getR(self)

    def __init__(self, *args):
        _experimental.StudentCopula_swiginit(self, _experimental.new_StudentCopula(*args))
    __swig_destroy__ = _experimental.delete_StudentCopula

# Register StudentCopula in _experimental:
_experimental.StudentCopula_swigregister(StudentCopula)
class StudentCopulaFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Student copula factory.

    This class implements the method described in [peng2014]_.
    It consists in inferring the correlation matrix and then estimating the
    :math:`\nu` parameter via profiled likelihood maximization.

    Notes
    -----
    The following :class:`~openturns.ResourceMap` entries can be used to tweak
    the optimization step:

    - `StudentCopulaFactory-MaximumAbsoluteError`
    - `StudentCopulaFactory-MaximumConstraintError`
    - `StudentCopulaFactory-MaximumObjectiveError`
    - `StudentCopulaFactory-MaximumRelativeError`
    - `StudentCopulaFactory-NuMin`
    - `StudentCopulaFactory-NuMax`
    - `StudentCopulaFactory-NuStart`
    - `StudentCopulaFactory-DefaultOptimizationAlgorithm`
    - `StudentCopulaFactory-MaximumEvaluationNumber`

    See also
    --------
    DistributionFactory, StudentCopula

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.StudentCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _experimental.StudentCopulaFactory_build(self, *args)

    def buildAsStudentCopula(self, *args):
        return _experimental.StudentCopulaFactory_buildAsStudentCopula(self, *args)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the optimization solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for the optimization of the log-likelihood.

        """
        return _experimental.StudentCopulaFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for the optimization of the log-likelihood.
        """
        return _experimental.StudentCopulaFactory_getOptimizationAlgorithm(self)

    def __init__(self, *args):
        _experimental.StudentCopulaFactory_swiginit(self, _experimental.new_StudentCopulaFactory(*args))
    __swig_destroy__ = _experimental.delete_StudentCopulaFactory

# Register StudentCopulaFactory in _experimental:
_experimental.StudentCopulaFactory_swigregister(StudentCopulaFactory)
class TruncatedOverMesh(openturns.model_copula.ContinuousDistribution):
    r"""
    Truncated distribution over a mesh.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    dist : :class:`~openturns.Distribution`
        Distribution to truncate
    mesh : :class:`~openturns.Mesh`
        Mesh defining the domain of the distribution.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{|\cD|}, \quad x \in \cD

    with :math:`\cD\subset\Rset^n` a mesh of dimension :math:`n`.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> f = ot.SymbolicFunction(['x', 'y'], ['sin(x) * sin(y)'])
    >>> levelSet = ot.LevelSet(f, ot.Less(), 0.2)
    >>> box = ot.Interval([-5.0] * 2, [5.0] * 2)
    >>> mesh = ot.LevelSetMesher([50]*2).build(levelSet, box, False)
    >>> dist = ot.Normal([0] * 2, [2] * 2)
    >>> distribution = otexp.TruncatedOverMesh(dist, mesh)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.TruncatedOverMesh_getClassName(self)

    def __eq__(self, *args):
        return _experimental.TruncatedOverMesh___eq__(self, *args)

    def __repr__(self):
        return _experimental.TruncatedOverMesh___repr__(self)

    def __str__(self, *args):
        return _experimental.TruncatedOverMesh___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _experimental.TruncatedOverMesh_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _experimental.TruncatedOverMesh_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _experimental.TruncatedOverMesh_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _experimental.TruncatedOverMesh_computeCDF(self, *args)

    def setMesh(self, mesh):
        r"""
        Accessor to the distribution's mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh.
        """
        return _experimental.TruncatedOverMesh_setMesh(self, mesh)

    def getMesh(self):
        r"""
        Accessor to the distribution's mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh.
        """
        return _experimental.TruncatedOverMesh_getMesh(self)

    def __init__(self, *args):
        _experimental.TruncatedOverMesh_swiginit(self, _experimental.new_TruncatedOverMesh(*args))
    __swig_destroy__ = _experimental.delete_TruncatedOverMesh

# Register TruncatedOverMesh in _experimental:
_experimental.TruncatedOverMesh_swigregister(TruncatedOverMesh)
class UniformOverMesh(openturns.model_copula.ContinuousDistribution):
    r"""
    UniformOverMesh distribution.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        Mesh defining the domain of the distribution.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{|\cD|}, \quad x \in \cD

    with :math:`\cD\subset\Rset^n` a mesh of dimension :math:`n`.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> f = ot.SymbolicFunction(['x', 'y'], ['sin(x)*sin(y)'])
    >>> levelSet = ot.LevelSet(f, ot.Less(), 0.2)
    >>> box = ot.Interval([-5.0]*2, [5.0]*2)
    >>> mesh = ot.LevelSetMesher([50]*2).build(levelSet, box, False)
    >>> distribution = otexp.UniformOverMesh(mesh)

    Draw a sample:

    >>> sample = distribution.getSample(5)

    Explore some of the attributes:

    >>> mesh = distribution.getMesh()
    >>> algo = distribution.getIntegrationAlgorithm()
    >>> distribution.setIntegrationAlgorithm(ot.GaussLegendre([10] * 2))
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.UniformOverMesh_getClassName(self)

    def __eq__(self, *args):
        return _experimental.UniformOverMesh___eq__(self, *args)

    def __repr__(self):
        return _experimental.UniformOverMesh___repr__(self)

    def __str__(self, *args):
        return _experimental.UniformOverMesh___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _experimental.UniformOverMesh_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _experimental.UniformOverMesh_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _experimental.UniformOverMesh_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _experimental.UniformOverMesh_computeCDF(self, *args)

    def setMesh(self, mesh):
        r"""
        Accessor to the distribution's mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh.
        """
        return _experimental.UniformOverMesh_setMesh(self, mesh)

    def getMesh(self):
        r"""
        Accessor to the distribution's mesh.

        Returns
        -------
        mesh : ;class:`~openturns.Mesh`
            Mesh.
        """
        return _experimental.UniformOverMesh_getMesh(self)

    def setIntegrationAlgorithm(self, integrationAlgorithm):
        r"""
        Accessor to the integration algorithm used to compute the CDF.

        Parameters
        ----------
        algo : :class:`~openturns.IntegrationAlgorithm`
            Integration algorithm used to compute the CDF. Default value is
            :class:`~openturns.GaussLegendre` with a marginal integration node number
            specified by the `UniformOverMesh-MarginalIntegrationNodesNumber` key in
            :class:`~openturns.ResourceMap` if the total number of nodes doesn't exceed
            a value specified by the `UniformOverMesh-MaximumIntegrationNodesNumber` key
            in :class:`~openturns.ResourceMap`, otherwise the marginal integration node
            number is decreased.
        """
        return _experimental.UniformOverMesh_setIntegrationAlgorithm(self, integrationAlgorithm)

    def getIntegrationAlgorithm(self):
        r"""
        Accessor to the integration algorithm used to compute the CDF.

        Returns
        -------
        algo : :class:`~openturns.IntegrationAlgorithm`
            Integration algorithm used to compute the CDF. Default value is
            :class:`~openturns.GaussLegendre` with a marginal integration node number
            specified by the `UniformOverMesh-MarginalIntegrationNodesNumber` key in
            :class:`~openturns.ResourceMap` if the total number of nodes doesn't exceed
            a value specified by the `UniformOverMesh-MaximumIntegrationNodesNumber` key
            in :class:`~openturns.ResourceMap`, otherwise the marginal integration node
            number is decreased.:class:`~openturns.IteratedQuadrature`.
        """
        return _experimental.UniformOverMesh_getIntegrationAlgorithm(self)

    def __init__(self, *args):
        _experimental.UniformOverMesh_swiginit(self, _experimental.new_UniformOverMesh(*args))
    __swig_destroy__ = _experimental.delete_UniformOverMesh

# Register UniformOverMesh in _experimental:
_experimental.UniformOverMesh_swigregister(UniformOverMesh)
class PosteriorDistribution(openturns.model_copula.ContinuousDistribution):
    r"""
    Distribution conditioned by observations.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    conditional : :class:`~openturns.ConditionalDistribution`
        The distribution of density :math:`f_{\vect{X}}(\vect{x}) = \int f_{\vect{X}|\vect{\Theta}=\vect{y}}(\vect{x}|\vect{y}) f_{\vect{Y}}(\vect{y})\di{\vect{y}}`.
    observations : 2-d sequence of float
        Observations :math:`x_i`.

    See also
    --------
    ConditionalDistribution, MetropolisHastings

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{\vect{Y}|\vect{X}=\vect{x}}(\vect{y}) = \frac{f_{\vect{Y}}(\vect{y})\prod_{i=1}^n f_{X|\vect{\Theta}=\vect{y}}(x_i)}{\int f_{\vect{Y}}(\vect{y}')\prod_{i=1}^n f_{X|\vect{\Theta}=\vect{y}'}(x_i) d \vect{y}'}

    with :math:`f_{\vect{X}|\vect{\Theta}}` the PDF of the conditioned distribution,
    :math:`f_{\vect{Y}}` the PDF of the conditioning distribution :math:`\vect{Y}`,
    :math:`x_i` the observations of the conditional distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> ot.RandomGenerator.SetSeed(0)
    >>> conditionedDistribution = ot.Normal()
    >>> # Conditional distribution
    >>> atoms = [ot.Uniform(0.0, 1.0), ot.Uniform(1.0, 2.0)]
    >>> conditioning = ot.ComposedDistribution(atoms)
    >>> conditional = ot.ConditionalDistribution(conditionedDistribution, conditioning)
    >>> # Observations
    >>> observationsSize = 5
    >>> observationsDistribution = ot.Distribution(conditionedDistribution)
    >>> observationsDistribution.setParameter(conditioning.getMean())
    >>> observations = observationsDistribution.getSample(observationsSize)
    >>> # Posterior distribution
    >>> distribution = otexp.PosteriorDistribution(conditional, observations)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.PosteriorDistribution_getClassName(self)

    def __eq__(self, *args):
        return _experimental.PosteriorDistribution___eq__(self, *args)

    def __repr__(self):
        return _experimental.PosteriorDistribution___repr__(self)

    def __str__(self, *args):
        return _experimental.PosteriorDistribution___str__(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _experimental.PosteriorDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _experimental.PosteriorDistribution_computeCDF(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _experimental.PosteriorDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _experimental.PosteriorDistribution_setParametersCollection(self, *args)

    def setConditionalDistribution(self, conditionalDistribution):
        r"""
        Conditional distribution accessor.

        Parameters
        ----------
        conditional : :class:`~openturns.ConditionalDistribution`
            The conditional distribution.
        """
        return _experimental.PosteriorDistribution_setConditionalDistribution(self, conditionalDistribution)

    def getConditionalDistribution(self):
        r"""
        Conditional distribution accessor.

        Returns
        -------
        conditional : :class:`~openturns.ConditionalDistribution`
            The conditional distribution.
        """
        return _experimental.PosteriorDistribution_getConditionalDistribution(self)

    def setObservations(self, observations):
        r"""
        Accessor to the observations.

        Parameters
        ----------
        observations : 2-d sequence of float
            Observations.
        """
        return _experimental.PosteriorDistribution_setObservations(self, observations)

    def getObservations(self):
        r"""
        Accessor to the observations.

        Returns
        -------
        observations : :class:`~openturns.Sample`
            Observations.
        """
        return _experimental.PosteriorDistribution_getObservations(self)

    def getLogNormalizationFactor(self):
        r"""
        Normalization factor accessor.

        Returns
        -------
        factor : float
            Log-scale normalization factor.
        """
        return _experimental.PosteriorDistribution_getLogNormalizationFactor(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _experimental.PosteriorDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _experimental.PosteriorDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _experimental.PosteriorDistribution_getKurtosis(self)

    def __init__(self, *args):
        _experimental.PosteriorDistribution_swiginit(self, _experimental.new_PosteriorDistribution(*args))
    __swig_destroy__ = _experimental.delete_PosteriorDistribution

# Register PosteriorDistribution in _experimental:
_experimental.PosteriorDistribution_swigregister(PosteriorDistribution)
class SmolyakExperiment(openturns.weightedexperiment.WeightedExperimentImplementation):
    r"""
    Smolyak experiment.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    experiments : list of :class:`~openturns.WeightedExperiment`
        List of :math:`n` marginal experiments of the Smolyak experiment.
        Each marginal experiment must have dimension 1.
    level : int
        Level value :math:`\ell \geq 1`.

    Notes
    -----
    The Smolyak design of experiments (DOE) is based on a collection
    of marginal multidimensional elementary designs of experiments.
    Compared to the :class:`~openturns.TensorProductExperiment`, the
    Smolyak experiment has a significantly lower number of nodes [petras2003]_.
    This implementation uses the combination technique ([gerstner1998]_ page 215).
    Smolyak quadrature involve weights which are negative ([sullivan2015]_ page 177).
    The size of the experiment is only known after the nodes and weights have been computed,
    that is, after the :meth:`~openturns.experimental.SmolyakExperiment.generateWithWeights` method is called.

    **Method**

    Let :math:`\mathcal{X} \subset \mathbb{R}^{d_x}` be the integration domain 
    and let :math:`g : \mathcal{X} \rightarrow \mathbb{R}^{d_y}` be an integrable 
    function. 
    Let :math:`f : \mathcal{X} \rightarrow \mathbb{R}` be a probability density function.
    The Smolyak experiment produces an approximation of the integral:

    .. math::

        \int_{\mathcal{X}} g(\vect{x}) f(\vect{x}) d\vect{x}
        \approx \sum_{i = 1}^{s_t} w_i g\left(\vect{x}_i\right)

    where :math:`s_t \in \mathbb{N}` is the size of the Smolyak
    design of experiments, :math:`w_1, ..., w_{s_t} \in \mathbb{R}` are the
    weights and :math:`\vect{x}_1, ..., \vect{x}_{s_t} \in \mathbb{R}^{d_x}`
    are the nodes. 

    Let :math:`\vect{k} = (k_1, ..., k_{d_x}) \in (\mathbb{N}^\star)^{d_x}` 
    be the multi-index where

    .. math::

        \mathbb{N}^\star = \{1, 2, ... \}

    is the set of natural numbers without zero.
    Consider the 1 and the infinity norms ([lemaitre2010]_ page 57, eq. 3.28):

    .. math::

        \|\vect{k}\|_1 = \sum_{i = 1}^{d_x} k_i \qquad
        \|\vect{k}\|_\infty = \max_{i = 1, ..., d_x} k_i.

    for any :math:`\vect{k} \in (\mathbb{N}^\star)^{d_x}`.

    Let :math:`\ell` be an integer representing the level of the quadrature.
    Let :math:`Q_{\ell}^{(1)}` be a marginal quadrature of level :math:`\ell`.
    This marginal quadrature must have dimension 1 as is suggested by the exponent in the
    notation :math:`Q_{\ell}^{(1)}`.
    Depending on the level :math:`\ell`, we can compute the actual number of nodes
    depending on a particular choice of that number of nodes and depending
    on the quadrature rule.
    The tensor product quadrature is:

    .. math::

        T_\ell^{(d_x)} = Q_{\ell}^{(1)} \otimes ... \otimes Q_{\ell}^{(1)}.

    In the previous equation, the marginal quadratures are not necessarily 
    of the same type. 
    For example, if the dimension is equal to 2, the first marginal quadrature may 
    be a Gaussian quadrature while the second one may be a random experiment, such 
    as a Monte-Carlo design of experiment.

    Let :math:`Q_0^{(1)} = \emptyset` be the empty quadrature. 
    For any integer :math:`k \in \mathbb{N}`, let :math:`\Delta_k^{(1)}` be the 
    difference quadrature defined by:

    .. math::

        \Delta_{k}^{(1)} = Q_{k}^{(1)} - Q_{k - 1}^{(1)}.    

    Therefore, the quadrature formula :math:`Q_\ell` can be expressed depending
    on difference quadratures:

    .. math::

        Q_\ell^{(1)} = \sum_{k = 1}^\ell \Delta_k^{(1)}.

    for any :math:`\ell \geq 1`. 

    The following equation provides an equivalent equation for the tensor product
    quadrature ([lemaitre2010]_ page 57, eq. 3.30):

    .. math::

        T_\ell^{(d_x)} = \sum_{\|\vect{k}\|_\infty \leq \ell}
        \Delta_{k_1}^{(1)} \otimes \cdots \otimes \Delta_{k_{d_x}}^{(1)}.

    The significant part of the previous equation is the set of multi-indices
    :math:`\|\vect{k}\|_\infty \leq \ell`, which may be very large
    depending on the dimension of the problem.

    One of the ways to reduce the size of this set is to consider the smaller set
    of multi-indices such that :math:`\|\vect{k}\|_1 \leq \ell + {d_x} - 1`. The sparse
    quadrature ([lemaitre2010]_ page 57, eq. 3.29, [gerstner1998]_  page 214)
    is introduced in the following definition.

    The Smolyak sparse quadrature formula at level :math:`\ell` is:

    .. math::

        S_\ell^{(d_x)} = \sum_{\|\vect{k}\|_1 \leq \ell + d_x - 1} 
        \Delta_{k_1}^{(1)} \otimes \cdots \otimes \Delta_{k_{d_x}}^{(1)}

    for any :math:`\ell \geq 1`. 

    As shown by the previous equation, for a given multi-index :math:`\vect{k}`
    the Smolyak quadrature requires to set the level of each marginal experiment to
    an integer which depends on the multi-index.
    This is done using the :meth:`~openturns.experimental.SmolyakExperiment.setLevel` method of the marginal quadrature.

    The following formula expresses the multivariate quadrature in terms of
    combinations univariate quadratures, known as the *combination technique*.
    This method combines elementary tensorized quadratures, summing them
    depending on the binomial coefficient.
    The sparse quadrature formula at level :math:`\ell` is:

    .. math::

        S_\ell^{(d_x)} = \sum_{\ell \leq \|\vect{k}\|_1 \leq \ell + d_x - 1} 
        (-1)^{\ell + d_x - \|\vect{k}\|_1 - 1} 
        {d_x - 1 \choose \|\vect{k}\|_1 - \ell} 
        Q_{k_1}^{(1)} \otimes \cdots \otimes Q_{k_{d_x}}^{(1)}

    for any :math:`\ell \geq 1` where the binomial coefficient is:

    .. math::

        {n \choose m} = \frac{n!}{m! (n - m)!}

    for any integers :math:`n \geq 0` and :math:`0 \leq m \leq n`.

    **Merge duplicate nodes**

    The Smolyak quadrature requires to merge the potentially duplicated nodes of the
    elementary quadratures.
    To do so, a dictionary is used so that unique nodes only are kept.
    This algorithm is enabled by default, but it can be disabled with the
    `SmolyakExperiment-MergeQuadrature` boolean key of the :class:`~openturns.ResourceMap`.
    This can reduce the number of nodes, which may be particularly efficient when the
    marginal quadrature rule is nested such as, for example, with Fejér or Clenshaw-Curtis
    quadrature rule.

    If two candidate nodes :math:`\vect{x}_1, \vect{x}_2 \in \mathbb{R}^{d_x}`,
    associated with the two weights :math:`w_1, w_2 \in \mathbb{R}`, are to be merged,
    then the merged node is

    .. math::

        \vect{x}_1' = \vect{x}_1

    and the merged weight is:


    .. math::

        w_1' = w_1 + w_2.

    If, however, the elementary quadrature rules have nodes which are computed up to some
    rounding error, the merging algorithm may not detect that two nodes which are
    close to each other are, indeed, the same.
    This is why rounding errors must be taken into account.
    Let :math:`\epsilon_r, \epsilon_a > 0` be the relative and absolute tolerances.
    These parameters can be set using the :class:`~openturns.ResourceMap` keys
    `SmolyakExperiment-MergeRelativeEpsilon` and `SmolyakExperiment-MergeAbsoluteEpsilon`.
    The criterion is based on a mixed absolute and relative tolerance.
    Two candidate nodes :math:`\vect{x}_1, \vect{x}_2 \in \mathbb{R}^{d_x}`
    are close to each other and are to be merged if:

    .. math::

        |(x_1)_i - (y_1)_i| \leq \delta_i

    for :math:`i = 1, ..., d_x`, where :math:`\delta_i` is equal to:

    .. math::

        \delta_i = \epsilon_a + \epsilon_r
        \max\left(\left|(x_1)_i\right|, \left|(y_1)_i\right|\right).

    If the bounds of the input distribution are either very close to zero
    or very large, then the default settings may not work properly: in this case,
    please fine tune the parameters to match your needs.

    **Accuracy**

    The following equation presents the absolute error of a sparse
    quadrature ([sullivan2015]_ page 177, eq. 9.10).
    Assume that :math:`g \in \mathcal{C}^r([0, 1]^{d_x})` and that we use a sparse
    quadrature with :math:`n_\ell` nodes at level :math:`\ell`.
    In this particular case, the probability density function :math:`f` is
    equal to 1. 
    Therefore,

    .. math::

        \left|\int_{[0, 1]^{d_x}} g(\vect{x}) d\vect{x} 
        - S_\ell(g)\right|
        = O \left(n_\ell^{-r} (\log(n_\ell))^{(d_x - 1)(r + 1)}\right).

    See also
    --------
    WeightedExperiment

    Examples
    --------
    In the following example, we create Smolyak quadrature using two Gauss-Legendre
    marginal quadratures.

    >>> import openturns as ot
    >>> import openturns.experimental as otexp
    >>> experiment1 = ot.GaussProductExperiment(ot.Uniform(0.0, 1.0))
    >>> experiment2 = ot.GaussProductExperiment(ot.Uniform(0.0, 1.0))
    >>> collection = [experiment1, experiment2]
    >>> level = 3
    >>> multivariate_experiment = otexp.SmolyakExperiment(collection, level)
    >>> nodes, weights = multivariate_experiment.generateWithWeights()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.SmolyakExperiment_getClassName(self)

    def __repr__(self):
        return _experimental.SmolyakExperiment___repr__(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _experimental.SmolyakExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _experimental.SmolyakExperiment_generateWithWeights(self)

    def generate(self):
        r"""
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Points :math:`(\Xi_i)_{i \in I}` which constitute the design of experiments
            with :math:`card I = size`. The sampling method is defined by the nature of
            the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _experimental.SmolyakExperiment_generate(self)

    def setExperimentCollection(self, coll):
        r"""
        Set the marginals of the experiment.

        Parameters
        ----------
        experiments : list of :class:`~openturns.WeightedExperiment`
            List of the marginals of the experiment.
        """
        return _experimental.SmolyakExperiment_setExperimentCollection(self, coll)

    def getExperimentCollection(self):
        r"""
        Get the marginals of the experiment.

        Returns
        -------
        experiments : list of :class:`~openturns.WeightedExperiment`
            List of the marginals of the experiment.
        """
        return _experimental.SmolyakExperiment_getExperimentCollection(self)

    def setLevel(self, level):
        r"""
        Set the level of the experiment.

        Parameters
        ----------
        level : int
            Level value :math:`\ell \geq 1`.
        """
        return _experimental.SmolyakExperiment_setLevel(self, level)

    def getLevel(self):
        r"""
        Get the level of the experiment.

        Returns
        -------
        level : int
            Level value :math:`\ell \geq 1`.
        """
        return _experimental.SmolyakExperiment_getLevel(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _experimental.SmolyakExperiment_setSize(self, size)

    def getSize(self):
        r"""
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _experimental.SmolyakExperiment_getSize(self)

    def computeCombination(self):
        r"""
        Compute the indices involved in the quadrature.

        Returns
        -------
        indicesCollection : list of :class:`~openturns.IndicesCollection`
            List of the multi-indices involved in Smolyak's quadrature.
        """
        return _experimental.SmolyakExperiment_computeCombination(self)

    def __init__(self, *args):
        _experimental.SmolyakExperiment_swiginit(self, _experimental.new_SmolyakExperiment(*args))
    __swig_destroy__ = _experimental.delete_SmolyakExperiment

# Register SmolyakExperiment in _experimental:
_experimental.SmolyakExperiment_swigregister(SmolyakExperiment)
class GeneralizedExtremeValueValidation(openturns.common.PersistentObject):
    r"""
    Validation of GeneralizedExtremeValue inference.

    .. warning::
        This class is experimental and likely to be modified in future releases.
        To use it, import the ``openturns.experimental`` submodule.

    Parameters
    ----------
    result : :class:`~openturns.DistributionFactoryResult`
        Inference result to validate.
    sample : 2-d sequence of float
        Data on which the inference was performed.

    See also
    --------
    GeneralizedExtremeValueFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experimental.GeneralizedExtremeValueValidation_getClassName(self)

    def drawReturnLevel(self):
        r"""
        Draw the return level with confidence interval.

        The *return level* plot consists of the points:

        .. math::
            \left\{ \left( m, \hat{z}_m\right), m >0 \right\}

        and the points:

        .. math::
            \left\{ \left( m, z_{m}^{emp}\right), m> 0\right\}

        where :math:`z_{m}^{emp}` is the empirical :math:`m`-block return level and :math:`\hat{z}_{m}` the 
        :math:`m`-block return level calculated with the fitted GEV.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The return level graph.

        """
        return _experimental.GeneralizedExtremeValueValidation_drawReturnLevel(self)

    def drawPDF(self):
        r"""
        Draw the estimated density and the data histogram.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The estimated density and the data histogram.

        """
        return _experimental.GeneralizedExtremeValueValidation_drawPDF(self)

    def drawDiagnosticPlot(self):
        r"""
        Draw the 4 usual diagnostic plots.

        The 4 graphs are the *probability-probability* plot, the *quantile-quantile* plot, the *return level* plot, the data histogram with the fitted model density.


        If :math:`(z_{(1)} \leq z_{(2)} \leq \dots \leq z_{(n)})` denotes the ordered block maximum data and :math:`\hat{G}` the cumulative distribution function of the GEV distribution fitted on the data, the graphs are defined as follows.

        The *probability-probability* plot consists of the points:

        .. math::
            \left\{ \left( i/(n+1), \hat{G}(z_{(i)}) \right), i=1, \dots , m\right\}


        The *quantile-quantile* plot consists of the points:

        .. math::
            \left\{  \left(  z_{(i)},  \hat{G}^{-1}(i/(n+1))  \right), i=1, \dots , n\right\} 

        The *return level* plot consists of the points:

        .. math::
            \left\{ \left( m, \hat{z}_m\right), m> 0\right\}

        and the points:

        .. math::
            \left\{ \left( m, z_{m}^{emp}\right), m> 0\right\}

        where :math:`z_{m}^{emp}` is the empirical :math:`m`-block return level and :math:`\hat{z}_{m}` the 
        :math:`m`-block return level calculated with the fitted GEV.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Returns a grid of 4 graphs:
             - the QQ-plot,
             - the PP-plot,
             - the return level graph (with confidence lines),
             - the density graph.

        """
        return _experimental.GeneralizedExtremeValueValidation_drawDiagnosticPlot(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Confidence level accessor.

        Parameters
        ----------
        level : float
            Confidence level for the confidence lines.

        """
        return _experimental.GeneralizedExtremeValueValidation_setConfidenceLevel(self, confidenceLevel)

    def getConfidenceLevel(self):
        r"""
        Confidence level accessor.

        Returns
        -------
        level : float
            Confidence level for the confidence lines.

        """
        return _experimental.GeneralizedExtremeValueValidation_getConfidenceLevel(self)

    def __repr__(self):
        return _experimental.GeneralizedExtremeValueValidation___repr__(self)

    def __init__(self, *args):
        _experimental.GeneralizedExtremeValueValidation_swiginit(self, _experimental.new_GeneralizedExtremeValueValidation(*args))
    __swig_destroy__ = _experimental.delete_GeneralizedExtremeValueValidation

# Register GeneralizedExtremeValueValidation in _experimental:
_experimental.GeneralizedExtremeValueValidation_swigregister(GeneralizedExtremeValueValidation)

