/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class RegimViewer
extends JPanel {
    private PnmImage refpnm;
    private int vw;
    private int vh;
    private Image refimg;
    private Image jpipImg;
    private double[] affine_matrix;
    private AffineTransform affine;

    public RegimViewer(String string, double[] dArray) {
        this.refpnm = new PnmImage(string.replaceFirst("jp2", "pgm"));
        this.affine_matrix = new double[6];
        this.affine_matrix[0] = dArray[0];
        this.affine_matrix[1] = dArray[3];
        this.affine_matrix[2] = dArray[1];
        this.affine_matrix[3] = dArray[4];
        this.affine_matrix[4] = dArray[2];
        this.affine_matrix[5] = dArray[5];
        this.affine = new AffineTransform();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                System.out.print(dArray[i * 3 + j] + " ");
            }
            System.out.println();
        }
    }

    public void projection(Image image, double d) {
        this.jpipImg = image;
        this.refimg = this.refpnm.createScaleImage(d);
        this.vw = this.refimg.getWidth(this);
        this.vh = this.refimg.getHeight(this);
        this.setSize(this.vw, this.vh);
        this.affine.setTransform(this.affine_matrix[0], this.affine_matrix[1], this.affine_matrix[2], this.affine_matrix[3], this.affine_matrix[4], this.affine_matrix[5]);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clearRect(0, 0, this.vw, this.vh);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int n = this.refimg.getWidth(this);
        int n2 = this.refimg.getHeight(this);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.drawImage(this.refimg, 0, 0, this);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
        BufferedImage bufferedImage2 = new BufferedImage(this.jpipImg.getWidth(this), this.jpipImg.getHeight(this), 1);
        Graphics2D graphics2D3 = bufferedImage2.createGraphics();
        graphics2D3.drawImage(this.jpipImg, 0, 0, this);
        graphics2D.setTransform(this.affine);
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, this);
    }

    public Dimension get_imsize() {
        return new Dimension(this.vw, this.vh);
    }
}

