/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.List;
import java.util.Map;

public class JPIPHttpClient {
    private String comURL;
    protected int fw;
    protected int fh;
    protected int rx;
    protected int ry;
    protected int rw;
    protected int rh;
    protected String cid;
    protected String tid;
    private boolean JPTstream;
    private boolean JPPstream;
    private boolean aux;
    private boolean tcp;
    private int port;

    public JPIPHttpClient(String string) {
        this.comURL = string + "?";
        this.fh = -1;
        this.fw = -1;
        this.ry = -1;
        this.rx = -1;
        this.rh = -1;
        this.rw = -1;
        this.cid = null;
        this.tid = null;
        this.aux = false;
        this.JPPstream = false;
        this.JPTstream = false;
        this.port = 0;
    }

    public int getFw() {
        return this.fw;
    }

    public int getFh() {
        return this.fh;
    }

    public int getRx() {
        return this.rx;
    }

    public int getRy() {
        return this.ry;
    }

    public int getRw() {
        return this.rw;
    }

    public int getRh() {
        return this.rh;
    }

    public byte[] requestViewWindow(int n, int n2) {
        if (this.cid != null) {
            return this.requestViewWindow(n, n2, this.cid);
        }
        return null;
    }

    public byte[] requestViewWindow(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.cid != null) {
            return this.requestViewWindow(n, n2, n3, n4, n5, n6, this.cid);
        }
        if (this.tid != null) {
            return this.requestViewWindow(null, this.tid, n, n2, n3, n4, n5, n6, null, false, 0, false, false);
        }
        return null;
    }

    public byte[] requestViewWindow(int n, int n2, String string) {
        return this.requestViewWindow(null, null, n, n2, -1, -1, -1, -1, string, false, 0, false, false);
    }

    public byte[] requestViewWindow(int n, int n2, int n3, int n4, int n5, int n6, String string) {
        return this.requestViewWindow(null, null, n, n2, n3, n4, n5, n6, string, false, 0, false, false);
    }

    public byte[] requestViewWindow(String string, int n, int n2) {
        return this.requestViewWindow(string, null, n, n2, -1, -1, -1, -1, null, false, 0, false, false);
    }

    public byte[] requestViewWindow(String string, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3) {
        if (this.cid == null) {
            return this.requestViewWindow(string, null, n, n2, -1, -1, -1, -1, null, bl, n3, bl2, bl3);
        }
        return null;
    }

    public byte[] requestViewWindow(String string, String string2, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3) {
        if (this.cid == null) {
            return this.requestViewWindow(string, string2, n, n2, -1, -1, -1, -1, null, bl, n3, bl2, bl3);
        }
        return null;
    }

    public byte[] requestViewWindow(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.requestViewWindow(string, null, n, n2, n3, n4, n5, n6, null, false, 0, false, false);
    }

    public byte[] requestViewWindow(int n, int n2, String string, boolean bl, int n3, boolean bl2, boolean bl3) {
        return this.requestViewWindow(null, null, n, n2, -1, -1, -1, -1, string, bl, n3, bl2, bl3);
    }

    public byte[] requestViewWindow(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, String string3, boolean bl, int n7, boolean bl2, boolean bl3) {
        if (string2 != null) {
            this.tid = string2;
        }
        String string4 = this.const_urlstring(string, string2, n, n2, n3, n4, n5, n6, string3, bl, n7, bl2, bl3);
        return this.GETrequest(string4);
    }

    public byte[] requestXML() {
        String string = this.comURL;
        if (this.cid == null) {
            return null;
        }
        string = string.concat("cid=" + this.cid);
        string = string.concat("&metareq=[xml_]");
        return this.GETrequest(string);
    }

    private byte[] GETrequest(String string) {
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        byte[] byArray = null;
        try {
            uRL = new URL(string);
            System.err.println("Requesting: " + uRL);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.connect();
            this.set_responseheader(httpURLConnection);
            if (!this.aux) {
                byArray = JPIPHttpClient.receive_httpchunk(httpURLConnection);
                httpURLConnection.disconnect();
            } else {
                httpURLConnection.disconnect();
                byArray = JPIPHttpClient.receive_tcpaux(this.comURL.substring(7, this.comURL.indexOf(47, 7)), this.port, this.cid);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (ProtocolException protocolException) {
            protocolException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (UnknownServiceException unknownServiceException) {
            unknownServiceException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private void set_responseheader(HttpURLConnection httpURLConnection) {
        List<String> list;
        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
        String string = map.get(null).get(0);
        System.err.println(string);
        if (!string.contains("OK")) {
            System.err.println(map.get("Reason"));
        }
        if ((list = map.get("Content-type")) == null) {
            list = map.get("Content-Type");
        }
        String string2 = list.get(0);
        System.err.println(string2);
        if (string2.endsWith("jpt-stream")) {
            this.JPTstream = true;
        } else if (string2.endsWith("jpp-stream")) {
            this.JPPstream = true;
        }
        list = map.get("JPIP-fsiz");
        if (list != null) {
            string2 = list.get(0);
            this.fw = Integer.valueOf(string2.substring(0, string2.indexOf(44)));
            this.fh = Integer.valueOf(string2.substring(string2.indexOf(44) + 1));
            System.err.println("fw,fh: " + this.fw + "," + this.fh);
        }
        if ((list = map.get("JPIP-roff")) != null) {
            string2 = list.get(0);
            this.rx = Integer.valueOf(string2.substring(0, string2.indexOf(44)));
            this.ry = Integer.valueOf(string2.substring(string2.indexOf(44) + 1));
            System.err.println("rx,ry: " + this.rx + "," + this.ry);
        }
        if ((list = map.get("JPIP-rsiz")) != null) {
            string2 = list.get(0);
            this.rw = Integer.valueOf(string2.substring(0, string2.indexOf(44)));
            this.rh = Integer.valueOf(string2.substring(string2.indexOf(44) + 1));
            System.err.println("rw,rh: " + this.rw + "," + this.rh);
        }
        if ((list = map.get("JPIP-cnew")) != null) {
            string2 = list.get(0);
            this.cid = string2.substring(string2.indexOf(61) + 1, string2.indexOf(44));
            int n = string2.indexOf("transport") + 10;
            int n2 = string2.indexOf(44, n);
            String string3 = n2 != -1 ? string2.substring(n, n2) : string2.substring(n);
            if (string3.matches("http-tcp")) {
                this.aux = true;
                this.tcp = true;
            } else if (string3.matches("http-udp")) {
                this.aux = true;
                this.tcp = false;
            } else {
                this.aux = false;
            }
            if (this.aux) {
                n = string2.indexOf("auxport") + 8;
                this.port = Integer.valueOf(string2.substring(n));
                System.err.println("cid: " + this.cid + ", transport: " + string3 + ", auxport: " + this.port);
            } else {
                System.err.println("cid: " + this.cid + ", transport: " + string3);
            }
        }
        if ((list = map.get("JPIP-tid")) != null) {
            string2 = list.get(0);
            this.tid = string2.substring(string2.indexOf(61) + 1);
            System.err.println("tid: " + this.tid);
        }
    }

    private static byte[] receive_httpchunk(HttpURLConnection httpURLConnection) {
        byte[] byArray = null;
        try {
            InputStream inputStream = httpURLConnection.getInputStream();
            if (inputStream.available() > 0) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[1024];
                System.err.println("reading jpipstream...");
                while ((n = inputStream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                    if (n > 0) continue;
                }
                int n2 = byteArrayOutputStream.size();
                byArray = byteArrayOutputStream.toByteArray();
                byArray2 = null;
                byteArrayOutputStream = null;
                System.err.println("jpiplen: " + n2);
                System.err.println("    succeeded");
            } else {
                System.err.println("No new jpipstream");
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] receive_tcpaux(String string, int n, String string2) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n2 = 8;
        try {
            int n3;
            Socket socket = new Socket(string, n);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byte[] byArray3 = new byte[n2];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream.writeBytes(string2 + "\r\n");
            do {
                JPIPHttpClient.read_stream(dataInputStream, byArray3, n2);
                n3 = ((byArray3[0] & 0xFF) << 8 | byArray3[1] & 0xFF) - n2;
                byArray = new byte[n3];
                JPIPHttpClient.read_stream(dataInputStream, byArray, n3);
                byteArrayOutputStream.write(byArray, 0, n3);
                dataOutputStream.write(byArray3, 0, n2);
            } while (byArray[n3 - 3] != 0 || byArray[n3 - 2] != 1 && byArray[n3 - 2] != 2);
            int n4 = byteArrayOutputStream.size();
            byArray2 = byteArrayOutputStream.toByteArray();
            System.err.println("jpiplen: " + n4);
            System.err.println("    succeeded");
            byArray = null;
            byteArrayOutputStream = null;
            dataOutputStream.close();
            dataInputStream.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray2;
    }

    private static void read_stream(InputStream inputStream, byte[] byArray, int n) {
        int n2 = 0;
        try {
            int n3;
            for (int i = n; i > 0; i -= n3) {
                n3 = inputStream.read(byArray, n2, i);
                if (n3 == -1) {
                    System.err.println("    failed to read_stream()");
                    break;
                }
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
    }

    private String const_urlstring(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, String string3, boolean bl, int n7, boolean bl2, boolean bl3) {
        String string4 = this.comURL;
        if (string != null) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("target=" + string);
        }
        if (string2 != null) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("tid=" + string2);
        }
        if (n != -1 && n2 != -1) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("fsiz=" + n + "," + n2);
        }
        if (n3 != -1 && n4 != -1) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("roff=" + n3 + "," + n4);
        }
        if (n5 != -1 && n6 != -1) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("rsiz=" + n5 + "," + n6);
        }
        if (string3 != null) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("cid=" + string3);
        }
        if (bl) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = n7 == 1 ? string4.concat("cnew=http-tcp") : (n7 == 2 ? string4.concat("cnew=http-udp") : string4.concat("cnew=http"));
        }
        if (bl2 && !this.JPTstream) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("type=jpp-stream");
        } else if (bl3 && !this.JPPstream) {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            string4 = string4.concat("type=jpt-stream");
        } else {
            if (!string4.endsWith("?")) {
                string4 = string4.concat("&");
            }
            if (this.JPTstream) {
                string4 = string4.concat("type=jpt-stream");
            } else if (this.JPPstream) {
                string4 = string4.concat("type=jpp-stream");
            }
        }
        return string4;
    }

    public void closeChannel() {
        if (this.cid == null) {
            return;
        }
        try {
            URL uRL = new URL(this.comURL + "cclose=" + this.cid);
            System.err.println("closing cid: " + this.cid);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.connect();
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            httpURLConnection.disconnect();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

