# Copyright (c) 2010-2023, Lawrence Livermore National Security, LLC. Produced
# at the Lawrence Livermore National Laboratory. All Rights reserved. See files
# LICENSE and NOTICE for details. LLNL-CODE-806117.
#
# This file is part of the MFEM library. For more information and source code
# availability visit https://mfem.org.
#
# MFEM is free software; you can redistribute it and/or modify it under the
# terms of the BSD-3 license. We welcome feedback and contributions, see file
# CONTRIBUTING.md for details.

# Variables corresponding to defines in config.hpp (YES, NO, or value)
MFEM_VERSION           = 40600
MFEM_VERSION_STRING    = 4.6.0
MFEM_SOURCE_DIR        = C:/M/B/src/mfem-4.6
MFEM_INSTALL_DIR       = /mingw64
MFEM_GIT_STRING        = (unknown)
MFEM_USE_MPI           = YES
MFEM_USE_METIS         = YES
MFEM_USE_METIS_5       = YES
MFEM_DEBUG             = NO
MFEM_USE_EXCEPTIONS    = NO
MFEM_USE_ZLIB          = YES
MFEM_USE_LIBUNWIND     = NO
MFEM_USE_LAPACK        = YES
MFEM_THREAD_SAFE       = NO
MFEM_USE_LEGACY_OPENMP = NO
MFEM_USE_OPENMP        = YES
MFEM_USE_MEMALLOC      = YES
MFEM_TIMER_TYPE        = 3
MFEM_USE_SUNDIALS      = YES
MFEM_USE_SUITESPARSE   = YES
MFEM_USE_SUPERLU       = NO
MFEM_USE_SUPERLU5      = NO
MFEM_USE_MUMPS         = NO
MFEM_USE_STRUMPACK     = NO
MFEM_USE_GINKGO        = NO
MFEM_USE_AMGX          = NO
MFEM_USE_GNUTLS        = NO
MFEM_USE_NETCDF        = YES
MFEM_USE_PETSC         = NO
MFEM_USE_SLEPC         = NO
MFEM_USE_MPFR          = YES
MFEM_USE_SIDRE         = NO
MFEM_USE_FMS           = NO
MFEM_USE_CONDUIT       = NO
MFEM_USE_PUMI          = NO
MFEM_USE_HIOP          = NO
MFEM_USE_GSLIB         = NO
MFEM_USE_CUDA          = NO
MFEM_USE_HIP           = NO
MFEM_USE_RAJA          = NO
MFEM_USE_OCCA          = NO
MFEM_USE_CEED          = NO
MFEM_USE_CALIPER       = NO
MFEM_USE_UMPIRE        = NO
MFEM_USE_SIMD          = NO
MFEM_USE_ADIOS2        = NO
MFEM_USE_MKL_CPARDISO  = NO
MFEM_USE_MKL_PARDISO   = OFF
MFEM_USE_MOONOLITH     = NO
MFEM_USE_ADFORWARD     = NO
MFEM_USE_CODIPACK      = NO
MFEM_USE_BENCHMARK     = NO
MFEM_USE_PARELAG       = NO
MFEM_USE_ENZYME        = NO

# Compiler, compile options, and link options
MFEM_CXX       = D:/a/msys64/mingw64/bin/g++.exe
MFEM_HOST_CXX  = D:/a/msys64/mingw64/bin/g++.exe
MFEM_CPPFLAGS  = 
MFEM_CXXFLAGS  = -std=c++14 -O3 -DNDEBUG -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -fopenmp
MFEM_TPLFLAGS  =  -ID:/a/msys64/mingw64/include -ID:/a/msys64/mingw64/include/suitesparse
MFEM_INCFLAGS  = -I$(MFEM_INC_DIR) $(MFEM_TPLFLAGS)
MFEM_PICFLAG   = 
MFEM_FLAGS     = $(MFEM_CPPFLAGS) $(MFEM_CXXFLAGS) $(MFEM_INCFLAGS)
MFEM_EXT_LIBS  =  D:/a/msys64/mingw64/lib/libgomp.dll.a D:/a/msys64/mingw64/lib/libmingwthrd.a D:/a/msys64/mingw64/lib/libHYPRE.dll.a D:/a/msys64/mingw64/lib/libumfpack.dll.a D:/a/msys64/mingw64/lib/libklu.dll.a D:/a/msys64/mingw64/lib/libamd.dll.a D:/a/msys64/mingw64/lib/libbtf.dll.a D:/a/msys64/mingw64/lib/libcholmod.dll.a D:/a/msys64/mingw64/lib/libcolamd.dll.a D:/a/msys64/mingw64/lib/libcamd.dll.a D:/a/msys64/mingw64/lib/libccolamd.dll.a D:/a/msys64/mingw64/lib/libsuitesparseconfig.dll.a D:/a/msys64/mingw64/lib/libopenblas.dll.a D:/a/msys64/mingw64/lib/libmetis.dll.a D:/a/msys64/mingw64/lib/libsundials_nvecserial.dll.a D:/a/msys64/mingw64/lib/libsundials_nvecparallel.dll.a D:/a/msys64/mingw64/lib/libsundials_nvecmpiplusx.dll.a D:/a/msys64/mingw64/lib/libsundials_cvodes.dll.a D:/a/msys64/mingw64/lib/libsundials_arkode.dll.a D:/a/msys64/mingw64/lib/libsundials_kinsol.dll.a D:/a/msys64/mingw64/lib/libnetcdf.dll.a D:/a/msys64/mingw64/lib/libhdf5_hl.dll.a D:/a/msys64/mingw64/lib/libhdf5.dll.a mpfr D:/a/msys64/mingw64/lib/libz.dll.a D:/a/msys64/mingw64/lib/libmsmpi.dll.a
MFEM_LIBS      = -Wl,-rpath,$(MFEM_LIB_DIR) -L$(MFEM_LIB_DIR) -lmfem $(MFEM_EXT_LIBS)
MFEM_LIB_FILE  = $(MFEM_LIB_DIR)/libmfem.dll.4.6.0
MFEM_STATIC    = NO
MFEM_SHARED    = YES
MFEM_BUILD_TAG = Windows-10.0.20348
MFEM_PREFIX    = /mingw64
MFEM_INC_DIR   = /mingw64/include
MFEM_LIB_DIR   = /mingw64/lib

# Location of test.mk
MFEM_TEST_MK = /mingw64/share/mfem/test.mk

# Command used to launch MPI jobs
MFEM_MPIEXEC    = mpirun
MFEM_MPIEXEC_NP = -n
MFEM_MPI_NP     = 4

# The NVCC compiler cannot link with -x=cu
MFEM_LINK_FLAGS := $(filter-out -x=cu -xhip, $(MFEM_FLAGS))

# Optional extra configuration

