# is-installed-globally

> Check if your package was installed globally

Can be useful if your CLI needs different behavior when installed globally and locally.

## Install

```sh
npm install is-installed-globally
```

## Usage

```js
import isInstalledGlobally from 'is-installed-globally';

// With `npm install your-package`
console.log(isInstalledGlobally);
//=> false

// With `npm install --global your-package`
console.log(isInstalledGlobally);
//=> true
```

## Related

- [import-global](https://github.com/sindresorhus/import-global) - Import a globally installed module
- [resolve-global](https://github.com/sindresorhus/resolve-global) - Resolve the path of a globally installed module
- [global-directory](https://github.com/sindresorhus/global-directory) - Get the directory of globally installed packages and binaries
