# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.9

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.devices.bluetooth.genericattributeprofile
import winsdk.windows.devices.bluetooth.rfcomm
import winsdk.windows.devices.enumeration
import winsdk.windows.devices.radios
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.networking
import winsdk.windows.storage.streams

class BluetoothAddressType(enum.IntEnum):
    PUBLIC = 0
    RANDOM = 1
    UNSPECIFIED = 2

class BluetoothCacheMode(enum.IntEnum):
    CACHED = 0
    UNCACHED = 1

class BluetoothConnectionStatus(enum.IntEnum):
    DISCONNECTED = 0
    CONNECTED = 1

class BluetoothError(enum.IntEnum):
    SUCCESS = 0
    RADIO_NOT_AVAILABLE = 1
    RESOURCE_IN_USE = 2
    DEVICE_NOT_CONNECTED = 3
    OTHER_ERROR = 4
    DISABLED_BY_POLICY = 5
    NOT_SUPPORTED = 6
    DISABLED_BY_USER = 7
    CONSENT_REQUIRED = 8
    TRANSPORT_NOT_SUPPORTED = 9

class BluetoothLEPreferredConnectionParametersRequestStatus(enum.IntEnum):
    UNSPECIFIED = 0
    SUCCESS = 1
    DEVICE_NOT_AVAILABLE = 2
    ACCESS_DENIED = 3

class BluetoothMajorClass(enum.IntEnum):
    MISCELLANEOUS = 0
    COMPUTER = 1
    PHONE = 2
    NETWORK_ACCESS_POINT = 3
    AUDIO_VIDEO = 4
    PERIPHERAL = 5
    IMAGING = 6
    WEARABLE = 7
    TOY = 8
    HEALTH = 9

class BluetoothMinorClass(enum.IntEnum):
    UNCATEGORIZED = 0
    COMPUTER_DESKTOP = 1
    COMPUTER_SERVER = 2
    COMPUTER_LAPTOP = 3
    COMPUTER_HANDHELD = 4
    COMPUTER_PALM_SIZE = 5
    COMPUTER_WEARABLE = 6
    COMPUTER_TABLET = 7
    PHONE_CELLULAR = 1
    PHONE_CORDLESS = 2
    PHONE_SMART_PHONE = 3
    PHONE_WIRED = 4
    PHONE_ISDN = 5
    NETWORK_FULLY_AVAILABLE = 0
    NETWORK_USED01_TO17_PERCENT = 8
    NETWORK_USED17_TO33_PERCENT = 16
    NETWORK_USED33_TO50_PERCENT = 24
    NETWORK_USED50_TO67_PERCENT = 32
    NETWORK_USED67_TO83_PERCENT = 40
    NETWORK_USED83_TO99_PERCENT = 48
    NETWORK_NO_SERVICE_AVAILABLE = 56
    AUDIO_VIDEO_WEARABLE_HEADSET = 1
    AUDIO_VIDEO_HANDS_FREE = 2
    AUDIO_VIDEO_MICROPHONE = 4
    AUDIO_VIDEO_LOUDSPEAKER = 5
    AUDIO_VIDEO_HEADPHONES = 6
    AUDIO_VIDEO_PORTABLE_AUDIO = 7
    AUDIO_VIDEO_CAR_AUDIO = 8
    AUDIO_VIDEO_SET_TOP_BOX = 9
    AUDIO_VIDEO_HIFI_AUDIO_DEVICE = 10
    AUDIO_VIDEO_VCR = 11
    AUDIO_VIDEO_VIDEO_CAMERA = 12
    AUDIO_VIDEO_CAMCORDER = 13
    AUDIO_VIDEO_VIDEO_MONITOR = 14
    AUDIO_VIDEO_VIDEO_DISPLAY_AND_LOUDSPEAKER = 15
    AUDIO_VIDEO_VIDEO_CONFERENCING = 16
    AUDIO_VIDEO_GAMING_OR_TOY = 18
    PERIPHERAL_JOYSTICK = 1
    PERIPHERAL_GAMEPAD = 2
    PERIPHERAL_REMOTE_CONTROL = 3
    PERIPHERAL_SENSING = 4
    PERIPHERAL_DIGITIZER_TABLET = 5
    PERIPHERAL_CARD_READER = 6
    PERIPHERAL_DIGITAL_PEN = 7
    PERIPHERAL_HANDHELD_SCANNER = 8
    PERIPHERAL_HANDHELD_GESTURE = 9
    WEARABLE_WRISTWATCH = 1
    WEARABLE_PAGER = 2
    WEARABLE_JACKET = 3
    WEARABLE_HELMET = 4
    WEARABLE_GLASSES = 5
    TOY_ROBOT = 1
    TOY_VEHICLE = 2
    TOY_DOLL = 3
    TOY_CONTROLLER = 4
    TOY_GAME = 5
    HEALTH_BLOOD_PRESSURE_MONITOR = 1
    HEALTH_THERMOMETER = 2
    HEALTH_WEIGHING_SCALE = 3
    HEALTH_GLUCOSE_METER = 4
    HEALTH_PULSE_OXIMETER = 5
    HEALTH_HEART_RATE_MONITOR = 6
    HEALTH_HEALTH_DATA_DISPLAY = 7
    HEALTH_STEP_COUNTER = 8
    HEALTH_BODY_COMPOSITION_ANALYZER = 9
    HEALTH_PEAK_FLOW_MONITOR = 10
    HEALTH_MEDICATION_MONITOR = 11
    HEALTH_KNEE_PROSTHESIS = 12
    HEALTH_ANKLE_PROSTHESIS = 13
    HEALTH_GENERIC_HEALTH_MANAGER = 14
    HEALTH_PERSONAL_MOBILITY_DEVICE = 15

class BluetoothServiceCapabilities(enum.IntFlag):
    NONE = 0
    LIMITED_DISCOVERABLE_MODE = 0x1
    POSITIONING_SERVICE = 0x8
    NETWORKING_SERVICE = 0x10
    RENDERING_SERVICE = 0x20
    CAPTURING_SERVICE = 0x40
    OBJECT_TRANSFER_SERVICE = 0x80
    AUDIO_SERVICE = 0x100
    TELEPHONE_SERVICE = 0x200
    INFORMATION_SERVICE = 0x400

Self = typing.TypeVar('Self')

class BluetoothAdapter(winsdk.system.Object):
    bluetooth_address: winsdk.system.UInt64
    device_id: str
    is_advertisement_offload_supported: winsdk.system.Boolean
    is_central_role_supported: winsdk.system.Boolean
    is_classic_supported: winsdk.system.Boolean
    is_low_energy_supported: winsdk.system.Boolean
    is_peripheral_role_supported: winsdk.system.Boolean
    are_classic_secure_connections_supported: winsdk.system.Boolean
    are_low_energy_secure_connections_supported: winsdk.system.Boolean
    is_extended_advertising_supported: winsdk.system.Boolean
    max_advertisement_data_length: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothAdapter: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[BluetoothAdapter]: ...
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[BluetoothAdapter]: ...
    @staticmethod
    def get_device_selector() -> str: ...
    def get_radio_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.radios.Radio]: ...

class BluetoothClassOfDevice(winsdk.system.Object):
    major_class: BluetoothMajorClass
    minor_class: BluetoothMinorClass
    raw_value: winsdk.system.UInt32
    service_capabilities: BluetoothServiceCapabilities
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothClassOfDevice: ...
    @staticmethod
    def from_parts(major_class: BluetoothMajorClass, minor_class: BluetoothMinorClass, service_capabilities: BluetoothServiceCapabilities) -> typing.Optional[BluetoothClassOfDevice]: ...
    @staticmethod
    def from_raw_value(raw_value: winsdk.system.UInt32) -> typing.Optional[BluetoothClassOfDevice]: ...

class BluetoothDevice(winsdk.system.Object):
    bluetooth_address: winsdk.system.UInt64
    class_of_device: typing.Optional[BluetoothClassOfDevice]
    connection_status: BluetoothConnectionStatus
    device_id: str
    host_name: typing.Optional[winsdk.windows.networking.HostName]
    name: str
    rfcomm_services: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.devices.bluetooth.rfcomm.RfcommDeviceService]]
    sdp_records: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.storage.streams.IBuffer]]
    device_information: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation]
    device_access_information: typing.Optional[winsdk.windows.devices.enumeration.DeviceAccessInformation]
    bluetooth_device_id: typing.Optional[BluetoothDeviceId]
    was_secure_connection_used_for_pairing: winsdk.system.Boolean
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothDevice: ...
    def close(self) -> None: ...
    @staticmethod
    def from_bluetooth_address_async(address: winsdk.system.UInt64) -> winsdk.windows.foundation.IAsyncOperation[BluetoothDevice]: ...
    @staticmethod
    def from_host_name_async(host_name: typing.Optional[winsdk.windows.networking.HostName]) -> winsdk.windows.foundation.IAsyncOperation[BluetoothDevice]: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[BluetoothDevice]: ...
    @staticmethod
    def get_device_selector() -> str: ...
    @staticmethod
    def get_device_selector_from_bluetooth_address(bluetooth_address: winsdk.system.UInt64) -> str: ...
    @staticmethod
    def get_device_selector_from_class_of_device(class_of_device: typing.Optional[BluetoothClassOfDevice]) -> str: ...
    @staticmethod
    def get_device_selector_from_connection_status(connection_status: BluetoothConnectionStatus) -> str: ...
    @staticmethod
    def get_device_selector_from_device_name(device_name: str) -> str: ...
    @staticmethod
    def get_device_selector_from_pairing_state(pairing_state: winsdk.system.Boolean) -> str: ...
    @typing.overload
    def get_rfcomm_services_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.rfcomm.RfcommDeviceServicesResult]: ...
    @typing.overload
    def get_rfcomm_services_async(self, cache_mode: BluetoothCacheMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.rfcomm.RfcommDeviceServicesResult]: ...
    @typing.overload
    def get_rfcomm_services_for_id_async(self, service_id: typing.Optional[winsdk.windows.devices.bluetooth.rfcomm.RfcommServiceId]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.rfcomm.RfcommDeviceServicesResult]: ...
    @typing.overload
    def get_rfcomm_services_for_id_async(self, service_id: typing.Optional[winsdk.windows.devices.bluetooth.rfcomm.RfcommServiceId], cache_mode: BluetoothCacheMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.rfcomm.RfcommDeviceServicesResult]: ...
    def request_access_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.enumeration.DeviceAccessStatus]: ...
    def add_connection_status_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_connection_status_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_name_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_name_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_sdp_records_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_sdp_records_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class BluetoothDeviceId(winsdk.system.Object):
    id: str
    is_classic_device: winsdk.system.Boolean
    is_low_energy_device: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothDeviceId: ...
    @staticmethod
    def from_id(device_id: str) -> typing.Optional[BluetoothDeviceId]: ...

class BluetoothLEAppearance(winsdk.system.Object):
    category: winsdk.system.UInt16
    raw_value: winsdk.system.UInt16
    sub_category: winsdk.system.UInt16
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEAppearance: ...
    @staticmethod
    def from_parts(appearance_category: winsdk.system.UInt16, appearance_sub_category: winsdk.system.UInt16) -> typing.Optional[BluetoothLEAppearance]: ...
    @staticmethod
    def from_raw_value(raw_value: winsdk.system.UInt16) -> typing.Optional[BluetoothLEAppearance]: ...

class BluetoothLEAppearanceCategories(winsdk.system.Object):
    barcode_scanner: typing.ClassVar[winsdk.system.UInt16]
    blood_pressure: typing.ClassVar[winsdk.system.UInt16]
    clock: typing.ClassVar[winsdk.system.UInt16]
    computer: typing.ClassVar[winsdk.system.UInt16]
    cycling: typing.ClassVar[winsdk.system.UInt16]
    display: typing.ClassVar[winsdk.system.UInt16]
    eye_glasses: typing.ClassVar[winsdk.system.UInt16]
    glucose_meter: typing.ClassVar[winsdk.system.UInt16]
    heart_rate: typing.ClassVar[winsdk.system.UInt16]
    human_interface_device: typing.ClassVar[winsdk.system.UInt16]
    keyring: typing.ClassVar[winsdk.system.UInt16]
    media_player: typing.ClassVar[winsdk.system.UInt16]
    outdoor_sport_activity: typing.ClassVar[winsdk.system.UInt16]
    phone: typing.ClassVar[winsdk.system.UInt16]
    pulse_oximeter: typing.ClassVar[winsdk.system.UInt16]
    remote_control: typing.ClassVar[winsdk.system.UInt16]
    running_walking: typing.ClassVar[winsdk.system.UInt16]
    tag: typing.ClassVar[winsdk.system.UInt16]
    thermometer: typing.ClassVar[winsdk.system.UInt16]
    uncategorized: typing.ClassVar[winsdk.system.UInt16]
    watch: typing.ClassVar[winsdk.system.UInt16]
    weight_scale: typing.ClassVar[winsdk.system.UInt16]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEAppearanceCategories: ...

class BluetoothLEAppearanceSubcategories(winsdk.system.Object):
    barcode_scanner: typing.ClassVar[winsdk.system.UInt16]
    blood_pressure_arm: typing.ClassVar[winsdk.system.UInt16]
    blood_pressure_wrist: typing.ClassVar[winsdk.system.UInt16]
    card_reader: typing.ClassVar[winsdk.system.UInt16]
    cycling_cadence_sensor: typing.ClassVar[winsdk.system.UInt16]
    cycling_computer: typing.ClassVar[winsdk.system.UInt16]
    cycling_power_sensor: typing.ClassVar[winsdk.system.UInt16]
    cycling_speed_cadence_sensor: typing.ClassVar[winsdk.system.UInt16]
    cycling_speed_sensor: typing.ClassVar[winsdk.system.UInt16]
    digital_pen: typing.ClassVar[winsdk.system.UInt16]
    digitizer_tablet: typing.ClassVar[winsdk.system.UInt16]
    gamepad: typing.ClassVar[winsdk.system.UInt16]
    generic: typing.ClassVar[winsdk.system.UInt16]
    heart_rate_belt: typing.ClassVar[winsdk.system.UInt16]
    joystick: typing.ClassVar[winsdk.system.UInt16]
    keyboard: typing.ClassVar[winsdk.system.UInt16]
    location_display: typing.ClassVar[winsdk.system.UInt16]
    location_navigation_display: typing.ClassVar[winsdk.system.UInt16]
    location_navigation_pod: typing.ClassVar[winsdk.system.UInt16]
    location_pod: typing.ClassVar[winsdk.system.UInt16]
    mouse: typing.ClassVar[winsdk.system.UInt16]
    oximeter_fingertip: typing.ClassVar[winsdk.system.UInt16]
    oximeter_wrist_worn: typing.ClassVar[winsdk.system.UInt16]
    running_walking_in_shoe: typing.ClassVar[winsdk.system.UInt16]
    running_walking_on_hip: typing.ClassVar[winsdk.system.UInt16]
    running_walking_on_shoe: typing.ClassVar[winsdk.system.UInt16]
    sports_watch: typing.ClassVar[winsdk.system.UInt16]
    thermometer_ear: typing.ClassVar[winsdk.system.UInt16]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEAppearanceSubcategories: ...

class BluetoothLEConnectionParameters(winsdk.system.Object):
    connection_interval: winsdk.system.UInt16
    connection_latency: winsdk.system.UInt16
    link_timeout: winsdk.system.UInt16
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEConnectionParameters: ...

class BluetoothLEConnectionPhy(winsdk.system.Object):
    receive_info: typing.Optional[BluetoothLEConnectionPhyInfo]
    transmit_info: typing.Optional[BluetoothLEConnectionPhyInfo]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEConnectionPhy: ...

class BluetoothLEConnectionPhyInfo(winsdk.system.Object):
    is_coded_phy: winsdk.system.Boolean
    is_uncoded1_m_phy: winsdk.system.Boolean
    is_uncoded2_m_phy: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEConnectionPhyInfo: ...

class BluetoothLEDevice(winsdk.system.Object):
    bluetooth_address: winsdk.system.UInt64
    connection_status: BluetoothConnectionStatus
    device_id: str
    gatt_services: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.devices.bluetooth.genericattributeprofile.GattDeviceService]]
    name: str
    appearance: typing.Optional[BluetoothLEAppearance]
    bluetooth_address_type: BluetoothAddressType
    device_information: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation]
    device_access_information: typing.Optional[winsdk.windows.devices.enumeration.DeviceAccessInformation]
    bluetooth_device_id: typing.Optional[BluetoothDeviceId]
    was_secure_connection_used_for_pairing: winsdk.system.Boolean
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEDevice: ...
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def from_bluetooth_address_async(bluetooth_address: winsdk.system.UInt64) -> winsdk.windows.foundation.IAsyncOperation[BluetoothLEDevice]: ...
    @typing.overload
    @staticmethod
    def from_bluetooth_address_async(bluetooth_address: winsdk.system.UInt64, bluetooth_address_type: BluetoothAddressType) -> winsdk.windows.foundation.IAsyncOperation[BluetoothLEDevice]: ...
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[BluetoothLEDevice]: ...
    def get_connection_parameters(self) -> typing.Optional[BluetoothLEConnectionParameters]: ...
    def get_connection_phy(self) -> typing.Optional[BluetoothLEConnectionPhy]: ...
    @staticmethod
    def get_device_selector() -> str: ...
    @staticmethod
    def get_device_selector_from_appearance(appearance: typing.Optional[BluetoothLEAppearance]) -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector_from_bluetooth_address(bluetooth_address: winsdk.system.UInt64) -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector_from_bluetooth_address(bluetooth_address: winsdk.system.UInt64, bluetooth_address_type: BluetoothAddressType) -> str: ...
    @staticmethod
    def get_device_selector_from_connection_status(connection_status: BluetoothConnectionStatus) -> str: ...
    @staticmethod
    def get_device_selector_from_device_name(device_name: str) -> str: ...
    @staticmethod
    def get_device_selector_from_pairing_state(pairing_state: winsdk.system.Boolean) -> str: ...
    def get_gatt_service(self, service_uuid: winsdk.system.Guid) -> typing.Optional[winsdk.windows.devices.bluetooth.genericattributeprofile.GattDeviceService]: ...
    @typing.overload
    def get_gatt_services_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.genericattributeprofile.GattDeviceServicesResult]: ...
    @typing.overload
    def get_gatt_services_async(self, cache_mode: BluetoothCacheMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.genericattributeprofile.GattDeviceServicesResult]: ...
    @typing.overload
    def get_gatt_services_for_uuid_async(self, service_uuid: winsdk.system.Guid) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.genericattributeprofile.GattDeviceServicesResult]: ...
    @typing.overload
    def get_gatt_services_for_uuid_async(self, service_uuid: winsdk.system.Guid, cache_mode: BluetoothCacheMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.bluetooth.genericattributeprofile.GattDeviceServicesResult]: ...
    def request_access_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.devices.enumeration.DeviceAccessStatus]: ...
    def request_preferred_connection_parameters(self, preferred_connection_parameters: typing.Optional[BluetoothLEPreferredConnectionParameters]) -> typing.Optional[BluetoothLEPreferredConnectionParametersRequest]: ...
    def add_connection_status_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothLEDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_connection_status_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_gatt_services_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothLEDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_gatt_services_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_name_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothLEDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_name_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_connection_parameters_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothLEDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_connection_parameters_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_connection_phy_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[BluetoothLEDevice, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_connection_phy_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class BluetoothLEPreferredConnectionParameters(winsdk.system.Object):
    connection_latency: winsdk.system.UInt16
    link_timeout: winsdk.system.UInt16
    max_connection_interval: winsdk.system.UInt16
    min_connection_interval: winsdk.system.UInt16
    balanced: typing.ClassVar[typing.Optional[BluetoothLEPreferredConnectionParameters]]
    power_optimized: typing.ClassVar[typing.Optional[BluetoothLEPreferredConnectionParameters]]
    throughput_optimized: typing.ClassVar[typing.Optional[BluetoothLEPreferredConnectionParameters]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEPreferredConnectionParameters: ...

class BluetoothLEPreferredConnectionParametersRequest(winsdk.system.Object):
    status: BluetoothLEPreferredConnectionParametersRequestStatus
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothLEPreferredConnectionParametersRequest: ...
    def close(self) -> None: ...

class BluetoothSignalStrengthFilter(winsdk.system.Object):
    sampling_interval: typing.Optional[typing.Optional[datetime.timedelta]]
    out_of_range_timeout: typing.Optional[typing.Optional[datetime.timedelta]]
    out_of_range_threshold_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Int16]]
    in_range_threshold_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Int16]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothSignalStrengthFilter: ...
    def __new__(cls: typing.Type[BluetoothSignalStrengthFilter]) -> BluetoothSignalStrengthFilter:...

class BluetoothUuidHelper(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> BluetoothUuidHelper: ...
    @staticmethod
    def from_short_id(short_id: winsdk.system.UInt32) -> winsdk.system.Guid: ...
    @staticmethod
    def try_get_short_id(uuid: winsdk.system.Guid) -> typing.Optional[typing.Optional[winsdk.system.UInt32]]: ...

