%feature("docstring") OT::LinearCombinationFunction
"Linear combination of functions.

Allows one to create a function which is the linear combination of functions
with scalar weights.

:math:`functionCollection  = (f_1, \\hdots, f_N)`
where :math:`\\forall 1 \\leq i \\leq N, \\,     f_i: \\Rset^n \\rightarrow \\Rset^{p}`
and :math:`scalarCoefficientColl = (c_1, \\hdots, c_N) \\in \\Rset^N`
then the linear combination is:

.. math::

    linComb  \\left|\\begin{array}{rcl}
                  \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                  \\vect{X} & \\mapsto & \\displaystyle \\sum_{i=1}^N c_i f_i (\\vect{X})
              \\end{array}\\right.

Parameters
----------
functionCollection : sequence of :class:`~openturns.Function`
    Collection of functions to sum.
scalarCoefficientColl : sequence of float
    Collection of scalar weights.

Examples
--------
>>> import openturns as ot
>>> f1 = ot.SymbolicFunction(['x'], ['sin(x)'])
>>> f2 = ot.SymbolicFunction(['x'], ['x'])
>>> f3 = ot.SymbolicFunction(['x'], ['cos(x)'])
>>> f = ot.LinearCombinationFunction([f1, f2, f3], [1.0, 2.0, 3.0])

Evaluate the function:

>>> x = [1.0]
>>> y = f(x)"
