%feature("docstring") OT::UniformFactory
"Uniform factory.

Notes
-----
The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{a}_n=(1-\\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\\\
      \\displaystyle\\Hat{b}_n=(1+\\mathrm{sign}(x_{(n,n)})/(2+n))x_{(n,n)}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Uniform"

// ---------------------------------------------------------------------

%feature("docstring") OT::UniformFactory::buildAsUniform
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsUniform()

    buildAsUniform(*sample*)

    buildAsUniform(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
    The parameters of the :class:`~openturns.Uniform`.

Returns
-------
dist : :class:`~openturns.Uniform`
    The estimated distribution as a :class:`openturns.Uniform`.
    
    In the first usage, the default :class:`openturns.Uniform` distribution is built."

