
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was fmt-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(fmt_known_comps static shared)
set(fmt_comp_static NO)
set(fmt_comp_shared NO)
foreach (fmt_comp IN LISTS ${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS)
    if (fmt_comp IN_LIST fmt_known_comps)
        set(fmt_comp_${fmt_comp} YES)
    else ()
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "fmt does not recognize component `${fmt_comp}`.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
endforeach ()

if (fmt_comp_static AND fmt_comp_shared)
    set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
        "fmt `static` and `shared` components are mutually exclusive.")
    set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
    return()
endif ()

set(fmt_static_targets "${CMAKE_CURRENT_LIST_DIR}/fmt-static-targets.cmake")
set(fmt_shared_targets "${CMAKE_CURRENT_LIST_DIR}/fmt-shared-targets.cmake")

macro(fmt_load_targets type)
    if (NOT EXISTS "${fmt_${type}_targets}")
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "fmt `${type}` libraries were requested but not found.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
    include("${fmt_${type}_targets}")
endmacro()

if (fmt_comp_static)
    fmt_load_targets(static)
elseif (fmt_comp_shared)
    fmt_load_targets(shared)
elseif (DEFINED fmt_SHARED_LIBS AND fmt_SHARED_LIBS)
    fmt_load_targets(shared)
elseif (DEFINED fmt_SHARED_LIBS AND NOT fmt_SHARED_LIBS)
    fmt_load_targets(static)
elseif (BUILD_SHARED_LIBS)
    if (EXISTS "${fmt_shared_targets}")
        fmt_load_targets(shared)
    else ()
        fmt_load_targets(static)
    endif ()
else ()
    if (EXISTS "${fmt_static_targets}")
        fmt_load_targets(static)
    else ()
        fmt_load_targets(shared)
    endif ()
endif ()

check_required_components(fmt)
