// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Networking_BackgroundTransfer_H
#define WINRT_Windows_Networking_BackgroundTransfer_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Networking.h"
#include "winrt/impl/Windows.ApplicationModel.Background.2.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Security.Credentials.2.h"
#include "winrt/impl/Windows.Storage.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.UI.Notifications.2.h"
#include "winrt/impl/Windows.Web.2.h"
#include "winrt/impl/Windows.Networking.BackgroundTransfer.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader<D>::CreateDownload(winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::IStorageFile const& resultFile) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateDownload(*(void**)(&uri), *(void**)(&resultFile), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>**)this;
            check_hresult(_winrt_abi_type->CreateDownload(*(void**)(&uri), *(void**)(&resultFile), &operation));
        }
        return winrt::Windows::Networking::BackgroundTransfer::DownloadOperation{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader<D>::CreateDownload(winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::IStorageFile const& resultFile, winrt::Windows::Storage::IStorageFile const& requestBodyFile) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateDownloadFromFile(*(void**)(&uri), *(void**)(&resultFile), *(void**)(&requestBodyFile), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>**)this;
            check_hresult(_winrt_abi_type->CreateDownloadFromFile(*(void**)(&uri), *(void**)(&resultFile), *(void**)(&requestBodyFile), &operation));
        }
        return winrt::Windows::Networking::BackgroundTransfer::DownloadOperation{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader<D>::CreateDownloadAsync(winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::IStorageFile const& resultFile, winrt::Windows::Storage::Streams::IInputStream const& requestBodyStream) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateDownloadAsync(*(void**)(&uri), *(void**)(&resultFile), *(void**)(&requestBodyStream), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>**)this;
            check_hresult(_winrt_abi_type->CreateDownloadAsync(*(void**)(&uri), *(void**)(&resultFile), *(void**)(&requestBodyStream), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::TransferGroup() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::TransferGroup(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransferGroup(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->put_TransferGroup(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::SuccessToastNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SuccessToastNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->get_SuccessToastNotification(&value));
        }
        return winrt::Windows::UI::Notifications::ToastNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::SuccessToastNotification(winrt::Windows::UI::Notifications::ToastNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SuccessToastNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->put_SuccessToastNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::FailureToastNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FailureToastNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->get_FailureToastNotification(&value));
        }
        return winrt::Windows::UI::Notifications::ToastNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::FailureToastNotification(winrt::Windows::UI::Notifications::ToastNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FailureToastNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->put_FailureToastNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::SuccessTileNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SuccessTileNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->get_SuccessTileNotification(&value));
        }
        return winrt::Windows::UI::Notifications::TileNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::SuccessTileNotification(winrt::Windows::UI::Notifications::TileNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SuccessTileNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->put_SuccessTileNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::FailureTileNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FailureTileNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->get_FailureTileNotification(&value));
        }
        return winrt::Windows::UI::Notifications::TileNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader2<D>::FailureTileNotification(winrt::Windows::UI::Notifications::TileNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FailureTileNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>**)this;
            check_hresult(_winrt_abi_type->put_FailureTileNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloader3<D>::CompletionGroup() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompletionGroup(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader3>**)this;
            check_hresult(_winrt_abi_type->get_CompletionGroup(&value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloaderFactory<D>::CreateWithCompletionGroup(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup const& completionGroup) const
    {
        void* backgroundDownloader{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithCompletionGroup(*(void**)(&completionGroup), &backgroundDownloader));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithCompletionGroup(*(void**)(&completionGroup), &backgroundDownloader));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundDownloader{ backgroundDownloader, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloaderStaticMethods<D>::GetCurrentDownloadsAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentDownloadsAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods>**)this;
            check_hresult(_winrt_abi_type->GetCurrentDownloadsAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloaderStaticMethods<D>::GetCurrentDownloadsAsync(param::hstring const& group) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentDownloadsForGroupAsync(*(void**)(&group), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods>**)this;
            check_hresult(_winrt_abi_type->GetCurrentDownloadsForGroupAsync(*(void**)(&group), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloaderStaticMethods2<D>::GetCurrentDownloadsForTransferGroupAsync(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const& group) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentDownloadsForTransferGroupAsync(*(void**)(&group), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods2>**)this;
            check_hresult(_winrt_abi_type->GetCurrentDownloadsForTransferGroupAsync(*(void**)(&group), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundDownloaderUserConsent<D>::RequestUnconstrainedDownloadsAsync(param::async_iterable<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation> const& operations) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderUserConsent>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderUserConsent, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderUserConsent>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestUnconstrainedDownloadsAsync(*(void**)(&operations), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderUserConsent>**)this;
            check_hresult(_winrt_abi_type->RequestUnconstrainedDownloadsAsync(*(void**)(&operations), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UnconstrainedTransferRequestResult>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::SetRequestHeader(param::hstring const& headerName, param::hstring const& headerValue) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetRequestHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->SetRequestHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::ServerCredential() const
    {
        void* credential{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ServerCredential(&credential));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->get_ServerCredential(&credential));
        }
        return winrt::Windows::Security::Credentials::PasswordCredential{ credential, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::ServerCredential(winrt::Windows::Security::Credentials::PasswordCredential const& credential) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ServerCredential(*(void**)(&credential)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->put_ServerCredential(*(void**)(&credential)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::ProxyCredential() const
    {
        void* credential{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProxyCredential(&credential));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->get_ProxyCredential(&credential));
        }
        return winrt::Windows::Security::Credentials::PasswordCredential{ credential, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::ProxyCredential(winrt::Windows::Security::Credentials::PasswordCredential const& credential) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ProxyCredential(*(void**)(&credential)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->put_ProxyCredential(*(void**)(&credential)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::Method() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Method(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->get_Method(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::Method(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Method(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->put_Method(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::Group() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Group(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->get_Group(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::Group(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Group(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->put_Group(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::CostPolicy() const
    {
        winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CostPolicy(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->get_CostPolicy(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferBase<D>::CostPolicy(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CostPolicy(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>**)this;
            check_hresult(_winrt_abi_type->put_CostPolicy(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferCompletionGroup<D>::Trigger() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Trigger(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>**)this;
            check_hresult(_winrt_abi_type->get_Trigger(&value));
        }
        return winrt::Windows::ApplicationModel::Background::IBackgroundTrigger{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferCompletionGroup<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferCompletionGroup<D>::Enable() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Enable());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>**)this;
            check_hresult(_winrt_abi_type->Enable());
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferCompletionGroupTriggerDetails<D>::Downloads() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Downloads(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails>**)this;
            check_hresult(_winrt_abi_type->get_Downloads(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferCompletionGroupTriggerDetails<D>::Uploads() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Uploads(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails>**)this;
            check_hresult(_winrt_abi_type->get_Uploads(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferContentPart<D>::SetHeader(param::hstring const& headerName, param::hstring const& headerValue) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>**)this;
            check_hresult(_winrt_abi_type->SetHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferContentPart<D>::SetText(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetText(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>**)this;
            check_hresult(_winrt_abi_type->SetText(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferContentPart<D>::SetFile(winrt::Windows::Storage::IStorageFile const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetFile(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>**)this;
            check_hresult(_winrt_abi_type->SetFile(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferContentPartFactory<D>::CreateWithName(param::hstring const& name) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithName(*(void**)(&name), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithName(*(void**)(&name), &value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferContentPartFactory<D>::CreateWithNameAndFileName(param::hstring const& name, param::hstring const& fileName) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithNameAndFileName(*(void**)(&name), *(void**)(&fileName), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithNameAndFileName(*(void**)(&name), *(void**)(&fileName), &value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferErrorStaticMethods<D>::GetStatus(int32_t hresult) const
    {
        winrt::Windows::Web::WebErrorStatus status{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferErrorStaticMethods>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferErrorStaticMethods, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferErrorStaticMethods>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStatus(hresult, reinterpret_cast<int32_t*>(&status)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferErrorStaticMethods>**)this;
            check_hresult(_winrt_abi_type->GetStatus(hresult, reinterpret_cast<int32_t*>(&status)));
        }
        return status;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferGroup<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferGroup<D>::TransferBehavior() const
    {
        winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferBehavior value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransferBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>**)this;
            check_hresult(_winrt_abi_type->get_TransferBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferGroup<D>::TransferBehavior(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferBehavior const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransferBehavior(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>**)this;
            check_hresult(_winrt_abi_type->put_TransferBehavior(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferGroupStatics<D>::CreateGroup(param::hstring const& name) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroupStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroupStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroupStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateGroup(*(void**)(&name), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroupStatics>**)this;
            check_hresult(_winrt_abi_type->CreateGroup(*(void**)(&name), &value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::Guid() const
    {
        winrt::guid value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Guid(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->get_Guid(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::RequestedUri() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RequestedUri(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->get_RequestedUri(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::Method() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Method(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->get_Method(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::Group() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Group(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->get_Group(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::CostPolicy() const
    {
        winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CostPolicy(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->get_CostPolicy(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::CostPolicy(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CostPolicy(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->put_CostPolicy(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::GetResultStreamAt(uint64_t position) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetResultStreamAt(position, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->GetResultStreamAt(position, &value));
        }
        return winrt::Windows::Storage::Streams::IInputStream{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperation<D>::GetResponseInformation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetResponseInformation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>**)this;
            check_hresult(_winrt_abi_type->GetResponseInformation(&value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::ResponseInformation{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperationPriority<D>::Priority() const
    {
        winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferPriority value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Priority(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority>**)this;
            check_hresult(_winrt_abi_type->get_Priority(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferOperationPriority<D>::Priority(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferPriority const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Priority(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority>**)this;
            check_hresult(_winrt_abi_type->put_Priority(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferRangesDownloadedEventArgs<D>::WasDownloadRestarted() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_WasDownloadRestarted(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_WasDownloadRestarted(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferRangesDownloadedEventArgs<D>::AddedRanges() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AddedRanges(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AddedRanges(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferFileRange>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundTransferRangesDownloadedEventArgs<D>::GetDeferral() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        return winrt::Windows::Foundation::Deferral{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader<D>::CreateUpload(winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::IStorageFile const& sourceFile) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateUpload(*(void**)(&uri), *(void**)(&sourceFile), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)this;
            check_hresult(_winrt_abi_type->CreateUpload(*(void**)(&uri), *(void**)(&sourceFile), &operation));
        }
        return winrt::Windows::Networking::BackgroundTransfer::UploadOperation{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader<D>::CreateUploadFromStreamAsync(winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::Streams::IInputStream const& sourceStream) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateUploadFromStreamAsync(*(void**)(&uri), *(void**)(&sourceStream), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)this;
            check_hresult(_winrt_abi_type->CreateUploadFromStreamAsync(*(void**)(&uri), *(void**)(&sourceStream), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader<D>::CreateUploadAsync(winrt::Windows::Foundation::Uri const& uri, param::async_iterable<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart> const& parts) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateUploadWithFormDataAndAutoBoundaryAsync(*(void**)(&uri), *(void**)(&parts), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)this;
            check_hresult(_winrt_abi_type->CreateUploadWithFormDataAndAutoBoundaryAsync(*(void**)(&uri), *(void**)(&parts), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader<D>::CreateUploadAsync(winrt::Windows::Foundation::Uri const& uri, param::async_iterable<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart> const& parts, param::hstring const& subType) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateUploadWithSubTypeAsync(*(void**)(&uri), *(void**)(&parts), *(void**)(&subType), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)this;
            check_hresult(_winrt_abi_type->CreateUploadWithSubTypeAsync(*(void**)(&uri), *(void**)(&parts), *(void**)(&subType), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader<D>::CreateUploadAsync(winrt::Windows::Foundation::Uri const& uri, param::async_iterable<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart> const& parts, param::hstring const& subType, param::hstring const& boundary) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateUploadWithSubTypeAndBoundaryAsync(*(void**)(&uri), *(void**)(&parts), *(void**)(&subType), *(void**)(&boundary), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>**)this;
            check_hresult(_winrt_abi_type->CreateUploadWithSubTypeAndBoundaryAsync(*(void**)(&uri), *(void**)(&parts), *(void**)(&subType), *(void**)(&boundary), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::TransferGroup() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::TransferGroup(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransferGroup(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->put_TransferGroup(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::SuccessToastNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SuccessToastNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->get_SuccessToastNotification(&value));
        }
        return winrt::Windows::UI::Notifications::ToastNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::SuccessToastNotification(winrt::Windows::UI::Notifications::ToastNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SuccessToastNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->put_SuccessToastNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::FailureToastNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FailureToastNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->get_FailureToastNotification(&value));
        }
        return winrt::Windows::UI::Notifications::ToastNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::FailureToastNotification(winrt::Windows::UI::Notifications::ToastNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FailureToastNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->put_FailureToastNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::SuccessTileNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SuccessTileNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->get_SuccessTileNotification(&value));
        }
        return winrt::Windows::UI::Notifications::TileNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::SuccessTileNotification(winrt::Windows::UI::Notifications::TileNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SuccessTileNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->put_SuccessTileNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::FailureTileNotification() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FailureTileNotification(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->get_FailureTileNotification(&value));
        }
        return winrt::Windows::UI::Notifications::TileNotification{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader2<D>::FailureTileNotification(winrt::Windows::UI::Notifications::TileNotification const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FailureTileNotification(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>**)this;
            check_hresult(_winrt_abi_type->put_FailureTileNotification(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploader3<D>::CompletionGroup() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompletionGroup(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader3>**)this;
            check_hresult(_winrt_abi_type->get_CompletionGroup(&value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploaderFactory<D>::CreateWithCompletionGroup(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup const& completionGroup) const
    {
        void* backgroundUploader{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithCompletionGroup(*(void**)(&completionGroup), &backgroundUploader));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderFactory>**)this;
            check_hresult(_winrt_abi_type->CreateWithCompletionGroup(*(void**)(&completionGroup), &backgroundUploader));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundUploader{ backgroundUploader, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploaderStaticMethods<D>::GetCurrentUploadsAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentUploadsAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods>**)this;
            check_hresult(_winrt_abi_type->GetCurrentUploadsAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploaderStaticMethods<D>::GetCurrentUploadsAsync(param::hstring const& group) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentUploadsForGroupAsync(*(void**)(&group), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods>**)this;
            check_hresult(_winrt_abi_type->GetCurrentUploadsForGroupAsync(*(void**)(&group), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploaderStaticMethods2<D>::GetCurrentUploadsForTransferGroupAsync(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const& group) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentUploadsForTransferGroupAsync(*(void**)(&group), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods2>**)this;
            check_hresult(_winrt_abi_type->GetCurrentUploadsForTransferGroupAsync(*(void**)(&group), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IBackgroundUploaderUserConsent<D>::RequestUnconstrainedUploadsAsync(param::async_iterable<winrt::Windows::Networking::BackgroundTransfer::UploadOperation> const& operations) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderUserConsent>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderUserConsent, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderUserConsent>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestUnconstrainedUploadsAsync(*(void**)(&operations), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderUserConsent>**)this;
            check_hresult(_winrt_abi_type->RequestUnconstrainedUploadsAsync(*(void**)(&operations), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UnconstrainedTransferRequestResult>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IContentPrefetcher<D>::ContentUris() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ContentUris(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>**)this;
            check_hresult(_winrt_abi_type->get_ContentUris(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Foundation::Uri>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IContentPrefetcher<D>::IndirectContentUri(winrt::Windows::Foundation::Uri const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IndirectContentUri(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>**)this;
            check_hresult(_winrt_abi_type->put_IndirectContentUri(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IContentPrefetcher<D>::IndirectContentUri() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IndirectContentUri(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>**)this;
            check_hresult(_winrt_abi_type->get_IndirectContentUri(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IContentPrefetcherTime<D>::LastSuccessfulPrefetchTime() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcherTime>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcherTime, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcherTime>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LastSuccessfulPrefetchTime(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcherTime>**)this;
            check_hresult(_winrt_abi_type->get_LastSuccessfulPrefetchTime(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation<D>::ResultFile() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ResultFile(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)this;
            check_hresult(_winrt_abi_type->get_ResultFile(&value));
        }
        return winrt::Windows::Storage::IStorageFile{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation<D>::Progress() const
    {
        winrt::Windows::Networking::BackgroundTransfer::BackgroundDownloadProgress value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Progress(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)this;
            check_hresult(_winrt_abi_type->get_Progress(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation<D>::StartAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)this;
            check_hresult(_winrt_abi_type->StartAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation, winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation<D>::AttachAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AttachAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)this;
            check_hresult(_winrt_abi_type->AttachAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation, winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation<D>::Pause() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Pause());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)this;
            check_hresult(_winrt_abi_type->Pause());
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation<D>::Resume() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Resume());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>**)this;
            check_hresult(_winrt_abi_type->Resume());
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation2<D>::TransferGroup() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation2>**)this;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::IsRandomAccessRequired() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRandomAccessRequired(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->get_IsRandomAccessRequired(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::IsRandomAccessRequired(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsRandomAccessRequired(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->put_IsRandomAccessRequired(value));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::GetResultRandomAccessStreamReference() const
    {
        void* stream{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetResultRandomAccessStreamReference(&stream));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->GetResultRandomAccessStreamReference(&stream));
        }
        return winrt::Windows::Storage::Streams::IRandomAccessStreamReference{ stream, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::GetDownloadedRanges() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDownloadedRanges(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->GetDownloadedRanges(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferFileRange>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::RangesDownloaded(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation, winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferRangesDownloadedEventArgs> const& eventHandler) const
    {
        winrt::event_token eventCookie{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_RangesDownloaded(*(void**)(&eventHandler), put_abi(eventCookie)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->add_RangesDownloaded(*(void**)(&eventHandler), put_abi(eventCookie)));
        }
        return eventCookie;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::RangesDownloaded(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation, winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferRangesDownloadedEventArgs> const& eventHandler) const
    {
        return impl::make_event_revoker<D, RangesDownloaded_revoker>(this, RangesDownloaded(eventHandler));
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::RangesDownloaded(winrt::event_token const& eventCookie) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            _winrt_abi_type->remove_RangesDownloaded(impl::bind_in(eventCookie));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            _winrt_abi_type->remove_RangesDownloaded(impl::bind_in(eventCookie));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::RequestedUri(winrt::Windows::Foundation::Uri const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RequestedUri(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->put_RequestedUri(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::RecoverableWebErrorStatuses() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecoverableWebErrorStatuses(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->get_RecoverableWebErrorStatuses(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Web::WebErrorStatus>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation3<D>::CurrentWebErrorStatus() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrentWebErrorStatus(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>**)this;
            check_hresult(_winrt_abi_type->get_CurrentWebErrorStatus(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Web::WebErrorStatus>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation4<D>::MakeCurrentInTransferGroup() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MakeCurrentInTransferGroup());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation4>**)this;
            check_hresult(_winrt_abi_type->MakeCurrentInTransferGroup());
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation5<D>::SetRequestHeader(param::hstring const& headerName, param::hstring const& headerValue) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetRequestHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5>**)this;
            check_hresult(_winrt_abi_type->SetRequestHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IDownloadOperation5<D>::RemoveRequestHeader(param::hstring const& headerName) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveRequestHeader(*(void**)(&headerName)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5>**)this;
            check_hresult(_winrt_abi_type->RemoveRequestHeader(*(void**)(&headerName)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IResponseInformation<D>::IsResumable() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsResumable(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)this;
            check_hresult(_winrt_abi_type->get_IsResumable(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IResponseInformation<D>::ActualUri() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualUri(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)this;
            check_hresult(_winrt_abi_type->get_ActualUri(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IResponseInformation<D>::StatusCode() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StatusCode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)this;
            check_hresult(_winrt_abi_type->get_StatusCode(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IResponseInformation<D>::Headers() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Headers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>**)this;
            check_hresult(_winrt_abi_type->get_Headers(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUnconstrainedTransferRequestResult<D>::IsUnconstrained() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUnconstrainedTransferRequestResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUnconstrainedTransferRequestResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUnconstrainedTransferRequestResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsUnconstrained(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUnconstrainedTransferRequestResult>**)this;
            check_hresult(_winrt_abi_type->get_IsUnconstrained(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation<D>::SourceFile() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SourceFile(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)this;
            check_hresult(_winrt_abi_type->get_SourceFile(&value));
        }
        return winrt::Windows::Storage::IStorageFile{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation<D>::Progress() const
    {
        winrt::Windows::Networking::BackgroundTransfer::BackgroundUploadProgress value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Progress(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)this;
            check_hresult(_winrt_abi_type->get_Progress(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation<D>::StartAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)this;
            check_hresult(_winrt_abi_type->StartAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::UploadOperation, winrt::Windows::Networking::BackgroundTransfer::UploadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation<D>::AttachAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AttachAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>**)this;
            check_hresult(_winrt_abi_type->AttachAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::UploadOperation, winrt::Windows::Networking::BackgroundTransfer::UploadOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation2<D>::TransferGroup() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation2>**)this;
            check_hresult(_winrt_abi_type->get_TransferGroup(&value));
        }
        return winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation3<D>::MakeCurrentInTransferGroup() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MakeCurrentInTransferGroup());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation3>**)this;
            check_hresult(_winrt_abi_type->MakeCurrentInTransferGroup());
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation4<D>::SetRequestHeader(param::hstring const& headerName, param::hstring const& headerValue) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetRequestHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4>**)this;
            check_hresult(_winrt_abi_type->SetRequestHeader(*(void**)(&headerName), *(void**)(&headerValue)));
        }
    }
    template <typename D> auto consume_Windows_Networking_BackgroundTransfer_IUploadOperation4<D>::RemoveRequestHeader(param::hstring const& headerName) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveRequestHeader(*(void**)(&headerName)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4>**)this;
            check_hresult(_winrt_abi_type->RemoveRequestHeader(*(void**)(&headerName)));
        }
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader>
    {
        int32_t __stdcall CreateDownload(void* uri, void* resultFile, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>(this->shim().CreateDownload(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&resultFile)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateDownloadFromFile(void* uri, void* resultFile, void* requestBodyFile, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>(this->shim().CreateDownload(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&resultFile), *reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&requestBodyFile)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateDownloadAsync(void* uri, void* resultFile, void* requestBodyStream, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>(this->shim().CreateDownloadAsync(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&resultFile), *reinterpret_cast<winrt::Windows::Storage::Streams::IInputStream const*>(&requestBodyStream)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2>
    {
        int32_t __stdcall get_TransferGroup(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup>(this->shim().TransferGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransferGroup(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransferGroup(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SuccessToastNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::ToastNotification>(this->shim().SuccessToastNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SuccessToastNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SuccessToastNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::ToastNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FailureToastNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::ToastNotification>(this->shim().FailureToastNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FailureToastNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FailureToastNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::ToastNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SuccessTileNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::TileNotification>(this->shim().SuccessTileNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SuccessTileNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SuccessTileNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::TileNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FailureTileNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::TileNotification>(this->shim().FailureTileNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FailureTileNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FailureTileNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::TileNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader3> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader3>
    {
        int32_t __stdcall get_CompletionGroup(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup>(this->shim().CompletionGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderFactory> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderFactory>
    {
        int32_t __stdcall CreateWithCompletionGroup(void* completionGroup, void** backgroundDownloader) noexcept final try
        {
            clear_abi(backgroundDownloader);
            typename D::abi_guard guard(this->shim());
            *backgroundDownloader = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundDownloader>(this->shim().CreateWithCompletionGroup(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup const*>(&completionGroup)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods>
    {
        int32_t __stdcall GetCurrentDownloadsAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>>(this->shim().GetCurrentDownloadsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCurrentDownloadsForGroupAsync(void* group, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>>(this->shim().GetCurrentDownloadsAsync(*reinterpret_cast<hstring const*>(&group)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods2> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods2>
    {
        int32_t __stdcall GetCurrentDownloadsForTransferGroupAsync(void* group, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>>(this->shim().GetCurrentDownloadsForTransferGroupAsync(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const*>(&group)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderUserConsent> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderUserConsent>
    {
        int32_t __stdcall RequestUnconstrainedDownloadsAsync(void* operations, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UnconstrainedTransferRequestResult>>(this->shim().RequestUnconstrainedDownloadsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation> const*>(&operations)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase>
    {
        int32_t __stdcall SetRequestHeader(void* headerName, void* headerValue) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetRequestHeader(*reinterpret_cast<hstring const*>(&headerName), *reinterpret_cast<hstring const*>(&headerValue));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ServerCredential(void** credential) noexcept final try
        {
            clear_abi(credential);
            typename D::abi_guard guard(this->shim());
            *credential = detach_from<winrt::Windows::Security::Credentials::PasswordCredential>(this->shim().ServerCredential());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ServerCredential(void* credential) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ServerCredential(*reinterpret_cast<winrt::Windows::Security::Credentials::PasswordCredential const*>(&credential));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProxyCredential(void** credential) noexcept final try
        {
            clear_abi(credential);
            typename D::abi_guard guard(this->shim());
            *credential = detach_from<winrt::Windows::Security::Credentials::PasswordCredential>(this->shim().ProxyCredential());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ProxyCredential(void* credential) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ProxyCredential(*reinterpret_cast<winrt::Windows::Security::Credentials::PasswordCredential const*>(&credential));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Method(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Method());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Method(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Method(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Group(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Group());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Group(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Group(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CostPolicy(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy>(this->shim().CostPolicy());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CostPolicy(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CostPolicy(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup>
    {
        int32_t __stdcall get_Trigger(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Background::IBackgroundTrigger>(this->shim().Trigger());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Enable() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Enable();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails>
    {
        int32_t __stdcall get_Downloads(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>(this->shim().Downloads());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Uploads(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(this->shim().Uploads());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart>
    {
        int32_t __stdcall SetHeader(void* headerName, void* headerValue) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetHeader(*reinterpret_cast<hstring const*>(&headerName), *reinterpret_cast<hstring const*>(&headerValue));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetText(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetText(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetFile(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetFile(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory>
    {
        int32_t __stdcall CreateWithName(void* name, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart>(this->shim().CreateWithName(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateWithNameAndFileName(void* name, void* fileName, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart>(this->shim().CreateWithNameAndFileName(*reinterpret_cast<hstring const*>(&name), *reinterpret_cast<hstring const*>(&fileName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferErrorStaticMethods> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferErrorStaticMethods>
    {
        int32_t __stdcall GetStatus(int32_t hresult, int32_t* status) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *status = detach_from<winrt::Windows::Web::WebErrorStatus>(this->shim().GetStatus(hresult));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup>
    {
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransferBehavior(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferBehavior>(this->shim().TransferBehavior());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransferBehavior(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransferBehavior(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferBehavior const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroupStatics> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroupStatics>
    {
        int32_t __stdcall CreateGroup(void* name, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup>(this->shim().CreateGroup(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation>
    {
        int32_t __stdcall get_Guid(winrt::guid* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::guid>(this->shim().Guid());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RequestedUri(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().RequestedUri());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Method(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Method());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Group(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Group());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CostPolicy(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy>(this->shim().CostPolicy());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CostPolicy(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CostPolicy(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCostPolicy const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetResultStreamAt(uint64_t position, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IInputStream>(this->shim().GetResultStreamAt(position));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetResponseInformation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::ResponseInformation>(this->shim().GetResponseInformation());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority>
    {
        int32_t __stdcall get_Priority(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferPriority>(this->shim().Priority());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Priority(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Priority(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferPriority const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs>
    {
        int32_t __stdcall get_WasDownloadRestarted(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().WasDownloadRestarted());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AddedRanges(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferFileRange>>(this->shim().AddedRanges());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Deferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader>
    {
        int32_t __stdcall CreateUpload(void* uri, void* sourceFile, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>(this->shim().CreateUpload(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&sourceFile)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateUploadFromStreamAsync(void* uri, void* sourceStream, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(this->shim().CreateUploadFromStreamAsync(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Storage::Streams::IInputStream const*>(&sourceStream)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateUploadWithFormDataAndAutoBoundaryAsync(void* uri, void* parts, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(this->shim().CreateUploadAsync(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart> const*>(&parts)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateUploadWithSubTypeAsync(void* uri, void* parts, void* subType, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(this->shim().CreateUploadAsync(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart> const*>(&parts), *reinterpret_cast<hstring const*>(&subType)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateUploadWithSubTypeAndBoundaryAsync(void* uri, void* parts, void* subType, void* boundary, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(this->shim().CreateUploadAsync(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart> const*>(&parts), *reinterpret_cast<hstring const*>(&subType), *reinterpret_cast<hstring const*>(&boundary)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2>
    {
        int32_t __stdcall get_TransferGroup(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup>(this->shim().TransferGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransferGroup(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransferGroup(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SuccessToastNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::ToastNotification>(this->shim().SuccessToastNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SuccessToastNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SuccessToastNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::ToastNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FailureToastNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::ToastNotification>(this->shim().FailureToastNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FailureToastNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FailureToastNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::ToastNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SuccessTileNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::TileNotification>(this->shim().SuccessTileNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SuccessTileNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SuccessTileNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::TileNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FailureTileNotification(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Notifications::TileNotification>(this->shim().FailureTileNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FailureTileNotification(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FailureTileNotification(*reinterpret_cast<winrt::Windows::UI::Notifications::TileNotification const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader3> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader3>
    {
        int32_t __stdcall get_CompletionGroup(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup>(this->shim().CompletionGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderFactory> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderFactory>
    {
        int32_t __stdcall CreateWithCompletionGroup(void* completionGroup, void** backgroundUploader) noexcept final try
        {
            clear_abi(backgroundUploader);
            typename D::abi_guard guard(this->shim());
            *backgroundUploader = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundUploader>(this->shim().CreateWithCompletionGroup(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup const*>(&completionGroup)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods>
    {
        int32_t __stdcall GetCurrentUploadsAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>>(this->shim().GetCurrentUploadsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCurrentUploadsForGroupAsync(void* group, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>>(this->shim().GetCurrentUploadsAsync(*reinterpret_cast<hstring const*>(&group)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods2> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods2>
    {
        int32_t __stdcall GetCurrentUploadsForTransferGroupAsync(void* group, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>>(this->shim().GetCurrentUploadsForTransferGroupAsync(*reinterpret_cast<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const*>(&group)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderUserConsent> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderUserConsent>
    {
        int32_t __stdcall RequestUnconstrainedUploadsAsync(void* operations, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::BackgroundTransfer::UnconstrainedTransferRequestResult>>(this->shim().RequestUnconstrainedUploadsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Networking::BackgroundTransfer::UploadOperation> const*>(&operations)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher>
    {
        int32_t __stdcall get_ContentUris(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Foundation::Uri>>(this->shim().ContentUris());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IndirectContentUri(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IndirectContentUri(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IndirectContentUri(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().IndirectContentUri());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcherTime> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcherTime>
    {
        int32_t __stdcall get_LastSuccessfulPrefetchTime(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime>>(this->shim().LastSuccessfulPrefetchTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation>
    {
        int32_t __stdcall get_ResultFile(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::IStorageFile>(this->shim().ResultFile());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Progress(struct struct_Windows_Networking_BackgroundTransfer_BackgroundDownloadProgress* value) noexcept final try
        {
            zero_abi<winrt::Windows::Networking::BackgroundTransfer::BackgroundDownloadProgress>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundDownloadProgress>(this->shim().Progress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation, winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>(this->shim().StartAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AttachAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation, winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>(this->shim().AttachAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Pause() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Pause();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Resume() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resume();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation2> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation2>
    {
        int32_t __stdcall get_TransferGroup(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup>(this->shim().TransferGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3>
    {
        int32_t __stdcall get_IsRandomAccessRequired(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsRandomAccessRequired());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsRandomAccessRequired(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsRandomAccessRequired(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetResultRandomAccessStreamReference(void** stream) noexcept final try
        {
            clear_abi(stream);
            typename D::abi_guard guard(this->shim());
            *stream = detach_from<winrt::Windows::Storage::Streams::IRandomAccessStreamReference>(this->shim().GetResultRandomAccessStreamReference());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDownloadedRanges(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferFileRange>>(this->shim().GetDownloadedRanges());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_RangesDownloaded(void* eventHandler, winrt::event_token* eventCookie) noexcept final try
        {
            zero_abi<winrt::event_token>(eventCookie);
            typename D::abi_guard guard(this->shim());
            *eventCookie = detach_from<winrt::event_token>(this->shim().RangesDownloaded(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation, winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferRangesDownloadedEventArgs> const*>(&eventHandler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_RangesDownloaded(winrt::event_token eventCookie) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RangesDownloaded(*reinterpret_cast<winrt::event_token const*>(&eventCookie));
            return 0;
        }
        int32_t __stdcall put_RequestedUri(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RequestedUri(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RecoverableWebErrorStatuses(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Web::WebErrorStatus>>(this->shim().RecoverableWebErrorStatuses());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CurrentWebErrorStatus(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Web::WebErrorStatus>>(this->shim().CurrentWebErrorStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation4> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation4>
    {
        int32_t __stdcall MakeCurrentInTransferGroup() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MakeCurrentInTransferGroup();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5>
    {
        int32_t __stdcall SetRequestHeader(void* headerName, void* headerValue) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetRequestHeader(*reinterpret_cast<hstring const*>(&headerName), *reinterpret_cast<hstring const*>(&headerValue));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveRequestHeader(void* headerName) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveRequestHeader(*reinterpret_cast<hstring const*>(&headerName));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IResponseInformation> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IResponseInformation>
    {
        int32_t __stdcall get_IsResumable(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsResumable());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ActualUri(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().ActualUri());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StatusCode(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().StatusCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Headers(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, hstring>>(this->shim().Headers());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IUnconstrainedTransferRequestResult> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IUnconstrainedTransferRequestResult>
    {
        int32_t __stdcall get_IsUnconstrained(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsUnconstrained());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation>
    {
        int32_t __stdcall get_SourceFile(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::IStorageFile>(this->shim().SourceFile());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Progress(struct struct_Windows_Networking_BackgroundTransfer_BackgroundUploadProgress* value) noexcept final try
        {
            zero_abi<winrt::Windows::Networking::BackgroundTransfer::BackgroundUploadProgress>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundUploadProgress>(this->shim().Progress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::UploadOperation, winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(this->shim().StartAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AttachAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperationWithProgress<winrt::Windows::Networking::BackgroundTransfer::UploadOperation, winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(this->shim().AttachAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation2> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation2>
    {
        int32_t __stdcall get_TransferGroup(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup>(this->shim().TransferGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation3> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation3>
    {
        int32_t __stdcall MakeCurrentInTransferGroup() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MakeCurrentInTransferGroup();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4> : produce_base<D, winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4>
    {
        int32_t __stdcall SetRequestHeader(void* headerName, void* headerValue) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetRequestHeader(*reinterpret_cast<hstring const*>(&headerName), *reinterpret_cast<hstring const*>(&headerValue));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveRequestHeader(void* headerName) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveRequestHeader(*reinterpret_cast<hstring const*>(&headerName));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Networking::BackgroundTransfer
{
    inline BackgroundDownloader::BackgroundDownloader() :
        BackgroundDownloader(impl::call_factory_cast<BackgroundDownloader(*)(winrt::Windows::Foundation::IActivationFactory const&), BackgroundDownloader>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<BackgroundDownloader>(); }))
    {
    }
    inline BackgroundDownloader::BackgroundDownloader(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup const& completionGroup) :
        BackgroundDownloader(impl::call_factory<BackgroundDownloader, IBackgroundDownloaderFactory>([&](IBackgroundDownloaderFactory const& f) { return f.CreateWithCompletionGroup(completionGroup); }))
    {
    }
    inline auto BackgroundDownloader::GetCurrentDownloadsAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation>>(*)(IBackgroundDownloaderStaticMethods const&), BackgroundDownloader, IBackgroundDownloaderStaticMethods>([](IBackgroundDownloaderStaticMethods const& f) { return f.GetCurrentDownloadsAsync(); });
    }
    inline auto BackgroundDownloader::GetCurrentDownloadsAsync(param::hstring const& group)
    {
        return impl::call_factory<BackgroundDownloader, IBackgroundDownloaderStaticMethods>([&](IBackgroundDownloaderStaticMethods const& f) { return f.GetCurrentDownloadsAsync(group); });
    }
    inline auto BackgroundDownloader::GetCurrentDownloadsForTransferGroupAsync(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const& group)
    {
        return impl::call_factory<BackgroundDownloader, IBackgroundDownloaderStaticMethods2>([&](IBackgroundDownloaderStaticMethods2 const& f) { return f.GetCurrentDownloadsForTransferGroupAsync(group); });
    }
    inline auto BackgroundDownloader::RequestUnconstrainedDownloadsAsync(param::async_iterable<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation> const& operations)
    {
        return impl::call_factory<BackgroundDownloader, IBackgroundDownloaderUserConsent>([&](IBackgroundDownloaderUserConsent const& f) { return f.RequestUnconstrainedDownloadsAsync(operations); });
    }
    inline BackgroundTransferCompletionGroup::BackgroundTransferCompletionGroup() :
        BackgroundTransferCompletionGroup(impl::call_factory_cast<BackgroundTransferCompletionGroup(*)(winrt::Windows::Foundation::IActivationFactory const&), BackgroundTransferCompletionGroup>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<BackgroundTransferCompletionGroup>(); }))
    {
    }
    inline BackgroundTransferContentPart::BackgroundTransferContentPart() :
        BackgroundTransferContentPart(impl::call_factory_cast<BackgroundTransferContentPart(*)(winrt::Windows::Foundation::IActivationFactory const&), BackgroundTransferContentPart>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<BackgroundTransferContentPart>(); }))
    {
    }
    inline BackgroundTransferContentPart::BackgroundTransferContentPart(param::hstring const& name) :
        BackgroundTransferContentPart(impl::call_factory<BackgroundTransferContentPart, IBackgroundTransferContentPartFactory>([&](IBackgroundTransferContentPartFactory const& f) { return f.CreateWithName(name); }))
    {
    }
    inline BackgroundTransferContentPart::BackgroundTransferContentPart(param::hstring const& name, param::hstring const& fileName) :
        BackgroundTransferContentPart(impl::call_factory<BackgroundTransferContentPart, IBackgroundTransferContentPartFactory>([&](IBackgroundTransferContentPartFactory const& f) { return f.CreateWithNameAndFileName(name, fileName); }))
    {
    }
    inline auto BackgroundTransferError::GetStatus(int32_t hresult)
    {
        return impl::call_factory<BackgroundTransferError, IBackgroundTransferErrorStaticMethods>([&](IBackgroundTransferErrorStaticMethods const& f) { return f.GetStatus(hresult); });
    }
    inline auto BackgroundTransferGroup::CreateGroup(param::hstring const& name)
    {
        return impl::call_factory<BackgroundTransferGroup, IBackgroundTransferGroupStatics>([&](IBackgroundTransferGroupStatics const& f) { return f.CreateGroup(name); });
    }
    inline BackgroundUploader::BackgroundUploader() :
        BackgroundUploader(impl::call_factory_cast<BackgroundUploader(*)(winrt::Windows::Foundation::IActivationFactory const&), BackgroundUploader>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<BackgroundUploader>(); }))
    {
    }
    inline BackgroundUploader::BackgroundUploader(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup const& completionGroup) :
        BackgroundUploader(impl::call_factory<BackgroundUploader, IBackgroundUploaderFactory>([&](IBackgroundUploaderFactory const& f) { return f.CreateWithCompletionGroup(completionGroup); }))
    {
    }
    inline auto BackgroundUploader::GetCurrentUploadsAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Networking::BackgroundTransfer::UploadOperation>>(*)(IBackgroundUploaderStaticMethods const&), BackgroundUploader, IBackgroundUploaderStaticMethods>([](IBackgroundUploaderStaticMethods const& f) { return f.GetCurrentUploadsAsync(); });
    }
    inline auto BackgroundUploader::GetCurrentUploadsAsync(param::hstring const& group)
    {
        return impl::call_factory<BackgroundUploader, IBackgroundUploaderStaticMethods>([&](IBackgroundUploaderStaticMethods const& f) { return f.GetCurrentUploadsAsync(group); });
    }
    inline auto BackgroundUploader::GetCurrentUploadsForTransferGroupAsync(winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup const& group)
    {
        return impl::call_factory<BackgroundUploader, IBackgroundUploaderStaticMethods2>([&](IBackgroundUploaderStaticMethods2 const& f) { return f.GetCurrentUploadsForTransferGroupAsync(group); });
    }
    inline auto BackgroundUploader::RequestUnconstrainedUploadsAsync(param::async_iterable<winrt::Windows::Networking::BackgroundTransfer::UploadOperation> const& operations)
    {
        return impl::call_factory<BackgroundUploader, IBackgroundUploaderUserConsent>([&](IBackgroundUploaderUserConsent const& f) { return f.RequestUnconstrainedUploadsAsync(operations); });
    }
    inline auto ContentPrefetcher::ContentUris()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Foundation::Uri>(*)(IContentPrefetcher const&), ContentPrefetcher, IContentPrefetcher>([](IContentPrefetcher const& f) { return f.ContentUris(); });
    }
    inline auto ContentPrefetcher::IndirectContentUri(winrt::Windows::Foundation::Uri const& value)
    {
        impl::call_factory<ContentPrefetcher, IContentPrefetcher>([&](IContentPrefetcher const& f) { return f.IndirectContentUri(value); });
    }
    inline auto ContentPrefetcher::IndirectContentUri()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::Uri(*)(IContentPrefetcher const&), ContentPrefetcher, IContentPrefetcher>([](IContentPrefetcher const& f) { return f.IndirectContentUri(); });
    }
    inline auto ContentPrefetcher::LastSuccessfulPrefetchTime()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime>(*)(IContentPrefetcherTime const&), ContentPrefetcher, IContentPrefetcherTime>([](IContentPrefetcherTime const& f) { return f.LastSuccessfulPrefetchTime(); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloader3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderStaticMethods2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundDownloaderUserConsent> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferBase> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroup> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferCompletionGroupTriggerDetails> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPart> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferContentPartFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferErrorStaticMethods> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroup> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferGroupStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferOperationPriority> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundTransferRangesDownloadedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploader3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderStaticMethods2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IBackgroundUploaderUserConsent> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcher> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IContentPrefetcherTime> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IDownloadOperation5> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IResponseInformation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IUnconstrainedTransferRequestResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::IUploadOperation4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundDownloader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroup> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferCompletionGroupTriggerDetails> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferContentPart> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferError> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferGroup> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundTransferRangesDownloadedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::BackgroundUploader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::ContentPrefetcher> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::DownloadOperation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::ResponseInformation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::UnconstrainedTransferRequestResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::BackgroundTransfer::UploadOperation> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
