// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Media_Devices_Core_H
#define WINRT_Windows_Media_Devices_Core_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Media.Devices.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Foundation.Numerics.2.h"
#include "winrt/impl/Windows.Media.MediaProperties.2.h"
#include "winrt/impl/Windows.Perception.Spatial.2.h"
#include "winrt/impl/Windows.Media.Devices.Core.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::FocalLength() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocalLength(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->get_FocalLength(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::PrincipalPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PrincipalPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->get_PrincipalPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::RadialDistortion() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RadialDistortion(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->get_RadialDistortion(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::TangentialDistortion() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TangentialDistortion(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->get_TangentialDistortion(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::ImageWidth() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ImageWidth(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->get_ImageWidth(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::ImageHeight() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ImageHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->get_ImageHeight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::ProjectOntoFrame(winrt::Windows::Foundation::Numerics::float3 const& coordinate) const
    {
        winrt::Windows::Foundation::Point result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProjectOntoFrame(impl::bind_in(coordinate), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->ProjectOntoFrame(impl::bind_in(coordinate), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::UnprojectAtUnitDepth(winrt::Windows::Foundation::Point const& pixelCoordinate) const
    {
        winrt::Windows::Foundation::Numerics::float2 result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnprojectAtUnitDepth(impl::bind_in(pixelCoordinate), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->UnprojectAtUnitDepth(impl::bind_in(pixelCoordinate), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::ProjectManyOntoFrame(array_view<winrt::Windows::Foundation::Numerics::float3 const> coordinates, array_view<winrt::Windows::Foundation::Point> results) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProjectManyOntoFrame(coordinates.size(), get_abi(coordinates), results.size(), put_abi(results)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->ProjectManyOntoFrame(coordinates.size(), get_abi(coordinates), results.size(), put_abi(results)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics<D>::UnprojectPixelsAtUnitDepth(array_view<winrt::Windows::Foundation::Point const> pixelCoordinates, array_view<winrt::Windows::Foundation::Numerics::float2> results) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnprojectPixelsAtUnitDepth(pixelCoordinates.size(), get_abi(pixelCoordinates), results.size(), put_abi(results)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics>**)this;
            check_hresult(_winrt_abi_type->UnprojectPixelsAtUnitDepth(pixelCoordinates.size(), get_abi(pixelCoordinates), results.size(), put_abi(results)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics2<D>::UndistortedProjectionTransform() const
    {
        winrt::Windows::Foundation::Numerics::float4x4 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UndistortedProjectionTransform(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)this;
            check_hresult(_winrt_abi_type->get_UndistortedProjectionTransform(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics2<D>::DistortPoint(winrt::Windows::Foundation::Point const& input) const
    {
        winrt::Windows::Foundation::Point result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DistortPoint(impl::bind_in(input), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)this;
            check_hresult(_winrt_abi_type->DistortPoint(impl::bind_in(input), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics2<D>::DistortPoints(array_view<winrt::Windows::Foundation::Point const> inputs, array_view<winrt::Windows::Foundation::Point> results) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DistortPoints(inputs.size(), get_abi(inputs), results.size(), put_abi(results)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)this;
            check_hresult(_winrt_abi_type->DistortPoints(inputs.size(), get_abi(inputs), results.size(), put_abi(results)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics2<D>::UndistortPoint(winrt::Windows::Foundation::Point const& input) const
    {
        winrt::Windows::Foundation::Point result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UndistortPoint(impl::bind_in(input), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)this;
            check_hresult(_winrt_abi_type->UndistortPoint(impl::bind_in(input), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsics2<D>::UndistortPoints(array_view<winrt::Windows::Foundation::Point const> inputs, array_view<winrt::Windows::Foundation::Point> results) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UndistortPoints(inputs.size(), get_abi(inputs), results.size(), put_abi(results)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>**)this;
            check_hresult(_winrt_abi_type->UndistortPoints(inputs.size(), get_abi(inputs), results.size(), put_abi(results)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_ICameraIntrinsicsFactory<D>::Create(winrt::Windows::Foundation::Numerics::float2 const& focalLength, winrt::Windows::Foundation::Numerics::float2 const& principalPoint, winrt::Windows::Foundation::Numerics::float3 const& radialDistortion, winrt::Windows::Foundation::Numerics::float2 const& tangentialDistortion, uint32_t imageWidth, uint32_t imageHeight) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsicsFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::ICameraIntrinsicsFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsicsFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(impl::bind_in(focalLength), impl::bind_in(principalPoint), impl::bind_in(radialDistortion), impl::bind_in(tangentialDistortion), imageWidth, imageHeight, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::ICameraIntrinsicsFactory>**)this;
            check_hresult(_winrt_abi_type->Create(impl::bind_in(focalLength), impl::bind_in(principalPoint), impl::bind_in(radialDistortion), impl::bind_in(tangentialDistortion), imageWidth, imageHeight, &result));
        }
        return winrt::Windows::Media::Devices::Core::CameraIntrinsics{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IDepthCorrelatedCoordinateMapper<D>::UnprojectPoint(winrt::Windows::Foundation::Point const& sourcePoint, winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& targetCoordinateSystem) const
    {
        winrt::Windows::Foundation::Numerics::float3 result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnprojectPoint(impl::bind_in(sourcePoint), *(void**)(&targetCoordinateSystem), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)this;
            check_hresult(_winrt_abi_type->UnprojectPoint(impl::bind_in(sourcePoint), *(void**)(&targetCoordinateSystem), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IDepthCorrelatedCoordinateMapper<D>::UnprojectPoints(array_view<winrt::Windows::Foundation::Point const> sourcePoints, winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& targetCoordinateSystem, array_view<winrt::Windows::Foundation::Numerics::float3> results) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnprojectPoints(sourcePoints.size(), get_abi(sourcePoints), *(void**)(&targetCoordinateSystem), results.size(), put_abi(results)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)this;
            check_hresult(_winrt_abi_type->UnprojectPoints(sourcePoints.size(), get_abi(sourcePoints), *(void**)(&targetCoordinateSystem), results.size(), put_abi(results)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IDepthCorrelatedCoordinateMapper<D>::MapPoint(winrt::Windows::Foundation::Point const& sourcePoint, winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& targetCoordinateSystem, winrt::Windows::Media::Devices::Core::CameraIntrinsics const& targetCameraIntrinsics) const
    {
        winrt::Windows::Foundation::Point result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MapPoint(impl::bind_in(sourcePoint), *(void**)(&targetCoordinateSystem), *(void**)(&targetCameraIntrinsics), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)this;
            check_hresult(_winrt_abi_type->MapPoint(impl::bind_in(sourcePoint), *(void**)(&targetCoordinateSystem), *(void**)(&targetCameraIntrinsics), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IDepthCorrelatedCoordinateMapper<D>::MapPoints(array_view<winrt::Windows::Foundation::Point const> sourcePoints, winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& targetCoordinateSystem, winrt::Windows::Media::Devices::Core::CameraIntrinsics const& targetCameraIntrinsics, array_view<winrt::Windows::Foundation::Point> results) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MapPoints(sourcePoints.size(), get_abi(sourcePoints), *(void**)(&targetCoordinateSystem), *(void**)(&targetCameraIntrinsics), results.size(), put_abi(results)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>**)this;
            check_hresult(_winrt_abi_type->MapPoints(sourcePoints.size(), get_abi(sourcePoints), *(void**)(&targetCoordinateSystem), *(void**)(&targetCameraIntrinsics), results.size(), put_abi(results)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameControlCapabilities<D>::Exposure() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Exposure(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Exposure(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameExposureCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameControlCapabilities<D>::ExposureCompensation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExposureCompensation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_ExposureCompensation(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameExposureCompensationCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameControlCapabilities<D>::IsoSpeed() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsoSpeed(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsoSpeed(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameIsoSpeedCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameControlCapabilities<D>::Focus() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Focus(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Focus(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameFocusCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameControlCapabilities<D>::PhotoConfirmationSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhotoConfirmationSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_PhotoConfirmationSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameControlCapabilities2<D>::Flash() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Flash(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_Flash(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameFlashCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameController<D>::ExposureControl() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExposureControl(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)this;
            check_hresult(_winrt_abi_type->get_ExposureControl(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameExposureControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameController<D>::ExposureCompensationControl() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExposureCompensationControl(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)this;
            check_hresult(_winrt_abi_type->get_ExposureCompensationControl(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameExposureCompensationControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameController<D>::IsoSpeedControl() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsoSpeedControl(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)this;
            check_hresult(_winrt_abi_type->get_IsoSpeedControl(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameIsoSpeedControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameController<D>::FocusControl() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusControl(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)this;
            check_hresult(_winrt_abi_type->get_FocusControl(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameFocusControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameController<D>::PhotoConfirmationEnabled() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhotoConfirmationEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)this;
            check_hresult(_winrt_abi_type->get_PhotoConfirmationEnabled(&value));
        }
        return winrt::Windows::Foundation::IReference<bool>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameController<D>::PhotoConfirmationEnabled(winrt::Windows::Foundation::IReference<bool> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PhotoConfirmationEnabled(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController>**)this;
            check_hresult(_winrt_abi_type->put_PhotoConfirmationEnabled(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameController2<D>::FlashControl() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameController2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameController2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FlashControl(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameController2>**)this;
            check_hresult(_winrt_abi_type->get_FlashControl(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameFlashControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCapabilities<D>::Supported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCapabilities<D>::Min() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Min(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Min(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCapabilities<D>::Max() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Max(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Max(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCapabilities<D>::Step() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Step(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Step(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCompensationCapabilities<D>::Supported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCompensationCapabilities<D>::Min() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Min(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Min(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCompensationCapabilities<D>::Max() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Max(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Max(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCompensationCapabilities<D>::Step() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Step(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Step(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCompensationControl<D>::Value() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl>**)this;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        return winrt::Windows::Foundation::IReference<float>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureCompensationControl<D>::Value(winrt::Windows::Foundation::IReference<float> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl>**)this;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureControl<D>::Auto() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Auto(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)this;
            check_hresult(_winrt_abi_type->get_Auto(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureControl<D>::Auto(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Auto(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)this;
            check_hresult(_winrt_abi_type->put_Auto(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureControl<D>::Value() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)this;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::TimeSpan>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameExposureControl<D>::Value(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::TimeSpan> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameExposureControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameExposureControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameExposureControl>**)this;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashCapabilities<D>::Supported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashCapabilities<D>::RedEyeReductionSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RedEyeReductionSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_RedEyeReductionSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashCapabilities<D>::PowerSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PowerSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_PowerSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::Mode() const
    {
        winrt::Windows::Media::Devices::Core::FrameFlashMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::Mode(winrt::Windows::Media::Devices::Core::FrameFlashMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Mode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->put_Mode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::Auto() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Auto(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->get_Auto(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::Auto(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Auto(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->put_Auto(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::RedEyeReduction() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RedEyeReduction(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->get_RedEyeReduction(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::RedEyeReduction(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RedEyeReduction(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->put_RedEyeReduction(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::PowerPercent() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PowerPercent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->get_PowerPercent(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFlashControl<D>::PowerPercent(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFlashControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PowerPercent(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFlashControl>**)this;
            check_hresult(_winrt_abi_type->put_PowerPercent(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFocusCapabilities<D>::Supported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFocusCapabilities<D>::Min() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Min(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Min(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFocusCapabilities<D>::Max() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Max(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Max(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFocusCapabilities<D>::Step() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Step(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Step(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFocusControl<D>::Value() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFocusControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFocusControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusControl>**)this;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        return winrt::Windows::Foundation::IReference<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameFocusControl<D>::Value(winrt::Windows::Foundation::IReference<uint32_t> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameFocusControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameFocusControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameFocusControl>**)this;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedCapabilities<D>::Supported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedCapabilities<D>::Min() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Min(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Min(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedCapabilities<D>::Max() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Max(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Max(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedCapabilities<D>::Step() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Step(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Step(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedControl<D>::Auto() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Auto(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)this;
            check_hresult(_winrt_abi_type->get_Auto(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedControl<D>::Auto(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Auto(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)this;
            check_hresult(_winrt_abi_type->put_Auto(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedControl<D>::Value() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)this;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        return winrt::Windows::Foundation::IReference<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IFrameIsoSpeedControl<D>::Value(winrt::Windows::Foundation::IReference<uint32_t> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>**)this;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::Supported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->get_Supported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::MaxPhotosPerSecond() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxPhotosPerSecond(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->get_MaxPhotosPerSecond(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::PhotosPerSecondLimit() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhotosPerSecondLimit(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->get_PhotosPerSecondLimit(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::PhotosPerSecondLimit(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PhotosPerSecondLimit(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->put_PhotosPerSecondLimit(value));
        }
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::GetHighestConcurrentFrameRate(winrt::Windows::Media::MediaProperties::IMediaEncodingProperties const& captureProperties) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetHighestConcurrentFrameRate(*(void**)(&captureProperties), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->GetHighestConcurrentFrameRate(*(void**)(&captureProperties), &value));
        }
        return winrt::Windows::Media::MediaProperties::MediaRatio{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::GetCurrentFrameRate() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentFrameRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->GetCurrentFrameRate(&value));
        }
        return winrt::Windows::Media::MediaProperties::MediaRatio{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::FrameCapabilities() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FrameCapabilities(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->get_FrameCapabilities(&value));
        }
        return winrt::Windows::Media::Devices::Core::FrameControlCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Media_Devices_Core_IVariablePhotoSequenceController<D>::DesiredFrameControllers() const
    {
        void* items{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DesiredFrameControllers(&items));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>**)this;
            check_hresult(_winrt_abi_type->get_DesiredFrameControllers(&items));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Media::Devices::Core::FrameController>{ items, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics> : produce_base<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics>
    {
        int32_t __stdcall get_FocalLength(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().FocalLength());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PrincipalPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().PrincipalPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RadialDistortion(winrt::Windows::Foundation::Numerics::float3* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3>(this->shim().RadialDistortion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TangentialDistortion(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().TangentialDistortion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ImageWidth(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ImageWidth());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ImageHeight(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ImageHeight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ProjectOntoFrame(winrt::Windows::Foundation::Numerics::float3 coordinate, winrt::Windows::Foundation::Point* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Point>(this->shim().ProjectOntoFrame(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&coordinate)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UnprojectAtUnitDepth(winrt::Windows::Foundation::Point pixelCoordinate, winrt::Windows::Foundation::Numerics::float2* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().UnprojectAtUnitDepth(*reinterpret_cast<winrt::Windows::Foundation::Point const*>(&pixelCoordinate)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ProjectManyOntoFrame(uint32_t __coordinatesSize, winrt::Windows::Foundation::Numerics::float3* coordinates, uint32_t __resultsSize, winrt::Windows::Foundation::Point* results) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(results, __resultsSize);
            typename D::abi_guard guard(this->shim());
            this->shim().ProjectManyOntoFrame(array_view<winrt::Windows::Foundation::Numerics::float3 const>(reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const *>(coordinates), reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const *>(coordinates) + __coordinatesSize), array_view<winrt::Windows::Foundation::Point>(reinterpret_cast<winrt::Windows::Foundation::Point*>(results), reinterpret_cast<winrt::Windows::Foundation::Point*>(results) + __resultsSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UnprojectPixelsAtUnitDepth(uint32_t __pixelCoordinatesSize, winrt::Windows::Foundation::Point* pixelCoordinates, uint32_t __resultsSize, winrt::Windows::Foundation::Numerics::float2* results) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(results, __resultsSize);
            typename D::abi_guard guard(this->shim());
            this->shim().UnprojectPixelsAtUnitDepth(array_view<winrt::Windows::Foundation::Point const>(reinterpret_cast<winrt::Windows::Foundation::Point const *>(pixelCoordinates), reinterpret_cast<winrt::Windows::Foundation::Point const *>(pixelCoordinates) + __pixelCoordinatesSize), array_view<winrt::Windows::Foundation::Numerics::float2>(reinterpret_cast<winrt::Windows::Foundation::Numerics::float2*>(results), reinterpret_cast<winrt::Windows::Foundation::Numerics::float2*>(results) + __resultsSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics2> : produce_base<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsics2>
    {
        int32_t __stdcall get_UndistortedProjectionTransform(winrt::Windows::Foundation::Numerics::float4x4* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float4x4>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float4x4>(this->shim().UndistortedProjectionTransform());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DistortPoint(winrt::Windows::Foundation::Point input, winrt::Windows::Foundation::Point* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Point>(this->shim().DistortPoint(*reinterpret_cast<winrt::Windows::Foundation::Point const*>(&input)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DistortPoints(uint32_t __inputsSize, winrt::Windows::Foundation::Point* inputs, uint32_t __resultsSize, winrt::Windows::Foundation::Point* results) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(results, __resultsSize);
            typename D::abi_guard guard(this->shim());
            this->shim().DistortPoints(array_view<winrt::Windows::Foundation::Point const>(reinterpret_cast<winrt::Windows::Foundation::Point const *>(inputs), reinterpret_cast<winrt::Windows::Foundation::Point const *>(inputs) + __inputsSize), array_view<winrt::Windows::Foundation::Point>(reinterpret_cast<winrt::Windows::Foundation::Point*>(results), reinterpret_cast<winrt::Windows::Foundation::Point*>(results) + __resultsSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UndistortPoint(winrt::Windows::Foundation::Point input, winrt::Windows::Foundation::Point* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Point>(this->shim().UndistortPoint(*reinterpret_cast<winrt::Windows::Foundation::Point const*>(&input)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UndistortPoints(uint32_t __inputsSize, winrt::Windows::Foundation::Point* inputs, uint32_t __resultsSize, winrt::Windows::Foundation::Point* results) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(results, __resultsSize);
            typename D::abi_guard guard(this->shim());
            this->shim().UndistortPoints(array_view<winrt::Windows::Foundation::Point const>(reinterpret_cast<winrt::Windows::Foundation::Point const *>(inputs), reinterpret_cast<winrt::Windows::Foundation::Point const *>(inputs) + __inputsSize), array_view<winrt::Windows::Foundation::Point>(reinterpret_cast<winrt::Windows::Foundation::Point*>(results), reinterpret_cast<winrt::Windows::Foundation::Point*>(results) + __resultsSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsicsFactory> : produce_base<D, winrt::Windows::Media::Devices::Core::ICameraIntrinsicsFactory>
    {
        int32_t __stdcall Create(winrt::Windows::Foundation::Numerics::float2 focalLength, winrt::Windows::Foundation::Numerics::float2 principalPoint, winrt::Windows::Foundation::Numerics::float3 radialDistortion, winrt::Windows::Foundation::Numerics::float2 tangentialDistortion, uint32_t imageWidth, uint32_t imageHeight, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::Devices::Core::CameraIntrinsics>(this->shim().Create(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&focalLength), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&principalPoint), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&radialDistortion), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&tangentialDistortion), imageWidth, imageHeight));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper> : produce_base<D, winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper>
    {
        int32_t __stdcall UnprojectPoint(winrt::Windows::Foundation::Point sourcePoint, void* targetCoordinateSystem, winrt::Windows::Foundation::Numerics::float3* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Numerics::float3>(this->shim().UnprojectPoint(*reinterpret_cast<winrt::Windows::Foundation::Point const*>(&sourcePoint), *reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&targetCoordinateSystem)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UnprojectPoints(uint32_t __sourcePointsSize, winrt::Windows::Foundation::Point* sourcePoints, void* targetCoordinateSystem, uint32_t __resultsSize, winrt::Windows::Foundation::Numerics::float3* results) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3>(results, __resultsSize);
            typename D::abi_guard guard(this->shim());
            this->shim().UnprojectPoints(array_view<winrt::Windows::Foundation::Point const>(reinterpret_cast<winrt::Windows::Foundation::Point const *>(sourcePoints), reinterpret_cast<winrt::Windows::Foundation::Point const *>(sourcePoints) + __sourcePointsSize), *reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&targetCoordinateSystem), array_view<winrt::Windows::Foundation::Numerics::float3>(reinterpret_cast<winrt::Windows::Foundation::Numerics::float3*>(results), reinterpret_cast<winrt::Windows::Foundation::Numerics::float3*>(results) + __resultsSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MapPoint(winrt::Windows::Foundation::Point sourcePoint, void* targetCoordinateSystem, void* targetCameraIntrinsics, winrt::Windows::Foundation::Point* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Point>(this->shim().MapPoint(*reinterpret_cast<winrt::Windows::Foundation::Point const*>(&sourcePoint), *reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&targetCoordinateSystem), *reinterpret_cast<winrt::Windows::Media::Devices::Core::CameraIntrinsics const*>(&targetCameraIntrinsics)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MapPoints(uint32_t __sourcePointsSize, winrt::Windows::Foundation::Point* sourcePoints, void* targetCoordinateSystem, void* targetCameraIntrinsics, uint32_t __resultsSize, winrt::Windows::Foundation::Point* results) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(results, __resultsSize);
            typename D::abi_guard guard(this->shim());
            this->shim().MapPoints(array_view<winrt::Windows::Foundation::Point const>(reinterpret_cast<winrt::Windows::Foundation::Point const *>(sourcePoints), reinterpret_cast<winrt::Windows::Foundation::Point const *>(sourcePoints) + __sourcePointsSize), *reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&targetCoordinateSystem), *reinterpret_cast<winrt::Windows::Media::Devices::Core::CameraIntrinsics const*>(&targetCameraIntrinsics), array_view<winrt::Windows::Foundation::Point>(reinterpret_cast<winrt::Windows::Foundation::Point*>(results), reinterpret_cast<winrt::Windows::Foundation::Point*>(results) + __resultsSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities>
    {
        int32_t __stdcall get_Exposure(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameExposureCapabilities>(this->shim().Exposure());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExposureCompensation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameExposureCompensationCapabilities>(this->shim().ExposureCompensation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsoSpeed(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameIsoSpeedCapabilities>(this->shim().IsoSpeed());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Focus(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameFocusCapabilities>(this->shim().Focus());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhotoConfirmationSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PhotoConfirmationSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities2> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameControlCapabilities2>
    {
        int32_t __stdcall get_Flash(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameFlashCapabilities>(this->shim().Flash());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameController> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameController>
    {
        int32_t __stdcall get_ExposureControl(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameExposureControl>(this->shim().ExposureControl());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExposureCompensationControl(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameExposureCompensationControl>(this->shim().ExposureCompensationControl());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsoSpeedControl(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameIsoSpeedControl>(this->shim().IsoSpeedControl());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FocusControl(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameFocusControl>(this->shim().FocusControl());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhotoConfirmationEnabled(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<bool>>(this->shim().PhotoConfirmationEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PhotoConfirmationEnabled(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PhotoConfirmationEnabled(*reinterpret_cast<winrt::Windows::Foundation::IReference<bool> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameController2> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameController2>
    {
        int32_t __stdcall get_FlashControl(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameFlashControl>(this->shim().FlashControl());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities>
    {
        int32_t __stdcall get_Supported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Supported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Min(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().Min());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Max(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().Max());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Step(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().Step());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities>
    {
        int32_t __stdcall get_Supported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Supported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Min(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Min());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Max(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Max());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Step(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Step());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl>
    {
        int32_t __stdcall get_Value(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<float>>(this->shim().Value());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Value(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Value(*reinterpret_cast<winrt::Windows::Foundation::IReference<float> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameExposureControl> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameExposureControl>
    {
        int32_t __stdcall get_Auto(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Auto());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Auto(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Auto(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Value(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::TimeSpan>>(this->shim().Value());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Value(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Value(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::TimeSpan> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities>
    {
        int32_t __stdcall get_Supported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Supported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RedEyeReductionSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().RedEyeReductionSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PowerSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PowerSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameFlashControl>
    {
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameFlashMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Mode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Mode(*reinterpret_cast<winrt::Windows::Media::Devices::Core::FrameFlashMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Auto(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Auto());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Auto(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Auto(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RedEyeReduction(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().RedEyeReduction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RedEyeReduction(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RedEyeReduction(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PowerPercent(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().PowerPercent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PowerPercent(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PowerPercent(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities>
    {
        int32_t __stdcall get_Supported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Supported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Min(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Min());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Max(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Max());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Step(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Step());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameFocusControl> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameFocusControl>
    {
        int32_t __stdcall get_Value(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<uint32_t>>(this->shim().Value());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Value(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Value(*reinterpret_cast<winrt::Windows::Foundation::IReference<uint32_t> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities>
    {
        int32_t __stdcall get_Supported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Supported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Min(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Min());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Max(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Max());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Step(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Step());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl> : produce_base<D, winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl>
    {
        int32_t __stdcall get_Auto(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Auto());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Auto(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Auto(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Value(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<uint32_t>>(this->shim().Value());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Value(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Value(*reinterpret_cast<winrt::Windows::Foundation::IReference<uint32_t> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController> : produce_base<D, winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController>
    {
        int32_t __stdcall get_Supported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Supported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxPhotosPerSecond(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().MaxPhotosPerSecond());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhotosPerSecondLimit(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().PhotosPerSecondLimit());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PhotosPerSecondLimit(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PhotosPerSecondLimit(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetHighestConcurrentFrameRate(void* captureProperties, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::MediaProperties::MediaRatio>(this->shim().GetHighestConcurrentFrameRate(*reinterpret_cast<winrt::Windows::Media::MediaProperties::IMediaEncodingProperties const*>(&captureProperties)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCurrentFrameRate(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::MediaProperties::MediaRatio>(this->shim().GetCurrentFrameRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FrameCapabilities(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Media::Devices::Core::FrameControlCapabilities>(this->shim().FrameCapabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DesiredFrameControllers(void** items) noexcept final try
        {
            clear_abi(items);
            typename D::abi_guard guard(this->shim());
            *items = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::Media::Devices::Core::FrameController>>(this->shim().DesiredFrameControllers());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Media::Devices::Core
{
    inline CameraIntrinsics::CameraIntrinsics(winrt::Windows::Foundation::Numerics::float2 const& focalLength, winrt::Windows::Foundation::Numerics::float2 const& principalPoint, winrt::Windows::Foundation::Numerics::float3 const& radialDistortion, winrt::Windows::Foundation::Numerics::float2 const& tangentialDistortion, uint32_t imageWidth, uint32_t imageHeight) :
        CameraIntrinsics(impl::call_factory<CameraIntrinsics, ICameraIntrinsicsFactory>([&](ICameraIntrinsicsFactory const& f) { return f.Create(focalLength, principalPoint, radialDistortion, tangentialDistortion, imageWidth, imageHeight); }))
    {
    }
    inline FrameController::FrameController() :
        FrameController(impl::call_factory_cast<FrameController(*)(winrt::Windows::Foundation::IActivationFactory const&), FrameController>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<FrameController>(); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Media::Devices::Core::ICameraIntrinsics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::ICameraIntrinsics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::ICameraIntrinsicsFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IDepthCorrelatedCoordinateMapper> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameControlCapabilities2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameController> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameController2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameExposureCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameExposureCompensationControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameExposureControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameFlashCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameFlashControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameFocusCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameFocusControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IFrameIsoSpeedControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::IVariablePhotoSequenceController> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::CameraIntrinsics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::DepthCorrelatedCoordinateMapper> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameControlCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameController> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameExposureCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameExposureCompensationCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameExposureCompensationControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameExposureControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameFlashCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameFlashControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameFocusCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameFocusControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameIsoSpeedCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::FrameIsoSpeedControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Media::Devices::Core::VariablePhotoSequenceController> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
