# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Utility classes."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _common
else:
    import _common

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class TBB(object):
    r"""
    Threading parameters.

    The number of threads is the value associated to the `TBB-ThreadsNumber` key
    in :class:`~openturns.ResourceMap`, which is initialized to the available cpus,
    and can be overridden by the `OPENTURNS_NUM_THREADS` environment variable.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def Enable():
        r"""Enable threading."""
        return _common.TBB_Enable()

    @staticmethod
    def Disable():
        r"""Disable threading."""
        return _common.TBB_Disable()

    @staticmethod
    def SetThreadsNumber(threadsNumber):
        r"""
        Accessor to the maximum number of TBB threads.

        Parameters
        ----------
        n_threads : int
            Maximum number of TBB threads.
        """
        return _common.TBB_SetThreadsNumber(threadsNumber)

    @staticmethod
    def GetThreadsNumber():
        r"""
        Accessor to the maximum number of TBB threads.

        Returns
        -------
        n_threads : int
            Maximum number of TBB threads.
        """
        return _common.TBB_GetThreadsNumber()
    __swig_destroy__ = _common.delete_TBB

# Register TBB in _common:
_common.TBB_swigregister(TBB)
class Object(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __swig_destroy__ = _common.delete_Object

    def __repr__(self):
        return _common.Object___repr__(self)

    def _repr_html_(self):
        return _common.Object__repr_html_(self)

    def __str__(self, *args):
        return _common.Object___str__(self, *args)

    def __repr_markdown__(self):
        return _common.Object___repr_markdown__(self)

# Register Object in _common:
_common.Object_swigregister(Object)

def Object___getstate__(self):
    import tempfile
    import os
    state = {}
    study = Study()

# assume xml support
    infile = tempfile.NamedTemporaryFile(delete=False, suffix='.xml')
    try:
        study.setStorageManager(XMLH5StorageManager(infile.name))
        state['format'] = 'xmlh5'
    except:
        study.setStorageManager(XMLStorageManager(infile.name))
        state['format'] = 'xml'
    study.add('instance', self)
    study.save()
    infile.seek(0)
    state['xmldata'] = infile.read()
    infile.close()
    os.remove(infile.name)
    if state['format'] == 'xmlh5':
        h5filename = infile.name.replace('.xml', '.h5')
        try:
            with open(h5filename, 'rb') as h5file:
                state['h5data'] = h5file.read()
            os.remove(h5filename)
        except FileNotFoundError:
            pass # no h5 data
    return state

Object.__getstate__ = Object___getstate__

def Object___setstate__(self, state):
    import tempfile
    import os

# call ctor to initialize underlying cxx obj
# as it is instantiated from object.__new__
    self.__init__()

    study = Study()
    outfile = tempfile.NamedTemporaryFile(delete=False, suffix='.xml')
    outfile.write(state['xmldata'])
    outfile.seek(0)
    if 'h5data' in state:
        h5filename = outfile.name.replace('.xml', '.h5')
        with open(h5filename, 'wb') as h5file:
            h5file.write(state['h5data'])
    if state.get('format', 'xml') == 'xmlh5':
        study.setStorageManager(XMLH5StorageManager(outfile.name))
    else:
        study.setStorageManager(XMLStorageManager(outfile.name))
    study.load()
    outfile.close()
    os.remove(outfile.name)
    if 'h5data' in state:
        os.remove(h5filename)
    study.fillObject('instance', self)

Object.__setstate__ = Object___setstate__

def Object__repr_html_(self):
    lines = str(self).splitlines()
    return '<p>' + '<br>\n'.join(lines) + '</p>'
Object._repr_html_ = Object__repr_html_

class PersistentObject(Object):
    r"""PersistentObject saves and reloads the object's internal state."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.PersistentObject_getClassName(self)
    __swig_destroy__ = _common.delete_PersistentObject

    def __eq__(self, other):
        return _common.PersistentObject___eq__(self, other)

    def __ne__(self, other):
        return _common.PersistentObject___ne__(self, other)

    def __repr__(self):
        return _common.PersistentObject___repr__(self)

    def __str__(self, *args):
        return _common.PersistentObject___str__(self, *args)

    def __repr_markdown__(self):
        return _common.PersistentObject___repr_markdown__(self)

    def _repr_html_(self):
        return _common.PersistentObject__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common.PersistentObject_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.PersistentObject_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.PersistentObject_setName(self, name)

# Register PersistentObject in _common:
_common.PersistentObject_swigregister(PersistentObject)
class InterfaceObject(Object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.InterfaceObject_getClassName(self)

    def __repr__(self):
        return _common.InterfaceObject___repr__(self)

    def __str__(self, *args):
        return _common.InterfaceObject___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.InterfaceObject_getId(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.InterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.InterfaceObject_getName(self)
    __swig_destroy__ = _common.delete_InterfaceObject

# Register InterfaceObject in _common:
_common.InterfaceObject_swigregister(InterfaceObject)
class _StringVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _common._StringVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _common._StringVector___nonzero__(self)

    def __bool__(self):
        return _common._StringVector___bool__(self)

    def __len__(self):
        return _common._StringVector___len__(self)

    def __getslice__(self, i, j):
        return _common._StringVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _common._StringVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _common._StringVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _common._StringVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _common._StringVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _common._StringVector___setitem__(self, *args)

    def pop(self):
        return _common._StringVector_pop(self)

    def append(self, x):
        return _common._StringVector_append(self, x)

    def empty(self):
        return _common._StringVector_empty(self)

    def size(self):
        return _common._StringVector_size(self)

    def swap(self, v):
        return _common._StringVector_swap(self, v)

    def begin(self):
        return _common._StringVector_begin(self)

    def end(self):
        return _common._StringVector_end(self)

    def rbegin(self):
        return _common._StringVector_rbegin(self)

    def rend(self):
        return _common._StringVector_rend(self)

    def clear(self):
        return _common._StringVector_clear(self)

    def get_allocator(self):
        return _common._StringVector_get_allocator(self)

    def pop_back(self):
        return _common._StringVector_pop_back(self)

    def erase(self, *args):
        return _common._StringVector_erase(self, *args)

    def __init__(self, *args):
        _common._StringVector_swiginit(self, _common.new__StringVector(*args))

    def push_back(self, x):
        return _common._StringVector_push_back(self, x)

    def front(self):
        return _common._StringVector_front(self)

    def back(self):
        return _common._StringVector_back(self)

    def assign(self, n, x):
        return _common._StringVector_assign(self, n, x)

    def resize(self, *args):
        return _common._StringVector_resize(self, *args)

    def insert(self, *args):
        return _common._StringVector_insert(self, *args)

    def reserve(self, n):
        return _common._StringVector_reserve(self, n)

    def capacity(self):
        return _common._StringVector_capacity(self)
    __swig_destroy__ = _common.delete__StringVector

# Register _StringVector in _common:
_common._StringVector_swigregister(_StringVector)
class Study(Object):
    r"""
    Save/load a Study.

    Parameters
    ----------
    fileName : str
        Name of the file used by the underlying storage manager,
        a :class:`~openturns.XMLStorageManager` in this case.
    compressionLevel : int, optional
        Compression level of the resulting XML file, in the range 0,...,9 (0=no compression, 9=best compression).
        The compression is done only if the XML lib has been compiled with zlib support.
        The default value is given by 'XMLStorageManager-DefaultCompressionLevel' in :class:`~openturns.ResourceMap`.

    Notes
    -----
    The study allows the user to save all its data to a structure looking like a
    map. The data are copied verbatim to the study. This is not a link, so future
    modification of the original won't affect the data saved in the study. To
    update the data saved in the study, the user has to explicitly save it again.
    Study allows the user to retrieve previously saved objects either by their name
    if a name was defined for the object or by their Id.

    If the study contains Python wrapper classes (:class:`~openturns.PythonFunction`,
    :class:`~openturns.PythonDistribution`, etc) serialization of the pure Python
    parts of the objects go through the pickle module or the dill module if available.
    The latter allows one to serialize objects including their Python definition which
    means the study can be reloaded in a Python environment that does not include
    their Python class or function definition contrary to the default pickle module.
    In that regard it can be useful to set the *recurse* setting of dill before
    saving.

    Examples
    --------
    >>> import openturns as ot

    Create a Study object:

    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))
    >>> myStudy2 = ot.Study('myStudy2.xml')
    >>> myStudy3 = ot.Study('myStudy2.xml.gz', 5)

    If HDF5 format dependencies are satisfied:

    >>> myStudy4 = ot.Study()  # doctest: +SKIP
    >>> myStudy4.setStorageManager(ot.XMLH5StorageManager('myStudy.xml'))  # doctest: +SKIP

    Add PersistentObjects to the study:

    >>> # a Point:
    >>> point = ot.Point(3, 0.0)
    >>> point[0] = 10.0
    >>> point[1] = 11.0
    >>> point[2] = 12.0
    >>> myStudy.add('point', point)
    >>> # a simulation result:
    >>> simulationResult = ot.ProbabilitySimulationResult(ot.ThresholdEvent(), 0.5, 0.01, 150, 4)
    >>> myStudy.add('simulationResult', simulationResult)

    Get objects from the study:

    >>> print(myStudy.getObject('point'))
    [10,11,12]

    Save the Study:

    >>> myStudy.save()

    Create a new Study object:

    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))

    Load data from the study:

    >>> myStudy.load()

    Create data from the ones stored in the study:

    >>> # a Point:
    >>> otherPoint = ot.Point()
    >>> myStudy.fillObject('point', otherPoint)
    >>> # a simulation result:
    >>> otherSimulationResult = ot.ProbabilitySimulationResult()
    >>> myStudy.fillObject('simulationResult', otherSimulationResult)

    Get information from the study:

    >>> myStudy.getLabels()
    ('point', 'simulationResult')

    Remove data:

    >>> myStudy.hasObject('simulationResult')
    True
    >>> myStudy.remove('simulationResult')
    >>> myStudy.hasObject('simulationResult')
    False
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Study_getClassName(self)

    def __repr__(self):
        return _common.Study___repr__(self)

    def __str__(self, *args):
        return _common.Study___str__(self, *args)

    def save(self):
        r"""Save the study through the storage manager."""
        return _common.Study_save(self)

    def load(self):
        r"""Reload the study from the storage manager."""
        return _common.Study_load(self)

    def setStorageManager(self, smgr):
        r"""
        Set the storage manager used by the study.

        Returns
        -------
        manager : :class:`~openturns.StorageManager`
            Storage manager used by the study to save and reload data.
        """
        return _common.Study_setStorageManager(self, smgr)

    def getStorageManager(self):
        r"""
        Get the storage manager used by the study.

        Parameters
        ----------
        manager : :class:`~openturns.StorageManager`
            Storage manager used by the study to save and reload data.
        """
        return _common.Study_getStorageManager(self)

    def add(self, *args):
        r"""
        Add an object to the study.

        :Available usages:
            add(*object*)

            add(*name, object, force=False*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            Object to add in the study.
        name : str
            Name to associate with the object.
        force : bool
            If *force=True* and *name* is already defined in the study, the previous
            object associated with this name is removed. A error message is emitted
            otherwise.
        """
        return _common.Study_add(self, *args)

    def remove(self, *args):
        r"""
        Remove an object from the study.

        :Available usages:
            remove(*object*)

            remove(*name*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`
            An object to be removed.
        name : str
            Name of the object to be removed.
        """
        return _common.Study_remove(self, *args)

    def hasObject(self, *args):
        r"""
        Query if object is stored in study.

        :Available usages:
            hasObject(*id*)

            hasObject(*name*)

        Parameters
        ----------
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.

        Returns
        -------
        hasObject : bool
            *True* if the object is stored in the study.
        """
        return _common.Study_hasObject(self, *args)

    def getObject(self, *args):
        r"""
        Get object from the study.

        :Available usages:
            getObject(*id*)

            getObject(*name*)

        Parameters
        ----------
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.

        Returns
        -------
        object : :class:`~openturns.PersistentObject`
            The object saved in the study.
        """
        return _common.Study_getObject(self, *args)

    def fillObjectByName(self, *args):
        r"""
        Fill an object with one got from study.

        :Available usages:
            fillObjectByName(*object, name*)

            fillObjectByName(*id, object*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            An object to be refilled (may be empty, i.e. default constructed).
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.
        """
        return _common.Study_fillObjectByName(self, *args)

    def fillObject(self, *args):
        r"""
        Fill an object with one got from study.

        :Available usages:
            fillObject(*name, object*)

            fillObject(*id, object*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            An object to be refilled (may be empty, i.e. default constructed).
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.
        """
        return _common.Study_fillObject(self, *args)

    def getLabels(self):
        r"""
        Accessor to the labels of the stored objects.

        Returns
        -------
        labels : tuple of str
            Labels of the objects stored in the study.
        """
        return _common.Study_getLabels(self)

    def __init__(self, *args):
        _common.Study_swiginit(self, _common.new_Study(*args))
    __swig_destroy__ = _common.delete_Study

# Register Study in _common:
_common.Study_swigregister(Study)
class StorageManager(Object):
    r"""
    Define the way OpenTURNS' objects are saved and reloaded.

    Available constructors:
        StorageManager(*defaultVersion=1*)

    Parameters
    ----------
    defaultVersion : positive int
        Argument interpreted as the name of the object in a user point of view.
        This name is never used in another way than for user information. This name
        has no meaning to the platform.

    Notes
    -----
    A StorageManager object can be used only through its derived classes
    including :class:`~openturns.XMLStorageManager` and its HDF5 counterpart.

    See also
    --------
    XMLStorageManager
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.StorageManager_getClassName(self)

    def __init__(self, defaultVersion=1):
        _common.StorageManager_swiginit(self, _common.new_StorageManager(defaultVersion))

    def __repr__(self):
        return _common.StorageManager___repr__(self)

    def getDefaultStudyVersion(self):
        r"""
        Return the version of the study that the manager can read/write.

        Returns
        -------
        version : positive int
            Version of the study that the manager can read/write.
        """
        return _common.StorageManager_getDefaultStudyVersion(self)

    def getStudyVersion(self):
        r"""
        Get the study version.

        Returns
        -------
        version : positive int
            Study version.
        """
        return _common.StorageManager_getStudyVersion(self)

    def setStudyVersion(self, version):
        r"""
        Set the study version.

        Parameters
        ----------
        version : positive int
            Study version.
        """
        return _common.StorageManager_setStudyVersion(self, version)
    __swig_destroy__ = _common.delete_StorageManager

# Register StorageManager in _common:
_common.StorageManager_swigregister(StorageManager)
class XMLStorageManager(StorageManager):
    r"""
    Storage manager that drives a XML file.

    This class allows one to read and write objects from an XML file.

    Parameters
    ----------
    fileName : str
        Name of the file containing the study.
    compressionLevel : int, optional
        Compression level of the resulting XML file, in the range 0,...,9 (0=no compression, 9=best compression).
        The compression is done only if the XML lib has been compiled with zlib support.
        The default value is given by 'XMLStorageManager-DefaultCompressionLevel' in :class:`~openturns.ResourceMap`.

    See also
    --------
    StorageManager

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a study:
    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))  # doctest: +SKIP
    >>> myStudy2 = ot.Study()  # doctest: +SKIP
    >>> myStudy2.setStorageManager(ot.XMLStorageManager('myStudy2.xml.gz', 5))  # doctest: +SKIP
    >>> # Add an object in the study:
    >>> simulationResult = ot.ProbabilitySimulationResult(ot.ThresholdEvent(), 0.5, 0.01, 150, 4)  # doctest: +SKIP
    >>> myStudy.add('simulationResult', simulationResult)  # doctest: +SKIP
    >>> # Save the Study in the file myStudy.xml:
    >>> myStudy.save()  # doctest: +SKIP
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.XMLStorageManager_getClassName(self)

    def __init__(self, *args):
        _common.XMLStorageManager_swiginit(self, _common.new_XMLStorageManager(*args))

    def __repr__(self):
        return _common.XMLStorageManager___repr__(self)

    def getFileName(self):
        r"""
        Get the name of the file containing the study.

        Returns
        -------
        fileName : str
            Name of the file containing the study.
        """
        return _common.XMLStorageManager_getFileName(self)

    def setFileName(self, fileName):
        r"""
        Set the name of the file containing the study.

        Parameters
        ----------
        fileName : str
            Name of the file containing the study.
        """
        return _common.XMLStorageManager_setFileName(self, fileName)
    __swig_destroy__ = _common.delete_XMLStorageManager

# Register XMLStorageManager in _common:
_common.XMLStorageManager_swigregister(XMLStorageManager)
class XMLH5StorageManager(XMLStorageManager):
    r"""
    Storage manager that drives XML/H5 files.

    This class allows one to read and write objects from a XML/H5 files pair.
    The XML part saves the metadata while the H5 binary file save the sample data.

    Parameters
    ----------
    fileName : str
        Name of the file containing the study.
        Will also specify the name of the h5 file, which will be created next to the XML file.
    compressionLevel : int, optional
        Compression level of the resulting XML and H5 files, in the range 0,...,9 (0=no compression, 9=best compression).
        The compression is only available if the XML and HDF5 libraries have been compiled with zlib support.
        The default value is given by 'XMLStorageManager-DefaultCompressionLevel' in :class:`~openturns.ResourceMap`.

    See also
    --------
    StorageManager
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.XMLH5StorageManager_getClassName(self)

    def __init__(self, *args):
        _common.XMLH5StorageManager_swiginit(self, _common.new_XMLH5StorageManager(*args))
    __swig_destroy__ = _common.delete_XMLH5StorageManager

# Register XMLH5StorageManager in _common:
_common.XMLH5StorageManager_swigregister(XMLH5StorageManager)
class TTY(object):
    r"""
    Console utilities.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    DEFAULT = _common.TTY_DEFAULT
    BOLD = _common.TTY_BOLD
    UNDERLINE = _common.TTY_UNDERLINE
    BLINK = _common.TTY_BLINK
    BLACKFG = _common.TTY_BLACKFG
    REDFG = _common.TTY_REDFG
    GREENFG = _common.TTY_GREENFG
    YELLOWFG = _common.TTY_YELLOWFG
    BLUEFG = _common.TTY_BLUEFG
    PURPLEFG = _common.TTY_PURPLEFG
    CYANFG = _common.TTY_CYANFG
    WHITEFG = _common.TTY_WHITEFG
    BLACKBG = _common.TTY_BLACKBG
    REDBG = _common.TTY_REDBG
    GREENBG = _common.TTY_GREENBG
    YELLOWBG = _common.TTY_YELLOWBG
    BLUEBG = _common.TTY_BLUEBG
    PURPLEBG = _common.TTY_PURPLEBG
    CYANBG = _common.TTY_CYANBG
    WHITEBG = _common.TTY_WHITEBG
    LASTCOLOR = _common.TTY_LASTCOLOR

    @staticmethod
    def ShowColors(flag):
        r"""
        Accessor to the color flag.

        Parameters
        ----------
        flag : bool
            Enable or disable colored output.
        """
        return _common.TTY_ShowColors(flag)

    @staticmethod
    def ColoredOutput():
        r"""
        Accessor to the color flag.

        Returns
        -------
        flag : bool
            Whether colored output is enabled or disabled.
        """
        return _common.TTY_ColoredOutput()
    __swig_destroy__ = _common.delete_TTY

# Register TTY in _common:
_common.TTY_swigregister(TTY)
class Log(object):
    r"""
    Logging utilities.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def Debug(msg):
        r"""
        Log debug message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Debug(msg)

    @staticmethod
    def HasDebug():
        r"""
        Test whether debug level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasDebug()

    @staticmethod
    def Info(msg):
        r"""
        Log information message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Info(msg)

    @staticmethod
    def HasInfo():
        r"""
        Test whether information level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasInfo()

    @staticmethod
    def User(msg):
        r"""
        Log user message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_User(msg)

    @staticmethod
    def HasUser():
        r"""
        Test whether user level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasUser()

    @staticmethod
    def Warn(msg):
        r"""
        Log warning message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Warn(msg)

    @staticmethod
    def HasWarn():
        r"""
        Test whether warning level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasWarn()

    @staticmethod
    def Error(msg):
        r"""
        Log error message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Error(msg)

    @staticmethod
    def HasError():
        r"""
        Test whether error level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasError()

    @staticmethod
    def Trace(msg):
        r"""
        Log execution trace message.

        Parameters
        ----------
        message : str
            The message to log.
        """
        return _common.Log_Trace(msg)

    @staticmethod
    def HasTrace():
        r"""
        Test whether execution trace level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasTrace()

    @staticmethod
    def SetFile(file):
        r"""
        Redirect logs to a file.

        Parameters
        ----------
        file_name : str
            Log file name

        Examples
        --------
        Write warnings in a file:

        >>> import openturns as ot
        >>> ot.Log.SetFile('Warnings.log')

        Set to an empty string to stop redirection:

        >>> ot.Log.SetFile('')
        """
        return _common.Log_SetFile(file)

    @staticmethod
    def Show(flags):
        r"""
        Accessor to the log flags.

        Parameters
        ----------
        flags : int
            Log flags to enable.

            Available values to be ORed:

            - DBG
            - INFO
            - USER
            - WARN
            - ERROR
            - TRACE
            - DEFAULT
            - NONE
            - ALL

        Examples
        --------
        Turn warnings off:

        >>> import openturns as ot
        >>> ot.Log.Show(ot.Log.NONE)
        """
        return _common.Log_Show(flags)

    @staticmethod
    def Flags():
        r"""
        Accessor to the log flags.

        Returns
        -------
        flags : int
            The enabled log flags.
        """
        return _common.Log_Flags()

    @staticmethod
    def Flush():
        r"""Flush pending messages."""
        return _common.Log_Flush()

    @staticmethod
    def Repeat(repeat):
        r"""
        Whether to report repeated messages.

        Parameters
        ----------
        repeat : bool
            Whether to report repeated messages
        """
        return _common.Log_Repeat(repeat)

    @staticmethod
    def SetColor(*args):
        r"""
        Color accessor.

        Parameters
        ----------
        severity : int
            Log level
        color : str or int
            Log color
        """
        return _common.Log_SetColor(*args)

    @staticmethod
    def GetColor(severity):
        r"""
        Color accessor.

        Parameters
        ----------
        severity : int
            Log level

        Returns
        -------
        color : str
            Log color
        """
        return _common.Log_GetColor(severity)
    __swig_destroy__ = _common.delete_Log

# Register Log in _common:
_common.Log_swigregister(Log)
cvar = _common.cvar
Log.DBG = _common.cvar.Log_DBG
Log.INFO = _common.cvar.Log_INFO
Log.USER = _common.cvar.Log_USER
Log.WARN = _common.cvar.Log_WARN
Log.ERROR = _common.cvar.Log_ERROR
Log.TRACE = _common.cvar.Log_TRACE
Log.DEFAULT = _common.cvar.Log_DEFAULT
Log.NONE = _common.cvar.Log_NONE
Log.ALL = _common.cvar.Log_ALL

class Path(object):
    r"""
    Path utilities.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def GetInstallationDirectory():
        r"""
        Accessor to the installation directory.

        Returns
        -------
        installDir : str
            The installation prefix.
        """
        return _common.Path_GetInstallationDirectory()

    @staticmethod
    def GetConfigDirectoryList():
        r"""
        Accessor to config directories.

        Returns
        -------
        dirList : list of str
            The list of directories searched for config files.
        """
        return _common.Path_GetConfigDirectoryList()

    @staticmethod
    def GetLibraryDirectory():
        r"""
        Accessor to the library directory.

        Returns
        -------
        dir : str
            The directory containing the shared library.
        """
        return _common.Path_GetLibraryDirectory()
    __swig_destroy__ = _common.delete_Path

# Register Path in _common:
_common.Path_swigregister(Path)
class ResourceMap(object):
    r"""
    The ResourceMap allows one to manage constants that are associated to key strings.

    Find below the ResourceMap's content:

    .. execforresourcemap::

    Examples
    --------
    Get some keys:

    >>> import openturns as ot
    >>> for key in ot.ResourceMap.GetKeys()[:4]:
    ...     print(key)
    ARMA-MeanEpsilon
    ARMALikelihoodFactory-DefaultMaximumCallsNumber
    ARMALikelihoodFactory-DefaultRhoBeg
    ARMALikelihoodFactory-DefaultRhoEnd
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    @staticmethod
    def GetType(key):
        r"""
        Access the type of a parameter.

        Parameters
        ----------
        key : str, possible values are 'str','int','float' or 'bool'
            An identifier associated to the parameter.

        Returns
        -------
        type : str
            The type associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetType('Distribution-SupportEpsilon')
        'float'
        """
        return _common.ResourceMap_GetType(key)

    @staticmethod
    def Get(key):
        r"""
        Access a parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : str
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Get('WeightedExperiment-DefaultSize')
        '100'
        """
        return _common.ResourceMap_Get(key)

    @staticmethod
    def GetAsString(key):
        r"""
        Access a string parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : str
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Get('WeightedExperiment-DefaultSize')
        '100'
        """
        return _common.ResourceMap_GetAsString(key)

    @staticmethod
    def GetAsBool(key):
        r"""
        Access a boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : bool
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals')
        True
        """
        return _common.ResourceMap_GetAsBool(key)

    @staticmethod
    def GetAsUnsignedInteger(key):
        r"""
        Access an integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : int
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsUnsignedInteger('RandomWalkMetropolisHastings-DefaultBurnIn')
        1000
        """
        return _common.ResourceMap_GetAsUnsignedInteger(key)

    @staticmethod
    def GetAsScalar(key):
        r"""
        Access a floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : float
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsScalar('SQP-DefaultTau')
        0.5
        """
        return _common.ResourceMap_GetAsScalar(key)

    @staticmethod
    def Set(key, value):
        r"""
        Access an existing parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : str
            The value associated to that key. If the key already exists as a *float*,
            an *int* or a *bool*, the given string is converted into the
            corresponding type.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Set('Distribution-SupportEpsilon', '1.0e-14')

        """
        return _common.ResourceMap_Set(key, value)

    @staticmethod
    def SetAsString(key, value):
        r"""
        Set an existing string parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : str
            The value associated to that key. The key is added to the string map even if
            it already exists in another map (float, int or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsString('View-ImageFormat', 'png')
        """
        return _common.ResourceMap_SetAsString(key, value)

    @staticmethod
    def SetAsBool(key, value):
        r"""
        Set an existing boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : bool
            The value associated to that key. The key is added to the bool map even if
            it already exists in another map (float, int or str).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals', True)
        """
        return _common.ResourceMap_SetAsBool(key, value)

    @staticmethod
    def SetAsUnsignedInteger(key, value):
        r"""
        Set an existing integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : int
            The value associated to that key. The key is added to the integer
            map even if it already exists in another map (float, str or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsUnsignedInteger('RandomWalkMetropolisHastings-DefaultBurnIn', 1000)
        """
        return _common.ResourceMap_SetAsUnsignedInteger(key, value)

    @staticmethod
    def SetAsScalar(key, value):
        r"""
        Set an existing floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : float
            The value associated to that key. The key is added to the float map even if
            it already exists in another map (str, int or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsScalar('SQP-DefaultTau', 0.5)
        """
        return _common.ResourceMap_SetAsScalar(key, value)

    @staticmethod
    def AddAsString(*args):
        r"""
        Add a new string parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : str
            The value associated to that key. The key is added to the string map even if
            it already exists in another map (float, int or bool).
        enumValues : sequence of str, optional
            Possible values. Default is an empty list.

            When non-empty the :meth:`SetAsString` calls will make sure the
            value associated to that key is part of the list of the possible supplied values.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsString('View-ImageFormat2', 'png')
        >>> ot.ResourceMap.RemoveKey('View-ImageFormat2')
        >>> ot.ResourceMap.AddAsString('View-ImageFormat3', 'png', ['png', 'jpg', 'bmp'])
        >>> ot.ResourceMap.RemoveKey('View-ImageFormat3')
        """
        return _common.ResourceMap_AddAsString(*args)

    @staticmethod
    def AddAsBool(key, value):
        r"""
        Add a new boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : bool
            The value associated to that key. The key is added to the bool map even if
            it already exists in another map (float, int or str).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals2', True)
        >>> ot.ResourceMap.RemoveKey('MaximumEntropyOrderStatisticsDistribution-CheckMarginals2')
        """
        return _common.ResourceMap_AddAsBool(key, value)

    @staticmethod
    def AddAsUnsignedInteger(key, value):
        r"""
        Add a new integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : int
            The value associated to that key. The key is added to the integer
            map even if it already exists in another map (float, str or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsUnsignedInteger('RandomWalkMetropolisHastings-DefaultBurnIn2', 0)
        >>> ot.ResourceMap.RemoveKey('RandomWalkMetropolisHastings-DefaultBurnIn2')
        """
        return _common.ResourceMap_AddAsUnsignedInteger(key, value)

    @staticmethod
    def AddAsScalar(key, value):
        r"""
        Add a new floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : float
            The value associated to that key. The key is added to the float map even if
            it already exists in another map (str, int or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsScalar('SQP-DefaultTau2', 0.5)
        >>> ot.ResourceMap.RemoveKey('SQP-DefaultTau2')
        """
        return _common.ResourceMap_AddAsScalar(key, value)

    @staticmethod
    def GetSize():
        r"""
        Get the size of the ResourceMap.

        Returns
        -------
        size : positive int
            The number of constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetSize()

    @staticmethod
    def GetStringSize():
        r"""
        Get the size of the string map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *string* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetStringSize()

    @staticmethod
    def GetScalarSize():
        r"""
        Get the size of the float map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *float* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetScalarSize()

    @staticmethod
    def GetUnsignedIntegerSize():
        r"""
        Get the size of the unsigned integer map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *int* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetUnsignedIntegerSize()

    @staticmethod
    def GetBoolSize():
        r"""
        Get the size of the bool map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *bool* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetBoolSize()

    @staticmethod
    def GetKeys():
        r"""
        Get the keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of identifiers.
        """
        return _common.ResourceMap_GetKeys()

    @staticmethod
    def GetStringKeys():
        r"""
        Get the string keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *string* identifiers.
        """
        return _common.ResourceMap_GetStringKeys()

    @staticmethod
    def GetScalarKeys():
        r"""
        Get the float keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *float* identifiers.
        """
        return _common.ResourceMap_GetScalarKeys()

    @staticmethod
    def GetUnsignedIntegerKeys():
        r"""
        Get the unsigned integer keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *int* identifiers.
        """
        return _common.ResourceMap_GetUnsignedIntegerKeys()

    @staticmethod
    def GetBoolKeys():
        r"""
        Get the bool keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *bool* identifiers.
        """
        return _common.ResourceMap_GetBoolKeys()

    @staticmethod
    def GetStringEnum(key):
        r"""
        Get the possible values of a string enum.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        enums : tuple of str
            The list of possible values.
        """
        return _common.ResourceMap_GetStringEnum(key)

    @staticmethod
    def HasKey(key):
        r"""
        Check if an entry exists.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        has_key : bool
            Whether an entry with that key exists.
        """
        return _common.ResourceMap_HasKey(key)

    @staticmethod
    def HasStringEnum(key):
        r"""
        Check if an entry is associated to a string enum.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        hasStringEnum : bool
            Whether an entry with that key exists.
        """
        return _common.ResourceMap_HasStringEnum(key)

    @staticmethod
    def RemoveKey(key):
        r"""
        Remove an entry.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsString('dummy_key', 'key_to_be_removed')
        >>> ot.ResourceMap.RemoveKey('dummy_key')
        """
        return _common.ResourceMap_RemoveKey(key)

    @staticmethod
    def Reload():
        r"""
        Reload the configuration.

        Reverts the values of the default keys and erases new keys.
        """
        return _common.ResourceMap_Reload()

    @staticmethod
    def FindKeys(substr):
        r"""
        Find keys matching a pattern.

        Parameters
        ----------
        substr : str
            A pattern to search.

        Returns
        -------
        value : sequence of str
            The keys matching the pattern.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.FindKeys('Multinomial')
        ('Multinomial-eta', 'Multinomial-smallA')
        """
        return _common.ResourceMap_FindKeys(substr)

    def __repr__(self):
        return _common.ResourceMap___repr__(self)

    @staticmethod
    def __len__():
        return _common.ResourceMap___len__()
    __swig_destroy__ = _common.delete_ResourceMap

# Register ResourceMap in _common:
_common.ResourceMap_swigregister(ResourceMap)
class ComparisonOperatorImplementation(PersistentObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperatorImplementation_getClassName(self)

    def __repr__(self):
        return _common.ComparisonOperatorImplementation___repr__(self)

    def __call__(self, a, b):
        return _common.ComparisonOperatorImplementation___call__(self, a, b)

    def __init__(self, *args):
        _common.ComparisonOperatorImplementation_swiginit(self, _common.new_ComparisonOperatorImplementation(*args))
    __swig_destroy__ = _common.delete_ComparisonOperatorImplementation

# Register ComparisonOperatorImplementation in _common:
_common.ComparisonOperatorImplementation_swigregister(ComparisonOperatorImplementation)
class _ComparisonOperatorImplementationTypedInterfaceObject(InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _common._ComparisonOperatorImplementationTypedInterfaceObject_swiginit(self, _common.new__ComparisonOperatorImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _common._ComparisonOperatorImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common._ComparisonOperatorImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common._ComparisonOperatorImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _common._ComparisonOperatorImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _common._ComparisonOperatorImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _common.delete__ComparisonOperatorImplementationTypedInterfaceObject

# Register _ComparisonOperatorImplementationTypedInterfaceObject in _common:
_common._ComparisonOperatorImplementationTypedInterfaceObject_swigregister(_ComparisonOperatorImplementationTypedInterfaceObject)
class ComparisonOperator(_ComparisonOperatorImplementationTypedInterfaceObject):
    r"""
    Base class for comparison operators.

    Notes
    -----
    Comparison operators are defined through the following implementations : 
    :class:`~openturns.Equal`, :class:`~openturns.Greater`,
    :class:`~openturns.GreaterOrEqual`, :class:`~openturns.Less` or 
    :class:`~openturns.LessOrEqual`

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperator_getClassName(self)

    def __call__(self, a, b):
        return _common.ComparisonOperator___call__(self, a, b)

    def compare(self, a, b):
        r"""
        Compare two values.

        Parameters
        ----------
        a : float
            First input to compare.
        b : float
            Second input to compare.
        """
        return _common.ComparisonOperator_compare(self, a, b)

    def __repr__(self):
        return _common.ComparisonOperator___repr__(self)

    def __init__(self, *args):
        _common.ComparisonOperator_swiginit(self, _common.new_ComparisonOperator(*args))
    __swig_destroy__ = _common.delete_ComparisonOperator

# Register ComparisonOperator in _common:
_common.ComparisonOperator_swigregister(ComparisonOperator)
class Equal(ComparisonOperatorImplementation):
    r"""
    Equal comparison operator.

    See also
    --------
    Greater, GreaterOrEqual, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Equal()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    True

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Equal_getClassName(self)

    def __repr__(self):
        return _common.Equal___repr__(self)

    def __str__(self, *args):
        return _common.Equal___str__(self, *args)

    def __call__(self, a, b):
        return _common.Equal___call__(self, a, b)

    def __init__(self, *args):
        _common.Equal_swiginit(self, _common.new_Equal(*args))
    __swig_destroy__ = _common.delete_Equal

# Register Equal in _common:
_common.Equal_swigregister(Equal)
class Greater(ComparisonOperatorImplementation):
    r"""
    Greater comparison operator.

    See also
    --------
    Equal, GreaterOrEqual, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Greater()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    True
    >>> print(operator(2, 2))
    False

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Greater_getClassName(self)

    def __repr__(self):
        return _common.Greater___repr__(self)

    def __str__(self, *args):
        return _common.Greater___str__(self, *args)

    def __call__(self, a, b):
        return _common.Greater___call__(self, a, b)

    def __init__(self, *args):
        _common.Greater_swiginit(self, _common.new_Greater(*args))
    __swig_destroy__ = _common.delete_Greater

# Register Greater in _common:
_common.Greater_swigregister(Greater)
class GreaterOrEqual(ComparisonOperatorImplementation):
    r"""
    Greater or equal comparison operator.

    See also
    --------
    Equal, Greater, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.GreaterOrEqual()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    True
    >>> print(operator(2, 2))
    True

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.GreaterOrEqual_getClassName(self)

    def __repr__(self):
        return _common.GreaterOrEqual___repr__(self)

    def __str__(self, *args):
        return _common.GreaterOrEqual___str__(self, *args)

    def __call__(self, a, b):
        return _common.GreaterOrEqual___call__(self, a, b)

    def __init__(self, *args):
        _common.GreaterOrEqual_swiginit(self, _common.new_GreaterOrEqual(*args))
    __swig_destroy__ = _common.delete_GreaterOrEqual

# Register GreaterOrEqual in _common:
_common.GreaterOrEqual_swigregister(GreaterOrEqual)
class Less(ComparisonOperatorImplementation):
    r"""
    Less comparison operator.

    See also
    --------
    Equal, Greater, GreaterOrEqual, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Less()
    >>> print(operator(1, 2))
    True
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    False

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Less_getClassName(self)

    def __repr__(self):
        return _common.Less___repr__(self)

    def __str__(self, *args):
        return _common.Less___str__(self, *args)

    def __call__(self, a, b):
        return _common.Less___call__(self, a, b)

    def __init__(self, *args):
        _common.Less_swiginit(self, _common.new_Less(*args))
    __swig_destroy__ = _common.delete_Less

# Register Less in _common:
_common.Less_swigregister(Less)
class LessOrEqual(ComparisonOperatorImplementation):
    r"""
    Less or equal comparison operator.

    See also
    --------
    Equal, Greater, GreaterOrEqual, Less

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.LessOrEqual()
    >>> print(operator(1, 2))
    True
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    True

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.LessOrEqual_getClassName(self)

    def __repr__(self):
        return _common.LessOrEqual___repr__(self)

    def __str__(self, *args):
        return _common.LessOrEqual___str__(self, *args)

    def __call__(self, a, b):
        return _common.LessOrEqual___call__(self, a, b)

    def __init__(self, *args):
        _common.LessOrEqual_swiginit(self, _common.new_LessOrEqual(*args))
    __swig_destroy__ = _common.delete_LessOrEqual

# Register LessOrEqual in _common:
_common.LessOrEqual_swigregister(LessOrEqual)
class _ComparisonOperatorImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_common._ComparisonOperatorImplementationPointer_ptr__get, _common._ComparisonOperatorImplementationPointer_ptr__set)

    def __init__(self, *args):
        _common._ComparisonOperatorImplementationPointer_swiginit(self, _common.new__ComparisonOperatorImplementationPointer(*args))
    __swig_destroy__ = _common.delete__ComparisonOperatorImplementationPointer

    def reset(self):
        return _common._ComparisonOperatorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _common._ComparisonOperatorImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _common._ComparisonOperatorImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _common._ComparisonOperatorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _common._ComparisonOperatorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common._ComparisonOperatorImplementationPointer_get(self)

    def getImplementation(self):
        return _common._ComparisonOperatorImplementationPointer_getImplementation(self)

    def unique(self):
        return _common._ComparisonOperatorImplementationPointer_unique(self)

    def use_count(self):
        return _common._ComparisonOperatorImplementationPointer_use_count(self)

    def swap(self, other):
        return _common._ComparisonOperatorImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common._ComparisonOperatorImplementationPointer_getClassName(self)

    def __repr__(self):
        return _common._ComparisonOperatorImplementationPointer___repr__(self)

    def __call__(self, a, b):
        return _common._ComparisonOperatorImplementationPointer___call__(self, a, b)

    def __eq__(self, other):
        return _common._ComparisonOperatorImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _common._ComparisonOperatorImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _common._ComparisonOperatorImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _common._ComparisonOperatorImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _common._ComparisonOperatorImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common._ComparisonOperatorImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common._ComparisonOperatorImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common._ComparisonOperatorImplementationPointer_setName(self, name)

# Register _ComparisonOperatorImplementationPointer in _common:
_common._ComparisonOperatorImplementationPointer_swigregister(_ComparisonOperatorImplementationPointer)
class _PersistentObjectPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_common._PersistentObjectPointer_ptr__get, _common._PersistentObjectPointer_ptr__set)

    def __init__(self, *args):
        _common._PersistentObjectPointer_swiginit(self, _common.new__PersistentObjectPointer(*args))
    __swig_destroy__ = _common.delete__PersistentObjectPointer

    def reset(self):
        return _common._PersistentObjectPointer_reset(self)

    def __ref__(self, *args):
        return _common._PersistentObjectPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _common._PersistentObjectPointer___deref__(self, *args)

    def isNull(self):
        return _common._PersistentObjectPointer_isNull(self)

    def __nonzero__(self):
        return _common._PersistentObjectPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common._PersistentObjectPointer_get(self)

    def getImplementation(self):
        return _common._PersistentObjectPointer_getImplementation(self)

    def unique(self):
        return _common._PersistentObjectPointer_unique(self)

    def use_count(self):
        return _common._PersistentObjectPointer_use_count(self)

    def swap(self, other):
        return _common._PersistentObjectPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common._PersistentObjectPointer_getClassName(self)

    def __eq__(self, other):
        return _common._PersistentObjectPointer___eq__(self, other)

    def __ne__(self, other):
        return _common._PersistentObjectPointer___ne__(self, other)

    def __repr__(self):
        return _common._PersistentObjectPointer___repr__(self)

    def __str__(self, *args):
        return _common._PersistentObjectPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _common._PersistentObjectPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _common._PersistentObjectPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common._PersistentObjectPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common._PersistentObjectPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common._PersistentObjectPointer_setName(self, name)

# Register _PersistentObjectPointer in _common:
_common._PersistentObjectPointer_swigregister(_PersistentObjectPointer)
class _StorageManagerPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_common._StorageManagerPointer_ptr__get, _common._StorageManagerPointer_ptr__set)

    def __init__(self, *args):
        _common._StorageManagerPointer_swiginit(self, _common.new__StorageManagerPointer(*args))
    __swig_destroy__ = _common.delete__StorageManagerPointer

    def reset(self):
        return _common._StorageManagerPointer_reset(self)

    def __ref__(self, *args):
        return _common._StorageManagerPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _common._StorageManagerPointer___deref__(self, *args)

    def isNull(self):
        return _common._StorageManagerPointer_isNull(self)

    def __nonzero__(self):
        return _common._StorageManagerPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common._StorageManagerPointer_get(self)

    def getImplementation(self):
        return _common._StorageManagerPointer_getImplementation(self)

    def unique(self):
        return _common._StorageManagerPointer_unique(self)

    def use_count(self):
        return _common._StorageManagerPointer_use_count(self)

    def swap(self, other):
        return _common._StorageManagerPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common._StorageManagerPointer_getClassName(self)

    def __repr__(self):
        return _common._StorageManagerPointer___repr__(self)

    def getDefaultStudyVersion(self):
        r"""
        Return the version of the study that the manager can read/write.

        Returns
        -------
        version : positive int
            Version of the study that the manager can read/write.
        """
        return _common._StorageManagerPointer_getDefaultStudyVersion(self)

    def getStudyVersion(self):
        r"""
        Get the study version.

        Returns
        -------
        version : positive int
            Study version.
        """
        return _common._StorageManagerPointer_getStudyVersion(self)

    def setStudyVersion(self, version):
        r"""
        Set the study version.

        Parameters
        ----------
        version : positive int
            Study version.
        """
        return _common._StorageManagerPointer_setStudyVersion(self, version)

    def _repr_html_(self):
        return _common._StorageManagerPointer__repr_html_(self)

    def __str__(self, *args):
        return _common._StorageManagerPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _common._StorageManagerPointer___repr_markdown__(self)

# Register _StorageManagerPointer in _common:
_common._StorageManagerPointer_swigregister(_StorageManagerPointer)

