# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Probabilistic distributions."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _dist_bundle3
else:
    import _dist_bundle3

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _dist_bundle3.delete_SwigPyIterator

    def value(self):
        return _dist_bundle3.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _dist_bundle3.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _dist_bundle3.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _dist_bundle3.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _dist_bundle3.SwigPyIterator_equal(self, x)

    def copy(self):
        return _dist_bundle3.SwigPyIterator_copy(self)

    def next(self):
        return _dist_bundle3.SwigPyIterator_next(self)

    def __next__(self):
        return _dist_bundle3.SwigPyIterator___next__(self)

    def previous(self):
        return _dist_bundle3.SwigPyIterator_previous(self)

    def advance(self, n):
        return _dist_bundle3.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _dist_bundle3.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _dist_bundle3.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _dist_bundle3.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _dist_bundle3.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _dist_bundle3.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _dist_bundle3.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _dist_bundle3:
_dist_bundle3.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class OrderStatisticsMarginalChecker(openturns.common.Object):
    r"""
    Compatibility tests of marginals with respect to the order statistics constraint.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.Distribution`
        The marginals :math:`(F_1, \dots, F_n)` which are tested with respect to the order :math:`F_1 < \dots < F_n` in the context of the maximum order statistics distribution.

    Notes
    -----

    Three tests are performed. We note :math:`[a_i,b_i]` the range of :math:`X_i`. The tests are :

    - Test 1 checks that :math:`a_i \leq a_{i+1}` and :math:`b_i \leq b_{i+1}` for all :math:`i`.

    - Test 2 discretizes :math:`[0,1]` with :math:`\{\dfrac{1}{2n},\dfrac{3}{2n}, \dots,\dfrac{2n-1}{2n}\} = \{q_1, \dots, q_{2n-1} \}` where :math:`n` is defined in the :class:`~openturns.ResourceMap` with `OSMC-OptimizationEpsilon`. By default, :math:`n=100`. Test 2 checks that:

      .. math::

          F_k^{-1}(q_j) \geq F_{k-1}^{-1}(q_j)+\epsilon, \quad 1 \leq j \leq d

      where :math:`\epsilon` is defined in the :class:`~openturns.ResourceMap` with `OSMC-QuantileIteration`. By default, :math:`\epsilon=10^{-7}`.

    - Test 3 checks that: 

      .. math::

          \min_{q \in [q_{j-1}, q_j]} \{F_k^{-1}(q) - F_{k-1}^{-1}(q) \} \geq \epsilon

      using the TNC algorithm.


    Examples
    --------
    Create the test checker:

    >>> import openturns as ot
    >>> coll = [ot.Uniform(-1.0, 1.0), ot.Uniform(-0.5, 1.5)]
    >>> testChecker = ot.OrderStatisticsMarginalChecker(coll)

    Check the compatibility:

    >>> compatibilityResult = testChecker.isCompatible()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_getClassName(self)

    def isCompatible(self):
        r"""
        Result of the compatibility tests.

        Returns
        -------
        resCompatibility : bool
            The final result of the 3 compatibility tests with respect to the order constraint.
        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_isCompatible(self)

    def check(self):
        r"""
        Give the reasons of uncompatibility of the margins if any.

        Notes
        -----
        This method throws an exception in case of compatibility problem with a message indicating the first compatibility problem arised.

        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_check(self)

    def buildPartition(self):
        r"""
        Accessor to the partition in independent marginal sets if any.

        Returns
        -------
        indepMarginals : :class:`~openturns.Indices`
            Indicates the indices that build some independent sets of marginals. If we note :math:`indepMarginals = [i_1, i_2]` then the sub random vectors :math:`(X_1, \dots, X_{i_1})`,  :math:`(X_{i_1+1}, \dots, X_{i_2})` and  :math:`(X_{i_2+1}, \dots, X_n)` are independent.
            This information is automatically used by OpenTURNS to build the appropriated maximum entropy order statistics distribution.
        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_buildPartition(self)

    def getOptimizationAlgorithm(self):
        return _dist_bundle3.OrderStatisticsMarginalChecker_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        return _dist_bundle3.OrderStatisticsMarginalChecker_setOptimizationAlgorithm(self, solver)

    def __init__(self, *args):
        _dist_bundle3.OrderStatisticsMarginalChecker_swiginit(self, _dist_bundle3.new_OrderStatisticsMarginalChecker(*args))
    __swig_destroy__ = _dist_bundle3.delete_OrderStatisticsMarginalChecker

# Register OrderStatisticsMarginalChecker in _dist_bundle3:
_dist_bundle3.OrderStatisticsMarginalChecker_swigregister(OrderStatisticsMarginalChecker)
class ParametrizedDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Parametrized distribution.

    Available constructors:
        ParametrizedDistribution(*parameters*)

    Parameters
    ----------
    parameters : :class:`~openturns.DistributionParameters`
        Parameters of the distribution to be created.

    See also
    --------
    Distribution

    Notes
    -----
    A *ParametrizedDistribution* object enables to create a distribution with
    non-native parameters defined thanks to the class
    :class:`~openturns.DistributionParameters`.

    Examples
    --------
    Create the parameters of the Gamma distribution:

    >>> import openturns as ot
    >>> parameters = ot.GammaMuSigma(1.5, 2.5, -0.5)

    Create the distribution:

    >>> distribution = ot.ParametrizedDistribution(parameters)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.ParametrizedDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.ParametrizedDistribution___eq__(self, *args)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.ParametrizedDistribution_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.ParametrizedDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.ParametrizedDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.ParametrizedDistribution_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.ParametrizedDistribution_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.ParametrizedDistribution_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.ParametrizedDistribution_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.ParametrizedDistribution_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.ParametrizedDistribution_computeCDFGradient(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`0 < p < 1`
            Quantile function input (a probability).
        tail : bool, optional (default=False)
            Whether p should be interpreted as the complementary probability.

        Returns
        -------
        X : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            Quantile at probability level :math:`p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_{\vect{X}}(p) = F_{\vect{X}}^{-1}(p),
                              \quad p \in [0; 1]
        """
        return _dist_bundle3.ParametrizedDistribution_computeQuantile(self, *args)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\alpha`.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _dist_bundle3.ParametrizedDistribution_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\alpha`.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the bilateral confidence interval at level 0.9 with marginal probability:

        >>> confInt, marginalProb = paramDist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _dist_bundle3.ParametrizedDistribution_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)

    def computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail):
        r"""
        Compute a unilateral confidence interval.

        Refer to :func:`computeUnilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.
        tail : boolean
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level :math:`\alpha`.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, False)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, True)
        >>> ot.ResourceMap.Reload()

        """
        return _dist_bundle3.ParametrizedDistribution_computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\alpha`.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.ParametrizedDistribution_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.ParametrizedDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.ParametrizedDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.ParametrizedDistribution_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.ParametrizedDistribution_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ParametrizedDistribution_isContinuous(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.ParametrizedDistribution_getRoughness(self)

    def getMean(self):
        r"""
        Accessor to the mean.

        Returns
        -------
        k : :class:`~openturns.Point`
            Mean.

        Notes
        -----
        The mean is the first-order moment:

        .. math::

            \vect{\mu} = \Tr{\left(\Expect{X_i}, \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ParametrizedDistribution_getMean(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.ParametrizedDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ParametrizedDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ParametrizedDistribution_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.ParametrizedDistribution_getStandardRepresentative(self)

    def __repr__(self):
        return _dist_bundle3.ParametrizedDistribution___repr__(self)

    def __init__(self, *args):
        _dist_bundle3.ParametrizedDistribution_swiginit(self, _dist_bundle3.new_ParametrizedDistribution(*args))
    __swig_destroy__ = _dist_bundle3.delete_ParametrizedDistribution

# Register ParametrizedDistribution in _dist_bundle3:
_dist_bundle3.ParametrizedDistribution_swigregister(ParametrizedDistribution)
class Poisson(openturns.model_copula.DiscreteDistribution):
    r"""
    Poisson distribution.

    Parameters
    ----------
    lambda : float, :math:`\lambda > 0`
        Mean and variance value.

        Default value is 1.0.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{X = k} = \frac{\lambda^k}{k!}\;e^{-\lambda}, \,  k \in \Nset

    It is evaluated using  Loader's algorithm, the *fast* and *accurate* method described in [loader2000]_,
    with the further improvements mentioned in [dimitriadis2016]_, see :meth:`~openturns.DistFunc.dPoisson`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \lambda \\
            \Var{X} & = & \sqrt{\lambda}
        \end{eqnarray*}

    The sampling is done using the rejection algorithm described in [devroye1986]_
    and [stadlober1990]_, see :meth:`~openturns.DistFunc.rPoisson`.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Poisson(10.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Poisson_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Poisson___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Poisson___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Poisson___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Poisson_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Poisson_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.Poisson_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Poisson_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.Poisson_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Poisson_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Poisson_computeCDFGradient(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Poisson_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.Poisson_computeLogCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input :math:`X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle3.Poisson_computeGeneratingFunction(self, z)

    def computeLogGeneratingFunction(self, z):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input :math:`X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle3.Poisson_computeLogGeneratingFunction(self, z)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.Poisson_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Poisson_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Poisson_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Poisson_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Poisson_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Poisson_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Poisson_getParameterDescription(self)

    def setLambda(self, _lambda):
        r"""
        Accessor to the distribution's mean and variance value.

        Parameters
        ----------
        lambda : float
            Distribution's mean and variance value.
        """
        return _dist_bundle3.Poisson_setLambda(self, _lambda)

    def getLambda(self):
        r"""
        Accessor to the distribution's mean and variance value.

        Returns
        -------
        lambda : float
            Distribution's mean and variance value.
        """
        return _dist_bundle3.Poisson_getLambda(self)

    def __init__(self, *args):
        _dist_bundle3.Poisson_swiginit(self, _dist_bundle3.new_Poisson(*args))
    __swig_destroy__ = _dist_bundle3.delete_Poisson

# Register Poisson in _dist_bundle3:
_dist_bundle3.Poisson_swigregister(Poisson)
class PoissonFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Poisson factory.

    Notes
    -----
    We use the following estimator:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\lambda}_n = \bar{x}_n
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Poisson
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.PoissonFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.PoissonFactory_build(self, *args)

    def buildAsPoisson(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsPoisson()

            buildAsPoisson(*sample*)

            buildAsPoisson(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Poisson`.

        Returns
        -------
        distribution : :class:`~openturns.Poisson`
            The estimated distribution as a Poisson.

            In the first usage, the default Poisson distribution is built.
        """
        return _dist_bundle3.PoissonFactory_buildAsPoisson(self, *args)

    def __init__(self, *args):
        _dist_bundle3.PoissonFactory_swiginit(self, _dist_bundle3.new_PoissonFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_PoissonFactory

# Register PoissonFactory in _dist_bundle3:
_dist_bundle3.PoissonFactory_swigregister(PoissonFactory)
class ProductDistribution(openturns.model_copula.ContinuousDistribution):
    r"""
    Product distribution.

    Helper class for defining the push-forward distribution of a given univariate distribution by a given scalar function.

    Available constructors:
        ProductDistribution(*distX, distY*)

    Parameters
    ----------

    distX : :class:`~openturns.Distribution`, univariate
        Independent of `distY`

    distY : :class:`~openturns.Distribution`, univariate
        Independent of `distX`

    Returns
    -------
    distZ : :class:`~openturns.Distribution`, univariate
        :math:`distZ` is the distribution of the random variable :math:`Z = XY` when :math:`(X,Y)` is a random vector with independent copula and respective marginal distributions `distX` and `distY`.


    Notes
    -----
    We note :math:`Z=XY` the scalar random variable which distribution is :math:`f_Z`.

    .. math::

        \displaystyle f_Z(z) = \int_{\Rset} f_X (t) f_{Y}(\dfrac{z}{t}) \, \dfrac{\Diff t}{|t|}

    with :math:`f_X`,  and :math:`f_Y` the probability density functions of :math:`X`  and :math:`Y`.

    Its first moments, if finite, are defined as: 

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{Z} & = &  \Expect{X} \Expect{Y} \\
            \Var{Z} & = & \Expect{X}^2 \Var{Y} +  \Expect{Y}^2 \Var{X} + \Var{X}  \Var{Y} 
        \end{eqnarray*}


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distX = ot.Normal(-1.0, 1.0)
    >>> distY = ot.Uniform(-1.0, 1.0)
    >>> distZ = ot.ProductDistribution(distX, distY)

    Draw a sample:

    >>> sample = distZ.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.ProductDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.ProductDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.ProductDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.ProductDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.ProductDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.ProductDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.ProductDistribution_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle3.ProductDistribution_computeProbability(self, interval)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.ProductDistribution_computeCharacteristicFunction(self, x)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ProductDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ProductDistribution_getKurtosis(self)

    def getMoment(self, n):
        r"""
        Accessor to the componentwise moments.

        Parameters
        ----------
        k : int
            The order of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise moment of order :math:`k`.

        Notes
        -----
        The componentwise moment of order :math:`k` is defined as:

        .. math::

            \vect{m}^{(k)} = \Tr{\left(\Expect{X_i^k}, \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ProductDistribution_getMoment(self, n)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.ProductDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.ProductDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.ProductDistribution_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.ProductDistribution_isElliptical(self)

    def setLeft(self, left):
        return _dist_bundle3.ProductDistribution_setLeft(self, left)

    def getLeft(self):
        r"""
        Accessor to the left distribution of the product.

        Returns
        -------
        distX :  :class:`~openturns.Distribution`.
        """
        return _dist_bundle3.ProductDistribution_getLeft(self)

    def setRight(self, right):
        return _dist_bundle3.ProductDistribution_setRight(self, right)

    def getRight(self):
        r"""
        Accessor to the right distribution of the product.

        Returns
        -------
        distY :  :class:`~openturns.Distribution`.
        """
        return _dist_bundle3.ProductDistribution_getRight(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ProductDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ProductDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ProductDistribution_isIntegral(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle3.ProductDistribution_getSingularities(self)

    def __init__(self, *args):
        _dist_bundle3.ProductDistribution_swiginit(self, _dist_bundle3.new_ProductDistribution(*args))
    __swig_destroy__ = _dist_bundle3.delete_ProductDistribution

# Register ProductDistribution in _dist_bundle3:
_dist_bundle3.ProductDistribution_swigregister(ProductDistribution)
class QuantileMatchingFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Estimation by matching quantiles.

    Implements generic estimation by matching quantiles.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution defining the parametric model to be adjusted to data.
        Its parameters define the starting point of the algorithm.
    probabilities : increasing sequence of float in [0, 1]
        The probabilities :math:`p_i \in [0,1]` corresponding to the quantiles.
        At most :math:`K` values can be given.
        It is possible to provide less than :math:`K` values if :meth:`setKnownParameter` is used
    bounds : :class:`~openturns.Interval`, optional
        Parameter bounds. The default bounds is an empty interval, which implies that the optimization problem is unbounded.

    Notes
    -----
    We consider a parametric model whose cumulative distribution function :math:`F_{\vect{\theta}}`
    is parametrized by :math:`\vect{\theta} \in \Rset^K`.

    Given a set of probabilities :math:`p_1, ..., p_K \in [0, 1]`
    and a set of scalars :math:`q_1, ..., q_K \in \Rset`,
    we want to determine :math:`\vect{\theta}` such that :math:`q_i` be the quantile of
    order :math:`p_i` of :math:`F_{\vect{\theta}}`:

    .. math::

        F_{\vect{\theta}}(q_i) = p_i, \quad 1 \leq i \leq K

    This is useful when some expert is able to specify such quantiles.

    When the quantiles :math:`q_i` are not known, they can be deduced from a given sample. We denote
    :math:`\hat{q}_1, ..., \hat{q}_K` the empirical quantiles obtained. In that case, we want to determine
    :math:`\vect{\theta}` such that :math:`\hat{q}_i` be the quantile of
    order :math:`p_i` of :math:`F_{\vect{\theta}}`:

    .. math::

        F_{\vect{\theta}}(\hat{q}_i) = p_i, \quad 1 \leq i \leq K

    The optimal :math:`\vect{\theta}` is searched as the solution of the optimization problem:

    .. math::

        \vect{\theta}_{opt} = \argmin_{\vect{\theta} \in \Rset^K} \sum_{i=1}^K (F^{-1}_{\vect{\theta}}(p_i) - \hat{q}_i)^2

    See also
    --------
    DistributionFactory

    Examples
    --------
    Fit a distribution with 2 parameters. Hence, two quantiles are used to estimate the parameters.
    Here, both quantiles are estimated from a given sample.

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal(0.9, 1.7).getSample(10)
    >>> factory = ot.QuantileMatchingFactory(ot.Normal(), [0.01, 0.99])
    >>> inf_distribution = factory.build(sample)
    >>> print(inf_distribution)
    Normal(mu = 0.267484, sigma = 1.32218)
    >>> print(factory.getProbabilities())
    [0.01,0.99]

    We see that the default value of the :math:`\epsilon` parameter is so that we consider the 1% and 99% percentile ranks.

    Use 5% and 95% percentile ranks:

    >>> probabilities = [0.05, 0.95]
    >>> factory = ot.QuantileMatchingFactory(ot.Normal(), probabilities)
    >>> inf_distribution = factory.build(sample)

    We can also make the optimization problem easier by specifying bounds to the parameters:

    >>> bounds = ot.Interval([-0.1, 0.0], [1.0, 2.0])
    >>> factory = ot.QuantileMatchingFactory(ot.Normal(), probabilities, bounds)
    >>> inf_distribution = factory.build(sample)

    An example with 4 parameters:

    >>> # A distribution with 4 parameters
    >>> distribution = ot.Beta(2.0, 3.0, 4.0, 5.0)
    >>> sample = distribution.getSample(10)
    >>> distribution = ot.Beta()
    >>> factory = ot.QuantileMatchingFactory(distribution, [0.01, 1/3, 2/3, 0.99])
    >>> inf_distribution = factory.build(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.QuantileMatchingFactory_getClassName(self)

    def __repr__(self):
        return _dist_bundle3.QuantileMatchingFactory___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.QuantileMatchingFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.QuantileMatchingFactory_build(self, *args)

    def buildFromQuantiles(self, quantiles):
        r"""
        Build from given quantiles.

        Parameters
        ----------
        quantiles : increasing sequence of float
            The quantiles of the distribution, matching the probabilities provided to the constructor.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

        """
        return _dist_bundle3.QuantileMatchingFactory_buildFromQuantiles(self, quantiles)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the moments.
        """
        return _dist_bundle3.QuantileMatchingFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the moments.
        """
        return _dist_bundle3.QuantileMatchingFactory_getOptimizationAlgorithm(self)

    def setOptimizationBounds(self, optimizationBounds):
        r"""
        Accessor to the optimization bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _dist_bundle3.QuantileMatchingFactory_setOptimizationBounds(self, optimizationBounds)

    def getOptimizationBounds(self):
        r"""
        Accessor to the optimization bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _dist_bundle3.QuantileMatchingFactory_getOptimizationBounds(self)

    def setKnownParameter(self, values, positions):
        r"""
        Accessor to the known parameters.

        Notes
        -----
        Using this method may cause the class to ignore some values of the given probabilities (or the default ones)
        as the underlying least squares problem is solved in dimension :math:`K` minus
        the number of known parameters.

        Parameters
        ----------
        values : sequence of float
            Values of fixed parameters.
        indices : sequence of int
            Indices of fixed parameters.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Beta(2.3, 2.2, -1.0, 1.0)
        >>> sample = distribution.getSample(10)
        >>> factory = ot.QuantileMatchingFactory(ot.Beta(), [0.01, 0.99])
        >>> # set (a,b) out of (r, t, a, b)
        >>> factory.setKnownParameter([-1.0, 1.0], [2, 3])
        >>> inf_distribution = factory.build(sample)
        """
        return _dist_bundle3.QuantileMatchingFactory_setKnownParameter(self, values, positions)

    def getKnownParameterValues(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        values : :class:`~openturns.Point`
            The values of the fixed parameters.
        """
        return _dist_bundle3.QuantileMatchingFactory_getKnownParameterValues(self)

    def getKnownParameterIndices(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            The indices of the fixed parameters.
        """
        return _dist_bundle3.QuantileMatchingFactory_getKnownParameterIndices(self)

    def setProbabilities(self, probabilities):
        r"""
        Accessor to the fractiles.

        Parameters
        ----------
        probabilities : sequence of float
            The probabilities :math:`p_i`.
        """
        return _dist_bundle3.QuantileMatchingFactory_setProbabilities(self, probabilities)

    def getProbabilities(self):
        r"""
        Accessor to the probabilities.

        Returns
        -------
        probabilities : :class:`~openturns.Point`
            The probabilities :math:`p_i`.
        """
        return _dist_bundle3.QuantileMatchingFactory_getProbabilities(self)

    def __init__(self, *args):
        _dist_bundle3.QuantileMatchingFactory_swiginit(self, _dist_bundle3.new_QuantileMatchingFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_QuantileMatchingFactory

# Register QuantileMatchingFactory in _dist_bundle3:
_dist_bundle3.QuantileMatchingFactory_swigregister(QuantileMatchingFactory)
class RandomMixture(openturns.model_copula.DistributionImplementation):
    r"""
    RandomMixture distribution.

    Refer to :ref:`random_mixture`.

    Available constructors:
        RandomMixture(*coll, cst*)

        RandomMixture(*coll, weights, cst*)

        RandomMixture(*coll, weightsMatrix*)

        RandomMixture(*coll, weightsMatrix, constant*)


    Parameters
    ----------
    coll : list of :class:`~openturns.Distribution`
        The collection of distributions that model the random vector.
    cst : float
        Constant coefficient of the affine expression in dimension 1.
        Default value is zero.
    weights :  sequence of float
        Weights of the affine combination in dimension 1.
        Default value is (1, ...,1).
    constant : sequence of float
        Constant vector of the affine expression.
        Its size should be equal to the dimension of the distribution.
        Default value is (0,...,0).
    weightsMatrix :  2-d sequence of float
        Weights of the affine combination.

    Notes
    -----
    Create an affine combination of input random variables of form:
        :math:`Y = y_0 + M X`
    where: :math:`\vect{Y}` of size :math:`d` with :math:`d\in \{1,2,3\}`
           :math:`\vect{X}` is a :math:`n`-random vector with independent components, i.e. a
           collection of univariate distributions,

           :math:`\mat{M}` is a :math:`d \times n` deterministic matrix, i.e. the linear
           operator of the affine transformation,

           :math:`\vect{y}_0` a constant and deterministic vector, i.e the constant
           part of the affine transformation.

    As the univariate random variables :math:`X_i` are independent, the
    characteristic function of :math:`\vect{Y}`, denoted :math:`\phi_Y`, is
    easily defined from the characteristic function of :math:`X_k` denoted
    :math:`\phi_{X_k}` as follows :

    .. math::

        \phi(z_1,...,z_d) =  \prod_{j=1}^d {\exp(i z_j {y_0}_j)} \prod_{k=1}^n \phi_{X_k}((\Tr{\mat{M}} z)_k)

    It is possible to evaluate its density probability function once the
    characteristic function evaluated, using the Poisson summation formula:

    .. math::

        \sum_{j_1 \in \mathbb{Z}}\hdots \sum_{j_d \in \mathbb{Z}} p(y_1 + 2\pi j_1/h_1,\hdots,y_d + 2\pi j_d/h_d) = (h_1\hdots h_d)/(2^d \pi^d) \sum_{k_1 \in \mathbb{Z}}\hdots \sum_{k_d \in \mathbb{Z}} \phi(k_1 h_1,\hdots,k_d h_d)\exp(-i(k_1 h_1+\hdots+k_d h_d))

    For :math:`h_i` small enough, the nested sums of the left term are reduced
    to the central term :math:`j_1=\hdots=j_d = 0`.
    Thus, the density is approximated by:

    .. math::

        p(y_1,\hdots,y_d) = (h_1\hdots h_d)/(2^d \pi^d) \sum_{|k_1| \leq N}\hdots \sum_{|k_d| \leq N} \phi(k_1 h_1,\hdots,k_d h_d)\exp(-i(k_1 h_1+\hdots+k_d h_d))

    The nested sums of the right term are computed by blocks of form
    :math:`2^b \leq k < 2^{b+1}`, and are truncated when the contribution of a
    block becomes lower than a threshold, which can be changed by
    setPDFPrecision method.
    Two other methods also may change the number of iterations; setBlockMin
    sets the block number from which truncation is possible, which means that
    computations are always performed for blocks lower than this parameter,
    even if their contributions are very small. On the other hand, setBlockMax
    sets the maximum number of blocks, which can be useful to make sure that
    computations run in a limited time.

    Note that the total number of evaluations of the characteristic function to
    compute up to block :math:`b` is equivalent to :math:`2^{dim \times (b+1)}`, so
    it is important to ensure that this number has some reasonable value.

    Note finally that the characteristic function evaluations are independent
    from :math:`\vect{y}=(y_1,\hdots,y_d)`: these values are stored in a cache.


    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{\vect{Y}}  & = & \vect{y}_0 + \mat{M}\Expect{\vect{X}} \\
            \Cov{Y}  & = & \mat{M} \Cov{X} \Tr{\mat{M}}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> coll = [ot.Triangular(0.0, 1.0, 5.0), ot.Uniform(-2.0, 2.0)]
    >>> weights = [3.0, 2.0]
    >>> cst = 3.0
    >>> distribution = ot.RandomMixture(coll, weights, cst)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.RandomMixture_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.RandomMixture___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.RandomMixture___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.RandomMixture___str__(self, *args)

    def getDistributionCollection(self):
        r"""
        Return the list of distributions used.

        In dimension 1, some analytical aggregations may be performed on
        distributions to improve performance, and collection may differ from the
        one originally given by user.

        Returns
        -------
        coll : DistributionCollection
            The collection of univariate distributions used for the combination

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # Sum of two Uniform here is a Triangular
        >>> coll = distribution.getDistributionCollection()
        >>> print(coll)
        [Triangular(a = -2, m = 0, b = 2)]
        """
        return _dist_bundle3.RandomMixture_getDistributionCollection(self)

    def getFFTAlgorithm(self):
        return _dist_bundle3.RandomMixture_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        return _dist_bundle3.RandomMixture_setFFTAlgorithm(self, fft)

    def setConstant(self, constant):
        r"""
        Set the constant term of the affine combination.

        Parameters
        ----------
        vect : sequence of float
            The constant term

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # Set the new constant term is 0
        >>> distribution.setConstant([1.0])
        """
        return _dist_bundle3.RandomMixture_setConstant(self, constant)

    def getConstant(self):
        r"""
        Return the vector of the affine combination.

        Returns
        -------
        out : :class:`~openturns.Point`
            The constant term

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # Constant term is 0
        >>> cst = distribution.getConstant()
        >>> print(cst)
        [0]
        """
        return _dist_bundle3.RandomMixture_getConstant(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.RandomMixture_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle3.RandomMixture_getSample(self, size)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.RandomMixture_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.RandomMixture_computePDF(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle3.RandomMixture_getMarginal(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.RandomMixture_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.RandomMixture_computeComplementaryCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle3.RandomMixture_computeProbability(self, interval)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`0 < p < 1`
            Quantile function input (a probability).
        tail : bool, optional (default=False)
            Whether p should be interpreted as the complementary probability.

        Returns
        -------
        X : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            Quantile at probability level :math:`p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_{\vect{X}}(p) = F_{\vect{X}}^{-1}(p),
                              \quad p \in [0; 1]
        """
        return _dist_bundle3.RandomMixture_computeQuantile(self, *args)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\alpha`.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.RandomMixture_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computeCharacteristicFunction(self, *args):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.RandomMixture_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.RandomMixture_computeLogCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.RandomMixture_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.RandomMixture_computeCDFGradient(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.RandomMixture_getParametersCollection(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.RandomMixture_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.RandomMixture_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.RandomMixture_getParameterDescription(self)

    def getWeights(self):
        r"""
        Return the weights of the combination as a Matrix.

        Returns
        -------
        out : :class:`~openturns.Matrix`
            The element of affine transformation

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # weights
        >>> w = distribution.getWeights()
        >>> print(w)
        [[ 1 ]]
        """
        return _dist_bundle3.RandomMixture_getWeights(self)

    def getPositionIndicator(self):
        r"""
        Position indicator accessor.

        Defines a generic metric of the position. When the mean is not defined it falls
        back to the median.
        Available only for 1-d distributions.

        Returns
        -------
        position : float
            Mean or median of the distribution.
        """
        return _dist_bundle3.RandomMixture_getPositionIndicator(self)

    def getDispersionIndicator(self):
        r"""
        Dispersion indicator accessor.

        Defines a generic metric of the dispersion. When the standard deviation is not
        defined it falls back to the interquartile.
        Only available for 1-d distributions.

        Returns
        -------
        dispersion : float
            Standard deviation or interquartile.
        """
        return _dist_bundle3.RandomMixture_getDispersionIndicator(self)

    def setBlockMin(self, blockMin):
        r"""
        Set the blockMin parameter.

        Parameters
        ----------
        blockMin : int
            Number of minimal evaluations of blocks for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> distribution.setBlockMin(4)
        """
        return _dist_bundle3.RandomMixture_setBlockMin(self, blockMin)

    def getBlockMin(self):
        r"""
        Return the blockMin parameter.

        Returns
        -------
        blockMin : int
            Number of minimal evaluations of blocks for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # blockMin
        >>> blockMin = distribution.getBlockMin()
        >>> print(blockMin)
        3
        """
        return _dist_bundle3.RandomMixture_getBlockMin(self)

    def setBlockMax(self, blockMax):
        r"""
        Set the blockMax parameter.

        Returns
        -------
        blockMax : int
            Number of maximal evaluations of blocks for characteristic function
            evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> distribution.setBlockMax(14)
        """
        return _dist_bundle3.RandomMixture_setBlockMax(self, blockMax)

    def getBlockMax(self):
        r"""
        Return the blockMax parameter.

        Returns
        -------
        blockMax : int
            Number of maximal evaluations of blocks for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # blockMax
        >>> blockMax = distribution.getBlockMax()
        >>> print(blockMax)
        16
        """
        return _dist_bundle3.RandomMixture_getBlockMax(self)

    def setMaxSize(self, maxSize):
        r"""
        Set the maximum size of cache for characteristic function evaluations.

        Parameters
        ----------
        size : int
            Maximum size of cache for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> size = pow(2,15)
        >>> distribution.setMaxSize(size)
        """
        return _dist_bundle3.RandomMixture_setMaxSize(self, maxSize)

    def getMaxSize(self):
        r"""
        Return the maximum size of cache for characteristic function evaluations.

        Returns
        -------
        size : int
            Maximum size of cache for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # default cache size
        >>> size = distribution.getMaxSize()
        >>> print(size)
        65536
        """
        return _dist_bundle3.RandomMixture_getMaxSize(self)

    def setAlpha(self, alpha):
        r"""
        Set the a priori range of PDF and CDF arguments in terms of standard deviation.

        Parameters
        ----------
        alpha : float
            A Priori range of PDF/CDF

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> alpha = 8.0
        >>> distribution.setAlpha(alpha)
        """
        return _dist_bundle3.RandomMixture_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Return the priori range of PDF and CDF argument.

        It is expressed in dispersionIndicator units.

        Returns
        -------
        alpha : float
            A Priori range of PDF/CDF

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # alpha
        >>> alpha = distribution.getAlpha()
        >>> print(alpha)
        5.0
        """
        return _dist_bundle3.RandomMixture_getAlpha(self)

    def setBeta(self, beta):
        r"""
        Set the distance of the a priori range at which the PDF is negligible.

        Parameters
        ----------
        beta : float
            Distance from the boundary of the a priori range

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> beta = 8.0
        >>> distribution.setBeta(beta)
        """
        return _dist_bundle3.RandomMixture_setBeta(self, beta)

    def getBeta(self):
        r"""
        Return the distance of the a priori range at which the PDF is negligible.

        Returns
        -------
        beta : float
            Distance from the boundary of the a priori range

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # beta
        >>> beta = distribution.getBeta()
        >>> print(beta)
        8.5
        """
        return _dist_bundle3.RandomMixture_getBeta(self)

    def setReferenceBandwidth(self, bandwidth):
        r"""
        Set the reference bandwidth.

        Parameters
        ----------
        bw : sequence of float
            The reference bandwidth

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> bw = [0.75]
        >>> distribution.setReferenceBandwidth(bw)
        """
        return _dist_bundle3.RandomMixture_setReferenceBandwidth(self, bandwidth)

    def getReferenceBandwidth(self):
        r"""
        Return the reference bandwidth.

        It is the maximum bandwidth that allows an accurate computation
        of the PDF over the range :math:`[mean \pm \beta\sigma]`.

        Returns
        -------
        out : :class:`~openturns.Point`
            The reference bandwidth

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Triangular(-1.0, 0.0, 1.0)])
        >>> # bw
        >>> bw = distribution.getReferenceBandwidth()
        >>> print(bw)
        [0.785398]
        """
        return _dist_bundle3.RandomMixture_getReferenceBandwidth(self)

    def setPDFPrecision(self, pdfPrecision):
        r"""
        Set the requested precision for PDF computation.

        Parameters
        ----------
        eps : float
            Precision for density evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> eps = 1.e-12
        >>> distribution.setPDFPrecision(eps)
        """
        return _dist_bundle3.RandomMixture_setPDFPrecision(self, pdfPrecision)

    def setCDFPrecision(self, cdfPrecision):
        r"""
        Set the requested precision for CDF computation.

        Parameters
        ----------
        eps : float
            Precision for cumulative function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> eps = 1.e-12
        >>> distribution.setCDFPrecision(eps)
        """
        return _dist_bundle3.RandomMixture_setCDFPrecision(self, cdfPrecision)

    def project(self, *args):
        r"""
        Project a RandomMixture distribution over a collection of DistributionFactory.

        Uses sampling and Kolmogorov distance.

        Parameters
        ----------
        coll : :class:`~openturns.DistributionFactoryCollection`
            The collection of factories
        kolmogorovNorm: sequence of float
            The Kolmogorov norms
        size : int
            Size of projection

        Returns
        -------
        out : tuple of size 2:
            First element is a collection of :class:`~openturns.Distribution`,
            and second element is a sequence of float containing
            the Kolmogorov norm of the projection over its factory.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Normal(0.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> coll = [ot.NormalFactory(), ot.UniformFactory()]
        >>> dist, kolmogorovNorm = distribution.project(coll)

        """
        return _dist_bundle3.RandomMixture_project(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_hasIndependentCopula(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle3.RandomMixture_hasEllipticalCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.RandomMixture_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_isIntegral(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.RandomMixture_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.RandomMixture_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.RandomMixture_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.RandomMixture_getKurtosis(self)

    def __init__(self, *args):
        _dist_bundle3.RandomMixture_swiginit(self, _dist_bundle3.new_RandomMixture(*args))
    __swig_destroy__ = _dist_bundle3.delete_RandomMixture

# Register RandomMixture in _dist_bundle3:
_dist_bundle3.RandomMixture_swigregister(RandomMixture)
class Rayleigh(openturns.model_copula.ContinuousDistribution):
    r"""
    Rayleigh distribution.

    Parameters
    ----------
    beta : float, :math:`\beta > 0`
        Scale parameter :math:`\beta`.

        Default value is 1.0.
    gamma : float
        Location parameter :math:`\gamma`.

        Default value is 0.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{(x - \gamma)} {\beta^2}
                 \exp \left(-\frac{(x - \gamma)^2}{2\beta^2}\right)
                 \quad x \in [\gamma,+\infty[

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \beta \sqrt{\frac{\pi}{2}} + \gamma \\
            \Var{X} & = & \frac{4 - \pi}{2} \beta^2
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Poisson(10.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Rayleigh_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Rayleigh___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Rayleigh___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Rayleigh___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Rayleigh_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Rayleigh_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Rayleigh_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.Rayleigh_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Rayleigh_computeCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.Rayleigh_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Rayleigh_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Rayleigh_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Rayleigh_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Rayleigh_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Rayleigh_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Rayleigh_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Rayleigh_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Rayleigh_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Rayleigh_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Rayleigh_getParameterDescription(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle3.Rayleigh_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle3.Rayleigh_getBeta(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle3.Rayleigh_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle3.Rayleigh_getGamma(self)

    def __init__(self, *args):
        _dist_bundle3.Rayleigh_swiginit(self, _dist_bundle3.new_Rayleigh(*args))
    __swig_destroy__ = _dist_bundle3.delete_Rayleigh

# Register Rayleigh in _dist_bundle3:
_dist_bundle3.Rayleigh_swigregister(Rayleigh)
class RayleighFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Rayleigh factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\gamma}_n = (1-\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\
          \displaystyle\Hat{\sigma}_n=\sqrt{\frac{2}{n}\sum_{i=1}^n(x_i-\Hat{\gamma}_n)^2}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Rayleigh
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.RayleighFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.RayleighFactory_build(self, *args)

    def buildAsRayleigh(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsRayleigh()

            buildAsRayleigh(*sample*)

            buildAsRayleigh(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float,
            The parameters of the :class:`~openturns.Rayleigh`.

        Returns
        -------
        dist : :class:`~openturns.Rayleigh`
            The estimated distribution as a Rayleigh.

            In the first usage, the default Rayleigh distribution is built.
        """
        return _dist_bundle3.RayleighFactory_buildAsRayleigh(self, *args)

    def __init__(self, *args):
        _dist_bundle3.RayleighFactory_swiginit(self, _dist_bundle3.new_RayleighFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_RayleighFactory

# Register RayleighFactory in _dist_bundle3:
_dist_bundle3.RayleighFactory_swigregister(RayleighFactory)
class Rice(openturns.model_copula.ContinuousDistribution):
    r"""
    Rice distribution.


    Parameters
    ----------
    beta : float, :math:`\beta > 0`
        Scale parameter.

        Default value is 1.0.
    nu : float, :math:`\nu \geq 0`
        Location parameter.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = 2\frac{x}{\beta^2}p_{\chi^2(2,\frac{\nu^2}{\beta^2})}
                 \left(\frac{x^2}{\beta^2}\right),
                 \quad x \in [0; +\infty[

    where :math:`p_{\chi^2(\nu, \lambda)}` is the probability density function of a
    :class:`~openturns.NonCentralChiSquare` distribution.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \beta \sqrt{\frac{\pi}{2}}
                             \mathrm{L}_{1/2}\left(-\frac{\nu^2}{2\beta^2}\right) \\
            \Var{X} & = & 2\beta^2 + \nu^2 - \frac{\pi\beta^2}{2}
                          \mathrm{L}_{1/2}^2\left(\frac{-\nu^2}{2\beta^2}\right)
        \end{eqnarray*}

    where :math:`\mathrm{L}_q(x)` denotes a Laguerre polynomial.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Rice()

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Rice_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Rice___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Rice___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Rice___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Rice_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Rice_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.Rice_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Rice_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.Rice_computeComplementaryCDF(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Rice_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Rice_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Rice_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Rice_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Rice_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Rice_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Rice_getParameterDescription(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle3.Rice_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle3.Rice_getBeta(self)

    def setNu(self, nu):
        r"""
        Accessor to the distribution's location parameter :math:`\nu`.

        Parameters
        ----------
        nu : float, :math:`\nu >= 0`
            Location parameter :math:`\nu`.
        """
        return _dist_bundle3.Rice_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the distribution's location parameter :math:`\nu`.

        Returns
        -------
        nu : float
            Location parameter :math:`\nu`.
        """
        return _dist_bundle3.Rice_getNu(self)

    def setMaximumIteration(self, maximumIteration):
        return _dist_bundle3.Rice_setMaximumIteration(self, maximumIteration)

    def getMaximumIteration(self):
        return _dist_bundle3.Rice_getMaximumIteration(self)

    def __init__(self, *args):
        _dist_bundle3.Rice_swiginit(self, _dist_bundle3.new_Rice(*args))
    __swig_destroy__ = _dist_bundle3.delete_Rice

# Register Rice in _dist_bundle3:
_dist_bundle3.Rice_swigregister(Rice)
class RiceFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Rice factory.

    Notes
    -----
    The parameters are estimated by method of moments, according to [koay2006]_.

    See also
    --------
    DistributionFactory, Rice
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.RiceFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.RiceFactory_build(self, *args)

    def buildAsRice(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsRice()

            buildAsRice(*sample*)

            buildAsRice(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.Rice`.

        Returns
        -------
        dist : :class:`~openturns.Rice`
            The estimated distribution as a Rice.

            In the first usage, the default Rice distribution is built.
        """
        return _dist_bundle3.RiceFactory_buildAsRice(self, *args)

    def __init__(self, *args):
        _dist_bundle3.RiceFactory_swiginit(self, _dist_bundle3.new_RiceFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_RiceFactory

# Register RiceFactory in _dist_bundle3:
_dist_bundle3.RiceFactory_swigregister(RiceFactory)
class Skellam(openturns.model_copula.DiscreteDistribution):
    r"""
    Skellam distribution.

    Parameters
    ----------
    lambda1 : float, :math:`\lambda_1 > 0`
        First :class:`~openturns.Poisson` distribution's parameter.

        Default value is 1.0.

    lambda2 : float, :math:`\lambda_2 > 0`
        Second :class:`~openturns.Poisson` distribution's parameter.

        Default value is 1.0.

    Notes
    -----
    The Skellan distribution takes its values in :math:`\Zset`.
    It is the distribution of :math:`(X_1 - X_2)` for :math:`(X_1, X_2)` independent
    and respectively distributed according to Poisson(:math:`\lambda_i`).

    Its probability distribution function is defined as:

    .. math::

        \Prob{X = k} = 2 \Prob{Y = 2 \lambda_1},
                       \quad \forall k \in \Zset

    where Y is distributed according to the :class:`~openturns.NonCentralChiSquare`
    distribution :math:`\chi^2_{\nu, \delta}`, with :math:`\nu=2(k+1)` and
    :math:`\delta=2\lambda_2`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \lambda_1 - \lambda_2 \\
            \Var{X} & = & \lambda_1 + \lambda_2
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Skellam(10.0, 5.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Skellam_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Skellam___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Skellam___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Skellam___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Skellam_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Skellam_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Skellam_computeCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Skellam_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Skellam_computeCDFGradient(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Skellam_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.Skellam_computeLogCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input :math:`X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle3.Skellam_computeGeneratingFunction(self, z)

    def computeLogGeneratingFunction(self, z):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input :math:`X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle3.Skellam_computeLogGeneratingFunction(self, z)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`0 < p < 1`
            Quantile function input (a probability).

        Returns
        -------
        X : float
            Quantile at probability level :math:`p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_X(p) = F_X^{-1}(p), \quad p \in [0; 1]

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle3.Skellam_computeScalarQuantile(self, prob, tail)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.Skellam_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Skellam_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Skellam_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Skellam_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Skellam_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Skellam_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Skellam_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Skellam_isElliptical(self)

    def setLambda1Lambda2(self, lambda1, lambda2):
        r"""
        Accessor to the Poisson distributions' parameters.

        Namely :math:`\lambda_1` and :math:`\lambda_2`.

        Parameters
        ----------
        lambda1 : float, :math:`\lambda_1 >0`
            First Poisson distribution's parameter :math:`\lambda_1`.
        lambda2 : float, :math:`\lambda_2 >0`
            Second Poisson distribution's parameter :math:`\lambda_2`.
        """
        return _dist_bundle3.Skellam_setLambda1Lambda2(self, lambda1, lambda2)

    def setLambda1(self, lambda1):
        r"""
        Accessor to the first Poisson distribution's parameter :math:`\lambda_1`.

        Parameters
        ----------
        lambda1 : float, :math:`\lambda_1 >0`
            First Poisson distribution's parameter :math:`\lambda_1`.
        """
        return _dist_bundle3.Skellam_setLambda1(self, lambda1)

    def getLambda1(self):
        r"""
        Accessor to the first Poisson distribution's parameter :math:`\lambda_1`.

        Returns
        -------
        lambda1 : float
            First Poisson distribution's parameter :math:`\lambda_1`.
        """
        return _dist_bundle3.Skellam_getLambda1(self)

    def setLambda2(self, lambda2):
        r"""
        Accessor to the second Poisson distribution's parameter :math:`\lambda_2`.

        Parameters
        ----------
        lambda2 : float, :math:`\lambda_2 >0`
            Second Poisson distribution's parameter :math:`\lambda_2`.
        """
        return _dist_bundle3.Skellam_setLambda2(self, lambda2)

    def getLambda2(self):
        r"""
        Accessor to the second Poisson distribution's parameter :math:`\lambda_2`.

        Returns
        -------
        lambda2 : float
            Second Poisson distribution's parameter :math:`\lambda_2`.
        """
        return _dist_bundle3.Skellam_getLambda2(self)

    def setMaximumIteration(self, maximumIteration):
        return _dist_bundle3.Skellam_setMaximumIteration(self, maximumIteration)

    def getMaximumIteration(self):
        return _dist_bundle3.Skellam_getMaximumIteration(self)

    def __init__(self, *args):
        _dist_bundle3.Skellam_swiginit(self, _dist_bundle3.new_Skellam(*args))
    __swig_destroy__ = _dist_bundle3.delete_Skellam

# Register Skellam in _dist_bundle3:
_dist_bundle3.Skellam_swigregister(Skellam)
class SkellamFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Skellam factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \Hat{\lambda_1} & = \frac{1}{2}(\Hat{\sigma}_x + \Hat{x}_n) \\
          \displaystyle \Hat{\lambda_2} & = \frac{1}{2}(\Hat{\sigma}_x - \Hat{x}_n)
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Skellam
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.SkellamFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.SkellamFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle3.SkellamFactory_buildEstimator(self, *args)

    def buildAsSkellam(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsSkellam()

            buildAsSkellam(*sample*)

            buildAsSkellam(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.Skellam`.

        Returns
        -------
        dist : :class:`~openturns.Skellam`
            The estimated distribution as a Skellam.

            In the first usage, the default Skellam distribution is built.
        """
        return _dist_bundle3.SkellamFactory_buildAsSkellam(self, *args)

    def __init__(self, *args):
        _dist_bundle3.SkellamFactory_swiginit(self, _dist_bundle3.new_SkellamFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_SkellamFactory

# Register SkellamFactory in _dist_bundle3:
_dist_bundle3.SkellamFactory_swigregister(SkellamFactory)
class SmoothedUniform(RandomMixture):
    r"""
    SmoothedUniform distribution.

    Parameters
    ----------
    a : float
        Lower bound of the :class:`~openturns.Uniform` component.

        Default value is -1.0.
    b : float, :math:`b > a`
        Upper bound of the :class:`~openturns.Uniform` component.

        Default value is 1.0.
    sigma : float, :math:`\sigma > 0`
        Standard deviation of the :class:`~openturns.Normal` component.

        Default value is 1.0.

    Notes
    -----
    This distribution is the distribution of the sum of a uniform random variable and an independent normal random variable.

    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{\Phi \left( (b - x)/\sigma \right) - \Phi \left( (a - x)/\sigma \right) }{ b - a }, \quad x \in \Rset

    where :math:`\Phi` is the CDF of the standard normal distribution.

    Its first moments are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{a+b}{2} \\
            \Var{X} & = & \frac{(b-a)^2}{12} + \sigma^2
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.SmoothedUniform(2.0, 3.0, 1.5)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.SmoothedUniform_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.SmoothedUniform___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.SmoothedUniform___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.SmoothedUniform___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.SmoothedUniform_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle3.SmoothedUniform_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.SmoothedUniform_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.SmoothedUniform_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.SmoothedUniform_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.SmoothedUniform_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.SmoothedUniform_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.SmoothedUniform_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.SmoothedUniform_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.SmoothedUniform_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.SmoothedUniform_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.SmoothedUniform_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.SmoothedUniform_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.SmoothedUniform_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.SmoothedUniform_getParameterDescription(self)

    def setParametersCollection(self, parametersCollection):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.SmoothedUniform_setParametersCollection(self, parametersCollection)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.SmoothedUniform_getParametersCollection(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.SmoothedUniform_isElliptical(self)

    def setA(self, a):
        r"""
        Accessor to the lower bound of the uniform component.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound of the :class:`~openturns.Uniform` component.
        """
        return _dist_bundle3.SmoothedUniform_setA(self, a)

    def getA(self):
        r"""
        Accessor to the lower bound of the uniform component.

        Returns
        -------
        a : float
            Lower bound of the :class:`~openturns.Uniform` component.
        """
        return _dist_bundle3.SmoothedUniform_getA(self)

    def setB(self, b):
        r"""
        Accessor to the upper bound of the uniform component.

        Parameters
        ----------
        b : float, :math:`a < b`
            Upper bound of the :class:`~openturns.Uniform` component.
        """
        return _dist_bundle3.SmoothedUniform_setB(self, b)

    def getB(self):
        r"""
        Accessor to the upper bound of the uniform component.

        Returns
        -------
        b : float
            Upper bound of the :class:`~openturns.Uniform` component.
        """
        return _dist_bundle3.SmoothedUniform_getB(self)

    def setSigma(self, sigma):
        r"""
        Accessor to the standard deviation of the normal component.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Standard deviation of the :class:`~openturns.Normal` component.
        """
        return _dist_bundle3.SmoothedUniform_setSigma(self, sigma)

    def getSigma(self):
        r"""
        Accessor to the standard deviation of the normal component.

        Returns
        -------
        sigma : float
            Standard deviation of the :class:`~openturns.Normal` component.
        """
        return _dist_bundle3.SmoothedUniform_getSigma(self)

    def __init__(self, *args):
        _dist_bundle3.SmoothedUniform_swiginit(self, _dist_bundle3.new_SmoothedUniform(*args))
    __swig_destroy__ = _dist_bundle3.delete_SmoothedUniform

# Register SmoothedUniform in _dist_bundle3:
_dist_bundle3.SmoothedUniform_swigregister(SmoothedUniform)
class SquaredNormal(openturns.model_copula.ContinuousDistribution):
    r"""
    Squared Normal distribution.

    Parameters
    ----------
    mu : float :math:`\mu`, optional
        Mean.

        Default value is 0.0.

    sigma : float :math:`\sigma`, optional
        Standard deviation.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{X}(x) = \frac{1}{2\sqrt{2\pi x}}(e^{-\frac{1}{2}(\frac{\sqrt{x}+\mu}{\sigma})^2} 
                    + e^{-\frac{1}{2}(\frac{\sqrt{x}-\mu}{\sigma})^2}),
                    \quad x \in ]0; +\infty[

    with :math:`\sigma > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \mu^2 + \sigma^2 \\
            \Var{X} & = & 2(2\mu^2 + \sigma^2)\sigma^2
        \end{eqnarray*}


    Examples
    --------
    Create a distribution from its native parameters :math:`(mu, sigma)`:

    >>> import openturns as ot
    >>> myDist = ot.SquaredNormal(1.0, 2.0)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.SquaredNormal_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.SquaredNormal___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.SquaredNormal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.SquaredNormal___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.SquaredNormal_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle3.SquaredNormal_getSample(self, size)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.SquaredNormal_computeCDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.SquaredNormal_computePDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.SquaredNormal_computeCharacteristicFunction(self, x)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.SquaredNormal_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.SquaredNormal_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.SquaredNormal_getParameterDescription(self)

    def setMu(self, mu):
        r"""
        Accessor to the normal distribution's mean which is squared.

        Parameters
        ----------
        mu : float
            Mean.
        """
        return _dist_bundle3.SquaredNormal_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the normal distribution's mean which is squared.

        Returns
        -------
        mu : float
            Mean.
        """
        return _dist_bundle3.SquaredNormal_getMu(self)

    def setSigma(self, sigma):
        r"""
        Accessor to the normal distribution's standard deviation which is squared.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Standard deviation.
        """
        return _dist_bundle3.SquaredNormal_setSigma(self, sigma)

    def getSigma(self):
        r"""
        Accessor to the normal distribution's standard deviation which is squared.

        Returns
        -------
        sigma : float
            Standard deviation.
        """
        return _dist_bundle3.SquaredNormal_getSigma(self)

    def __init__(self, *args):
        _dist_bundle3.SquaredNormal_swiginit(self, _dist_bundle3.new_SquaredNormal(*args))
    __swig_destroy__ = _dist_bundle3.delete_SquaredNormal

# Register SquaredNormal in _dist_bundle3:
_dist_bundle3.SquaredNormal_swigregister(SquaredNormal)
class Student(openturns.model_copula.EllipticalDistribution):
    r"""
    Student distribution.

    Available constructors:
        Student(*nu, mu, sigma*)

        Student(*nu, mu, sigma, R*)

    Parameters
    ----------
    d : int, :math:`d \geq 1`
        Dimension.

        Default value is 1.

    nu : float, :math:`\nu > 0`
        Generalized number of degrees of freedom.

        Default value is 3.0.

    mu : float :math:`\mu`, sequence of float, :math:`\vect{\mu} \in \Rset^d`
        Location parameter.

        Default value  is 0.0.

    sigma : float :math:`\sigma`, sequence of float, :math:`\vect{\sigma} \in \Rset^{*d}_+`
        Scale parameter.

        Default value  is 1.0.

    R : :class:`~openturns.CorrelationMatrix` :math:`\mat{R} \in  \cM_{d \times d}(\Rset)`
        Shape matrix.

        Default value is the identity matrix.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{\Gamma \left(\frac{\nu + d}{2}\right)}
                      {(\pi \nu) ^ {\frac{d}{2}} \Gamma \left(\frac{\nu}{2}\right)}
                 \frac{\left| \mathrm{det}(\mat{R}) \right| ^ {-1/2}}
                      {\prod_{k = 1} ^ d \sigma_k}
                 \left(1 + \frac{\vect{z} ^ t \mat{R} ^ {-1} \vect{z}}{\nu}
                 \right) ^ {-\frac{\nu + d}{2}}, \quad x \in \Rset

    with :math:`\nu > 0, d \geq 1, \mat{R} \in  \cM_{d \times d}(\Rset),
    \sigma_k > 0, k=1, \dots, d` , and
    where :math:`\vect{z}=\mat{\Delta}^{-1}\left(\vect{x}-\vect{\mu}\right)`, 
    :math:`\mat{\Delta} = \mat{\mathrm{diag}}(\vect{\sigma})` and :math:`\Gamma`
    denotes Euler's Gamma function :meth:`~openturns.SpecFunc.Gamma`.

    The matrix :math:`\mat{R}` is symmetric positive definite.

    The first moments of the distribution are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \vect{\Expect{X}} & = & \vect{\mu} \quad \text{ if }\nu>1\\
            \mat{\Cov{X}} & = & \displaystyle \frac{\nu}{\nu-2}
                                \Tr{\mat{\Delta}}\,\mat{R}\,\mat{\Delta}
                              \quad \text{ if }\nu>2
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Student(3.0, -0.5, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)

    Create a multivariate Student distribution with constant :math:`\sigma` and identity correlation matrix:

    >>> dimension = 5
    >>> nu = 3.0
    >>> mu = [0.0] * dimension
    >>> sigma = [0.1] * dimension
    >>> R = ot.CorrelationMatrix(dimension)
    >>> distribution = ot.Student(nu, mu, sigma, R)
    >>> print('distribution=', distribution)
    distribution= Student(nu = 3, mu = [0,0,0,0,0], sigma = [0.1,0.1,0.1,0.1,0.1], R = 5x5
    [[ 1 0 0 0 0 ]
     [ 0 1 0 0 0 ]
     [ 0 0 1 0 0 ]
     [ 0 0 0 1 0 ]
     [ 0 0 0 0 1 ]])

    Create a multivariate Student distribution with a different :math:`\sigma` parameter and a different correlation matrix:

    >>> sigma = [1.5, 0.4, 1.0, 2.5, 1.0]
    >>> R = ot.CorrelationMatrix(dimension)
    >>> R[0, 2] = -0.5
    >>> R[3, 4] = -0.2
    >>> distribution = ot.Student(nu, mu, sigma, R)
    >>> print('distribution=', distribution)
    distribution= Student(nu = 3, mu = [0,0,0,0,0], sigma = [1.5,0.4,1,2.5,1], R = 5x5
    [[  1    0   -0.5  0    0   ]
     [  0    1    0    0    0   ]
     [ -0.5  0    1    0    0   ]
     [  0    0    0    1   -0.2 ]
     [  0    0    0   -0.2  1   ]])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Student_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Student___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Student___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Student___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Student_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle3.Student_getSample(self, size)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Student_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle3.Student_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.Student_computeEntropy(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Student_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Student_computeCDFGradient(self, *args)

    def computeRadialDistributionCDF(self, radius, tail=False):
        r"""
        Compute the cumulative distribution function of the squared radius.

        For the underlying standard spherical distribution (for elliptical
        distributions only).

        Parameters
        ----------
        r2 : float, :math:`0 \leq r^2`
            Squared radius.

        Returns
        -------
        F : float
            CDF value at input :math:`r^2`.

        Notes
        -----
        This is the CDF of the sum of the squared independent, standard, identically
        distributed components:

        .. math::

            R^2 = \sqrt{\sum\limits_{i=1}^n U_i^2}
        """
        return _dist_bundle3.Student_computeRadialDistributionCDF(self, radius, tail)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle3.Student_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Conditional PDF values at input.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            pdf^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\dfrac{d}{d\,x_n}\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional PDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\dfrac{d}{d\,x_1}\Prob{X_1 \leq x_1}`, ie the PDF of the first component at :math:`x_1`.
        """
        return _dist_bundle3.Student_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \mid X_1, \ldots, X_{n - 1}}(x_n) =
                \Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}},
                \quad x_n \in \supp{X_n}
        """
        return _dist_bundle3.Student_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at input.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            F^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional CDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\Prob{X_1 \leq x_1}`, ie the CDF of the first component at :math:`x_1`.
        """
        return _dist_bundle3.Student_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input :math:`p`, :math:`X_{cond}`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle3.Student_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        q : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Conditional quantiles values at input.

        Notes
        -----
        The sequential conditional quantile function is defined as follows:

        .. math::

            Q^{seq}_{X_1,\ldots,X_d}(q_1,\ldots,q_d) = \left(F^{-1}(q_n|X_1=x_1,\ldots,X_{n-1}=x_{n_1}\right)_{i=1,\ldots,d}

        where :math:`x_1,\ldots,x_{n-1}` are defined recursively as :math:`x_1=F_1^{-1}(q_1)` and given :math:`(x_i)_{i=1,
        \ldots,n-1}`, :math:`x_n=F^{-1}(q_n|X_1=x_1,\ldots,X_{n-1}=x_{n_1})`: the conditioning part is the set of already 
        computed conditional quantiles.
        """
        return _dist_bundle3.Student_computeSequentialConditionalQuantile(self, q)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle3.Student_getMarginal(self, *args)

    def getMean(self):
        r"""
        Accessor to the mean.

        Returns
        -------
        k : :class:`~openturns.Point`
            Mean.

        Notes
        -----
        The mean is the first-order moment:

        .. math::

            \vect{\mu} = \Tr{\left(\Expect{X_i}, \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Student_getMean(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Student_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Student_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Student_getKurtosis(self)

    def getCovariance(self):
        r"""
        Accessor to the covariance matrix.

        Returns
        -------
        Sigma : :class:`~openturns.CovarianceMatrix`
            Covariance matrix.

        Notes
        -----
        The covariance is the second-order central moment. It is defined as:

        .. math::

            \mat{\Sigma} & = \Cov{\vect{X}} \\
                         & = \Expect{\left(\vect{X} - \vect{\mu}\right)
                                     \Tr{\left(\vect{X} - \vect{\mu}\right)}}
        """
        return _dist_bundle3.Student_getCovariance(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Student_getStandardRepresentative(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Student_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Student_setParametersCollection(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Student_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Student_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Student_getParameterDescription(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.Student_hasIndependentCopula(self)

    def setNu(self, nu):
        r"""
        Accessor to the generalized number of degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            The :math:`\nu` parameter.
        """
        return _dist_bundle3.Student_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the generalized number of degrees of freedom.

        Returns
        -------
        nu : float
            The :math:`\nu` parameter.
        """
        return _dist_bundle3.Student_getNu(self)

    def computeDensityGenerator(self, betaSquare):
        r"""
        Compute the density generator.

        Parameters
        ----------
        y : float
            Input.

        Returns
        -------
        p : float
            Value :math:`\varphi(y)`.

        Notes
        -----
        The density generator is the function :math:`\varphi` such that the probability density function
        of the elliptical distribution rewrites:

        .. math::

            f_{\vect{X}}(\vect{x}) =
                \varphi\left(\Tr{\left(\vect{x} - \vect{\mu}\right)}
                              \mat{\Sigma}^{-1}
                              \left(\vect{x} - \vect{\mu}\right)
                    \right),
                \quad \vect{x} \in \supp{\vect{X}}

        The density generator only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computePDF
        """
        return _dist_bundle3.Student_computeDensityGenerator(self, betaSquare)

    def computeLogDensityGenerator(self, betaSquare):
        r"""
        Computes the log of the density generator.

        Parameters
        ----------
        y : float
            Input.

        Returns
        -------
        p : float
            Value :math:`\log \varphi(y)`.

        Notes
        -----
        The density generator  :math:`\varphi` is defined in :eq:`generator`.

        See Also
        --------
        isElliptical, computePDF
        """
        return _dist_bundle3.Student_computeLogDensityGenerator(self, betaSquare)

    def computeDensityGeneratorDerivative(self, betaSquare):
        r"""
        Compute the first-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Value :math:`\dfrac{d\varphi}{d\,t}(y)`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle3.Student_computeDensityGeneratorDerivative(self, betaSquare)

    def computeDensityGeneratorSecondDerivative(self, betaSquare):
        r"""
        Compute the second-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Value :math:`\dfrac{d^2\varphi}{d\,t^2}(y)`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle3.Student_computeDensityGeneratorSecondDerivative(self, betaSquare)

    def __init__(self, *args):
        _dist_bundle3.Student_swiginit(self, _dist_bundle3.new_Student(*args))
    __swig_destroy__ = _dist_bundle3.delete_Student

# Register Student in _dist_bundle3:
_dist_bundle3.Student_swigregister(Student)
class StudentFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Student factory.

    Notes
    -----
    Some parameters are estimated by the method of moments and others by the maximum reduced 
    likelihood method:

    .. math::
        :nowrap:

        \begin{align*}
          \Hat{\mu} = &\Hat{\mu}_x \\
          \Hat{\sigma} = &\Hat{\sigma}_x\sqrt{\dfrac{\Hat{\nu}-2}{\Hat{\nu}}} \\
          \Hat{R}_{ij} = &\dfrac{2}{\pi}\arcsin(\tau_{ij})
        \end{align*}

    where :math:`\mat{\tau}` is the sample Kendall tau matrix and :math:`\Hat{\nu}`
    maximizes the reduced likelihood associated to :class:`~openturns.Student` with
    parameters :math:`(\Hat{\nu}, \Hat{\mu}, \hat{\sigma}(\Hat{\nu}), \Hat{\mat{R}})`.

    See also
    --------
    DistributionFactory, Student
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.StudentFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.StudentFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle3.StudentFactory_buildEstimator(self, *args)

    def buildAsStudent(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsStudent()

            buildAsStudent(*sample*)

            buildAsStudent(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.Student`.

        Returns
        -------
        dist : :class:`~openturns.Student`
            The estimated distribution as a Student.

            In the first usage, the default Student distribution is built.
        """
        return _dist_bundle3.StudentFactory_buildAsStudent(self, *args)

    def __init__(self, *args):
        _dist_bundle3.StudentFactory_swiginit(self, _dist_bundle3.new_StudentFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_StudentFactory

# Register StudentFactory in _dist_bundle3:
_dist_bundle3.StudentFactory_swigregister(StudentFactory)
class Trapezoidal(openturns.model_copula.ContinuousDistribution):
    r"""
    Trapezoidal distribution.

    Parameters
    ----------
    a : float, :math:`a < d`
        Lower bound.

        Default value is -2.0.
    b : float, :math:`a \leq b < c`
        Level start.

        Default value is -1.0.
    c : float, :math:`b < c \leq d`
        Level end.

        Default value is is 1.0.
    d : float, :math:`c \leq d`
        Upper bound.

        Default value is 2.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \left\{
                     \begin{array}{ll}
                     \displaystyle h \frac{x - a}{b - a} & a \leq x < b \\
                     \displaystyle h                     & b \leq x < c \\
                     \displaystyle h \frac{d - x}{d - c} & c \leq x \leq d \\
                     \end{array}
                 \right., \quad x \in [a, d]

    with: :math:`h=\frac{2}{d+c-a-b}`

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{h}{6}(d^2 + cd + c^2 - b^2 - ab - a^2)  \\
            \Var{X} & = &  \frac{h^2}{72}(d^4 + 2cd^3 - 3bd^3 - 3ad^3 ...\\
                        & & - 3bcd^2 - 3acd^2 + 4b^2d^2 + 4abd^2 ...\\
                        & & + 4a^2d^2 + 2c^3d - 3bc^2d - 3ac^2d ...\\
                        & & + 4b^2cd + 4abcd + 4a^2cd - 3b^3d - 3ab^2d ...\\
                        & & - 3a^2bd - 3a^3d + c^4 - 3bc^3 - 3ac^3 + 4b^2c^2 ...\\
                        & & + 4abc^2 + 4a^2c^2 - 3b^3c - 3ab^2c - 3a^2bc ...\\
                        & & - 3a^3c + b^4 + 2ab^3 + 2a^3b + a^4)
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Trapezoidal(1.0, 2.3, 4.5, 5.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Trapezoidal_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Trapezoidal___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Trapezoidal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Trapezoidal___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Trapezoidal_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Trapezoidal_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Trapezoidal_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Trapezoidal_computeCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Trapezoidal_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Trapezoidal_computePDFGradient(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Trapezoidal_computeLogPDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Trapezoidal_computeCDFGradient(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.Trapezoidal_computeEntropy(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.Trapezoidal_getRoughness(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Trapezoidal_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Trapezoidal_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Trapezoidal_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Trapezoidal_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Trapezoidal_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Trapezoidal_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Trapezoidal_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Trapezoidal_isElliptical(self)

    def setA(self, a):
        r"""
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float, :math:`a \leq b < c \leq d`
            Lower bound.
        """
        return _dist_bundle3.Trapezoidal_setA(self, a)

    def getA(self):
        r"""
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.Trapezoidal_getA(self)

    def setB(self, b):
        r"""
        Accessor to the distribution's level start.

        Returns
        -------
        b : float, :math:`a \leq b < c \leq d`
            Level start.
        """
        return _dist_bundle3.Trapezoidal_setB(self, b)

    def getB(self):
        r"""
        Accessor to the distribution's level start.

        Returns
        -------
        b : float
            Level start.
        """
        return _dist_bundle3.Trapezoidal_getB(self)

    def setC(self, c):
        r"""
        Accessor to the distribution's level end.

        Returns
        -------
        c : float, :math:`a \leq b < c \leq d`
            Level end.
        """
        return _dist_bundle3.Trapezoidal_setC(self, c)

    def getC(self):
        r"""
        Accessor to the distribution's level end.

        Returns
        -------
        c : float
            Level end.
        """
        return _dist_bundle3.Trapezoidal_getC(self)

    def setD(self, d):
        r"""
        Accessor to the distribution's upper bound.

        Returns
        -------
        d : float, :math:`a \leq b < c \leq d`
            Upper bound.
        """
        return _dist_bundle3.Trapezoidal_setD(self, d)

    def getD(self):
        r"""
        Accessor to the distribution's upper bound.

        Returns
        -------
        d : float
            Upper bound.
        """
        return _dist_bundle3.Trapezoidal_getD(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle3.Trapezoidal_getSingularities(self)

    def __init__(self, *args):
        _dist_bundle3.Trapezoidal_swiginit(self, _dist_bundle3.new_Trapezoidal(*args))
    __swig_destroy__ = _dist_bundle3.delete_Trapezoidal

# Register Trapezoidal in _dist_bundle3:
_dist_bundle3.Trapezoidal_swigregister(Trapezoidal)
class TrapezoidalFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Trapezoidal factory.

    Notes
    -----
    The parameters are estimated by the maximum likelihood method.

    See also
    --------
    DistributionFactory, Trapezoidal
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TrapezoidalFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.TrapezoidalFactory_build(self, *args)

    def buildAsTrapezoidal(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsTrapezoidal()

            buildAsTrapezoidal(*sample*)

            buildAsTrapezoidal(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.Trapezoidal`.

        Returns
        -------
        dist : :class:`~openturns.Trapezoidal`
            The estimated distribution as a Trapezoidal.

            In the first usage, the default Trapezoidal distribution is built.
        """
        return _dist_bundle3.TrapezoidalFactory_buildAsTrapezoidal(self, *args)

    def __init__(self, *args):
        _dist_bundle3.TrapezoidalFactory_swiginit(self, _dist_bundle3.new_TrapezoidalFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_TrapezoidalFactory

# Register TrapezoidalFactory in _dist_bundle3:
_dist_bundle3.TrapezoidalFactory_swigregister(TrapezoidalFactory)
class Triangular(openturns.model_copula.ContinuousDistribution):
    r"""
    Triangular distribution.

    Parameters
    ----------
    a : float
        Lower bound.

        Default value is -1.0.
    m : float, :math:`a \leq m \leq b`
        Mode.

        Default value is 0.0.
    b : float, :math:`a < b`
        Upper bound.

        Default value is 1.0.


    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \left\{
                     \begin{array}{ll}
                     \displaystyle \frac{2(x - a)}{(m - a)(b - a)}
                                   & a \leq x \leq m \\
                     \displaystyle \frac{2(b - x)}{(b - m)(b - a)}
                                   & m \leq x \leq b
                     \end{array}
                 \right., \quad x \in [a, b]

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & =  & \frac{1}{3}\,(a+m+b) \\
            \Var{X} & = & \frac{1}{18} (a^2+b^2+m^2-ab-am-bm)
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Triangular(1.0, 2.5, 4.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Triangular_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Triangular___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Triangular___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Triangular___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Triangular_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Triangular_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Triangular_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Triangular_computeCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Triangular_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Triangular_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Triangular_computeCDFGradient(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.Triangular_computeEntropy(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.Triangular_getRoughness(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Triangular_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Triangular_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Triangular_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Triangular_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Triangular_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Triangular_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Triangular_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Triangular_isElliptical(self)

    def setAMB(self, a, m, b):
        r"""
        Accessor to the distribution parameters.

        Parameters
        ----------
        a : float
            Lower bound.
        m : float, :math:`a \leq m \leq b`
            Mode.
        b : float, :math:`a < b`
            Upper bound.
        """
        return _dist_bundle3.Triangular_setAMB(self, a, m, b)

    def getA(self):
        r"""
        Accessor to the distribution lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.Triangular_getA(self)

    def getM(self):
        r"""
        Accessor to the distribution  mode.

        Returns
        -------
        m : float
            Mode.
        """
        return _dist_bundle3.Triangular_getM(self)

    def getB(self):
        r"""
        Accessor to the distribution upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle3.Triangular_getB(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle3.Triangular_getSingularities(self)

    def __init__(self, *args):
        _dist_bundle3.Triangular_swiginit(self, _dist_bundle3.new_Triangular(*args))
    __swig_destroy__ = _dist_bundle3.delete_Triangular

# Register Triangular in _dist_bundle3:
_dist_bundle3.Triangular_swigregister(Triangular)
class TriangularFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Triangular factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{a}_n=(1-\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\
          \displaystyle\Hat{b}_n=(1+\mathrm{sign}(x_{(n,n)})/(2+n))x_{(n,n)}\\
          \displaystyle\Hat{m}_n=3\bar{x}_n-\Hat{a}_n-\Hat{b}_n
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Triangular
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TriangularFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.TriangularFactory_build(self, *args)

    def buildAsTriangular(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsTriangular()

            buildAsTriangular(*sample*)

            buildAsTriangular(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.Triangular`.

        Returns
        -------
        dist : :class:`~openturns.Triangular`
            The estimated distribution as a Triangular.

            In the first usage, the default Triangular distribution is built.
        """
        return _dist_bundle3.TriangularFactory_buildAsTriangular(self, *args)

    def __init__(self, *args):
        _dist_bundle3.TriangularFactory_swiginit(self, _dist_bundle3.new_TriangularFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_TriangularFactory

# Register TriangularFactory in _dist_bundle3:
_dist_bundle3.TriangularFactory_swigregister(TriangularFactory)
class TruncatedNormal(openturns.model_copula.ContinuousDistribution):
    r"""
    TruncatedNormal distribution.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is 0.0.
    sigma : float, :math:`\sigma > 0`
        Standard deviation.

        Default value is 1.0.
    a : float
        Lower bound.

        Default is -1.0.
    b : float, :math:`a < b`
        Upper bound.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{\sigma}
                 \frac{ \phi \left(\frac{x - \mu}{\sigma}\right)}
                      { \Phi \left(\frac{b - \mu}{\sigma}\right)
                      - \Phi \left(\frac{a - \mu}{\sigma}\right)},
                 \quad x \in [a; b]

    where :math:`\phi` and :math:`\Phi` are, respectively, the probability density
    distribution function and the cumulative distribution function of a standard
    normal distribution.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \mu + \frac{\phi(\frac{a - \mu}{\sigma})
                                       - \phi(\frac{b - \mu}{\sigma})}
                                        {\Phi(\frac{b - \mu}{\sigma})
                                       - \Phi(\frac{a - \mu}{\sigma})}\sigma \\
            \Var{X} & = & \sigma^2
                      \left[1
                        +\frac{\frac{a - \mu}{\sigma} \phi(\frac{a - \mu}{\sigma})
                             - \frac{b - \mu}{\sigma} \phi(\frac{b - \mu}{\sigma})}
                              {\Phi(\frac{b - \mu}{\sigma})
                             - \Phi(\frac{a - \mu}{\sigma})}
                        -\left(
                         \frac{\phi(\frac{a - \mu}{\sigma})
                             - \phi(\frac{b - \mu}{\sigma})}
                              {\Phi(\frac{b - \mu}{\sigma})
                             - \Phi(\frac{a - \mu}{\sigma})}
                          \right)^2
                      \right]
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.TruncatedNormal(0.5, 3.0, -2.0, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TruncatedNormal_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.TruncatedNormal___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.TruncatedNormal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.TruncatedNormal___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.TruncatedNormal_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.TruncatedNormal_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.TruncatedNormal_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.TruncatedNormal_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.TruncatedNormal_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.TruncatedNormal_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.TruncatedNormal_computeEntropy(self)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\alpha`.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _dist_bundle3.TruncatedNormal_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\alpha`.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.TruncatedNormal_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.TruncatedNormal_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.TruncatedNormal_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.TruncatedNormal_computePDFGradient(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.TruncatedNormal_computeLogPDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.TruncatedNormal_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.TruncatedNormal_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.TruncatedNormal_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.TruncatedNormal_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.TruncatedNormal_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.TruncatedNormal_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.TruncatedNormal_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.TruncatedNormal_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.TruncatedNormal_isElliptical(self)

    def setMu(self, mu):
        r"""
        Accessor to the distribution's mean.

        Parameters
        ----------
        mu : float
            Mean.
        """
        return _dist_bundle3.TruncatedNormal_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the distribution's mean.

        Returns
        -------
        mu : float
            Mean.
        """
        return _dist_bundle3.TruncatedNormal_getMu(self)

    def setSigma(self, sigma):
        r"""
        Accessor to the distribution's standard deviation.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Standard deviation.
        """
        return _dist_bundle3.TruncatedNormal_setSigma(self, sigma)

    def getSigma(self):
        r"""
        Accessor to the distribution's standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation.
        """
        return _dist_bundle3.TruncatedNormal_getSigma(self)

    def setA(self, a):
        r"""
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle3.TruncatedNormal_setA(self, a)

    def getA(self):
        r"""
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.TruncatedNormal_getA(self)

    def setB(self, b):
        r"""
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`b > a`
            Upper bound.
        """
        return _dist_bundle3.TruncatedNormal_setB(self, b)

    def getB(self):
        r"""
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle3.TruncatedNormal_getB(self)

    def __init__(self, *args):
        _dist_bundle3.TruncatedNormal_swiginit(self, _dist_bundle3.new_TruncatedNormal(*args))
    __swig_destroy__ = _dist_bundle3.delete_TruncatedNormal

# Register TruncatedNormal in _dist_bundle3:
_dist_bundle3.TruncatedNormal_swigregister(TruncatedNormal)
class TruncatedNormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Truncated Normal factory.

    Notes
    -----
    Several estimators to build a TruncatedNormal distribution from a scalar sample
    are available. The default strategy is using the maximum likelihood estimators with scaling.

    **Maximum likelihood estimator:**

    The parameters are estimated by numerical maximum likelihood estimation with 
    scaling. 
    The starting point of the optimization algorithm is based on the moment based 
    estimator. 

    Let :math:`n` be the sample sample size. 
    Let :math:`x_{min}` be the sample minimum and :math:`x_{max}` be the sample maximum. 

    We compute the scaling parameters :math:`\alpha` and :math:`\beta` 
    from the equations: 

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \alpha = \frac{2}{x_{min} - x_{max}}, \\
          \displaystyle \beta = \frac{1}{2} (x_{min} + x_{max}).
        \end{eqnarray*}

    Then the sample :math:`\{x_i\}_{i=1,...,n}` is scaled into 
    :math:`\{u_i\}_{i=1,...,n}` from the equation:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle u_i = \alpha (x_i - \beta)
        \end{eqnarray*}

    for :math:`i=1,...,n`. 
    Hence, the scaled sample is so that :math:`u_i\in[-1,1]` 
    for :math:`i=1,...,n`. 

    The starting point of the likelihood maximization algorithm is based on the 
    scaled sample. 
    Let 

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \mu_0^u = \bar{u}, \\
          \displaystyle \sigma_0^u = \sigma_{u, n}
        \end{eqnarray*}

    where :math:`\bar{u}` is the sample mean of the scaled sample and 
    :math:`\sigma_{u, n}` is the sample standard deviation of the scaled sample. 

    Then the likelihood maximization optimization algorithm is used to fit the 
    scaled truncated normal distribution. 
    The `TruncatedNormalFactory-SigmaLowerBound` key in the :class:`~openturns.ResourceMap` 
    is used as a lower bound for the scaled standard deviation. 

    Let :math:`\epsilon` be computed from the sample size:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \epsilon = 1 + \frac{1}{n}.
        \end{eqnarray*}

    The lower and upper bounds of the scaled truncated normal distribution are set to 
    :math:`-\epsilon` and :math:`\epsilon` and are not optimized. 
    This leads to a maximum likelihood optimization problem in 2 dimensions only, where the 
    solution is the optimum scaled mean :math:`\mu_u^\star` and the 
    optimum scaled standard deviation :math:`\sigma_u^\star`. 

    Finally, the parameters of the truncated normal distribution are computed 
    from the parameters of the scaled truncated normal distribution. 
    The inverse scaling equation is :math:`x = \beta + \frac{u}{\beta}`, which 
    leads to:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \mu = \beta + \frac{\mu_u^\star}{\alpha}, \\
          \displaystyle \sigma = \frac{\sigma_u^\star}{\alpha}, \\
          \displaystyle a = \beta - \frac{\epsilon}{\alpha}, \\
          \displaystyle b = \beta + \frac{\epsilon}{\alpha}.
        \end{eqnarray*}

    **Moment based estimator:**

    Let :math:`x_{min}` be the sample minimum and :math:`x_{max}` be the sample maximum. 
    Let :math:`\delta = x_{max} - x_{min}` be the sample range. 

    The distribution bounds are computed from the equations:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{a}_n = x_{min} - \frac{\delta}{n + 2}\\
          \displaystyle\Hat{b}_n = x_{max} + \frac{\delta}{n + 2}
        \end{eqnarray*}

    Then the :math:`\mu` and :math:`\sigma` parameters are estimated from the 
    methods of moments. 

    See also
    --------
    DistributionFactory, TruncatedNormal

    Examples
    --------

    In the following example, the parameters of a :class:`~openturns.TruncatedNormal` 
    are estimated from a sample. 

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> size = 10000
    >>> distribution = ot.TruncatedNormal(2.0, 3.0, -1.0, 4.0)
    >>> sample = distribution.getSample(size)
    >>> factory = ot.TruncatedNormalFactory()
    >>> estimated = factory.build(sample)
    >>> estimated = factory.buildMethodOfMoments(sample)
    >>> estimated = factory.buildMethodOfLikelihoodMaximization(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TruncatedNormalFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.TruncatedNormalFactory_build(self, *args)

    def buildAsTruncatedNormal(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsTruncatedNormal()

            buildAsTruncatedNormal(*sample*)

            buildAsTruncatedNormal(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.TruncatedNormal`.

        Returns
        -------
        dist : :class:`~openturns.TruncatedNormal`
            The estimated distribution as a TruncatedNormal.

            In the first usage, the default TruncatedNormal distribution is built.
        """
        return _dist_bundle3.TruncatedNormalFactory_buildAsTruncatedNormal(self, *args)

    def buildMethodOfMoments(self, sample):
        r"""
        Method of moments estimator.


        Parameters
        ----------
        sample : 2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.TruncatedNormal`
            The estimated distribution.
        """
        return _dist_bundle3.TruncatedNormalFactory_buildMethodOfMoments(self, sample)

    def buildMethodOfLikelihoodMaximization(self, sample):
        r"""
        Method of likelihood maximization.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.TruncatedNormal`
            The estimated distribution
        """
        return _dist_bundle3.TruncatedNormalFactory_buildMethodOfLikelihoodMaximization(self, sample)

    def __init__(self, *args):
        _dist_bundle3.TruncatedNormalFactory_swiginit(self, _dist_bundle3.new_TruncatedNormalFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_TruncatedNormalFactory

# Register TruncatedNormalFactory in _dist_bundle3:
_dist_bundle3.TruncatedNormalFactory_swigregister(TruncatedNormalFactory)
class Uniform(openturns.model_copula.ContinuousDistribution):
    r"""
    Uniform distribution.

    Parameters
    ----------
    a : float
        Lower bound.

        Default value is -1.0.
    b : float, :math:`b > a`
        Upper bound.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{b-a}, \quad x \in [a; b]

    with :math:`a < b`.

    Its first moments are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{a+b}{2} \\
            \Var{X} & = & \frac{(b-a)^2}{12}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Uniform(2.0, 3.0)

    Create it from the alternative parametrization :math:`(\mu, \sigma)`:

    >>> distribution2 = ot.UniformMuSigma(3.0, 1.15).getDistribution()

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Uniform_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Uniform___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Uniform___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Uniform___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Uniform_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle3.Uniform_getSample(self, size)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Uniform_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Uniform_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Uniform_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.Uniform_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Uniform_computeCharacteristicFunction(self, x)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\alpha`.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _dist_bundle3.Uniform_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\alpha`.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the bilateral confidence interval at level 0.9 with marginal probability:

        >>> confInt, marginalProb = paramDist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _dist_bundle3.Uniform_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\alpha`.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.Uniform_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Uniform_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.Uniform_computeCDFGradient(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.Uniform_computeEntropy(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.Uniform_getRoughness(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Uniform_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Uniform_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.Uniform_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Uniform_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Uniform_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Uniform_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Uniform_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Uniform_isElliptical(self)

    def isCopula(self):
        r"""
        Test whether the distribution is a copula or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A copula is a distribution with uniform margins on [0; 1].
        """
        return _dist_bundle3.Uniform_isCopula(self)

    def setA(self, a):
        r"""
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle3.Uniform_setA(self, a)

    def getA(self):
        r"""
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.Uniform_getA(self)

    def setB(self, b):
        r"""
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`a < b`
            Upper bound.
        """
        return _dist_bundle3.Uniform_setB(self, b)

    def getB(self):
        r"""
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle3.Uniform_getB(self)

    def __init__(self, *args):
        _dist_bundle3.Uniform_swiginit(self, _dist_bundle3.new_Uniform(*args))
    __swig_destroy__ = _dist_bundle3.delete_Uniform

# Register Uniform in _dist_bundle3:
_dist_bundle3.Uniform_swigregister(Uniform)
class UniformFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Uniform factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{a}_n=(1-\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\
          \displaystyle\Hat{b}_n=(1+\mathrm{sign}(x_{(n,n)})/(2+n))x_{(n,n)}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Uniform
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.UniformFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.UniformFactory_build(self, *args)

    def buildAsUniform(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsUniform()

            buildAsUniform(*sample*)

            buildAsUniform(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.Uniform`.

        Returns
        -------
        dist : :class:`~openturns.Uniform`
            The estimated distribution as a :class:`openturns.Uniform`.

            In the first usage, the default :class:`openturns.Uniform` distribution is built.
        """
        return _dist_bundle3.UniformFactory_buildAsUniform(self, *args)

    def __init__(self, *args):
        _dist_bundle3.UniformFactory_swiginit(self, _dist_bundle3.new_UniformFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_UniformFactory

# Register UniformFactory in _dist_bundle3:
_dist_bundle3.UniformFactory_swigregister(UniformFactory)
class UniformMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    Uniform distribution parameters.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is 0.0.
    sigma : float
        Standard deviation :math:`\sigma > 0`.

        Default value is 0.57735.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        a &= \mu - \sigma \sqrt{3} \\
        b &= \mu + \sigma \sqrt{3}

    See also
    --------
    Uniform

    Examples
    --------
    Create the parameters of the Uniform distribution:

    >>> import openturns as ot
    >>> parameters = ot.UniformMuSigma(8.4, 2.25)

    Convert parameters into the native parameters:

    >>> p_native = parameters.evaluate()

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> p_grad = parameters.gradient()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.UniformMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.UniformMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle3.UniformMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle3.UniformMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle3.UniformMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle3.UniformMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle3.UniformMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle3.UniformMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle3.UniformMuSigma_getDescription(self)

    def __repr__(self):
        return _dist_bundle3.UniformMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.UniformMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle3.UniformMuSigma_swiginit(self, _dist_bundle3.new_UniformMuSigma(*args))
    __swig_destroy__ = _dist_bundle3.delete_UniformMuSigma

# Register UniformMuSigma in _dist_bundle3:
_dist_bundle3.UniformMuSigma_swigregister(UniformMuSigma)
class UserDefined(openturns.model_copula.DiscreteDistribution):
    r"""
    UserDefined distribution.

    Available constructors:

        UserDefined(*points*)

        UserDefined(*points, weights*)

    Parameters
    ----------
    points : 2-d sequence of float
        List of :math:`n` points of dimension :math:`d` :math:`\vect{x}_i`, :math:`i = 1, \ldots, n`.

        Default value is [1].
    weights : sequence of float
        List of :math:`n` weights :math:`p_i`, :math:`i = 1, \ldots, n`.
        If :math:`\sum_{i=1}^n p_i \neq 1`, the weights are normalized.

        Default value is [1].

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{\vect{X} = \vect{x}_i} = p_i, \quad i = 1,\ldots,n.

    Its first moment is:

    .. math::

        \Expect{X} = \sum_{i=1}^n p_i \vect{x}_i.

    Sampling is done using the *alias* method as described in [devroye1986]_, Chapter 3.
    It has an optimal space complexity of :math:`\cO(n)` and runtime CPU complexity of :math:`\cO(1)`, see :meth:`~openturns.DistFunc.rDiscrete`.

    Examples
    --------
    Create a 1d-distribution:

    >>> import openturns as ot
    >>> points = ot.Sample([[1.0], [2.0], [3.0]])
    >>> weights = [0.4, 0.5, 1.0]
    >>> my_distribution = ot.UserDefined(points, weights)
    >>> print(my_distribution)
    UserDefined({x = [1], p = 0.210526}, {x = [2], p = 0.263158}, {x = [3], p = 0.526316})

    Create a 3d-distribution:

    >>> points = ot.Sample(4, 3)
    >>> for i in range(4):
    ...     for j in range(3):
    ...         points[i, j] = 10 * (i + 1) + 0.1 * (j + 1)
    >>> distribution = ot.UserDefined(points, [0.3,0.2,0.25,0.25])
    >>> print(distribution)
    UserDefined({x = [10.1,10.2,10.3], p = 0.3}, {x = [20.1,20.2,20.3], p = 0.2}, {x = [30.1,30.2,30.3], p = 0.25}, {x = [40.1,40.2,40.3], p = 0.25})

    Create :math:`\mathcal{U}[\![9,19]\!]`, the discrete uniform distribution on the set {9, 10, ..., 19}
    with equal weights:

    >>> points = [[i] for i in range(9, 20)]
    >>> distribution = ot.UserDefined(points)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.UserDefined_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.UserDefined___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.UserDefined___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.UserDefined___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.UserDefined_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle3.UserDefined_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.UserDefined_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.UserDefined_computeCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.UserDefined_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.UserDefined_computeCDFGradient(self, *args)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.UserDefined_getSupport(self, *args)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.UserDefined_isIntegral(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.UserDefined_getParametersCollection(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.UserDefined_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.UserDefined_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.UserDefined_getParameterDescription(self)

    def setData(self, points, weights):
        r"""
        Accessor to the distribution's :math:`x` and :math:`p` parameters.

        Parameters
        ----------
        points : :class:`~openturns.Sample`
            Collection of points
        weights : :class:`~openturns.Point`
            Associated weights
        """
        return _dist_bundle3.UserDefined_setData(self, points, weights)

    def getX(self):
        r"""
        Accessor to the distribution's :math:`x` parameter.

        Returns
        -------
        coll : :class:`~openturns.Sample`
            Collection of points.
        """
        return _dist_bundle3.UserDefined_getX(self)

    def getP(self):
        r"""
        Accessor to the distribution's :math:`p` parameter.

        Returns
        -------
        coll : :class:`~openturns.Point`
            Collection of weights.
        """
        return _dist_bundle3.UserDefined_getP(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle3.UserDefined_getMarginal(self, *args)

    def compactSupport(self, *args):
        r"""
        Compact the support of the distribution.

        Compact by concatenating points of distance less than :math:`\varepsilon`
        and adding their weights.

        Notes
        -----
        The :math:`\varepsilon` has a default value associated to the
        :class:`~openturns.ResourceMap` key *DiscreteDistribution-SupportEpsilon*.

        The method is always used for any univariate distributions and for upper
        dimensions, it is only used when the number of points defining the support is
        less than a limit specified by the :class:`~openturns.ResourceMap` key
        *UserDefined-SmallSize*. By default, the size limit is equal to :math:`1e4`.

        """
        return _dist_bundle3.UserDefined_compactSupport(self, *args)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle3.UserDefined_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.UserDefined_hasIndependentCopula(self)

    def __init__(self, *args):
        _dist_bundle3.UserDefined_swiginit(self, _dist_bundle3.new_UserDefined(*args))
    __swig_destroy__ = _dist_bundle3.delete_UserDefined

# Register UserDefined in _dist_bundle3:
_dist_bundle3.UserDefined_swigregister(UserDefined)
class UserDefinedFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    UserDefined factory.

    Notes
    -----
    The distribution is estimated by an Uniform distribution over the sample.

    See also
    --------
    DistributionFactory, UserDefined
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.UserDefinedFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.UserDefinedFactory_build(self, *args)

    def buildAsUserDefined(self, *args):
        return _dist_bundle3.UserDefinedFactory_buildAsUserDefined(self, *args)

    def __init__(self, *args):
        _dist_bundle3.UserDefinedFactory_swiginit(self, _dist_bundle3.new_UserDefinedFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_UserDefinedFactory

# Register UserDefinedFactory in _dist_bundle3:
_dist_bundle3.UserDefinedFactory_swigregister(UserDefinedFactory)
class VonMises(openturns.model_copula.ContinuousDistribution):
    r"""
    Von Mises distribution.

    Parameters
    ----------
    mu : float
        Mean parameter.

        Default value is 0.0.
    kappa : float, :math:`\kappa > 0`
        Concentration parameter.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{e^{\kappa\cos(x-\mu)}}
                      {2\pi \mathrm{I}_0(\kappa)}, \quad x \in [\mu-\pi, \mu+\pi]

    with :math:`\kappa > 0` and :math:`\mathrm{I}_0` the modified Bessel function of order 0.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.VonMises(1.0, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.VonMises_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.VonMises___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.VonMises___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.VonMises___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.VonMises_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.VonMises_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.VonMises_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.VonMises_computeLogPDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.VonMises_computeEntropy(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.VonMises_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.VonMises_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.VonMises_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.VonMises_isElliptical(self)

    def setMu(self, mu):
        r"""
        Accessor to the location parameter.

        Parameters
        ----------
        mu : float
            Mean parameter.
        """
        return _dist_bundle3.VonMises_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the location parameter.

        Returns
        -------
        mu : float
            Mean parameter.
        """
        return _dist_bundle3.VonMises_getMu(self)

    def setKappa(self, kappa):
        r"""
        Accessor to the concentration parameter.

        Parameters
        ----------
        kappa : float, :math:`\kappa > 0`
            Concentration parameter.
        """
        return _dist_bundle3.VonMises_setKappa(self, kappa)

    def getKappa(self):
        r"""
        Accessor to the concentration parameter.

        Returns
        -------
        kappa : float
            Concentration parameter.
        """
        return _dist_bundle3.VonMises_getKappa(self)

    def getCircularMean(self):
        return _dist_bundle3.VonMises_getCircularMean(self)

    def getCircularVariance(self):
        return _dist_bundle3.VonMises_getCircularVariance(self)

    def __init__(self, *args):
        _dist_bundle3.VonMises_swiginit(self, _dist_bundle3.new_VonMises(*args))
    __swig_destroy__ = _dist_bundle3.delete_VonMises

# Register VonMises in _dist_bundle3:
_dist_bundle3.VonMises_swigregister(VonMises)
class VonMisesFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    VonMises factory.

    Parameters
    ----------
    circular : bool, optional
        Flag to tell if the data are in :math:`\Rset` (*circular=False*) or in :math:`\Rset/(2\pi\Zset)` (*circular=True*). Default is True. 

    Notes
    -----
    If *circular=True*, we introduce :math:`z_n=\frac{1}{n}\sum_{k=1}^ne^{iX_k}`. Then, the estimators read:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\mu}_n^{\strut} &=& \mathrm{Arg}(z_n)\\
          \displaystyle\Hat{\kappa}_n&\mbox{s.t.}&\frac{I_1(\Hat{\kappa}_n)}{I_0(\Hat{\kappa}_n)}=\sqrt{\frac{n}{n-1}\left(|z_n|^2-\frac{1}{n}\right)}
        \end{eqnarray*}

    where :math:`I_0` and :math:`I_1` are the modified Bessel functions of the first kind of order 0 and 1.

    If *circular=False*, the estimators read:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\mu}_n^{\strut}&=&\frac{1}{n}\sum_{k=1}^n X_k\\
          \displaystyle\Hat{\kappa}_n&\mbox{s.t.}&\frac{I_1(\Hat{\kappa}_n)}{I_0(\Hat{\kappa}_n)}=\frac{1}{n}\sum_{k=1}^n\cos(X_k-\Hat{\mu}_n)
        \end{eqnarray*}

    Note that the last equation has no solution if the right-hand side is not positive.

    In both cases, the resolution of this equation defininig :math:`\Hat{\kappa}_n` can be tuned through
    `VonMisesFactory-RelativePrecision`, `VonMisesFactory-ResidualPrecision`,
    `VonMisesFactory-MaximumIteration` in :class:`~openturns.ResourceMap`

    See also
    --------
    DistributionFactory, VonMises
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.VonMisesFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.VonMisesFactory_build(self, *args)

    def buildAsVonMises(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsVonMises()

            buildAsVonMises(*sample*)

            buildAsVonMises(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.VonMises`.

        Returns
        -------
        dist : :class:`~openturns.VonMises`
            The estimated distribution as a VonMises.

            In the first usage, the default VonMises distribution is built.
        """
        return _dist_bundle3.VonMisesFactory_buildAsVonMises(self, *args)

    def __init__(self, *args):
        _dist_bundle3.VonMisesFactory_swiginit(self, _dist_bundle3.new_VonMisesFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_VonMisesFactory

# Register VonMisesFactory in _dist_bundle3:
_dist_bundle3.VonMisesFactory_swigregister(VonMisesFactory)
class WeibullMin(openturns.model_copula.ContinuousDistribution):
    r"""
    WeibullMin distribution.


    Parameters
    ----------
    beta : float
        scale parameter :math:`\beta > 0`.

        Default value is 1.0.
    alpha : float
        shape parameter :math:`\alpha > 0`.

        Default value is 1.0.
    gamma : float, optional
        Location parameter.

        Default value is 0.0.

    Notes
    -----
    Its cumulative and probability density functions are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            F_X(x) & = & 1-\exp \left(-\left(\frac{x - \gamma}{\beta}\right)^{\alpha}\right), \quad x \in [\gamma; +\infty) \\
            f_X(x) & = & \frac{\alpha}{\beta}\left(\frac{x - \gamma}{\beta} \right) ^ {\alpha-1} \exp \left(-\left(\frac{x - \gamma}{\beta}\right)^{\alpha}\right), \quad x \in [\gamma; +\infty)
        \end{eqnarray*}

    with :math:`\beta > 0` and :math:`\alpha > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = &  \gamma + \beta \,\Gamma\left(1 + \frac{1}{\alpha}\right) \\
            \Var{X} & = & \beta^2 \left( \Gamma \left( 1 + \frac{2}{\alpha} \right) -  \Gamma^2 \left( 1 + \frac{1}{\alpha} \right) \right)
        \end{eqnarray*}

    where :math:`\Gamma` denotes Euler's Gamma function
    :meth:`~openturns.SpecFunc.Gamma`.

    It is possible to create a WeibullMin distribution from the alternative parametrization :math:`(\mu, \sigma, \gamma)`: see  :class:`~openturns.WeibullMinMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\mu, \sigma, \gamma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\beta, \alpha, \gamma)`.

    Note that if :math:`X` follows a WeibullMin :math:`(\beta, \alpha, \gamma)` distribution, then  :math:`(-X)` follows a WeibullMax :math:`(\beta, \alpha, -\gamma)` distribution.

    See also
    --------
    WeibullMax

    Examples
    --------
    Create a distribution from its native parameters :math:`(\beta, \alpha, \gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.WeibullMin(2.0, 1.5, 1.0)

    Create it from the alternative parametrization :math:`(\mu, \sigma, \gamma)`:

    >>> myDist2 = ot.WeibullMin()
    >>> myDist2.setParameter(ot.WeibullMinMuSigma()([2.8, 1.2, 1.0]))

    Create it from :math:`(\mu, \sigma, \gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.WeibullMinMuSigma(2.8, 1.2, 1.0)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.WeibullMin_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.WeibullMin___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.WeibullMin___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.WeibullMin___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.WeibullMin_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.WeibullMin_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.WeibullMin_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.WeibullMin_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.WeibullMin_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.WeibullMin_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.WeibullMin_computeCharacteristicFunction(self, x)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.WeibullMin_computeEntropy(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.WeibullMin_computePDFGradient(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.WeibullMin_computeLogPDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle3.WeibullMin_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.WeibullMin_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.WeibullMin_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.WeibullMin_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.WeibullMin_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.WeibullMin_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.WeibullMin_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.WeibullMin_getParameterDescription(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle3.WeibullMin_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution scale parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle3.WeibullMin_getBeta(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the distribution shape parameter :math:`\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\alpha > 0`
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle3.WeibullMin_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Accessor to the distribution shape parameter :math:`\alpha`.

        Returns
        -------
        alpha : float
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle3.WeibullMin_getAlpha(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution location parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle3.WeibullMin_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution location parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle3.WeibullMin_getGamma(self)

    def __init__(self, *args):
        _dist_bundle3.WeibullMin_swiginit(self, _dist_bundle3.new_WeibullMin(*args))
    __swig_destroy__ = _dist_bundle3.delete_WeibullMin

# Register WeibullMin in _dist_bundle3:
_dist_bundle3.WeibullMin_swigregister(WeibullMin)
class WeibullMinFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    WeibullMin factory.

    See also
    --------
    DistributionFactory, WeibullMin

    Notes
    -----
    Several estimators to build a WeibullMin distribution from a scalar sample
    are proposed. The default strategy is using the maximum likelihood estimators.

    **Moments based estimator:**

    Lets denote:

    - :math:`\displaystyle \overline{x}_n = \frac{1}{n} \sum_{i=1}^n x_i` the empirical
      mean of the sample, 
    - :math:`\displaystyle s_n^2 = \frac{1}{n-1} \sum_{i=1}^n (x_i - \overline{x}_n)^2`
      its empirical variance

    The estimator :math:`(\hat{\beta}_n, \hat{\alpha}_n, \hat{\gamma}_n)` of
    :math:`(\beta, \alpha, \gamma)` is defined by :

    .. math::
        :label: weibullMin_moment
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \Hat{\gamma}_n & = & (1-\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}
        \end{eqnarray*}

        \begin{eqnarray*}
           \overline{x}_n & = & \hat{\beta}_n \,\Gamma\left(1 + \frac{1}{\hat{\alpha}_n}\right)
                           +  \hat{\gamma}_n \\
            s_n^2 & = & \hat{\beta}_n^2 \left( \Gamma \left( 1 + \frac{2}{\hat{\alpha}_n} \right) -
                         \Gamma^2 \left( 1 + \frac{1}{\hat{\alpha}_n} \right) \right)
        \end{eqnarray*}


    **Maximum likelihood based estimator:**

    The following sums are defined by:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            S_0 &=&  \sum_{i=1}^n \frac{1}{x_i - \gamma} \\
            S_1 &=&  \sum_{i=1}^n \log (x_i - \gamma) \\
            S_2 &=&  \sum_{i=1}^n (x_i - \gamma)^{\alpha} \log (x_i - \gamma) \\
            S_3 &=&  \sum_{i=1}^n (x_i - \gamma)^{\alpha}\\
            S_4 &=&  \sum_{i=1}^n (x_i - \gamma)^{\alpha-1}
        \end{eqnarray*}


    The Maximum Likelihood estimator of :math:`(\beta, \alpha, \gamma)` is 
    defined by :math:`(\hat{\beta}_n, \hat{\alpha}_n, \hat{\gamma}_n)` verifying:

    .. math::
        :label: wm_mll_estimator
        :nowrap:

        \begin{eqnarray*}
            S_3(\hat{\alpha}_n,\hat{\gamma}_n) - n\hat{\beta}_n^{\hat{\alpha}_n} =  0 \\
            \hat{\alpha}_n \left[S_0(\hat{\gamma}_n) - n\dfrac{S_4(\hat{\alpha}_n,\hat{\gamma}_n)}{S_3(\hat{\alpha}_n,\hat{\gamma}_n)} \right] - S_0(\hat{\gamma}_n) = 0 \\
            S_0(\hat{\gamma}_n)(S_3(\hat{\alpha}_n,\hat{\gamma}_n)(n+S_1(\hat{\gamma}_n))-nS_2(\hat{\alpha}_n,\hat{\gamma}_n))-n^2S_4(\hat{\alpha}_n,\hat{\gamma}_n) = 0
        \end{eqnarray*}

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.WeibullMinFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle3.WeibullMinFactory_build(self, *args)

    def buildAsWeibullMin(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsWeibullMin()

            buildAsWeibullMin(*sample*)

            buildAsWeibullMin(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.WeibullMin`.

        Returns
        -------
        dist : :class:`~openturns.WeibullMin`
            The estimated distribution as a WeibullMin.

            In the first usage, the default WeibullMin distribution is built.
        """
        return _dist_bundle3.WeibullMinFactory_buildAsWeibullMin(self, *args)

    def buildMethodOfMoments(self, sample):
        r"""
        Method of moments estimator.


        Parameters
        ----------
        sample : 2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.WeibullMin`
            The estimated distribution.
        """
        return _dist_bundle3.WeibullMinFactory_buildMethodOfMoments(self, sample)

    def buildMethodOfLikelihoodMaximization(self, sample):
        r"""
        Method of likelihood maximization.

        Refer to :class:`~openturns.MaximumLikelihoodFactory`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.WeibullMin`
            The estimated distribution.

        Notes
        -----
        The maximization of the likelihood is initialized with the value of the estimator calculated with the method of moments.

        """
        return _dist_bundle3.WeibullMinFactory_buildMethodOfLikelihoodMaximization(self, sample)

    def __init__(self, *args):
        _dist_bundle3.WeibullMinFactory_swiginit(self, _dist_bundle3.new_WeibullMinFactory(*args))
    __swig_destroy__ = _dist_bundle3.delete_WeibullMinFactory

# Register WeibullMinFactory in _dist_bundle3:
_dist_bundle3.WeibullMinFactory_swigregister(WeibullMinFactory)
class WeibullMinMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    WeibullMin distribution parameters.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is 1.0.
    sigma : float
        Standard deviation :math:`\sigma > 0`.

        Default value is 1.0.
    gamma : float, optional
        Shift parameter :math:`\gamma < \mu`.

        Default value is 0.0.

    Notes
    -----
    The native parameters :math:`\alpha` and :math:`\beta` are searched such as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \mu & = &  \gamma + \beta \,\Gamma\left(1 + \frac{1}{\alpha}\right) \\
            \sigma^2 & = & \beta^2 \left( \Gamma \left( 1 + \frac{2}{\alpha} \right) - \Gamma^2 \left( 1 + \frac{1}{\alpha} \right) \right)
        \end{eqnarray*}


    The :math:`\gamma` parameter is the same.

    See also
    --------
    WeibullMin

    Examples
    --------
    Create the parameters  :math:`(\mu, \sigma, \gamma)` of the WeibullMin distribution:

    >>> import openturns as ot
    >>> parameters = ot.WeibullMinMuSigma(1.3, 1.23, -0.5)

    Convert parameters into the native parameters  :math:`(\beta, \alpha, \gamma)`:

    >>> print(parameters.evaluate())
    [1.99222,1.48961,-0.5]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.WeibullMinMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.WeibullMinMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle3.WeibullMinMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle3.WeibullMinMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle3.WeibullMinMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle3.WeibullMinMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle3.WeibullMinMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle3.WeibullMinMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle3.WeibullMinMuSigma_getDescription(self)

    def __repr__(self):
        return _dist_bundle3.WeibullMinMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.WeibullMinMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle3.WeibullMinMuSigma_swiginit(self, _dist_bundle3.new_WeibullMinMuSigma(*args))
    __swig_destroy__ = _dist_bundle3.delete_WeibullMinMuSigma

# Register WeibullMinMuSigma in _dist_bundle3:
_dist_bundle3.WeibullMinMuSigma_swigregister(WeibullMinMuSigma)
class Wishart(openturns.model_copula.ContinuousDistribution):
    r"""
    Wishart distribution.

    Parameters
    ----------
    V : 2-d sequence of float
        Scale matrix, positive definite of size :math:`p`.

        Default value is [[1.0]].
    nu : float, :math:`\nu > p - 1`
        Degrees of freedom.

        Default value is 1.0.

    See Also
    --------
    InverseWishart

    Notes
    -----
    The distribution is of dimension :math:`\frac{p(p+1)}{2}` (without the symmetry terms).

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> p = 3
    >>> nu = p + 1.0
    >>> distribution = ot.Wishart(ot.CovarianceMatrix(p), nu)

    Get a realization as covariance matrix:

    >>> matrix = distribution.getRealizationAsMatrix()
    >>> print(matrix)
    [[ 5.16322 2.73917 3.26582 ]
     [ 2.73917 2.63329 2.61323 ]
     [ 3.26582 2.61323 3.65668 ]]

    Get a realization (to be interpreted as the lower triangle terms of the matrix,
    line by line as a flat vector):

    >>> flat = distribution.getRealization()
    >>> print(flat)
    [5.82928,-5.5291,18.3127,-0.787297,2.42298,0.465375]

    Draw a sample (also in flat format):

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Wishart_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.Wishart___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Wishart___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Wishart___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.Wishart_getRealization(self)

    def getRealizationAsMatrix(self):
        r"""
        Get one realization of the distribution as a covariance matrix.

        Returns
        -------
        V : :class:`~openturns.CovarianceMatrix`
            A realization as a matrix
        """
        return _dist_bundle3.Wishart_getRealizationAsMatrix(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Wishart_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle3.Wishart_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.Wishart_computeCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.Wishart_computeEntropy(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Wishart_getStandardDeviation(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Wishart_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Wishart_setParametersCollection(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Wishart_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Wishart_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Wishart_getParameterDescription(self)

    def setV(self, v):
        r"""
        Accessor to the scale parameter.

        Parameters
        ----------
        V : 2-d sequence of float
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle3.Wishart_setV(self, v)

    def getV(self):
        r"""
        Accessor to the scale parameter.

        Returns
        -------
        V : :class:`~openturns.CovarianceMatrix`
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle3.Wishart_getV(self)

    def setNu(self, nu):
        r"""
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle3.Wishart_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle3.Wishart_getNu(self)

    def __init__(self, *args):
        _dist_bundle3.Wishart_swiginit(self, _dist_bundle3.new_Wishart(*args))
    __swig_destroy__ = _dist_bundle3.delete_Wishart

# Register Wishart in _dist_bundle3:
_dist_bundle3.Wishart_swigregister(Wishart)
class ZipfMandelbrot(openturns.model_copula.DiscreteDistribution):
    r"""
    ZipfMandelbrot distribution.

    Parameters
    ----------
    N : int, :math:`N > 0`

        Default value is 1.
    q : float, :math:`q \geq 0`

        Default value is 0.0.
    s : float, :math:`s > 0`

        Default value is 1.0.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{X = k} = \frac{1}{(k+q)^s \mathrm{H}(N,q,s)},
                       \quad \forall k \in [1, N]

    where :math:`\mathrm{H}(N,q,s)` is the Generalized Harmonic Number:
    :math:`\mathrm{H}(N,q,s) = \sum_{i=1}^{N} \frac{1}{(i+q)^s}`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & =  & \frac{\mathrm{H}_{N,q,s-1}}{\mathrm{H}_{N,q,s}}-q \\
            \Var{X} & = & \frac{\displaystyle \sum_{i=1}^N
                                    \frac{(i - \Expect{X})^2}{(i+q)^s}}{\mathrm{H}_{N,q,s}}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.ZipfMandelbrot(15, 1.2, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.ZipfMandelbrot_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle3.ZipfMandelbrot___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.ZipfMandelbrot___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.ZipfMandelbrot___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle3.ZipfMandelbrot_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.ZipfMandelbrot_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle3.ZipfMandelbrot_computeCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle3.ZipfMandelbrot_computeEntropy(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.ZipfMandelbrot_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ZipfMandelbrot_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle3.ZipfMandelbrot_getKurtosis(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.ZipfMandelbrot_isElliptical(self)

    def setQ(self, q):
        r"""
        Accessor to the parameter :math:`q`.

        Parameters
        ----------
        q : float, :math:`q >= 0`
        """
        return _dist_bundle3.ZipfMandelbrot_setQ(self, q)

    def getQ(self):
        r"""
        Accessor to the parameter :math:`q`.

        Returns
        -------
        q : float
        """
        return _dist_bundle3.ZipfMandelbrot_getQ(self)

    def setS(self, s):
        r"""
        Accessor to the parameter :math:`s`.

        Parameters
        ----------
        s : float, :math:`s > 0`
        """
        return _dist_bundle3.ZipfMandelbrot_setS(self, s)

    def getS(self):
        r"""
        Accessor to the parameter :math:`s`.

        Returns
        -------
        s : float
        """
        return _dist_bundle3.ZipfMandelbrot_getS(self)

    def setN(self, n):
        r"""
        Accessor to the parameter :math:`N`.

        Parameters
        ----------
        N : int, :math:`N > 0`
        """
        return _dist_bundle3.ZipfMandelbrot_setN(self, n)

    def getN(self):
        r"""
        Accessor to the parameter :math:`N`.

        Returns
        -------
        N : int
        """
        return _dist_bundle3.ZipfMandelbrot_getN(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.ZipfMandelbrot_getSupport(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.ZipfMandelbrot_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.ZipfMandelbrot_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.ZipfMandelbrot_getParameterDescription(self)

    def __init__(self, *args):
        _dist_bundle3.ZipfMandelbrot_swiginit(self, _dist_bundle3.new_ZipfMandelbrot(*args))
    __swig_destroy__ = _dist_bundle3.delete_ZipfMandelbrot

# Register ZipfMandelbrot in _dist_bundle3:
_dist_bundle3.ZipfMandelbrot_swigregister(ZipfMandelbrot)

