%feature("docstring") OT::TimeVaryingResult
"Distribution factory result for non stationary likelihood estimation.


We consider a non stationary GEV model to describe the distribution of :math:`Z_t`:

.. math::

    Z_t \\sim \\mbox{GEV}(\\mu(t), \\sigma(t), \\xi(t))

We have the values of :math:`Z_t` on the time stamps :math:`(t_1, \\dots, t_n)`.

For numerical reasons, the time stamps have been normalized using the linear function:

.. math::

    \\tau(t) = \\dfrac{t-c}{d}

Each of :math:`\\mu(t), \\sigma(t), \\xi(t)`  has an expression in terms of a parameter vector and time functions:

.. math::

    \\theta(t)  = h\\left(\\sum_{i=1}^{d_{\\theta}} \\beta_i^{\\theta} \\varphi_i^{\\theta}(\\tau(t))\\right)

where:

- :math:`h: \\Rset \\mapsto \\Rset` is usually referred to as the *inverse-link function*. The function :math:`\\theta(t)` denotes
  either :math:`\\mu(t)`, :math:`\\sigma(t)` or :math:`\\xi(t)`,
- each :math:`\\varphi_i^{\\theta}` is a scalar function :math:`\\Rset \\mapsto \\Rset`,
- each :math:`\\beta_i^{j} \\in \\Rset`.


We denote by :math:`d_{\\mu}`, :math:`d_{\\sigma}` and :math:`d_{\\xi}` the size of the functional basis of
:math:`\\mu`, :math:`\\sigma` and :math:`\\xi` respectively. We denote by
:math:`\\vect{\\beta} = (\\beta_1^{\\mu}, \\dots, \\beta_{d_{\\mu}}^{\\mu}, \\beta_1^{\\sigma}, \\dots, \\beta_{d_{\\sigma}}^{\\sigma}, \\beta_1^{\\xi}, \\dots, \\beta_{d_{\\xi}}^{\\xi})`
the complete vector of parameters.

The estimator of vector  :math:`\\vect{\\beta}` maximizes the likelihood of the Parent distribution.

Parameters
----------
factory : :class:`~openturns.DistributionFactory`
    Parent distribution factory.
data : 2-d sequence of float
    Data.
parameterFunction : :class:`~openturns.Function`
    The  function :math:`\\vect{\\theta}`.
timeStamps : 2-d sequence of float
    Values of :math:`t`.
parameterDistribution : :class:`~openturns.Distribution`
    The distribution of :math:`\\vect{\\beta}`.
normalizationFunction : :class:`~openturns.LinearFunction`
    The normalization function :math:`t \\mapsto \\tau(t)`.
llh : float
    Maximum log-likelihood.

See also
--------
GeneralizedExtremeValueFactory"

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::getDistribution
"Accessor to the Parent distribution at a given time.

Parameters
----------
t : float
    Time value.

Returns
-------
distribution : :class:`~openturns.Distribution`
    The Parent distribution at time :math:`t`."

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::getTimeGrid
"Accessor to the time grid.

Returns
-------
timeGrid : :class:`~openturns.Sample`
    Timestamp values."

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::getParameterDistribution
"Accessor to the distribution of :math:`\\vect{\\beta}`.

Returns
-------
parameterDistribution : :class:`~openturns.Distribution`
    The distribution of the  estimator of :math:`\\vect{\\beta}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::setParameterDistribution
"Accessor to the distribution of of :math:`\\vect{\\beta}`.

Parameters
----------
parameterDistribution : :class:`~openturns.Distribution`
    The distribution of the estimator of :math:`\\vect{\\beta}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::getParameterFunction
"Parameter function accessor.

Returns
-------
parameterFunction : :class:`~openturns.Function`
    The  function :math:`t \\mapsto \\vect{\\theta}(t)`."

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::getNormalizationFunction
"Normalizing function accessor.

Returns
-------
normalizeFunction : :class:`~openturns.Function`
    The  function :math:`t \\mapsto \\tau(t)`."


// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::getOptimalParameter
"Optimal parameter accessor.

Returns
-------
optimalParameter : :class:`~openturns.Point`
    Optimal vector of parameters :math:`\\vect{\\beta}`.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::setLogLikelihood
"Optimal log-likelihood value accessor.

Parameters
----------
llh : float
    Maximum log-likelihood.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::getLogLikelihood
"Optimal log-likelihood value accessor.

Returns
-------
llh : float
    Maximum log-likelihood.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::drawParameterFunction
"Draw the parameter function.

Parameters
----------
parameterIndex : int, 
    The index :math:`j` specifying the marginal of :math:`\\vect{\\theta}`.

Returns
-------
graph : :class:`~openturns.Graph`
    Graph of :math:`\\theta_j(t)`.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::drawQuantileFunction
"Draw the quantile function.

The quantile function is the function :math:`t \\mapsto q_p(t)` where :math:`q_p(t)` is
the quantile of order :math:`p` of the Parent distribution at time :math:`t`.

Parameters
----------
p : float
    The quantile level.

Returns
-------
graph : :class:`~openturns.Graph`
    Quantile function graph."

// ---------------------------------------------------------------------

%feature("docstring") OT::TimeVaryingResult::drawDiagnosticPlot
"Draw the 4 usual diagnostic plots.

If :math:`Z_t` is a non stationary GEV model defined as follows:

.. math::

    Z_t \\sim \\mbox{GEV}(\\mu(t), \\sigma(t), \\xi(t))
    
then the standardized variables :math:`\\hat{Z}_t` defined by:

.. math::

    \\hat{Z}_t = \\dfrac{1}{\\xi(t)} \\log \\left[1+ \\xi(t)\\left( \\dfrac{Z_t-\\mu(t)}{\\sigma(t)} \\right)\\right]

have  the standard Gumbel distribution which is the GEV model with :math:`(\\mu, \\sigma, \\xi) = (0, 1, 0)`.

Then, the 4 diagnostic graphs are built from the transformed data compared to the Gumbel model: the *probability-probability* plot, the *quantile-quantile* plot, the *return level* plot, the data histogram with the Gumbel distribution.

If :math:`(\\hat{z}_{(1)}, \\dots, \\hat{z}_{(n)})` denotes the ordered block maximum transformed data, the graphs are defined as follows.

The *probability-probability* plot consists of the points:

.. math::
    \\left\\{ \\left( i/(n+1),\\exp (-\\exp (-\\hat{z}_{(i)})) \\right), i=1, \\dots , n\\right\\}


The *quantile-quantile* plot consists of the points:

.. math::
    \\left\\{  \\left(  \\hat{z}_{(i)},  -\\log(-\\log(i/(n+1)))  \\right), i=1, \\dots , n\\right\\} 

The *return level* plot consists of the points:

.. math::
    \\left\\{ \\left( m, \\hat{z}_m\\right),m> 0\\right\\}

and the points:

.. math::
    \\left\\{ \\left( m, \\hat{z}_{m}^{emp}\\right), m> 0\\right\\}

where :math:`\\hat{z}_{m}^{emp}` is the empirical :math:`m`-block return level of the transformed data and :math:`\\hat{z}_{m}` the 
:math:`m`-block return level of the Gumbel distribution.

Returns
-------
grid : :class:`~openturns.GridLayout`
    Returns a grid of 4 graphs:
     - the QQ-plot,
     - the PP-plot,
     - the return level graph (with confidence lines),
     - the density graph.
"
