%feature("docstring") OT::Logistic
"Logistic distribution.

Parameters
----------
mu : float
    Mean parameter :math:`\\mu`.
    
    Default value is 1.0.
beta : float, :math:`\\beta > 0`
    Scale parameter :math:`\\beta`.
    
    Default value is 1.0.

Notes
-----
Its probability density function is defined as:

.. math::

    f_X(x) = \\frac{\\exp\\left(\\left(- \\frac{x - \\mu}{\\beta}\\right)\\right)}
                  {\\beta \\left(1 + \\exp\\left(- \\frac{x-\\mu}{\\beta}
                                             \\right)\\right)^2},
             \\quad x \\in \\Rset

with :math:`\\mu \\in \\Rset` and :math:`\\beta > 0`.

Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & \\mu \\\\
        \\Var{X} & = & \\frac{1}{3} \\pi^2 \\beta^2
    \\end{eqnarray*}

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> distribution = ot.Logistic(0.0, 1.0)

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Logistic::getMu
"Accessor to the distribution's mean parameter :math:`\\mu`.

Returns
-------
mu : float
    Mean parameter :math:`\\mu`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Logistic::getBeta
"Accessor to the distribution's scale parameter :math:`\\beta`.

Returns
-------
beta : float
    Scale parameter :math:`\\beta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Logistic::setMu
"Accessor to the distribution's mean parameter :math:`\\mu`.

Parameters
----------
mu : float, :math:`\\mu \\in \\Rset`
    Mean parameter :math:`\\mu`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Logistic::setBeta
"Accessor to the distribution's scale parameter :math:`\\beta`.

Parameters
----------
beta : float, :math:`\\beta > 0`
    Scale parameter :math:`\\beta`."
