# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Internal data types."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _typ
else:
    import _typ

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _typ.delete_SwigPyIterator

    def value(self):
        return _typ.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _typ.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _typ.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _typ.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _typ.SwigPyIterator_equal(self, x)

    def copy(self):
        return _typ.SwigPyIterator_copy(self)

    def next(self):
        return _typ.SwigPyIterator_next(self)

    def __next__(self):
        return _typ.SwigPyIterator___next__(self)

    def previous(self):
        return _typ.SwigPyIterator_previous(self)

    def advance(self, n):
        return _typ.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _typ.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _typ.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _typ.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _typ.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _typ.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _typ.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _typ:
_typ.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.common
class UnsignedIntegerCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete_UnsignedIntegerCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.UnsignedIntegerCollection_clear(self)

    def __len__(self):
        return _typ.UnsignedIntegerCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.UnsignedIntegerCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.UnsignedIntegerCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ.UnsignedIntegerCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ.UnsignedIntegerCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.UnsignedIntegerCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.UnsignedIntegerCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.UnsignedIntegerCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.UnsignedIntegerCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.UnsignedIntegerCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.UnsignedIntegerCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.UnsignedIntegerCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ.UnsignedIntegerCollection_find(self, val)

    def __repr__(self):
        return _typ.UnsignedIntegerCollection___repr__(self)

    def __str__(self, *args):
        return _typ.UnsignedIntegerCollection___str__(self, *args)

    def __init__(self, *args):
        _typ.UnsignedIntegerCollection_swiginit(self, _typ.new_UnsignedIntegerCollection(*args))

# Register UnsignedIntegerCollection in _typ:
_typ.UnsignedIntegerCollection_swigregister(UnsignedIntegerCollection)
class _UnsignedIntegerPersistentCollection(openturns.common.PersistentObject, UnsignedIntegerCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._UnsignedIntegerPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _typ._UnsignedIntegerPersistentCollection_swiginit(self, _typ.new__UnsignedIntegerPersistentCollection(*args))

    def __repr__(self):
        return _typ._UnsignedIntegerPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ._UnsignedIntegerPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete__UnsignedIntegerPersistentCollection

# Register _UnsignedIntegerPersistentCollection in _typ:
_typ._UnsignedIntegerPersistentCollection_swigregister(_UnsignedIntegerPersistentCollection)
class _StringCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete__StringCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ._StringCollection_clear(self)

    def __len__(self):
        return _typ._StringCollection___len__(self)

    def __eq__(self, rhs):
        return _typ._StringCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ._StringCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ._StringCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ._StringCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ._StringCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ._StringCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ._StringCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ._StringCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ._StringCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ._StringCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ._StringCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ._StringCollection_find(self, val)

    def __repr__(self):
        return _typ._StringCollection___repr__(self)

    def __str__(self, *args):
        return _typ._StringCollection___str__(self, *args)

    def __init__(self, *args):
        _typ._StringCollection_swiginit(self, _typ.new__StringCollection(*args))

# Register _StringCollection in _typ:
_typ._StringCollection_swigregister(_StringCollection)
class _StringPersistentCollection(openturns.common.PersistentObject, _StringCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._StringPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _typ._StringPersistentCollection_swiginit(self, _typ.new__StringPersistentCollection(*args))

    def __repr__(self):
        return _typ._StringPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ._StringPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete__StringPersistentCollection

# Register _StringPersistentCollection in _typ:
_typ._StringPersistentCollection_swigregister(_StringPersistentCollection)
class Description(_StringPersistentCollection):
    r"""
    Collection of strings.

    Available constructors:
        Description(*size=0, value=' '*)

        Description(*sequence*)

    Parameters
    ----------
    size : int, :math:`size \geq 0`
        Size of the collection.
    value : str
        Value set to the *size* elements.
    sequence : sequence of str
        Components of the vector.

    Examples
    --------
    >>> import openturns as ot

    Use the first constructor:

    >>> ot.Description()
    []
    >>> ot.Description(2)
    [,]
    >>> ot.Description(2, 'C')
    [C,C]

    Use the second constructor:

    >>> vector = ot.Description(['P1', 'P2', 'P3'])
    >>> vector
    [P1,P2,P3]

    Use some functionalities:

    >>> vector[1] = 'P4'
    >>> vector
    [P1,P4,P3]
    >>> vector.add('P5')
    >>> vector
    [P1,P4,P3,P5]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Description_getClassName(self)

    def isBlank(self):
        r"""
        Check if the description is blank.

        Returns
        -------
        isBlank : bool
            *True* if all the components are empty.

        Examples
        --------
        >>> import openturns as ot
        >>> vector = ot.Description(3)
        >>> vector.isBlank()
        True
        >>> vector = ot.Description(['P1', 'P2', ' '])
        >>> vector.isBlank()
        False
        """
        return _typ.Description_isBlank(self)
    __swig_destroy__ = _typ.delete_Description

    def __repr__(self):
        return _typ.Description___repr__(self)

    def __str__(self, *args):
        return _typ.Description___str__(self, *args)

    def sort(self):
        return _typ.Description_sort(self)

    @staticmethod
    def BuildDefault(*args):
        r"""
        Build a default description.

        Parameters
        ----------
        size : int, :math:`size \geq 0`
            Size of the collection.
        value : str
            Prefixed label of the final labels. By default, it is equal to *Component*.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of dimension *size* built as: *value0, ..., valueN with N=size-1*.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.Description.BuildDefault(3)
        [Component0,Component1,Component2]
        >>> ot.Description.BuildDefault(3, 'C')
        [C0,C1,C2]
        """
        return _typ.Description_BuildDefault(*args)

    def __init__(self, *args):
        _typ.Description_swiginit(self, _typ.new_Description(*args))

    def __setitem__(self, arg, valObj):
        return _typ.Description___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ.Description___getitem__(self, arg)

    def __eq__(self, other):
        return _typ.Description___eq__(self, other)

    def __ne__(self, other):
        return _typ.Description___ne__(self, other)

# Register Description in _typ:
_typ.Description_swigregister(Description)
class PlatformInfo(object):
    r"""
    Informations about platform.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def GetVersion():
        r"""
        Accessor to the version string.

        Returns
        -------
        version : str
            Version string.
        """
        return _typ.PlatformInfo_GetVersion()

    @staticmethod
    def GetRevision():
        r"""
        Accessor to the revision string.

        Returns
        -------
        revision : str
            Git revision.
        """
        return _typ.PlatformInfo_GetRevision()

    @staticmethod
    def GetDate():
        r"""
        Accessor to the build date.

        Returns
        -------
        date : str
            Build date.
        """
        return _typ.PlatformInfo_GetDate()

    @staticmethod
    def GetInstallationDirectory():
        r"""
        Accessor to the install prefix.

        Returns
        -------
        prefix : str
            Installation prefix.
        """
        return _typ.PlatformInfo_GetInstallationDirectory()

    @staticmethod
    def GetNumericalPrecision():
        r"""
        Accessor to the output numerical precision.

        Returns
        -------
        precision : int
            String output numerical precision.
        """
        return _typ.PlatformInfo_GetNumericalPrecision()

    @staticmethod
    def SetNumericalPrecision(precision):
        r"""
        Accessor to the output numerical precision.

        Parameters
        ----------
        precision : int
            String output numerical precision.
        """
        return _typ.PlatformInfo_SetNumericalPrecision(precision)

    @staticmethod
    def GetFeatures():
        r"""
        Accessor to the features list.

        Returns
        -------
        features : :class:`~openturns.Description`
            Features list.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.PlatformInfo.GetFeatures())
        [bison,bonmin,...

        """
        return _typ.PlatformInfo_GetFeatures()

    @staticmethod
    def HasFeature(feature):
        r"""
        Test a feature's availability.

        Parameters
        ----------
        feature : str
            The desired feature, often associated to a software dependency,
            Call :meth:`GetFeatures` for the possible feature values.

        Returns
        -------
        has_feature : bool
            Whether the designated feature is available.

        Examples
        --------
        >>> import openturns as ot
        >>> have_xml_support = ot.PlatformInfo.HasFeature('libxml2')

        """
        return _typ.PlatformInfo_HasFeature(feature)
    __swig_destroy__ = _typ.delete_PlatformInfo

# Register PlatformInfo in _typ:
_typ.PlatformInfo_swigregister(PlatformInfo)
class Indices(_UnsignedIntegerPersistentCollection):
    r"""
    Collection of unsigned integers.

    Available constructors:
        Indices(*size=0, value=0*)

        Indices(*sequence*)

    Parameters
    ----------
    size : int, :math:`size \geq 0`
        Size of the collection.
    value : positive int
        Value set to the *size* elements.
    sequence : sequence of int
        Components of the vector.

    Examples
    --------
    >>> import openturns as ot

    Use the first constructor:

    >>> ot.Indices(3)
    [0,0,0]
    >>> ot.Indices(3, 4)
    [4,4,4]

    Use the second constructor:

    >>> vector = ot.Indices([100, 30, 70])
    >>> vector
    [100,30,70]

    Use some functionalities:

    >>> vector[1] = 20
    >>> vector
    [100,20,70]
    >>> vector.add(50)
    >>> vector
    [100,20,70,50]

    The `Indices` class has a method that can search for an
    element and return `True` if the element is in the indices, 
    and `False` otherwise.
    We can access to it using the `in` keyword.

    >>> indices = ot.Indices([3, 5, 7, 9])
    >>> print(0 in indices)
    False
    >>> print(3 in indices)
    True
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Indices_getClassName(self)

    def check(self, bound):
        r"""
        Check that no value is repeated and no value exceeds the given bound.

        Parameters
        ----------
        bound : positive int
            The bound value.

        Returns
        -------
        check : bool
            *True* if no value is repeated and all values are < bound.
        """
        return _typ.Indices_check(self, bound)

    def isIncreasing(self):
        r"""
        Check if the indices are increasing.

        Returns
        -------
        isIncreasing : bool
            *True* if the indices are increasing.

        Examples
        --------
        >>> import openturns as ot
        >>> indices = ot.Indices(3)
        >>> indices.fill()
        >>> indices.isIncreasing()
        True
        """
        return _typ.Indices_isIncreasing(self)

    def fill(self, initialValue=0, stepSize=1):
        r"""
        Fill the indices with a linear progression.

        Starting from the start value *initialValue* by step *stepSize*.

        Parameters
        ----------
        initialValue : positive int
            Initial value. By default it is equal to 0.
        stepSize : positive int
            Step size. By default it is equal to 1.

        Examples
        --------
        >>> import openturns as ot
        >>> indices = ot.Indices(3)
        >>> indices.fill()
        >>> print(indices)
        [0,1,2]
        >>> indices = ot.Indices(3)
        >>> indices.fill(2, 4)
        >>> print(indices)
        [2,6,10]
        """
        return _typ.Indices_fill(self, initialValue, stepSize)

    def complement(self, n):
        r"""
        Build the complement of the current indices wrt :math:`\{0,\dots,n-1\}`.

        Parameters
        ----------
        bound : positive int
            The value of :math:`n`.

        Returns
        -------
        complement : :class:`~openturns.Indices`
            The increasing collection of integers in :math:`\{0,\dots,n-1\}` not in the current indices.

        Examples
        --------
        >>> import openturns as ot
        >>> indices = ot.Indices([1, 3, 4])
        >>> print(indices.complement(7))
        [0,2,5,6]
        """
        return _typ.Indices_complement(self, n)

    def normInf(self):
        r"""
        Compute the infinite norm of the indices.

        Returns
        -------
        norm: int
            The maximum of the indices.

        Examples
        --------
        >>> import openturns as ot
        >>> indices = ot.Indices([3, 5, 7, 9])
        >>> print(indices.normInf())
        9
        """
        return _typ.Indices_normInf(self)

    def norm1(self):
        r"""
        Compute the 1-norm of the indices.

        Returns
        -------
        norm: int
            The sum of the indices.

        Examples
        --------
        >>> import openturns as ot
        >>> indices = ot.Indices([3, 5, 7, 9])
        >>> print(indices.norm1())
        24
        """
        return _typ.Indices_norm1(self)

    def __repr__(self):
        return _typ.Indices___repr__(self)

    def __str__(self, *args):
        return _typ.Indices___str__(self, *args)

    def __init__(self, *args):
        _typ.Indices_swiginit(self, _typ.new_Indices(*args))

    def __setitem__(self, arg, valObj):
        return _typ.Indices___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ.Indices___getitem__(self, arg)

    def __eq__(self, other):
        return _typ.Indices___eq__(self, other)

    def __ne__(self, other):
        return _typ.Indices___ne__(self, other)
    __swig_destroy__ = _typ.delete_Indices

# Register Indices in _typ:
_typ.Indices_swigregister(Indices)
class IndicesCollectionImplementation(openturns.common.PersistentObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.IndicesCollectionImplementation_getClassName(self)

    def __repr__(self):
        return _typ.IndicesCollectionImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.IndicesCollectionImplementation___str__(self, *args)

    def getSize(self):
        return _typ.IndicesCollectionImplementation_getSize(self)

    def getStride(self):
        return _typ.IndicesCollectionImplementation_getStride(self)

    def __eq__(self, *args):
        return _typ.IndicesCollectionImplementation___eq__(self, *args)

    def __ne__(self, *args):
        return _typ.IndicesCollectionImplementation___ne__(self, *args)

    def __getitem__(self, index):
        return _typ.IndicesCollectionImplementation___getitem__(self, index)

    def __setitem__(self, index, val):
        return _typ.IndicesCollectionImplementation___setitem__(self, index, val)

    def __len__(self):
        return _typ.IndicesCollectionImplementation___len__(self)

    def __init__(self, *args):
        _typ.IndicesCollectionImplementation_swiginit(self, _typ.new_IndicesCollectionImplementation(*args))
    __swig_destroy__ = _typ.delete_IndicesCollectionImplementation

# Register IndicesCollectionImplementation in _typ:
_typ.IndicesCollectionImplementation_swigregister(IndicesCollectionImplementation)
class _IndicesCollectionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _typ._IndicesCollectionImplementationTypedInterfaceObject_swiginit(self, _typ.new__IndicesCollectionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _typ._IndicesCollectionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._IndicesCollectionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._IndicesCollectionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _typ._IndicesCollectionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _typ._IndicesCollectionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _typ.delete__IndicesCollectionImplementationTypedInterfaceObject

# Register _IndicesCollectionImplementationTypedInterfaceObject in _typ:
_typ._IndicesCollectionImplementationTypedInterfaceObject_swigregister(_IndicesCollectionImplementationTypedInterfaceObject)
class IndicesCollection(_IndicesCollectionImplementationTypedInterfaceObject):
    r"""
    Fixed size collection of Indices.

    This class is a container for a fixed size list of Indices.
    Lists cannot be shrunk or extended, but values can be modified.

    Available constructors:
        IndicesCollection(*size, stride, indices*)

        IndicesCollection(*sequence*)

    Parameters
    ----------
    size : int
        Collection size.
    stride : int
        Size of each element
        Default creates an empty sample with dimension 1.
    values : :class:`~openturns.Indices` or flat (1d) array, list or tuple of int
        The point that will be repeated along the sample.
        Default creates a sample filled with zeros (null vectors).
    sequence : :class:`~openturns.IndicesCollection`
        Copy values from a collection of Indices.

    Examples
    --------
    Create a IndicesCollection

    >>> import openturns as ot
    >>> indices = list(range(12))
    >>> listIndices = ot.IndicesCollection(3, 4, indices)
    >>> print(listIndices)
    [[0,1,2,3],[4,5,6,7],[8,9,10,11]]

    Create a IndicesCollection from a (2d) array, list or tuple

    >>> import numpy as np
    >>> listIndices = ot.IndicesCollection(np.array([(1, 2), (3, 4), (5, 6)]))

    and back

    >>> indices = np.array(listIndices)

    Get an Indices.  Note that a copy is returned, modifying it does not alter original list.

    >>> first = listIndices[0]
    >>> first[0] = 0
    >>> print(first)
    [0,2]
    >>> print(listIndices)
    [[1,2],[3,4],[5,6]]

    To mdify values, one has to change the whole element.

    >>> listIndices[0] = [7, 8]
    >>> print(listIndices)
    [[7,8],[3,4],[5,6]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.IndicesCollection_getClassName(self)

    def __repr__(self):
        return _typ.IndicesCollection___repr__(self)

    def __str__(self, *args):
        return _typ.IndicesCollection___str__(self, *args)

    def getSize(self):
        r"""
        Accessor to the collection size.

        Returns
        -------
        m : int
            The number of :class:`~openturns.Indices` in the collection.
        """
        return _typ.IndicesCollection_getSize(self)

    def getStride(self):
        r"""
        Accessor to the indices size.

        Returns
        -------
        m : int
            The number of integers in each :class:`~openturns.Indices`.
        """
        return _typ.IndicesCollection_getStride(self)

    def __getitem__(self, index):
        return _typ.IndicesCollection___getitem__(self, index)

    def __setitem__(self, index, val):
        return _typ.IndicesCollection___setitem__(self, index, val)

    def __len__(self):
        return _typ.IndicesCollection___len__(self)

    def __init__(self, *args):
        _typ.IndicesCollection_swiginit(self, _typ.new_IndicesCollection(*args))
    __swig_destroy__ = _typ.delete_IndicesCollection

# Register IndicesCollection in _typ:
_typ.IndicesCollection_swigregister(IndicesCollection)
class ScalarCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete_ScalarCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.ScalarCollection_clear(self)

    def __len__(self):
        return _typ.ScalarCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.ScalarCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.ScalarCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ.ScalarCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ.ScalarCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.ScalarCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.ScalarCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.ScalarCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.ScalarCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.ScalarCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.ScalarCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.ScalarCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ.ScalarCollection_find(self, val)

    def __repr__(self):
        return _typ.ScalarCollection___repr__(self)

    def __str__(self, *args):
        return _typ.ScalarCollection___str__(self, *args)

    def __init__(self, *args):
        _typ.ScalarCollection_swiginit(self, _typ.new_ScalarCollection(*args))

# Register ScalarCollection in _typ:
_typ.ScalarCollection_swigregister(ScalarCollection)
class _ScalarPersistentCollection(openturns.common.PersistentObject, ScalarCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._ScalarPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _typ._ScalarPersistentCollection_swiginit(self, _typ.new__ScalarPersistentCollection(*args))

    def __repr__(self):
        return _typ._ScalarPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ._ScalarPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete__ScalarPersistentCollection

# Register _ScalarPersistentCollection in _typ:
_typ._ScalarPersistentCollection_swigregister(_ScalarPersistentCollection)
class PointCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete_PointCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.PointCollection_clear(self)

    def __len__(self):
        return _typ.PointCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.PointCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.PointCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ.PointCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ.PointCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.PointCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.PointCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.PointCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.PointCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.PointCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.PointCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.PointCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ.PointCollection_find(self, val)

    def __repr__(self):
        return _typ.PointCollection___repr__(self)

    def __str__(self, *args):
        return _typ.PointCollection___str__(self, *args)

    def __init__(self, *args):
        _typ.PointCollection_swiginit(self, _typ.new_PointCollection(*args))

# Register PointCollection in _typ:
_typ.PointCollection_swigregister(PointCollection)
class _PointPersistentCollection(openturns.common.PersistentObject, PointCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._PointPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _typ._PointPersistentCollection_swiginit(self, _typ.new__PointPersistentCollection(*args))

    def __repr__(self):
        return _typ._PointPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ._PointPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete__PointPersistentCollection

# Register _PointPersistentCollection in _typ:
_typ._PointPersistentCollection_swigregister(_PointPersistentCollection)
OT_TYPECHECK_NUMERICALPOINT = _typ.OT_TYPECHECK_NUMERICALPOINT
class Point(_ScalarPersistentCollection):
    r"""
    Real vector.

    Parameters
    ----------
    dimension : int, :math:`n > 0`, optional
        The number of components.
    value : float, optional
        The components value.
        Default creates a null vector.

    Examples
    --------
    Create a Point

    >>> import openturns as ot
    >>> x = ot.Point(3, 1.0)
    >>> x
    class=Point name=Unnamed dimension=3 values=[1,1,1]

    Get or set terms

    >>> print(x[0])
    1.0
    >>> x[0] = 0.0
    >>> print(x[0])
    0.0
    >>> print(x[:2])
    [0,1]

    Create a Point from a flat (1d) array, list or tuple

    >>> import numpy as np
    >>> y = ot.Point((0.0, 1.0, 2.0))
    >>> y = ot.Point(range(3))
    >>> y = ot.Point(np.arange(3))

    and back

    >>> z = np.array(y)

    Addition, subtraction (with compatible dimensions)

    >>> print(x + y)
    [0,2,3]
    >>> print(x - y)
    [0,0,-1]

    Multiplication, division with a scalar

    >>> print(x * 3.0)
    [0,3,3]
    >>> print(x / 3.0)
    [0,0.333333,0.333333]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Point_getClassName(self)

    def __repr__(self):
        return _typ.Point___repr__(self)

    def __str__(self, *args):
        return _typ.Point___str__(self, *args)

    def clean(self, threshold):
        return _typ.Point_clean(self, threshold)

    def isIncreasing(self):
        r"""
        Check if the components are in increasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.isIncreasing()
        True
        >>> x = ot.Point([1.0, 1.0, 3.0])
        >>> x.isIncreasing()
        False
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isIncreasing()
        False
        """
        return _typ.Point_isIncreasing(self)

    def isNonDecreasing(self):
        r"""
        Check if the components are in nondecreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.isNonDecreasing()
        True
        >>> x = ot.Point([1.0, 1.0, 3.0])
        >>> x.isNonDecreasing()
        True
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isNonDecreasing()
        False
        """
        return _typ.Point_isNonDecreasing(self)

    def isDecreasing(self):
        r"""
        Check if the components are in decreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([3.0, 2.0, 1.0])
        >>> x.isDecreasing()
        True
        >>> x = ot.Point([3.0, 3.0, 1.0])
        >>> x.isDecreasing()
        False
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isIncreasing()
        False
        """
        return _typ.Point_isDecreasing(self)

    def isNonIncreasing(self):
        r"""
        Check if the components are in nonincreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([3.0, 2.0, 1.0])
        >>> x.isNonIncreasing()
        True
        >>> x = ot.Point([3.0, 3.0, 1.0])
        >>> x.isNonIncreasing()
        True
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isNonIncreasing()
        False
        """
        return _typ.Point_isNonIncreasing(self)

    def isMonotonic(self):
        r"""
        Check if the components are in nonincreasing or nondecreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.isMonotonic()
        True
        >>> x = ot.Point([2.0, 2.0, 1.0])
        >>> x.isMonotonic()
        True
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isMonotonic()
        False
        """
        return _typ.Point_isMonotonic(self)

    def getDimension(self):
        r"""
        Accessor to the vector's dimension.

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ.Point_getDimension(self)

    def getSize(self):
        r"""
        Accessor to the vector's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ.Point_getSize(self)

    def __imul__(self, scalar):
        return _typ.Point___imul__(self, scalar)

    def __itruediv__(self, *args):
        return _typ.Point___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def norm(self):
        r"""
        Compute the Euclidean (:math:`L^2`) norm.

        The Euclidean (:math:`L^2`) norm of a vector is defined as:

        .. math::

            \norm{\vect{x}} = \norm{\vect{x}}_2
                            = \sqrt{\sum_{i=1}^n x_i^2}

        Returns
        -------
        norm : float
            The vector's Euclidean norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm()
        3.741657...
        """
        return _typ.Point_norm(self)

    def norm1(self):
        r"""
        Compute the :math:`L^1` norm.

        The :math:`L^1` norm of a vector is defined as:

        .. math::

            \norm{\vect{x}}_1 = \sum_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^1` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm1()
        6.0
        """
        return _typ.Point_norm1(self)

    def normInf(self):
        r"""
        Compute the :math:`L^{\inf}` norm.

        The :math:`L^{\inf}` norm of a vector is defined as:

        .. math::

            \norm{\vect{x}}_{\inf} = \max_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^{\inf}` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normInf()
        3.0
        """
        return _typ.Point_normInf(self)

    def normSquare(self):
        r"""
        Compute the squared Euclidean norm.

        Returns
        -------
        norm : float
            The vector's squared Euclidean norm.

        See Also
        --------
        norm

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normSquare()
        14.0
        """
        return _typ.Point_normSquare(self)

    def normalize(self):
        r"""
        Compute the normalized vector with respect to its Euclidean norm.

        Returns
        -------
        normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its Euclidean norm.

        See Also
        --------
        norm

        Raises
        ------
        RuntimeError : If the Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalize())
        [0.267261,0.534522,0.801784]
        """
        return _typ.Point_normalize(self)

    def normalizeSquare(self):
        r"""
        Compute the normalized vector with respect to its squared Euclidean norm.

        Returns
        -------
        normalized_vector : normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its squared Euclidean norm.

        See Also
        --------
        normSquare

        Raises
        ------
        RuntimeError : If the squared Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalizeSquare())
        [0.0714286,0.285714,0.642857]
        """
        return _typ.Point_normalizeSquare(self)

    def dot(self, rhs):
        r"""
        Compute the scalar product.

        Parameters
        ----------
        point : sequence of float
            Scalar product second argument

        Returns
        -------
        dot : float
            Scalar product

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> prod = x.dot([4, 5, 6])
        """
        return _typ.Point_dot(self, rhs)

    def __init__(self, *args):
        _typ.Point_swiginit(self, _typ.new_Point(*args))

    def __setitem__(self, arg, valObj):
        return _typ.Point___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ.Point___getitem__(self, arg)

    def __eq__(self, other):
        return _typ.Point___eq__(self, other)

    def __ne__(self, other):
        return _typ.Point___ne__(self, other)

    def __radd__(self, s):
        return _typ.Point___radd__(self, s)

    def __add__(self, other):
        return _typ.Point___add__(self, other)

    def __sub__(self, other):
        return _typ.Point___sub__(self, other)

    def __mul__(self, s):
        return _typ.Point___mul__(self, s)

    def __rmul__(self, s):
        return _typ.Point___rmul__(self, s)

    def __div__(self, s):
        return _typ.Point___div__(self, s)

    def __truediv__(self, s):
        return _typ.Point___truediv__(self, s)

    def __iadd__(self, other):
        return _typ.Point___iadd__(self, other)

    def __isub__(self, other):
        return _typ.Point___isub__(self, other)

    def __neg__(self):
        return _typ.Point___neg__(self)
    __swig_destroy__ = _typ.delete_Point

# Register Point in _typ:
_typ.Point_swigregister(Point)
class PointWithDescription(Point):
    r"""
    Collection of real values with a description for each component.

    Available constructors:
        PointWithDescription(*size=0, value=0.0*)

        PointWithDescription(*sequence*)

    Parameters
    ----------
    size : int, :math:`size \geq 0`
        Size of the vector.
    value : float
        Value set to the *size* elements.
    sequence : sequence of pair (string, float)
        Components of the vector.

    Examples
    --------
    >>> import openturns as ot

    Use the first constructor:

    >>> print(ot.PointWithDescription(2))
    [ : 0,  : 0]
    >>> vector = ot.PointWithDescription(2, 3.0)
    >>> print(vector)
    [ : 3,  : 3]
    >>> vector.setDescription(['c1', 'c2'])
    >>> print(vector)
    [c1 : 3, c2 : 3]

    Use the second constructor:

    >>> vector = ot.PointWithDescription([('C1', 2.0), ('C2', 3.0), ('C3', 4.5)])
    >>> print(vector)
    [C1 : 2, C2 : 3, C3 : 4.5]
    >>> print(vector.getDescription())
    [C1,C2,C3]

    Use some functionalities:

    >>> vector[1] = 7.1
    >>> print(vector)
    [C1 : 2, C2 : 7.1, C3 : 4.5]
    >>> vector.add(6.2)
    >>> print(vector)
    [C1 : 2, C2 : 7.1, C3 : 4.5,  : 6.2]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.PointWithDescription_getClassName(self)

    def setDescription(self, description):
        r"""
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components.
        """
        return _typ.PointWithDescription_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the components.

        See Also
        --------
        setDescription
        """
        return _typ.PointWithDescription_getDescription(self)

    def __repr__(self):
        return _typ.PointWithDescription___repr__(self)

    def __str__(self, *args):
        return _typ.PointWithDescription___str__(self, *args)

    def __init__(self, *args):
        _typ.PointWithDescription_swiginit(self, _typ.new_PointWithDescription(*args))
    __swig_destroy__ = _typ.delete_PointWithDescription

# Register PointWithDescription in _typ:
_typ.PointWithDescription_swigregister(PointWithDescription)
class _PointWithDescriptionCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete__PointWithDescriptionCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ._PointWithDescriptionCollection_clear(self)

    def __len__(self):
        return _typ._PointWithDescriptionCollection___len__(self)

    def __eq__(self, rhs):
        return _typ._PointWithDescriptionCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ._PointWithDescriptionCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ._PointWithDescriptionCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ._PointWithDescriptionCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ._PointWithDescriptionCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ._PointWithDescriptionCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ._PointWithDescriptionCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ._PointWithDescriptionCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ._PointWithDescriptionCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ._PointWithDescriptionCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ._PointWithDescriptionCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ._PointWithDescriptionCollection_find(self, val)

    def __repr__(self):
        return _typ._PointWithDescriptionCollection___repr__(self)

    def __str__(self, *args):
        return _typ._PointWithDescriptionCollection___str__(self, *args)

    def __init__(self, *args):
        _typ._PointWithDescriptionCollection_swiginit(self, _typ.new__PointWithDescriptionCollection(*args))

# Register _PointWithDescriptionCollection in _typ:
_typ._PointWithDescriptionCollection_swigregister(_PointWithDescriptionCollection)
class _PointWithDescriptionPersistentCollection(openturns.common.PersistentObject, _PointWithDescriptionCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._PointWithDescriptionPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _typ._PointWithDescriptionPersistentCollection_swiginit(self, _typ.new__PointWithDescriptionPersistentCollection(*args))

    def __repr__(self):
        return _typ._PointWithDescriptionPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ._PointWithDescriptionPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete__PointWithDescriptionPersistentCollection

# Register _PointWithDescriptionPersistentCollection in _typ:
_typ._PointWithDescriptionPersistentCollection_swigregister(_PointWithDescriptionPersistentCollection)
class _MatrixImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _typ._MatrixImplementationTypedInterfaceObject_swiginit(self, _typ.new__MatrixImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _typ._MatrixImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._MatrixImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._MatrixImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _typ._MatrixImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _typ._MatrixImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _typ.delete__MatrixImplementationTypedInterfaceObject

# Register _MatrixImplementationTypedInterfaceObject in _typ:
_typ._MatrixImplementationTypedInterfaceObject_swigregister(_MatrixImplementationTypedInterfaceObject)
class Matrix(_MatrixImplementationTypedInterfaceObject):
    r"""
    Real rectangular matrix.

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`, optional
        Number of rows.
        Default is 1.
    n_columns : int, :math:`n_c > 0`, optional
        Number of columns.
        Default is 1.
    values : sequence of float with size :math:`n_r \times n_c`, optional
        Values. **column-major** ordering is used (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.Matrix(2, 2, range(2 * 2))
    >>> print(M)
    [[ 0 2 ]
     [ 1 3 ]]

    Get or set terms

    >>> print(M[0, 0])
    0.0
    >>> M[0, 0] = 1.
    >>> print(M[0, 0])
    1.0
    >>> print(M[:, 0])
    [[ 1 ]
     [ 1 ]]

    Create an openturns matrix from a numpy 2d-array (or matrix, or 2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0, 3.0], [4.0, 5.0, 6.0]])
    >>> ot_matrix = ot.Matrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)

    Basic linear algebra operations (provided the dimensions are compatible)

    >>> A = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
    >>> B = ot.Matrix(np.eye(2))
    >>> C = ot.Matrix(3, 2, [1.] * 3 * 2)
    >>> print(A * B - C)
    [[ 0 1 ]
     [ 2 3 ]
     [ 4 5 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Matrix_getClassName(self)

    def clean(self, threshold):
        r"""
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_matrix : :class:`~openturns.Matrix`
            Input matrix with elements smaller than the threshold set to zero.
        """
        return _typ.Matrix_clean(self, threshold)

    def __repr__(self):
        return _typ.Matrix___repr__(self)

    def __str__(self, *args):
        return _typ.Matrix___str__(self, *args)

    def getNbRows(self):
        r"""
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.Matrix_getNbRows(self)

    def getNbColumns(self):
        r"""
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.Matrix_getNbColumns(self)

    def transpose(self):
        r"""
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.Matrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]
         [ 5 6 ]]
        >>> print(M.transpose())
        [[ 1 3 5 ]
         [ 2 4 6 ]]
        """
        return _typ.Matrix_transpose(self)

    def reshape(self, newRowDim, newColDim):
        r"""
        Reshape the matrix.

        Parameters
        ----------
        newRowDim : int
            The row dimension of the reshaped matrix.
        newColDim : int
            The column dimension of the reshaped matrix.

        Returns
        -------
        MT : :class:`~openturns.Matrix`
            The reshaped matrix.

        Notes
        -----
        If the size of the reshaped matrix is smaller than the size of the matrix to be
        reshaped, only the :math:`newRowDim\times newColDim` first elements are kept (in
        a column-major storage sense). If the size is greater, the new elements are set
        to zero.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]
         [ 5 6 ]]
        >>> print(M.reshape(1, 6))
        1x6
        [[ 1 3 5 2 4 6 ]]
        >>> print(M.reshape(2, 2))
        [[ 1 5 ]
         [ 3 2 ]]
        >>> print(M.reshape(2, 6))
        2x6
        [[ 1 5 4 0 0 0 ]
         [ 3 2 6 0 0 0 ]]
        """
        return _typ.Matrix_reshape(self, newRowDim, newColDim)

    def reshapeInPlace(self, newRowDim, newColDim):
        r"""
        Reshape the matrix, in place.

        Parameters
        ----------
        newRowDim : int
            The row dimension of the reshaped matrix.
        newColDim : int
            The column dimension of the reshaped matrix.

        Notes
        -----
        If the size of the reshaped matrix is smaller than the size of the matrix to be
        reshaped, only the :math:`newRowDim\times newColDim` first elements are kept (in
        a column-major storage sense). If the size is greater, the new elements are set
        to zero. If the size is unchanged, no copy of data is done.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]
         [ 5 6 ]]
        >>> M.reshapeInPlace(1, 6)
        >>> print(M)
        1x6
        [[ 1 3 5 2 4 6 ]]
        >>> M.reshapeInPlace(2, 2)
        >>> print(M)
        [[ 1 5 ]
         [ 3 2 ]]
        >>> M.reshapeInPlace(2, 6)
        >>> print(M)
        2x6
        [[ 1 5 0 0 0 0 ]
         [ 3 2 0 0 0 0 ]]
        """
        return _typ.Matrix_reshapeInPlace(self, newRowDim, newColDim)

    def __add__(self, *args):
        return _typ.Matrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.Matrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.Matrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.Matrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystemInPlace(self, *args):
        r"""
        Solve a rectangular linear system whose the present matrix is the operator.

        Similar to :meth:`solveLinearSystem` except the matrix is modified in-place
        during the resolution avoiding the need to allocate an extra copy if the
        original copy is not re-used.

        """
        return _typ.Matrix_solveLinearSystemInPlace(self, *args)

    def solveLinearSystem(self, *args):
        r"""
        Solve a rectangular linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : :class:`~openturns.Point` or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the rectangular linear system.

        Notes
        -----

        This will handle both matrices and vectors, as well as underdetermined, square
        or overdetermined linear systems although you'd better type explicitly your
        matrix if it has some properties that could simplify the resolution (see
        :class:`~openturns.TriangularMatrix`, :class:`~openturns.SquareMatrix`).

        This uses LAPACK's `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_.
        The `RCOND` parameter of this routine can be changed through the `MatrixImplementation-DefaultSmallPivot`
        key of the :class:`~openturns.ResourceMap`.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> b = ot.Point([1.0] * 3)
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.Matrix_solveLinearSystem(self, *args)

    def computeSingularValues(self, keepIntact=True):
        r"""
        Compute the singular values.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitly stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \times n_c` matrix
            :math:`\mat{\Sigma}` of the SVD decomposition.

        See also
        --------
        computeSVD

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M.computeSingularValues(True))
        [9.52552,0.514301]
        """
        return _typ.Matrix_computeSingularValues(self, keepIntact)

    def computeSVD(self, fullSVD=False, keepIntact=True):
        r"""
        Compute the singular values decomposition (SVD).

        The singular values decomposition of a rectangular matrix :math:`\mat{M}` with
        size :math:`n_r > n_c` reads:

        .. math::

            \mat{M} = \mat{U} \mat{\Sigma} \Tr{\mat{V}}

        where :math:`\mat{U}` is an :math:`n_r \times n_r` orthogonal matrix,
        :math:`\mat{\Sigma}` is an :math:`n_r \times n_c` diagonal matrix and
        :math:`\mat{V}` is an :math:`n_c \times n_c` orthogonal matrix.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitly stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \times n_c` matrix
            :math:`\mat{\Sigma}` of the SVD.
        U : :class:`~openturns.SquareMatrix`
            The left orthogonal matrix of the SVD.
        VT : :class:`~openturns.SquareMatrix`
            The transposed right orthogonal matrix of the SVD.

        Notes
        -----
        This uses LAPACK's `DGESDD <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesdd.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> singular_values, U, VT = M.computeSVD(True)
        >>> Sigma = ot.Matrix(M.getNbRows(), M.getNbColumns())
        >>> for i in range(singular_values.getSize()):
        ...     Sigma[i, i] = singular_values[i]
        >>> np.testing.assert_array_almost_equal(U * Sigma * VT, M)
        """
        return _typ.Matrix_computeSVD(self, fullSVD, keepIntact)

    def computeQR(self, fullQR=False, keepIntact=True):
        r"""
        Compute the QR factorization. By default, it is the *economic* decomposition which is computed.

        The economic QR factorization of a rectangular matrix :math:`\mat{M}` with
        :math:`n_r \geq n_c` (more rows than columns) is defined as follows:

        .. math::

            \mat{M} = \mat{Q} \mat{R}
                    = \mat{Q} \begin{bmatrix} \mat{R_1} \\ \mat{0} \end{bmatrix}
                    = \begin{bmatrix} \mat{Q_1}, \mat{Q_2} \end{bmatrix}
                      \begin{bmatrix} \mat{R_1} \\ \mat{0} \end{bmatrix}
                    = \mat{Q_1} \mat{R_1}

        where :math:`\mat{R_1}` is an :math:`n_c \times n_c` upper triangular matrix,
        :math:`\mat{Q_1}` is :math:`n_r \times n_c`, :math:`\mat{Q_2}` is
        :math:`n_r \times (n_r - n_c)`, and :math:`\mat{Q_1}` and :math:`\mat{Q_2}`
        both have orthogonal columns.

        Parameters
        ----------
        full_qr : bool, optional
            A flag telling whether `Q`, `R` or `Q1`, `R1` are returned.
            Default is *False* and returns `Q1`, `R1`.
        keep_intact : bool, optional
            A flag telling whether the present matrix is preserved or not in the computation of the decomposition.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        Q1 : :class:`~openturns.Matrix`
            The orthogonal matrix of the economic QR factorization.
        R1 : :class:`~openturns.TriangularMatrix`
            The right (upper) triangular matrix of the economic QR factorization.
        Q : :class:`~openturns.Matrix`
            The orthogonal matrix of the full QR factorization.
        R : :class:`~openturns.TriangularMatrix`
            The right (upper) triangular matrix of the full QR factorization.

        Notes
        -----
        The economic QR factorization is often used for solving overdetermined linear
        systems (where the operator :math:`\mat{M}` has :math:`n_r \geq n_c`) in the
        least-square sense because it implies solving a (simple) triangular system:

        .. math::

            \vect{\hat{x}} = \arg\min\limits_{\vect{x} \in \Rset^{n_r}} \|\mat{M} \vect{x} - \vect{b}\|
                           = \mat{R_1}^{-1} (\Tr{\mat{Q_1}} \vect{b})

        This uses LAPACK's `DGEQRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dgeqrf.f.html>`_
        and `DORGQR <http://www.netlib.org/lapack/lapack-3.1.1/html/dorgqr.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> Q1, R1 = M.computeQR()
        >>> np.testing.assert_array_almost_equal(Q1 * R1, M)
        """
        return _typ.Matrix_computeQR(self, fullQR, keepIntact)

    def computeGram(self, transpose=True):
        r"""
        Compute the associated Gram matrix.

        Parameters
        ----------
        transposed : bool
            Tells if matrix is to be transposed or not.
            Default value is True

        Returns
        -------
        MMT : :class:`~openturns.Matrix`
            The Gram matrix.

        Notes
        -----
        When transposed is set to `True`, the method computes :math:`cM^t \times \cM`.
        Otherwise it computes :math:`\cM \ times \cM^t`

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> MtM = M.computeGram()
        >>> print(MtM)
        [[ 35 44 ]
         [ 44 56 ]]
        >>> MMt = M.computeGram(False)
        >>> print(MMt)
        [[  5 11 17 ]
         [ 11 25 39 ]
         [ 17 39 61 ]]
        """
        return _typ.Matrix_computeGram(self, transpose)

    def __eq__(self, *args):
        return _typ.Matrix___eq__(self, *args)

    def isEmpty(self):
        r"""
        Tell if the matrix is empty.

        Returns
        -------
        is_empty : bool
            True if the matrix contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[]])
        >>> M.isEmpty()
        True
        """
        return _typ.Matrix_isEmpty(self)

    def __baseaddress__(self):
        return _typ.Matrix___baseaddress__(self)

    def __elementsize__(self):
        return _typ.Matrix___elementsize__(self)

    def __stride__(self, dim):
        return _typ.Matrix___stride__(self, dim)

    def getDiagonal(self, k=0):
        r"""
        Get the k-th diagonal of the matrix.

        Parameters
        ----------
        k : int
            The k-th diagonal to extract
            Default value is 0

        Returns
        -------
        D: :class:`~openturns.Matrix`
            The k-th diagonal.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0, 3.0], [4.0, 5.0, 6.0], [7.0, 8.0, 9.0]])
        >>> diag = M.getDiagonal()
        >>> print(diag)
        [[ 1 ]
         [ 5 ]
         [ 9 ]]
        >>> print(M.getDiagonal(1))
        [[ 2 ]
         [ 6 ]]
        """
        return _typ.Matrix_getDiagonal(self, k)

    def getDiagonalAsPoint(self, k=0):
        r"""
        Get the k-th diagonal of the matrix.

        Parameters
        ----------
        k : int
            The k-th diagonal to extract
            Default value is 0

        Returns
        -------
        pt : :class:`~openturns.Point`
            The k-th digonal.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0, 3.0], [4.0, 5.0, 6.0], [7.0, 8.0, 9.0]])
        >>> pt = M.getDiagonalAsPoint()
        >>> print(pt)
        [1,5,9]

        """
        return _typ.Matrix_getDiagonalAsPoint(self, k)

    def setDiagonal(self, *args):
        r"""
        Set the k-th diagonal of the matrix.

        Parameters
        ----------
        diag : :class:`~openturns.Point` or :class:`~openturns.Matrix` or a float
            Value(s) used to fill the diagonal of the matrix

        k : int
            The k-th diagonal to fill
            Default value is 0

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0, 3.0], [4.0, 5.0, 6.0], [7.0, 8.0, 9.0]])
        >>> M.setDiagonal([-1, 23, 9])
        >>> print(M)
        [[ -1  2  3 ]
         [  4 23  6 ]
         [  7  8  9 ]]
        >>> M.setDiagonal(1.0)
        >>> print(M)
        [[ 1 2 3 ]
         [ 4 1 6 ]
         [ 7 8 1 ]]
        >>> M.setDiagonal([2, 6, 9])
        >>> print(M)
        [[ 2 2 3 ]
         [ 4 6 6 ]
         [ 7 8 9 ]]
        """
        return _typ.Matrix_setDiagonal(self, *args)

    def computeHadamardProduct(self, other):
        r"""
        Compute the Hadamard product matrix.

        Parameters
        ----------
        Mat : :class:`~openturns.Matrix`
            The right hand matrix

        Returns
        -------
        C : :class:`~openturns.Matrix`
            The Hadamard product matrix.

        Notes
        -----

        The matrix :math:`\cC` resulting from the Hadamard product of the matrices
        :math:`\cA` and :`\cB` is as follows:

        .. math::

            \cC_{i,j} = \cA_{i,j} * \cB_{i,j}

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.Matrix([[1.0, 2.0], [3.0, 4.0]])
        >>> B = ot.Matrix([[1.0, 2.0], [3.0, 4.0]])
        >>> C = A.computeHadamardProduct(B)
        >>> print(C)
        [[  1  4 ]
         [  9 16 ]]
        >>> print(B.computeHadamardProduct(A))
        [[  1  4 ]
         [  9 16 ]]
        """
        return _typ.Matrix_computeHadamardProduct(self, other)

    def computeSumElements(self):
        r"""
        Compute the sum of the matrix elements.

        Returns
        -------
        sum : a float
            The sum of the elements.

        Notes
        -----

        We compute here the sum of elements of the matrix :math:`\cM`, that defines as:

        .. math::

            s = \sum_{i=1}^{nRows}\sum_{j=1}^{nColumns} \cM_{i,j}

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> s = M.computeSumElements()
        >>> print(s)
        21.0
        """
        return _typ.Matrix_computeSumElements(self)

    def squareElements(self):
        r"""
        Square the Matrix, ie each element of the matrix is squared.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> M.squareElements()
        >>> print(M)
        [[  1  4 ]
         [  9 16 ]
         [ 25 36 ]]
        """
        return _typ.Matrix_squareElements(self)

    def __init__(self, *args):
        _typ.Matrix_swiginit(self, _typ.new_Matrix(*args))

    def __getitem__(self, args):
        return _typ.Matrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.Matrix___setitem__(self, args, valObj)

    def __rmul__(self, s):
        return _typ.Matrix___rmul__(self, s)

    def __matmul__(self, other):
        return _typ.Matrix___matmul__(self, other)

    def __neg__(self):
        return _typ.Matrix___neg__(self)
    __swig_destroy__ = _typ.delete_Matrix

# Register Matrix in _typ:
_typ.Matrix_swigregister(Matrix)

# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the Matrix (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def Matrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns()),
                                                'typestr': "|f" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__() or 1), True),
                                                'strides': (self.__stride__(0), self.__stride__(1)),
                                                'version': 3,
                                                }
    return super(Matrix, self).__getattribute__(name)
Matrix.__getattribute__ = Matrix___getattribute__

class SquareMatrix(Matrix):
    r"""
    Real square matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of float with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.SquareMatrix(2, range(2 * 2))
    >>> print(M)
    [[ 0 2 ]
     [ 1 3 ]]

    Get or set terms

    >>> print(M[0, 0])
    0.0
    >>> M[0, 0] = 1.0
    >>> print(M[0, 0])
    1.0
    >>> print(M[:, 0])
    [[ 1 ]
     [ 1 ]]

    Create an openturns matrix from a **square** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0], [3.0, 4.0]])
    >>> ot_matrix = ot.SquareMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)

    Basic linear algebra operations (provided the dimensions are compatible)

    >>> A = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
    >>> B = ot.SquareMatrix(np.eye(2))
    >>> C = ot.Matrix(3, 2, [1.0] * 3 * 2)
    >>> print(A * B - C)
    [[ 0 1 ]
     [ 2 3 ]
     [ 4 5 ]]
    >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
    >>> print(A ** 2)
    [[  7 10 ]
     [ 15 22 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SquareMatrix_getClassName(self)

    def __repr__(self):
        return _typ.SquareMatrix___repr__(self)

    def getDimension(self):
        r"""
        Accessor to the dimension (the number of rows).

        Returns
        -------
        dimension : int
        """
        return _typ.SquareMatrix_getDimension(self)

    def transpose(self):
        r"""
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.SquareMatrix_transpose(self)

    def __add__(self, *args):
        return _typ.SquareMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SquareMatrix___sub__(self, *args)

    def __pow__(self, n):
        return _typ.SquareMatrix___pow__(self, n)

    def __mul__(self, *args):
        return _typ.SquareMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SquareMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystemInPlace(self, *args):
        r"""
        Solve a rectangular linear system whose the present matrix is the operator.

        Similar to :meth:`solveLinearSystem` except the matrix is modified in-place
        during the resolution avoiding the need to allocate an extra copy if the
        original copy is not re-used.

        """
        return _typ.SquareMatrix_solveLinearSystemInPlace(self, *args)

    def solveLinearSystem(self, *args):
        r"""
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitly the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = [1.0] * 2
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.SquareMatrix_solveLinearSystem(self, *args)

    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        r"""
        Compute the logarithm of the absolute value of the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The logarithm of the absolute value of the square matrix determinant.
        sign : float
            The sign of the determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeLogAbsoluteDeterminant()
        [0.693147..., -1.0]
        """
        return _typ.SquareMatrix_computeLogAbsoluteDeterminant(self, keepIntact)

    def computeDeterminant(self, keepIntact=True):
        r"""
        Compute the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The square matrix determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeDeterminant()
        -2.0
        """
        return _typ.SquareMatrix_computeDeterminant(self, keepIntact)

    def computeTrace(self):
        r"""
        Compute the trace of the matrix.

        Returns
        -------
        trace : float
            The trace of the matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> M.computeTrace()
        5.0
        """
        return _typ.SquareMatrix_computeTrace(self)

    def computeEigenValues(self, keepIntact=True):
        r"""
        Compute eigenvalues.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.ComplexCollection`
            Eigenvalues.

        See Also
        --------
        computeEV

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> M.computeEigenValues()
        [(-0.372281,0),(5.37228,0)]
        """
        return _typ.SquareMatrix_computeEigenValues(self, keepIntact)

    def computeEV(self, keepIntact=True):
        r"""
        Compute the eigenvalues decomposition (EVD).

        The eigenvalues decomposition of a square matrix :math:`\mat{M}` with
        size :math:`n` reads:

        .. math::

            \mat{M} = \mat{\Phi} \mat{\Lambda} \mat{\Phi}^{-1}

        where :math:`\mat{\Lambda}` is an :math:`n \times n` diagonal matrix and
        :math:`\mat{\Phi}` is an :math:`n \times n` orthogonal matrix.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigen_values : :class:`~openturns.ComplexCollection`
            The vector of eigenvalues with size :math:`n` that form the diagonal of
            the :math:`n \times n` matrix :math:`\mat{\Lambda}` of the EVD.
        Phi : :class:`~openturns.SquareComplexMatrix`
            The left matrix of the EVD.

        Notes
        -----
        This uses LAPACK'S `DGEEV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgeev.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> eigen_values, Phi = M.computeEV()
        >>> Lambda = ot.SquareComplexMatrix(M.getDimension())
        >>> for i in range(eigen_values.getSize()):
        ...     Lambda[i, i] = eigen_values[i]
        >>> # from scipy.linalg import inv # SquareComplexMatrix does not implement solveLinearSystem
        >>> # Phi, Lambda = np.matrix(Phi), np.matrix(Lambda)
        >>> # np.testing.assert_array_almost_equal(Phi * Lambda * inv(Phi), M)
        """
        return _typ.SquareMatrix_computeEV(self, keepIntact)

    def computeLargestEigenValueModule(self, *args):
        r"""
        Compute the largest eigenvalue module.

        Parameters
        ----------
        maximumIterations : int, optional
            The maximum number of power iterations to perform to get the approximation.
            Default is given by the 'Matrix-LargestEigenValueIterations' key in
            the :class:`~openturns.ResourceMap`.
        epsilon : float, optional
            The target relative error. Default is given by the
            'Matrix-LargestEigenValueRelativeError' key in the
            :class:`~openturns.ResourceMap`.

        Returns
        -------
        largestEigenvalueModule : float
            The largest eigenvalue module.

        See Also
        --------
        computeEV, computeEigenValues

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> M.computeLargestEigenValueModule()
        5.3722...
        """
        return _typ.SquareMatrix_computeLargestEigenValueModule(self, *args)

    def isDiagonal(self):
        r"""
        Test whether the matrix is diagonal or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.SquareMatrix_isDiagonal(self)

    def __init__(self, *args):
        _typ.SquareMatrix_swiginit(self, _typ.new_SquareMatrix(*args))

    def __getitem__(self, args):
        return _typ.SquareMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.SquareMatrix___setitem__(self, args, valObj)
    __swig_destroy__ = _typ.delete_SquareMatrix

# Register SquareMatrix in _typ:
_typ.SquareMatrix_swigregister(SquareMatrix)
class SymmetricMatrix(SquareMatrix):
    r"""
    Real symmetric matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of float with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Raises
    ------
    TypeError : If the matrix is not symmetric.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.SymmetricMatrix(2, [0.0, 2.0, 2.0, 1.0])
    >>> print(M)
    [[ 0 2 ]
     [ 2 1 ]]

    Get or set terms

    >>> print(M[0, 0])
    0.0
    >>> M[0, 0] = 1.0
    >>> print(M[0, 0])
    1.0
    >>> print(M[:, 0])
    [[ 1 ]
     [ 2 ]]

    Create an openturns matrix from a **symmetric** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0], [2.0, 4.0]])
    >>> ot_matrix = ot.SymmetricMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SymmetricMatrix_getClassName(self)

    def checkSymmetry(self):
        r"""Check if the internal representation is really symmetric."""
        return _typ.SymmetricMatrix_checkSymmetry(self)

    def isDiagonal(self):
        r"""
        Test whether the matrix is diagonal or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.SymmetricMatrix_isDiagonal(self)

    def __repr__(self):
        return _typ.SymmetricMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.SymmetricMatrix___str__(self, *args)

    def transpose(self):
        r"""
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.SymmetricMatrix_transpose(self)

    def __add__(self, *args):
        return _typ.SymmetricMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SymmetricMatrix___sub__(self, *args)

    def __pow__(self, n):
        return _typ.SymmetricMatrix___pow__(self, n)

    def __mul__(self, *args):
        return _typ.SymmetricMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SymmetricMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystemInPlace(self, *args):
        r"""
        Solve a rectangular linear system whose the present matrix is the operator.

        Similar to :meth:`solveLinearSystem` except the matrix is modified in-place
        during the resolution avoiding the need to allocate an extra copy if the
        original copy is not re-used.

        """
        return _typ.SymmetricMatrix_solveLinearSystemInPlace(self, *args)

    def solveLinearSystem(self, *args):
        r"""
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitly the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = [1.0] * 2
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.SymmetricMatrix_solveLinearSystem(self, *args)

    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        r"""
        Compute the logarithm of the absolute value of the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The logarithm of the absolute value of the square matrix determinant.
        sign : float
            The sign of the determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeLogAbsoluteDeterminant()
        [0.693147..., -1.0]
        """
        return _typ.SymmetricMatrix_computeLogAbsoluteDeterminant(self, keepIntact)

    def computeDeterminant(self, keepIntact=True):
        r"""
        Compute the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The square matrix determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeDeterminant()
        -2.0
        """
        return _typ.SymmetricMatrix_computeDeterminant(self, keepIntact)

    def computeEigenValues(self, keepIntact=True):
        r"""
        Compute eigenvalues.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.Point`
            Eigenvalues.

        See Also
        --------
        computeEV

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> print(M.computeEigenValues())
        [-4.70156,1.70156]
        """
        return _typ.SymmetricMatrix_computeEigenValues(self, keepIntact)

    def computeEV(self, keepIntact=True):
        r"""
        Compute the eigenvalues decomposition (EVD).

        The eigenvalues decomposition of a square matrix :math:`\mat{M}` with
        size :math:`n` reads:

        .. math::

            \mat{M} = \mat{\Phi} \mat{\Lambda} \Tr{\mat{\Phi}}

        where :math:`\mat{\Lambda}` is an :math:`n \times n` diagonal matrix and
        :math:`\mat{\Phi}` is an :math:`n \times n` orthogonal matrix.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.Point`
            The vector of eigenvalues with size :math:`n` that form the diagonal of
            the :math:`n \times n` matrix :math:`\mat{\Lambda}` of the EVD.
        Phi : :class:`~openturns.SquareComplexMatrix`
            The left matrix of the EVD.

        Notes
        -----
        This uses LAPACK'S `DSYEV <http://www.netlib.org/lapack/lapack-3.1.1/html/dsyev.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> eigen_values, Phi = M.computeEV()
        >>> Lambda = ot.SquareMatrix(M.getDimension())
        >>> for i in range(eigen_values.getSize()):
        ...     Lambda[i, i] = eigen_values[i]
        >>> np.testing.assert_array_almost_equal(Phi * Lambda * Phi.transpose(), M)
        """
        return _typ.SymmetricMatrix_computeEV(self, keepIntact)

    def computeLargestEigenValueModule(self, *args):
        r"""
        Compute the largest eigenvalue module.

        Parameters
        ----------
        maximumIterations : int, optional
            The maximum number of power iterations to perform to get the approximation.
            Default is given by the 'Matrix-LargestEigenValueIterations' key in
            the :class:`~openturns.ResourceMap`.
        epsilon : float, optional
            The target relative error. Default is given by the
            'Matrix-LargestEigenValueRelativeError' key in the
            :class:`~openturns.ResourceMap`.

        Returns
        -------
        largestEigenvalueModule : float
            The largest eigenvalue module.

        See Also
        --------
        computeEV, computeEigenValues

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SymmetricMatrix([[1.0, 3.0], [3.0, 4.0]])
        >>> M.computeLargestEigenValueModule()
        5.8541...
        """
        return _typ.SymmetricMatrix_computeLargestEigenValueModule(self, *args)

    def __eq__(self, *args):
        return _typ.SymmetricMatrix___eq__(self, *args)

    def computeSumElements(self):
        r"""
        Compute the sum of the matrix elements.

        Returns
        -------
        sum : a float
            The sum of the elements.

        Notes
        -----

        We compute here the sum of elements of the matrix :math:`\cM`, that defines as:

        .. math::

            s = \sum_{i=1}^{nRows}\sum_{j=1}^{nColumns} \cM_{i,j}

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> s = M.computeSumElements()
        >>> print(s)
        21.0
        """
        return _typ.SymmetricMatrix_computeSumElements(self)

    def __init__(self, *args):
        _typ.SymmetricMatrix_swiginit(self, _typ.new_SymmetricMatrix(*args))

    def __getitem__(self, args):
        return _typ.SymmetricMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.SymmetricMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.SymmetricMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_SymmetricMatrix

# Register SymmetricMatrix in _typ:
_typ.SymmetricMatrix_swigregister(SymmetricMatrix)

def SymmetricMatrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.checkSymmetry()
    return super(SymmetricMatrix, self).__getattribute__(name)
SymmetricMatrix.__getattribute__ = SymmetricMatrix___getattribute__

class _TensorImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _typ._TensorImplementationTypedInterfaceObject_swiginit(self, _typ.new__TensorImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _typ._TensorImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._TensorImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._TensorImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _typ._TensorImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _typ._TensorImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _typ.delete__TensorImplementationTypedInterfaceObject

# Register _TensorImplementationTypedInterfaceObject in _typ:
_typ._TensorImplementationTypedInterfaceObject_swigregister(_TensorImplementationTypedInterfaceObject)
class Tensor(_TensorImplementationTypedInterfaceObject):
    r"""
    Tensor.

    Available constructors:
        Tensor(*n_rows, n_columns, n_sheets*)

        Tensor(*n_rows, n_columns, n_sheets, values*)

        Tensor(*sequence*)

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`
        Number of rows.
    n_columns : int, :math:`n_c > 0`
        Number of columns.
    n_sheets : int, :math:`n_s > 0`
        Number of sheets.
    values : sequence of float with size :math:`n_r \times n_c \times n_s`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        If not mentioned, a zero tensor is created.
    sequence : sequence of float
        Values.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Tensor(2, 2, 2, [1]))
    sheet #0
    [[ 1 0 ]
     [ 0 0 ]]
    sheet #1
    [[ 0 0 ]
     [ 0 0 ]]
    >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
    >>> print(T)
    sheet #0
    [[  0  2 ]
     [  1  3 ]]
    sheet #1
    [[  4  6 ]
     [  5  7 ]]
    sheet #2
    [[  8 10 ]
     [  9 11 ]]

    Get or set terms:

    >>> print(T[0, 0, 0])
    0.0
    >>> T[0, 0, 0] = 1.
    >>> print(T[0, 0, 0])
    1.0

    Create an openturns tensor from a sequence:

    >>> T = ot.Tensor([[[1.0, 2.0, 3.0], [4.0, 5.0, 6.0]], [[7.0, 8.0, 9.0], [10.0, 11.0, 12.0]]])
    >>> print(T)
    sheet #0
    [[  1  4 ]
     [  7 10 ]]
    sheet #1
    [[  2  5 ]
     [  8 11 ]]
    sheet #2
    [[  3  6 ]
     [  9 12 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Tensor_getClassName(self)

    def clean(self, threshold):
        r"""
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_tensor : :class:`~openturns.Tensor`
            Input tensor with elements smaller than the threshold set to zero.
        """
        return _typ.Tensor_clean(self, threshold)

    def __repr__(self):
        return _typ.Tensor___repr__(self)

    def __str__(self, *args):
        return _typ.Tensor___str__(self, *args)

    def getSheet(self, k):
        r"""
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.Matrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getSheet(1))
        [[ 4 6 ]
         [ 5 7 ]]
        """
        return _typ.Tensor_getSheet(self, k)

    def setSheet(self, k, m):
        r"""
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.Matrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  0  2 ]
         [  1  3 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        >>> M = ot.Matrix([[1, 2],[3, 4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  1  2 ]
         [  3  4 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        """
        return _typ.Tensor_setSheet(self, k, m)

    def getNbRows(self):
        r"""
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.Tensor_getNbRows(self)

    def getNbColumns(self):
        r"""
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.Tensor_getNbColumns(self)

    def getNbSheets(self):
        r"""
        Accessor to the number of sheets.

        Returns
        -------
        n_sheets : int

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getNbSheets())
        3
        """
        return _typ.Tensor_getNbSheets(self)

    def __eq__(self, *args):
        return _typ.Tensor___eq__(self, *args)

    def isEmpty(self):
        r"""
        Tell if the tensor is empty.

        Returns
        -------
        is_empty : bool
            *True* if the tensor contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor()
        >>> T.isEmpty()
        True
        """
        return _typ.Tensor_isEmpty(self)

    def __baseaddress__(self):
        return _typ.Tensor___baseaddress__(self)

    def __elementsize__(self):
        return _typ.Tensor___elementsize__(self)

    def __stride__(self, dim):
        return _typ.Tensor___stride__(self, dim)

    def __init__(self, *args):
        _typ.Tensor_swiginit(self, _typ.new_Tensor(*args))

    def __getitem__(self, args):
        return _typ.Tensor___getitem__(self, args)

    def __setitem__(self, args, val):
        return _typ.Tensor___setitem__(self, args, val)
    __swig_destroy__ = _typ.delete_Tensor

# Register Tensor in _typ:
_typ.Tensor_swigregister(Tensor)

# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the Tensor (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def Tensor___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns(), self.getNbSheets()),
                                                'typestr': "|f" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__() or 1), True),
                                                'strides': (self.__stride__(0), self.__stride__(1), self.__stride__(2)),
                                                'version': 3,
                                                }
    return super(Tensor, self).__getattribute__(name)
Tensor.__getattribute__ = Tensor___getattribute__

class SymmetricTensor(Tensor):
    r"""
    Symmetric tensor.

    Available constructors:
        SymmetricTensor(*n_rows, n_sheets*)

        SymmetricTensor(*n_rows, n_sheets, values*)

        SymmetricTensor(*sequence*)

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`
        Number of rows and columns.
    n_sheets : int, :math:`n_s > 0`
        Number of sheets.
    values : sequence of float with size :math:`n_r \times n_r \times n_s`, optional
        Values. **column-major** ordering is used (like Fortran) for
        reshaping the flat list of values.
        If not mentioned, a zero tensor is created.
    sequence : sequence of float
        Values.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.SymmetricTensor(2, 2, [0, 1]))
    sheet #0
    [[ 0 1 ]
     [ 1 0 ]]
    sheet #1
    [[ 0 0 ]
     [ 0 0 ]]
    >>> T = ot.SymmetricTensor(2, 3, range(2*2*3))
    >>> print(T)
    sheet #0
    [[  0  1 ]
     [  1  3 ]]
    sheet #1
    [[  4  5 ]
     [  5  7 ]]
    sheet #2
    [[  8  9 ]
     [  9 11 ]]

    Get or set terms:

    >>> print(T[0, 0, 0])
    0.0
    >>> T[0, 0, 0] = 1.0
    >>> print(T[0, 0, 0])
    1.0

    Create an openturns tensor from a sequence:

    >>> T = ot.SymmetricTensor([[[1.0, 2.0, 3.0], [7.0, 8.0, 9.0]], [[7.0, 8.0, 9.0], [10.0, 11.0, 12.0]]])
    >>> print(T)
    sheet #0
    [[  1  7 ]
     [  7 10 ]]
    sheet #1
    [[  2  8 ]
     [  8 11 ]]
    sheet #2
    [[  3  9 ]
     [  9 12 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SymmetricTensor_getClassName(self)

    def __repr__(self):
        return _typ.SymmetricTensor___repr__(self)

    def __str__(self, *args):
        return _typ.SymmetricTensor___str__(self, *args)

    def checkSymmetry(self):
        r"""Check if the internal representation is really symmetric."""
        return _typ.SymmetricTensor_checkSymmetry(self)

    def getSheet(self, k):
        r"""
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.Matrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getSheet(1))
        [[ 4 6 ]
         [ 5 7 ]]
        """
        return _typ.SymmetricTensor_getSheet(self, k)

    def setSheet(self, k, m):
        r"""
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.Matrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  0  2 ]
         [  1  3 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        >>> M = ot.Matrix([[1, 2],[3, 4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  1  2 ]
         [  3  4 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        """
        return _typ.SymmetricTensor_setSheet(self, k, m)

    def __init__(self, *args):
        _typ.SymmetricTensor_swiginit(self, _typ.new_SymmetricTensor(*args))

    def __getitem__(self, args):
        return _typ.SymmetricTensor___getitem__(self, args)

    def __setitem__(self, args, val):
        return _typ.SymmetricTensor___setitem__(self, args, val)
    __swig_destroy__ = _typ.delete_SymmetricTensor

# Register SymmetricTensor in _typ:
_typ.SymmetricTensor_swigregister(SymmetricTensor)

def SymmetricTensor___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.checkSymmetry()
    return super(SymmetricTensor, self).__getattribute__(name)
SymmetricTensor.__getattribute__ = SymmetricTensor___getattribute__

class _ComplexMatrixImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _typ._ComplexMatrixImplementationTypedInterfaceObject_swiginit(self, _typ.new__ComplexMatrixImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _typ._ComplexMatrixImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._ComplexMatrixImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._ComplexMatrixImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _typ._ComplexMatrixImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _typ._ComplexMatrixImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _typ.delete__ComplexMatrixImplementationTypedInterfaceObject

# Register _ComplexMatrixImplementationTypedInterfaceObject in _typ:
_typ._ComplexMatrixImplementationTypedInterfaceObject_swigregister(_ComplexMatrixImplementationTypedInterfaceObject)
class ComplexCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete_ComplexCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.ComplexCollection_clear(self)

    def __len__(self):
        return _typ.ComplexCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.ComplexCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.ComplexCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ.ComplexCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ.ComplexCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.ComplexCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.ComplexCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.ComplexCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.ComplexCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.ComplexCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.ComplexCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.ComplexCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ.ComplexCollection_find(self, val)

    def __repr__(self):
        return _typ.ComplexCollection___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexCollection___str__(self, *args)

    def __init__(self, *args):
        _typ.ComplexCollection_swiginit(self, _typ.new_ComplexCollection(*args))

# Register ComplexCollection in _typ:
_typ.ComplexCollection_swigregister(ComplexCollection)
class _ComplexPersistentCollection(openturns.common.PersistentObject, ComplexCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._ComplexPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _typ._ComplexPersistentCollection_swiginit(self, _typ.new__ComplexPersistentCollection(*args))

    def __repr__(self):
        return _typ._ComplexPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ._ComplexPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete__ComplexPersistentCollection

# Register _ComplexPersistentCollection in _typ:
_typ._ComplexPersistentCollection_swigregister(_ComplexPersistentCollection)
class ComplexMatrix(_ComplexMatrixImplementationTypedInterfaceObject):
    r"""
    Complex Matrix.

    Parameters
    ----------
    nr : integer
        The number of rows of the complex matrix.
    nc : integer
        The number of columns of the complex matrix.
    values : sequence of complex number, optional
        The sequence must have :math:`n_r \times n_c` elements. It might be a
        :class:`~openturns.ComplexCollection` or a :class:`~openturns.ScalarCollection`. Default is (0, 0).

    See also
    --------
    ComplexTensor

    Examples
    --------
    >>> import openturns as ot
    >>> m = ot.ComplexMatrix(2, 2, [1+2j, 3+4j , 5+6j, 7+8j])
    >>> print(m)
    [[ (1,2) (5,6) ]
     [ (3,4) (7,8) ]]
    >>> m = ot.ComplexMatrix(2, 3, range(2*3))
    >>> print(m)
    [[ (0,0) (2,0) (4,0) ]
     [ (1,0) (3,0) (5,0) ]]

    Create a matrix from a numpy array:

    >>> import numpy as np
    >>> array = np.array([[1, 2], [3, 4], [5, 6]])
    >>> m = ot.ComplexMatrix(array)
    >>> print(m)
    [[ (1,0) (2,0) ]
     [ (3,0) (4,0) ]
     [ (5,0) (6,0) ]]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexMatrix_getClassName(self)

    def clean(self, threshold):
        r"""
        Clean the matrix according to a specific threshold.

        Parameters
        ----------
        threshold : positive float
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.ComplexMatrix_clean(self, threshold)

    def solveLinearSystemInPlace(self, *args):
        r"""
        Solve a system of linear equations.

        Parameters
        ----------
        B : :class:`~openturns.ComplexMatrix`
            Second member

        Returns
        -------
        X : :class:`~openturns.ComplexMatrix`
            The solution to A * X = B.

        Notes
        -----
        Unlike :meth:`solveLinearSystem` this method does not copy the matrix A
        and alters it in-place during the resolution, so the content of A may change.
        """
        return _typ.ComplexMatrix_solveLinearSystemInPlace(self, *args)

    def solveLinearSystem(self, *args):
        r"""
        Solve a system of linear equations.

        Parameters
        ----------
        B : :class:`~openturns.ComplexMatrix`
            Second member

        Returns
        -------
        X : :class:`~openturns.ComplexMatrix`
            The solution to A * X = B.
        """
        return _typ.ComplexMatrix_solveLinearSystem(self, *args)

    def __repr__(self):
        return _typ.ComplexMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexMatrix___str__(self, *args)

    def getNbRows(self):
        r"""
        Accessor to the number of rows.

        Returns
        -------
        nr : integer
            The number of rows of :math:`\mat{M}`.
        """
        return _typ.ComplexMatrix_getNbRows(self)

    def getNbColumns(self):
        r"""
        Accessor to the number of columns.

        Returns
        -------
        nc : integer
            The number of columns of :math:`\mat{M}`.
        """
        return _typ.ComplexMatrix_getNbColumns(self)

    def transpose(self):
        r"""
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.ComplexMatrix_transpose(self)

    def conjugate(self):
        r"""
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\mat{N}` of size :math:`n_r \times n_c`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{i, j}`.
        """
        return _typ.ComplexMatrix_conjugate(self)

    def conjugateTranspose(self):
        r"""
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{j, i}`.
        """
        return _typ.ComplexMatrix_conjugateTranspose(self)

    def real(self):
        r"""
        Accessor to the real part.

        Returns
        -------
        rmat : :class:`~openturns.Matrix`
            A real matrix :math:`\mat{A}` of size :math:`n_r \times n_c` such
            :math:`A_{i, j} = \mathrm{Re} (M_{i, j})`.
        """
        return _typ.ComplexMatrix_real(self)

    def imag(self):
        r"""
        Accessor to the imaginary part.

        Returns
        -------
        imat : :class:`~openturns.Matrix`
            A real matrix :math:`\mat{A}` of size :math:`n_r \times n_c` such
            :math:`A_{i, j} = \mathrm{Im} (M_{i, j})`.
        """
        return _typ.ComplexMatrix_imag(self)

    def __add__(self, *args):
        return _typ.ComplexMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.ComplexMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.ComplexMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.ComplexMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def __eq__(self, *args):
        return _typ.ComplexMatrix___eq__(self, *args)

    def isEmpty(self):
        r"""
        Test whether the matrix is empty or not.

        Returns
        -------
        isEmpty : bool
            Flag telling whether the dimensions of the matrix is zero.
        """
        return _typ.ComplexMatrix_isEmpty(self)

    def __baseaddress__(self):
        return _typ.ComplexMatrix___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexMatrix___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexMatrix___stride__(self, dim)

    def __init__(self, *args):
        _typ.ComplexMatrix_swiginit(self, _typ.new_ComplexMatrix(*args))

    def __getitem__(self, args):
        return _typ.ComplexMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.ComplexMatrix___setitem__(self, args, valObj)

    def __rmul__(self, s):
        return _typ.ComplexMatrix___rmul__(self, s)

    def __matmul__(self, *args):
        return _typ.ComplexMatrix___matmul__(self, *args)
    __swig_destroy__ = _typ.delete_ComplexMatrix

# Register ComplexMatrix in _typ:
_typ.ComplexMatrix_swigregister(ComplexMatrix)

# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the ComplexMatrix (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def ComplexMatrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns()),
                                                'typestr': "|c" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__() or 1), True),
                                                'strides': (self.__stride__(0), self.__stride__(1)),
                                                'version': 3,
                                                }
    return super(ComplexMatrix, self).__getattribute__(name)
ComplexMatrix.__getattribute__ = ComplexMatrix___getattribute__

class SquareComplexMatrix(ComplexMatrix):
    r"""
    Complex square matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of complex with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.SquareComplexMatrix(2, range(2 * 2))
    >>> print(M)
    [[ (0,0) (2,0) ]
     [ (1,0) (3,0) ]]

    Get or set terms

    >>> print(M[0, 0])
    0j
    >>> M[0, 0] = 1.0
    >>> print(M[0, 0])
    (1+0j)
    >>> print(M[:, 0])
    [[ (1,0) ]
     [ (1,0) ]]


    Create an openturns matrix from a **square** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0], [3.0, 4.0]])
    >>> ot_matrix = ot.SquareComplexMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SquareComplexMatrix_getClassName(self)

    def __repr__(self):
        return _typ.SquareComplexMatrix___repr__(self)

    def getDimension(self):
        r"""
        Accessor to the dimension (the number of rows).

        Returns
        -------
        dimension : int
        """
        return _typ.SquareComplexMatrix_getDimension(self)

    def transpose(self):
        r"""
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.SquareComplexMatrix_transpose(self)

    def conjugate(self):
        r"""
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\mat{N}` of size :math:`n_r \times n_c`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{i, j}`.
        """
        return _typ.SquareComplexMatrix_conjugate(self)

    def conjugateTranspose(self):
        r"""
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{j, i}`.
        """
        return _typ.SquareComplexMatrix_conjugateTranspose(self)

    def __add__(self, *args):
        return _typ.SquareComplexMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SquareComplexMatrix___sub__(self, *args)

    def __pow__(self, n):
        return _typ.SquareComplexMatrix___pow__(self, n)

    def __mul__(self, *args):
        return _typ.SquareComplexMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SquareComplexMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def __init__(self, *args):
        _typ.SquareComplexMatrix_swiginit(self, _typ.new_SquareComplexMatrix(*args))

    def __getitem__(self, args):
        return _typ.SquareComplexMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.SquareComplexMatrix___setitem__(self, args, valObj)
    __swig_destroy__ = _typ.delete_SquareComplexMatrix

# Register SquareComplexMatrix in _typ:
_typ.SquareComplexMatrix_swigregister(SquareComplexMatrix)
class HermitianMatrix(SquareComplexMatrix):
    r"""
    Hermitian Matrix.

    Available constructors:
        HermitianMatrix(*dim*)

    Parameters
    ----------
    dim : integer
        The dimension of the Hermitian matrix (square matrix with *dim* rows and 
        *dim* columns).

    See also
    --------
    ComplexMatrix

    Notes
    -----
    The Hermitian matrix is filled with :math:`(0, 0)`. It is not possible to fill
    the matrix from a collection of complex values (to be done later).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.HermitianMatrix_getClassName(self)

    def __repr__(self):
        return _typ.HermitianMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.HermitianMatrix___str__(self, *args)

    def getDimension(self):
        r"""
        Accessor to the matrix dimension.

        Returns
        -------
        dim : integer
            The dimension of the Hermitian matrix.
        """
        return _typ.HermitianMatrix_getDimension(self)

    def transpose(self):
        r"""
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.HermitianMatrix_transpose(self)

    def conjugate(self):
        r"""
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\mat{N}` of size :math:`n_r \times n_c`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{i, j}`.
        """
        return _typ.HermitianMatrix_conjugate(self)

    def conjugateTranspose(self):
        r"""
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{j, i}`.
        """
        return _typ.HermitianMatrix_conjugateTranspose(self)

    def real(self):
        r"""
        Accessor to the real part.

        Returns
        -------
        rmat : :class:`~openturns.Matrix`
            A real matrix :math:`\mat{A}` of size :math:`n_r \times n_c` such
            :math:`A_{i, j} = \mathrm{Re} (M_{i, j})`.
        """
        return _typ.HermitianMatrix_real(self)

    def imag(self):
        r"""
        Accessor to the imaginary part.

        Returns
        -------
        imat : :class:`~openturns.Matrix`
            A real matrix :math:`\mat{A}` of size :math:`n_r \times n_c` such
            :math:`A_{i, j} = \mathrm{Im} (M_{i, j})`.
        """
        return _typ.HermitianMatrix_imag(self)

    def checkHermitian(self):
        r"""Check if the internal representation is really hermitian."""
        return _typ.HermitianMatrix_checkHermitian(self)

    def __add__(self, *args):
        return _typ.HermitianMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.HermitianMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.HermitianMatrix___mul__(self, *args)

    def __pow__(self, n):
        return _typ.HermitianMatrix___pow__(self, n)

    def __truediv__(self, *args):
        return _typ.HermitianMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def computeCholesky(self, keepIntact=True):
        r"""
        Compute the Cholesky factor.

        Returns
        -------
        G : :class:`~openturns.ComplexMatrix`
            The Cholesky factor :math:`\mat{G}`, i.e. the complex matrix such as
            :math:`\mat{G} \times \Tr{\mat{G}}` is the initial matrix.
        """
        return _typ.HermitianMatrix_computeCholesky(self, keepIntact)

    def __init__(self, *args):
        _typ.HermitianMatrix_swiginit(self, _typ.new_HermitianMatrix(*args))

    def __getitem__(self, args):
        return _typ.HermitianMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.HermitianMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.HermitianMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_HermitianMatrix

# Register HermitianMatrix in _typ:
_typ.HermitianMatrix_swigregister(HermitianMatrix)

def HermitianMatrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.checkHermitian()
    return super(HermitianMatrix, self).__getattribute__(name)
HermitianMatrix.__getattribute__ = HermitianMatrix___getattribute__

class TriangularMatrix(SquareMatrix):
    r"""
    Hermitian Matrix.

    Available constructors:
        TriangularMatrix(*dim*)

        TriangularMatrix(*dim, isLower*)

    Parameters
    ----------
    dim : integer
        The dimension of the triangular matrix (square matrix with *dim* rows and 
        *dim* columns).
    isLower : bool
        Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        Default is *True*.

    See also
    --------
    Matrix

    Notes
    -----
    The triangular matrix is filled with 0.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.TriangularMatrix_getClassName(self)

    def checkTriangularity(self):
        return _typ.TriangularMatrix_checkTriangularity(self)

    def isDiagonal(self):
        r"""
        Test whether the matrix is diagonal or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.TriangularMatrix_isDiagonal(self)

    def __repr__(self):
        return _typ.TriangularMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.TriangularMatrix___str__(self, *args)

    def getDimension(self):
        r"""
        Accessor to the dimension (the number of rows).

        Returns
        -------
        dimension : int
        """
        return _typ.TriangularMatrix_getDimension(self)

    def transpose(self):
        r"""
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.TriangularMatrix_transpose(self)

    def isLowerTriangular(self):
        r"""
        Test whether the matrix is lower triangular or upper triangular.

        Returns
        -------
        isLower : bool
            Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        """
        return _typ.TriangularMatrix_isLowerTriangular(self)

    def __add__(self, *args):
        return _typ.TriangularMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.TriangularMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.TriangularMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.TriangularMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystem(self, *args):
        r"""
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitly the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = [1.0] * 2
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.TriangularMatrix_solveLinearSystem(self, *args)

    def solveLinearSystemInPlace(self, *args):
        r"""
        Solve a rectangular linear system whose the present matrix is the operator.

        Similar to :meth:`solveLinearSystem` except the matrix is modified in-place
        during the resolution avoiding the need to allocate an extra copy if the
        original copy is not re-used.

        """
        return _typ.TriangularMatrix_solveLinearSystemInPlace(self, *args)

    def __init__(self, *args):
        _typ.TriangularMatrix_swiginit(self, _typ.new_TriangularMatrix(*args))

    def __getitem__(self, args):
        return _typ.TriangularMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.TriangularMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.TriangularMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_TriangularMatrix

# Register TriangularMatrix in _typ:
_typ.TriangularMatrix_swigregister(TriangularMatrix)
class TriangularComplexMatrix(SquareComplexMatrix):
    r"""
    Hermitian Matrix.

    Available constructors:
        TriangularComplexMatrix(*dim*)

        TriangularComplexMatrix(*dim, isLower*)

    Parameters
    ----------
    dim : integer
        The dimension of the triangular matrix (square matrix with *dim* rows and 
        *dim* columns).
    isLower : bool
        Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        Default is *True*.

    See also
    --------
    ComplexMatrix

    Notes
    -----
    The triangular complex matrix is filled with :math:`(0, 0)`. It is not possible to fill
    the matrix from a collection of complex values (to be done later).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.TriangularComplexMatrix_getClassName(self)

    def __repr__(self):
        return _typ.TriangularComplexMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.TriangularComplexMatrix___str__(self, *args)

    def getDimension(self):
        r"""
        Accessor to the matrix dimension.

        Returns
        -------
        dim : integer
            The dimension of the matrix.
        """
        return _typ.TriangularComplexMatrix_getDimension(self)

    def transpose(self):
        r"""
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.TriangularComplexMatrix_transpose(self)

    def conjugate(self):
        r"""
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\mat{N}` of size :math:`n_r \times n_c`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{i, j}`.
        """
        return _typ.TriangularComplexMatrix_conjugate(self)

    def conjugateTranspose(self):
        r"""
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
            associated with the given complex matrix :math:`\mat{M}` such as
            :math:`N_{i, j} = \overline{M}_{j, i}`.
        """
        return _typ.TriangularComplexMatrix_conjugateTranspose(self)

    def isLowerTriangular(self):
        r"""
        Test whether the matrix is lower triangular or upper triangular.

        Returns
        -------
        isLower : bool
            Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        """
        return _typ.TriangularComplexMatrix_isLowerTriangular(self)

    def __add__(self, *args):
        return _typ.TriangularComplexMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.TriangularComplexMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.TriangularComplexMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.TriangularComplexMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def __init__(self, *args):
        _typ.TriangularComplexMatrix_swiginit(self, _typ.new_TriangularComplexMatrix(*args))

    def __getitem__(self, args):
        return _typ.TriangularComplexMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.TriangularComplexMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.TriangularComplexMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_TriangularComplexMatrix

# Register TriangularComplexMatrix in _typ:
_typ.TriangularComplexMatrix_swigregister(TriangularComplexMatrix)
class _ComplexTensorImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _typ._ComplexTensorImplementationTypedInterfaceObject_swiginit(self, _typ.new__ComplexTensorImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _typ._ComplexTensorImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._ComplexTensorImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._ComplexTensorImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _typ._ComplexTensorImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _typ._ComplexTensorImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _typ.delete__ComplexTensorImplementationTypedInterfaceObject

# Register _ComplexTensorImplementationTypedInterfaceObject in _typ:
_typ._ComplexTensorImplementationTypedInterfaceObject_swigregister(_ComplexTensorImplementationTypedInterfaceObject)
class ComplexTensor(_ComplexTensorImplementationTypedInterfaceObject):
    r"""
    Complex tensor.

    Available constructors:
        ComplexTensor(*n_rows, n_columns, n_sheets*)

        ComplexTensor(*n_rows, n_columns, n_sheets, values*)

        ComplexTensor(*sequence*)

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`
        Number of rows.
    n_columns : int, :math:`n_c > 0`
        Number of columns.
    n_sheets : int, :math:`n_s > 0`
        Number of sheets.
    values : sequence of complex with size :math:`n_r \times n_c \times n_s`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        If not mentioned, a zero tensor is created.
    sequence : sequence of complex
        Values.

    Examples
    --------
    Create a tensor of complex values:

    >>> import openturns as ot
    >>> T = ot.ComplexTensor(2, 2, 2, range(2 * 2 * 2))
    >>> print(T)
    sheet #0
    [[ (0,0) (2,0) ]
     [ (1,0) (3,0) ]]
    sheet #1
    [[ (4,0) (6,0) ]
     [ (5,0) (7,0) ]]

    Get or set terms:

    >>> print(T[0, 0, 0])
    0j
    >>> T[0, 0, 0] = 1.0
    >>> print(T[0, 0, 0])
    (1+0j)

    Create an openturns tensor from a numpy 3d-array:

    >>> import numpy as np
    >>> np_3d_array = np.array([[[1.0, 2.0, 3.0], [4.0, 5.0, 6.0]], [[7.0, 8.0, 9.0], [10.0, 11.0, 12.0]]])
    >>> ot_tensor = ot.ComplexTensor(np_3d_array)

    and back

    >>> np_tensor = np.array(ot_tensor)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexTensor_getClassName(self)

    def clean(self, threshold):
        r"""
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_tensor : :class:`~openturns.ComplexTensor`
            Input tensor with elements smaller than the threshold set to zero.
        """
        return _typ.ComplexTensor_clean(self, threshold)

    def __repr__(self):
        return _typ.ComplexTensor___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexTensor___str__(self, *args)

    def getSheet(self, k):
        r"""
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.ComplexMatrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.ComplexTensor(2,2,3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  (0,0)  (2,0) ]
         [  (1,0)  (3,0) ]]
        sheet #1
        [[  (4,0)  (6,0) ]
         [  (5,0)  (7,0) ]]
        sheet #2
        [[  (8,0) (10,0) ]
         [  (9,0) (11,0) ]]
        >>> print(T.getSheet(0))
        [[ (0,0) (2,0) ]
         [ (1,0) (3,0) ]]
        """
        return _typ.ComplexTensor_getSheet(self, k)

    def setSheet(self, k, m):
        r"""
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.ComplexMatrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.ComplexTensor(2,2,3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  (0,0)  (2,0) ]
         [  (1,0)  (3,0) ]]
        sheet #1
        [[  (4,0)  (6,0) ]
         [  (5,0)  (7,0) ]]
        sheet #2
        [[  (8,0) (10,0) ]
         [  (9,0) (11,0) ]]
        >>> M = ot.ComplexMatrix([[1,2],[3,4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  (1,0)  (2,0) ]
         [  (3,0)  (4,0) ]]
        sheet #1
        [[  (4,0)  (6,0) ]
         [  (5,0)  (7,0) ]]
        sheet #2
        [[  (8,0) (10,0) ]
         [  (9,0) (11,0) ]]
        """
        return _typ.ComplexTensor_setSheet(self, k, m)

    def getNbRows(self):
        r"""
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.ComplexTensor_getNbRows(self)

    def getNbColumns(self):
        r"""
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.ComplexTensor_getNbColumns(self)

    def getNbSheets(self):
        r"""
        Accessor to the number of sheets.

        Returns
        -------
        n_sheets : int
        """
        return _typ.ComplexTensor_getNbSheets(self)

    def __eq__(self, *args):
        return _typ.ComplexTensor___eq__(self, *args)

    def isEmpty(self):
        r"""
        Tell if the tensor is empty.

        Returns
        -------
        is_empty : bool
            True if the tensor contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.ComplexTensor()
        >>> T.isEmpty()
        True
        """
        return _typ.ComplexTensor_isEmpty(self)

    def __baseaddress__(self):
        return _typ.ComplexTensor___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexTensor___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexTensor___stride__(self, dim)

    def __init__(self, *args):
        _typ.ComplexTensor_swiginit(self, _typ.new_ComplexTensor(*args))

    def __getitem__(self, args):
        return _typ.ComplexTensor___getitem__(self, args)

    def __setitem__(self, args, val):
        return _typ.ComplexTensor___setitem__(self, args, val)
    __swig_destroy__ = _typ.delete_ComplexTensor

# Register ComplexTensor in _typ:
_typ.ComplexTensor_swigregister(ComplexTensor)

# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the ComplexTensor (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def ComplexTensor___getattribute__(self, name):
    """Implement attribute accesses."""
    if (name == '__array_interface__'):
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns(), self.getNbSheets()),
                                                'typestr': "|c" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__() or 1), True),
                                                'strides': (self.__stride__(0), self.__stride__(1), self.__stride__(2)),
                                                'version': 3,
                                                }
    return object.__getattribute__(self, name)
ComplexTensor.__getattribute__ = ComplexTensor___getattribute__

class _CovarianceMatrixCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete__CovarianceMatrixCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ._CovarianceMatrixCollection_clear(self)

    def __len__(self):
        return _typ._CovarianceMatrixCollection___len__(self)

    def __eq__(self, rhs):
        return _typ._CovarianceMatrixCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ._CovarianceMatrixCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ._CovarianceMatrixCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ._CovarianceMatrixCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ._CovarianceMatrixCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ._CovarianceMatrixCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ._CovarianceMatrixCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ._CovarianceMatrixCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ._CovarianceMatrixCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ._CovarianceMatrixCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ._CovarianceMatrixCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ._CovarianceMatrixCollection_find(self, val)

    def __repr__(self):
        return _typ._CovarianceMatrixCollection___repr__(self)

    def __str__(self, *args):
        return _typ._CovarianceMatrixCollection___str__(self, *args)

    def __init__(self, *args):
        _typ._CovarianceMatrixCollection_swiginit(self, _typ.new__CovarianceMatrixCollection(*args))

# Register _CovarianceMatrixCollection in _typ:
_typ._CovarianceMatrixCollection_swigregister(_CovarianceMatrixCollection)
class _CovarianceMatrixPersistentCollection(openturns.common.PersistentObject, _CovarianceMatrixCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._CovarianceMatrixPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _typ._CovarianceMatrixPersistentCollection_swiginit(self, _typ.new__CovarianceMatrixPersistentCollection(*args))

    def __repr__(self):
        return _typ._CovarianceMatrixPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ._CovarianceMatrixPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete__CovarianceMatrixPersistentCollection

# Register _CovarianceMatrixPersistentCollection in _typ:
_typ._CovarianceMatrixPersistentCollection_swigregister(_CovarianceMatrixPersistentCollection)
class CovarianceMatrix(SymmetricMatrix):
    r"""
    Covariance (real symmetric positive definite) matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of float with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates an identity matrix.

    Raises
    ------
    TypeError : If the matrix is not symmetric.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> C = ot.CovarianceMatrix(2, [1.0, 0.5, 0.5, 1.0])
    >>> print(C)
    [[ 1   0.5 ]
     [ 0.5 1   ]]

    Get or set terms

    >>> print(C[0, 1])
    0.5
    >>> C[0, 1] = 0.6
    >>> print(C[0, 1])
    0.6
    >>> print(C[:, 0])
    [[ 1   ]
     [ 0.6 ]]

    Create an openturns matrix from a **symmetric** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 0.5], [0.5, 1.0]])
    >>> ot_matrix = ot.CovarianceMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.CovarianceMatrix_getClassName(self)

    def __repr__(self):
        return _typ.CovarianceMatrix___repr__(self)

    def transpose(self):
        r"""
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.CovarianceMatrix_transpose(self)

    def __add__(self, *args):
        return _typ.CovarianceMatrix___add__(self, *args)

    def __mul__(self, *args):
        return _typ.CovarianceMatrix___mul__(self, *args)

    def isPositiveDefinite(self):
        r"""
        Test whether the matrix is positive definite or not.

        A matrix :math:`\mat{M}` is positive definite if :math:`\Tr{\vect{z}} \mat{M} \vect{z}`
        is positive for every compatible non-zero column vector :math:`\vect{z}`.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.CovarianceMatrix_isPositiveDefinite(self)

    def computeCholesky(self, keepIntact=True):
        r"""
        Compute the Cholesky factor.

        The Cholesky factor of a covariance (real symmetric positive definite) matrix
        :math:`\mat{C}` is the lower triangular matrix :math:`\mat{L}` such that:

        .. math::

            \mat{C} = \mat{L} \Tr{\mat{L}}

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        cholesky_factor : :class:`~openturns.TriangularMatrix`
            The left (lower) Cholesky factor.
        """
        return _typ.CovarianceMatrix_computeCholesky(self, keepIntact)

    def computeRegularizedCholesky(self):
        r"""
        Compute the regularized Cholesky factor.

        Similar to :meth:`computeCholesky` but with a regularization loop according
        to the largest eigenvalue and keys `Matrix-StartingScaling` and `Matrix-MaximalScaling`.

        Returns
        -------
        cholesky_factor : :class:`~openturns.TriangularMatrix`
            The left (lower) Cholesky factor.
        """
        return _typ.CovarianceMatrix_computeRegularizedCholesky(self)

    def solveLinearSystemInPlace(self, *args):
        r"""
        Solve a rectangular linear system whose the present matrix is the operator.

        Similar to :meth:`solveLinearSystem` except the matrix is modified in-place
        during the resolution avoiding the need to allocate an extra copy if the
        original copy is not re-used.

        """
        return _typ.CovarianceMatrix_solveLinearSystemInPlace(self, *args)

    def solveLinearSystem(self, *args):
        r"""
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitly the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = [1.0] * 2
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.CovarianceMatrix_solveLinearSystem(self, *args)

    def __init__(self, *args):
        _typ.CovarianceMatrix_swiginit(self, _typ.new_CovarianceMatrix(*args))

    def __getitem__(self, args):
        return _typ.CovarianceMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.CovarianceMatrix___setitem__(self, args, valObj)
    __swig_destroy__ = _typ.delete_CovarianceMatrix

# Register CovarianceMatrix in _typ:
_typ.CovarianceMatrix_swigregister(CovarianceMatrix)
class CorrelationMatrix(CovarianceMatrix):
    r"""
    Correlation Matrix.

    Available constructors:
        CorrelationMatrix(*dim*)

        CorrelationMatrix(*dim, values*)

    Parameters
    ----------
    dim : integer
        The dimension of the correlation matrix (square matrix with *dim* rows and 
        *dim* columns).
    values : sequence of float
        Collection of :math:`dim^2` scalar values to put in the correlation matrix,
        filled by rows. When not specified, the correlation matrix is initialized to
        the identity matrix.

    See also
    --------
    CovarianceMatrix

    Notes
    -----
    In the first usage, the correlation matrix is the identity matrix.

    In the second usage, the correlation matrix contains the specified values,
    filled by rows.

    .. warning::

        No check is made on the values, in particular the diagonal elements are not
        forced to be equal to 1 and the positiveness of the matrix is not checked.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.CorrelationMatrix_getClassName(self)

    def __repr__(self):
        return _typ.CorrelationMatrix___repr__(self)

    def transpose(self):
        r"""
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.CorrelationMatrix_transpose(self)

    def __init__(self, *args):
        _typ.CorrelationMatrix_swiginit(self, _typ.new_CorrelationMatrix(*args))

    def __getitem__(self, args):
        return _typ.CorrelationMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.CorrelationMatrix___setitem__(self, args, valObj)

    def __mul__(self, *args):
        return _typ.CorrelationMatrix___mul__(self, *args)
    __swig_destroy__ = _typ.delete_CorrelationMatrix

# Register CorrelationMatrix in _typ:
_typ.CorrelationMatrix_swigregister(CorrelationMatrix)
class IdentityMatrix(CorrelationMatrix):
    r"""
    Identity matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.IdentityMatrix(2)
    >>> print(M)
    [[ 1 0 ]
     [ 0 1 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.IdentityMatrix_getClassName(self)

    def __repr__(self):
        return _typ.IdentityMatrix___repr__(self)

    def transpose(self):
        r"""
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.IdentityMatrix_transpose(self)

    def __mul__(self, *args):
        return _typ.IdentityMatrix___mul__(self, *args)

    def solveLinearSystem(self, *args):
        r"""
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitly the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = [1.0] * 2
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.IdentityMatrix_solveLinearSystem(self, *args)

    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        r"""
        Compute the logarithm of the absolute value of the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The logarithm of the absolute value of the square matrix determinant.
        sign : float
            The sign of the determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeLogAbsoluteDeterminant()
        [0.693147..., -1.0]
        """
        return _typ.IdentityMatrix_computeLogAbsoluteDeterminant(self, keepIntact)

    def computeDeterminant(self, keepIntact=True):
        r"""
        Compute the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The square matrix determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeDeterminant()
        -2.0
        """
        return _typ.IdentityMatrix_computeDeterminant(self, keepIntact)

    def computeEigenValues(self, keepIntact=True):
        r"""
        Compute eigenvalues.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.Point`
            Eigenvalues.

        See Also
        --------
        computeEV

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> print(M.computeEigenValues())
        [-4.70156,1.70156]
        """
        return _typ.IdentityMatrix_computeEigenValues(self, keepIntact)

    def computeEV(self, keepIntact=True):
        r"""
        Compute the eigenvalues decomposition (EVD).

        The eigenvalues decomposition of a square matrix :math:`\mat{M}` with
        size :math:`n` reads:

        .. math::

            \mat{M} = \mat{\Phi} \mat{\Lambda} \Tr{\mat{\Phi}}

        where :math:`\mat{\Lambda}` is an :math:`n \times n` diagonal matrix and
        :math:`\mat{\Phi}` is an :math:`n \times n` orthogonal matrix.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.Point`
            The vector of eigenvalues with size :math:`n` that form the diagonal of
            the :math:`n \times n` matrix :math:`\mat{\Lambda}` of the EVD.
        Phi : :class:`~openturns.SquareComplexMatrix`
            The left matrix of the EVD.

        Notes
        -----
        This uses LAPACK'S `DSYEV <http://www.netlib.org/lapack/lapack-3.1.1/html/dsyev.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> eigen_values, Phi = M.computeEV()
        >>> Lambda = ot.SquareMatrix(M.getDimension())
        >>> for i in range(eigen_values.getSize()):
        ...     Lambda[i, i] = eigen_values[i]
        >>> np.testing.assert_array_almost_equal(Phi * Lambda * Phi.transpose(), M)
        """
        return _typ.IdentityMatrix_computeEV(self, keepIntact)

    def isPositiveDefinite(self):
        r"""
        Test whether the matrix is positive definite or not.

        A matrix :math:`\mat{M}` is positive definite if :math:`\Tr{\vect{z}} \mat{M} \vect{z}`
        is positive for every compatible non-zero column vector :math:`\vect{z}`.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.IdentityMatrix_isPositiveDefinite(self)

    def computeCholesky(self, keepIntact=True):
        r"""
        Compute the Cholesky factor.

        The Cholesky factor of a covariance (real symmetric positive definite) matrix
        :math:`\mat{C}` is the lower triangular matrix :math:`\mat{L}` such that:

        .. math::

            \mat{C} = \mat{L} \Tr{\mat{L}}

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        cholesky_factor : :class:`~openturns.TriangularMatrix`
            The left (lower) Cholesky factor.
        """
        return _typ.IdentityMatrix_computeCholesky(self, keepIntact)

    def computeSingularValues(self, keepIntact=True):
        r"""
        Compute the singular values.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitly stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \times n_c` matrix
            :math:`\mat{\Sigma}` of the SVD decomposition.

        See also
        --------
        computeSVD

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M.computeSingularValues(True))
        [9.52552,0.514301]
        """
        return _typ.IdentityMatrix_computeSingularValues(self, keepIntact)

    def computeSVD(self, fullSVD=False, keepIntact=True):
        r"""
        Compute the singular values decomposition (SVD).

        The singular values decomposition of a rectangular matrix :math:`\mat{M}` with
        size :math:`n_r > n_c` reads:

        .. math::

            \mat{M} = \mat{U} \mat{\Sigma} \Tr{\mat{V}}

        where :math:`\mat{U}` is an :math:`n_r \times n_r` orthogonal matrix,
        :math:`\mat{\Sigma}` is an :math:`n_r \times n_c` diagonal matrix and
        :math:`\mat{V}` is an :math:`n_c \times n_c` orthogonal matrix.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitly stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \times n_c` matrix
            :math:`\mat{\Sigma}` of the SVD.
        U : :class:`~openturns.SquareMatrix`
            The left orthogonal matrix of the SVD.
        VT : :class:`~openturns.SquareMatrix`
            The transposed right orthogonal matrix of the SVD.

        Notes
        -----
        This uses LAPACK's `DGESDD <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesdd.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> singular_values, U, VT = M.computeSVD(True)
        >>> Sigma = ot.Matrix(M.getNbRows(), M.getNbColumns())
        >>> for i in range(singular_values.getSize()):
        ...     Sigma[i, i] = singular_values[i]
        >>> np.testing.assert_array_almost_equal(U * Sigma * VT, M)
        """
        return _typ.IdentityMatrix_computeSVD(self, fullSVD, keepIntact)

    def __init__(self, *args):
        _typ.IdentityMatrix_swiginit(self, _typ.new_IdentityMatrix(*args))

    @staticmethod
    def __setitem__(arg1, arg2):
        return _typ.IdentityMatrix___setitem__(arg1, arg2)
    __swig_destroy__ = _typ.delete_IdentityMatrix

# Register IdentityMatrix in _typ:
_typ.IdentityMatrix_swigregister(IdentityMatrix)
class _SampleImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _typ._SampleImplementationTypedInterfaceObject_swiginit(self, _typ.new__SampleImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _typ._SampleImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._SampleImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._SampleImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _typ._SampleImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _typ._SampleImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _typ.delete__SampleImplementationTypedInterfaceObject

# Register _SampleImplementationTypedInterfaceObject in _typ:
_typ._SampleImplementationTypedInterfaceObject_swigregister(_SampleImplementationTypedInterfaceObject)
class SampleCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete_SampleCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.SampleCollection_clear(self)

    def __len__(self):
        return _typ.SampleCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.SampleCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.SampleCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ.SampleCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ.SampleCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.SampleCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.SampleCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.SampleCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.SampleCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.SampleCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.SampleCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.SampleCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ.SampleCollection_find(self, val)

    def __repr__(self):
        return _typ.SampleCollection___repr__(self)

    def __str__(self, *args):
        return _typ.SampleCollection___str__(self, *args)

    def __init__(self, *args):
        _typ.SampleCollection_swiginit(self, _typ.new_SampleCollection(*args))

# Register SampleCollection in _typ:
_typ.SampleCollection_swigregister(SampleCollection)
OT_TYPECHECK_NUMERICALSAMPLE = _typ.OT_TYPECHECK_NUMERICALSAMPLE
class SampleImplementation(openturns.common.PersistentObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SampleImplementation_getClassName(self)
    CSV = _typ.SampleImplementation_CSV

    @staticmethod
    def BuildFromCSVFile(*args):
        return _typ.SampleImplementation_BuildFromCSVFile(*args)

    @staticmethod
    def BuildFromTextFile(*args):
        return _typ.SampleImplementation_BuildFromTextFile(*args)

    def __init__(self, *args):
        _typ.SampleImplementation_swiginit(self, _typ.new_SampleImplementation(*args))

    def data(self):
        return _typ.SampleImplementation_data(self)

    def elementSize(self):
        return _typ.SampleImplementation_elementSize(self)

    def setDescription(self, description):
        return _typ.SampleImplementation_setDescription(self, description)

    def getDescription(self):
        return _typ.SampleImplementation_getDescription(self)

    def __repr__(self):
        return _typ.SampleImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.SampleImplementation___str__(self, *args)

    def __eq__(self, rhs):
        return _typ.SampleImplementation___eq__(self, rhs)

    def contains(self, val):
        return _typ.SampleImplementation_contains(self, val)

    def getSize(self):
        return _typ.SampleImplementation_getSize(self)

    def getDimension(self):
        return _typ.SampleImplementation_getDimension(self)

    def add(self, *args):
        return _typ.SampleImplementation_add(self, *args)

    def stack(self, sample):
        return _typ.SampleImplementation_stack(self, sample)

    def computeMean(self):
        return _typ.SampleImplementation_computeMean(self)

    def computeCovariance(self):
        return _typ.SampleImplementation_computeCovariance(self)

    def computeStandardDeviation(self):
        return _typ.SampleImplementation_computeStandardDeviation(self)

    def computeLinearCorrelation(self):
        return _typ.SampleImplementation_computeLinearCorrelation(self)

    def computePearsonCorrelation(self):
        return _typ.SampleImplementation_computePearsonCorrelation(self)

    def computeSpearmanCorrelation(self):
        return _typ.SampleImplementation_computeSpearmanCorrelation(self)

    def computeKendallTau(self):
        return _typ.SampleImplementation_computeKendallTau(self)

    def computeRange(self):
        return _typ.SampleImplementation_computeRange(self)

    def computeMedian(self):
        return _typ.SampleImplementation_computeMedian(self)

    def computeVariance(self):
        return _typ.SampleImplementation_computeVariance(self)

    def computeSkewness(self):
        return _typ.SampleImplementation_computeSkewness(self)

    def computeKurtosis(self):
        return _typ.SampleImplementation_computeKurtosis(self)

    def computeCentralMoment(self, k):
        return _typ.SampleImplementation_computeCentralMoment(self, k)

    def computeRawMoment(self, k):
        return _typ.SampleImplementation_computeRawMoment(self, k)

    def computeQuantilePerComponent(self, *args):
        return _typ.SampleImplementation_computeQuantilePerComponent(self, *args)

    def computeQuantile(self, *args):
        return _typ.SampleImplementation_computeQuantile(self, *args)

    def computeEmpiricalCDF(self, point, tail=False):
        return _typ.SampleImplementation_computeEmpiricalCDF(self, point, tail)

    def getMax(self):
        return _typ.SampleImplementation_getMax(self)

    def getMin(self):
        return _typ.SampleImplementation_getMin(self)

    def rank(self, *args):
        return _typ.SampleImplementation_rank(self, *args)

    def sortInPlace(self):
        return _typ.SampleImplementation_sortInPlace(self)

    def sort(self, *args):
        return _typ.SampleImplementation_sort(self, *args)

    def sortAccordingToAComponent(self, index):
        return _typ.SampleImplementation_sortAccordingToAComponent(self, index)

    def sortAccordingToAComponentInPlace(self, index):
        return _typ.SampleImplementation_sortAccordingToAComponentInPlace(self, index)

    def sortUnique(self):
        return _typ.SampleImplementation_sortUnique(self)

    def sortUniqueInPlace(self):
        return _typ.SampleImplementation_sortUniqueInPlace(self)

    def argsort(self, isIncreasing=True):
        return _typ.SampleImplementation_argsort(self, isIncreasing)

    def getMarginal(self, *args):
        return _typ.SampleImplementation_getMarginal(self, *args)

    def select(self, indices):
        return _typ.SampleImplementation_select(self, indices)

    def __iadd__(self, *args):
        return _typ.SampleImplementation___iadd__(self, *args)

    def __isub__(self, *args):
        return _typ.SampleImplementation___isub__(self, *args)

    def __add__(self, *args):
        return _typ.SampleImplementation___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SampleImplementation___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.SampleImplementation___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SampleImplementation___truediv__(self, *args)
    __div__ = __truediv__



    def __imul__(self, *args):
        return _typ.SampleImplementation___imul__(self, *args)

    def __itruediv__(self, *args):
        return _typ.SampleImplementation___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def exportToCSVFile(self, *args):
        return _typ.SampleImplementation_exportToCSVFile(self, *args)
    __swig_destroy__ = _typ.delete_SampleImplementation

# Register SampleImplementation in _typ:
_typ.SampleImplementation_swigregister(SampleImplementation)

def __eq__(lhs, rhs):
    return _typ.__eq__(lhs, rhs)

def __mul__(*args):
    return _typ.__mul__(*args)
class Sample(_SampleImplementationTypedInterfaceObject):
    r"""
    Sample of real vectors.

    Available constructors:
        Sample(array)

        Sample(*size, dim*)

        Sample(*size, point*)

        Sample(*other, first, last*)

    Parameters
    ----------
    array : 2-d sequence of float
        The data
    size : int, :math:`m > 0`, optional
        The sample size.
        Default creates an empty sample with dimension 1.
    dimension : int, :math:`n \geq 0`, optional
        The real vectors dimension.
        Default creates an empty sample with dimension 1.
    point : :class:`~openturns.Point` or flat (1d) array, list or tuple of floats, optional
        The point that will be repeated along the sample.
        Default creates a sample filled with zeros (null vectors).
    other : :class:`~openturns.Sample`
        The sample contains points to copy.
    first : int, :math:`0 \leq first < m`
        The index of the first point to copy.
    last : int, :math:`first < last \leq m`, optional
        The index after the last point to copy.

    See Also
    --------
    ImportFromCSVFile, ImportFromTextFile

    Examples
    --------
    Create a Sample

    >>> import openturns as ot
    >>> import numpy as np
    >>> sample = ot.Sample(3, 2)
    >>> print(sample)
    0 : [ 0 0 ]
    1 : [ 0 0 ]
    2 : [ 0 0 ]
    >>> sample = ot.Sample(3, [1.0, 2.0])
    >>> print(sample)
    0 : [ 1 2 ]
    1 : [ 1 2 ]
    2 : [ 1 2 ]

    Create a Sample from a (2d) array, list or tuple

    >>> import numpy as np
    >>> sample = ot.Sample(np.array([(1.0, 2.0), (3.0, 4.0), (5.0, 6.0)]))

    and back

    >>> z = np.array(sample)

    Eventually samples may also be generated from probability distributions or
    experiments

    >>> random_sample = ot.Normal(2).getSample(10)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 10).generate()

    **Translation:** addition or subtraction of a (compatible) sample or a point, or a scalar which is promoted into a point of compatible dimension with equal components

    >>> print(sample + sample)
    0 : [  2  4 ]
    1 : [  6  8 ]
    2 : [ 10 12 ]
    >>> print(sample - sample)
    0 : [ 0 0 ]
    1 : [ 0 0 ]
    2 : [ 0 0 ]
    >>> print(sample - sample[0])
    0 : [ 0 0 ]
    1 : [ 2 2 ]
    2 : [ 4 4 ]
    >>> print(sample - sample[0, 0])
    0 : [ 0 1 ]
    1 : [ 2 3 ]
    2 : [ 4 5 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Sample_getClassName(self)

    @staticmethod
    def ImportFromCSVFile(*args):
        r"""
        Static method for building a sample from a CSV file.

        Parameters
        ----------
        file_name : str
            Path to CSV file.
        separator : str
            Separating string.
            Default uses `csv-file-separator` from the :class:`~openturns.ResourceMap`.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample loaded from the CSV file.

        Notes
        -----
        The file may or may not contain a header line (columns spanned with strings
        delimited with quotes). If it does contain such a header line, it will be
        used for setting the sample description using :py:meth:`setDescription`.

        The implementation follows the RFC 4180: https://tools.ietf.org/html/rfc4180.

        See Also
        --------
        exportToCSVFile

        Examples
        --------
        >>> import openturns as ot

        Let's first create a sample CSV file

        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> sample.exportToCSVFile('sample.csv')

        And load it back

        >>> loaded_sample = ot.Sample.ImportFromCSVFile('sample.csv')
        >>> assert sample == loaded_sample
        """
        return _typ.Sample_ImportFromCSVFile(*args)

    @staticmethod
    def ImportFromTextFile(*args):
        r"""
        Static method for building a sample from a text file.

        Parameters
        ----------
        file_name : str
            Path to text file.
        separator : str
            Separating string.
            Default uses a blank space.
        skipped_lines : int
            Number of lines skipped.
            Default is 0.
        numSeparator : str
            Decimal separator.
            Default is dot.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample loaded from the text file.

        Notes
        -----
        The file may or may not contain a header line (columns spanned with strings
        delimited with quotes). If it does contain such a header line, it will be
        used for setting the sample description using :py:meth:`setDescription`.
        It can also contain some comments, if a line starts with one of the
        characters contained in `Sample-CommentsMarker` from the :class:`~openturns.ResourceMap`.

        See Also
        --------
        exportToCSVFile

        Examples
        --------
        >>> import openturns as ot

        Let's first create a sample text file

        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> sample.exportToCSVFile('sample.txt', ' ')

        And load it back

        >>> loaded_sample = ot.Sample.ImportFromTextFile('sample.txt')
        >>> assert sample == loaded_sample
        """
        return _typ.Sample_ImportFromTextFile(*args)

    @staticmethod
    def BuildFromPoint(point):
        r"""
        Static method for building a sample from a sequence of float.

        Parameters
        ----------
        data : 1d array-like
            Data.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample generated from sequence

        Examples
        --------
        >>> import openturns as ot
        >>> n = 20
        >>> x = ot.Sample.BuildFromPoint(range(n))
        >>> data = [2.0, 2.0, 1.0, 1.0, 2.0, 3.0, 1.0, 2.0, 2.0, 1.0]
        >>> sample = ot.Sample.BuildFromPoint(data)
        """
        return _typ.Sample_BuildFromPoint(point)

    def exportToCSVFile(self, *args):
        r"""
        Dump the sample to a CSV file.

        Parameters
        ----------
        file_name : str
            Path to CSV file.
        separator : str
            Separating string.
            Default uses `csv-file-separator` from the :class:`~openturns.ResourceMap`.
        numSeparator : str, default='.'
            Decimal separator.
        precision : int
            Numerical precision
            Default takes `Sample-CSVPrecision` entry from :class:`~openturns.ResourceMap`.
        format : str
            Floating-point formatting, one of:

            - scientific: exponent notation
            - fixed: constant number of digits
            - defaultfloat: variable number of digits

            Default takes `Sample-CSVFormat` entry from :class:`~openturns.ResourceMap`.

        Notes
        -----
        This will create a header line with componentwise descriptions (obtained from
        :py:meth:`getDescription`) between quotes as column names.
        In scientific formatting the number of significant digits is :math:`precision + 1`.

        See Also
        --------
        ImportFromCSVFile, ImportFromTextFile

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> sample.exportToCSVFile('sample.csv', '; ')
        """
        return _typ.Sample_exportToCSVFile(self, *args)

    def __ne__(self, *args):
        return _typ.Sample___ne__(self, *args)

    def __baseaddress__(self):
        return _typ.Sample___baseaddress__(self)

    def __elementsize__(self):
        return _typ.Sample___elementsize__(self)

    def __contains__(self, val):
        return _typ.Sample___contains__(self, val)

    def erase(self, *args):
        r"""
        Erase point(s) at or between index(es) (in-place).

        Parameters
        ----------
        f : int, :math:`0 \leq f < m`
            The index of the first point to erase.
        l : int, :math:`f < l \leq m`, optional
            The index after the last point to erase.
            Default uses `l = f + 1` and only removes `sample[f]`.

        Examples
        --------
        >>> import openturns as ot
        >>> sample = ot.Sample([[i] for i in range(5)])
        >>> print(sample)
        0 : [ 0 ]
        1 : [ 1 ]
        2 : [ 2 ]
        3 : [ 3 ]
        4 : [ 4 ]
        >>> sample.erase(1, 3)
        >>> print(sample)
        0 : [ 0 ]
        1 : [ 3 ]
        2 : [ 4 ]
        """
        return _typ.Sample_erase(self, *args)

    def clear(self):
        r"""Erase all values."""
        return _typ.Sample_clear(self)

    def __repr__(self):
        return _typ.Sample___repr__(self)

    def __str__(self, *args):
        return _typ.Sample___str__(self, *args)

    def setDescription(self, description):
        r"""
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the sample's components.

        See Also
        --------
        getDescription
        """
        return _typ.Sample_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the sample's components.

        See Also
        --------
        setDescription
        """
        return _typ.Sample_getDescription(self)

    def getDimension(self):
        r"""
        Accessor to the sample's dimension.

        Returns
        -------
        n : int
            The number of components of the points in the sample.
        """
        return _typ.Sample_getDimension(self)

    def getSize(self):
        r"""
        Accessor to the sample size.

        Returns
        -------
        m : int
            The number points in the sample.
        """
        return _typ.Sample_getSize(self)

    def getMax(self):
        r"""
        Accessor to the componentwise maximum values.

        Returns
        -------
        maximum_values : :class:`~openturns.Point`
            Componentwise maximum values.
        """
        return _typ.Sample_getMax(self)

    def getMin(self):
        r"""
        Accessor to the componentwise minimum values.

        Returns
        -------
        minimum_values : :class:`~openturns.Point`
            Componentwise minimum values.
        """
        return _typ.Sample_getMin(self)

    def add(self, *args):
        r"""
        Append a sample (in-place).

        Parameters
        ----------
        point or sample : sequence or 2-d sequence of float
            The point(s) to append.

        Examples
        --------
        Append an existing sample with a single point.

        >>> import openturns as ot
        >>> sample = ot.Sample(3, 2)
        >>> sample.add([1.0, 2.0])
        >>> print(sample)
        0 : [ 0 0 ]
        1 : [ 0 0 ]
        2 : [ 0 0 ]
        3 : [ 1 2 ]

        Append an existing sample with another sample.

        >>> sample.add(ot.Sample(2, [2.0, 1.0]))
        >>> print(sample)
        0 : [ 0 0 ]
        1 : [ 0 0 ]
        2 : [ 0 0 ]
        3 : [ 1 2 ]
        4 : [ 2 1 ]
        5 : [ 2 1 ]
        """
        return _typ.Sample_add(self, *args)

    def stack(self, sample):
        r"""
        Stack (horizontally) the given sample to the current one (in-place).

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            Sample to stack with compatible size.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> another_sample = ot.Normal(2).getSample(3)
        >>> print(another_sample)
            [ X0        X1        ]
        0 : [ -0.355007  1.43725  ]
        1 : [  0.810668  0.793156 ]
        2 : [ -0.470526  0.261018 ]
        >>> sample.stack(another_sample)
        >>> print(sample)
            [ X0        X1        X0        X1        ]
        0 : [  0.608202 -1.26617  -0.355007  1.43725  ]
        1 : [ -0.438266  1.20548   0.810668  0.793156 ]
        2 : [ -2.18139   0.350042 -0.470526  0.261018 ]
        """
        return _typ.Sample_stack(self, sample)

    def asPoint(self):
        r"""
        Accessor to the internal linear storage for 1D sample.

        Returns
        -------
        values : :class:`~openturns.Point`
            Flat internal representation of the sample.

        Notes
        -----
        Available only for 1D sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal().getSample(5)
        >>> print(sample)
            [ X0        ]
        0 : [  0.608202 ]
        1 : [ -1.26617  ]
        2 : [ -0.438266 ]
        3 : [  1.20548  ]
        4 : [ -2.18139  ]
        >>> print(sample.asPoint())
        [0.608202,-1.26617,-0.438266,1.20548,-2.18139]

        """
        return _typ.Sample_asPoint(self)

    def split(self, index):
        r"""
        Trunk the sample.

        It splits the sample before the index passed as argument and returns the
        remainder as new sample.

        Parameters
        ----------
        index : int, :math:`0 \leq i < m`
            The truncation index.

        Returns
        -------
        remainder_sample : :class:`~openturns.Sample`
            The remainder sample (everything that comes after the truncation index).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> remainder_sample = sample.split(1)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        >>> print(remainder_sample)
            [ X0        X1        ]
        0 : [ -0.438266  1.20548  ]
        1 : [ -2.18139   0.350042 ]
        """
        return _typ.Sample_split(self, index)

    def computeMean(self):
        r"""
        Estimate the mean vector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean vector estimated from the sample.

        Notes
        -----
        The mean is estimated as follows:

        .. math::

            \vect{\widehat{\mu}} = \Tr{\left(\frac{1}{m}
                                             \sum_{j=1}^m x_i^{(j)},
                                             \quad i = 1, \ldots, n\right)}

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeMean())
        [-0.0512622,0.136653]
        """
        return _typ.Sample_computeMean(self)

    def computeCovariance(self):
        r"""
        Estimate the covariance matrix.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance matrix estimated from the sample.

        Notes
        -----
        The covariance matrix is estimated as follows:

        .. math::

            \mat{\widehat{\Sigma}} = \left[\frac{1}{m - 1}
                                           \sum_{k=1}^m
                                           \left(x_i^{(k)} - \widehat{\mu}_i\right)
                                           \left(x_j^{(k)} - \widehat{\mu}_j\right),
                                           \quad i, j = 1, \ldots, n\right]

        where :math:`\vect{\widehat{\mu}}` denotes the estimate of the mean.

        This is an unbiased estimator.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeCovariance())
        [[ 0.946682  0.0182104 ]
         [ 0.0182104 0.903226  ]]
        """
        return _typ.Sample_computeCovariance(self)

    def computeStandardDeviation(self):
        r"""
        Estimate the componentwise standard deviations.

        Returns
        -------
        standard_deviations : :class:`~openturns.Point`
            Componentwise standard deviation estimated from the sample.

        Notes
        -----
        The componentwise standard deviations are estimated as the square root of the
        componentwise variances.

        See Also
        --------
        computeVariance

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeStandardDeviation())
        [0.972976,0.950382]
        """
        return _typ.Sample_computeStandardDeviation(self)

    def computeVariance(self):
        r"""
        Estimate the componentwise variances.

        Returns
        -------
        variances : :class:`~openturns.Point`
            Componentwise variances estimated from the sample.

        Notes
        -----
        The componentwise variances are estimated as follows:

        .. math::

            \vect{\widehat{\sigma^2}} = \Tr{\left(\frac{1}{m-1}
                                                  \sum_{j=1}^m
                                                  \left(x_i^{(j)} - \widehat{\mu}_i\right)^2,
                                                  \quad i = 1, \ldots, n\right)}

        where :math:`\vect{\widehat{\mu}}` is the estimate of the mean.

        This estimator is unbiased.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeVariance())
        [0.946682,0.903226]
        """
        return _typ.Sample_computeVariance(self)

    def computeLinearCorrelation(self):
        r"""**(ditch me?)**"""
        return _typ.Sample_computeLinearCorrelation(self)

    def computePearsonCorrelation(self):
        r"""
        Estimate the Pearson correlation matrix.

        Returns
        -------
        rho : :class:`~openturns.CorrelationMatrix`
            Pearson correlation matrix estimated from the sample.

        Notes
        -----
        The Pearson correlation matrix is estimated as follows:

        .. math::

            \mat{\widehat{\rho}} = \left[\frac{\widehat{\Sigma}_{i,j}}
                                              {\widehat{\Sigma}_{i,i} \widehat{\Sigma}_{j,j}},
                                         \quad i,j = 1, \ldots, n\right]

        where :math:`\mat{\widehat{\Sigma}}` denotes the estimate of the covariance.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computePearsonCorrelation())
        [[ 1         0.0196933 ]
         [ 0.0196933 1         ]]
        """
        return _typ.Sample_computePearsonCorrelation(self)

    def computeSpearmanCorrelation(self):
        r"""
        Estimate the Spearman correlation matrix.

        Returns
        -------
        rho : :class:`~openturns.CorrelationMatrix`
            Spearman correlation matrix estimated from the sample.

        Notes
        -----
        The Spearman correlation matrix is estimated as the Pearson correlation matrix
        of the ranks sample (i.e. using `self.rank().computePearsonCorrelation()`).

        See Also
        --------
        rank, computePearsonCorrelation

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeSpearmanCorrelation())
        [[  1          -0.00556174 ]
         [ -0.00556174  1          ]]
        """
        return _typ.Sample_computeSpearmanCorrelation(self)

    def computeKendallTau(self):
        r"""
        Estimate the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix estimated from the sample.

        Notes
        -----
        This uses an external implementation provided under the Boost Software License
        by David Simcha based on the paper by [knight1966]_. It actually switches
        between two implementations depending on the sample size:

            - The most basic implementation performing in :math:`O(m^2)` is used when
              the sample size is less than `SampleImplementation-SmallKendallTau`
              from the :class:`~openturns.ResourceMap`.
            - The other more complex implementation performing in :math:`O(m\log(m))`
              is used for larger samples.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeKendallTau())
        [[ 1          0.00689655 ]
         [ 0.00689655 1          ]]
        """
        return _typ.Sample_computeKendallTau(self)

    def computeRange(self):
        r"""
        Compute the range per component.

        Returns
        -------
        range : :class:`~openturns.Point`
            Componentwise ranges estimated from the sample.

        Notes
        -----
        The *statistical range* is defined as the deviation between the maximal and
        the minimal value of the sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeRange())
        [4.02827,3.49949]
        """
        return _typ.Sample_computeRange(self)

    def computeMedian(self):
        r"""
        Estimate the componentwise medians (50%-quantiles).

        Returns
        -------
        median : :class:`~openturns.Point`
            Median vector estimated from the sample.

        See Also
        --------
        computeQuantilePerComponent

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeMedian())
        [0.221141,0.108703]
        """
        return _typ.Sample_computeMedian(self)

    def computeSkewness(self):
        r"""
        Estimate the componentwise skewness (3rd order central normalized moment).

        Returns
        -------
        skewness : :class:`~openturns.Point`
            Componentwise skewness estimated from the sample.

        Notes
        -----
        The componentwise skewnesses are estimated as follows:

        .. math::

            \vect{\widehat{\delta}} = \Tr{\left(m \frac{\sqrt{m-1}}{m-2}
                                                \frac{\sum_{j=1}^m
                                                      \left(x_i^{(j)} - \widehat{\mu}_i\right)^3}
                                                     {\left(\sum_{j=1}^m
                                                            \left(x_i^{(j)} - \widehat{\mu}_i\right)^2
                                                      \right)^{3/2}},
                                                \quad i = 1, \ldots, n\right)}

        where :math:`\vect{\widehat{\mu}}` is the estimate of the mean.

        This is an unbiased estimator.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeSkewness())
        [-0.69393,0.231931]
        """
        return _typ.Sample_computeSkewness(self)

    def computeKurtosis(self):
        r"""
        Estimate the componentwise kurtosis (4th order central normalized moment).

        Returns
        -------
        kurtosis : :class:`~openturns.Point`
            Componentwise kurtosis estimated from the sample.

        Notes
        -----
        The componentwise kurtosis are estimated as follows:

        .. math::

            \vect{\widehat{\kappa}} = \Tr{\left(\frac{m (m-1) (m+1)}{(m-2) (m-3)}
                                                \frac{\sum_{j=1}^m
                                                      \left(x_i^{(j)} - \widehat{\mu}_i\right)^4}
                                                     {\left(\sum_{j=1}^m
                                                            \left(x_i^{(j)} - \widehat{\mu}_i\right)^2
                                                      \right)^2}
                                                - 3 \frac{3 (m-5)}{(m-2) (m-3)},
                                                \quad i = 1, \ldots, n\right)}

        where :math:`\vect{\widehat{\mu}}` is the estimate of the mean.

        This estimator is unbiased.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeKurtosis())
        [3.27647,2.40275]
        """
        return _typ.Sample_computeKurtosis(self)

    def computeCentralMoment(self, k):
        r"""
        Estimate componentwise central moments.

        Parameters
        ----------
        k : int
            The central moment's order.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order :math:`k` estimated from the sample.

        Notes
        -----
        The central moment of order :math:`k` is estimated as follows:

        .. math::

            \vect{\widehat{m}}^{(k)}_0 = \Tr{\left(\frac{1}{m}
                                                   \sum_{j=1}^m
                                                   \left(x_i^{(j)} - \widehat{\mu}_i\right)^k,
                                                   \quad i = 1, \ldots, n\right)}

        where :math:`\vect{\widehat{\mu}}` is the estimator of the mean.

        These estimators are the natural (possibly biased) estimators.
        For unbiased estimators use the other dedicated methods such as
        :py:meth:`computeVariance` for the variance.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeCentralMoment(2))
        [0.915126,0.873119]
        """
        return _typ.Sample_computeCentralMoment(self, k)

    def computeRawMoment(self, k):
        r"""
        Compute the raw (non-central) moment per component.

        Parameters
        ----------
        k : int, :math:`k \geq 0`
            Componentwise moment's order.

        Returns
        -------
        moments : :class:`~openturns.Point`
            Componentwise moments estimated from the sample.

        Notes
        -----
        The (raw) moment of order :math:`k` is estimated as follows:

        .. math::

            \vect{\widehat{m}}^{(k)} = \Tr{\left(\frac{1}{m}
                                                 \sum_{j=1}^m {x_i^{(j)}}^k,
                                                 \quad i = 1, \ldots, n\right)}

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeRawMoment(2))
        [0.917754,0.891793]
        """
        return _typ.Sample_computeRawMoment(self, k)

    def computeQuantilePerComponent(self, *args):
        r"""
        Estimate the componentwise quantiles.

        Parameters
        ----------
        p : float, :math:`0 \leq p \leq 1`, or sequence of float
            Input probability level.

        Returns
        -------
        quantile : :class:`~openturns.Point` or :class:`~openturns.Sample`
            Componentwise quantile at probability level :math:`p`, estimated from the
            sample.

        Notes
        -----
        The present implementation interpolates the quantile between the two adjacent
        empirical quantiles (:math:`\widehat{x}_i^-` and :math:`\widehat{x}_i^+`):

        .. math::

            \widehat{q}_i = \alpha \widehat{x}_i^- + (1 - \alpha) \widehat{x}_i^+

        where :math:`\alpha = p m - 0.5`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeQuantilePerComponent(0.2))
        [-0.696412,-0.767092]
        """
        return _typ.Sample_computeQuantilePerComponent(self, *args)

    def computeQuantile(self, *args):
        r"""
        Estimate the quantile of the joint distribution underlying the sample.

        Parameters
        ----------
        p : float, :math:`0 \leq p \leq 1`, or sequence of float
            Input probability level.

        Returns
        -------
        quantile : :class:`~openturns.Point` or :class:`~openturns.Sample`
            Quantile of the **joint** distribution at probability level :math:`p`,
            estimated from the sample.

        Raises
        ------
        NotImplementedYetError : If the dimension is greater than 1.

        See Also
        --------
        computeQuantilePerComponent

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(1).getSample(30)
        >>> print(sample.computeQuantile(.2))
        [-0.947394]
        """
        return _typ.Sample_computeQuantile(self, *args)

    def computeEmpiricalCDF(self, point, tail=False):
        r"""
        Estimate the empirical cumulative distribution function (ECDF).

        Parameters
        ----------
        x : sequence of float
            CDF input.
        survival : bool, optional
            A flag telling whether this should estimate the empirical cumulative
            distribution function or the empirical survival function.
            Default is `False` and estimates the CDF.

        Returns
        -------
        p : float, :math:`0 \leq p \leq 1`
            Empirical CDF or SF value at point x.

        Notes
        -----
        The empirical cumulative distribution function (CDF) is estimated as follows:

        .. math::

            \hat{F}(\vect{x}) = \frac{1}{m} \sum_{j=1}^m
                                \mathbf{1}_{\cap_{i=1}^n x_i^{(j)} \leq x_i}(\vect{x})

        The empirical survival function (SF) is estimated in a similar way:

        .. math::

            \hat{S}(\vect{x}) = \frac{1}{m} \sum_{j=1}^m
                                \mathbf{1}_{\cap_{i=1}^n x_i^{(j)} > x_i}(\vect{x})

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeEmpiricalCDF(sample[0]))
        0.1
        """
        return _typ.Sample_computeEmpiricalCDF(self, point, tail)

    def find(self, point):
        r"""
        Get the position of a point in the sample.

        Parameters
        ----------
        point : sequence of float
            The wanted point.

        Returns
        -------
        index : int,
            Returns :math:`m` if the point does not belong to the sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.find(sample[10]))
        10
        >>> print(sample.find([0.0, 0.0]))
        30
        """
        return _typ.Sample_find(self, point)

    def __add__(self, *args):
        return _typ.Sample___add__(self, *args)

    def __sub__(self, *args):
        return _typ.Sample___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.Sample___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.Sample___truediv__(self, *args)
    __div__ = __truediv__



    def __imul__(self, *args):
        return _typ.Sample___imul__(self, *args)

    def __itruediv__(self, *args):
        return _typ.Sample___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def rank(self, *args):
        r"""
        Compute the sample (componentwise) ranks.

        Parameters
        ----------
        marginal_index : int, :math:`0 \leq i < n`, optional
            The component whose ranks are wanted.
            Default computes the ranks of all the components.

        Notes
        -----
        The ranks of a 1d sample is a list of indices that sorts the points in the
        ascending order. Ties (equal points) are averaged.

        Returns
        -------
        ranks : :class:`~openturns.Sample`
            The requested ranks.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> print(sample.rank())
            [ X0 X1 ]
        0 : [ 2  0  ]
        1 : [ 1  2  ]
        2 : [ 0  1  ]
        """
        return _typ.Sample_rank(self, *args)

    def sortInPlace(self):
        r"""
        Sort the sample in place.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> sample.sortInPlace()
        >>> print(sample)
            [ X0        X1        ]
        0 : [ -2.18139   0.350042 ]
        1 : [ -0.438266  1.20548  ]
        2 : [  0.608202 -1.26617  ]
        """
        return _typ.Sample_sortInPlace(self)

    def sort(self, *args):
        r"""
        Sort the sample.

        The ordering is based on the comparison operator of the :class:`~openturns.Point`. 
        Hence, the `sort` method orders the points in the sample 
        according to lexicographic order. 

        Parameters
        ----------
        marginal_index : int, :math:`0 \leq i < n`, optional
            The index of the component to sort.
            Default sorts the whole sample, i.e. the returned sorted sample has 
            the same dimension as the input sample.
            If `marginal_index` is provided, then the returned sorted sample has dimension 1: 
            the corresponding marginal sample is sorted and returned.

        Returns
        -------
        sorted_sample : :class:`~openturns.Sample`
            The requested sorted sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> print(sample.sort())
            [ X0        X1        ]
        0 : [ -2.18139   0.350042 ]
        1 : [ -0.438266  1.20548  ]
        2 : [  0.608202 -1.26617  ]
        >>> print(sample.sort(1))
        0 : [ -1.26617  ]
        1 : [  0.350042 ]
        2 : [  1.20548  ]

        In the following sample, the first component of all points is equal to -1, 
        which creates a tie where the other components must be used to make 
        a difference in the comparison. 
        The algorithm sorts the points taking into account all the components in the 
        points. 
        This shows that the algorithm uses lexicographic ordering, since using only 
        the first component would leave the sample unchanged.

        >>> import openturns as ot
        >>> sample = ot.Sample(
        ...     [[-1.0, 1.0, 1.0], [-1.0, 1.0, 0.0], [-1.0, 0.0, 1.0], [-1.0, 0.0, -1.0]]
        ... )
        >>> print(sample)
        0 : [ -1  1  1 ]
        1 : [ -1  1  0 ]
        2 : [ -1  0  1 ]
        3 : [ -1  0 -1 ]
        >>> print(sample.sort())
        0 : [ -1  0 -1 ]
        1 : [ -1  0  1 ]
        2 : [ -1  1  0 ]
        3 : [ -1  1  1 ]
        """
        return _typ.Sample_sort(self, *args)

    def sortAccordingToAComponent(self, index):
        r"""
        Sort the sample according to the given component.

        Parameters
        ----------
        marginal_index : int, :math:`0 \leq i < n`
            The component to use for sorting the sample.

        Returns
        -------
        sorted_sample : :class:`~openturns.Sample`
            The sample sorted according to the given component.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> print(sample.sortAccordingToAComponent(0))
            [ X0        X1        ]
        0 : [ -2.18139   0.350042 ]
        1 : [ -0.438266  1.20548  ]
        2 : [  0.608202 -1.26617  ]
        """
        return _typ.Sample_sortAccordingToAComponent(self, index)

    def sortAccordingToAComponentInPlace(self, index):
        r"""
        Sort the sample in place according to the given component.

        Parameters
        ----------
        marginal_index : int, :math:`0 \leq i < n`
            The component to use for sorting the sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> sample.sortAccordingToAComponentInPlace(0)
        >>> print(sample)
            [ X0        X1        ]
        0 : [ -2.18139   0.350042 ]
        1 : [ -0.438266  1.20548  ]
        2 : [  0.608202 -1.26617  ]
        """
        return _typ.Sample_sortAccordingToAComponentInPlace(self, index)

    def sortUnique(self):
        r"""
        Sort the sample and remove duplicate points.

        Returns
        -------
        unique_sample : :class:`~openturns.Sample`
            The requested sorted sample with duplicate points removed.

        Examples
        --------
        >>> import openturns as ot
        >>> sample = ot.Sample([[3, 0, 3], [1, 1, 0], [0, 2, 2], [1, 1, 0]])
        >>> print(sample)
        0 : [ 3 0 3 ]
        1 : [ 1 1 0 ]
        2 : [ 0 2 2 ]
        3 : [ 1 1 0 ]
        >>> print(sample.sortUnique())
        0 : [ 0 2 2 ]
        1 : [ 1 1 0 ]
        2 : [ 3 0 3 ]
        """
        return _typ.Sample_sortUnique(self)

    def sortUniqueInPlace(self):
        r"""
        Sort the sample in place and remove duplicate points.

        Examples
        --------
        >>> import openturns as ot
        >>> sample = ot.Sample([[3, 0, 3], [1, 1, 0], [0, 2, 2], [1, 1, 0]])
        >>> print(sample)
        0 : [ 3 0 3 ]
        1 : [ 1 1 0 ]
        2 : [ 0 2 2 ]
        3 : [ 1 1 0 ]
        >>> sample.sortUniqueInPlace()
        >>> print(sample)
        0 : [ 0 2 2 ]
        1 : [ 1 1 0 ]
        2 : [ 3 0 3 ]
        """
        return _typ.Sample_sortUniqueInPlace(self)

    def argsort(self, isIncreasing=True):
        r"""
        Returns indices of sorted sample.

        The algorithm sorts the points in the sample in the lexicographic order. 

        Returns
        -------
        indices : :class:`~openturns.Indices`
            The indices which sorts the sample.
        isIncreasing : bool, optional
            If `True`, sort in increasing order.
            If `False`, sort in decreasing order.
            Default is `True`.

        Examples
        --------
        >>> import openturns as ot
        >>> sample = ot.Sample(
        ...     [[-1.0, 1.0, 0.0], [-1.0, 1.0, 1.0], [-1.0, 0.0, 1.0], [-1.0, 0.0, -1.0]]
        ... )
        >>> print(sample)
        0 : [ -1  1  0 ]
        1 : [ -1  1  1 ]
        2 : [ -1  0  1 ]
        3 : [ -1  0 -1 ]
        >>> indices = sample.argsort()
        >>> print(indices)
        [3,2,0,1]
        >>> print(sample[indices])
            [ v0 v1 v2 ]
        0 : [ -1  0 -1 ]
        1 : [ -1  0  1 ]
        2 : [ -1  1  0 ]
        3 : [ -1  1  1 ]
        >>> indices = sample.argsort(False)
        >>> print(indices)
        [1,0,2,3]
        """
        return _typ.Sample_argsort(self, isIncreasing)

    def getMarginal(self, *args):
        r"""
        Accessor to sample marginal(s) (column(s)).

        Parameters
        ----------
        indices : int, sequence of int, :math:`0 \leq i < n` or sequence of str
            The identifiers of the wanted marginal(s).
            When the description contains duplicate labels, the first marginal is picked up.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A subsample of the present sample with the requested marginal(s).

        Notes
        -----
        The :class:`~openturns.Sample` also implements slicing in its
        `__getitem__` method.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(10).getSample(3)
        >>> print(sample.getMarginal([1, 4]))
            [ X1        X4        ]
        0 : [ -1.26617  -2.18139  ]
        1 : [  0.261018 -1.31178  ]
        2 : [  0.445785  0.473617 ]
        """
        return _typ.Sample_getMarginal(self, *args)

    def select(self, indices):
        r"""
        Select points in a sample.

        It selects the points at given locations and returns them as a new sample.

        Parameters
        ----------
        indices : sequence of int, :math:`0 \leq i < m`
            The selected indices.

        Returns
        -------
        selected_sample : :class:`~openturns.Sample`
            The selected points as a sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> selected_sample = sample.select([1, 0, 1])
        >>> print(selected_sample)
            [ X0        X1        ]
        0 : [ -0.438266  1.20548  ]
        1 : [  0.608202 -1.26617  ]
        2 : [ -0.438266  1.20548  ]

        """
        return _typ.Sample_select(self, indices)

    def __len__(self):
        return _typ.Sample___len__(self)

    def __getitem__(self, *args):
        return _typ.Sample___getitem__(self, *args)

    def __setitem__(self, *args):
        return _typ.Sample___setitem__(self, *args)

    def __init__(self, *args):
        _typ.Sample_swiginit(self, _typ.new_Sample(*args))

    def __eq__(self, *args):
        return _typ.Sample___eq__(self, *args)

    def __iadd__(self, *args):
        return _typ.Sample___iadd__(self, *args)

    def __isub__(self, *args):
        return _typ.Sample___isub__(self, *args)

    def __rmul__(self, s):
        return _typ.Sample___rmul__(self, s)
    __swig_destroy__ = _typ.delete_Sample

# Register Sample in _typ:
_typ.Sample_swigregister(Sample)

# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the Sample (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def __Sample_getattribute(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getSize(), self.getDimension()),
                                                'typestr': "|f" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__() or 1), True),
                                                'version': 3, 
                                                }
    return super(Sample, self).__getattribute__(name)
Sample.__getattribute__ = __Sample_getattribute

def __Sample_asDataFrame(self):
    """
    Convert to pandas DataFrame.

    Returns
    -------
    df : pandas DataFrame
        The converted data
    """
    from pandas import DataFrame
    df = DataFrame.from_records(self, columns=list(self.getDescription()))
    return df
Sample.asDataFrame = __Sample_asDataFrame

def __Sample_BuildFromDataFrame(df):
    """
    Convert a pandas DataFrame to Sample.

    Parameters
    ----------
    df : pandas DataFrame
        The data to convert

    Returns
    -------
    sample : :class:`~openturns.Sample`
        The converted sample
    """
    sample = openturns.Sample(df.values)
    sample.setDescription(df.columns)
    return sample
Sample.BuildFromDataFrame = __Sample_BuildFromDataFrame



def __Sample_repr_html(self):
    """Get HTML representation."""
    html = '<table>\n'
    desc = self.getDescription()
    ell_threshold = openturns.common.ResourceMap.GetAsUnsignedInteger("Sample-PrintEllipsisThreshold")
    ell_size = openturns.common.ResourceMap.GetAsUnsignedInteger("Sample-PrintEllipsisSize")
    size = self.getSize()
    dim = self.getDimension()
    ellipsis = size * dim > ell_threshold
    if not desc.isBlank():
        if ellipsis and dim > 2 * ell_size:
            html += '  <tr><th></th><th>'
            html += '</th><th>'.join(desc[0:ell_size])
            html += f'</th><th colspan="{dim - 2 * ell_size}">...</th><th>'
            html += '</th><th>'.join(desc[-ell_size:])
            html += '</th></tr>\n'
        else:
            html += '  <tr><td></td><th>' + '</th><th>'.join(desc) + '</th></tr>\n'
    for i in range(size):
        if ellipsis and size > 2 * ell_size:
            if i == ell_size:
                html += f'<tr><td colspan="{dim + 1}">...</td></tr>\n'
                continue
            else:
                if i > ell_size and i < size - ell_size:
                    continue
# Write row
        fmt = openturns.common.ResourceMap.GetAsString("Sample-PrintFormat")
        if ellipsis and dim > 2 * ell_size:
            html += '  <tr><th>' + str(i)
            if dim > 0:
                html += '</th><td>'
            html += '</td><td>'.join([fmt.format(x) for x in self[i, 0:ell_size]])
            html += f'<td colspan="{dim - 2 * ell_size}">...</td><td>'
            html += '</td><td>'.join([fmt.format(x) for x in self[i, -ell_size:]])
            html += '</td></tr>\n'
        else:
            html += '  <tr><th>' + str(i)
            if dim > 0:
                html += '</th><td>' + '</td><td>'.join([fmt.format(x) for x in self[i]])
            html += '</td></tr>\n'
    html += '</table>'
    return html

Sample._repr_html_ = __Sample_repr_html

class DomainImplementation(openturns.common.PersistentObject):
    r"""
    Base class for domain objects.

    Notes
    -----
    A Domain object can be created through its derived classes:

    - :class:`~openturns.Interval`

    - :class:`~openturns.MeshDomain`

    - :class:`~openturns.LevelSet`

    - :class:`~openturns.DomainUnion`

    - :class:`~openturns.DomainDisjunctiveUnion`

    - :class:`~openturns.DomainIntersection`

    - :class:`~openturns.DomainComplement`

    - :class:`~openturns.DomainDifference`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.DomainImplementation_getClassName(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point or sample : sequence of float or 2-d sequence of float
            Point or Sample with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool or sequence of bool
            Flag telling whether the given point is inside of the domain.
        """
        return _typ.DomainImplementation_contains(self, *args)

    def computeDistance(self, *args):
        r"""
        Compute the Euclidean distance of a given point to the domain.

        Parameters
        ----------
        point or sample : sequence of float or 2-d sequence of float
            Point or Sample with the same dimension as the current domain's dimension.

        Returns
        -------
        distance : float or Sample
            Euclidean distance of the point to the domain.
        """
        return _typ.DomainImplementation_computeDistance(self, *args)

    def __repr__(self):
        return _typ.DomainImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.DomainImplementation___str__(self, *args)

    def getDimension(self):
        r"""
        Get the dimension of the domain.

        Returns
        -------
        dim : int
            Dimension of the domain.
        """
        return _typ.DomainImplementation_getDimension(self)

    def __init__(self, *args):
        _typ.DomainImplementation_swiginit(self, _typ.new_DomainImplementation(*args))
    __swig_destroy__ = _typ.delete_DomainImplementation

# Register DomainImplementation in _typ:
_typ.DomainImplementation_swigregister(DomainImplementation)

DomainImplementation.__contains__ = DomainImplementation.contains

class Interval(DomainImplementation):
    r"""
    Numerical interval.

    Available constructors:
        Interval(*dim=0*)

        Interval(*lowerBound, upperBound, finiteLowerBound=[True]*dim, finiteUpperBound=[True]*dim*)

    Parameters
    ----------
    dim : int, :math:`dim \geq 0`
        Dimension of the interval. If only *dim* is mentioned, it leads to create
        the finite interval :math:`[0, 1]^{dim}`.
        By default, an empty interval is created.
    lowerBound, upperBound : float or sequence of float of dimension *dim*
        Define an interval
        :math:`[lowerBound_0, upperBound_0]\times \dots \times [lowerBound_{dim-1}, upperBound_{dim-1}]`.
        It is allowed to have :math:`lowerBound_i \geq upperBound_i` for some
        :math:`i`: it simply defines an empty interval.
        The *lowerBound* and the *upperBound* must be of the same type. If
        *finiteLowerBound* and *finiteUpperBound* are mentioned, they must be
        sequences.
    finiteLowerBound : sequence of bool of dimension *dim*
        Flags telling for each component of the lower bound whether it is finite or
        not.
    finiteUpperBound : sequence of bool of dimension *dim*
        Flags telling for each component of the upper bound whether it is finite or
        not.

    Notes
    -----
    The meaning of a flag is: if flag :math:`i` is *True*, the corresponding
    component of the given bound is finite and its value is given by bound
    :math:`i`. If not, the corresponding component is infinite and its value is
    either :math:`-\infty` if bound :math:`i < 0` or :math:`+\infty` if bound
    :math:`i \geq 0`.

    It is possible to add or subtract two intervals and multiply an interval by a
    scalar.

    Examples
    --------
    >>> import openturns as ot
    >>> # A finite interval
    >>> print(ot.Interval([2.0, 3.0], [4.0, 5.0]))
    [2, 4]
    [3, 5]
    >>> # Not finite intervals
    >>> a = 2.0
    >>> print(ot.Interval([a], [1], [True], [False]))
    [2, (1) +inf[
    >>> print(ot.Interval([1], [a], [False], [True]))
    ]-inf (1), 2]
    >>> # Operations with intervals:
    >>> interval1 = ot.Interval([2.0, 3.0], [5.0, 8.0])
    >>> interval2 = ot.Interval([1.0, 4.0], [6.0, 13.0])
    >>> # Addition
    >>> print(interval1 + interval2)
    [3, 11]
    [7, 21]
    >>> # Subtraction
    >>> print(interval1 - interval2)
    [-4, 4]
    [-10, 4]
    >>> # Multiplication
    >>> print(interval1 * 3)
    [6, 15]
    [9, 24]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Interval_getClassName(self)

    def isEmpty(self):
        r"""
        Check if the interval is empty.

        Returns
        -------
        isEmpty : bool
            *True* if the interior of the interval is empty.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([1.0, 2.0], [1.0, 2.0])
        >>> interval.setFiniteLowerBound([True, False])
        >>> print(interval.isEmpty())
        False
        """
        return _typ.Interval_isEmpty(self)

    def isNumericallyEmpty(self):
        r"""
        Check if the interval is numerically empty.

        Returns
        -------
        isEmpty : bool
            Flag telling whether the interval is numerically empty, i.e. if its numerical
            volume is inferior or equal to :math:`\epsilon` (defined in the
            :class:`~openturns.ResourceMap`:
            :math:`\epsilon` = Domain-SmallVolume).

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([1.0, 2.0], [1.0, 2.0])
        >>> print(interval.isNumericallyEmpty())
        True
        """
        return _typ.Interval_isNumericallyEmpty(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point or sample : sequence of float or 2-d sequence of float
            Point or Sample with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool or sequence of bool
            Flag telling whether the given point is inside of the domain.
        """
        return _typ.Interval_contains(self, *args)

    def computeDistance(self, *args):
        r"""
        Compute the Euclidean distance of a given point to the domain.

        Parameters
        ----------
        point or sample : sequence of float or 2-d sequence of float
            Point or Sample with the same dimension as the current domain's dimension.

        Returns
        -------
        distance : float or Sample
            Euclidean distance of the point to the domain.
        """
        return _typ.Interval_computeDistance(self, *args)

    def numericallyContains(self, point):
        r"""
        Check if the given point is inside of the discretization of the interval.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside the interval bounds, not taking
            into account whether bounds are finite or not.
        """
        return _typ.Interval_numericallyContains(self, point)

    def intersect(self, other):
        r"""
        Get the intersection with another interval.

        Parameters
        ----------
        otherInterval : :class:`~openturns.Interval`
            Interval of the same dimension.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            An interval corresponding to the intersection of the current interval with
            *otherInterval*.

        Examples
        --------
        >>> import openturns as ot
        >>> interval1 = ot.Interval([2.0, 3.0], [5.0, 8.0])
        >>> interval2 = ot.Interval([1.0, 4.0], [6.0, 13.0])
        >>> print(interval1.intersect(interval2))
        [2, 5]
        [4, 8]
        """
        return _typ.Interval_intersect(self, other)

    def join(self, other):
        r"""
        Get the smallest interval containing both the current interval and another one.

        Parameters
        ----------
        otherInterval : :class:`~openturns.Interval`
            Interval of the same dimension.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Smallest interval containing both the current interval and
            *otherInterval*.

        Examples
        --------
        >>> import openturns as ot
        >>> interval1 = ot.Interval([2.0, 3.0], [5.0, 8.0])
        >>> interval2 = ot.Interval([1.0, 4.0], [6.0, 13.0])
        >>> print(interval1.join(interval2))
        [1, 6]
        [3, 13]
        """
        return _typ.Interval_join(self, other)

    def getMarginal(self, *args):
        r"""
        Marginal accessor.

        Parameters
        ----------
        index : int or sequence of int
            Index or indices of the selected components.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            The marginal interval.
        """
        return _typ.Interval_getMarginal(self, *args)

    def __add__(self, rhs):
        return _typ.Interval___add__(self, rhs)

    def __sub__(self, rhs):
        return _typ.Interval___sub__(self, rhs)

    def __iadd__(self, other):
        return _typ.Interval___iadd__(self, other)

    def __isub__(self, other):
        return _typ.Interval___isub__(self, other)

    def __mul__(self, scalar):
        return _typ.Interval___mul__(self, scalar)

    def __imul__(self, scalar):
        return _typ.Interval___imul__(self, scalar)

    def __eq__(self, *args):
        return _typ.Interval___eq__(self, *args)

    def __ne__(self, *args):
        return _typ.Interval___ne__(self, *args)

    def getVolume(self):
        r"""
        Get the volume of the interval.

        Returns
        -------
        volume : float
            Volume contained within interval bounds.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getVolume())
        4.0
        """
        return _typ.Interval_getVolume(self)

    def getLowerBound(self):
        r"""
        Get the lower bound.

        Returns
        -------
        lowerBound : :class:`~openturns.Point`
            Value of the lower bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getLowerBound())
        [2,3]
        """
        return _typ.Interval_getLowerBound(self)

    def setLowerBound(self, lowerBound):
        r"""
        Set the lower bound.

        Parameters
        ----------
        lowerBound : sequence of float
            Value of the lower bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setLowerBound([-4, -5])
        >>> print(interval)
        [-4, 1]
        [-5, 1]
        """
        return _typ.Interval_setLowerBound(self, lowerBound)

    def getUpperBound(self):
        r"""
        Get the upper bound.

        Returns
        -------
        upperBound : :class:`~openturns.Point`
            Value of the upper bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getUpperBound())
        [4,5]
        """
        return _typ.Interval_getUpperBound(self)

    def setUpperBound(self, upperBound):
        r"""
        Set the upper bound.

        Parameters
        ----------
        upperBound : sequence of float
            Value of the upper bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setUpperBound([4, 5])
        >>> print(interval)
        [0, 4]
        [0, 5]
        """
        return _typ.Interval_setUpperBound(self, upperBound)

    def getFiniteLowerBound(self):
        r"""
        Tell for each component of the lower bound whether it is finite or not.

        Returns
        -------
        flags : :class:`~openturns.BoolCollection`
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the lower bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getFiniteLowerBound())
        [1,0]
        """
        return _typ.Interval_getFiniteLowerBound(self)

    def setFiniteLowerBound(self, finiteLowerBound):
        r"""
        Tell for each component of the lower bound whether it is finite or not.

        Parameters
        ----------
        flags : sequence of bool
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the lower bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setFiniteLowerBound([True, False])
        >>> print(interval)
        [0, 1]
        ]-inf (0), 1]
        """
        return _typ.Interval_setFiniteLowerBound(self, finiteLowerBound)

    def getFiniteUpperBound(self):
        r"""
        Tell for each component of the upper bound whether it is finite or not.

        Returns
        -------
        flags : :class:`~openturns.BoolCollection`
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the upper bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getFiniteUpperBound())
        [1,1]
        """
        return _typ.Interval_getFiniteUpperBound(self)

    def setFiniteUpperBound(self, finiteUpperBound):
        r"""
        Tell for each component of the upper bound whether it is finite or not.

        Parameters
        ----------
        flags : sequence of bool
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the upper bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setFiniteUpperBound([True, False])
        >>> print(interval)
        [0, 1]
        [0, (1) +inf[
        """
        return _typ.Interval_setFiniteUpperBound(self, finiteUpperBound)

    def __repr__(self):
        return _typ.Interval___repr__(self)

    def __str__(self, *args):
        return _typ.Interval___str__(self, *args)

    def __init__(self, *args):
        _typ.Interval_swiginit(self, _typ.new_Interval(*args))
    __swig_destroy__ = _typ.delete_Interval

# Register Interval in _typ:
_typ.Interval_swigregister(Interval)
class HistoryStrategyImplementation(openturns.common.PersistentObject):
    r"""
    History storage strategy.

    Available constructors:
        HistoryStrategy()

        HistoryStrategy(*historyStrategyImp*)

    Parameters
    ----------
    historyStrategyImp : HistoryStrategyImplementation
        An implementation of a history strategy which is provided by
        :class:`~openturns.Compact`, :class:`~openturns.Full`,
        :class:`~openturns.Last` or :class:`~openturns.Null` class.

    See also
    --------
    Compact, Full, Last, Null

    Notes
    -----
    In order to prevent a memory problem, the User has the possibility to choose the 
    storage strategy used to save the numerical samples. Four strategies are proposed:

    - the :class:`~openturns.Null` strategy where nothing is stored. This class
      does not require to specify arguments.
    - the :class:`~openturns.Full` strategy where every point is stored. Be careful!
      The memory will be exhausted for huge samples. This class does not require to
      specify arguments.
    - the :class:`~openturns.Last` strategy where only the :math:`N` last points are
      stored, where :math:`N` is specified by the User. This class requires to
      specify the number of points to store.
    - the :class:`~openturns.Compact` strategy where a regularly spaced sub-sample
      is stored. The minimum size :math:`N` of the stored numerical sample is
      specified by the User. It proceeds as follows:

      1. it stores the first :math:`2N` simulations: the size of the stored
         sample is :math:`2N`,
      2. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N` (this is the *compact* step),
      3. it stores the next :math:`N` simulations when selecting 1 out of 2 of the
         next simulations : the size of the stored sample is :math:`2N`,
      4. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N`,
      5. it stores the next :math:`N` simulations when selecting 1 out of 4 of the
         next simulations : the size of the stored sample is :math:`2N`,
      6. then it keeps on until reaching the stopping criteria.

      The stored numerical sample will have a size within :math:`N` and :math:`2N`.
      This class requires to specify the number of points to store.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.HistoryStrategyImplementation_getClassName(self)

    def store(self, *args):
        r"""
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _typ.HistoryStrategyImplementation_store(self, *args)

    def setDimension(self, dimension):
        r"""
        Set the dimension of points to store.

        This method must be called before calling the store method.

        Notes
        -----
        It erases the previously stored points

        Parameters
        ----------
        dimension: int
            Dimension of points to store
        """
        return _typ.HistoryStrategyImplementation_setDimension(self, dimension)

    def clear(self):
        r"""
        Clear the stored points.

        Notes
        -----
        It erases the previously stored points
        """
        return _typ.HistoryStrategyImplementation_clear(self)

    def getSample(self):
        r"""
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.HistoryStrategyImplementation_getSample(self)

    def __repr__(self):
        return _typ.HistoryStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _typ.HistoryStrategyImplementation_swiginit(self, _typ.new_HistoryStrategyImplementation(*args))
    __swig_destroy__ = _typ.delete_HistoryStrategyImplementation

# Register HistoryStrategyImplementation in _typ:
_typ.HistoryStrategyImplementation_swigregister(HistoryStrategyImplementation)
class _HistoryStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _typ._HistoryStrategyImplementationTypedInterfaceObject_swiginit(self, _typ.new__HistoryStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _typ._HistoryStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._HistoryStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._HistoryStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _typ._HistoryStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _typ._HistoryStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _typ.delete__HistoryStrategyImplementationTypedInterfaceObject

# Register _HistoryStrategyImplementationTypedInterfaceObject in _typ:
_typ._HistoryStrategyImplementationTypedInterfaceObject_swigregister(_HistoryStrategyImplementationTypedInterfaceObject)
class HistoryStrategy(_HistoryStrategyImplementationTypedInterfaceObject):
    r"""
    History storage strategy.

    Available constructors:
        HistoryStrategy()

        HistoryStrategy(*historyStrategyImp*)

    Parameters
    ----------
    historyStrategyImp : HistoryStrategyImplementation
        An implementation of a history strategy which is provided by
        :class:`~openturns.Compact`, :class:`~openturns.Full`,
        :class:`~openturns.Last` or :class:`~openturns.Null` class.

    See also
    --------
    Compact, Full, Last, Null

    Notes
    -----
    In order to prevent a memory problem, the User has the possibility to choose the 
    storage strategy used to save the numerical samples. Four strategies are proposed:

    - the :class:`~openturns.Null` strategy where nothing is stored. This class
      does not require to specify arguments.
    - the :class:`~openturns.Full` strategy where every point is stored. Be careful!
      The memory will be exhausted for huge samples. This class does not require to
      specify arguments.
    - the :class:`~openturns.Last` strategy where only the :math:`N` last points are
      stored, where :math:`N` is specified by the User. This class requires to
      specify the number of points to store.
    - the :class:`~openturns.Compact` strategy where a regularly spaced sub-sample
      is stored. The minimum size :math:`N` of the stored numerical sample is
      specified by the User. It proceeds as follows:

      1. it stores the first :math:`2N` simulations: the size of the stored
         sample is :math:`2N`,
      2. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N` (this is the *compact* step),
      3. it stores the next :math:`N` simulations when selecting 1 out of 2 of the
         next simulations : the size of the stored sample is :math:`2N`,
      4. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N`,
      5. it stores the next :math:`N` simulations when selecting 1 out of 4 of the
         next simulations : the size of the stored sample is :math:`2N`,
      6. then it keeps on until reaching the stopping criteria.

      The stored numerical sample will have a size within :math:`N` and :math:`2N`.
      This class requires to specify the number of points to store.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.HistoryStrategy_getClassName(self)

    def store(self, *args):
        r"""
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _typ.HistoryStrategy_store(self, *args)

    def setDimension(self, dimension):
        r"""
        Set the dimension of points to store.

        This method must be called before calling the store method.

        Notes
        -----
        It erases the previously stored points

        Parameters
        ----------
        dimension: int
            Dimension of points to store
        """
        return _typ.HistoryStrategy_setDimension(self, dimension)

    def clear(self):
        r"""
        Clear the stored points.

        Notes
        -----
        It erases the previously stored points
        """
        return _typ.HistoryStrategy_clear(self)

    def getSample(self):
        r"""
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.HistoryStrategy_getSample(self)

    def __repr__(self):
        return _typ.HistoryStrategy___repr__(self)

    def __init__(self, *args):
        _typ.HistoryStrategy_swiginit(self, _typ.new_HistoryStrategy(*args))
    __swig_destroy__ = _typ.delete_HistoryStrategy

# Register HistoryStrategy in _typ:
_typ.HistoryStrategy_swigregister(HistoryStrategy)
class _SampleImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_typ._SampleImplementationPointer_ptr__get, _typ._SampleImplementationPointer_ptr__set)

    def __init__(self, *args):
        _typ._SampleImplementationPointer_swiginit(self, _typ.new__SampleImplementationPointer(*args))
    __swig_destroy__ = _typ.delete__SampleImplementationPointer

    def reset(self):
        return _typ._SampleImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ._SampleImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _typ._SampleImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _typ._SampleImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ._SampleImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ._SampleImplementationPointer_get(self)

    def getImplementation(self):
        return _typ._SampleImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ._SampleImplementationPointer_unique(self)

    def use_count(self):
        return _typ._SampleImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ._SampleImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._SampleImplementationPointer_getClassName(self)

    def BuildFromCSVFile(self, *args):
        return _typ._SampleImplementationPointer_BuildFromCSVFile(self, *args)

    def BuildFromTextFile(self, *args):
        return _typ._SampleImplementationPointer_BuildFromTextFile(self, *args)

    def data(self):
        return _typ._SampleImplementationPointer_data(self)

    def elementSize(self):
        return _typ._SampleImplementationPointer_elementSize(self)

    def setDescription(self, description):
        return _typ._SampleImplementationPointer_setDescription(self, description)

    def getDescription(self):
        return _typ._SampleImplementationPointer_getDescription(self)

    def __repr__(self):
        return _typ._SampleImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _typ._SampleImplementationPointer___str__(self, *args)

    def __eq__(self, rhs):
        return _typ._SampleImplementationPointer___eq__(self, rhs)

    def contains(self, val):
        return _typ._SampleImplementationPointer_contains(self, val)

    def getSize(self):
        return _typ._SampleImplementationPointer_getSize(self)

    def getDimension(self):
        return _typ._SampleImplementationPointer_getDimension(self)

    def add(self, *args):
        return _typ._SampleImplementationPointer_add(self, *args)

    def stack(self, sample):
        return _typ._SampleImplementationPointer_stack(self, sample)

    def computeMean(self):
        return _typ._SampleImplementationPointer_computeMean(self)

    def computeCovariance(self):
        return _typ._SampleImplementationPointer_computeCovariance(self)

    def computeStandardDeviation(self):
        return _typ._SampleImplementationPointer_computeStandardDeviation(self)

    def computeLinearCorrelation(self):
        return _typ._SampleImplementationPointer_computeLinearCorrelation(self)

    def computePearsonCorrelation(self):
        return _typ._SampleImplementationPointer_computePearsonCorrelation(self)

    def computeSpearmanCorrelation(self):
        return _typ._SampleImplementationPointer_computeSpearmanCorrelation(self)

    def computeKendallTau(self):
        return _typ._SampleImplementationPointer_computeKendallTau(self)

    def computeRange(self):
        return _typ._SampleImplementationPointer_computeRange(self)

    def computeMedian(self):
        return _typ._SampleImplementationPointer_computeMedian(self)

    def computeVariance(self):
        return _typ._SampleImplementationPointer_computeVariance(self)

    def computeSkewness(self):
        return _typ._SampleImplementationPointer_computeSkewness(self)

    def computeKurtosis(self):
        return _typ._SampleImplementationPointer_computeKurtosis(self)

    def computeCentralMoment(self, k):
        return _typ._SampleImplementationPointer_computeCentralMoment(self, k)

    def computeRawMoment(self, k):
        return _typ._SampleImplementationPointer_computeRawMoment(self, k)

    def computeQuantilePerComponent(self, *args):
        return _typ._SampleImplementationPointer_computeQuantilePerComponent(self, *args)

    def computeQuantile(self, *args):
        return _typ._SampleImplementationPointer_computeQuantile(self, *args)

    def computeEmpiricalCDF(self, point, tail=False):
        return _typ._SampleImplementationPointer_computeEmpiricalCDF(self, point, tail)

    def getMax(self):
        return _typ._SampleImplementationPointer_getMax(self)

    def getMin(self):
        return _typ._SampleImplementationPointer_getMin(self)

    def rank(self, *args):
        return _typ._SampleImplementationPointer_rank(self, *args)

    def sort(self, *args):
        return _typ._SampleImplementationPointer_sort(self, *args)

    def sortInPlace(self):
        return _typ._SampleImplementationPointer_sortInPlace(self)

    def sortAccordingToAComponent(self, index):
        return _typ._SampleImplementationPointer_sortAccordingToAComponent(self, index)

    def sortAccordingToAComponentInPlace(self, index):
        return _typ._SampleImplementationPointer_sortAccordingToAComponentInPlace(self, index)

    def sortUnique(self):
        return _typ._SampleImplementationPointer_sortUnique(self)

    def sortUniqueInPlace(self):
        return _typ._SampleImplementationPointer_sortUniqueInPlace(self)

    def argsort(self, isIncreasing=True):
        return _typ._SampleImplementationPointer_argsort(self, isIncreasing)

    def getMarginal(self, *args):
        return _typ._SampleImplementationPointer_getMarginal(self, *args)

    def select(self, indices):
        return _typ._SampleImplementationPointer_select(self, indices)

    def __iadd__(self, *args):
        return _typ._SampleImplementationPointer___iadd__(self, *args)

    def __isub__(self, *args):
        return _typ._SampleImplementationPointer___isub__(self, *args)

    def __add__(self, *args):
        return _typ._SampleImplementationPointer___add__(self, *args)

    def __sub__(self, *args):
        return _typ._SampleImplementationPointer___sub__(self, *args)

    def __mul__(self, *args):
        return _typ._SampleImplementationPointer___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ._SampleImplementationPointer___truediv__(self, *args)
    __div__ = __truediv__



    def __imul__(self, *args):
        return _typ._SampleImplementationPointer___imul__(self, *args)

    def __itruediv__(self, *args):
        return _typ._SampleImplementationPointer___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def exportToCSVFile(self, *args):
        return _typ._SampleImplementationPointer_exportToCSVFile(self, *args)

    def __ne__(self, other):
        return _typ._SampleImplementationPointer___ne__(self, other)

    def __repr_markdown__(self):
        return _typ._SampleImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _typ._SampleImplementationPointer__repr_html_(self)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ._SampleImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ._SampleImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ._SampleImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ._SampleImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ._SampleImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ._SampleImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ._SampleImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._SampleImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._SampleImplementationPointer_setName(self, name)

# Register _SampleImplementationPointer in _typ:
_typ._SampleImplementationPointer_swigregister(_SampleImplementationPointer)
class _MatrixImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_typ._MatrixImplementationPointer_ptr__get, _typ._MatrixImplementationPointer_ptr__set)

    def __init__(self, *args):
        _typ._MatrixImplementationPointer_swiginit(self, _typ.new__MatrixImplementationPointer(*args))
    __swig_destroy__ = _typ.delete__MatrixImplementationPointer

    def reset(self):
        return _typ._MatrixImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ._MatrixImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _typ._MatrixImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _typ._MatrixImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ._MatrixImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ._MatrixImplementationPointer_get(self)

    def getImplementation(self):
        return _typ._MatrixImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ._MatrixImplementationPointer_unique(self)

    def use_count(self):
        return _typ._MatrixImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ._MatrixImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._MatrixImplementationPointer_getClassName(self)

    def __repr__(self):
        return _typ._MatrixImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _typ._MatrixImplementationPointer___str__(self, *args)

    def __call__(self, *args):
        return _typ._MatrixImplementationPointer___call__(self, *args)

    def getNbRows(self):
        return _typ._MatrixImplementationPointer_getNbRows(self)

    def getNbColumns(self):
        return _typ._MatrixImplementationPointer_getNbColumns(self)

    def getDimension(self):
        return _typ._MatrixImplementationPointer_getDimension(self)

    def transpose(self):
        return _typ._MatrixImplementationPointer_transpose(self)

    def resize(self, *args):
        return _typ._MatrixImplementationPointer_resize(self, *args)

    def reshape(self, newRowDim, newColDim):
        return _typ._MatrixImplementationPointer_reshape(self, newRowDim, newColDim)

    def reshapeInPlace(self, newRowDim, newColDim):
        return _typ._MatrixImplementationPointer_reshapeInPlace(self, newRowDim, newColDim)

    def getRow(self, rowIndex):
        return _typ._MatrixImplementationPointer_getRow(self, rowIndex)

    def getRowSym(self, rowIndex):
        return _typ._MatrixImplementationPointer_getRowSym(self, rowIndex)

    def getColumn(self, columnIndex):
        return _typ._MatrixImplementationPointer_getColumn(self, columnIndex)

    def getColumnSym(self, columnIndex):
        return _typ._MatrixImplementationPointer_getColumnSym(self, columnIndex)

    def __add__(self, matrix):
        return _typ._MatrixImplementationPointer___add__(self, matrix)

    def __iadd__(self, matrix):
        return _typ._MatrixImplementationPointer___iadd__(self, matrix)

    def __sub__(self, matrix):
        return _typ._MatrixImplementationPointer___sub__(self, matrix)

    def __isub__(self, matrix):
        return _typ._MatrixImplementationPointer___isub__(self, matrix)

    def genProd(self, matrix, transposeLeft=False, transposeRight=False):
        return _typ._MatrixImplementationPointer_genProd(self, matrix, transposeLeft, transposeRight)

    def symProd(self, m, symSide):
        return _typ._MatrixImplementationPointer_symProd(self, m, symSide)

    def genPower(self, n):
        return _typ._MatrixImplementationPointer_genPower(self, n)

    def symPower(self, n):
        return _typ._MatrixImplementationPointer_symPower(self, n)

    def genSampleProd(self, sample, transposeMatrix, transposeSample, side):
        return _typ._MatrixImplementationPointer_genSampleProd(self, sample, transposeMatrix, transposeSample, side)

    def genVectProd(self, pt, transpose=False):
        return _typ._MatrixImplementationPointer_genVectProd(self, pt, transpose)

    def symVectProd(self, pt):
        return _typ._MatrixImplementationPointer_symVectProd(self, pt)

    def triangularVectProd(self, *args):
        return _typ._MatrixImplementationPointer_triangularVectProd(self, *args)

    def __mul__(self, s):
        return _typ._MatrixImplementationPointer___mul__(self, s)

    def __imul__(self, s):
        return _typ._MatrixImplementationPointer___imul__(self, s)

    def __truediv__(self, *args):
        return _typ._MatrixImplementationPointer___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv__(self, *args):
        return _typ._MatrixImplementationPointer___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def symmetrize(self):
        return _typ._MatrixImplementationPointer_symmetrize(self)

    def triangularize(self, isLowerTriangular):
        return _typ._MatrixImplementationPointer_triangularize(self, isLowerTriangular)

    def solveLinearSystemRect(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemRect(self, *args)

    def solveLinearSystemRectInPlace(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemRectInPlace(self, *args)

    def solveLinearSystemSquareInPlace(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemSquareInPlace(self, *args)

    def solveLinearSystemSquare(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemSquare(self, *args)

    def solveLinearSystemTri(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemTri(self, *args)

    def solveLinearSystemTriInPlace(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemTriInPlace(self, *args)

    def solveLinearSystemSymInPlace(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemSymInPlace(self, *args)

    def solveLinearSystemSym(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemSym(self, *args)

    def solveLinearSystemCovInPlace(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemCovInPlace(self, *args)

    def solveLinearSystemCov(self, *args):
        return _typ._MatrixImplementationPointer_solveLinearSystemCov(self, *args)

    def triangularProd(self, *args):
        return _typ._MatrixImplementationPointer_triangularProd(self, *args)

    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeLogAbsoluteDeterminant(self, keepIntact)

    def computeDeterminant(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeDeterminant(self, keepIntact)

    def computeLogAbsoluteDeterminantSym(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeLogAbsoluteDeterminantSym(self, keepIntact)

    def computeDeterminantSym(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeDeterminantSym(self, keepIntact)

    def computeTrace(self):
        return _typ._MatrixImplementationPointer_computeTrace(self)

    def computeEigenValuesSquare(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeEigenValuesSquare(self, keepIntact)

    def computeEVSquare(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeEVSquare(self, keepIntact)

    def computeEigenValuesSym(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeEigenValuesSym(self, keepIntact)

    def computeEVSym(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeEVSym(self, keepIntact)

    def computeLargestEigenValueModuleSquare(self, *args):
        return _typ._MatrixImplementationPointer_computeLargestEigenValueModuleSquare(self, *args)

    def computeLargestEigenValueModuleSym(self, *args):
        return _typ._MatrixImplementationPointer_computeLargestEigenValueModuleSym(self, *args)

    def computeSingularValues(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeSingularValues(self, keepIntact)

    def computeSVD(self, fullSVD=False, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeSVD(self, fullSVD, keepIntact)

    def isSymmetric(self):
        return _typ._MatrixImplementationPointer_isSymmetric(self)

    def isPositiveDefinite(self):
        return _typ._MatrixImplementationPointer_isPositiveDefinite(self)

    def hasUnitRange(self):
        return _typ._MatrixImplementationPointer_hasUnitRange(self)

    def clean(self, threshold):
        return _typ._MatrixImplementationPointer_clean(self, threshold)

    def cleanSym(self, threshold):
        return _typ._MatrixImplementationPointer_cleanSym(self, threshold)

    def computeCholesky(self, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeCholesky(self, keepIntact)

    def computeRegularizedCholesky(self):
        return _typ._MatrixImplementationPointer_computeRegularizedCholesky(self)

    def computeQR(self, fullQR=False, keepIntact=True):
        return _typ._MatrixImplementationPointer_computeQR(self, fullQR, keepIntact)

    def computeGram(self, transpose=True):
        return _typ._MatrixImplementationPointer_computeGram(self, transpose)

    def __eq__(self, *args):
        return _typ._MatrixImplementationPointer___eq__(self, *args)

    def __ne__(self, *args):
        return _typ._MatrixImplementationPointer___ne__(self, *args)

    def isEmpty(self):
        return _typ._MatrixImplementationPointer_isEmpty(self)

    def isTriangular(self, lower=True):
        return _typ._MatrixImplementationPointer_isTriangular(self, lower)

    def __stride__(self, dim):
        return _typ._MatrixImplementationPointer___stride__(self, dim)

    def getDiagonal(self, k=0):
        return _typ._MatrixImplementationPointer_getDiagonal(self, k)

    def getDiagonalAsPoint(self, k=0):
        return _typ._MatrixImplementationPointer_getDiagonalAsPoint(self, k)

    def setDiagonal(self, *args):
        return _typ._MatrixImplementationPointer_setDiagonal(self, *args)

    def computeHadamardProduct(self, other):
        return _typ._MatrixImplementationPointer_computeHadamardProduct(self, other)

    def computeSumElements(self):
        return _typ._MatrixImplementationPointer_computeSumElements(self)

    def squareElements(self):
        return _typ._MatrixImplementationPointer_squareElements(self)

    def __repr_markdown__(self):
        return _typ._MatrixImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _typ._MatrixImplementationPointer__repr_html_(self)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ._MatrixImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ._MatrixImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ._MatrixImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ._MatrixImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ._MatrixImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ._MatrixImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ._MatrixImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._MatrixImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._MatrixImplementationPointer_setName(self, name)

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ._MatrixImplementationPointer_clear(self)

    def __len__(self):
        return _typ._MatrixImplementationPointer___len__(self)

    def __contains__(self, val):
        return _typ._MatrixImplementationPointer___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ._MatrixImplementationPointer_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ._MatrixImplementationPointer___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ._MatrixImplementationPointer___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ._MatrixImplementationPointer___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ._MatrixImplementationPointer_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ._MatrixImplementationPointer_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ._MatrixImplementationPointer_getSize(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ._MatrixImplementationPointer_find(self, val)

# Register _MatrixImplementationPointer in _typ:
_typ._MatrixImplementationPointer_swigregister(_MatrixImplementationPointer)
class _PointPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_typ._PointPointer_ptr__get, _typ._PointPointer_ptr__set)

    def __init__(self, *args):
        _typ._PointPointer_swiginit(self, _typ.new__PointPointer(*args))
    __swig_destroy__ = _typ.delete__PointPointer

    def reset(self):
        return _typ._PointPointer_reset(self)

    def __ref__(self, *args):
        return _typ._PointPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _typ._PointPointer___deref__(self, *args)

    def isNull(self):
        return _typ._PointPointer_isNull(self)

    def __nonzero__(self):
        return _typ._PointPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ._PointPointer_get(self)

    def getImplementation(self):
        return _typ._PointPointer_getImplementation(self)

    def unique(self):
        return _typ._PointPointer_unique(self)

    def use_count(self):
        return _typ._PointPointer_use_count(self)

    def swap(self, other):
        return _typ._PointPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ._PointPointer_getClassName(self)

    def __repr__(self):
        return _typ._PointPointer___repr__(self)

    def __str__(self, *args):
        return _typ._PointPointer___str__(self, *args)

    def clean(self, threshold):
        return _typ._PointPointer_clean(self, threshold)

    def isIncreasing(self):
        r"""
        Check if the components are in increasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.isIncreasing()
        True
        >>> x = ot.Point([1.0, 1.0, 3.0])
        >>> x.isIncreasing()
        False
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isIncreasing()
        False
        """
        return _typ._PointPointer_isIncreasing(self)

    def isNonDecreasing(self):
        r"""
        Check if the components are in nondecreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.isNonDecreasing()
        True
        >>> x = ot.Point([1.0, 1.0, 3.0])
        >>> x.isNonDecreasing()
        True
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isNonDecreasing()
        False
        """
        return _typ._PointPointer_isNonDecreasing(self)

    def isDecreasing(self):
        r"""
        Check if the components are in decreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([3.0, 2.0, 1.0])
        >>> x.isDecreasing()
        True
        >>> x = ot.Point([3.0, 3.0, 1.0])
        >>> x.isDecreasing()
        False
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isIncreasing()
        False
        """
        return _typ._PointPointer_isDecreasing(self)

    def isNonIncreasing(self):
        r"""
        Check if the components are in nonincreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([3.0, 2.0, 1.0])
        >>> x.isNonIncreasing()
        True
        >>> x = ot.Point([3.0, 3.0, 1.0])
        >>> x.isNonIncreasing()
        True
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isNonIncreasing()
        False
        """
        return _typ._PointPointer_isNonIncreasing(self)

    def isMonotonic(self):
        r"""
        Check if the components are in nonincreasing or nondecreasing order.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.isMonotonic()
        True
        >>> x = ot.Point([2.0, 2.0, 1.0])
        >>> x.isMonotonic()
        True
        >>> x = ot.Point([1.0, 3.0, 2.0])
        >>> x.isMonotonic()
        False
        """
        return _typ._PointPointer_isMonotonic(self)

    def getDimension(self):
        r"""
        Accessor to the vector's dimension.

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ._PointPointer_getDimension(self)

    def getSize(self):
        r"""
        Accessor to the vector's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ._PointPointer_getSize(self)

    def __imul__(self, scalar):
        return _typ._PointPointer___imul__(self, scalar)

    def __itruediv__(self, *args):
        return _typ._PointPointer___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def norm(self):
        r"""
        Compute the Euclidean (:math:`L^2`) norm.

        The Euclidean (:math:`L^2`) norm of a vector is defined as:

        .. math::

            \norm{\vect{x}} = \norm{\vect{x}}_2
                            = \sqrt{\sum_{i=1}^n x_i^2}

        Returns
        -------
        norm : float
            The vector's Euclidean norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm()
        3.741657...
        """
        return _typ._PointPointer_norm(self)

    def norm1(self):
        r"""
        Compute the :math:`L^1` norm.

        The :math:`L^1` norm of a vector is defined as:

        .. math::

            \norm{\vect{x}}_1 = \sum_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^1` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm1()
        6.0
        """
        return _typ._PointPointer_norm1(self)

    def normInf(self):
        r"""
        Compute the :math:`L^{\inf}` norm.

        The :math:`L^{\inf}` norm of a vector is defined as:

        .. math::

            \norm{\vect{x}}_{\inf} = \max_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^{\inf}` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normInf()
        3.0
        """
        return _typ._PointPointer_normInf(self)

    def normSquare(self):
        r"""
        Compute the squared Euclidean norm.

        Returns
        -------
        norm : float
            The vector's squared Euclidean norm.

        See Also
        --------
        norm

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normSquare()
        14.0
        """
        return _typ._PointPointer_normSquare(self)

    def normalize(self):
        r"""
        Compute the normalized vector with respect to its Euclidean norm.

        Returns
        -------
        normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its Euclidean norm.

        See Also
        --------
        norm

        Raises
        ------
        RuntimeError : If the Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalize())
        [0.267261,0.534522,0.801784]
        """
        return _typ._PointPointer_normalize(self)

    def normalizeSquare(self):
        r"""
        Compute the normalized vector with respect to its squared Euclidean norm.

        Returns
        -------
        normalized_vector : normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its squared Euclidean norm.

        See Also
        --------
        normSquare

        Raises
        ------
        RuntimeError : If the squared Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalizeSquare())
        [0.0714286,0.285714,0.642857]
        """
        return _typ._PointPointer_normalizeSquare(self)

    def dot(self, rhs):
        r"""
        Compute the scalar product.

        Parameters
        ----------
        point : sequence of float
            Scalar product second argument

        Returns
        -------
        dot : float
            Scalar product

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> prod = x.dot([4, 5, 6])
        """
        return _typ._PointPointer_dot(self, rhs)

    def __setitem__(self, arg, valObj):
        return _typ._PointPointer___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ._PointPointer___getitem__(self, arg)

    def __eq__(self, other):
        return _typ._PointPointer___eq__(self, other)

    def __ne__(self, other):
        return _typ._PointPointer___ne__(self, other)

    def __radd__(self, s):
        return _typ._PointPointer___radd__(self, s)

    def __add__(self, other):
        return _typ._PointPointer___add__(self, other)

    def __sub__(self, other):
        return _typ._PointPointer___sub__(self, other)

    def __mul__(self, s):
        return _typ._PointPointer___mul__(self, s)

    def __rmul__(self, s):
        return _typ._PointPointer___rmul__(self, s)

    def __div__(self, s):
        return _typ._PointPointer___div__(self, s)

    def __truediv__(self, s):
        return _typ._PointPointer___truediv__(self, s)

    def __iadd__(self, other):
        return _typ._PointPointer___iadd__(self, other)

    def __isub__(self, other):
        return _typ._PointPointer___isub__(self, other)

    def __neg__(self):
        return _typ._PointPointer___neg__(self)

    def __repr_markdown__(self):
        return _typ._PointPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _typ._PointPointer__repr_html_(self)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ._PointPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ._PointPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ._PointPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ._PointPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ._PointPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ._PointPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ._PointPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ._PointPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ._PointPointer_setName(self, name)

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ._PointPointer_clear(self)

    def __len__(self):
        return _typ._PointPointer___len__(self)

    def __contains__(self, val):
        return _typ._PointPointer___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ._PointPointer_select(self, marginalIndices)

    def __delitem__(self, i):
        return _typ._PointPointer___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ._PointPointer_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ._PointPointer_add(self, *args)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ._PointPointer_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ._PointPointer_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ._PointPointer_find(self, val)

# Register _PointPointer in _typ:
_typ._PointPointer_swigregister(_PointPointer)
class _TensorImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ptr_ = property(_typ._TensorImplementationPointer_ptr__get, _typ._TensorImplementationPointer_ptr__set)

    def __init__(self, *args):
        _typ._TensorImplementationPointer_swiginit(self, _typ.new__TensorImplementationPointer(*args))
    __swig_destroy__ = _typ.delete__TensorImplementationPointer

    def reset(self):
        return _typ._TensorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ._TensorImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _typ._TensorImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _typ._TensorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ._TensorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ._TensorImplementationPointer_get(self)

    def getImplementation(self):
        return _typ._TensorImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ._TensorImplementationPointer_unique(self)

    def use_count(self):
        return _typ._TensorImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ._TensorImplementationPointer_swap(self, other)

# Register _TensorImplementationPointer in _typ:
_typ._TensorImplementationPointer_swigregister(_TensorImplementationPointer)
class _ComplexMatrixImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ptr_ = property(_typ._ComplexMatrixImplementationPointer_ptr__get, _typ._ComplexMatrixImplementationPointer_ptr__set)

    def __init__(self, *args):
        _typ._ComplexMatrixImplementationPointer_swiginit(self, _typ.new__ComplexMatrixImplementationPointer(*args))
    __swig_destroy__ = _typ.delete__ComplexMatrixImplementationPointer

    def reset(self):
        return _typ._ComplexMatrixImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ._ComplexMatrixImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _typ._ComplexMatrixImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _typ._ComplexMatrixImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ._ComplexMatrixImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ._ComplexMatrixImplementationPointer_get(self)

    def getImplementation(self):
        return _typ._ComplexMatrixImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ._ComplexMatrixImplementationPointer_unique(self)

    def use_count(self):
        return _typ._ComplexMatrixImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ._ComplexMatrixImplementationPointer_swap(self, other)

# Register _ComplexMatrixImplementationPointer in _typ:
_typ._ComplexMatrixImplementationPointer_swigregister(_ComplexMatrixImplementationPointer)
class HermitianMatrixCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _typ.delete_HermitianMatrixCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.HermitianMatrixCollection_clear(self)

    def __len__(self):
        return _typ.HermitianMatrixCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.HermitianMatrixCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.HermitianMatrixCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _typ.HermitianMatrixCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _typ.HermitianMatrixCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.HermitianMatrixCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.HermitianMatrixCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.HermitianMatrixCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.HermitianMatrixCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.HermitianMatrixCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.HermitianMatrixCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.HermitianMatrixCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _typ.HermitianMatrixCollection_find(self, val)

    def __repr__(self):
        return _typ.HermitianMatrixCollection___repr__(self)

    def __str__(self, *args):
        return _typ.HermitianMatrixCollection___str__(self, *args)

    def __init__(self, *args):
        _typ.HermitianMatrixCollection_swiginit(self, _typ.new_HermitianMatrixCollection(*args))

# Register HermitianMatrixCollection in _typ:
_typ.HermitianMatrixCollection_swigregister(HermitianMatrixCollection)
class _ComplexTensorImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ptr_ = property(_typ._ComplexTensorImplementationPointer_ptr__get, _typ._ComplexTensorImplementationPointer_ptr__set)

    def __init__(self, *args):
        _typ._ComplexTensorImplementationPointer_swiginit(self, _typ.new__ComplexTensorImplementationPointer(*args))
    __swig_destroy__ = _typ.delete__ComplexTensorImplementationPointer

    def reset(self):
        return _typ._ComplexTensorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ._ComplexTensorImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _typ._ComplexTensorImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _typ._ComplexTensorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ._ComplexTensorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ._ComplexTensorImplementationPointer_get(self)

    def getImplementation(self):
        return _typ._ComplexTensorImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ._ComplexTensorImplementationPointer_unique(self)

    def use_count(self):
        return _typ._ComplexTensorImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ._ComplexTensorImplementationPointer_swap(self, other)

# Register _ComplexTensorImplementationPointer in _typ:
_typ._ComplexTensorImplementationPointer_swigregister(_ComplexTensorImplementationPointer)

class BoolCollection(UnsignedIntegerCollection):
    """Proxy of C++ OT::BoolCollection class."""
    pass


