%feature("docstring") OT::Uniform
"Uniform distribution.

Parameters
----------
a : float
    Lower bound.

    Default value is -1.0.
b : float, :math:`b > a`
    Upper bound.

    Default value is 1.0.

Notes
-----
Its probability density function is defined as:

.. math::

    f_X(x) = \\frac{1}{b-a}, \\quad x \\in [a; b]

with :math:`a < b`.

Its first moments are defined as:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & \\frac{a+b}{2} \\\\
        \\Var{X} & = & \\frac{(b-a)^2}{12}
    \\end{eqnarray*}

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> distribution = ot.Uniform(2.0, 3.0)

Create it from the alternative parametrization :math:`(\\mu, \\sigma)`:

>>> distribution2 = ot.UniformMuSigma(3.0, 1.15).getDistribution()

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Uniform::getA
"Accessor to the distribution's lower bound.

Returns
-------
a : float
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Uniform::getB
"Accessor to the distribution's upper bound.

Returns
-------
b : float
    Upper bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Uniform::setA
"Accessor to the distribution's lower bound.

Parameters
----------
a : float, :math:`a < b`
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Uniform::setB
"Accessor to the distribution's upper bound.

Parameters
----------
b : float, :math:`a < b`
    Upper bound."
