%feature("docstring") OT::ConstantBasisFactory
"Constant basis factory.

Parameters
----------
dimension : integer
    Input dimension of the basis.

See also
--------
BasisFactory, LinearBasisFactory, QuadraticBasisFactory

Notes
-----
A factory for constant basis of input dimension *dimension*.

Examples
--------
>>> import openturns as ot
>>> basis = ot.ConstantBasisFactory(2).build()
>>> f = ot.AggregatedFunction(basis)
>>> x = [2, 3]
>>> print(f(x))
[1]"
