# Config file for MOAB; use the CMake find_package() function to pull this into
# your own CMakeLists.txt file.
#
# This file defines the following variables:
# MOAB_FOUND        - boolean indicating that MOAB is found
# MOAB_INCLUDE_DIRS - include directories from which to pick up MOAB includes
# MOAB_LIBRARIES    - libraries need to link to MOAB; use this in target_link_libraries for MOAB-dependent targets
# MOAB_CXX, MOAB_CC, MOAB_F77, MOAB_FC - compilers used to compile MOAB
# MOAB_CXXFLAGS, MOAB_CCFLAGS, MOAB_FFLAGS, MOAB_FCFLAGS - compiler flags used to compile MOAB; possibly need to use these in add_definitions or CMAKE_<LANG>_FLAGS_<MODE> 

set(MOAB_FOUND 1)

set(MOAB_CC "D:/a/msys64/clang64/bin/clang.exe")
set(MOAB_CXX "D:/a/msys64/clang64/bin/clang++.exe")
set(MOAB_FC )
set(MOAB_F77 )
# Compiler flags used by MOAB
set(MOAB_CFLAGS "-O3 -DNDEBUG -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -pedantic -fpic -Wall -Wno-long-long -Wextra -Wno-cast-align -Wsign-compare -Wpointer-arith -Wformat -Wformat-security -Wunused-parameter -fstack-protector-all -fpermissive -Wno-ignored-attributes -Wno-variadic-macros -Wno-deprecated-declarations -Wno-unused-local-typedefs -ID:/a/msys64/clang64/include/eigen3")
set(MOAB_CXXFLAGS "-O3 -DNDEBUG -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -pedantic -fpic -Wall -Wno-long-long -Wextra -Wno-cast-align -Wsign-compare -Wpointer-arith -Wformat -Wformat-security -Wunused-parameter -fstack-protector-all -fpermissive -Wno-ignored-attributes -Wno-variadic-macros -Wno-deprecated-declarations -Wno-unused-local-typedefs -ID:/a/msys64/clang64/include/eigen3")
set(MOAB_FCFLAGS "")
set(MOAB_FFLAGS "")

set(MOAB_BUILT_SHARED OFF)
set(MOAB_USE_MPI OFF)
set(MPI_DIR "")
set(MOAB_USE_HDF5 OFF)
set(MOAB_USE_HDF5_PARALLEL OFF)
set(HDF5_DIR "")
set(MOAB_USE_ZLIB OFF)
set(ZLIB_DIR "")
set(MOAB_USE_SZIP OFF)
set(SZIP_DIR "")
set(MOAB_USE_NETCDF OFF)
set(NETCDF_DIR "")
set(MOAB_USE_PNETCDF OFF)
set(PNETCDF_DIR "")
set(MOAB_USE_METIS OFF)
set(METIS_DIR "")
set(MOAB_USE_PARMETIS OFF)
set(PARMETIS_DIR "")
set(MOAB_USE_ZOLTAN OFF)
set(ZOLTAN_DIR "")
set(MOAB_USE_BLAS ON)
set(BLAS_LIBRARIES "D:/a/msys64/clang64/lib/libopenblas.dll.a")
set(MOAB_USE_LAPACK ON)
set(LAPACK_LIBRARIES "D:/a/msys64/clang64/lib/libopenblas.dll.a;-pthread")
set(MOAB_USE_EIGEN ON)
set(EIGEN3_DIR "D:/a/msys64/clang64/include/eigen3")
set(TEMPESTREMAP_DIR "")
set(MOAB_USE_TEMPESTREMAP )

set(MOAB_MESH_DIR "D:/M/B/src/moab-5.5.1/MeshFiles/unittest")

set(ENABLE_IGEOM OFF)
set(CGM_DIR "")
set(ENABLE_IMESH OFF)
set(ENABLE_IREL OFF)
set(ENABLE_FBIGEOM OFF)

# Library and include defs
get_filename_component(MOAB_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

include (${MOAB_CMAKE_DIR}/ResolveCompilerPaths.cmake)

# missing support for DAMSEL, CCMIO
set (MOAB_PACKAGE_LIBS "         D:/a/msys64/clang64/lib/libopenblas.dll.a;-pthread D:/a/msys64/clang64/lib/libopenblas.dll.a " )
string(STRIP "${MOAB_PACKAGE_LIBS}" MOAB_PACKAGE_LIBS)
set(MOAB_PACKAGE_LIBS_LIST ${MOAB_PACKAGE_LIBS})
separate_arguments(MOAB_PACKAGE_LIBS_LIST)
list(REMOVE_DUPLICATES MOAB_PACKAGE_LIBS_LIST)
set(MOAB_PACKAGE_LIBS "${MOAB_PACKAGE_LIBS_LIST}")

set (MOAB_PACKAGE_INCLUDES_LIST "       -ID:/a/msys64/clang64/include/eigen3  " )
string(STRIP "${MOAB_PACKAGE_INCLUDES_LIST}" MOAB_PACKAGE_INCLUDES_LIST)
RESOLVE_INCLUDES(MOAB_PACKAGE_INCLUDES "${MOAB_PACKAGE_INCLUDES_LIST}")
separate_arguments(MOAB_PACKAGE_INCLUDES)
list(REMOVE_DUPLICATES MOAB_PACKAGE_INCLUDES)

if(NOT TARGET MOAB AND NOT MOAB_BINARY_DIR)
  include("${MOAB_CMAKE_DIR}/MOABTargets.cmake")
endif()

# Target information
if(MOAB_USE_HDF5)
  if(EXISTS "/share/cmake/hdf5/hdf5-config.cmake")
    include(/share/cmake/hdf5/hdf5-config.cmake)
  endif()
endif()

set(MOAB_LIBRARY_DIRS "/clang64/lib")
set(MOAB_INCLUDE_DIRS "/clang64/include" ${MOAB_PACKAGE_INCLUDES})
set(MOAB_LIBS "-lMOAB")
set(MOAB_LIBRARIES "-L/clang64/lib ${MOAB_LIBS} ${MOAB_PACKAGE_LIBS}")
if(ENABLE_IMESH)
  set(MOAB_LIBS "-liMesh ${MOAB_LIBS}")
  set(IMESH_LIBRARIES "-L/clang64/lib ${MOAB_LIBS} ${MOAB_PACKAGE_LIBS}")
endif(ENABLE_IMESH)
if(ENABLE_FBIGEOM)
  set(MOAB_LIBS "-lFBiGeom ${MOAB_LIBS}")
  set(FBIGEOM_LIBRARIES "-L/clang64/lib ${MOAB_LIBS} ${MOAB_PACKAGE_LIBS}")
endif(ENABLE_FBIGEOM)
if(ENABLE_IREL)
  set(MOAB_LIBS "-liRel ${MOAB_LIBS}")
  set(IREL_LIBRARIES "-L/clang64/lib ${MOAB_LIBS} ${MOAB_PACKAGE_LIBS}")
endif(ENABLE_IREL)

