/*
 * Copyright (c) 2012 Sander van der Burg
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so, 
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __ILBM_CYCLEINFO_H
#define __ILBM_CYCLEINFO_H

#include <stdio.h>
#include <libiff/ifftypes.h>
#include <libiff/group.h>
#include <libiff/chunk.h>

#define ILBM_CYCLEINFO_SHIFT_LEFT -1
#define ILBM_CYCLEINFO_SHIFT_RIGHT 1

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
    IFF_Group *parent;
    
    IFF_ID chunkId;
    IFF_Long chunkSize;
    
    IFF_Word direction;
    IFF_UByte start, end;
    IFF_Long seconds;
    IFF_Long microSeconds;
    IFF_Word pad;
}
ILBM_CycleInfo;

ILBM_CycleInfo *ILBM_createCycleInfo(void);

IFF_Chunk *ILBM_readCycleInfo(FILE *file, const IFF_Long chunkSize);

int ILBM_writeCycleInfo(FILE *file, const IFF_Chunk *chunk);

int ILBM_checkCycleInfo(const IFF_Chunk *chunk);

void ILBM_freeCycleInfo(IFF_Chunk *chunk);

void ILBM_printCycleInfo(const IFF_Chunk *chunk, const unsigned int indentLevel);

int ILBM_compareCycleInfo(const IFF_Chunk *chunk1, const IFF_Chunk *chunk2);

#ifdef __cplusplus
}
#endif

#endif
