
#ifndef KIOCORE_EXPORT_H
#define KIOCORE_EXPORT_H

#ifdef KIOCORE_STATIC_DEFINE
#  define KIOCORE_EXPORT
#  define KIOCORE_NO_EXPORT
#else
#  ifndef KIOCORE_EXPORT
#    ifdef KF6KIOCore_EXPORTS
        /* We are building this library */
#      define KIOCORE_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KIOCORE_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KIOCORE_NO_EXPORT
#    define KIOCORE_NO_EXPORT 
#  endif
#endif

#ifndef KIOCORE_DECL_DEPRECATED
#  define KIOCORE_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KIOCORE_DECL_DEPRECATED_EXPORT
#  define KIOCORE_DECL_DEPRECATED_EXPORT KIOCORE_EXPORT KIOCORE_DECL_DEPRECATED
#endif

#ifndef KIOCORE_DECL_DEPRECATED_NO_EXPORT
#  define KIOCORE_DECL_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT KIOCORE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KIOCORE_NO_DEPRECATED
#    define KIOCORE_NO_DEPRECATED
#  endif
#endif
#include <kio_version.h>

#define KIOCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KIOCORE_NO_DEPRECATED) && !defined(KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KIOCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KIOCORE_NO_DEPRECATED_WARNINGS) && !defined(KIOCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KIOCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KIOCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KIOCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KIOCORE_NO_DEPRECATED)
#  undef KIOCORE_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT
#elif defined(KIOCORE_NO_DEPRECATED_WARNINGS)
#  define KIOCORE_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT
#else
#  define KIOCORE_DEPRECATED KIOCORE_DECL_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_DECL_DEPRECATED_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIOCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIOCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIOCORE_NO_DEPRECATED
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KIO_VERSION
#endif
#ifdef KIOCORE_NO_DEPRECATED_WARNINGS
#  define KIOCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIOCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE KIO_VERSION
#  endif
#endif

#ifndef KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KIOCORE_DEPRECATED
#  define KIOCORE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIOCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x56500
#  define KIOCORE_DEPRECATED_VERSION_5_101(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_101(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x60300
#  define KIOCORE_DEPRECATED_VERSION_6_3(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_6_3(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x60400
#  define KIOCORE_DEPRECATED_VERSION_6_4(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_6_4(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x60600
#  define KIOCORE_DEPRECATED_VERSION_6_6(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_6_6(text)
#endif
#define KIOCORE_DEPRECATED_VERSION_5(minor, text)      KIOCORE_DEPRECATED_VERSION_5_##minor(text)
#define KIOCORE_DEPRECATED_VERSION_6(minor, text)      KIOCORE_DEPRECATED_VERSION_6_##minor(text)
#define KIOCORE_DEPRECATED_VERSION(major, minor, text) KIOCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KIOCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KIOCORE_DEPRECATED_VERSION(major, minor, text)
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KIOCORE_EXPORT_H */
