/* BEGIN_LEGAL 

Copyright (c) 2025 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
/// @file xed-cpuid-group-enum.h

// This file was automatically generated.
// Do not edit this file.

#if !defined(XED_CPUID_GROUP_ENUM_H)
# define XED_CPUID_GROUP_ENUM_H
#include "xed-common-hdrs.h"
#define XED_CPUID_GROUP_INVALID_DEFINED 1
#define XED_CPUID_GROUP_ADOX_ADCX_DEFINED 1
#define XED_CPUID_GROUP_AES_DEFINED 1
#define XED_CPUID_GROUP_AMX_AVX512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AMX_BF16_DEFINED 1
#define XED_CPUID_GROUP_AMX_BF16_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AMX_COMPLEX_DEFINED 1
#define XED_CPUID_GROUP_AMX_COMPLEX_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AMX_FP16_DEFINED 1
#define XED_CPUID_GROUP_AMX_FP16_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AMX_FP8_DEFINED 1
#define XED_CPUID_GROUP_AMX_INT8_DEFINED 1
#define XED_CPUID_GROUP_AMX_INT8_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AMX_MOVRS_DEFINED 1
#define XED_CPUID_GROUP_AMX_TF32_DEFINED 1
#define XED_CPUID_GROUP_AMX_TILE_DEFINED 1
#define XED_CPUID_GROUP_AMX_TRANSPOSE_DEFINED 1
#define XED_CPUID_GROUP_AMX_TRANSPOSE_BF16_DEFINED 1
#define XED_CPUID_GROUP_AMX_TRANSPOSE_COMPLEX_DEFINED 1
#define XED_CPUID_GROUP_AMX_TRANSPOSE_FP16_DEFINED 1
#define XED_CPUID_GROUP_AMX_TRANSPOSE_MOVRS_DEFINED 1
#define XED_CPUID_GROUP_AMX_TRANSPOSE_TF32_DEFINED 1
#define XED_CPUID_GROUP_APX_F_DEFINED 1
#define XED_CPUID_GROUP_APX_F_ADX_DEFINED 1
#define XED_CPUID_GROUP_APX_F_AMX_DEFINED 1
#define XED_CPUID_GROUP_APX_F_BMI1_DEFINED 1
#define XED_CPUID_GROUP_APX_F_BMI2_DEFINED 1
#define XED_CPUID_GROUP_APX_F_CET_DEFINED 1
#define XED_CPUID_GROUP_APX_F_CMPCCXADD_DEFINED 1
#define XED_CPUID_GROUP_APX_F_ENQCMD_DEFINED 1
#define XED_CPUID_GROUP_APX_F_INVPCID_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPB_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPB_AVX10_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPD_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPD_AVX10_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPQ_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPQ_AVX10_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPW_DEFINED 1
#define XED_CPUID_GROUP_APX_F_KOPW_AVX10_DEFINED 1
#define XED_CPUID_GROUP_APX_F_LZCNT_DEFINED 1
#define XED_CPUID_GROUP_APX_F_MOVBE_DEFINED 1
#define XED_CPUID_GROUP_APX_F_MOVDIR64B_DEFINED 1
#define XED_CPUID_GROUP_APX_F_MOVDIRI_DEFINED 1
#define XED_CPUID_GROUP_APX_F_MSR_IMM_DEFINED 1
#define XED_CPUID_GROUP_APX_F_POPCNT_DEFINED 1
#define XED_CPUID_GROUP_APX_F_RAO_INT_DEFINED 1
#define XED_CPUID_GROUP_APX_F_USER_MSR_DEFINED 1
#define XED_CPUID_GROUP_APX_F_VMX_DEFINED 1
#define XED_CPUID_GROUP_AVX_DEFINED 1
#define XED_CPUID_GROUP_AVX10_2_RC_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX10_2_RC_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX10_MOVRS_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX10_MOVRS_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX10_MOVRS_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX2_DEFINED 1
#define XED_CPUID_GROUP_AVX2GATHER_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_128N_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_128N_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_KOPD_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_KOPD_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_KOPQ_DEFINED 1
#define XED_CPUID_GROUP_AVX512BW_KOPQ_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512CD_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512CD_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512CD_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512CD_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512CD_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512CD_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_128N_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_128N_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_KOPB_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_KOPB_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_KOPW_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_KOPW_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_SCALAR_DEFINED 1
#define XED_CPUID_GROUP_AVX512DQ_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512ER_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512ER_SCALAR_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_128N_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_128N_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_KOPW_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_KOPW_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_SCALAR_DEFINED 1
#define XED_CPUID_GROUP_AVX512F_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512PF_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_4FMAPS_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_4FMAPS_SCALAR_DEFINED 1
#define XED_CPUID_GROUP_AVX512_4VNNIW_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_NE_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_NE_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_NE_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BF16_NE_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BITALG_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BITALG_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BITALG_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BITALG_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BITALG_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_BITALG_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_COM_EF_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_128N_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_128N_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_CONVERT_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_CONVERT_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_CONVERT_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_SCALAR_DEFINED 1
#define XED_CPUID_GROUP_AVX512_FP16_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_GFNI_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_GFNI_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_GFNI_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_GFNI_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_GFNI_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_GFNI_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_IFMA_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_IFMA_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_IFMA_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_IFMA_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_IFMA_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_IFMA_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MEDIAX_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MEDIAX_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MEDIAX_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MINMAX_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MINMAX_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MINMAX_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MINMAX_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_MOVZXC_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_NE_CONVERT_FP8_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_NE_CONVERT_FP8_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_NE_CONVERT_FP8_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_SAT_CVT_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_SAT_CVT_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_SAT_CVT_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_SAT_CVT_DS_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_SAT_CVT_DS_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_SAT_CVT_DS_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_SAT_CVT_DS_SCALAR_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VAES_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VAES_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VAES_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VAES_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VAES_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VAES_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI2_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI2_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI2_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI2_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI2_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI2_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VBMI_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_FP16_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_FP16_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_FP16_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_INT16_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_INT16_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_INT16_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_INT8_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_INT8_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VNNI_INT8_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VP2INTERSECT_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VP2INTERSECT_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VP2INTERSECT_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPCLMULQDQ_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPCLMULQDQ_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPCLMULQDQ_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPCLMULQDQ_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPCLMULQDQ_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPCLMULQDQ_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPOPCNTDQ_128_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPOPCNTDQ_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPOPCNTDQ_256_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPOPCNTDQ_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPOPCNTDQ_512_DEFINED 1
#define XED_CPUID_GROUP_AVX512_VPOPCNTDQ_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_AVXAES_DEFINED 1
#define XED_CPUID_GROUP_AVX_GFNI_DEFINED 1
#define XED_CPUID_GROUP_AVX_IFMA_DEFINED 1
#define XED_CPUID_GROUP_AVX_NE_CONVERT_DEFINED 1
#define XED_CPUID_GROUP_AVX_VNNI_DEFINED 1
#define XED_CPUID_GROUP_AVX_VNNI_INT16_DEFINED 1
#define XED_CPUID_GROUP_AVX_VNNI_INT8_DEFINED 1
#define XED_CPUID_GROUP_BMI1_DEFINED 1
#define XED_CPUID_GROUP_BMI2_DEFINED 1
#define XED_CPUID_GROUP_CET_DEFINED 1
#define XED_CPUID_GROUP_CLDEMOTE_DEFINED 1
#define XED_CPUID_GROUP_CLFLUSHOPT_DEFINED 1
#define XED_CPUID_GROUP_CLFSH_DEFINED 1
#define XED_CPUID_GROUP_CLWB_DEFINED 1
#define XED_CPUID_GROUP_CMOV_DEFINED 1
#define XED_CPUID_GROUP_CMPCCXADD_DEFINED 1
#define XED_CPUID_GROUP_CMPXCHG16B_DEFINED 1
#define XED_CPUID_GROUP_ENQCMD_DEFINED 1
#define XED_CPUID_GROUP_F16C_DEFINED 1
#define XED_CPUID_GROUP_FCMOV_DEFINED 1
#define XED_CPUID_GROUP_FCOMI_DEFINED 1
#define XED_CPUID_GROUP_FMA_DEFINED 1
#define XED_CPUID_GROUP_FRED_DEFINED 1
#define XED_CPUID_GROUP_FXSAVE_DEFINED 1
#define XED_CPUID_GROUP_FXSAVE64_DEFINED 1
#define XED_CPUID_GROUP_GFNI_DEFINED 1
#define XED_CPUID_GROUP_HRESET_DEFINED 1
#define XED_CPUID_GROUP_ICACHE_PREFETCH_DEFINED 1
#define XED_CPUID_GROUP_INVPCID_DEFINED 1
#define XED_CPUID_GROUP_KEYLOCKER_DEFINED 1
#define XED_CPUID_GROUP_KEYLOCKER_WIDE_DEFINED 1
#define XED_CPUID_GROUP_LAHF_DEFINED 1
#define XED_CPUID_GROUP_LKGS_DEFINED 1
#define XED_CPUID_GROUP_LONGMODE_DEFINED 1
#define XED_CPUID_GROUP_LZCNT_DEFINED 1
#define XED_CPUID_GROUP_MCOMMIT_DEFINED 1
#define XED_CPUID_GROUP_MONITOR_DEFINED 1
#define XED_CPUID_GROUP_MONITORX_DEFINED 1
#define XED_CPUID_GROUP_MOVBE_DEFINED 1
#define XED_CPUID_GROUP_MOVDIR64B_DEFINED 1
#define XED_CPUID_GROUP_MOVDIRI_DEFINED 1
#define XED_CPUID_GROUP_MOVRS_DEFINED 1
#define XED_CPUID_GROUP_MPX_DEFINED 1
#define XED_CPUID_GROUP_MSRLIST_DEFINED 1
#define XED_CPUID_GROUP_MSR_IMM_DEFINED 1
#define XED_CPUID_GROUP_PBNDKB_DEFINED 1
#define XED_CPUID_GROUP_PCLMULQDQ_DEFINED 1
#define XED_CPUID_GROUP_PCONFIG_DEFINED 1
#define XED_CPUID_GROUP_PENTIUMMMX_DEFINED 1
#define XED_CPUID_GROUP_PKU_DEFINED 1
#define XED_CPUID_GROUP_POPCNT_DEFINED 1
#define XED_CPUID_GROUP_PREFETCHW_DEFINED 1
#define XED_CPUID_GROUP_PREFETCHWT1_DEFINED 1
#define XED_CPUID_GROUP_PTWRITE_DEFINED 1
#define XED_CPUID_GROUP_RAO_INT_DEFINED 1
#define XED_CPUID_GROUP_RDPID_DEFINED 1
#define XED_CPUID_GROUP_RDPRU_DEFINED 1
#define XED_CPUID_GROUP_RDRAND_DEFINED 1
#define XED_CPUID_GROUP_RDSEED_DEFINED 1
#define XED_CPUID_GROUP_RDTSCP_DEFINED 1
#define XED_CPUID_GROUP_RDWRFSGS_DEFINED 1
#define XED_CPUID_GROUP_RTM_DEFINED 1
#define XED_CPUID_GROUP_SEP_DEFINED 1
#define XED_CPUID_GROUP_SERIALIZE_DEFINED 1
#define XED_CPUID_GROUP_SGX_DEFINED 1
#define XED_CPUID_GROUP_SHA_DEFINED 1
#define XED_CPUID_GROUP_SHA512_DEFINED 1
#define XED_CPUID_GROUP_SM3_DEFINED 1
#define XED_CPUID_GROUP_SM4_DEFINED 1
#define XED_CPUID_GROUP_SM4_128_AVX10_DEFINED 1
#define XED_CPUID_GROUP_SM4_256_AVX10_DEFINED 1
#define XED_CPUID_GROUP_SM4_512_AVX10_DEFINED 1
#define XED_CPUID_GROUP_SMAP_DEFINED 1
#define XED_CPUID_GROUP_SMX_DEFINED 1
#define XED_CPUID_GROUP_SNP_DEFINED 1
#define XED_CPUID_GROUP_SSE_DEFINED 1
#define XED_CPUID_GROUP_SSE2_DEFINED 1
#define XED_CPUID_GROUP_SSE2MMX_DEFINED 1
#define XED_CPUID_GROUP_SSE3_DEFINED 1
#define XED_CPUID_GROUP_SSE3X87_DEFINED 1
#define XED_CPUID_GROUP_SSE4_DEFINED 1
#define XED_CPUID_GROUP_SSE42_DEFINED 1
#define XED_CPUID_GROUP_SSE4A_DEFINED 1
#define XED_CPUID_GROUP_SSEMXCSR_DEFINED 1
#define XED_CPUID_GROUP_SSSE3_DEFINED 1
#define XED_CPUID_GROUP_SSSE3MMX_DEFINED 1
#define XED_CPUID_GROUP_TSX_LDTRK_DEFINED 1
#define XED_CPUID_GROUP_UINTR_DEFINED 1
#define XED_CPUID_GROUP_USER_MSR_DEFINED 1
#define XED_CPUID_GROUP_VAES_DEFINED 1
#define XED_CPUID_GROUP_VIA_PADLOCK_AES_DEFINED 1
#define XED_CPUID_GROUP_VIA_PADLOCK_MONTMUL_DEFINED 1
#define XED_CPUID_GROUP_VIA_PADLOCK_RNG_DEFINED 1
#define XED_CPUID_GROUP_VIA_PADLOCK_SHA_DEFINED 1
#define XED_CPUID_GROUP_VPCLMULQDQ_DEFINED 1
#define XED_CPUID_GROUP_VTX_DEFINED 1
#define XED_CPUID_GROUP_WAITPKG_DEFINED 1
#define XED_CPUID_GROUP_WBNOINVD_DEFINED 1
#define XED_CPUID_GROUP_WRMSRNS_DEFINED 1
#define XED_CPUID_GROUP_XSAVE_DEFINED 1
#define XED_CPUID_GROUP_XSAVEC_DEFINED 1
#define XED_CPUID_GROUP_XSAVEOPT_DEFINED 1
#define XED_CPUID_GROUP_XSAVES_DEFINED 1
#define XED_CPUID_GROUP_LAST_DEFINED 1
typedef enum {
  XED_CPUID_GROUP_INVALID,
  XED_CPUID_GROUP_ADOX_ADCX,
  XED_CPUID_GROUP_AES,
  XED_CPUID_GROUP_AMX_AVX512_AVX10,
  XED_CPUID_GROUP_AMX_BF16,
  XED_CPUID_GROUP_AMX_BF16_AVX10,
  XED_CPUID_GROUP_AMX_COMPLEX,
  XED_CPUID_GROUP_AMX_COMPLEX_AVX10,
  XED_CPUID_GROUP_AMX_FP16,
  XED_CPUID_GROUP_AMX_FP16_AVX10,
  XED_CPUID_GROUP_AMX_FP8,
  XED_CPUID_GROUP_AMX_INT8,
  XED_CPUID_GROUP_AMX_INT8_AVX10,
  XED_CPUID_GROUP_AMX_MOVRS,
  XED_CPUID_GROUP_AMX_TF32,
  XED_CPUID_GROUP_AMX_TILE,
  XED_CPUID_GROUP_AMX_TRANSPOSE,
  XED_CPUID_GROUP_AMX_TRANSPOSE_BF16,
  XED_CPUID_GROUP_AMX_TRANSPOSE_COMPLEX,
  XED_CPUID_GROUP_AMX_TRANSPOSE_FP16,
  XED_CPUID_GROUP_AMX_TRANSPOSE_MOVRS,
  XED_CPUID_GROUP_AMX_TRANSPOSE_TF32,
  XED_CPUID_GROUP_APX_F,
  XED_CPUID_GROUP_APX_F_ADX,
  XED_CPUID_GROUP_APX_F_AMX,
  XED_CPUID_GROUP_APX_F_BMI1,
  XED_CPUID_GROUP_APX_F_BMI2,
  XED_CPUID_GROUP_APX_F_CET,
  XED_CPUID_GROUP_APX_F_CMPCCXADD,
  XED_CPUID_GROUP_APX_F_ENQCMD,
  XED_CPUID_GROUP_APX_F_INVPCID,
  XED_CPUID_GROUP_APX_F_KOPB,
  XED_CPUID_GROUP_APX_F_KOPB_AVX10,
  XED_CPUID_GROUP_APX_F_KOPD,
  XED_CPUID_GROUP_APX_F_KOPD_AVX10,
  XED_CPUID_GROUP_APX_F_KOPQ,
  XED_CPUID_GROUP_APX_F_KOPQ_AVX10,
  XED_CPUID_GROUP_APX_F_KOPW,
  XED_CPUID_GROUP_APX_F_KOPW_AVX10,
  XED_CPUID_GROUP_APX_F_LZCNT,
  XED_CPUID_GROUP_APX_F_MOVBE,
  XED_CPUID_GROUP_APX_F_MOVDIR64B,
  XED_CPUID_GROUP_APX_F_MOVDIRI,
  XED_CPUID_GROUP_APX_F_MSR_IMM,
  XED_CPUID_GROUP_APX_F_POPCNT,
  XED_CPUID_GROUP_APX_F_RAO_INT,
  XED_CPUID_GROUP_APX_F_USER_MSR,
  XED_CPUID_GROUP_APX_F_VMX,
  XED_CPUID_GROUP_AVX,
  XED_CPUID_GROUP_AVX10_2_RC_256_AVX10,
  XED_CPUID_GROUP_AVX10_2_RC_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX10_MOVRS_128_AVX10,
  XED_CPUID_GROUP_AVX10_MOVRS_256_AVX10,
  XED_CPUID_GROUP_AVX10_MOVRS_512_AVX10,
  XED_CPUID_GROUP_AVX2,
  XED_CPUID_GROUP_AVX2GATHER,
  XED_CPUID_GROUP_AVX512BW_128,
  XED_CPUID_GROUP_AVX512BW_128N,
  XED_CPUID_GROUP_AVX512BW_128N_AVX10,
  XED_CPUID_GROUP_AVX512BW_128_AVX10,
  XED_CPUID_GROUP_AVX512BW_256,
  XED_CPUID_GROUP_AVX512BW_256_AVX10,
  XED_CPUID_GROUP_AVX512BW_512,
  XED_CPUID_GROUP_AVX512BW_512_AVX10,
  XED_CPUID_GROUP_AVX512BW_KOPD,
  XED_CPUID_GROUP_AVX512BW_KOPD_AVX10,
  XED_CPUID_GROUP_AVX512BW_KOPQ,
  XED_CPUID_GROUP_AVX512BW_KOPQ_AVX10,
  XED_CPUID_GROUP_AVX512CD_128,
  XED_CPUID_GROUP_AVX512CD_128_AVX10,
  XED_CPUID_GROUP_AVX512CD_256,
  XED_CPUID_GROUP_AVX512CD_256_AVX10,
  XED_CPUID_GROUP_AVX512CD_512,
  XED_CPUID_GROUP_AVX512CD_512_AVX10,
  XED_CPUID_GROUP_AVX512DQ_128,
  XED_CPUID_GROUP_AVX512DQ_128N,
  XED_CPUID_GROUP_AVX512DQ_128N_AVX10,
  XED_CPUID_GROUP_AVX512DQ_128_AVX10,
  XED_CPUID_GROUP_AVX512DQ_256,
  XED_CPUID_GROUP_AVX512DQ_256_AVX10,
  XED_CPUID_GROUP_AVX512DQ_512,
  XED_CPUID_GROUP_AVX512DQ_512_AVX10,
  XED_CPUID_GROUP_AVX512DQ_KOPB,
  XED_CPUID_GROUP_AVX512DQ_KOPB_AVX10,
  XED_CPUID_GROUP_AVX512DQ_KOPW,
  XED_CPUID_GROUP_AVX512DQ_KOPW_AVX10,
  XED_CPUID_GROUP_AVX512DQ_SCALAR,
  XED_CPUID_GROUP_AVX512DQ_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX512ER_512,
  XED_CPUID_GROUP_AVX512ER_SCALAR,
  XED_CPUID_GROUP_AVX512F_128,
  XED_CPUID_GROUP_AVX512F_128N,
  XED_CPUID_GROUP_AVX512F_128N_AVX10,
  XED_CPUID_GROUP_AVX512F_128_AVX10,
  XED_CPUID_GROUP_AVX512F_256,
  XED_CPUID_GROUP_AVX512F_256_AVX10,
  XED_CPUID_GROUP_AVX512F_512,
  XED_CPUID_GROUP_AVX512F_512_AVX10,
  XED_CPUID_GROUP_AVX512F_KOPW,
  XED_CPUID_GROUP_AVX512F_KOPW_AVX10,
  XED_CPUID_GROUP_AVX512F_SCALAR,
  XED_CPUID_GROUP_AVX512F_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX512PF_512,
  XED_CPUID_GROUP_AVX512_4FMAPS_512,
  XED_CPUID_GROUP_AVX512_4FMAPS_SCALAR,
  XED_CPUID_GROUP_AVX512_4VNNIW_512,
  XED_CPUID_GROUP_AVX512_BF16_128,
  XED_CPUID_GROUP_AVX512_BF16_128_AVX10,
  XED_CPUID_GROUP_AVX512_BF16_256,
  XED_CPUID_GROUP_AVX512_BF16_256_AVX10,
  XED_CPUID_GROUP_AVX512_BF16_512,
  XED_CPUID_GROUP_AVX512_BF16_512_AVX10,
  XED_CPUID_GROUP_AVX512_BF16_NE_128_AVX10,
  XED_CPUID_GROUP_AVX512_BF16_NE_256_AVX10,
  XED_CPUID_GROUP_AVX512_BF16_NE_512_AVX10,
  XED_CPUID_GROUP_AVX512_BF16_NE_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX512_BITALG_128,
  XED_CPUID_GROUP_AVX512_BITALG_128_AVX10,
  XED_CPUID_GROUP_AVX512_BITALG_256,
  XED_CPUID_GROUP_AVX512_BITALG_256_AVX10,
  XED_CPUID_GROUP_AVX512_BITALG_512,
  XED_CPUID_GROUP_AVX512_BITALG_512_AVX10,
  XED_CPUID_GROUP_AVX512_COM_EF_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_128,
  XED_CPUID_GROUP_AVX512_FP16_128N,
  XED_CPUID_GROUP_AVX512_FP16_128N_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_128_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_256,
  XED_CPUID_GROUP_AVX512_FP16_256_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_512,
  XED_CPUID_GROUP_AVX512_FP16_512_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_CONVERT_128_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_CONVERT_256_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_CONVERT_512_AVX10,
  XED_CPUID_GROUP_AVX512_FP16_SCALAR,
  XED_CPUID_GROUP_AVX512_FP16_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX512_GFNI_128,
  XED_CPUID_GROUP_AVX512_GFNI_128_AVX10,
  XED_CPUID_GROUP_AVX512_GFNI_256,
  XED_CPUID_GROUP_AVX512_GFNI_256_AVX10,
  XED_CPUID_GROUP_AVX512_GFNI_512,
  XED_CPUID_GROUP_AVX512_GFNI_512_AVX10,
  XED_CPUID_GROUP_AVX512_IFMA_128,
  XED_CPUID_GROUP_AVX512_IFMA_128_AVX10,
  XED_CPUID_GROUP_AVX512_IFMA_256,
  XED_CPUID_GROUP_AVX512_IFMA_256_AVX10,
  XED_CPUID_GROUP_AVX512_IFMA_512,
  XED_CPUID_GROUP_AVX512_IFMA_512_AVX10,
  XED_CPUID_GROUP_AVX512_MEDIAX_128_AVX10,
  XED_CPUID_GROUP_AVX512_MEDIAX_256_AVX10,
  XED_CPUID_GROUP_AVX512_MEDIAX_512_AVX10,
  XED_CPUID_GROUP_AVX512_MINMAX_128_AVX10,
  XED_CPUID_GROUP_AVX512_MINMAX_256_AVX10,
  XED_CPUID_GROUP_AVX512_MINMAX_512_AVX10,
  XED_CPUID_GROUP_AVX512_MINMAX_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX512_MOVZXC_128_AVX10,
  XED_CPUID_GROUP_AVX512_NE_CONVERT_FP8_128_AVX10,
  XED_CPUID_GROUP_AVX512_NE_CONVERT_FP8_256_AVX10,
  XED_CPUID_GROUP_AVX512_NE_CONVERT_FP8_512_AVX10,
  XED_CPUID_GROUP_AVX512_SAT_CVT_128_AVX10,
  XED_CPUID_GROUP_AVX512_SAT_CVT_256_AVX10,
  XED_CPUID_GROUP_AVX512_SAT_CVT_512_AVX10,
  XED_CPUID_GROUP_AVX512_SAT_CVT_DS_128_AVX10,
  XED_CPUID_GROUP_AVX512_SAT_CVT_DS_256_AVX10,
  XED_CPUID_GROUP_AVX512_SAT_CVT_DS_512_AVX10,
  XED_CPUID_GROUP_AVX512_SAT_CVT_DS_SCALAR_AVX10,
  XED_CPUID_GROUP_AVX512_VAES_128,
  XED_CPUID_GROUP_AVX512_VAES_128_AVX10,
  XED_CPUID_GROUP_AVX512_VAES_256,
  XED_CPUID_GROUP_AVX512_VAES_256_AVX10,
  XED_CPUID_GROUP_AVX512_VAES_512,
  XED_CPUID_GROUP_AVX512_VAES_512_AVX10,
  XED_CPUID_GROUP_AVX512_VBMI2_128,
  XED_CPUID_GROUP_AVX512_VBMI2_128_AVX10,
  XED_CPUID_GROUP_AVX512_VBMI2_256,
  XED_CPUID_GROUP_AVX512_VBMI2_256_AVX10,
  XED_CPUID_GROUP_AVX512_VBMI2_512,
  XED_CPUID_GROUP_AVX512_VBMI2_512_AVX10,
  XED_CPUID_GROUP_AVX512_VBMI_128,
  XED_CPUID_GROUP_AVX512_VBMI_128_AVX10,
  XED_CPUID_GROUP_AVX512_VBMI_256,
  XED_CPUID_GROUP_AVX512_VBMI_256_AVX10,
  XED_CPUID_GROUP_AVX512_VBMI_512,
  XED_CPUID_GROUP_AVX512_VBMI_512_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_128,
  XED_CPUID_GROUP_AVX512_VNNI_128_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_256,
  XED_CPUID_GROUP_AVX512_VNNI_256_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_512,
  XED_CPUID_GROUP_AVX512_VNNI_512_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_FP16_128_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_FP16_256_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_FP16_512_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_INT16_128_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_INT16_256_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_INT16_512_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_INT8_128_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_INT8_256_AVX10,
  XED_CPUID_GROUP_AVX512_VNNI_INT8_512_AVX10,
  XED_CPUID_GROUP_AVX512_VP2INTERSECT_128,
  XED_CPUID_GROUP_AVX512_VP2INTERSECT_256,
  XED_CPUID_GROUP_AVX512_VP2INTERSECT_512,
  XED_CPUID_GROUP_AVX512_VPCLMULQDQ_128,
  XED_CPUID_GROUP_AVX512_VPCLMULQDQ_128_AVX10,
  XED_CPUID_GROUP_AVX512_VPCLMULQDQ_256,
  XED_CPUID_GROUP_AVX512_VPCLMULQDQ_256_AVX10,
  XED_CPUID_GROUP_AVX512_VPCLMULQDQ_512,
  XED_CPUID_GROUP_AVX512_VPCLMULQDQ_512_AVX10,
  XED_CPUID_GROUP_AVX512_VPOPCNTDQ_128,
  XED_CPUID_GROUP_AVX512_VPOPCNTDQ_128_AVX10,
  XED_CPUID_GROUP_AVX512_VPOPCNTDQ_256,
  XED_CPUID_GROUP_AVX512_VPOPCNTDQ_256_AVX10,
  XED_CPUID_GROUP_AVX512_VPOPCNTDQ_512,
  XED_CPUID_GROUP_AVX512_VPOPCNTDQ_512_AVX10,
  XED_CPUID_GROUP_AVXAES,
  XED_CPUID_GROUP_AVX_GFNI,
  XED_CPUID_GROUP_AVX_IFMA,
  XED_CPUID_GROUP_AVX_NE_CONVERT,
  XED_CPUID_GROUP_AVX_VNNI,
  XED_CPUID_GROUP_AVX_VNNI_INT16,
  XED_CPUID_GROUP_AVX_VNNI_INT8,
  XED_CPUID_GROUP_BMI1,
  XED_CPUID_GROUP_BMI2,
  XED_CPUID_GROUP_CET,
  XED_CPUID_GROUP_CLDEMOTE,
  XED_CPUID_GROUP_CLFLUSHOPT,
  XED_CPUID_GROUP_CLFSH,
  XED_CPUID_GROUP_CLWB,
  XED_CPUID_GROUP_CMOV,
  XED_CPUID_GROUP_CMPCCXADD,
  XED_CPUID_GROUP_CMPXCHG16B,
  XED_CPUID_GROUP_ENQCMD,
  XED_CPUID_GROUP_F16C,
  XED_CPUID_GROUP_FCMOV,
  XED_CPUID_GROUP_FCOMI,
  XED_CPUID_GROUP_FMA,
  XED_CPUID_GROUP_FRED,
  XED_CPUID_GROUP_FXSAVE,
  XED_CPUID_GROUP_FXSAVE64,
  XED_CPUID_GROUP_GFNI,
  XED_CPUID_GROUP_HRESET,
  XED_CPUID_GROUP_ICACHE_PREFETCH,
  XED_CPUID_GROUP_INVPCID,
  XED_CPUID_GROUP_KEYLOCKER,
  XED_CPUID_GROUP_KEYLOCKER_WIDE,
  XED_CPUID_GROUP_LAHF,
  XED_CPUID_GROUP_LKGS,
  XED_CPUID_GROUP_LONGMODE,
  XED_CPUID_GROUP_LZCNT,
  XED_CPUID_GROUP_MCOMMIT,
  XED_CPUID_GROUP_MONITOR,
  XED_CPUID_GROUP_MONITORX,
  XED_CPUID_GROUP_MOVBE,
  XED_CPUID_GROUP_MOVDIR64B,
  XED_CPUID_GROUP_MOVDIRI,
  XED_CPUID_GROUP_MOVRS,
  XED_CPUID_GROUP_MPX,
  XED_CPUID_GROUP_MSRLIST,
  XED_CPUID_GROUP_MSR_IMM,
  XED_CPUID_GROUP_PBNDKB,
  XED_CPUID_GROUP_PCLMULQDQ,
  XED_CPUID_GROUP_PCONFIG,
  XED_CPUID_GROUP_PENTIUMMMX,
  XED_CPUID_GROUP_PKU,
  XED_CPUID_GROUP_POPCNT,
  XED_CPUID_GROUP_PREFETCHW,
  XED_CPUID_GROUP_PREFETCHWT1,
  XED_CPUID_GROUP_PTWRITE,
  XED_CPUID_GROUP_RAO_INT,
  XED_CPUID_GROUP_RDPID,
  XED_CPUID_GROUP_RDPRU,
  XED_CPUID_GROUP_RDRAND,
  XED_CPUID_GROUP_RDSEED,
  XED_CPUID_GROUP_RDTSCP,
  XED_CPUID_GROUP_RDWRFSGS,
  XED_CPUID_GROUP_RTM,
  XED_CPUID_GROUP_SEP,
  XED_CPUID_GROUP_SERIALIZE,
  XED_CPUID_GROUP_SGX,
  XED_CPUID_GROUP_SHA,
  XED_CPUID_GROUP_SHA512,
  XED_CPUID_GROUP_SM3,
  XED_CPUID_GROUP_SM4,
  XED_CPUID_GROUP_SM4_128_AVX10,
  XED_CPUID_GROUP_SM4_256_AVX10,
  XED_CPUID_GROUP_SM4_512_AVX10,
  XED_CPUID_GROUP_SMAP,
  XED_CPUID_GROUP_SMX,
  XED_CPUID_GROUP_SNP,
  XED_CPUID_GROUP_SSE,
  XED_CPUID_GROUP_SSE2,
  XED_CPUID_GROUP_SSE2MMX,
  XED_CPUID_GROUP_SSE3,
  XED_CPUID_GROUP_SSE3X87,
  XED_CPUID_GROUP_SSE4,
  XED_CPUID_GROUP_SSE42,
  XED_CPUID_GROUP_SSE4A,
  XED_CPUID_GROUP_SSEMXCSR,
  XED_CPUID_GROUP_SSSE3,
  XED_CPUID_GROUP_SSSE3MMX,
  XED_CPUID_GROUP_TSX_LDTRK,
  XED_CPUID_GROUP_UINTR,
  XED_CPUID_GROUP_USER_MSR,
  XED_CPUID_GROUP_VAES,
  XED_CPUID_GROUP_VIA_PADLOCK_AES,
  XED_CPUID_GROUP_VIA_PADLOCK_MONTMUL,
  XED_CPUID_GROUP_VIA_PADLOCK_RNG,
  XED_CPUID_GROUP_VIA_PADLOCK_SHA,
  XED_CPUID_GROUP_VPCLMULQDQ,
  XED_CPUID_GROUP_VTX,
  XED_CPUID_GROUP_WAITPKG,
  XED_CPUID_GROUP_WBNOINVD,
  XED_CPUID_GROUP_WRMSRNS,
  XED_CPUID_GROUP_XSAVE,
  XED_CPUID_GROUP_XSAVEC,
  XED_CPUID_GROUP_XSAVEOPT,
  XED_CPUID_GROUP_XSAVES,
  XED_CPUID_GROUP_LAST
} xed_cpuid_group_enum_t;

/// This converts strings to #xed_cpuid_group_enum_t types.
/// @param s A C-string.
/// @return #xed_cpuid_group_enum_t
/// @ingroup ENUM
XED_DLL_EXPORT xed_cpuid_group_enum_t str2xed_cpuid_group_enum_t(const char* s);
/// This converts strings to #xed_cpuid_group_enum_t types.
/// @param p An enumeration element of type xed_cpuid_group_enum_t.
/// @return string
/// @ingroup ENUM
XED_DLL_EXPORT const char* xed_cpuid_group_enum_t2str(const xed_cpuid_group_enum_t p);

/// Returns the last element of the enumeration
/// @return xed_cpuid_group_enum_t The last element of the enumeration.
/// @ingroup ENUM
XED_DLL_EXPORT xed_cpuid_group_enum_t xed_cpuid_group_enum_t_last(void);
#endif
