/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CFullyQualifiedClassGroupDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/FullyQualifiedClassGroupXml.h"

using namespace Caf;

void FullyQualifiedClassGroupXml::add(
	const SmartPtrCFullyQualifiedClassGroupDoc fullyQualifiedClassGroupDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("FullyQualifiedClassGroupXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(fullyQualifiedClassGroupDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string classNamespaceVal = fullyQualifiedClassGroupDoc->getClassNamespace();
		CAF_CM_VALIDATE_STRING(classNamespaceVal);
		thisXml->addAttribute("classNamespace", classNamespaceVal);

		const std::string classNameVal = fullyQualifiedClassGroupDoc->getClassName();
		CAF_CM_VALIDATE_STRING(classNameVal);
		thisXml->addAttribute("className", classNameVal);

		const std::string classVersionVal = fullyQualifiedClassGroupDoc->getClassVersion();
		CAF_CM_VALIDATE_STRING(classVersionVal);
		thisXml->addAttribute("classVersion", classVersionVal);
	}
	CAF_CM_EXIT;
}

SmartPtrCFullyQualifiedClassGroupDoc FullyQualifiedClassGroupXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("FullyQualifiedClassGroupXml", "parse");

	SmartPtrCFullyQualifiedClassGroupDoc fullyQualifiedClassGroupDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string classNamespaceStrVal =
			thisXml->findRequiredAttribute("classNamespace");
		const std::string classNamespaceVal = classNamespaceStrVal;

		const std::string classNameStrVal =
			thisXml->findRequiredAttribute("className");
		const std::string classNameVal = classNameStrVal;

		const std::string classVersionStrVal =
			thisXml->findRequiredAttribute("classVersion");
		const std::string classVersionVal = classVersionStrVal;

		fullyQualifiedClassGroupDoc.CreateInstance();
		fullyQualifiedClassGroupDoc->initialize(
			classNamespaceVal,
			classNameVal,
			classVersionVal);
	}
	CAF_CM_EXIT;

	return fullyQualifiedClassGroupDoc;
}

