static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1997 Spencer Kimball                                             \n"
" * Copyright 2012 Maxime Nicco <maxime.nicco@gmail.com>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (mask_radius, _(\"Mask radius\"), 7.0)                        \n"
"    value_range (0.0, 50.0)                                                   \n"
"                                                                              \n"
"property_double (pct_black, _(\"Percent black\"), 0.2)                        \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     cartoon                                              \n"
"#define GEGL_OP_C_SOURCE cartoon.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#define THRESHOLD 1.0                                                         \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  gdouble      prev_mask_radius;                                              \n"
"  gdouble      prev_pct_black;                                                \n"
"  gdouble      prev_ramp;                                                     \n"
"} Ramps;                                                                      \n"
"                                                                              \n"
"static void                                                                   \n"
"grey_blur_buffer (GeglBuffer  *input,                                         \n"
"                  gdouble      mask_radius,                                   \n"
"                  GeglBuffer **dest1,                                         \n"
"                  GeglBuffer **dest2)                                         \n"
"{                                                                             \n"
"  GeglNode *gegl, *image, *write1, *write2, *grey, *blur1, *blur2;            \n"
"  gdouble radius, std_dev1, std_dev2;                                         \n"
"                                                                              \n"
"  gegl = gegl_node_new ();                                                    \n"
"  image = gegl_node_new_child (gegl,                                          \n"
"                \"operation\", \"gegl:buffer-source\",                        \n"
"                \"buffer\", input,                                            \n"
"                NULL);                                                        \n"
"  grey = gegl_node_new_child (gegl,                                           \n"
"                \"operation\", \"gegl:grey\",                                 \n"
"                NULL);                                                        \n"
"                                                                              \n"
"  radius   = 1.0;                                                             \n"
"  radius   = fabs (radius) + 1.0;                                             \n"
"  std_dev1 = sqrt (-(radius * radius) / (2 * log (1.0 / 255.0)));             \n"
"                                                                              \n"
"  radius   = fabs (mask_radius) + 1.0;                                        \n"
"  std_dev2 = sqrt (-(radius * radius) / (2 * log (1.0 / 255.0)));             \n"
"                                                                              \n"
"  blur1 =  gegl_node_new_child (gegl,                                         \n"
"                \"operation\", \"gegl:gaussian-blur\",                        \n"
"                \"std_dev_x\", std_dev1,                                      \n"
"                \"std_dev_y\", std_dev1,                                      \n"
"                NULL);                                                        \n"
"  blur2 =  gegl_node_new_child (gegl,                                         \n"
"                \"operation\", \"gegl:gaussian-blur\",                        \n"
"                \"std_dev_x\", std_dev2,                                      \n"
"                \"std_dev_y\", std_dev2,                                      \n"
"                NULL);                                                        \n"
"                                                                              \n"
"  write1 = gegl_node_new_child(gegl,                                          \n"
"                \"operation\", \"gegl:buffer-sink\",                          \n"
"                \"buffer\", dest1, NULL);                                     \n"
"                                                                              \n"
"  write2 = gegl_node_new_child(gegl,                                          \n"
"                \"operation\", \"gegl:buffer-sink\",                          \n"
"                \"buffer\", dest2, NULL);                                     \n"
"                                                                              \n"
"  gegl_node_link_many (image, grey, blur1, write1, NULL);                     \n"
"  gegl_node_process (write1);                                                 \n"
"                                                                              \n"
"  gegl_node_link_many (grey, blur2, write2, NULL);                            \n"
"  gegl_node_process (write2);                                                 \n"
"                                                                              \n"
"  g_object_unref (gegl);                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static gdouble                                                                \n"
"compute_ramp (GeglBuffer  *dest1,                                             \n"
"              GeglBuffer  *dest2,                                             \n"
"              gdouble      pct_black)                                         \n"
"{                                                                             \n"
"  GeglBufferIterator *iter;                                                   \n"
"  gint    hist[100];                                                          \n"
"  gint    count;                                                              \n"
"  gint i;                                                                     \n"
"  gint sum;                                                                   \n"
"                                                                              \n"
"  memset (hist, 0, sizeof (int) * 100);                                       \n"
"  count = 0;                                                                  \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (dest1, NULL, 0, babl_format (\"Y' float\"),\n"
"                                   GEGL_ACCESS_READ, GEGL_ABYSS_NONE);        \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, dest2, NULL, 0, babl_format (\"Y' float\"), \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gfloat *pixel1   = iter->data[0];                                       \n"
"      gfloat *pixel2   = iter->data[1];                                       \n"
"      glong   n_pixels = iter->length;                                        \n"
"                                                                              \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          if (*pixel2 != 0)                                                   \n"
"            {                                                                 \n"
"              gdouble diff = (gdouble) *pixel1 / (gdouble) *pixel2;           \n"
"                                                                              \n"
"              if (diff < 1.0 && diff >= 0.0)                                  \n"
"                {                                                             \n"
"                  hist[(int) (diff * 100)] += 1;                              \n"
"                  count += 1;                                                 \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          pixel1++;                                                           \n"
"          pixel2++;                                                           \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (pct_black == 0.0 || count == 0)                                         \n"
"    return 1.0;                                                               \n"
"                                                                              \n"
"  sum = 0;                                                                    \n"
"  for (i = 0; i < 100; i++)                                                   \n"
"    {                                                                         \n"
"      sum += hist[i];                                                         \n"
"      if (((gdouble) sum / (gdouble) count) > pct_black)                      \n"
"        return (1.0 - (gdouble) i / 100.0);                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  return 0.0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle *region;                                                      \n"
"                                                                              \n"
"  region = gegl_operation_source_get_bounding_box (operation, \"input\");     \n"
"                                                                              \n"
"  if (region != NULL)                                                         \n"
"    return *region;                                                           \n"
"  else                                                                        \n"
"    return *GEGL_RECTANGLE (0, 0, 0, 0);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *output_roi)                     \n"
"{                                                                             \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, input_pad);\n"
"                                                                              \n"
"  if (in_rect)                                                                \n"
"    return *in_rect;                                                          \n"
"  else                                                                        \n"
"    return (GeglRectangle){0, 0, 0, 0};                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *output_roi)                           \n"
"{                                                                             \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (in_rect)                                                                \n"
"    return *in_rect;                                                          \n"
"  else                                                                        \n"
"    return (GeglRectangle){0, 0, 0, 0};                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties         *o = GEGL_PROPERTIES (operation);                    \n"
"  GeglBufferIterator *iter;                                                   \n"
"  GeglBuffer         *dest1;                                                  \n"
"  GeglBuffer         *dest2;                                                  \n"
"  gdouble             ramp;                                                   \n"
"  gdouble             progress = 0.0;                                         \n"
"  gdouble             pixels_count = result->width * result->height;          \n"
"                                                                              \n"
"  grey_blur_buffer (input, o->mask_radius, &dest1, &dest2);                   \n"
"                                                                              \n"
"  ramp = compute_ramp (dest1, dest2, o->pct_black);                           \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (output, result, 0,                         \n"
"                                   babl_format (\"Y'CbCrA float\"),           \n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, input, result, 0,                           \n"
"                            babl_format (\"Y'CbCrA float\"),                  \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, dest1, NULL, 0, babl_format (\"Y' float\"), \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, dest2, NULL, 0, babl_format (\"Y' float\"), \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"                                                                              \n"
"  gegl_operation_progress (operation, 0.0, \"\");                             \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gfloat *out_pixel = iter->data[0];                                      \n"
"      gfloat *in_pixel  = iter->data[1];                                      \n"
"      gfloat *grey1     = iter->data[2];                                      \n"
"      gfloat *grey2     = iter->data[3];                                      \n"
"      glong   n_pixels  = iter->length;                                       \n"
"                                                                              \n"
"      progress += n_pixels / pixels_count;                                    \n"
"                                                                              \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          gdouble mult = 0.0;                                                 \n"
"                                                                              \n"
"          if (*grey2 != 0)                                                    \n"
"            {                                                                 \n"
"              gdouble diff = (gdouble) *grey1 / (gdouble) *grey2;             \n"
"                                                                              \n"
"              if (diff < THRESHOLD)                                           \n"
"                {                                                             \n"
"                  if (GEGL_FLOAT_EQUAL (ramp, 0.0))                           \n"
"                    mult = 0.0;                                               \n"
"                  else                                                        \n"
"                    mult = (ramp - MIN (ramp, (THRESHOLD - diff))) / ramp;    \n"
"                }                                                             \n"
"              else                                                            \n"
"                mult = 1.0;                                                   \n"
"            }                                                                 \n"
"                                                                              \n"
"          out_pixel[0] = CLAMP (*grey1 * mult, 0.0, 1.0);                     \n"
"          out_pixel[1] = in_pixel[1];                                         \n"
"          out_pixel[2] = in_pixel[2];                                         \n"
"          out_pixel[3] = in_pixel[3];                                         \n"
"                                                                              \n"
"          out_pixel += 4;                                                     \n"
"          in_pixel  += 4;                                                     \n"
"          grey1++;                                                            \n"
"          grey2++;                                                            \n"
"        }                                                                     \n"
"                                                                              \n"
"        gegl_operation_progress (operation, progress, \"\");                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_progress (operation, 1.0, \"\");                             \n"
"                                                                              \n"
"  g_object_unref (dest1);                                                     \n"
"  g_object_unref (dest2);                                                     \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_bounding_box        = get_bounding_box;                \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"  operation_class->threaded                = FALSE;                           \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"categories\",  \"artistic\",                                            \n"
"    \"name\",        \"gegl:cartoon\",                                        \n"
"    \"title\",       _(\"Cartoon\"),                                          \n"
"    \"reference-hash\", \"e9853f9c322d769576f6acdb61859f81\",                 \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Simulates a cartoon, its result is similar to a black\"\n"
"                     \" felt pen drawing subsequently shaded with color. This\"\n"
"                     \" is achieved by enhancing edges and darkening areas that\"\n"
"                     \" are already distinctly darker than their neighborhood\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
