/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/SchemaTypesXml/InstanceOperationXml.h"

#include "Doc/SchemaTypesDoc/CInstanceOperationCollectionDoc.h"
#include "Doc/SchemaTypesDoc/CInstanceOperationDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/InstanceOperationCollectionXml.h"

using namespace Caf;

void InstanceOperationCollectionXml::add(
	const SmartPtrCInstanceOperationCollectionDoc instanceOperationCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstanceOperationCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(instanceOperationCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCInstanceOperationDoc> instanceOperationVal =
			instanceOperationCollectionDoc->getInstanceOperationCollection();
		CAF_CM_VALIDATE_STL(instanceOperationVal);

		if (! instanceOperationVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCInstanceOperationDoc> > instanceOperationIter(instanceOperationVal);
				instanceOperationIter; instanceOperationIter++) {
				const SmartPtrCXmlElement instanceOperationXml =
					thisXml->createAndAddElement("instanceOperation");
				InstanceOperationXml::add(*instanceOperationIter, instanceOperationXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCInstanceOperationCollectionDoc InstanceOperationCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstanceOperationCollectionXml", "parse");

	SmartPtrCInstanceOperationCollectionDoc instanceOperationCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection instanceOperationChildrenXml =
			thisXml->findRequiredChildren("instanceOperation");

		std::deque<SmartPtrCInstanceOperationDoc> instanceOperationVal;
		if (! instanceOperationChildrenXml.IsNull() && ! instanceOperationChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> instanceOperationXmlIter(*instanceOperationChildrenXml);
				instanceOperationXmlIter; instanceOperationXmlIter++) {
				const SmartPtrCXmlElement instanceOperationXml = instanceOperationXmlIter->second;
				const SmartPtrCInstanceOperationDoc instanceOperationDoc =
					InstanceOperationXml::parse(instanceOperationXml);
				instanceOperationVal.push_back(instanceOperationDoc);
			}
		}

		instanceOperationCollectionDoc.CreateInstance();
		instanceOperationCollectionDoc->initialize(
			instanceOperationVal);
	}
	CAF_CM_EXIT;

	return instanceOperationCollectionDoc;
}

