/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimageconvert_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimageconvert
 * @title: gimpimageconvert
 * @short_description: Conversions between RGB, indexed, and grayscale modes.
 *
 * Conversions between RGB, indexed, and grayscale modes.
 **/


/**
 * gimp_image_convert_rgb:
 * @image: The image.
 *
 * Convert specified image to RGB color
 *
 * This procedure converts the specified image to RGB color. This
 * process requires an image in Grayscale or Indexed color mode. No
 * image content is lost in this process aside from the colormap for an
 * indexed image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_convert_rgb (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-convert-rgb",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_convert_grayscale:
 * @image: The image.
 *
 * Convert specified image to grayscale
 *
 * This procedure converts the specified image to grayscale. This
 * process requires an image in RGB or Indexed color mode.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_convert_grayscale (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-convert-grayscale",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_convert_indexed:
 * @image: The image.
 * @dither_type: The dither type to use.
 * @palette_type: The type of palette to use.
 * @num_cols: The number of colors to quantize to, ignored unless (palette_type == GIMP_CONVERT_PALETTE_GENERATE).
 * @alpha_dither: Dither transparency to fake partial opacity.
 * @remove_unused: Remove unused or duplicate color entries from final palette, ignored if (palette_type == GIMP_CONVERT_PALETTE_GENERATE).
 * @palette: The name of the custom palette to use, ignored unless (palette_type == GIMP_CONVERT_PALETTE_CUSTOM).
 *
 * Convert specified image to and Indexed image
 *
 * This procedure converts the specified image to 'indexed' color. This
 * process requires an image in RGB or Grayscale mode. The
 * 'palette_type' specifies what kind of palette to use, A type of '0'
 * means to use an optimal palette of 'num_cols' generated from the
 * colors in the image. A type of '1' means to re-use the previous
 * palette (not currently implemented). A type of '2' means to use the
 * so-called WWW-optimized palette. Type '3' means to use only black
 * and white colors. A type of '4' means to use a palette from the gimp
 * palettes directories. The 'dither type' specifies what kind of
 * dithering to use. '0' means no dithering, '1' means standard
 * Floyd-Steinberg error diffusion, '2' means Floyd-Steinberg error
 * diffusion with reduced bleeding, '3' means dithering based on pixel
 * location ('Fixed' dithering).
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_convert_indexed (GimpImage              *image,
                            GimpConvertDitherType   dither_type,
                            GimpConvertPaletteType  palette_type,
                            gint                    num_cols,
                            gboolean                alpha_dither,
                            gboolean                remove_unused,
                            const gchar            *palette)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_CONVERT_DITHER_TYPE, dither_type,
                                          GIMP_TYPE_CONVERT_PALETTE_TYPE, palette_type,
                                          G_TYPE_INT, num_cols,
                                          G_TYPE_BOOLEAN, alpha_dither,
                                          G_TYPE_BOOLEAN, remove_unused,
                                          G_TYPE_STRING, palette,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-convert-indexed",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_convert_set_dither_matrix:
 * @width: Width of the matrix (0 to reset to default matrix).
 * @height: Height of the matrix (0 to reset to default matrix).
 * @matrix_length: The length of 'matrix'.
 * @matrix: (array length=matrix_length) (element-type guint8): The matrix -- all values must be >= 1.
 *
 * Set dither matrix for conversion to indexed
 *
 * This procedure sets the dither matrix used when converting images to
 * INDEXED mode with positional dithering.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_convert_set_dither_matrix (gint          width,
                                      gint          height,
                                      gint          matrix_length,
                                      const guint8 *matrix)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, width,
                                          G_TYPE_INT, height,
                                          G_TYPE_INT, matrix_length,
                                          GIMP_TYPE_UINT8_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_uint8_array (gimp_value_array_index (args, 3), matrix, matrix_length);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-convert-set-dither-matrix",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_convert_precision:
 * @image: The image.
 * @precision: The new precision.
 *
 * Convert the image to the specified precision
 *
 * This procedure converts the image to the specified precision. Note
 * that indexed images cannot be converted and are always in
 * GIMP_PRECISION_U8.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_image_convert_precision (GimpImage     *image,
                              GimpPrecision  precision)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_PRECISION, precision,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-convert-precision",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
