/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "e-dbus-address-book.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_vcards,
        guint arg_opflags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_uid,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOXED_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBoxedBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_query,
        const gchar *const *arg_sort_keys,
        const gchar *const *arg_sort_types,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBoxedBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBoxedBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boxed (param_values + 3),
              g_marshal_value_peek_boxed (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.evolution.dataserver.AddressBook
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:EDBusAddressBook
 * @title: EDBusAddressBook
 * @short_description: Generated C code for the org.gnome.evolution.dataserver.AddressBook D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBook.top_of_page">org.gnome.evolution.dataserver.AddressBook</link> D-Bus interface in C.
 */

enum
{
  E_DBUS__ADDRESS_BOOK_ERROR,
};

static unsigned E_DBUS__ADDRESS_BOOK_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.evolution.dataserver.AddressBook ---- */

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_retrieve_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_retrieve_properties_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_retrieve_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_retrieve_properties =
{
  {
    -1,
    (gchar *) "RetrieveProperties",
    NULL,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_retrieve_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-retrieve-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_open_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_open_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_open_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_open =
{
  {
    -1,
    (gchar *) "Open",
    NULL,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_open_OUT_ARG_pointers,
    NULL
  },
  "handle-open",
  FALSE
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_refresh =
{
  {
    -1,
    (gchar *) "Refresh",
    NULL,
    NULL,
    NULL
  },
  "handle-refresh",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_create_contacts_IN_ARG_vcards =
{
  {
    -1,
    (gchar *) "vcards",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_create_contacts_IN_ARG_opflags =
{
  {
    -1,
    (gchar *) "opflags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_create_contacts_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_create_contacts_IN_ARG_vcards.parent_struct,
  &_e_dbus_address_book_method_info_create_contacts_IN_ARG_opflags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_create_contacts_OUT_ARG_uids =
{
  {
    -1,
    (gchar *) "uids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_create_contacts_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_create_contacts_OUT_ARG_uids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_create_contacts =
{
  {
    -1,
    (gchar *) "CreateContacts",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_create_contacts_IN_ARG_pointers,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_create_contacts_OUT_ARG_pointers,
    NULL
  },
  "handle-create-contacts",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_modify_contacts_IN_ARG_vcards =
{
  {
    -1,
    (gchar *) "vcards",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_modify_contacts_IN_ARG_opflags =
{
  {
    -1,
    (gchar *) "opflags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_modify_contacts_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_modify_contacts_IN_ARG_vcards.parent_struct,
  &_e_dbus_address_book_method_info_modify_contacts_IN_ARG_opflags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_modify_contacts =
{
  {
    -1,
    (gchar *) "ModifyContacts",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_modify_contacts_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-modify-contacts",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_remove_contacts_IN_ARG_uids =
{
  {
    -1,
    (gchar *) "uids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_remove_contacts_IN_ARG_opflags =
{
  {
    -1,
    (gchar *) "opflags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_remove_contacts_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_remove_contacts_IN_ARG_uids.parent_struct,
  &_e_dbus_address_book_method_info_remove_contacts_IN_ARG_opflags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_remove_contacts =
{
  {
    -1,
    (gchar *) "RemoveContacts",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_remove_contacts_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-contacts",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_contact_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_contact_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_contact_IN_ARG_uid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_contact_OUT_ARG_vcard =
{
  {
    -1,
    (gchar *) "vcard",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_contact_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_contact_OUT_ARG_vcard.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_get_contact =
{
  {
    -1,
    (gchar *) "GetContact",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_contact_IN_ARG_pointers,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_contact_OUT_ARG_pointers,
    NULL
  },
  "handle-get-contact",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_contact_list_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_contact_list_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_contact_list_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_contact_list_OUT_ARG_vcards =
{
  {
    -1,
    (gchar *) "vcards",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_contact_list_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_contact_list_OUT_ARG_vcards.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_get_contact_list =
{
  {
    -1,
    (gchar *) "GetContactList",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_contact_list_IN_ARG_pointers,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_contact_list_OUT_ARG_pointers,
    NULL
  },
  "handle-get-contact-list",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_contact_list_uids_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_contact_list_uids_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_contact_list_uids_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_contact_list_uids_OUT_ARG_uids =
{
  {
    -1,
    (gchar *) "uids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_contact_list_uids_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_contact_list_uids_OUT_ARG_uids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_get_contact_list_uids =
{
  {
    -1,
    (gchar *) "GetContactListUids",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_contact_list_uids_IN_ARG_pointers,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_contact_list_uids_OUT_ARG_pointers,
    NULL
  },
  "handle-get-contact-list-uids",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_view_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_view_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_view_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_view_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_view_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_view_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_get_view =
{
  {
    -1,
    (gchar *) "GetView",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_view_IN_ARG_pointers,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_view_OUT_ARG_pointers,
    NULL
  },
  "handle-get-view",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_cursor_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_cursor_IN_ARG_sort_keys =
{
  {
    -1,
    (gchar *) "sort_keys",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_cursor_IN_ARG_sort_types =
{
  {
    -1,
    (gchar *) "sort_types",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_cursor_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_cursor_IN_ARG_query.parent_struct,
  &_e_dbus_address_book_method_info_get_cursor_IN_ARG_sort_keys.parent_struct,
  &_e_dbus_address_book_method_info_get_cursor_IN_ARG_sort_types.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_get_cursor_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_get_cursor_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_get_cursor_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_get_cursor =
{
  {
    -1,
    (gchar *) "GetCursor",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_cursor_IN_ARG_pointers,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_get_cursor_OUT_ARG_pointers,
    NULL
  },
  "handle-get-cursor",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_contains_email_IN_ARG_email =
{
  {
    -1,
    (gchar *) "email",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_contains_email_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_contains_email_IN_ARG_email.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_method_info_contains_email_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_method_info_contains_email_OUT_ARG_pointers[] =
{
  &_e_dbus_address_book_method_info_contains_email_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_method_info_contains_email =
{
  {
    -1,
    (gchar *) "ContainsEmail",
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_contains_email_IN_ARG_pointers,
    (GDBusArgInfo **) &_e_dbus_address_book_method_info_contains_email_OUT_ARG_pointers,
    NULL
  },
  "handle-contains-email",
  FALSE
};

static const GDBusMethodInfo * const _e_dbus_address_book_method_info_pointers[] =
{
  &_e_dbus_address_book_method_info_retrieve_properties.parent_struct,
  &_e_dbus_address_book_method_info_open.parent_struct,
  &_e_dbus_address_book_method_info_close.parent_struct,
  &_e_dbus_address_book_method_info_refresh.parent_struct,
  &_e_dbus_address_book_method_info_create_contacts.parent_struct,
  &_e_dbus_address_book_method_info_modify_contacts.parent_struct,
  &_e_dbus_address_book_method_info_remove_contacts.parent_struct,
  &_e_dbus_address_book_method_info_get_contact.parent_struct,
  &_e_dbus_address_book_method_info_get_contact_list.parent_struct,
  &_e_dbus_address_book_method_info_get_contact_list_uids.parent_struct,
  &_e_dbus_address_book_method_info_get_view.parent_struct,
  &_e_dbus_address_book_method_info_get_cursor.parent_struct,
  &_e_dbus_address_book_method_info_contains_email.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_signal_info_error_ARG_error_message =
{
  {
    -1,
    (gchar *) "error_message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_signal_info_error_ARG_pointers[] =
{
  &_e_dbus_address_book_signal_info_error_ARG_error_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _e_dbus_address_book_signal_info_error =
{
  {
    -1,
    (gchar *) "Error",
    (GDBusArgInfo **) &_e_dbus_address_book_signal_info_error_ARG_pointers,
    NULL
  },
  "error"
};

static const GDBusSignalInfo * const _e_dbus_address_book_signal_info_pointers[] =
{
  &_e_dbus_address_book_signal_info_error.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_online =
{
  {
    -1,
    (gchar *) "Online",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "online",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_revision =
{
  {
    -1,
    (gchar *) "Revision",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "revision",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_locale =
{
  {
    -1,
    (gchar *) "Locale",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "locale",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_writable =
{
  {
    -1,
    (gchar *) "Writable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "writable",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_categories =
{
  {
    -1,
    (gchar *) "Categories",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "categories",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_cache_dir =
{
  {
    -1,
    (gchar *) "CacheDir",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "cache-dir",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_capabilities =
{
  {
    -1,
    (gchar *) "Capabilities",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "capabilities",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_required_fields =
{
  {
    -1,
    (gchar *) "RequiredFields",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "required-fields",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _e_dbus_address_book_property_info_supported_fields =
{
  {
    -1,
    (gchar *) "SupportedFields",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-fields",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _e_dbus_address_book_property_info_pointers[] =
{
  &_e_dbus_address_book_property_info_online.parent_struct,
  &_e_dbus_address_book_property_info_revision.parent_struct,
  &_e_dbus_address_book_property_info_locale.parent_struct,
  &_e_dbus_address_book_property_info_writable.parent_struct,
  &_e_dbus_address_book_property_info_categories.parent_struct,
  &_e_dbus_address_book_property_info_cache_dir.parent_struct,
  &_e_dbus_address_book_property_info_capabilities.parent_struct,
  &_e_dbus_address_book_property_info_required_fields.parent_struct,
  &_e_dbus_address_book_property_info_supported_fields.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _e_dbus_address_book_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.evolution.dataserver.AddressBook",
    (GDBusMethodInfo **) &_e_dbus_address_book_method_info_pointers,
    (GDBusSignalInfo **) &_e_dbus_address_book_signal_info_pointers,
    (GDBusPropertyInfo **) &_e_dbus_address_book_property_info_pointers,
    NULL
  },
  "address-book",
};


/**
 * e_dbus_address_book_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBook.top_of_page">org.gnome.evolution.dataserver.AddressBook</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 *
 * Since: 3.8
 */
GDBusInterfaceInfo *
e_dbus_address_book_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_e_dbus_address_book_interface_info.parent_struct;
}

/**
 * e_dbus_address_book_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #EDBusAddressBook interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 *
 * Since: 3.8
 */
guint
e_dbus_address_book_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "online");
  g_object_class_override_property (klass, property_id_begin++, "revision");
  g_object_class_override_property (klass, property_id_begin++, "locale");
  g_object_class_override_property (klass, property_id_begin++, "writable");
  g_object_class_override_property (klass, property_id_begin++, "categories");
  g_object_class_override_property (klass, property_id_begin++, "cache-dir");
  g_object_class_override_property (klass, property_id_begin++, "capabilities");
  g_object_class_override_property (klass, property_id_begin++, "required-fields");
  g_object_class_override_property (klass, property_id_begin++, "supported-fields");
  return property_id_begin - 1;
}


inline static void
e_dbus_address_book_signal_marshal_error (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_retrieve_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_open (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_refresh (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_create_contacts (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_modify_contacts (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_remove_contacts (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_get_contact (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_get_contact_list (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_get_contact_list_uids (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_get_view (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_get_cursor (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOXED_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
e_dbus_address_book_method_marshal_contains_email (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * EDBusAddressBook:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBook.top_of_page">org.gnome.evolution.dataserver.AddressBook</link>.
 *
 * Since: 3.8
 */

/**
 * EDBusAddressBookIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #EDBusAddressBook::handle-close signal.
 * @handle_contains_email: Handler for the #EDBusAddressBook::handle-contains-email signal.
 * @handle_create_contacts: Handler for the #EDBusAddressBook::handle-create-contacts signal.
 * @handle_get_contact: Handler for the #EDBusAddressBook::handle-get-contact signal.
 * @handle_get_contact_list: Handler for the #EDBusAddressBook::handle-get-contact-list signal.
 * @handle_get_contact_list_uids: Handler for the #EDBusAddressBook::handle-get-contact-list-uids signal.
 * @handle_get_cursor: Handler for the #EDBusAddressBook::handle-get-cursor signal.
 * @handle_get_view: Handler for the #EDBusAddressBook::handle-get-view signal.
 * @handle_modify_contacts: Handler for the #EDBusAddressBook::handle-modify-contacts signal.
 * @handle_open: Handler for the #EDBusAddressBook::handle-open signal.
 * @handle_refresh: Handler for the #EDBusAddressBook::handle-refresh signal.
 * @handle_remove_contacts: Handler for the #EDBusAddressBook::handle-remove-contacts signal.
 * @handle_retrieve_properties: Handler for the #EDBusAddressBook::handle-retrieve-properties signal.
 * @get_cache_dir: Getter for the #EDBusAddressBook:cache-dir property.
 * @get_capabilities: Getter for the #EDBusAddressBook:capabilities property.
 * @get_categories: Getter for the #EDBusAddressBook:categories property.
 * @get_locale: Getter for the #EDBusAddressBook:locale property.
 * @get_online: Getter for the #EDBusAddressBook:online property.
 * @get_required_fields: Getter for the #EDBusAddressBook:required-fields property.
 * @get_revision: Getter for the #EDBusAddressBook:revision property.
 * @get_supported_fields: Getter for the #EDBusAddressBook:supported-fields property.
 * @get_writable: Getter for the #EDBusAddressBook:writable property.
 * @error: Handler for the #EDBusAddressBook::error signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBook.top_of_page">org.gnome.evolution.dataserver.AddressBook</link>.
 *
 * Since: 3.8
 */

typedef EDBusAddressBookIface EDBusAddressBookInterface;
G_DEFINE_INTERFACE (EDBusAddressBook, e_dbus_address_book, G_TYPE_OBJECT)

static void
e_dbus_address_book_default_init (EDBusAddressBookIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * EDBusAddressBook::handle-retrieve-properties:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RetrieveProperties">RetrieveProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_retrieve_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-retrieve-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_retrieve_properties),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_retrieve_properties,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * EDBusAddressBook::handle-open:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Open">Open()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_open() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-open",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_open),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_open,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * EDBusAddressBook::handle-close:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * EDBusAddressBook::handle-refresh:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Refresh">Refresh()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_refresh() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-refresh",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_refresh),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_refresh,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * EDBusAddressBook::handle-create-contacts:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_vcards: Argument passed by remote caller.
   * @arg_opflags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.CreateContacts">CreateContacts()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_create_contacts() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-create-contacts",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_create_contacts),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_create_contacts,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_UINT);

  /**
   * EDBusAddressBook::handle-modify-contacts:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_vcards: Argument passed by remote caller.
   * @arg_opflags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ModifyContacts">ModifyContacts()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_modify_contacts() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-modify-contacts",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_modify_contacts),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_modify_contacts,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_UINT);

  /**
   * EDBusAddressBook::handle-remove-contacts:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uids: Argument passed by remote caller.
   * @arg_opflags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RemoveContacts">RemoveContacts()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_remove_contacts() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-remove-contacts",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_remove_contacts),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_remove_contacts,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_UINT);

  /**
   * EDBusAddressBook::handle-get-contact:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContact">GetContact()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_get_contact() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-get-contact",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_get_contact),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_get_contact,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * EDBusAddressBook::handle-get-contact-list:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactList">GetContactList()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_get_contact_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-get-contact-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_get_contact_list),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_get_contact_list,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * EDBusAddressBook::handle-get-contact-list-uids:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactListUids">GetContactListUids()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_get_contact_list_uids() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-get-contact-list-uids",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_get_contact_list_uids),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_get_contact_list_uids,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * EDBusAddressBook::handle-get-view:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetView">GetView()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_get_view() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-get-view",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_get_view),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_get_view,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * EDBusAddressBook::handle-get-cursor:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_query: Argument passed by remote caller.
   * @arg_sort_keys: Argument passed by remote caller.
   * @arg_sort_types: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetCursor">GetCursor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_get_cursor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-get-cursor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_get_cursor),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_get_cursor,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRV);

  /**
   * EDBusAddressBook::handle-contains-email:
   * @object: A #EDBusAddressBook.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_email: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ContainsEmail">ContainsEmail()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_complete_contains_email() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.8
   */
  g_signal_new ("handle-contains-email",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookIface, handle_contains_email),
    g_signal_accumulator_true_handled,
    NULL,
      e_dbus_address_book_method_marshal_contains_email,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * EDBusAddressBook::error:
   * @object: A #EDBusAddressBook.
   * @arg_error_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBook.Error">"Error"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Since: 3.8
   */
  E_DBUS__ADDRESS_BOOK_SIGNALS[E_DBUS__ADDRESS_BOOK_ERROR] =
    g_signal_new ("error",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (EDBusAddressBookIface, error),
      NULL,
      NULL,
      e_dbus_address_book_signal_marshal_error,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * EDBusAddressBook:online:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Online">"Online"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("online", "Online", "Online", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:revision:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Revision">"Revision"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("revision", "Revision", "Revision", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:locale:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Locale">"Locale"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("locale", "Locale", "Locale", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:writable:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Writable">"Writable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("writable", "Writable", "Writable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:categories:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Categories">"Categories"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("categories", "Categories", "Categories", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:cache-dir:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.CacheDir">"CacheDir"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("cache-dir", "CacheDir", "CacheDir", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:capabilities:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Capabilities">"Capabilities"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("capabilities", "Capabilities", "Capabilities", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:required-fields:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.RequiredFields">"RequiredFields"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("required-fields", "RequiredFields", "RequiredFields", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * EDBusAddressBook:supported-fields:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.SupportedFields">"SupportedFields"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 3.8
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("supported-fields", "SupportedFields", "SupportedFields", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * e_dbus_address_book_get_online: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Online">"Online"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 3.8
 */
gboolean 
e_dbus_address_book_get_online (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), FALSE);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_online (object);
}

/**
 * e_dbus_address_book_set_online: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Online">"Online"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_online (EDBusAddressBook *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "online", value, NULL);
}

/**
 * e_dbus_address_book_get_revision: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Revision">"Revision"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use e_dbus_address_book_dup_revision() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 3.8
 */
const gchar *
e_dbus_address_book_get_revision (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), NULL);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_revision (object);
}

/**
 * e_dbus_address_book_dup_revision: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Revision">"Revision"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 3.8
 */
gchar *
e_dbus_address_book_dup_revision (EDBusAddressBook *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "revision", &value, NULL);
  return value;
}

/**
 * e_dbus_address_book_set_revision: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Revision">"Revision"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_revision (EDBusAddressBook *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "revision", value, NULL);
}

/**
 * e_dbus_address_book_get_locale: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Locale">"Locale"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use e_dbus_address_book_dup_locale() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 3.8
 */
const gchar *
e_dbus_address_book_get_locale (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), NULL);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_locale (object);
}

/**
 * e_dbus_address_book_dup_locale: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Locale">"Locale"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 3.8
 */
gchar *
e_dbus_address_book_dup_locale (EDBusAddressBook *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "locale", &value, NULL);
  return value;
}

/**
 * e_dbus_address_book_set_locale: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Locale">"Locale"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_locale (EDBusAddressBook *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "locale", value, NULL);
}

/**
 * e_dbus_address_book_get_writable: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Writable">"Writable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 3.8
 */
gboolean 
e_dbus_address_book_get_writable (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), FALSE);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_writable (object);
}

/**
 * e_dbus_address_book_set_writable: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Writable">"Writable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_writable (EDBusAddressBook *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "writable", value, NULL);
}

/**
 * e_dbus_address_book_get_categories: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Categories">"Categories"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use e_dbus_address_book_dup_categories() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 3.8
 */
const gchar *const *
e_dbus_address_book_get_categories (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), NULL);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_categories (object);
}

/**
 * e_dbus_address_book_dup_categories: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Categories">"Categories"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 *
 * Since: 3.8
 */
gchar **
e_dbus_address_book_dup_categories (EDBusAddressBook *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "categories", &value, NULL);
  return value;
}

/**
 * e_dbus_address_book_set_categories: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Categories">"Categories"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_categories (EDBusAddressBook *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "categories", value, NULL);
}

/**
 * e_dbus_address_book_get_cache_dir: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.CacheDir">"CacheDir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use e_dbus_address_book_dup_cache_dir() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 3.8
 */
const gchar *
e_dbus_address_book_get_cache_dir (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), NULL);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_cache_dir (object);
}

/**
 * e_dbus_address_book_dup_cache_dir: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.CacheDir">"CacheDir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 3.8
 */
gchar *
e_dbus_address_book_dup_cache_dir (EDBusAddressBook *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "cache-dir", &value, NULL);
  return value;
}

/**
 * e_dbus_address_book_set_cache_dir: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.CacheDir">"CacheDir"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_cache_dir (EDBusAddressBook *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "cache-dir", value, NULL);
}

/**
 * e_dbus_address_book_get_capabilities: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Capabilities">"Capabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use e_dbus_address_book_dup_capabilities() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 3.8
 */
const gchar *const *
e_dbus_address_book_get_capabilities (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), NULL);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_capabilities (object);
}

/**
 * e_dbus_address_book_dup_capabilities: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Capabilities">"Capabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 *
 * Since: 3.8
 */
gchar **
e_dbus_address_book_dup_capabilities (EDBusAddressBook *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "capabilities", &value, NULL);
  return value;
}

/**
 * e_dbus_address_book_set_capabilities: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.Capabilities">"Capabilities"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_capabilities (EDBusAddressBook *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "capabilities", value, NULL);
}

/**
 * e_dbus_address_book_get_required_fields: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.RequiredFields">"RequiredFields"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use e_dbus_address_book_dup_required_fields() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 3.8
 */
const gchar *const *
e_dbus_address_book_get_required_fields (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), NULL);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_required_fields (object);
}

/**
 * e_dbus_address_book_dup_required_fields: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.RequiredFields">"RequiredFields"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 *
 * Since: 3.8
 */
gchar **
e_dbus_address_book_dup_required_fields (EDBusAddressBook *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "required-fields", &value, NULL);
  return value;
}

/**
 * e_dbus_address_book_set_required_fields: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.RequiredFields">"RequiredFields"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_required_fields (EDBusAddressBook *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "required-fields", value, NULL);
}

/**
 * e_dbus_address_book_get_supported_fields: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.SupportedFields">"SupportedFields"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use e_dbus_address_book_dup_supported_fields() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 3.8
 */
const gchar *const *
e_dbus_address_book_get_supported_fields (EDBusAddressBook *object)
{
  g_return_val_if_fail (E_DBUS_IS_ADDRESS_BOOK (object), NULL);

  return E_DBUS_ADDRESS_BOOK_GET_IFACE (object)->get_supported_fields (object);
}

/**
 * e_dbus_address_book_dup_supported_fields: (skip)
 * @object: A #EDBusAddressBook.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.SupportedFields">"SupportedFields"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 *
 * Since: 3.8
 */
gchar **
e_dbus_address_book_dup_supported_fields (EDBusAddressBook *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "supported-fields", &value, NULL);
  return value;
}

/**
 * e_dbus_address_book_set_supported_fields: (skip)
 * @object: A #EDBusAddressBook.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-evolution-dataserver-AddressBook.SupportedFields">"SupportedFields"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_set_supported_fields (EDBusAddressBook *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "supported-fields", value, NULL);
}

/**
 * e_dbus_address_book_emit_error:
 * @object: A #EDBusAddressBook.
 * @arg_error_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBook.Error">"Error"</link> D-Bus signal.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_emit_error (
    EDBusAddressBook *object,
    const gchar *arg_error_message)
{
  g_signal_emit (object, E_DBUS__ADDRESS_BOOK_SIGNALS[E_DBUS__ADDRESS_BOOK_ERROR], 0, arg_error_message);
}

/**
 * e_dbus_address_book_call_retrieve_properties:
 * @proxy: A #EDBusAddressBookProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RetrieveProperties">RetrieveProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_retrieve_properties_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_retrieve_properties_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_retrieve_properties (
    EDBusAddressBook *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RetrieveProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_retrieve_properties_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_properties: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_retrieve_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_retrieve_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_retrieve_properties_finish (
    EDBusAddressBook *proxy,
    gchar ***out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_retrieve_properties_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_properties: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RetrieveProperties">RetrieveProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_retrieve_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_retrieve_properties_sync (
    EDBusAddressBook *proxy,
    gchar ***out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RetrieveProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_open:
 * @proxy: A #EDBusAddressBookProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Open">Open()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_open_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_open_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_open (
    EDBusAddressBook *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_open_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_properties: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_open().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_open().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_open_finish (
    EDBusAddressBook *proxy,
    gchar ***out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_open_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_properties: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Open">Open()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_open() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_open_sync (
    EDBusAddressBook *proxy,
    gchar ***out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_close:
 * @proxy: A #EDBusAddressBookProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_close_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_close_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_close (
    EDBusAddressBook *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_close_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_close_finish (
    EDBusAddressBook *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_close_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_close_sync (
    EDBusAddressBook *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_refresh:
 * @proxy: A #EDBusAddressBookProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Refresh">Refresh()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_refresh_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_refresh_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_refresh (
    EDBusAddressBook *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Refresh",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_refresh_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_refresh().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_refresh().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_refresh_finish (
    EDBusAddressBook *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_refresh_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Refresh">Refresh()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_refresh() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_refresh_sync (
    EDBusAddressBook *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Refresh",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_create_contacts:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_vcards: Argument to pass with the method invocation.
 * @arg_opflags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.CreateContacts">CreateContacts()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_create_contacts_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_create_contacts_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_create_contacts (
    EDBusAddressBook *proxy,
    const gchar *const *arg_vcards,
    guint arg_opflags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateContacts",
    g_variant_new ("(^asu)",
                   arg_vcards,
                   arg_opflags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_create_contacts_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_uids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_create_contacts().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_create_contacts().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_create_contacts_finish (
    EDBusAddressBook *proxy,
    gchar ***out_uids,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_uids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_create_contacts_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_vcards: Argument to pass with the method invocation.
 * @arg_opflags: Argument to pass with the method invocation.
 * @out_uids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.CreateContacts">CreateContacts()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_create_contacts() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_create_contacts_sync (
    EDBusAddressBook *proxy,
    const gchar *const *arg_vcards,
    guint arg_opflags,
    gchar ***out_uids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateContacts",
    g_variant_new ("(^asu)",
                   arg_vcards,
                   arg_opflags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_uids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_modify_contacts:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_vcards: Argument to pass with the method invocation.
 * @arg_opflags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ModifyContacts">ModifyContacts()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_modify_contacts_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_modify_contacts_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_modify_contacts (
    EDBusAddressBook *proxy,
    const gchar *const *arg_vcards,
    guint arg_opflags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ModifyContacts",
    g_variant_new ("(^asu)",
                   arg_vcards,
                   arg_opflags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_modify_contacts_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_modify_contacts().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_modify_contacts().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_modify_contacts_finish (
    EDBusAddressBook *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_modify_contacts_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_vcards: Argument to pass with the method invocation.
 * @arg_opflags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ModifyContacts">ModifyContacts()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_modify_contacts() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_modify_contacts_sync (
    EDBusAddressBook *proxy,
    const gchar *const *arg_vcards,
    guint arg_opflags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ModifyContacts",
    g_variant_new ("(^asu)",
                   arg_vcards,
                   arg_opflags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_remove_contacts:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_uids: Argument to pass with the method invocation.
 * @arg_opflags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RemoveContacts">RemoveContacts()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_remove_contacts_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_remove_contacts_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_remove_contacts (
    EDBusAddressBook *proxy,
    const gchar *const *arg_uids,
    guint arg_opflags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveContacts",
    g_variant_new ("(^asu)",
                   arg_uids,
                   arg_opflags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_remove_contacts_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_remove_contacts().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_remove_contacts().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_remove_contacts_finish (
    EDBusAddressBook *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_remove_contacts_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_uids: Argument to pass with the method invocation.
 * @arg_opflags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RemoveContacts">RemoveContacts()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_remove_contacts() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_remove_contacts_sync (
    EDBusAddressBook *proxy,
    const gchar *const *arg_uids,
    guint arg_opflags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveContacts",
    g_variant_new ("(^asu)",
                   arg_uids,
                   arg_opflags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_contact:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContact">GetContact()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_get_contact_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_get_contact_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_get_contact (
    EDBusAddressBook *proxy,
    const gchar *arg_uid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetContact",
    g_variant_new ("(s)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_get_contact_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_vcard: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_get_contact().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_get_contact().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_contact_finish (
    EDBusAddressBook *proxy,
    gchar **out_vcard,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_vcard);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_contact_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @out_vcard: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContact">GetContact()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_get_contact() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_contact_sync (
    EDBusAddressBook *proxy,
    const gchar *arg_uid,
    gchar **out_vcard,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetContact",
    g_variant_new ("(s)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_vcard);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_contact_list:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactList">GetContactList()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_get_contact_list_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_get_contact_list_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_get_contact_list (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetContactList",
    g_variant_new ("(s)",
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_get_contact_list_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_vcards: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_get_contact_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_get_contact_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_contact_list_finish (
    EDBusAddressBook *proxy,
    gchar ***out_vcards,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_vcards);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_contact_list_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @out_vcards: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactList">GetContactList()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_get_contact_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_contact_list_sync (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    gchar ***out_vcards,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetContactList",
    g_variant_new ("(s)",
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_vcards);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_contact_list_uids:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactListUids">GetContactListUids()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_get_contact_list_uids_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_get_contact_list_uids_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_get_contact_list_uids (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetContactListUids",
    g_variant_new ("(s)",
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_get_contact_list_uids_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_uids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_get_contact_list_uids().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_get_contact_list_uids().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_contact_list_uids_finish (
    EDBusAddressBook *proxy,
    gchar ***out_uids,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_uids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_contact_list_uids_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @out_uids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactListUids">GetContactListUids()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_get_contact_list_uids() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_contact_list_uids_sync (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    gchar ***out_uids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetContactListUids",
    g_variant_new ("(s)",
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_uids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_view:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetView">GetView()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_get_view_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_get_view_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_get_view (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetView",
    g_variant_new ("(s)",
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_get_view_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_get_view().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_get_view().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_view_finish (
    EDBusAddressBook *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_view_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetView">GetView()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_get_view() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_view_sync (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetView",
    g_variant_new ("(s)",
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_cursor:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @arg_sort_keys: Argument to pass with the method invocation.
 * @arg_sort_types: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetCursor">GetCursor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_get_cursor_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_get_cursor_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_get_cursor (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    const gchar *const *arg_sort_keys,
    const gchar *const *arg_sort_types,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCursor",
    g_variant_new ("(s^as^as)",
                   arg_query,
                   arg_sort_keys,
                   arg_sort_types),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_get_cursor_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_get_cursor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_get_cursor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_cursor_finish (
    EDBusAddressBook *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_get_cursor_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_query: Argument to pass with the method invocation.
 * @arg_sort_keys: Argument to pass with the method invocation.
 * @arg_sort_types: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetCursor">GetCursor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_get_cursor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_get_cursor_sync (
    EDBusAddressBook *proxy,
    const gchar *arg_query,
    const gchar *const *arg_sort_keys,
    const gchar *const *arg_sort_types,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCursor",
    g_variant_new ("(s^as^as)",
                   arg_query,
                   arg_sort_keys,
                   arg_sort_types),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_contains_email:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_email: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ContainsEmail">ContainsEmail()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_call_contains_email_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_call_contains_email_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_call_contains_email (
    EDBusAddressBook *proxy,
    const gchar *arg_email,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ContainsEmail",
    g_variant_new ("(s)",
                   arg_email),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_call_contains_email_finish:
 * @proxy: A #EDBusAddressBookProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_call_contains_email().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_call_contains_email().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_contains_email_finish (
    EDBusAddressBook *proxy,
    gboolean *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_call_contains_email_sync:
 * @proxy: A #EDBusAddressBookProxy.
 * @arg_email: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ContainsEmail">ContainsEmail()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_call_contains_email() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.8
 */
gboolean
e_dbus_address_book_call_contains_email_sync (
    EDBusAddressBook *proxy,
    const gchar *arg_email,
    gboolean *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ContainsEmail",
    g_variant_new ("(s)",
                   arg_email),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_complete_retrieve_properties:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RetrieveProperties">RetrieveProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_retrieve_properties (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   properties));
}

/**
 * e_dbus_address_book_complete_open:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Open">Open()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_open (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   properties));
}

/**
 * e_dbus_address_book_complete_close:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_close (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_complete_refresh:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.Refresh">Refresh()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_refresh (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_complete_create_contacts:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @uids: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.CreateContacts">CreateContacts()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_create_contacts (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *uids)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   uids));
}

/**
 * e_dbus_address_book_complete_modify_contacts:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ModifyContacts">ModifyContacts()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_modify_contacts (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_complete_remove_contacts:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.RemoveContacts">RemoveContacts()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_remove_contacts (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_complete_get_contact:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @vcard: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContact">GetContact()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_get_contact (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *vcard)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   vcard));
}

/**
 * e_dbus_address_book_complete_get_contact_list:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @vcards: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactList">GetContactList()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_get_contact_list (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *vcards)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   vcards));
}

/**
 * e_dbus_address_book_complete_get_contact_list_uids:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @uids: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetContactListUids">GetContactListUids()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_get_contact_list_uids (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *uids)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   uids));
}

/**
 * e_dbus_address_book_complete_get_view:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetView">GetView()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_get_view (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/**
 * e_dbus_address_book_complete_get_cursor:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.GetCursor">GetCursor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_get_cursor (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/**
 * e_dbus_address_book_complete_contains_email:
 * @object: A #EDBusAddressBook.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBook.ContainsEmail">ContainsEmail()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_complete_contains_email (
    EDBusAddressBook *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   result));
}

/* ------------------------------------------------------------------------ */

/**
 * EDBusAddressBookProxy:
 *
 * The #EDBusAddressBookProxy structure contains only private data and should only be accessed using the provided API.
 *
 * Since: 3.8
 */

/**
 * EDBusAddressBookProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EDBusAddressBookProxy.
 *
 * Since: 3.8
 */

struct _EDBusAddressBookProxyPrivate
{
  GData *qdata;
};

static void e_dbus_address_book_proxy_iface_init (EDBusAddressBookIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookProxy, e_dbus_address_book_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (EDBusAddressBookProxy)
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK, e_dbus_address_book_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookProxy, e_dbus_address_book_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK, e_dbus_address_book_proxy_iface_init))

#endif
static void
e_dbus_address_book_proxy_finalize (GObject *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (e_dbus_address_book_proxy_parent_class)->finalize (object);
}

static void
e_dbus_address_book_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _e_dbus_address_book_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
e_dbus_address_book_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.evolution.dataserver.AddressBook: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
e_dbus_address_book_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _e_dbus_address_book_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.evolution.dataserver.AddressBook", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) e_dbus_address_book_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
e_dbus_address_book_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_e_dbus_address_book_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], E_DBUS_TYPE_ADDRESS_BOOK);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, E_DBUS_TYPE_ADDRESS_BOOK);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
e_dbus_address_book_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
e_dbus_address_book_proxy_get_online (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Online");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
e_dbus_address_book_proxy_get_revision (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Revision");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
e_dbus_address_book_proxy_get_locale (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Locale");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
e_dbus_address_book_proxy_get_writable (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Writable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
e_dbus_address_book_proxy_get_categories (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Categories");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Categories");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Categories", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
e_dbus_address_book_proxy_get_cache_dir (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CacheDir");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
e_dbus_address_book_proxy_get_capabilities (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Capabilities");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Capabilities");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Capabilities", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
e_dbus_address_book_proxy_get_required_fields (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "RequiredFields");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RequiredFields");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "RequiredFields", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
e_dbus_address_book_proxy_get_supported_fields (EDBusAddressBook *object)
{
  EDBusAddressBookProxy *proxy = E_DBUS_ADDRESS_BOOK_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SupportedFields");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedFields");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SupportedFields", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
e_dbus_address_book_proxy_init (EDBusAddressBookProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = e_dbus_address_book_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, E_DBUS_TYPE_ADDRESS_BOOK_PROXY, EDBusAddressBookProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), e_dbus_address_book_interface_info ());
}

static void
e_dbus_address_book_proxy_class_init (EDBusAddressBookProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = e_dbus_address_book_proxy_finalize;
  gobject_class->get_property = e_dbus_address_book_proxy_get_property;
  gobject_class->set_property = e_dbus_address_book_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = e_dbus_address_book_proxy_g_signal;
  proxy_class->g_properties_changed = e_dbus_address_book_proxy_g_properties_changed;

  e_dbus_address_book_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EDBusAddressBookProxyPrivate));
#endif
}

static void
e_dbus_address_book_proxy_iface_init (EDBusAddressBookIface *iface)
{
  iface->get_online = e_dbus_address_book_proxy_get_online;
  iface->get_revision = e_dbus_address_book_proxy_get_revision;
  iface->get_locale = e_dbus_address_book_proxy_get_locale;
  iface->get_writable = e_dbus_address_book_proxy_get_writable;
  iface->get_categories = e_dbus_address_book_proxy_get_categories;
  iface->get_cache_dir = e_dbus_address_book_proxy_get_cache_dir;
  iface->get_capabilities = e_dbus_address_book_proxy_get_capabilities;
  iface->get_required_fields = e_dbus_address_book_proxy_get_required_fields;
  iface->get_supported_fields = e_dbus_address_book_proxy_get_supported_fields;
}

/**
 * e_dbus_address_book_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBook.top_of_page">org.gnome.evolution.dataserver.AddressBook</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_proxy_new_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_proxy_new_sync() for the synchronous, blocking version of this constructor.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (E_DBUS_TYPE_ADDRESS_BOOK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBook", NULL);
}

/**
 * e_dbus_address_book_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with e_dbus_address_book_proxy_new().
 *
 * Returns: (transfer full) (type EDBusAddressBookProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.8
 */
EDBusAddressBook *
e_dbus_address_book_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK (ret);
  else
    return NULL;
}

/**
 * e_dbus_address_book_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBook.top_of_page">org.gnome.evolution.dataserver.AddressBook</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EDBusAddressBookProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.8
 */
EDBusAddressBook *
e_dbus_address_book_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (E_DBUS_TYPE_ADDRESS_BOOK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBook", NULL);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK (ret);
  else
    return NULL;
}


/**
 * e_dbus_address_book_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like e_dbus_address_book_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 *
 * Since: 3.8
 */
void
e_dbus_address_book_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (E_DBUS_TYPE_ADDRESS_BOOK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBook", NULL);
}

/**
 * e_dbus_address_book_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with e_dbus_address_book_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type EDBusAddressBookProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.8
 */
EDBusAddressBook *
e_dbus_address_book_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK (ret);
  else
    return NULL;
}

/**
 * e_dbus_address_book_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like e_dbus_address_book_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EDBusAddressBookProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.8
 */
EDBusAddressBook *
e_dbus_address_book_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (E_DBUS_TYPE_ADDRESS_BOOK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBook", NULL);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * EDBusAddressBookSkeleton:
 *
 * The #EDBusAddressBookSkeleton structure contains only private data and should only be accessed using the provided API.
 *
 * Since: 3.8
 */

/**
 * EDBusAddressBookSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EDBusAddressBookSkeleton.
 *
 * Since: 3.8
 */

struct _EDBusAddressBookSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_e_dbus_address_book_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], E_DBUS_TYPE_ADDRESS_BOOK);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, E_DBUS_TYPE_ADDRESS_BOOK);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_e_dbus_address_book_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_e_dbus_address_book_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _e_dbus_address_book_skeleton_vtable =
{
  _e_dbus_address_book_skeleton_handle_method_call,
  _e_dbus_address_book_skeleton_handle_get_property,
  _e_dbus_address_book_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
e_dbus_address_book_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return e_dbus_address_book_interface_info ();
}

static GDBusInterfaceVTable *
e_dbus_address_book_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_e_dbus_address_book_skeleton_vtable;
}

static GVariant *
e_dbus_address_book_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_e_dbus_address_book_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _e_dbus_address_book_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _e_dbus_address_book_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _e_dbus_address_book_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBook", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _e_dbus_address_book_emit_changed (gpointer user_data);

static void
e_dbus_address_book_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _e_dbus_address_book_emit_changed (skeleton);
}

static void
_e_dbus_address_book_on_signal_error (
    EDBusAddressBook *object,
    const gchar *arg_error_message)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_error_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBook", "Error",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void e_dbus_address_book_skeleton_iface_init (EDBusAddressBookIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookSkeleton, e_dbus_address_book_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (EDBusAddressBookSkeleton)
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK, e_dbus_address_book_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookSkeleton, e_dbus_address_book_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK, e_dbus_address_book_skeleton_iface_init))

#endif
static void
e_dbus_address_book_skeleton_finalize (GObject *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (e_dbus_address_book_skeleton_parent_class)->finalize (object);
}

static void
e_dbus_address_book_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_e_dbus_address_book_emit_changed (gpointer user_data)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.evolution.dataserver.AddressBook",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_e_dbus_address_book_schedule_emit_changed (EDBusAddressBookSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
e_dbus_address_book_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _e_dbus_address_book_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _e_dbus_address_book_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
e_dbus_address_book_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _e_dbus_address_book_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _e_dbus_address_book_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
e_dbus_address_book_skeleton_init (EDBusAddressBookSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = e_dbus_address_book_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, E_DBUS_TYPE_ADDRESS_BOOK_SKELETON, EDBusAddressBookSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRV);
}

static gboolean 
e_dbus_address_book_skeleton_get_online (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
e_dbus_address_book_skeleton_get_revision (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
e_dbus_address_book_skeleton_get_locale (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
e_dbus_address_book_skeleton_get_writable (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
e_dbus_address_book_skeleton_get_categories (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
e_dbus_address_book_skeleton_get_cache_dir (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
e_dbus_address_book_skeleton_get_capabilities (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
e_dbus_address_book_skeleton_get_required_fields (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
e_dbus_address_book_skeleton_get_supported_fields (EDBusAddressBook *object)
{
  EDBusAddressBookSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
e_dbus_address_book_skeleton_class_init (EDBusAddressBookSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = e_dbus_address_book_skeleton_finalize;
  gobject_class->get_property = e_dbus_address_book_skeleton_get_property;
  gobject_class->set_property = e_dbus_address_book_skeleton_set_property;
  gobject_class->notify       = e_dbus_address_book_skeleton_notify;


  e_dbus_address_book_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = e_dbus_address_book_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = e_dbus_address_book_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = e_dbus_address_book_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = e_dbus_address_book_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EDBusAddressBookSkeletonPrivate));
#endif
}

static void
e_dbus_address_book_skeleton_iface_init (EDBusAddressBookIface *iface)
{
  iface->error = _e_dbus_address_book_on_signal_error;
  iface->get_online = e_dbus_address_book_skeleton_get_online;
  iface->get_revision = e_dbus_address_book_skeleton_get_revision;
  iface->get_locale = e_dbus_address_book_skeleton_get_locale;
  iface->get_writable = e_dbus_address_book_skeleton_get_writable;
  iface->get_categories = e_dbus_address_book_skeleton_get_categories;
  iface->get_cache_dir = e_dbus_address_book_skeleton_get_cache_dir;
  iface->get_capabilities = e_dbus_address_book_skeleton_get_capabilities;
  iface->get_required_fields = e_dbus_address_book_skeleton_get_required_fields;
  iface->get_supported_fields = e_dbus_address_book_skeleton_get_supported_fields;
}

/**
 * e_dbus_address_book_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBook.top_of_page">org.gnome.evolution.dataserver.AddressBook</link>.
 *
 * Returns: (transfer full) (type EDBusAddressBookSkeleton): The skeleton object.
 *
 * Since: 3.8
 */
EDBusAddressBook *
e_dbus_address_book_skeleton_new (void)
{
  return E_DBUS_ADDRESS_BOOK (g_object_new (E_DBUS_TYPE_ADDRESS_BOOK_SKELETON, NULL));
}

