/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import org.jruby.RubyArray;
import org.jruby.exceptions.Unrescuable;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CatchThrow
extends RuntimeException
implements Unrescuable {
    public IRubyObject[] args = IRubyObject.NULL_ARRAY;
    public final IRubyObject tag;

    public CatchThrow() {
        this.tag = null;
    }

    public CatchThrow(IRubyObject tag2) {
        this.tag = tag2;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject enter(ThreadContext context, IRubyObject yielded, Block block) {
        CatchThrow catchThrow = new CatchThrow(yielded);
        context.pushCatch(catchThrow);
        try {
            IRubyObject iRubyObject = block.yield(context, yielded);
            return iRubyObject;
        }
        catch (CatchThrow c) {
            if (c != catchThrow) {
                throw c;
            }
            IRubyObject[] args2 = catchThrow.args;
            switch (args2.length) {
                case 0: {
                    IRubyObject iRubyObject = context.nil;
                    return iRubyObject;
                }
                case 1: {
                    IRubyObject iRubyObject = args2[0];
                    return iRubyObject;
                }
            }
            RubyArray rubyArray = RubyArray.newArrayMayCopy(context.runtime, args2);
            return rubyArray;
        }
        finally {
            context.popCatch();
        }
    }
}

