/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ShardsApi {

    public static class SyncShard
    extends SolrRequest<SyncShardResponse> {
        private final String collectionName;
        private final String shardName;

        public SyncShard(String collectionName, String shardName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/shards/{shardName}/sync".replace("{collectionName}", collectionName).replace("{shardName}", shardName));
            this.collectionName = collectionName;
            this.shardName = shardName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected SyncShardResponse createResponse(SolrClient client) {
            return new SyncShardResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class SyncShardResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public SyncShardResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class ForceShardLeader
    extends SolrRequest<ForceShardLeaderResponse> {
        private final String collectionName;
        private final String shardName;

        public ForceShardLeader(String collectionName, String shardName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/shards/{shardName}/force-leader".replace("{collectionName}", collectionName).replace("{shardName}", shardName));
            this.collectionName = collectionName;
            this.shardName = shardName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected ForceShardLeaderResponse createResponse(SolrClient client) {
            return new ForceShardLeaderResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ForceShardLeaderResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public ForceShardLeaderResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

