/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uninverting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;
import org.apache.solr.uninverting.DocTermOrds;
import org.apache.solr.uninverting.FieldCache;

public class FieldCacheImpl
implements FieldCache {
    private Map<Class<?>, Cache> caches;
    final IndexReader.ClosedListener purgeCore = this::purgeByCacheKey;

    FieldCacheImpl() {
        this.init();
    }

    private synchronized void init() {
        this.caches = Map.ofEntries(Map.entry(Long.TYPE, new LongCache(this)), Map.entry(BinaryDocValues.class, new BinaryDocValuesCache(this)), Map.entry(SortedDocValues.class, new SortedDocValuesCache(this)), Map.entry(DocTermOrds.class, new DocTermOrdsCache(this)), Map.entry(DocsWithFieldCache.class, new DocsWithFieldCache(this)));
    }

    @Override
    public synchronized void purgeAllCaches() {
        this.init();
    }

    @Override
    public synchronized void purgeByCacheKey(IndexReader.CacheKey coreCacheKey) {
        for (Cache c : this.caches.values()) {
            c.purgeByCacheKey(coreCacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FieldCache.CacheEntry[] getCacheEntries() {
        ArrayList<FieldCache.CacheEntry> result = new ArrayList<FieldCache.CacheEntry>(17);
        for (Map.Entry<Class<?>, Cache> cacheEntry : this.caches.entrySet()) {
            Cache cache = cacheEntry.getValue();
            Class<?> cacheType = cacheEntry.getKey();
            Map<IndexReader.CacheKey, Map<CacheKey, Accountable>> map = cache.readerCache;
            synchronized (map) {
                for (Map.Entry<IndexReader.CacheKey, Map<CacheKey, Accountable>> readerCacheEntry : cache.readerCache.entrySet()) {
                    IndexReader.CacheKey readerKey = readerCacheEntry.getKey();
                    if (readerKey == null) continue;
                    Map<CacheKey, Accountable> innerCache = readerCacheEntry.getValue();
                    for (Map.Entry<CacheKey, Accountable> mapEntry : innerCache.entrySet()) {
                        CacheKey entry = mapEntry.getKey();
                        result.add(new FieldCache.CacheEntry(readerKey, entry.field, cacheType, entry.custom, mapEntry.getValue()));
                    }
                }
            }
        }
        return result.toArray(new FieldCache.CacheEntry[result.size()]);
    }

    private void initReader(LeafReader reader) {
        IndexReader.CacheHelper cacheHelper = reader.getCoreCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalStateException("Cannot cache on " + reader);
        }
        cacheHelper.addClosedListener(this.purgeCore);
    }

    void setDocsWithField(LeafReader reader, String field, Bits docsWithField, FieldCache.Parser parser) {
        Bits.MatchNoBits bits;
        int maxDoc = reader.maxDoc();
        if (docsWithField == null) {
            bits = new Bits.MatchNoBits(maxDoc);
        } else if (docsWithField instanceof FixedBitSet) {
            int numSet = ((FixedBitSet)docsWithField).cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                bits = new Bits.MatchAllBits(maxDoc);
            } else {
                bits = docsWithField;
            }
        } else {
            bits = docsWithField;
        }
        this.caches.get(DocsWithFieldCache.class).put(reader, new CacheKey(field, parser), new BitsEntry((Bits)bits));
    }

    @Override
    public Bits getDocsWithField(LeafReader reader, String field, FieldCache.Parser parser) throws IOException {
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
        if (fieldInfo == null) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        if (fieldInfo.getDocValuesType() == DocValuesType.NONE && !(parser instanceof FieldCache.PointParser) && fieldInfo.getIndexOptions() == IndexOptions.NONE) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        BitsEntry bitsEntry = (BitsEntry)this.caches.get(DocsWithFieldCache.class).get(reader, new CacheKey(field, parser));
        return bitsEntry.bits;
    }

    @Override
    public NumericDocValues getNumerics(LeafReader reader, String field, FieldCache.Parser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException();
        }
        NumericDocValues valuesIn = reader.getNumericDocValues(field);
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptyNumeric();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (parser instanceof FieldCache.PointParser) {
            if (info.getPointDimensionCount() == 0) {
                return DocValues.emptyNumeric();
            }
            if (info.getPointDimensionCount() != 1) {
                throw new IllegalStateException("Type mismatch: " + field + " was indexed with dimensions=" + info.getPointDimensionCount());
            }
            PointValues values = reader.getPointValues(field);
            if (values == null || values.size() == 0L) {
                return DocValues.emptyNumeric();
            }
            if (values.size() != (long)values.getDocCount()) {
                throw new IllegalStateException("Type mismatch: " + field + " was indexed with multiple values, numValues=" + values.size() + ",numDocs=" + values.getDocCount());
            }
        } else if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptyNumeric();
        }
        return ((LongsFromArray)this.caches.get(Long.TYPE).get(reader, new CacheKey(field, parser))).iterator();
    }

    @Override
    public SortedDocValues getTermsIndex(LeafReader reader, String field) throws IOException {
        return this.getTermsIndex(reader, field, 0.5f);
    }

    @Override
    public SortedDocValues getTermsIndex(LeafReader reader, String field, float acceptableOverheadRatio) throws IOException {
        SortedDocValues valuesIn = reader.getSortedDocValues(field);
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptySorted();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptySorted();
        }
        SortedDocValuesImpl impl = (SortedDocValuesImpl)this.caches.get(SortedDocValues.class).get(reader, new CacheKey(field, Float.valueOf(acceptableOverheadRatio)));
        return impl.iterator();
    }

    @Override
    public BinaryDocValues getTerms(LeafReader reader, String field) throws IOException {
        return this.getTerms(reader, field, 0.5f);
    }

    @Override
    public BinaryDocValues getTerms(LeafReader reader, String field, float acceptableOverheadRatio) throws IOException {
        BinaryDocValues valuesIn = reader.getBinaryDocValues(field);
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptyBinary();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptyBinary();
        }
        BinaryDocValuesImpl impl = (BinaryDocValuesImpl)this.caches.get(BinaryDocValues.class).get(reader, new CacheKey(field, Float.valueOf(acceptableOverheadRatio)));
        return impl.iterator();
    }

    @Override
    public SortedSetDocValues getDocTermOrds(LeafReader reader, String field, BytesRef prefix) throws IOException {
        assert (prefix == null || INT32_TERM_PREFIX.equals((Object)prefix) || INT64_TERM_PREFIX.equals((Object)prefix));
        SortedSetDocValues dv = reader.getSortedSetDocValues(field);
        if (dv != null) {
            return dv;
        }
        SortedDocValues sdv = reader.getSortedDocValues(field);
        if (sdv != null) {
            return DocValues.singleton((SortedDocValues)sdv);
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptySortedSet();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptySortedSet();
        }
        Terms terms = reader.terms(field);
        if (terms == null) {
            return DocValues.emptySortedSet();
        }
        long numPostings = terms.getSumDocFreq();
        if (numPostings != -1L && numPostings == (long)terms.getDocCount()) {
            return DocValues.singleton((SortedDocValues)this.getTermsIndex(reader, field));
        }
        DocTermOrds dto = (DocTermOrds)this.caches.get(DocTermOrds.class).get(reader, new CacheKey(field, prefix));
        return dto.iterator(reader);
    }

    static final class DocTermOrdsCache
    extends Cache {
        DocTermOrdsCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader, CacheKey key) throws IOException {
            BytesRef prefix = (BytesRef)key.custom;
            return new DocTermOrds(reader, null, key.field, prefix);
        }
    }

    static final class BinaryDocValuesCache
    extends Cache {
        BinaryDocValuesCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader, CacheKey key) throws IOException {
            int startBPV;
            int maxDoc = reader.maxDoc();
            Terms terms = reader.terms(key.field);
            float acceptableOverheadRatio = ((Float)key.custom).floatValue();
            int termCountHardLimit = maxDoc;
            PagedBytes bytes = new PagedBytes(15);
            if (terms != null) {
                long numUniqueTerms = terms.size();
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)termCountHardLimit) {
                        numUniqueTerms = termCountHardLimit;
                    }
                    startBPV = PackedInts.bitsRequired((long)(numUniqueTerms * 4L));
                } else {
                    startBPV = 1;
                }
            } else {
                startBPV = 1;
            }
            GrowableWriter docToOffset = new GrowableWriter(startBPV, maxDoc, acceptableOverheadRatio);
            bytes.copyUsingLengthPrefix(new BytesRef());
            if (terms != null) {
                BytesRef term;
                int termCount = 0;
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while (termCount++ != termCountHardLimit && (term = termsEnum.next()) != null) {
                    int docID;
                    long pointer = bytes.copyUsingLengthPrefix(term);
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToOffset.set(docID, pointer);
                    }
                }
            }
            PackedInts.Mutable offsetReader = docToOffset.getMutable();
            Bits docsWithField = new Bits((PackedInts.Reader)offsetReader, maxDoc){
                final /* synthetic */ PackedInts.Reader val$offsetReader;
                final /* synthetic */ int val$maxDoc;
                {
                    this.val$offsetReader = reader;
                    this.val$maxDoc = n;
                }

                public boolean get(int index) {
                    return this.val$offsetReader.get(index) != 0L;
                }

                public int length() {
                    return this.val$maxDoc;
                }
            };
            this.wrapper.setDocsWithField(reader, key.field, docsWithField, null);
            return new BinaryDocValuesImpl(bytes.freeze(true), (PackedInts.Reader)offsetReader, docsWithField);
        }
    }

    public static class BinaryDocValuesImpl
    implements Accountable {
        private final PagedBytes.Reader bytes;
        private final PackedInts.Reader docToOffset;
        private final Bits docsWithField;

        public BinaryDocValuesImpl(PagedBytes.Reader bytes, PackedInts.Reader docToOffset, Bits docsWithField) {
            this.bytes = bytes;
            this.docToOffset = docToOffset;
            this.docsWithField = docsWithField;
        }

        public BinaryDocValues iterator() {
            return new BinaryDocValues(){
                final BytesRef term = new BytesRef();
                int docID = -1;

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() {
                    do {
                        ++this.docID;
                        if (this.docID < docToOffset.size()) continue;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    } while (!docsWithField.get(this.docID));
                    return this.docID;
                }

                public int advance(int target) {
                    if (target < docToOffset.size()) {
                        this.docID = target;
                        if (docsWithField.get(this.docID)) {
                            return this.docID;
                        }
                        return this.nextDoc();
                    }
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    return docsWithField.get(this.docID);
                }

                public long cost() {
                    return 0L;
                }

                public BytesRef binaryValue() {
                    long pointer = docToOffset.get(this.docID);
                    if (pointer == 0L) {
                        this.term.length = 0;
                    } else {
                        bytes.fill(this.term, pointer);
                    }
                    return this.term;
                }
            };
        }

        public long ramBytesUsed() {
            return this.bytes.ramBytesUsed() + this.docToOffset.ramBytesUsed() + 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>(2);
            resources.add(Accountables.namedAccountable((String)"term bytes", (Accountable)this.bytes));
            resources.add(Accountables.namedAccountable((String)"addresses", (Accountable)this.docToOffset));
            return Collections.unmodifiableList(resources);
        }
    }

    static class SortedDocValuesCache
    extends Cache {
        SortedDocValuesCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader, CacheKey key) throws IOException {
            int startTermsBPV;
            int maxDoc = reader.maxDoc();
            Terms terms = reader.terms(key.field);
            float acceptableOverheadRatio = ((Float)key.custom).floatValue();
            PagedBytes bytes = new PagedBytes(15);
            if (terms != null) {
                long numUniqueTerms = terms.size();
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)maxDoc) {
                        throw new IllegalStateException("Type mismatch: " + key.field + " was indexed with multiple values per document, use SORTED_SET instead");
                    }
                    startTermsBPV = PackedInts.bitsRequired((long)numUniqueTerms);
                } else {
                    startTermsBPV = 1;
                }
            } else {
                startTermsBPV = 1;
            }
            PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder((float)0.0f);
            GrowableWriter docToTermOrd = new GrowableWriter(startTermsBPV, maxDoc, acceptableOverheadRatio);
            int termOrd = 0;
            if (terms != null) {
                BytesRef term;
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    if (termOrd >= maxDoc) {
                        throw new IllegalStateException("Type mismatch: " + key.field + " was indexed with multiple values per document, use SORTED_SET instead");
                    }
                    termOrdToBytesOffset.add(bytes.copyUsingLengthPrefix(term));
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToTermOrd.set(docID, (long)(1 + termOrd));
                    }
                    ++termOrd;
                }
            }
            return new SortedDocValuesImpl(bytes.freeze(true), termOrdToBytesOffset.build(), (PackedInts.Reader)docToTermOrd.getMutable(), termOrd);
        }
    }

    public static class SortedDocValuesImpl
    implements Accountable {
        private final PagedBytes.Reader bytes;
        private final PackedLongValues termOrdToBytesOffset;
        private final PackedInts.Reader docToTermOrd;
        private final int numOrd;

        public SortedDocValuesImpl(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset, PackedInts.Reader docToTermOrd, int numOrd) {
            this.bytes = bytes;
            this.docToTermOrd = docToTermOrd;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
            this.numOrd = numOrd;
        }

        public SortedDocValues iterator() {
            return new Iter();
        }

        public long ramBytesUsed() {
            return this.bytes.ramBytesUsed() + this.termOrdToBytesOffset.ramBytesUsed() + this.docToTermOrd.ramBytesUsed() + 3L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4L;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>(3);
            resources.add(Accountables.namedAccountable((String)"term bytes", (Accountable)this.bytes));
            resources.add(Accountables.namedAccountable((String)"ord -> term", (Accountable)this.termOrdToBytesOffset));
            resources.add(Accountables.namedAccountable((String)"doc -> ord", (Accountable)this.docToTermOrd));
            return Collections.unmodifiableList(resources);
        }

        public class Iter
        extends SortedDocValues {
            private int docID = -1;
            private final BytesRef term = new BytesRef();

            public int getOrd(int docID) {
                return (int)SortedDocValuesImpl.this.docToTermOrd.get(docID) - 1;
            }

            public int docID() {
                return this.docID;
            }

            public int nextDoc() {
                do {
                    ++this.docID;
                    if (this.docID < SortedDocValuesImpl.this.docToTermOrd.size()) continue;
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                } while (SortedDocValuesImpl.this.docToTermOrd.get(this.docID) == 0L);
                return this.docID;
            }

            public int advance(int target) {
                if (target < SortedDocValuesImpl.this.docToTermOrd.size()) {
                    this.docID = target;
                    if (SortedDocValuesImpl.this.docToTermOrd.get(this.docID) != 0L) {
                        return this.docID;
                    }
                    return this.nextDoc();
                }
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }

            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                return SortedDocValuesImpl.this.docToTermOrd.get(this.docID) != 0L;
            }

            public long cost() {
                return 0L;
            }

            public int ordValue() {
                return (int)SortedDocValuesImpl.this.docToTermOrd.get(this.docID) - 1;
            }

            public int getValueCount() {
                return SortedDocValuesImpl.this.numOrd;
            }

            public BytesRef lookupOrd(int ord) {
                if (ord < 0) {
                    throw new IllegalArgumentException("ord must be >=0 (got ord=" + ord + ")");
                }
                SortedDocValuesImpl.this.bytes.fill(this.term, SortedDocValuesImpl.this.termOrdToBytesOffset.get((long)ord));
                return this.term;
            }
        }
    }

    static final class LongCache
    extends Cache {
        LongCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(final LeafReader reader, CacheKey key) throws IOException {
            Bits.MatchNoBits docsWithField;
            final FieldCache.Parser parser = (FieldCache.Parser)key.custom;
            final HoldsOneThing valuesRef = new HoldsOneThing();
            Uninvert u = new Uninvert(parser instanceof FieldCache.PointParser){
                private long minValue;
                private long currentValue;
                private GrowableWriter values;

                @Override
                public void visitTerm(BytesRef term) {
                    this.currentValue = parser.parseValue(term);
                    if (this.values == null) {
                        int startBitsPerValue;
                        if (this.currentValue < 0L) {
                            this.minValue = this.currentValue;
                            startBitsPerValue = this.minValue == Long.MIN_VALUE ? 64 : PackedInts.bitsRequired((long)(-this.minValue));
                        } else {
                            this.minValue = 0L;
                            startBitsPerValue = PackedInts.bitsRequired((long)this.currentValue);
                        }
                        this.values = new GrowableWriter(startBitsPerValue, reader.maxDoc(), 0.5f);
                        if (this.minValue != 0L) {
                            this.values.fill(0, this.values.size(), -this.minValue);
                        }
                        valuesRef.set(new GrowableWriterAndMinValue(this.values, this.minValue));
                    }
                }

                @Override
                public void visitDoc(int docID) {
                    this.values.set(docID, this.currentValue - this.minValue);
                }

                @Override
                protected TermsEnum termsEnum(Terms terms) throws IOException {
                    return parser.termsEnum(terms);
                }
            };
            u.uninvert(reader, key.field);
            this.wrapper.setDocsWithField(reader, key.field, u.docsWithField, parser);
            GrowableWriterAndMinValue values = (GrowableWriterAndMinValue)valuesRef.get();
            Object object = docsWithField = u.docsWithField == null ? new Bits.MatchNoBits(reader.maxDoc()) : u.docsWithField;
            if (values == null) {
                return new LongsFromArray(key.field, (PackedInts.Reader)new PackedInts.NullReader(reader.maxDoc()), 0L, (Bits)docsWithField);
            }
            return new LongsFromArray(key.field, (PackedInts.Reader)values.writer.getMutable(), values.minValue, (Bits)docsWithField);
        }
    }

    public static class LongsFromArray
    implements Accountable {
        private final PackedInts.Reader values;
        private final long minValue;
        private final Bits docsWithField;
        private final String field;

        public LongsFromArray(String field, PackedInts.Reader values, long minValue, Bits docsWithField) {
            this.field = field;
            this.values = values;
            this.minValue = minValue;
            this.docsWithField = docsWithField;
        }

        public long ramBytesUsed() {
            return this.values.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8L;
        }

        public NumericDocValues iterator() {
            return new NumericDocValues(){
                int docID = -1;

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() {
                    do {
                        ++this.docID;
                        if (this.docID < values.size()) continue;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    } while (!docsWithField.get(this.docID));
                    return this.docID;
                }

                public int advance(int target) {
                    if (target < values.size()) {
                        this.docID = target;
                        if (docsWithField.get(this.docID)) {
                            return this.docID;
                        }
                        return this.nextDoc();
                    }
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    return docsWithField.get(this.docID);
                }

                public long cost() {
                    return values.size();
                }

                public long longValue() {
                    return minValue + values.get(this.docID);
                }
            };
        }
    }

    static final class DocsWithFieldCache
    extends Cache {
        DocsWithFieldCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected BitsEntry createValue(LeafReader reader, CacheKey key) throws IOException {
            String field = key.field;
            FieldCache.Parser parser = (FieldCache.Parser)key.custom;
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                return this.createValueDocValues(reader, field);
            }
            if (parser instanceof FieldCache.PointParser) {
                return this.createValuePoints(reader, field);
            }
            return this.createValuePostings(reader, field);
        }

        private BitsEntry createValueDocValues(LeafReader reader, String field) throws IOException {
            int docID;
            NumericDocValues iterator;
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            DocValuesType dvType = fieldInfo.getDocValuesType();
            switch (dvType) {
                case NUMERIC: {
                    iterator = reader.getNumericDocValues(field);
                    break;
                }
                case BINARY: {
                    iterator = reader.getBinaryDocValues(field);
                    break;
                }
                case SORTED: {
                    iterator = reader.getSortedDocValues(field);
                    break;
                }
                case SORTED_NUMERIC: {
                    iterator = reader.getSortedNumericDocValues(field);
                    break;
                }
                case SORTED_SET: {
                    iterator = reader.getSortedSetDocValues(field);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            FixedBitSet bits = new FixedBitSet(reader.maxDoc());
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                bits.set(docID);
            }
            return new BitsEntry((Bits)bits);
        }

        private BitsEntry createValuePoints(LeafReader reader, String field) throws IOException {
            int maxDoc = reader.maxDoc();
            PointValues values = reader.getPointValues(field);
            assert (values != null);
            assert (values.size() > 0L);
            int docCount = values.getDocCount();
            assert (docCount <= maxDoc);
            if (docCount == maxDoc) {
                return new BitsEntry((Bits)new Bits.MatchAllBits(maxDoc));
            }
            Uninvert u = new Uninvert(true){

                @Override
                protected TermsEnum termsEnum(Terms terms) throws IOException {
                    throw new AssertionError();
                }

                @Override
                protected void visitTerm(BytesRef term) {
                }

                @Override
                protected void visitDoc(int docID) {
                }
            };
            u.uninvert(reader, field);
            return new BitsEntry(u.docsWithField);
        }

        private BitsEntry createValuePostings(LeafReader reader, String field) throws IOException {
            int maxDoc = reader.maxDoc();
            FixedBitSet res = null;
            Terms terms = reader.terms(field);
            if (terms != null) {
                BytesRef term;
                int termsDocCount = terms.getDocCount();
                assert (termsDocCount <= maxDoc);
                if (termsDocCount == maxDoc) {
                    return new BitsEntry((Bits)new Bits.MatchAllBits(maxDoc));
                }
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    if (res == null) {
                        res = new FixedBitSet(maxDoc);
                    }
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        res.set(docID);
                    }
                }
            }
            if (res == null) {
                return new BitsEntry((Bits)new Bits.MatchNoBits(maxDoc));
            }
            int numSet = res.cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                return new BitsEntry((Bits)new Bits.MatchAllBits(maxDoc));
            }
            return new BitsEntry((Bits)res);
        }
    }

    static class BitsEntry
    implements Accountable {
        final Bits bits;

        BitsEntry(Bits bits) {
            this.bits = bits;
        }

        public long ramBytesUsed() {
            long base = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            if (this.bits instanceof Bits.MatchAllBits || this.bits instanceof Bits.MatchNoBits) {
                return base;
            }
            return base + (long)(this.bits.length() >>> 3);
        }
    }

    private static class GrowableWriterAndMinValue {
        public GrowableWriter writer;
        public long minValue;

        GrowableWriterAndMinValue(GrowableWriter array, long minValue) {
            this.writer = array;
            this.minValue = minValue;
        }
    }

    private static class HoldsOneThing<T> {
        private T it;

        private HoldsOneThing() {
        }

        public void set(T it) {
            this.it = it;
        }

        public T get() {
            return this.it;
        }
    }

    private static abstract class Uninvert {
        public Bits docsWithField;
        final boolean points;

        Uninvert(boolean points) {
            this.points = points;
        }

        final void uninvert(LeafReader reader, String field) throws IOException {
            if (this.points) {
                this.uninvertPoints(reader, field);
            } else {
                this.uninvertPostings(reader, field);
            }
        }

        final void uninvertPoints(LeafReader reader, String field) throws IOException {
            boolean setDocsWithField;
            final int maxDoc = reader.maxDoc();
            PointValues values = reader.getPointValues(field);
            assert (values != null);
            assert (values.size() > 0L);
            int docCount = values.getDocCount();
            assert (docCount <= maxDoc);
            if (docCount == maxDoc) {
                this.docsWithField = new Bits.MatchAllBits(maxDoc);
                setDocsWithField = false;
            } else {
                setDocsWithField = true;
            }
            final BytesRef scratch = new BytesRef();
            values.intersect(new PointValues.IntersectVisitor(){

                public void visit(int docID) throws IOException {
                    throw new AssertionError();
                }

                public void visit(int docID, byte[] packedValue) throws IOException {
                    scratch.bytes = packedValue;
                    scratch.length = packedValue.length;
                    this.visitTerm(scratch);
                    this.visitDoc(docID);
                    if (setDocsWithField) {
                        if (docsWithField == null) {
                            docsWithField = new FixedBitSet(maxDoc);
                        }
                        ((FixedBitSet)docsWithField).set(docID);
                    }
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
        }

        final void uninvertPostings(LeafReader reader, String field) throws IOException {
            int maxDoc = reader.maxDoc();
            Terms terms = reader.terms(field);
            if (terms != null) {
                BytesRef term;
                boolean setDocsWithField;
                int termsDocCount = terms.getDocCount();
                assert (termsDocCount <= maxDoc);
                if (termsDocCount == maxDoc) {
                    this.docsWithField = new Bits.MatchAllBits(maxDoc);
                    setDocsWithField = false;
                } else {
                    setDocsWithField = true;
                }
                TermsEnum termsEnum = this.termsEnum(terms);
                PostingsEnum docs = null;
                FixedBitSet docsWithField = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    this.visitTerm(term);
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        this.visitDoc(docID);
                        if (!setDocsWithField) continue;
                        if (docsWithField == null) {
                            docsWithField = new FixedBitSet(maxDoc);
                            this.docsWithField = docsWithField;
                        }
                        docsWithField.set(docID);
                    }
                }
            }
        }

        protected abstract TermsEnum termsEnum(Terms var1) throws IOException;

        protected abstract void visitTerm(BytesRef var1);

        protected abstract void visitDoc(int var1);
    }

    static class CacheKey {
        final String field;
        final Object custom;

        CacheKey(String field, Object custom) {
            this.field = field;
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o instanceof CacheKey) {
                CacheKey other = (CacheKey)o;
                if (other.field.equals(this.field) && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ (this.custom == null ? 0 : this.custom.hashCode());
        }
    }

    static abstract class Cache {
        final FieldCacheImpl wrapper;
        final Map<IndexReader.CacheKey, Map<CacheKey, Accountable>> readerCache = new WeakHashMap<IndexReader.CacheKey, Map<CacheKey, Accountable>>();

        Cache(FieldCacheImpl wrapper) {
            this.wrapper = wrapper;
        }

        protected abstract Accountable createValue(LeafReader var1, CacheKey var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purgeByCacheKey(IndexReader.CacheKey coreCacheKey) {
            Map<IndexReader.CacheKey, Map<CacheKey, Accountable>> map = this.readerCache;
            synchronized (map) {
                this.readerCache.remove(coreCacheKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(LeafReader reader, CacheKey key, Accountable value) {
            IndexReader.CacheHelper cacheHelper = reader.getCoreCacheHelper();
            if (cacheHelper == null) {
                throw new IllegalStateException("Cannot cache on " + reader);
            }
            IndexReader.CacheKey readerKey = cacheHelper.getKey();
            Map<IndexReader.CacheKey, Map<CacheKey, Accountable>> map = this.readerCache;
            synchronized (map) {
                Map<CacheKey, Accountable> innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<CacheKey, Accountable>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader);
                }
                if (innerCache.get(key) == null) {
                    innerCache.put(key, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(LeafReader reader, CacheKey key) throws IOException {
            Accountable value;
            Map<CacheKey, Accountable> innerCache;
            IndexReader.CacheHelper cacheHelper = reader.getCoreCacheHelper();
            if (cacheHelper == null) {
                reader.getCoreCacheHelper();
                throw new IllegalStateException("Cannot cache on " + reader);
            }
            IndexReader.CacheKey readerKey = cacheHelper.getKey();
            Accountable accountable = this.readerCache;
            synchronized (accountable) {
                innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<CacheKey, Accountable>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new FieldCache.CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof FieldCache.CreationPlaceholder) {
                accountable = value;
                synchronized (accountable) {
                    FieldCache.CreationPlaceholder progress = (FieldCache.CreationPlaceholder)value;
                    if (progress.value == null) {
                        progress.value = this.createValue(reader, key);
                        Map<IndexReader.CacheKey, Map<CacheKey, Accountable>> map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }
    }
}

