/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/cores/{core}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class SwapCoresAPI {
    private static final String V2_SWAP_CORES_CMD = "swap";
    private final CoreAdminHandler coreHandler;

    public SwapCoresAPI(CoreAdminHandler coreHandler) {
        this.coreHandler = coreHandler;
    }

    @Command(name="swap")
    public void swapCores(PayloadObj<SwapCoresPayload> obj) throws Exception {
        SwapCoresPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CoreAdminParams.CoreAdminAction.SWAP.name().toLowerCase(Locale.ROOT));
        v1Params.put("core", obj.getRequest().getPathTemplateValues().get("core"));
        v1Params.put("other", v1Params.remove("with"));
        this.coreHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }

    public static class SwapCoresPayload
    implements ReflectMapWriter {
        @JsonProperty(required=true)
        public String with;
        @JsonProperty
        public String async;
    }
}

