/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.Map;
import javax.inject.Inject;
import org.apache.solr.client.api.endpoint.DeleteReplicaPropertyApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteReplicaProperty
extends AdminAPIBase
implements DeleteReplicaPropertyApi {
    @Inject
    public DeleteReplicaProperty(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse deleteReplicaProperty(String collName, String shardName, String replicaName, String propertyName) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteReplicaProperty.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteReplicaProperty.createRemoteMessage(collName, shardName, replicaName, propertyName);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.DELETEREPLICAPROP, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        return response;
    }

    public static SolrJerseyResponse invokeUsingV1Inputs(DeleteReplicaProperty apiInstance, SolrParams solrParams) throws Exception {
        RequiredSolrParams requiredParams = solrParams.required();
        String propNameToDelete = requiredParams.get("property");
        String trimmedPropNameToDelete = propNameToDelete.startsWith("property.") ? propNameToDelete.substring("property.".length()) : propNameToDelete;
        return apiInstance.deleteReplicaProperty(requiredParams.get("collection"), requiredParams.get("shard"), requiredParams.get("replica"), trimmedPropNameToDelete);
    }

    public static ZkNodeProps createRemoteMessage(String collName, String shardName, String replicaName, String propName) {
        Map<String, String> messageProperties = Map.of("operation", CollectionParams.CollectionAction.DELETEREPLICAPROP.toLower(), "collection", collName, "shard", shardName, "replica", replicaName, "property", propName);
        return new ZkNodeProps(messageProperties);
    }
}

